<?php

if ( ! class_exists( 'TC_Mailchimp_API' ) ) {

    class TC_Mailchimp_API {

        var $settings = '';
        var $mc_settings = '';
        var $newsletter_enabled = '';
        var $confirmation_enabled = '';
        var $api_key = '';
        var $server_prefix = '';
        var $list_id = '';
        var $double_optin = '';
        var $welcome_email = '';
        var $emails_to_collect = '';
        var $mailchimp = '';

        function __construct() {
            self::init();
        }

        function init() {

            $this->settings = get_option( 'tickera_general_setting' );
            $this->mc_settings = get_option( 'tc_mailchimp_settings' );
            $this->newsletter_enabled = ( isset( $this->mc_settings['enable_mailchimp_newsletter'] ) && 'yes' == $this->mc_settings['enable_mailchimp_newsletter'] ) ? true : false;
            $this->confirmation_enabled = isset( $this->mc_settings['enable_confirmation'] ) ? $this->mc_settings['enable_confirmation'] : false;
            $this->api_key = isset( $this->mc_settings['api_key'] ) ? $this->mc_settings['api_key'] : '';
            $this->server_prefix = isset( $this->mc_settings['server_prefix'] ) ? $this->mc_settings['server_prefix'] : '';
            $this->list_id = isset( $this->mc_settings['list_id'] ) ? $this->mc_settings['list_id'] : '';
            $this->double_optin = isset( $this->mc_settings['double_optin'] ) ? $this->mc_settings['double_optin'] : false;
            $this->welcome_email = isset( $this->mc_settings['send_welcome'] ) ? $this->mc_settings['send_welcome'] : false;
            $this->emails_to_collect = isset( $this->mc_settings['tc_emails_to_collect'] ) ? $this->mc_settings['tc_emails_to_collect'] : false;

            if ( $this->newsletter_enabled ) {
                require_once __DIR__ . '/vendor/autoload.php';
                $mailchimp = new \MailchimpMarketing\ApiClient();
                $this->mailchimp = $mailchimp->setConfig([
                    'apiKey' => $this->api_key,
                    'server' => $this->server_prefix
                ]);
            }
        }

        /**
         * Validate API Key and Server Prefix
         */
        function verify_connection() {

            $response = [];

            try {
                $response = $this->mailchimp->ping->get();
            } catch ( Exception $e ) {}

            return $response;
        }

        /**
         * Collection of Audiences
         * @return mixed
         */
        function get_lists() {

            $response = [];

            try {
                $response = $this->mailchimp->lists->getAllLists();
            } catch ( Exception $e ) {}

            return $response;
        }

        function subscribe( $list_id, $member ) {

            $response = [];
            $member_email = $member[ 'email_address' ];
            $subscriber_hash = md5( strtolower( $member_email ) );
            $member = array_merge( $member, [ 'status_if_new' => $member[ 'status' ] ] );

            try {
                $response = $this->mailchimp->lists->setListMember( $list_id, $subscriber_hash, $member );
            } catch ( Exception $e) {}

            return $response;
        }

        function update_members_tags( $list_id, $email, $tags ) {

            $response = [];
            $subscriber_hash = md5( strtolower( $email ) );

            try {
                $response = $this->mailchimp->lists->updateListMemberTags( $list_id, $subscriber_hash, [ 'tags' => $tags ] );
            } catch ( Exception $e) {}

            return $response;
        }
    }
}
