<?php
if ( isset( $_POST[ 'save_mailchimp_settings_nonce' ] ) ) {
    if ( wp_verify_nonce( $_POST[ 'save_mailchimp_settings_nonce' ], 'save_mailchimp_settings' ) ) {
        update_option( 'tc_mailchimp_settings', $_POST[ 'tc_mailchimp' ] );
    }
}

$tc_mailchimp_settings = get_option( 'tc_mailchimp_settings' );
$tc_general_settings = get_option( 'tickera_general_setting', false );

$disable_field_in_api_v3 = true; // Disable fields in api v3
$api = new TC_Mailchimp_API();
?>
<div class="wrap tc_wrap" style="opacity: 1;">
    <div id="poststuff" class="metabox-holder tc-settings">
        <form action="" method="post" name="save_mailchimp_options" enctype="multipart/form-data">
            <div id="store_settings" class="postbox">
                <h3><span><?php _e( 'Mailchimp Options', 'tc-mailchimp' ); ?></span></h3>
                <div class="inside">
                    <table class="form-table">
                        <tbody>
                        <tr>
                            <th scope="row">
                                <label for="list_id"><?php _e( 'Enable Mailchimp Newsletter', 'tc-mailchimp' ) ?></label>
                            </th>
                            <td>
                                <?php $enabled = isset( $tc_mailchimp_settings[ 'enable_mailchimp_newsletter' ] ) ? $tc_mailchimp_settings[ 'enable_mailchimp_newsletter' ] : 'no'; ?>
                                <input name="tc_mailchimp[enable_mailchimp_newsletter]" type="radio" value="yes" <?php checked( $enabled, 'yes', true ) ?>> Yes
                                <input name="tc_mailchimp[enable_mailchimp_newsletter]" type="radio" value="no" <?php checked( $enabled, 'no', true ) ?>> No
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="api_key"><?php _e( 'API Key', 'tc-mailchimp' ) ?></label></th>
                            <td>
                                <input name="tc_mailchimp[api_key]" type="text" id="api_key" value="<?php echo isset( $tc_mailchimp_settings[ 'api_key' ] ) ? $tc_mailchimp_settings[ 'api_key' ] : ''; ?>" class="regular-text">
                                <p class="description"><?php echo sprintf( __( 'Set the MailChimp %sAPI key%s.', 'tc-mailchimp' ), '<a href="https://mailchimp.com/help/about-api-keys/">', '</a>' ); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="server_prefix"><?php _e( 'Server Prefix', 'tc-mailchimp' ) ?></label></th>
                            <td>
                                <input name="tc_mailchimp[server_prefix]" type="text" id="server_prefix" value="<?php echo isset( $tc_mailchimp_settings[ 'server_prefix' ] ) ? $tc_mailchimp_settings[ 'server_prefix' ] : ''; ?>" class="regular-text">
                                <p class="description"><?php _e( 'In a mailchimp account, the us20 from the https://us20.admin.mailchimp.com/ url is the server prefix.', 'tc-mailchimp' ); ?></p>
                            </td>
                        </tr>
                        <?php if ( $api->newsletter_enabled ) :
                            $status = $api->verify_connection();
                            $status = isset( $status->health_status )
                                ? '<span class="tc-success">' . $status->health_status . '</span>'
                                : '<span class="tc-error">' . __( 'Disconnected', 'tc-mailchimp' ) . '</span>';
                            ?>
                            <tr>
                                <th scope="row"></th>
                                <td>
                                    <p><strong><?php echo __( 'Status: ', 'tc-mailchimp' ); ?></strong><?php echo $status ?></p>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"><label for="list_id"><?php _e( 'List ID', 'tc-mailchimp' ) ?></label></th>
                                <td>
                                    <?php
                                        $lists = $api->get_lists();
                                        $lists = ( isset( $lists->lists ) ) ? $lists->lists : [];
                                        $selected_list = isset( $tc_mailchimp_settings[ 'list_id' ] ) ? $tc_mailchimp_settings[ 'list_id' ] : '';
                                    ?>
                                    <select id="list_id" name="tc_mailchimp[list_id]" class="regular-text">
                                        <option value="" <?php selected( $selected_list, '', true ); ?>><?php esc_html_e( 'Select an audience', 'tc-mailchimp' ); ?></option>
                                        <?php foreach ( $lists as $list ) :
                                            if ( isset( $list->id ) ) : ?>
                                            <option value="<?php echo esc_attr( $list->id ); ?>" <?php selected( $selected_list, esc_attr( $list->id ), true ); ?>><?php echo esc_html( $list->name ); ?></option>
                                        <?php endif;
                                        endforeach; ?>
                                    </select>
                                    <div class="tc-show-message"></div>
                                    <p class="description"><?php _e( 'Set the Mailchimp list ID', 'tc-mailchimp' ); ?></p>
                                </td>
                            </tr>
                        <?php endif; ?>
                        <?php $tc_emails_to_collect = isset( $tc_mailchimp_settings[ 'tc_emails_to_collect' ] ) ? $tc_mailchimp_settings[ 'tc_emails_to_collect' ] : 'both_emails'; ?>
                        <tr>
                            <th scope="row">
                                <label for="show_owner_fields"><?php _e( 'E-Mails To Collect:', 'tc-mailchimp' ); ?></label>
                            </th>
                            <td>
                                <label>
                                    <input type="radio" class="tc_emails_to_collect" name="tc_mailchimp[tc_emails_to_collect]" value="buyer_emails" <?php if ( $tc_emails_to_collect == 'buyer_emails' ) { ?> checked="checked" <?php } ?>>Buyer E-Mails
                                </label>
                                <br/>
                                <label>
                                    <input type="radio" class="tc_emails_to_collect" name="tc_mailchimp[tc_emails_to_collect]" value="owner_emails" <?php if ( $tc_emails_to_collect == 'owner_emails' ){ ?>checked="checked" <?php } ?>>Ticket Attendee E-Mails
                                </label>
                                <br/>
                                <label>
                                    <input type="radio" class="tc_emails_to_collect" name="tc_mailchimp[tc_emails_to_collect]" value="both_emails" <?php if ( $tc_emails_to_collect == 'both_emails' ){ ?>checked="checked" <?php } ?>>Ticket Attendee and Buyer E-mails.
                                </label>
                                <br/>
                                <span class="description"><?php _e( 'Attendee e-mails will not be subscribed if attendee fields and e-mail are not enabled in Tickera settings.', 'tc-mailchimp' ); ?> </span>
                            </td>
                        </tr>
                        <?php if ( ! $disable_field_in_api_v3 && class_exists( 'TC_WooCommerce_Bridge' ) ) { ?>
                            <tr>
                                <th scope="row">
                                    <label for="users_buying_tickets"><?php _e( 'Subscribe ticket buying customers only', 'tc-mailchimp' ) ?></label>
                                </th>
                                <td>
                                    <input name="tc_mailchimp[users_buying_tickets]" type="checkbox" id="users_buying_tickets" value="1" <?php if ( isset( $tc_mailchimp_settings[ 'users_buying_tickets' ] ) ) { echo "checked"; } ?>>
                                    <p class="description"><?php _e( 'If checked only the customers who bought tickets will be subscribed.', 'tc-mailchimp' ); ?></p>
                                </td>
                            </tr>
                        <?php } ?>
                        <?php if ( ! $disable_field_in_api_v3 ) : ?>
                        <tr>
                            <th scope="row">
                                <label for="send_welcome"><?php _e( 'Send Welcome E-mail', 'tc-mailchimp' ) ?></label>
                            </th>
                            <td>
                                <input name="tc_mailchimp[send_welcome]" type="checkbox" id="send_welcome" value="1" <?php if ( isset( $tc_mailchimp_settings[ 'send_welcome' ] ) ) { echo "checked"; } ?>>
                                <p class="description"><?php _e( 'Check to enable Mailchimp to send welcome e-mail (only if you have paid subscription at Mailchimp).', 'tc-mailchimp' ); ?></p>
                            </td>
                        </tr>
                        <?php endif; ?>
                        <tr>
                            <th scope="row">
                                <label for="double_optin"><?php _e( 'Enable Double Opt-In', 'tc-mailchimp' ) ?></label>
                            </th>
                            <td>
                                <input name="tc_mailchimp[double_optin]" type="checkbox" id="double_optin" value="1" <?php if ( isset( $tc_mailchimp_settings[ 'double_optin' ] ) ) { echo "checked"; } ?>>
                                <p class="description"><?php _e( 'If enabled, customers will receive mail prompting them to confirm their subscription.', 'tc-mailchimp' ); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="double_optin"><?php _e( 'Enable Confirmation Checkbox', 'tc-mailchimp' ) ?></label>
                            </th>
                            <td>
                                <input name="tc_mailchimp[enable_confirmation]" type="checkbox" id="enable_confirmation" class="enable_confirmation" value="1" <?php if ( isset( $tc_mailchimp_settings[ 'enable_confirmation' ] ) ) { echo "checked"; } ?>>
                                <p class="description"><?php _e( 'If enabled, customers will see checkbox to confirm subscription, if not customers will be automatically subscribed.', 'tc-mailchimp' ); ?></p>
                            </td>
                        </tr>
                        <tr class="tc_conditional" data-condition-field_name="enable_confirmation" data-condition-field_type="checkbox" data-condition-value="1" data-condition-action="show">
                            <th scope="row">
                                <label for="confirmation_label"><?php _e( 'Label', 'tc-mailchimp' ) ?></label>
                            </th>
                            <td>
                                <input name="tc_mailchimp[confirmation_label]" type="text" id="confirmation_label" class="regular-text" value="<?php echo esc_attr( ( isset( $tc_mailchimp_settings[ 'confirmation_label' ] ) ? $tc_mailchimp_settings[ 'confirmation_label' ] : __('Sign-up to our newsletter.', 'tc-mailchimp') ) ); ?>">
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="tag"><?php _e( 'Subscriber\'s Tag', 'tc-mailchimp' ) ?></label>
                            </th>
                            <td>
                                <?php
                                    $options = apply_filters( 'tc_mc_subscriber_tag_options', [
                                        'event' => __( 'Event Name (Default)', 'tc-mailchimp' ),
                                        'ticket_type' => __( 'Ticket Type', 'tc-mailchimp' )
                                    ] );

                                    $selected_tag = isset( $tc_mailchimp_settings[ 'tag' ] ) ? $tc_mailchimp_settings[ 'tag' ] : 'event';
                                ?>
                                <select name="tc_mailchimp[tag]" class="regular-text">
                                    <?php foreach( $options as $value => $label ) : ?>
                                        <option value="<?php echo esc_attr( $value ) ?>" <?php selected( $value, $selected_tag, true ); ?>><?php echo esc_html( $label ); ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <p class="description"><?php _e( 'On successful subscription, tag the subscriber with the selected tag type.', 'tc-mailchimp' ); ?></p>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div><!-- inside -->
            </div><!-- store-settings -->
            <?php wp_nonce_field( 'save_mailchimp_settings', 'save_mailchimp_settings_nonce' ); ?>
            <?php submit_button( '', 'primary', 'save_mailchimp_options' ); ?>
        </form>
    </div><!-- poststuff -->
</div><!-- wrap -->
