<?php

namespace Tickera\Ticket\Element;

if ( class_exists( '\Tickera\TC_Ticket_Template_Elements' ) ) {

    class tc_woo_shipping_info_element extends \Tickera\TC_Ticket_Template_Elements {

        var $element_name = 'tc_woo_shipping_info_element';
        var $element_title = 'WooCommerce Shipping Info';
        var $font_awesome_icon = '<i class="fa fa-paper-plane"></i>';

        function on_creation() {
            $this->element_title = apply_filters( 'tc_woo_shipping_info_element', __( 'WooCommerce Shipping Info', 'woocommerce-tickera-bridge' ) );
        }

        function ticket_content( $ticket_instance_id = false, $ticket_type_id = false ) {

            $ticket_instance = new \Tickera\TC_Ticket_Instance( (int)$ticket_instance_id );
            $order_id = ( isset( $ticket_instance->details->post_parent ) ) ? (int)$ticket_instance->details->post_parent : '';

            $order = new \WC_Order( $order_id );
            $shipping_first_name = $order->get_shipping_first_name();
            $shipping_last_name = $order->get_shipping_last_name();
            $shipping_company = $order->get_shipping_company();
            $shipping_address_1 = $order->get_shipping_address_1();
            $shipping_address_2 = $order->get_shipping_address_2();
            $shipping_city = $order->get_shipping_city();
            $shipping_state = $order->get_shipping_state();
            $shipping_postcode = $order->get_shipping_postcode();
            $shipping_country = $order->get_shipping_country();

            $shipping_info = '';
            $shipping_info .= isset( $shipping_first_name ) ? $shipping_first_name . ' ' : '';
            $shipping_info .= isset( $shipping_last_name ) ? $shipping_last_name . '<br />' : '';
            $shipping_info .= isset( $shipping_company ) ? $shipping_company . '<br />' : '';
            $shipping_info .= isset( $shipping_address_1 ) ? $shipping_address_1 . '<br />' : '';
            $shipping_info .= isset( $shipping_address_2 ) ? $shipping_address_2 . '<br />' : '';
            $shipping_info .= isset( $shipping_city ) ? $shipping_city . '<br />' : '';
            $shipping_info .= isset( $shipping_state ) ? $shipping_state . '<br />' : '';
            $shipping_info .= isset( $shipping_postcode ) ? $shipping_postcode . '<br />' : '';
            $shipping_info .= isset( $shipping_country ) ? $shipping_country . '<br />' : '';

            return $shipping_info;
        }

    }

    \Tickera\tickera_register_template_element( 'Tickera\Ticket\Element\tc_woo_shipping_info_element', __( 'WooCommerce Shipping Info', 'woocommerce-tickera-bridge' ) );
}
