<?php

namespace Tickera\Ticket\Element;

if ( class_exists( '\Tickera\TC_Ticket_Template_Elements' ) ) {

    class tc_woo_billing_info_element extends \Tickera\TC_Ticket_Template_Elements {

        var $element_name = 'tc_woo_billing_info_element';
        var $element_title = 'WooCommerce Billing Info';
        var $font_awesome_icon = '<i class="fa fa-credit-card"></i>';

        function on_creation() {
            $this->element_title = apply_filters( 'tc_woo_billing_info_element', __( 'WooCommerce Billing Info', 'woocommerce-tickera-bridge' ) );
        }

        function ticket_content( $ticket_instance_id = false, $ticket_type_id = false ) {

            $ticket_instance = new \Tickera\TC_Ticket_Instance( (int)$ticket_instance_id );
            $order_id = isset( $ticket_instance->details->post_parent ) ? (int)$ticket_instance->details->post_parent : '';

            $order = new \WC_Order( $order_id );
            $billing_first_name = $order->get_billing_first_name();
            $billing_last_name = $order->get_billing_last_name();
            $billing_company = $order->get_billing_company();
            $billing_address_1 = $order->get_billing_address_1();
            $billing_address_2 = $order->get_billing_address_2();
            $billing_city = $order->get_billing_city();
            $billing_state = $order->get_billing_state();
            $billing_postcode = $order->get_billing_postcode();
            $billing_country = $order->get_billing_country();
            $billing_email = $order->get_billing_email();
            $billing_phone = $order->get_billing_phone();

            $billing_info = '';
            $billing_info .= isset( $billing_first_name ) ? $billing_first_name . ' ' : '';
            $billing_info .= isset( $billing_last_name ) ? $billing_last_name . '<br />' : '';
            $billing_info .= isset( $billing_company ) ? $billing_company . '<br />' : '';
            $billing_info .= isset( $billing_address_1 ) ? $billing_address_1 . '<br />' : '';
            $billing_info .= isset( $billing_address_2 ) ? $billing_address_2 . '<br />' : '';
            $billing_info .= isset( $billing_city ) ? $billing_city . '<br />' : '';
            $billing_info .= isset( $billing_state ) ? $billing_state . '<br />' : '';
            $billing_info .= isset( $billing_postcode ) ? $billing_postcode . '<br />' : '';
            $billing_info .= isset( $billing_country ) ? $billing_country . '<br />' : '';
            $billing_info .= isset( $billing_email ) ? $billing_email . '<br />' : '';
            $billing_info .= isset( $billing_phone ) ? $billing_phone . '<br />' : '';

            return $billing_info;
        }

    }

    \Tickera\tickera_register_template_element( 'Tickera\Ticket\Element\tc_woo_billing_info_element', __( 'WooCommerce Billing Info', 'woocommerce-tickera-bridge' ) );
}

