( function( $ ) {

    $( document ).ready( function() {

        /**
         * Render add to cart button.
         * Table with Event tickets - Shortcode
         * Display Type: Dropdown
         */
        $( document ).on( 'change', '.tc-wb-event-dropdown-wrap select.ticket-type-id', function() {

            let wrapper = $( this ).closest( '.tc-wb-event-dropdown-wrap' ),
                ticketId = $( this ).val(),
                actionsContainer = wrapper.find( '.actions' ),
                addToCartContainer = actionsContainer.find( '[id="ticket-type-' + ticketId + '"]' );

            addToCartContainer.prependTo( actionsContainer );
        });

        /**
         * Update add to cart data-quantity attribute on quantity change.
         */
        $( document ).on( 'change keyup', '.tc-wb-quantity-selector', function() {

            let wrapper = $( this ).closest( '.event_tickets' ),
                quantity = $( this ).val(),
                isTable =  ( wrapper.length ) ? true : false;

            if ( isTable ) {

                let currentRow = $( this ).closest( 'tr' ),
                    addToCartBtn = currentRow.find( '.tc-wb-add-to-cart .add_to_cart_button' ),
                    addToCartHref = addToCartBtn.attr( 'href' ).replace( /(?=&).+/g, '' );

                addToCartBtn.attr( {
                    'href': addToCartHref + '&quantity=' + quantity,
                    'data-quantity': quantity
                });

            } else {

                wrapper = $( this ).closest( 'div' ).parent();
                let addToCartBtn = wrapper.find( '.tc-wb-add-to-cart .add_to_cart_button' ),
                    addToCartHref = addToCartBtn.attr( 'href' ).replace( /(?=&).+/g, '' );

                addToCartBtn.attr( {
                    'href': addToCartHref + '&quantity=' + quantity,
                    'data-quantity': quantity
                });
            }
        });
    });

} )( jQuery );
