/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/components/fields.js":
/*!**********************************!*\
  !*** ./src/components/fields.js ***!
  \**********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CheckboxField: function() { return /* binding */ CheckboxField; },
/* harmony export */   ConfirmEmailField: function() { return /* binding */ ConfirmEmailField; },
/* harmony export */   EmailField: function() { return /* binding */ EmailField; },
/* harmony export */   HiddenField: function() { return /* binding */ HiddenField; },
/* harmony export */   LabelField: function() { return /* binding */ LabelField; },
/* harmony export */   NumberField: function() { return /* binding */ NumberField; },
/* harmony export */   RadioField: function() { return /* binding */ RadioField; },
/* harmony export */   ScriptField: function() { return /* binding */ ScriptField; },
/* harmony export */   SelectField: function() { return /* binding */ SelectField; },
/* harmony export */   TextField: function() { return /* binding */ TextField; },
/* harmony export */   TextareaField: function() { return /* binding */ TextareaField; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _fields_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./fields/text */ "./src/components/fields/text.js");
/* harmony import */ var _fields_number__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./fields/number */ "./src/components/fields/number.js");
/* harmony import */ var _fields_email__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./fields/email */ "./src/components/fields/email.js");
/* harmony import */ var _fields_confirm_email__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./fields/confirm-email */ "./src/components/fields/confirm-email.js");
/* harmony import */ var _fields_label__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./fields/label */ "./src/components/fields/label.js");
/* harmony import */ var _fields_textarea__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./fields/textarea */ "./src/components/fields/textarea.js");
/* harmony import */ var _fields_select__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./fields/select */ "./src/components/fields/select.js");
/* harmony import */ var _fields_checkbox__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./fields/checkbox */ "./src/components/fields/checkbox.js");
/* harmony import */ var _fields_radio__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./fields/radio */ "./src/components/fields/radio.js");
/* harmony import */ var _fields_hidden__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./fields/hidden */ "./src/components/fields/hidden.js");
/* harmony import */ var _fields_script__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./fields/script */ "./src/components/fields/script.js");












const TextField = prop => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_fields_text__WEBPACK_IMPORTED_MODULE_1__.TextFieldControl, {
    ...prop
  });
};
const NumberField = prop => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_fields_number__WEBPACK_IMPORTED_MODULE_2__.NumberFieldControl, {
    ...prop
  });
};
const EmailField = prop => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_fields_email__WEBPACK_IMPORTED_MODULE_3__.EmailFieldControl, {
    ...prop
  });
};
const ConfirmEmailField = prop => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_fields_confirm_email__WEBPACK_IMPORTED_MODULE_4__.ConfirmEmailFieldControl, {
    ...prop
  });
};
const LabelField = prop => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_fields_label__WEBPACK_IMPORTED_MODULE_5__.LabelFieldControl, {
    ...prop
  });
};
const TextareaField = prop => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_fields_textarea__WEBPACK_IMPORTED_MODULE_6__.TextareaFieldControl, {
    ...prop
  });
};
const SelectField = prop => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_fields_select__WEBPACK_IMPORTED_MODULE_7__.SelectFieldControl, {
    ...prop
  });
};
const CheckboxField = prop => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_fields_checkbox__WEBPACK_IMPORTED_MODULE_8__.CheckboxFieldControl, {
    ...prop
  });
};
const RadioField = prop => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_fields_radio__WEBPACK_IMPORTED_MODULE_9__.RadioFieldControl, {
    ...prop
  });
};
const ScriptField = prop => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_fields_script__WEBPACK_IMPORTED_MODULE_11__.ScriptFieldControl, {
    ...prop
  });
};
const HiddenField = prop => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_fields_hidden__WEBPACK_IMPORTED_MODULE_10__.HiddenFieldControl, {
    ...prop
  });
};


/***/ }),

/***/ "./src/components/fields/checkbox.js":
/*!*******************************************!*\
  !*** ./src/components/fields/checkbox.js ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CheckboxFieldControl: function() { return /* binding */ CheckboxFieldControl; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @woocommerce/blocks-checkout */ "@woocommerce/blocks-checkout");
/* harmony import */ var _woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_5__);






const blockNamespace = 'tickera/checkout-fields';
var selectedValues = [],
  error;
const CheckboxFieldControl = prop => {
  let field = prop.field,
    pageLoaded = prop.loaded,
    category = prop.category,
    item = prop.item,
    i = prop.i;
  prop = prop.data.prop;

  /*
   * setExtensionData will update the wc/store/checkout data store with the values supplied.
   * It can be used to pass data from the client to the server when submitting the checkout form.
   */
  const {
    setExtensionData
  } = prop.checkoutExtensionData;

  /*
   * Debounce the setExtensionData function to avoid
   * multiple calls to the API when rapidly changing options.
   */
  const debouncedSetExtensionData = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((0,lodash__WEBPACK_IMPORTED_MODULE_5__.debounce)((namespace, key, value) => {
    setExtensionData(namespace, key, value);
  }, 1000), [setExtensionData]);
  if (typeof field.field_values !== 'undefined') {
    if (typeof field.field_values === 'object') {
      var fieldValues = field.field_values;
    } else {
      var fieldValues = field.field_values.split(',');
    }
  } else {
    var fieldValues = [];
  }
  var checkboxes = [],
    contents = [];
  fieldValues.map(function (value, index) {
    let label;
    if (typeof value === 'object') {
      label = value.label;
      value = value.value;
    } else {
      value = value.trim();
      label = value;
    }
    if ('' != value) {
      let postMeta = typeof field.post_meta !== 'undefined' ? field.post_meta : true,
        key;
      if (typeof category !== 'undefined') {
        key = 'owner' == category ? item.id + '_' + i + '_' + field.field_name + '_option_' + index + (postMeta == true ? '_post_meta' : '') : 'buyer_data_' + field.field_name + '_option_' + index + (postMeta == true ? '_post_meta' : '');
      } else {
        if (fieldValues.length > 1) {
          key = field.field_name + '_option_' + index + (postMeta == true ? '_post_meta' : '');
        } else {
          key = field.field_name + (postMeta == true ? '_post_meta' : '');
        }
      }

      /**
       * Handles fields validation
       * Applies on checkbox last option
       */
      const validationKey = 'owner' == category ? item.id + '_' + i + '_' + field.field_name + '_post_meta' : 'buyer_data_' + field.field_name + '_post_meta';
      const validationErrorId = validationKey + '-validator';
      const {
        setValidationErrors,
        clearValidationError
      } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useDispatch)('wc/store/validation');
      const validationError = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_4__.useSelect)(select => {
        const store = select('wc/store/validation');
        return store.getValidationError(validationErrorId);
      });

      /**
       * Handles changes in fields value.
       * Exclude Label field.
       */
      let [fieldValue, setFieldValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)('');
      (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        // Store selected values for later comparison
        if (typeof fieldValue !== 'undefined' && fieldValue) {
          selectedValues[key] = fieldValue;
        } else {
          delete selectedValues[key];
        }
        if (field.required) {
          // Set Validation Errors. Initially hidden until page has been fully loaded
          let hideError = !pageLoaded ? true : false;
          setValidationErrors({
            [validationErrorId]: {
              message: tc_woobridge_block.please_enter_a_valid + ' ' + field.field_title.toLowerCase(),
              hidden: hideError
            }
          });

          // Clear error with the following conditions
          if (pageLoaded && Object.keys(selectedValues).length) {
            clearValidationError(validationErrorId);
          }
        }
        fieldValue = fieldValue ? value : '';

        // Update in tickera/checkout-fields extended data
        setExtensionData(blockNamespace, key, fieldValue);

        // Ensures setExtensionData is being called one at a time.
        debouncedSetExtensionData(blockNamespace, key, fieldValue);
      }, [setExtensionData, fieldValue, setValidationErrors, clearValidationError]);
      error = !validationError?.hidden ? validationError?.message : false;
      checkboxes.push((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_3__.CheckboxControl, {
        id: key,
        label: label,
        checked: fieldValue,
        onChange: setFieldValue
      }));
    }
  });
  contents.push((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: 'tc-wb-block-component tc-wb-block-components-' + field.field_name + (error ? ' has-error' : '')
  }, field.field_title ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h5", null, field.field_title) : '', (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-checkbox"
  }, checkboxes), error ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-validation-error"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, error)) : '', field.field_description ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-checkout-step__description description"
  }, field.field_description) : ''));
  return contents;
};

/***/ }),

/***/ "./src/components/fields/confirm-email.js":
/*!************************************************!*\
  !*** ./src/components/fields/confirm-email.js ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConfirmEmailFieldControl: function() { return /* binding */ ConfirmEmailFieldControl; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../functions */ "./src/components/functions.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_4__);





const blockNamespace = 'tickera/checkout-fields';
var fieldValue, confirmFieldValue;
const validateEmail = email => {
  return email.includes('@') ? true : false;
};
const ConfirmEmailFieldControl = prop => {
  let pageLoaded = prop.loaded,
    item = prop.item,
    i = prop.i;
  prop = prop.data.prop;

  /*
   * setExtensionData will update the wc/store/checkout data store with the values supplied.
   * It can be used to pass data from the client to the server when submitting the checkout form.
   */
  const {
    setExtensionData
  } = prop.checkoutExtensionData;

  /*
   * Debounce the setExtensionData function to avoid
   * multiple calls to the API when rapidly changing options.
   */
  const debouncedSetExtensionData = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((0,lodash__WEBPACK_IMPORTED_MODULE_4__.debounce)((namespace, key, value) => {
    setExtensionData(namespace, key, value);
  }, 1000), [setExtensionData]);
  const {
    setValidationErrors,
    clearValidationError
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)('wc/store/validation');

  /**
   * Email Field
   *
   * @type {string}
   */
  const emailKey = item.id + '_' + i + '_owner_email_post_meta';
  const [emailFieldValue, setEmailFieldValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)('');

  // Handles email validation
  const emailValidationErrorId = emailKey + '-validator';
  const emailValidationError = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const store = select('wc/store/validation');
    return store.getValidationError(emailValidationErrorId);
  });

  // Listen to email field
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    fieldValue = emailFieldValue;

    // Set Validation Errors. Initially hidden until page has been fully loaded
    let hideError = !pageLoaded ? true : false;
    setValidationErrors({
      [emailValidationErrorId]: {
        message: tc_woobridge_block.please_enter_a_valid + ' ' + tc_woobridge_block.email_address.toLowerCase(),
        hidden: hideError
      }
    });
    setValidationErrors({
      [confirmEmailValidationErrorId]: {
        message: tc_woobridge_block.please_enter_a_valid + ' ' + tc_woobridge_block.confirmation_email_address.toLowerCase(),
        hidden: hideError
      }
    });

    // Clear error with the following conditions
    if (pageLoaded && emailFieldValue.trim() && validateEmail(emailFieldValue)) {
      clearValidationError(emailValidationErrorId);
    }
    if (pageLoaded && fieldValue == confirmFieldValue) {
      clearValidationError(confirmEmailValidationErrorId);
    }

    // Update in tickera/checkout-fields extended data
    setExtensionData(blockNamespace, emailKey, emailFieldValue);

    // Ensures setExtensionData is being called one at a time.
    debouncedSetExtensionData(blockNamespace, emailKey, emailFieldValue);
  }, [setExtensionData, emailFieldValue, setValidationErrors, clearValidationError]);

  /**
   * Email Confirmation Field
   *
   * @type {string}
   */
  const confirmEmailKey = item.id + '_' + i + '_owner_confirm_email_post_meta';
  const [confirmEmailFieldValue, setConfirmEmailFieldValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)('');

  // Handles email confirmation validation
  const confirmEmailValidationErrorId = confirmEmailKey + '-validator';
  const confirmEmailValidationError = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const store = select('wc/store/validation');
    return store.getValidationError(confirmEmailValidationErrorId);
  });

  // Listen to email confirmation field
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    confirmFieldValue = confirmEmailFieldValue;

    // Set Validation Errors. Initially hidden until page has been fully loaded
    let hideError = !pageLoaded ? true : false;
    setValidationErrors({
      [confirmEmailValidationErrorId]: {
        message: tc_woobridge_block.please_enter_a_valid + ' ' + tc_woobridge_block.confirmation_email_address.toLowerCase(),
        hidden: hideError
      }
    });

    // Clear error with the following conditions
    if (pageLoaded && fieldValue == confirmFieldValue) {
      clearValidationError(confirmEmailValidationErrorId);
    }

    // Update in tickera/checkout-fields extended data
    setExtensionData(blockNamespace, confirmEmailKey, confirmEmailFieldValue);

    // Ensures setExtensionData is being called one at a time.
    debouncedSetExtensionData(blockNamespace, confirmEmailKey, confirmEmailFieldValue);
  }, [setExtensionData, confirmEmailFieldValue, setValidationErrors, clearValidationError]);
  let emailError = !emailValidationError?.hidden ? emailValidationError?.message : false,
    confirmEmailError = !confirmEmailValidationError?.hidden ? confirmEmailValidationError?.message : false,
    content = [];
  content.push((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: 'tc-wb-block-component tc-wb-block-component-owner_email' + (emailError ? ' has-error' : '')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-text-input is-active"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "email",
    id: "owner_email",
    onChange: e => setEmailFieldValue(e.target.value)
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: "owner_email"
  }, (0,_functions__WEBPACK_IMPORTED_MODULE_1__.stringConvention)(tc_woobridge_block.email_address)), emailError ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-validation-error"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, emailError)) : '')));
  content.push((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: 'tc-wb-block-component tc-wb-block-component-owner_confirm_email' + (confirmEmailError ? ' has-error' : '')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-text-input is-active"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "email",
    id: "owner_confirm_email",
    onChange: e => setConfirmEmailFieldValue(e.target.value)
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: "owner_confirm_email"
  }, (0,_functions__WEBPACK_IMPORTED_MODULE_1__.stringConvention)(tc_woobridge_block.confirm_email_address)), confirmEmailError ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-validation-error"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, confirmEmailError)) : '')));
  return content;
};

/***/ }),

/***/ "./src/components/fields/email.js":
/*!****************************************!*\
  !*** ./src/components/fields/email.js ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EmailFieldControl: function() { return /* binding */ EmailFieldControl; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);




const blockNamespace = 'tickera/checkout-fields';
const validateEmail = email => {
  return email.includes('@') ? true : false;
};
const EmailFieldControl = prop => {
  let field = prop.field,
    pageLoaded = prop.loaded,
    item = prop.item,
    i = prop.i;
  prop = prop.data.prop;

  /*
   * setExtensionData will update the wc/store/checkout data store with the values supplied.
   * It can be used to pass data from the client to the server when submitting the checkout form.
   */
  const {
    setExtensionData
  } = prop.checkoutExtensionData;

  /*
   * Debounce the setExtensionData function to avoid
   * multiple calls to the API when rapidly changing options.
   */
  const debouncedSetExtensionData = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)((0,lodash__WEBPACK_IMPORTED_MODULE_3__.debounce)((namespace, key, value) => {
    setExtensionData(namespace, key, value);
  }, 1000), [setExtensionData]);
  const key = item.id + '_' + i + '_' + field.field_name + '_post_meta';

  /**
   * Handles fields validation
   */
  const validationErrorId = key + '-validator';
  const {
    setValidationErrors,
    clearValidationError
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)('wc/store/validation');
  const validationError = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const store = select('wc/store/validation');
    return store.getValidationError(validationErrorId);
  });

  /**
   * Handles changes in fields value.
   * Exclude Label field.
   */
  const [fieldValue, setFieldValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('');
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (field.required) {
      // Set Validation Errors. Initially hidden until page has been fully loaded
      let hideError = !pageLoaded ? true : false;
      setValidationErrors({
        [validationErrorId]: {
          message: tc_woobridge_block.please_enter_a_valid + field.field_title.toLowerCase(),
          hidden: hideError
        }
      });

      // Clear error with the following conditions
      if (pageLoaded && fieldValue.trim() && validateEmail(fieldValue)) {
        clearValidationError(validationErrorId);
      }
    }

    // Update in tickera/checkout-fields extended data
    setExtensionData(blockNamespace, key, fieldValue);

    // Ensures setExtensionData is being called one at a time.
    debouncedSetExtensionData(blockNamespace, key, fieldValue);
  }, [setExtensionData, fieldValue, setValidationErrors, clearValidationError]);
  let error = !validationError?.hidden ? validationError?.message : false;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: 'tc-wb-block-component tc-wb-block-component-' + field.field_name + (error ? ' has-error' : '')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-text-input is-active"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "email",
    id: field.field_name,
    onChange: e => setFieldValue(e.target.value)
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: field.field_name
  }, field.field_title), error ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-validation-error"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, error)) : '', field.field_description ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-checkout-step__description description"
  }, field.field_description) : ''));
};

/***/ }),

/***/ "./src/components/fields/extras/confirm-age.js":
/*!*****************************************************!*\
  !*** ./src/components/fields/extras/confirm-age.js ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConfirmAgeFieldControl: function() { return /* binding */ ConfirmAgeFieldControl; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @woocommerce/blocks-checkout */ "@woocommerce/blocks-checkout");
/* harmony import */ var _woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_4__);





const blockNamespace = 'tickera/checkout-fields';
const ConfirmAgeFieldControl = prop => {
  let field = prop.field,
    pageLoaded = prop.loaded;
  prop = prop.data.prop;

  /*
   * setExtensionData will update the wc/store/checkout data store with the values supplied.
   * It can be used to pass data from the client to the server when submitting the checkout form.
   */
  const {
    setExtensionData
  } = prop.checkoutExtensionData;

  /*
   * Debounce the setExtensionData function to avoid
   * multiple calls to the API when rapidly changing options.
   */
  const debouncedSetExtensionData = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)((0,lodash__WEBPACK_IMPORTED_MODULE_4__.debounce)((namespace, key, value) => {
    setExtensionData(namespace, key, value);
  }, 1000), [setExtensionData]);
  var checkboxes = [],
    contents = [];
  let postMeta = typeof field.post_meta !== 'undefined' ? field.post_meta : true,
    key = field.field_name + (postMeta == true ? '_post_meta' : '');
  /**
   * Handles fields validation
   * Applies on checkbox last option
   */
  const validationKey = key;
  const validationErrorId = validationKey + '-validator';
  const {
    setValidationErrors,
    clearValidationError
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)('wc/store/validation');
  const validationError = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const store = select('wc/store/validation');
    return store.getValidationError(validationErrorId);
  });

  /**
   * Handles changes in fields value.
   * Exclude Label field.
   */
  let [fieldValue, setFieldValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('');
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    // Set Validation Errors. Initially hidden until page has been fully loaded
    let hideError = !pageLoaded ? true : false;
    setValidationErrors({
      [validationErrorId]: {
        message: field.error_message,
        hidden: hideError
      }
    });

    // Clear error with the following conditions
    if (pageLoaded && fieldValue === true) {
      clearValidationError(validationErrorId);
    }

    // Update in tickera/checkout-fields extended data
    setExtensionData(blockNamespace, key, fieldValue);

    // Ensures setExtensionData is being called one at a time.
    debouncedSetExtensionData(blockNamespace, key, fieldValue);
  }, [setExtensionData, fieldValue, setValidationErrors, clearValidationError]);
  let error = !validationError?.hidden ? validationError?.message : false;
  checkboxes.push((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_2__.CheckboxControl, {
    id: key,
    label: field.field_title,
    checked: fieldValue,
    onChange: setFieldValue
  }));
  contents.push((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: 'tc-wb-block-component tc-wb-block-components-' + field.field_name + (error ? ' has-error' : '')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-checkbox"
  }, checkboxes), error ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-validation-error"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, error)) : ''));
  return contents;
};

/***/ }),

/***/ "./src/components/fields/hidden.js":
/*!*****************************************!*\
  !*** ./src/components/fields/hidden.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HiddenFieldControl: function() { return /* binding */ HiddenFieldControl; }
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);


const blockNamespace = 'tickera/checkout-fields';
const HiddenFieldControl = prop => {
  let field = prop.field,
    category = prop.category,
    item = prop.item,
    i = prop.i;
  prop = prop.data.prop;

  /*
   * setExtensionData will update the wc/store/checkout data store with the values supplied.
   * It can be used to pass data from the client to the server when submitting the checkout form.
   */
  const {
    setExtensionData
  } = prop.checkoutExtensionData;

  /*
   * Debounce the setExtensionData function to avoid
   * multiple calls to the API when rapidly changing options.
   */
  const debouncedSetExtensionData = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useCallback)((0,lodash__WEBPACK_IMPORTED_MODULE_1__.debounce)((namespace, key, value) => {
    setExtensionData(namespace, key, value);
  }, 1000), [setExtensionData]);
  if ('error' == field.field_type) {
    var key = field.field_name;
  } else {
    var key = 'owner' == category ? item.id + '_' + i + '_' + field.field_name + '_post_meta' : 'buyer_data_' + field.field_name + '_post_meta';
  }

  /**
   * Handles changes in fields value.
   * Exclude Label field.
   */
  let defaultValue = typeof field.default_value != 'undefined' ? field.default_value[i] : '';
  const [fieldValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useState)(defaultValue);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    // Update in tickera/checkout-fields extended data
    setExtensionData(blockNamespace, key, fieldValue);

    // Ensures setExtensionData is being called one at a time.
    debouncedSetExtensionData(blockNamespace, key, fieldValue);
  }, [setExtensionData, fieldValue]);
};

/***/ }),

/***/ "./src/components/fields/label.js":
/*!****************************************!*\
  !*** ./src/components/fields/label.js ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LabelFieldControl: function() { return /* binding */ LabelFieldControl; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

const LabelFieldControl = prop => {
  let field = prop.field,
    item = prop.item,
    content;
  switch (field.field_tag) {
    case 'p':
      content = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, field.field_title);
      break;
    case 'h1':
      content = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h1", null, field.field_title);
      break;
    case 'h2':
      content = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, field.field_title);
      break;
    case 'h3':
      content = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", null, field.field_title);
      break;
    case 'h4':
      content = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h4", null, field.field_title);
      break;
    case 'h5':
      content = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h5", null, field.field_title);
      break;
    case 'h6':
      content = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h6", null, field.field_title);
      break;
    case 'blockquote':
      content = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("blockquote", null, field.field_title);
      break;
    case 'div':
      content = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, field.field_title);
      break;
    case 'pre':
      content = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("pre", null, field.field_title);
      break;
    default:
      content = (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h5", null, field.field_title);
  }
  return content;
};

/***/ }),

/***/ "./src/components/fields/number.js":
/*!*****************************************!*\
  !*** ./src/components/fields/number.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NumberFieldControl: function() { return /* binding */ NumberFieldControl; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../functions */ "./src/components/functions.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_4__);





const blockNamespace = 'tickera/checkout-fields';
const NumberFieldControl = prop => {
  let field = prop.field,
    pageLoaded = prop.loaded,
    category = prop.category,
    item = prop.item,
    i = prop.i;
  prop = prop.data.prop;

  /*
   * setExtensionData will update the wc/store/checkout data store with the values supplied.
   * It can be used to pass data from the client to the server when submitting the checkout form.
   */
  const {
    setExtensionData
  } = prop.checkoutExtensionData;

  /*
   * Debounce the setExtensionData function to avoid
   * multiple calls to the API when rapidly changing options.
   */
  const debouncedSetExtensionData = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((0,lodash__WEBPACK_IMPORTED_MODULE_4__.debounce)((namespace, key, value) => {
    setExtensionData(namespace, key, value);
  }, 1000), [setExtensionData]);
  const key = 'owner' == category ? item.id + '_' + i + '_' + field.field_name + '_post_meta' : 'buyer_data_' + field.field_name + '_post_meta';

  /**
   * Handles fields validation
   */
  const validationErrorId = key + '-validator';
  const {
    setValidationErrors,
    clearValidationError
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)('wc/store/validation');
  const validationError = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const store = select('wc/store/validation');
    return store.getValidationError(validationErrorId);
  });

  /**
   * Handles changes in fields value.
   * Exclude Label field.
   */
  const [fieldValue, setFieldValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)('');
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    // Set Validation Errors. Initially hidden until page has been fully loaded
    let hideError = !pageLoaded ? true : false;

    // Required input error handler
    if (field.required && !fieldValue.trim() || isNaN(parseInt(fieldValue)) == true) {
      setValidationErrors({
        [validationErrorId]: {
          message: tc_woobridge_block.please_enter_a_valid + ' ' + field.field_title.toLowerCase(),
          hidden: hideError
        }
      });
    } else if (parseInt(field.field_min) > 0 && parseInt(fieldValue) < parseInt(field.field_min)) {
      setValidationErrors({
        [validationErrorId]: {
          message: tc_woobridge_block.please_enter_number + ' ' + parseInt(field.field_min) + ' ' + tc_woobridge_block.and_above,
          hidden: hideError
        }
      });
    } else if (parseInt(field.field_max) > 0 && parseInt(fieldValue) > parseInt(field.field_max)) {
      setValidationErrors({
        [validationErrorId]: {
          message: tc_woobridge_block.please_enter_number + ' ' + parseInt(field.field_max) + ' ' + tc_woobridge_block.and_below,
          hidden: hideError
        }
      });
    } else if (parseInt(field.field_step) > 0 && parseInt(fieldValue) % parseInt(field.field_step) > 0) {
      setValidationErrors({
        [validationErrorId]: {
          message: tc_woobridge_block.enter_divisible_by + ' ' + parseInt(field.field_step),
          hidden: hideError
        }
      });
    } else {
      // Clear error with the following conditions
      if (pageLoaded) {
        clearValidationError(validationErrorId);
      }
    }

    // Update in tickera/checkout-fields extended data
    setExtensionData(blockNamespace, key, fieldValue);

    // Ensures setExtensionData is being called one at a time.
    debouncedSetExtensionData(blockNamespace, key, fieldValue);
  }, [setExtensionData, fieldValue, setValidationErrors, clearValidationError]);
  let error = !validationError?.hidden ? validationError?.message : false;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: 'tc-wb-block-component tc-wb-block-component-' + field.field_name + (error ? ' has-error' : '')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-text-input is-active"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "number",
    id: field.field_name,
    min: field.field_min,
    max: field.field_max,
    step: field.field_step,
    onChange: e => setFieldValue(e.target.value)
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: field.field_name
  }, field.field_placeholder ? (0,_functions__WEBPACK_IMPORTED_MODULE_1__.stringConvention)(field.field_placeholder) : (0,_functions__WEBPACK_IMPORTED_MODULE_1__.stringConvention)(field.field_title), " "), error ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-validation-error"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, error)) : '', field.field_description ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-checkout-step__description description"
  }, field.field_description) : ''));
};

/***/ }),

/***/ "./src/components/fields/radio.js":
/*!****************************************!*\
  !*** ./src/components/fields/radio.js ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RadioFieldControl: function() { return /* binding */ RadioFieldControl; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_4__);





const blockNamespace = 'tickera/checkout-fields';
const RadioFieldControl = prop => {
  let field = prop.field,
    pageLoaded = prop.loaded,
    category = prop.category,
    item = prop.item,
    i = prop.i;
  prop = prop.data.prop;

  /*
   * setExtensionData will update the wc/store/checkout data store with the values supplied.
   * It can be used to pass data from the client to the server when submitting the checkout form.
   */
  const {
    setExtensionData
  } = prop.checkoutExtensionData;

  /*
   * Debounce the setExtensionData function to avoid
   * multiple calls to the API when rapidly changing options.
   */
  const debouncedSetExtensionData = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)((0,lodash__WEBPACK_IMPORTED_MODULE_4__.debounce)((namespace, key, value) => {
    setExtensionData(namespace, key, value);
  }, 1000), [setExtensionData]);
  const key = 'owner' == category ? item.id + '_' + i + '_' + field.field_name + '_post_meta' : 'buyer_data_' + field.field_name + '_post_meta';

  /**
   * Handles fields validation
   */
  const validationErrorId = key + '-validator';
  const {
    setValidationErrors,
    clearValidationError
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)('wc/store/validation');
  const validationError = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const store = select('wc/store/validation');
    return store.getValidationError(validationErrorId);
  });

  /**
   * Handles changes in fields value.
   * Exclude Label field.
   */
  const [fieldValue, setFieldValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(field.field_default_value);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (field.required) {
      // Set Validation Errors. Initially hidden until page has been fully loaded
      let hideError = !pageLoaded ? true : false;
      setValidationErrors({
        [validationErrorId]: {
          message: tc_woobridge_block.please_enter_a_valid + ' ' + field.field_title.toLowerCase(),
          hidden: hideError
        }
      });

      // Clear error with the following conditions
      if (pageLoaded && fieldValue.trim()) {
        clearValidationError(validationErrorId);
      }
    }

    // Update in tickera/checkout-fields extended data
    setExtensionData(blockNamespace, key, fieldValue);

    // Ensures setExtensionData is being called one at a time.
    debouncedSetExtensionData(blockNamespace, key, fieldValue);
  }, [setExtensionData, fieldValue, setValidationErrors, clearValidationError]);
  let fieldValues = typeof field.field_values !== 'undefined' ? field.field_values.split(',') : [],
    error = !validationError?.hidden ? validationError?.message : false,
    options = [];
  fieldValues.forEach(function (value, index) {
    options.push({
      value: value,
      label: value
    });
  });
  let contents = [];
  contents.push((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: 'tc-wb-block-component tc-wb-block-component-' + field.field_name + (error ? ' has-error' : '')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h5", null, field.field_title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__.RadioControl, {
    className: "tc-wb-block-components-radio-control__input",
    selected: fieldValue,
    options: options,
    onChange: value => setFieldValue(value)
  }), error ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-validation-error"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, error)) : '', field.field_description ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-checkout-step__description description"
  }, field.field_description) : ''));
  return contents;
};

/***/ }),

/***/ "./src/components/fields/script.js":
/*!*****************************************!*\
  !*** ./src/components/fields/script.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ScriptFieldControl: function() { return /* binding */ ScriptFieldControl; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _extras_confirm_age__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./extras/confirm-age */ "./src/components/fields/extras/confirm-age.js");
/* harmony import */ var _checkbox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./checkbox */ "./src/components/fields/checkbox.js");



const ScriptFieldControl = prop => {
  switch (prop.field.field_type) {
    case 'script':
      if ('confirm_age' == prop.field.field_name) {
        return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_extras_confirm_age__WEBPACK_IMPORTED_MODULE_1__.ConfirmAgeFieldControl, {
          ...prop
        });
      }
      break;
    case 'checkbox':
      (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_checkbox__WEBPACK_IMPORTED_MODULE_2__.CheckboxFieldControl, {
        ...prop
      });
      break;
  }
};

/***/ }),

/***/ "./src/components/fields/select.js":
/*!*****************************************!*\
  !*** ./src/components/fields/select.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectFieldControl: function() { return /* binding */ SelectFieldControl; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);




const blockNamespace = 'tickera/checkout-fields';
const SelectFieldControl = prop => {
  let field = prop.field,
    pageLoaded = prop.loaded,
    category = prop.category,
    item = prop.item,
    i = prop.i;
  prop = prop.data.prop;

  /*
   * setExtensionData will update the wc/store/checkout data store with the values supplied.
   * It can be used to pass data from the client to the server when submitting the checkout form.
   */
  const {
    setExtensionData
  } = prop.checkoutExtensionData;

  /*
   * Debounce the setExtensionData function to avoid
   * multiple calls to the API when rapidly changing options.
   */
  const debouncedSetExtensionData = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)((0,lodash__WEBPACK_IMPORTED_MODULE_3__.debounce)((namespace, key, value) => {
    setExtensionData(namespace, key, value);
  }, 1000), [setExtensionData]);
  const key = 'owner' == category ? item.id + '_' + i + '_' + field.field_name + '_post_meta' : 'buyer_data_' + field.field_name + '_post_meta';

  /**
   * Handles fields validation
   */
  const validationErrorId = key + '-validator';
  const {
    setValidationErrors,
    clearValidationError
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)('wc/store/validation');
  const validationError = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const store = select('wc/store/validation');
    return store.getValidationError(validationErrorId);
  });

  /**
   * Handles changes in fields value.
   * Exclude Label field.
   */
  const [fieldValue, setFieldValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(field.field_default_value);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (field.required) {
      // Set Validation Errors. Initially hidden until page has been fully loaded
      let hideError = !pageLoaded ? true : false;
      setValidationErrors({
        [validationErrorId]: {
          message: tc_woobridge_block.please_enter_a_valid + ' ' + field.field_title.toLowerCase(),
          hidden: hideError
        }
      });

      // Clear error with the following conditions
      if (pageLoaded && fieldValue.trim()) {
        clearValidationError(validationErrorId);
      }
    }

    // Update in tickera/checkout-fields extended data
    setExtensionData(blockNamespace, key, fieldValue);

    // Ensures setExtensionData is being called one at a time.
    debouncedSetExtensionData(blockNamespace, key, fieldValue);
  }, [setExtensionData, fieldValue, setValidationErrors, clearValidationError]);
  let fieldValues = typeof field.field_values !== 'undefined' ? field.field_values.split(',') : [],
    error = !validationError?.hidden ? validationError?.message : false;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: 'tc-wb-block-component tc-wb-block-component-' + field.field_name + (error ? ' has-error' : '')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: 'wc-blocks-components-select tc-wb-block-combobox is-active'
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: 'wc-blocks-components-select__container'
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: field.field_name,
    className: "wc-blocks-components-select__label"
  }, field.field_placeholder ? field.field_placeholder : field.field_title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("select", {
    size: "1",
    className: "wc-blocks-components-select__select",
    id: field.field_name,
    "aria-invalid": "false",
    autoComplete: "off",
    onChange: e => setFieldValue(e.target.value)
  }, typeof field.field_default_value !== 'undefined' && '' !== field.field_default_value.trim() ? '' : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
    value: ""
  }), ";", ((field, value) => {
    let options = [];
    fieldValues.forEach(function (optionValue, index) {
      options.push((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("option", {
        value: optionValue,
        selected: value === optionValue || '' === optionValue && value === field.field_default_value
      }, optionValue));
    });
    return options;
  })(field, fieldValue)))), error ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-validation-error"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, error)) : '', field.field_description ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-checkout-step__description description"
  }, field.field_description) : '');
};

/***/ }),

/***/ "./src/components/fields/text.js":
/*!***************************************!*\
  !*** ./src/components/fields/text.js ***!
  \***************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TextFieldControl: function() { return /* binding */ TextFieldControl; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../functions */ "./src/components/functions.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_4__);





const blockNamespace = 'tickera/checkout-fields';
const TextFieldControl = prop => {
  let field = prop.field,
    pageLoaded = prop.loaded,
    category = prop.category,
    item = prop.item,
    i = prop.i;
  prop = prop.data.prop;

  /*
   * setExtensionData will update the wc/store/checkout data store with the values supplied.
   * It can be used to pass data from the client to the server when submitting the checkout form.
   */
  const {
    setExtensionData
  } = prop.checkoutExtensionData;

  /*
   * Debounce the setExtensionData function to avoid
   * multiple calls to the API when rapidly changing options.
   */
  const debouncedSetExtensionData = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useCallback)((0,lodash__WEBPACK_IMPORTED_MODULE_4__.debounce)((namespace, key, value) => {
    setExtensionData(namespace, key, value);
  }, 1000), [setExtensionData]);
  const key = 'owner' == category ? item.id + '_' + i + '_' + field.field_name + '_post_meta' : 'buyer_data_' + field.field_name + '_post_meta';

  /**
   * Handles fields validation
   */
  const validationErrorId = key + '-validator';
  const {
    setValidationErrors,
    clearValidationError
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useDispatch)('wc/store/validation');
  const validationError = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_3__.useSelect)(select => {
    const store = select('wc/store/validation');
    return store.getValidationError(validationErrorId);
  });

  /**
   * Handles changes in fields value.
   * Exclude Label field.
   */
  const [fieldValue, setFieldValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)('');
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (field.required) {
      // Set Validation Errors. Initially hidden until page has been fully loaded
      let hideError = !pageLoaded ? true : false;
      setValidationErrors({
        [validationErrorId]: {
          message: tc_woobridge_block.please_enter_a_valid + ' ' + field.field_title.toLowerCase(),
          hidden: hideError
        }
      });

      // Clear error with the following conditions
      if (pageLoaded && fieldValue.trim()) {
        clearValidationError(validationErrorId);
      }
    }

    // Update in tickera/checkout-fields extended data
    setExtensionData(blockNamespace, key, fieldValue);

    // Ensures setExtensionData is being called one at a time.
    debouncedSetExtensionData(blockNamespace, key, fieldValue);
  }, [setExtensionData, fieldValue, setValidationErrors, clearValidationError]);
  let error = !validationError?.hidden ? validationError?.message : false;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: 'tc-wb-block-component tc-wb-block-component-' + field.field_name + (error ? ' has-error' : '')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-text-input is-active"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("input", {
    type: "text",
    id: field.field_name,
    onChange: e => setFieldValue(e.target.value)
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", {
    htmlFor: field.field_name
  }, field.field_placeholder ? (0,_functions__WEBPACK_IMPORTED_MODULE_1__.stringConvention)(field.field_placeholder) : (0,_functions__WEBPACK_IMPORTED_MODULE_1__.stringConvention)(field.field_title), " "), error ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-validation-error"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, error)) : '', field.field_description ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-checkout-step__description description"
  }, field.field_description) : ''));
};

/***/ }),

/***/ "./src/components/fields/textarea.js":
/*!*******************************************!*\
  !*** ./src/components/fields/textarea.js ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TextareaFieldControl: function() { return /* binding */ TextareaFieldControl; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash */ "lodash");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);




const blockNamespace = 'tickera/checkout-fields';
const TextareaFieldControl = prop => {
  let field = prop.field,
    pageLoaded = prop.loaded,
    category = prop.category,
    item = prop.item,
    i = prop.i;
  prop = prop.data.prop;

  /*
   * setExtensionData will update the wc/store/checkout data store with the values supplied.
   * It can be used to pass data from the client to the server when submitting the checkout form.
   */
  const {
    setExtensionData
  } = prop.checkoutExtensionData;

  /*
   * Debounce the setExtensionData function to avoid
   * multiple calls to the API when rapidly changing options.
   */
  const debouncedSetExtensionData = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)((0,lodash__WEBPACK_IMPORTED_MODULE_3__.debounce)((namespace, key, value) => {
    setExtensionData(namespace, key, value);
  }, 1000), [setExtensionData]);
  const key = 'owner' == category ? item.id + '_' + i + '_' + field.field_name + '_post_meta' : 'buyer_data_' + field.field_name + '_post_meta';

  /**
   * Handles fields validation
   */
  const validationErrorId = key + '-validator';
  const {
    setValidationErrors,
    clearValidationError
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useDispatch)('wc/store/validation');
  const validationError = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    const store = select('wc/store/validation');
    return store.getValidationError(validationErrorId);
  });

  /**
   * Handles changes in fields value.
   * Exclude Label field.
   */
  const [fieldValue, setFieldValue] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)('');
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (field.required) {
      // Set Validation Errors. Initially hidden until page has been fully loaded
      let hideError = !pageLoaded ? true : false;
      setValidationErrors({
        [validationErrorId]: {
          message: tc_woobridge_block.please_enter_a_valid + ' ' + field.field_title.toLowerCase(),
          hidden: hideError
        }
      });

      // Clear error with the following conditions
      if (pageLoaded && fieldValue.trim()) {
        clearValidationError(validationErrorId);
      }
    }

    // Update in tickera/checkout-fields extended data
    setExtensionData(blockNamespace, key, fieldValue);

    // Ensures setExtensionData is being called one at a time.
    debouncedSetExtensionData(blockNamespace, key, fieldValue);
  }, [setExtensionData, fieldValue, setValidationErrors, clearValidationError]);
  let error = !validationError?.hidden ? validationError?.message : false;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: 'tc-wb-block-component tc-wb-block-component-' + field.field_name + (error ? ' has-error' : '')
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("textarea", {
    className: "wc-block-components-textarea",
    onChange: e => setFieldValue(e.target.value),
    placeholder: field.field_placeholder ? field.field_placeholder : '',
    rows: 2,
    value: fieldValue
  }), error ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-validation-error"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, error)) : '', field.field_description ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wc-block-components-checkout-step__description description"
  }, field.field_description) : '');
};

/***/ }),

/***/ "./src/components/functions.js":
/*!*************************************!*\
  !*** ./src/components/functions.js ***!
  \*************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   stringConvention: function() { return /* binding */ stringConvention; }
/* harmony export */ });
/**
 * Convert String Convention (e.g. ucfirst, lcfirst)
 * Valid convention values:
 * - ucfirst (e.g. Hello world)
 *
 * @param prop
 */
const stringConvention = (string, convention, nospace) => {
  nospace = typeof nospace !== 'undefined' ? nospace : false;
  convention = typeof convention !== 'undefined' ? convention : 'ucfirst';
  switch (convention) {
    case 'ucfirst':
      return string.charAt(0).toUpperCase() + string.toLowerCase().slice(1);
      break;
    case 'ucwords':
      let ucWords = string.toLowerCase().replace(/(?<= )[^\s]|^./g, a => a.toUpperCase());
      return nospace ? ucWords.replace(' ', '') : ucWords;
      break;
  }
  return string;
};


/***/ }),

/***/ "./src/frontend/block.js":
/*!*******************************!*\
  !*** ./src/frontend/block.js ***!
  \*******************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Block: function() { return /* binding */ Block; }
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components_functions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../components/functions */ "./src/components/functions.js");
/* harmony import */ var _components_fields__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../components/fields */ "./src/components/fields.js");
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./style.scss */ "./src/frontend/style.scss");
/* harmony import */ var _woocommerce_settings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @woocommerce/settings */ "@woocommerce/settings");
/* harmony import */ var _woocommerce_settings__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_woocommerce_settings__WEBPACK_IMPORTED_MODULE_4__);



var pageLoaded = false;


/**
 * Woocommerce Integration Data
 */

const checkoutData = (0,_woocommerce_settings__WEBPACK_IMPORTED_MODULE_4__.getSetting)('tickera/checkout-fields_data');
const render = (prop, fieldType) => {
  switch (fieldType) {
    case 'text':
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_fields__WEBPACK_IMPORTED_MODULE_2__.TextField, {
        ...prop
      });
      break;
    case 'number':
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_fields__WEBPACK_IMPORTED_MODULE_2__.NumberField, {
        ...prop
      });
      break;
    case 'email':
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_fields__WEBPACK_IMPORTED_MODULE_2__.EmailField, {
        ...prop
      });
      break;
    case 'confirm_email':
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_fields__WEBPACK_IMPORTED_MODULE_2__.ConfirmEmailField, {
        ...prop
      });
      break;
    case 'label':
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_fields__WEBPACK_IMPORTED_MODULE_2__.LabelField, {
        ...prop
      });
      break;
    case 'checkbox':
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_fields__WEBPACK_IMPORTED_MODULE_2__.CheckboxField, {
        ...prop
      });
      break;
    case 'select':
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_fields__WEBPACK_IMPORTED_MODULE_2__.SelectField, {
        ...prop
      });
      break;
    case 'textarea':
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_fields__WEBPACK_IMPORTED_MODULE_2__.TextareaField, {
        ...prop
      });
      break;
    case 'radio':
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_fields__WEBPACK_IMPORTED_MODULE_2__.RadioField, {
        ...prop
      });
      break;
    case 'script':
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_fields__WEBPACK_IMPORTED_MODULE_2__.ScriptField, {
        ...prop
      });
      break;
    case 'hidden':
    case 'error':
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components_fields__WEBPACK_IMPORTED_MODULE_2__.HiddenField, {
        ...prop
      });
      break;
  }
};

/**
 * checkoutExtensionData, extensions
 *
 * @param prop
 * @returns {*[]}
 * @constructor
 */
const Block = prop => {
  let contents = [];
  if (document.readyState == 'complete') {
    pageLoaded = true;
  }

  // Buyer Fields
  contents.push((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wp-block-checkout-buyer-fields wc-block-components-checkout-step"
  }, (() => {
    let fields = [];
    checkoutData.buyer_fields.map(field => {
      const thisProp = {
        data: {
          prop
        },
        field,
        loaded: pageLoaded,
        category: 'buyer'
      };
      if (typeof field.form_visibility === 'undefined' || typeof field.form_visibility !== 'undefined' && field.form_visibility) {
        fields.push(render(thisProp, field.field_type));
      } else {
        fields.push(render(thisProp, 'hidden'));
      }
    });
    return fields;
  })()));

  // Owner Fields
  contents.push((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wp-block-checkout-owner-fields wc-block-components-checkout-step"
  }, checkoutData.cart_items.map((item, index) => {
    if (checkoutData.owner_fields[item.id].length > 0) {
      let visible_field = false;
      checkoutData.owner_fields[item.id].map(function (el) {
        if (typeof el.form_visibility !== 'undefined' && el.form_visibility) {
          visible_field = true;
        }
      });
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: !visible_field ? 'tc-hidden' : ''
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h4", null, item.name), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", null, (() => {
        let fields = [];
        for (let i = 0; i < item.quantity; i++) {
          fields.push((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h5", null, i + 1, ". ", tc_woobridge_block.attendee_info));
          checkoutData.owner_fields[item.id].map(field => {
            const thisProp = {
              data: {
                prop
              },
              item,
              field,
              loaded: pageLoaded,
              category: 'owner',
              i: i
            };
            if (typeof field.form_visibility === 'undefined' || typeof field.form_visibility !== 'undefined' && field.form_visibility) {
              fields.push(render(thisProp, field.field_type));
            } else {
              fields.push(render(thisProp, 'hidden'));
            }
          });
        }
        return fields;
      })()));
    }
  })));

  // Extras
  contents.push((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wp-block-checkout-extras-fields"
  }, (() => {
    let fields = [];
    checkoutData.extra_fields.map(field => {
      const thisProp = {
        data: {
          prop
        },
        field,
        loaded: pageLoaded
      };
      fields.push(render(thisProp, field.field_type));
    });
    return fields;
  })()));
  return contents;
};

/***/ }),

/***/ "./src/frontend/index.js":
/*!*******************************!*\
  !*** ./src/frontend/index.js ***!
  \*******************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @woocommerce/blocks-checkout */ "@woocommerce/blocks-checkout");
/* harmony import */ var _woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _block__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./block */ "./src/frontend/block.js");
/* harmony import */ var _block_json__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../block.json */ "./src/block.json");
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */


(0,_woocommerce_blocks_checkout__WEBPACK_IMPORTED_MODULE_0__.registerCheckoutBlock)({
  metadata: _block_json__WEBPACK_IMPORTED_MODULE_2__,
  component: _block__WEBPACK_IMPORTED_MODULE_1__.Block
});

/***/ }),

/***/ "./src/frontend/style.scss":
/*!*********************************!*\
  !*** ./src/frontend/style.scss ***!
  \*********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ (function(module) {

module.exports = window["React"];

/***/ }),

/***/ "lodash":
/*!*************************!*\
  !*** external "lodash" ***!
  \*************************/
/***/ (function(module) {

module.exports = window["lodash"];

/***/ }),

/***/ "@woocommerce/blocks-checkout":
/*!****************************************!*\
  !*** external ["wc","blocksCheckout"] ***!
  \****************************************/
/***/ (function(module) {

module.exports = window["wc"]["blocksCheckout"];

/***/ }),

/***/ "@woocommerce/settings":
/*!************************************!*\
  !*** external ["wc","wcSettings"] ***!
  \************************************/
/***/ (function(module) {

module.exports = window["wc"]["wcSettings"];

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ (function(module) {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ (function(module) {

module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ (function(module) {

module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ (function(module) {

module.exports = window["wp"]["i18n"];

/***/ }),

/***/ "./src/block.json":
/*!************************!*\
  !*** ./src/block.json ***!
  \************************/
/***/ (function(module) {

module.exports = JSON.parse('{"apiVersion":2,"name":"tickera/checkout-fields","version":"2.0.0","title":"Attendees Information","category":"woocommerce","description":"Additional attendees details in Contact Information Block","supports":{"html":false,"align":false,"multiple":false,"reusable":false},"parent":["woocommerce/checkout-contact-information-block"],"attributes":{"lock":{"type":"object","default":{"remove":true,"move":true}},"text":{"type":"string","default":""}},"textdomain":"woocommerce-tickera-bridge","editorStyle":"file:../../../build/style-editor.css"}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	!function() {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = function(result, chunkIds, fn, priority) {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var chunkIds = deferred[i][0];
/******/ 				var fn = deferred[i][1];
/******/ 				var priority = deferred[i][2];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every(function(key) { return __webpack_require__.O[key](chunkIds[j]); })) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	!function() {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = function(module) {
/******/ 			var getter = module && module.__esModule ?
/******/ 				function() { return module['default']; } :
/******/ 				function() { return module; };
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	!function() {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"frontend": 0,
/******/ 			"./style-frontend": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = function(chunkId) { return installedChunks[chunkId] === 0; };
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = function(parentChunkLoadingFunction, data) {
/******/ 			var chunkIds = data[0];
/******/ 			var moreModules = data[1];
/******/ 			var runtime = data[2];
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some(function(id) { return installedChunks[id] !== 0; })) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = self["webpackChunktickera_checkout_fields"] = self["webpackChunktickera_checkout_fields"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	}();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["./style-frontend"], function() { return __webpack_require__("./src/frontend/index.js"); })
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;
//# sourceMappingURL=frontend.js.map