<?php
/**
 * Thrive Themes - https://thrivethemes.com
 *
 * @package TCB2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Silence is golden
}

class TCB_Lead_Generation_Checkbox_Element extends TCB_Element_Abstract {

	public function name() {
		return __( 'Lead Generation Checkbox', 'thrive-cb' );
	}

	public function identifier() {
		return '.tve_lg_checkbox';
	}

	public function hide() {
		return true;
	}

	public function own_components() {
		$controls_default_config = array(
			'css_suffix' => ' label',
			'css_prefix' => apply_filters( 'tcb_selection_root', '#tve_editor', true ) . ' ',
		);

		$columns = array();
		for ( $i = 1; $i <= 10; $i ++ ) {
			$col = array(
				'value' => $i,
				'name'  => sprintf( __( '%d column', 'thrive-cb' ), $i ),
			);

			$columns[] = $col;
		}

		return array(
			'lead_generation_checkbox' => array(
				'config' => array(
					'columns_number' => array(
						'config'  => array(
							'options' => $columns,
							'name'    => 'Columns',
						),
						'extends' => 'Select',
					),
					'consent'        => array(
						'config' => array(
							'options' => array(
								array(
									'value' => 'when_checked',
									'name'  => __( 'Only when the checkbox is ticked', 'thrive-cb' ),
								),
								array(
									'value' => 'always',
									'name'  => __( 'Always on form submission', 'thrive-cb' ),
								),
							),
							'labels'  => array(
								'wordpress' => __( 'Create Wordpress account', 'thrive-cb' ),
								'default'   => __( 'Send lead data to {service}', 'thrive-cb' ),
							),
						),
					),
					'required'       => array(
						'config' => array(
							'default' => false,
							'label'   => __( 'Required field' ),
						),
					),
				),
			),
			'typography'               => array(
				'disabled_controls' => array(
					'TextAlign',
					'.tve-advanced-controls',
				),
				'config'            => array(
					'FontSize'      => $controls_default_config,
					'FontColor'     => $controls_default_config,
					'FontFace'      => $controls_default_config,
					'LetterSpacing' => $controls_default_config,
					'LineHeight'    => $controls_default_config,
					'TextAlign'     => $controls_default_config,
					'TextStyle'     => $controls_default_config,
					'TextTransform' => $controls_default_config,
				),
			),
			'layout'                   => array(
				'disabled_controls' => array(
					'Width',
					'Height',
					'Alignment',
					'.tve-advanced-controls',
				),
				'config'            => array(),
			),
			'borders'                  => array(
				'config' => array(),
			),
			'animation'                => array(
				'hidden' => true,
			),
			'background'               => array(
				'config' => array(),
			),
			'styles-templates'         => array(
				'config' => array(),
			),
		);
	}

}
