// This file was generated by modules-webmake (modules for web) project.
// See: https://github.com/medikoo/modules-webmake

(function (modules) {
	'use strict';

	var resolve, getRequire, wmRequire, notFoundError, findFile
	  , extensions = {".js":[],".json":[],".css":[],".html":[]}
	  , envRequire = typeof require === 'function' ? require : null;

	notFoundError = function (path) {
		var error = new Error("Could not find module '" + path + "'");
		error.code = 'MODULE_NOT_FOUND';
		return error;
	};
	findFile = function (scope, name, extName) {
		var i, ext;
		if (typeof scope[name + extName] === 'function') return name + extName;
		for (i = 0; (ext = extensions[extName][i]); ++i) {
			if (typeof scope[name + ext] === 'function') return name + ext;
		}
		return null;
	};
	resolve = function (scope, tree, path, fullPath, state, id) {
		var name, dir, exports, module, fn, found, ext;
		path = path.split('/');
		name = path.pop();
		if ((name === '.') || (name === '..')) {
			path.push(name);
			name = '';
		}
		while ((dir = path.shift()) != null) {
			if (!dir || (dir === '.')) continue;
			if (dir === '..') {
				scope = tree.pop();
				id = id.slice(0, id.lastIndexOf('/'));
			} else {
				tree.push(scope);
				scope = scope[dir];
				id += '/' + dir;
			}
			if (!scope) throw notFoundError(fullPath);
		}
		if (name && (typeof scope[name] !== 'function')) {
			found = findFile(scope, name, '.js');
			if (!found) found = findFile(scope, name, '.json');
			if (!found) found = findFile(scope, name, '.css');
			if (!found) found = findFile(scope, name, '.html');
			if (found) {
				name = found;
			} else if ((state !== 2) && (typeof scope[name] === 'object')) {
				tree.push(scope);
				scope = scope[name];
				id += '/' + name;
				name = '';
			}
		}
		if (!name) {
			if ((state !== 1) && scope[':mainpath:']) {
				return resolve(scope, tree, scope[':mainpath:'], fullPath, 1, id);
			}
			return resolve(scope, tree, 'index', fullPath, 2, id);
		}
		fn = scope[name];
		if (!fn) throw notFoundError(fullPath);
		if (fn.hasOwnProperty('module')) return fn.module.exports;
		exports = {};
		fn.module = module = { exports: exports, id: id + '/' + name };
		fn.call(exports, exports, module, getRequire(scope, tree, id));
		return module.exports;
	};
	wmRequire = function (scope, tree, fullPath, id) {
		var name, path = fullPath, t = fullPath.charAt(0), state = 0;
		if (t === '/') {
			path = path.slice(1);
			scope = modules['/'];
			if (!scope) {
				if (envRequire) return envRequire(fullPath);
				throw notFoundError(fullPath);
			}
			id = '/';
			tree = [];
		} else if (t !== '.') {
			name = path.split('/', 1)[0];
			scope = modules[name];
			if (!scope) {
				if (envRequire) return envRequire(fullPath);
				throw notFoundError(fullPath);
			}
			id = name;
			tree = [];
			path = path.slice(name.length + 1);
			if (!path) {
				path = scope[':mainpath:'];
				if (path) {
					state = 1;
				} else {
					path = 'index';
					state = 2;
				}
			}
		}
		return resolve(scope, tree, path, fullPath, state, id);
	};
	getRequire = function (scope, tree, id) {
		return function (path) {
			return wmRequire(scope, [].concat(tree), path, id);
		};
	};
	return getRequire(modules, [], '');
})({
	"workspace": {
		"tcb-bridge": {
			"assets": {
				"js": {
					"external": {
						"main.js": function (exports, module, require) {
							eval("/**\n * Created by Ovidiu on 7/20/2017.\n */\nvar TVE = window.TVE || {},\n\tTVE_Ult_Ext = window.TVE_Ult_Ext = TVE_Ult_Ext || {};\n\n(function ( $ ) {\n\t/**\n\t * On TCB Main Ready\n\t */\n\t$( window ).on( 'tcb_main_ready', function () {\n\t\tTVE.Views.Components.ultimatum_countdown = require( './ultimatum-countdown-component' );\n\n\t\tTVE_Ult_Ext.UltimatumCountdown = require( './modals/ultimatum-countdown' );\n\t} );\n})( jQuery );\n//# sourceURL=workspace/tcb-bridge/assets/js/external/main.js");
						},
						"modals": {
							"ultimatum-countdown.js": function (exports, module, require) {
								eval("/**\n * Created by Ovidiu on 7/20/2017.\n */\nvar _instance = null,\n\tshortcode_base = TVE.shortcode_manager;\nmodule.exports = TVE.modal.base.extend( {\n\tafter_initialize: function () {\n\t\tthis.$el.addClass( 'medium' );\n\t\tthis.$campaign = this.$el.find( '#tve_ult_campaign' );\n\t\tthis.$shortcode = this.$el.find( '#tve_ult_shortcode' );\n\t},\n\tbefore_open: function () {\n\t\tif ( ! TVE.ActiveElement.hasClass( 'tcb-elem-placeholder' ) ) {\n\t\t\tvar _config = this.get_config();\n\t\t\tif ( typeof _config['tve_ult_campaign'] !== 'undefined' && typeof _config['tve_ult_shortcode'] !== 'undefined' ) {\n\t\t\t\tthis.$campaign.val( _config['tve_ult_campaign'] ).trigger( 'change' );\n\t\t\t\tthis.$shortcode.val( _config['tve_ult_shortcode'] );\n\t\t\t}\n\t\t}\n\t},\n\t/**\n\t * Returns Ultimatum Shortcode Settings\n\t *\n\t * @returns {*}\n\t */\n\tget_config: function () {\n\t\tvar shortcode_config = shortcode_base( TVE.ActiveElement.find( '.thrive-shortcode-config' ), 'ultimatum_shortcode' );\n\n\t\treturn shortcode_config.get();\n\t},\n\tcampaign_changed: function ( event, dom ) {\n\t\tvar _$shortcode = this.$shortcode;\n\n\t\t_$shortcode.html( '' );\n\t\tif ( dom.value ) {\n\t\t\tjQuery.each( tve_ult_page_data.tu_shortcode_campaigns[dom.value].designs, function ( id, name ) {\n\t\t\t\tvar $option = jQuery( '<option/>' ).text( name ).val( id );\n\t\t\t\t_$shortcode.append( $option );\n\t\t\t}, this );\n\t\t}\n\t},\n\tgenerate_countdown_html: function () {\n\t\tvar self = this,\n\t\t\t$target = TVE.ActiveElement;\n\n\t\tthis.countdown_ajax( {\n\t\t\ttve_ult_campaign: this.$campaign.val(),\n\t\t\ttve_ult_shortcode: this.$shortcode.val()\n\t\t} ).done( function ( response ) {\n\t\t\tif ( response ) {\n\t\t\t\t$target.html( response ).removeClass( 'tcb-elem-placeholder' );\n\t\t\t}\n\t\t} ).error( function ( error ) {\n\t\t\tTVE.page_message( error.responseText, 2, 5000 );\n\t\t} ).complete( function () {\n\t\t\tTVE.main.overlay( 'close' );\n\t\t\tself.close();\n\t\t} );\n\n\t},\n\tcountdown_ajax: function ( data, ajax_param ) {\n\t\tvar params = {\n\t\t\ttype: 'post',\n\t\t\tdataType: 'json',\n\t\t\turl: tve_ult_page_data.ajaxurl\n\t\t};\n\t\tTVE.main.overlay();\n\t\tdata.action = 'tve_ult_fetch_countdown_for_editor';\n\t\tdata._nonce = tve_ult_page_data.security;\n\t\tparams.data = data;\n\n\t\tif ( ajax_param ) {\n\t\t\tfor ( var k in ajax_param ) {\n\t\t\t\tparams[k] = ajax_param[k];\n\t\t\t}\n\t\t}\n\n\t\treturn jQuery.ajax( params, data );\n\t}\n}, {\n\t/**\n\t * \"Singleton\" implementation for modal instance\n\t *\n\t * @param el\n\t */\n\tget_instance: function ( el ) {\n\t\tif ( ! _instance ) {\n\t\t\t_instance = new TVE_Ult_Ext.UltimatumCountdown( {\n\t\t\t\tel: el\n\t\t\t} );\n\t\t}\n\n\t\treturn _instance;\n\t}\n} );\n//# sourceURL=workspace/tcb-bridge/assets/js/external/modals/ultimatum-countdown.js");
							}
						},
						"ultimatum-countdown-component.js": function (exports, module, require) {
							eval("/**\n * Created by Ovidiu on 7/20/2017.\n */\nmodule.exports = TVE.Views.Base.component.extend( {\n\tcontrols_init: function () {\n\t},\n\tplaceholder_action: function () {\n\t\tvar campaignShortcodes = TVE_Ult_Ext.UltimatumCountdown.get_instance( TVE.modal.get_element( 'campaign-shotcodes' ) );\n\t\tcampaignShortcodes.open( {\n\t\t\ttop: '20%'\n\t\t} );\n\t},\n\t/**\n\t * Callback for change countdown button inside the Ultimatum Countdown Options Menu\n\t */\n\tchange_countdown: function () {\n\t\tthis.placeholder_action();\n\t}\n} );\n//# sourceURL=workspace/tcb-bridge/assets/js/external/ultimatum-countdown-component.js");
						}
					}
				}
			}
		}
	}
})("workspace/tcb-bridge/assets/js/external/main");
