/*! Thrive Graph Editor - 2018-10-17
* http://www.thrivethemes.com/
* Copyright (c) 2018 Thrive Themes */

!function(a,b){if("function"==typeof define&&define.amd)define(["backbone","lodash","jquery"],function(c,d,e){return c.$=e,b(a,c,d,e)});else if("undefined"!=typeof exports){var c=require("backbone"),d=require("lodash"),e=c.$=require("jquery");module.exports=b(a,c,d,e)}else{var c=a.Backbone,d=a._,e=c.$=a.jQuery||a.$;a.joint=b(a,c,d,e),a.g=a.joint.g,a.V=a.Vectorizer=a.joint.V}}(this,function(a,b,c,d){!function(){function a(a){this.message=a}var b="undefined"!=typeof exports?exports:this,c="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";a.prototype=new Error,a.prototype.name="InvalidCharacterError",b.btoa||(b.btoa=function(b){for(var d,e,f=String(b),g=0,h=c,i="";f.charAt(0|g)||(h="=",g%1);i+=h.charAt(63&d>>8-g%1*8)){if((e=f.charCodeAt(g+=.75))>255)throw new a("'btoa' failed: The string to be encoded contains characters outside of the Latin1 range.");d=d<<8|e}return i}),b.atob||(b.atob=function(b){var d=String(b).replace(/=+$/,"");if(d.length%4==1)throw new a("'atob' failed: The string to be decoded is not correctly encoded.");for(var e,f,g=0,h=0,i="";f=d.charAt(h++);~f&&(e=g%4?64*e+f:f,g++%4)?i+=String.fromCharCode(255&e>>(-2*g&6)):0)f=c.indexOf(f);return i})}(),function(){function a(a,b){return this.slice(a,b)}function b(a,b){arguments.length<2&&(b=0);for(var c=0,d=a.length;c<d;++c,++b)this[b]=255&a[c]}function c(c){var d;if("number"==typeof c){d=new Array(c);for(var e=0;e<c;++e)d[e]=0}else d=c.slice(0);return d.subarray=a,d.buffer=d,d.byteLength=d.length,d.set=b,"object"==typeof c&&c.buffer&&(d.buffer=c.buffer),d}"undefined"==typeof Uint8Array&&"undefined"!=typeof window&&(window.Uint8Array=c,window.Uint32Array=c,window.Int32Array=c)}(),function(){"undefined"!=typeof XMLHttpRequest&&("response"in XMLHttpRequest.prototype||"mozResponseArrayBuffer"in XMLHttpRequest.prototype||"mozResponse"in XMLHttpRequest.prototype||"responseArrayBuffer"in XMLHttpRequest.prototype||Object.defineProperty(XMLHttpRequest.prototype,"response",{get:function(){return new Uint8Array(new VBArray(this.responseBody).toArray())}}))}();var e,f=function(){var a={},b=Math,c=b.abs,d=b.cos,e=b.sin,f=b.sqrt,g=b.min,h=b.max,i=b.atan2,j=b.round,k=b.floor,l=b.PI,m=b.random;a.bezier={curveThroughPoints:function(a){for(var b=this.getCurveControlPoints(a),c=["M",a[0].x,a[0].y],d=0;d<b[0].length;d++)c.push("C",b[0][d].x,b[0][d].y,b[1][d].x,b[1][d].y,a[d+1].x,a[d+1].y);return c},getCurveControlPoints:function(a){var b,c=[],d=[],e=a.length-1;if(1==e)return c[0]=p((2*a[0].x+a[1].x)/3,(2*a[0].y+a[1].y)/3),d[0]=p(2*c[0].x-a[0].x,2*c[0].y-a[0].y),[c,d];var f=[];for(b=1;b<e-1;b++)f[b]=4*a[b].x+2*a[b+1].x;f[0]=a[0].x+2*a[1].x,f[e-1]=(8*a[e-1].x+a[e].x)/2;var g=this.getFirstControlPoints(f);for(b=1;b<e-1;++b)f[b]=4*a[b].y+2*a[b+1].y;f[0]=a[0].y+2*a[1].y,f[e-1]=(8*a[e-1].y+a[e].y)/2;var h=this.getFirstControlPoints(f);for(b=0;b<e;b++)c.push(p(g[b],h[b])),b<e-1?d.push(p(2*a[b+1].x-g[b+1],2*a[b+1].y-h[b+1])):d.push(p((a[e].x+g[e-1])/2,(a[e].y+h[e-1])/2));return[c,d]},getCurveDivider:function(a,b,c,d){return function(e){var f=o(a,b).pointAt(e),g=o(b,c).pointAt(e),h=o(c,d).pointAt(e),i=o(f,g).pointAt(e),j=o(g,h).pointAt(e),k=o(i,j).pointAt(e);return[{p0:a,p1:f,p2:i,p3:k},{p0:k,p1:j,p2:h,p3:d}]}},getFirstControlPoints:function(a){var b=a.length,c=[],d=[],e=2;c[0]=a[0]/e;for(var f=1;f<b;f++)d[f]=1/e,e=(f<b-1?4:3.5)-d[f],c[f]=(a[f]-c[f-1])/e;for(f=1;f<b;f++)c[b-f-1]-=d[b-f]*c[b-f];return c},getInversionSolver:function(a,b,c,d){function e(a,b){var c=f[a],d=f[b];return function(e){return(a%3?3:1)*(b%3?3:1)*(e.x*(c.y-d.y)+e.y*(d.x-c.x)+c.x*d.y-c.y*d.x)}}var f=arguments;return function(c){var d=3*e(2,3)(b),f=e(1,3)(a)/d,g=-e(2,3)(a)/d,h=f*e(3,1)(c)+g*(e(3,0)(c)+e(2,1)(c))+e(2,0)(c),i=f*e(3,0)(c)+g*e(2,0)(c)+e(1,0)(c);return i/(i-h)}}};var n=a.Ellipse=function(a,b,c){return this instanceof n?a instanceof n?new n(p(a),a.a,a.b):(a=p(a),this.x=a.x,this.y=a.y,this.a=b,void(this.b=c)):new n(a,b,c)};a.Ellipse.fromRect=function(a){return a=q(a),n(a.center(),a.width/2,a.height/2)},a.Ellipse.prototype={bbox:function(){return q(this.x-this.a,this.y-this.b,2*this.a,2*this.b)},clone:function(){return n(this)},normalizedDistance:function(a){var b=a.x,c=a.y,d=this.a,e=this.b,f=this.x,g=this.y;return(b-f)*(b-f)/(d*d)+(c-g)*(c-g)/(e*e)},containsPoint:function(a){return this.normalizedDistance(a)<=1},center:function(){return p(this.x,this.y)},tangentTheta:function(b){var c,d,e=b.x,f=b.y,g=this.a,h=this.b,i=this.bbox().center(),j=i.x,k=i.y,l=e>i.x+g/2,m=e<i.x-g/2;return l||m?(c=e>i.x?f-30:f+30,d=g*g/(e-j)-g*g*(f-k)*(c-k)/(h*h*(e-j))+j):(d=f>i.y?e+30:e-30,c=h*h/(f-k)-h*h*(e-j)*(d-j)/(g*g*(f-k))+k),a.point(d,c).theta(b)},equals:function(a){return a=n(a),a.x===this.x&&a.y===this.y&&a.a===this.a&&a.b===this.b},intersectionWithLineFromCenterToPoint:function(a,b){a=p(a),b&&a.rotate(p(this.x,this.y),b);var c,d=a.x-this.x,e=a.y-this.y;if(0===d)return c=this.bbox().pointNearestToPoint(a),b?c.rotate(p(this.x,this.y),-b):c;var g=e/d,h=g*g,i=this.a*this.a,j=this.b*this.b,k=f(1/(1/i+h/j));k=d<0?-k:k;var l=g*k;return c=p(this.x+k,this.y+l),b?c.rotate(p(this.x,this.y),-b):c},toString:function(){return p(this.x,this.y).toString()+" "+this.a+" "+this.b}};var o=a.Line=function(a,b){if(!(this instanceof o))return new o(a,b);this.start=p(a),this.end=p(b)};a.Line.prototype={bearing:function(){var a=u(this.start.y),b=u(this.end.y),c=this.start.x,f=this.end.x,g=u(f-c),h=e(g)*d(b),j=d(a)*e(b)-e(a)*d(b)*d(g),k=t(i(h,j)),l=["NE","E","SE","S","SW","W","NW","N"],m=k-22.5;return m<0&&(m+=360),m=parseInt(m/45),l[m]},clone:function(){return o(this)},intersection:function(a){var b=p(this.end.x-this.start.x,this.end.y-this.start.y),c=p(a.end.x-a.start.x,a.end.y-a.start.y),d=b.x*c.y-b.y*c.x,e=p(a.start.x-this.start.x,a.start.y-this.start.y),f=e.x*c.y-e.y*c.x,g=e.x*b.y-e.y*b.x;if(0===d||f*d<0||g*d<0)return null;if(d>0){if(f>d||g>d)return null}else if(f<d||g<d)return null;return p(this.start.x+f*b.x/d,this.start.y+f*b.y/d)},length:function(){return f(this.squaredLength())},midpoint:function(){return p((this.start.x+this.end.x)/2,(this.start.y+this.end.y)/2)},pointAt:function(a){var b=(1-a)*this.start.x+a*this.end.x,c=(1-a)*this.start.y+a*this.end.y;return p(b,c)},pointOffset:function(a){return((this.end.x-this.start.x)*(a.y-this.start.y)-(this.end.y-this.start.y)*(a.x-this.start.x))/2},squaredLength:function(){var a=this.start.x,b=this.start.y,c=this.end.x,d=this.end.y;return(a-=c)*a+(b-=d)*b},toString:function(){return this.start.toString()+" "+this.end.toString()}};var p=a.Point=function(a,b){if(!(this instanceof p))return new p(a,b);if("string"==typeof a){var c=a.split(-1===a.indexOf("@")?" ":"@");a=parseInt(c[0],10),b=parseInt(c[1],10)}else Object(a)===a&&(b=a.y,a=a.x);this.x=void 0===a?0:a,this.y=void 0===b?0:b};a.Point.fromPolar=function(a,b,f){f=f&&p(f)||p(0,0);var g=c(a*d(b)),h=c(a*e(b)),i=r(t(b));return i<90?h=-h:i<180?(g=-g,h=-h):i<270&&(g=-g),p(f.x+g,f.y+h)},a.Point.random=function(a,b,c,d){return p(k(m()*(b-a+1)+a),k(m()*(d-c+1)+c))},a.Point.prototype={adhereToRect:function(a){return a.containsPoint(this)?this:(this.x=g(h(this.x,a.x),a.x+a.width),this.y=g(h(this.y,a.y),a.y+a.height),this)},bearing:function(a){return o(this,a).bearing()},changeInAngle:function(a,b,c){return p(this).offset(-a,-b).theta(c)-this.theta(c)},clone:function(){return p(this)},difference:function(a){return p(this.x-a.x,this.y-a.y)},distance:function(a){return o(this,a).length()},equals:function(a){return this.x===a.x&&this.y===a.y},magnitude:function(){return f(this.x*this.x+this.y*this.y)||.01},manhattanDistance:function(a){return c(a.x-this.x)+c(a.y-this.y)},move:function(a,b){var c=u(p(a).theta(this));return this.offset(d(c)*b,-e(c)*b)},normalize:function(a){var b=(a||1)/this.magnitude();return this.scale(b,b)},offset:function(a,b){return this.x+=a||0,this.y+=b||0,this},reflection:function(a){return p(a).move(this,this.distance(a))},rotate:function(a,b){b=(b+360)%360,this.toPolar(a),this.y+=u(b);var c=p.fromPolar(this.x,this.y,a);return this.x=c.x,this.y=c.y,this},round:function(a){return this.x=a?this.x.toFixed(a):j(this.x),this.y=a?this.y.toFixed(a):j(this.y),this},scale:function(a,b,c){return c=c&&p(c)||p(0,0),this.x=c.x+a*(this.x-c.x),this.y=c.y+b*(this.y-c.y),this},snapToGrid:function(a,b){return this.x=s(this.x,a),this.y=s(this.y,b||a),this},theta:function(a){a=p(a);var b=-(a.y-this.y),c=a.x-this.x,d=0==b.toFixed(10)&&0==c.toFixed(10)?0:i(b,c);return d<0&&(d=2*l+d),180*d/l},toJSON:function(){return{x:this.x,y:this.y}},toPolar:function(a){a=a&&p(a)||p(0,0);var b=this.x,c=this.y;return this.x=f((b-a.x)*(b-a.x)+(c-a.y)*(c-a.y)),this.y=u(a.theta(p(b,c))),this},toString:function(){return this.x+"@"+this.y},update:function(a,b){return this.x=a||0,this.y=b||0,this}};var q=a.Rect=function(a,b,c,d){if(!(this instanceof q))return new q(a,b,c,d);Object(a)===a&&(b=a.y,c=a.width,d=a.height,a=a.x),this.x=void 0===a?0:a,this.y=void 0===b?0:b,this.width=void 0===c?0:c,this.height=void 0===d?0:d};a.Rect.fromEllipse=function(a){return a=n(a),q(a.x-a.a,a.y-a.b,2*a.a,2*a.b)},a.Rect.prototype={bbox:function(a){var b=u(a||0),f=c(e(b)),g=c(d(b)),h=this.width*g+this.height*f,i=this.width*f+this.height*g;return q(this.x+(this.width-h)/2,this.y+(this.height-i)/2,h,i)},bottomLeft:function(){return p(this.x,this.y+this.height)},bottomMiddle:function(){return p(this.x+this.width/2,this.y+this.height)},center:function(){return p(this.x+this.width/2,this.y+this.height/2)},clone:function(){return q(this)},containsPoint:function(a){return a=p(a),a.x>=this.x&&a.x<=this.x+this.width&&a.y>=this.y&&a.y<=this.y+this.height},containsRect:function(a){var b=q(this).normalize(),c=q(a).normalize(),d=b.width,e=b.height,f=c.width,g=c.height;if(!(d&&e&&f&&g))return!1;var h=b.x,i=b.y,j=c.x,k=c.y;return f+=j,d+=h,g+=k,e+=i,h<=j&&f<=d&&i<=k&&g<=e},corner:function(){return p(this.x+this.width,this.y+this.height)},equals:function(a){var b=q(this).normalize(),c=q(a).normalize();return b.x===c.x&&b.y===c.y&&b.width===c.width&&b.height===c.height},intersect:function(a){var b=this.origin(),c=this.corner(),d=a.origin(),e=a.corner();if(e.x<=b.x||e.y<=b.y||d.x>=c.x||d.y>=c.y)return null;var f=Math.max(b.x,d.x),g=Math.max(b.y,d.y);return q(f,g,Math.min(c.x,e.x)-f,Math.min(c.y,e.y)-g)},intersectionWithLineFromCenterToPoint:function(a,b){a=p(a);var c,d=p(this.x+this.width/2,this.y+this.height/2);b&&a.rotate(d,b);for(var e=[o(this.origin(),this.topRight()),o(this.topRight(),this.corner()),o(this.corner(),this.bottomLeft()),o(this.bottomLeft(),this.origin())],f=o(d,a),g=e.length-1;g>=0;--g){var h=e[g].intersection(f);if(null!==h){c=h;break}}return c&&b&&c.rotate(d,-b),c},leftMiddle:function(){return p(this.x,this.y+this.height/2)},moveAndExpand:function(a){return this.x+=a.x||0,this.y+=a.y||0,this.width+=a.width||0,this.height+=a.height||0,this},normalize:function(){var a=this.x,b=this.y,c=this.width,d=this.height;return this.width<0&&(a=this.x+this.width,c=-this.width),this.height<0&&(b=this.y+this.height,d=-this.height),this.x=a,this.y=b,this.width=c,this.height=d,this},origin:function(){return p(this.x,this.y)},pointNearestToPoint:function(a){if(a=p(a),this.containsPoint(a)){switch(this.sideNearestToPoint(a)){case"right":return p(this.x+this.width,a.y);case"left":return p(this.x,a.y);case"bottom":return p(a.x,this.y+this.height);case"top":return p(a.x,this.y)}}return a.adhereToRect(this)},rightMiddle:function(){return p(this.x+this.width,this.y+this.height/2)},round:function(a){return this.x=a?this.x.toFixed(a):j(this.x),this.y=a?this.y.toFixed(a):j(this.y),this.width=a?this.width.toFixed(a):j(this.width),this.height=a?this.height.toFixed(a):j(this.height),this},scale:function(a,b,c){return c=this.origin().scale(a,b,c),this.x=c.x,this.y=c.y,this.width*=a,this.height*=b,this},sideNearestToPoint:function(a){a=p(a);var b=a.x-this.x,c=this.x+this.width-a.x,d=a.y-this.y,e=this.y+this.height-a.y,f=b,g="left";return c<f&&(f=c,g="right"),d<f&&(f=d,g="top"),e<f&&(f=e,g="bottom"),g},snapToGrid:function(a,b){var c=this.origin().snapToGrid(a,b),d=this.corner().snapToGrid(a,b);return this.x=c.x,this.y=c.y,this.width=d.x-c.x,this.height=d.y-c.y,this},topMiddle:function(){return p(this.x+this.width/2,this.y)},topRight:function(){return p(this.x+this.width,this.y)},toJSON:function(){return{x:this.x,y:this.y,width:this.width,height:this.height}},toString:function(){return this.origin().toString()+" "+this.corner().toString()},union:function(a){var b=this.origin(),c=this.corner(),d=a.origin(),e=a.corner(),f=Math.min(b.x,d.x),g=Math.min(b.y,d.y),h=Math.max(c.x,e.x),i=Math.max(c.y,e.y);return q(f,g,h-f,i-g)}};var r=a.normalizeAngle=function(a){return a%360+(a<0?360:0)};a.scale={linear:function(a,b,c){var d=a[1]-a[0],e=b[1]-b[0];return(c-a[0])/d*e+b[0]||0}};var s=a.snapToGrid=function(a,b){return b*Math.round(a/b)},t=a.toDeg=function(a){return 180*a/l%360},u=a.toRad=function(a,b){return b=b||!1,(a=b?a:a%360)*l/180};return a.ellipse=a.Ellipse,a.line=a.Line,a.point=a.Point,a.rect=a.Rect,a}();e=function(){"use strict";if("object"!=typeof window||!window.SVGAngle&&!document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1"))return function(){throw new Error("SVG is required to use Vectorizer.")};var a={xmlns:"http://www.w3.org/2000/svg",xml:"http://www.w3.org/XML/1998/namespace",xlink:"http://www.w3.org/1999/xlink"},b=function(c,d,e){if(!(this instanceof b))return b.apply(Object.create(b.prototype),arguments);if(c){if(b.isV(c)&&(c=c.node),d=d||{},b.isString(c))if("svg"===c.toLowerCase())c=b.createSvgDocument();else if("<"===c[0]){var f=b.createSvgDocument(c);if(f.childNodes.length>1){var g,h,i=[];for(g=0,h=f.childNodes.length;g<h;g++){var j=f.childNodes[g];i.push(new b(document.importNode(j,!0)))}return i}c=document.importNode(f.firstChild,!0)}else c=document.createElementNS(a.xmlns,c);return this.node=c,this.node.id||(this.node.id=b.uniqueId()),this.setAttributes(d),e&&this.append(e),this}};b.prototype.getTransformToElement=function(a){return a.getScreenCTM().inverse().multiply(this.node.getScreenCTM())},b.matrixToTransformString=function(a){return a||(a=!0),"matrix("+[a.a||1,a.b||0,a.c||0,a.d||1,a.e||0,a.f||0]+")"},b.prototype.transform=function(a,c){if(b.isUndefined(a))return this.node.parentNode?this.getTransformToElement(this.node.parentNode):this.node.getScreenCTM();if(c&&c.absolute)return this.attr("transform",b.matrixToTransformString(a));var d=this.node.transform.baseVal;c&&c.absolute&&d.clear();var e=b.createSVGTransform(a);return d.appendItem(e),this},b.prototype.translate=function(a,c,d){d=d||{},c=c||0;var e=this.attr("transform")||"",f=b.parseTransformString(e);if(b.isUndefined(a))return f.translate;e=e.replace(/translate\([^\)]*\)/g,"").trim();var g=d.absolute?a:f.translate.tx+a,h=d.absolute?c:f.translate.ty+c,i="translate("+g+","+h+")";return this.attr("transform",(i+" "+e).trim()),this},b.prototype.rotate=function(a,c,d,e){e=e||{};var f=this.attr("transform")||"",g=b.parseTransformString(f);if(b.isUndefined(a))return g.rotate;f=f.replace(/rotate\([^\)]*\)/g,"").trim(),a%=360;var h=e.absolute?a:g.rotate.angle+a,i=void 0!==c&&void 0!==d?","+c+","+d:"",j="rotate("+h+i+")";return this.attr("transform",(f+" "+j).trim()),this},b.prototype.scale=function(a,c){c=b.isUndefined(c)?a:c;var d=this.attr("transform")||"",e=b.parseTransformString(d);if(b.isUndefined(a))return e.scale;d=d.replace(/scale\([^\)]*\)/g,"").trim();var f="scale("+a+","+c+")";return this.attr("transform",(d+" "+f).trim()),this},b.prototype.bbox=function(a,c){if(!this.node.ownerSVGElement)return{x:0,y:0,width:0,height:0};var d;try{d=this.node.getBBox(),d={x:d.x,y:d.y,width:d.width,height:d.height}}catch(a){d={x:this.node.clientLeft,y:this.node.clientTop,width:this.node.clientWidth,height:this.node.clientHeight}}if(a)return d;var e=this.getTransformToElement(c||this.node.ownerSVGElement);return b.transformRect(d,e)},b.prototype.text=function(a,c){a=b.sanitizeText(a),c=c||{};var d,e=a.split("\n");this.attr("y")||this.attr("y","0.8em"),this.attr("display",a?null:"none"),this.attr("xml:space","preserve"),this.node.textContent="";var f=this.node;if(c.textPath){var g=this.find("defs");0===g.length&&(g=b("defs"),this.append(g));var h=Object(c.textPath)===c.textPath?c.textPath.d:c.textPath;if(h){var i=b("path",{d:h});g.append(i)}var j=b("textPath");!c.textPath["xlink:href"]&&i&&j.attr("xlink:href","#"+i.node.id),Object(c.textPath)===c.textPath&&j.attr(c.textPath),this.append(j),f=j.node}for(var k=0,l=0;l<e.length;l++){var m=e[l],n=c.lineHeight||"1em";"auto"===c.lineHeight&&(n="1.5em");var o=b("tspan",{dy:0==l?"0em":n,x:this.attr("x")||0});if(o.addClass("v-line"),m)if(c.annotations){for(var p=0,q=b.annotateString(e[l],b.isArray(c.annotations)?c.annotations:[c.annotations],{offset:-k,includeAnnotationIndices:c.includeAnnotationIndices}),r=0;r<q.length;r++){var s=q[r];if(b.isObject(s)){var t=parseInt(s.attrs["font-size"],10);t&&t>p&&(p=t),d=b("tspan",s.attrs),c.includeAnnotationIndices&&d.attr("annotations",s.annotations),s.attrs.class&&d.addClass(s.attrs.class),d.node.textContent=s.t}else d=document.createTextNode(s||" ");o.append(d)}"auto"===c.lineHeight&&p&&0!==l&&o.attr("dy",1.2*p+"px")}else o.node.textContent=m;else o.addClass("v-empty-line"),o.node.style.fillOpacity=0,o.node.style.strokeOpacity=0,o.node.textContent="-";b(f).append(o),k+=m.length+1}return this},b.prototype.removeAttr=function(a){var c=b.qualifyAttr(a),d=this.node;return c.ns?d.hasAttributeNS(c.ns,c.local)&&d.removeAttributeNS(c.ns,c.local):d.hasAttribute(a)&&d.removeAttribute(a),this},b.prototype.attr=function(a,c){if(b.isUndefined(a)){for(var d=this.node.attributes,e={},f=0;f<d.length;f++)e[d[f].name]=d[f].value;return e}if(b.isString(a)&&b.isUndefined(c))return this.node.getAttribute(a);if("object"==typeof a)for(var g in a)a.hasOwnProperty(g)&&this.setAttribute(g,a[g]);else this.setAttribute(a,c);return this},b.prototype.remove=function(){return this.node.parentNode&&this.node.parentNode.removeChild(this.node),this},b.prototype.empty=function(){for(;this.node.firstChild;)this.node.removeChild(this.node.firstChild);return this},b.prototype.setAttributes=function(a){for(var b in a)a.hasOwnProperty(b)&&this.setAttribute(b,a[b]);return this},b.prototype.append=function(a){b.isArray(a)||(a=[a]);for(var c=0,d=a.length;c<d;c++)this.node.appendChild(b.toNode(a[c]));return this},b.prototype.prepend=function(a){var c=this.node.firstChild;return c?b(c).before(a):this.append(a)},b.prototype.before=function(a){var c=this.node,d=c.parentNode;if(d){b.isArray(a)||(a=[a]);for(var e=0,f=a.length;e<f;e++)d.insertBefore(b.toNode(a[e]),c)}return this},b.prototype.svg=function(){return this.node instanceof window.SVGSVGElement?this:b(this.node.ownerSVGElement)},b.prototype.defs=function(){var a=this.svg().node.getElementsByTagName("defs");return a&&a.length?b(a[0]):void 0},b.prototype.clone=function(){var a=b(this.node.cloneNode(!0));return a.node.id=b.uniqueId(),a},b.prototype.findOne=function(a){var c=this.node.querySelector(a);return c?b(c):void 0},b.prototype.find=function(a){var c=[],d=this.node.querySelectorAll(a);if(d)for(var e=0;e<d.length;e++)c.push(b(d[e]));return c},b.prototype.index=function(){for(var a=0,b=this.node.previousSibling;b;)1===b.nodeType&&a++,b=b.previousSibling;return a},b.prototype.findParentByClass=function(a,c){for(var d=this.node.ownerSVGElement,e=this.node.parentNode;e&&e!==c&&e!==d;){var f=b(e);if(f.hasClass(a))return f;e=e.parentNode}return null},b.prototype.toLocalPoint=function(a,b){var c=this.svg().node,d=c.createSVGPoint();d.x=a,d.y=b;try{var e=d.matrixTransform(c.getScreenCTM().inverse()),f=this.getTransformToElement(c).inverse()}catch(a){return d}return e.matrixTransform(f)},b.prototype.translateCenterToPoint=function(a){var b=this.bbox(),c=f.rect(b).center();this.translate(a.x-c.x,a.y-c.y)},b.prototype.translateAndAutoOrient=function(a,c,d){var e=this.scale();this.attr("transform",""),this.scale(e.sx,e.sy);var g=this.svg().node,h=this.bbox(!1,d),i=g.createSVGTransform();i.setTranslate(-h.x-h.width/2,-h.y-h.height/2);var j=g.createSVGTransform(),k=f.point(a).changeInAngle(a.x-c.x,a.y-c.y,c);j.setRotate(k,0,0);var l=g.createSVGTransform(),m=f.point(a).move(c,h.width/2);l.setTranslate(a.x+(a.x-m.x),a.y+(a.y-m.y));var n=this.getTransformToElement(d),o=g.createSVGTransform();o.setMatrix(l.matrix.multiply(j.matrix.multiply(i.matrix.multiply(n))));var p=b.decomposeMatrix(o.matrix);return this.translate(p.translateX,p.translateY),this.rotate(p.rotation),this},b.prototype.animateAlongPath=function(a,c){var d=b("animateMotion",a),e=b("mpath",{"xlink:href":"#"+b(c).node.id});d.append(e),this.append(d);try{d.node.beginElement()}catch(a){if("fake"===document.documentElement.getAttribute("smiling")){var f=d.node;f.animators=[];var g=f.getAttribute("id");g&&(id2anim[g]=f);for(var h=getTargets(f),i=0,j=h.length;i<j;i++){var k=h[i],l=new Animator(f,k,i);animators.push(l),f.animators[i]=l,l.register()}}}},b.prototype.hasClass=function(a){return new RegExp("(\\s|^)"+a+"(\\s|$)").test(this.node.getAttribute("class"))},b.prototype.addClass=function(a){if(!this.hasClass(a)){var b=this.node.getAttribute("class")||"";this.node.setAttribute("class",(b+" "+a).trim())}return this},b.prototype.removeClass=function(a){if(this.hasClass(a)){var b=this.node.getAttribute("class").replace(new RegExp("(\\s|^)"+a+"(\\s|$)","g"),"$2");this.node.setAttribute("class",b)}return this},b.prototype.toggleClass=function(a,c){return(b.isUndefined(c)?this.hasClass(a):!c)?this.removeClass(a):this.addClass(a),this},b.prototype.sample=function(a){a=a||1;for(var b,c=this.node,d=c.getTotalLength(),e=[],f=0;f<d;)b=c.getPointAtLength(f),e.push({x:b.x,y:b.y,distance:f}),f+=a;return e},b.prototype.convertToPath=function(){var a=b("path");a.attr(this.attr());var c=this.convertToPathData();return c&&a.attr("d",c),a},b.prototype.convertToPathData=function(){var a=this.node.tagName.toUpperCase();switch(a){case"PATH":return this.attr("d");case"LINE":return b.convertLineToPathData(this.node);case"POLYGON":return b.convertPolygonToPathData(this.node);case"POLYLINE":return b.convertPolylineToPathData(this.node);case"ELLIPSE":return b.convertEllipseToPathData(this.node);case"CIRCLE":return b.convertCircleToPathData(this.node);case"RECT":return b.convertRectToPathData(this.node)}throw new Error(a+" cannot be converted to PATH.")},b.prototype.findIntersection=function(a,c){var d=this.svg().node;c=c||d;var e=f.rect(this.bbox(!1,c)),g=e.center();if(e.intersectionWithLineFromCenterToPoint(a)){var h,i=this.node.localName.toUpperCase();if("RECT"===i){var j=f.rect(parseFloat(this.attr("x")||0),parseFloat(this.attr("y")||0),parseFloat(this.attr("width")),parseFloat(this.attr("height"))),k=this.getTransformToElement(c),l=b.decomposeMatrix(k),m=d.createSVGTransform();m.setRotate(-l.rotation,g.x,g.y);var n=b.transformRect(j,m.matrix.multiply(k));h=f.rect(n).intersectionWithLineFromCenterToPoint(a,l.rotation)}else if("PATH"===i||"POLYGON"===i||"POLYLINE"===i||"CIRCLE"===i||"ELLIPSE"===i){var o,p,q,r,s,t,u="PATH"===i?this:this.convertToPath(),v=u.sample(),w=1/0,x=[];for(o=0;o<v.length;o++)p=v[o],q=b.createSVGPoint(p.x,p.y),q=q.matrixTransform(this.getTransformToElement(c)),p=f.point(q),r=p.distance(g),s=1.1*p.distance(a),t=r+s,t<w?(w=t,x=[{sample:p,refDistance:s}]):t<w+1&&x.push({sample:p,refDistance:s});x.sort(function(a,b){return a.refDistance-b.refDistance}),x[0]&&(h=x[0].sample)}return h}},b.prototype.setAttribute=function(a,c){var d=this.node;if(null===c)return this.removeAttr(a),this;var e=b.qualifyAttr(a);return e.ns?d.setAttributeNS(e.ns,a,c):"id"===a?d.id=c:d.setAttribute(a,c),this},b.createSvgDocument=function(c){var d='<svg xmlns="'+a.xmlns+'" xmlns:xlink="'+a.xlink+'" version="1.1">'+(c||"")+"</svg>";return b.parseXML(d,{async:!1}).documentElement},b.idCounter=0,b.uniqueId=function(){return"v-"+ ++b.idCounter},b.sanitizeText=function(a){return(a||"").replace(/ /g," ")},b.isUndefined=function(a){return void 0===a},b.isString=function(a){return"string"==typeof a},b.isObject=function(a){return a&&"object"==typeof a},b.isArray=Array.isArray,b.parseXML=function(a,c){c=c||{};var d;try{var e=new DOMParser;b.isUndefined(c.async)||(e.async=c.async),d=e.parseFromString(a,"text/xml")}catch(a){d=void 0}if(!d||d.getElementsByTagName("parsererror").length)throw new Error("Invalid XML: "+a);return d},b.qualifyAttr=function(b){if(-1!==b.indexOf(":")){var c=b.split(":");return{ns:a[c[0]],local:c[1]}}return{ns:null,local:b}},b.parseTransformString=function(a){var b,c,d;if(a){var e=a.match(/translate\((.*)\)/);e&&(b=e[1].split(/[ ,]+/));var f=a.match(/rotate\((.*)\)/);f&&(c=f[1].split(/[ ,]+/));var g=a.match(/scale\((.*)\)/);g&&(d=g[1].split(/[ ,]+/))}var h=d&&d[0]?parseFloat(d[0]):1;return{translate:{tx:b&&b[0]?parseInt(b[0],10):0,ty:b&&b[1]?parseInt(b[1],10):0},rotate:{angle:c&&c[0]?parseInt(c[0],10):0,cx:c&&c[1]?parseInt(c[1],10):void 0,cy:c&&c[2]?parseInt(c[2],10):void 0},scale:{sx:h,sy:d&&d[1]?parseFloat(d[1]):h}}},b.deltaTransformPoint=function(a,b){return{x:b.x*a.a+b.y*a.c+0,y:b.x*a.b+b.y*a.d+0}},b.decomposeMatrix=function(a){var c=b.deltaTransformPoint(a,{x:0,y:1}),d=b.deltaTransformPoint(a,{x:1,y:0}),e=180/Math.PI*Math.atan2(c.y,c.x)-90,f=180/Math.PI*Math.atan2(d.y,d.x);return{translateX:a.e,translateY:a.f,scaleX:Math.sqrt(a.a*a.a+a.b*a.b),scaleY:Math.sqrt(a.c*a.c+a.d*a.d),skewX:e,skewY:f,rotation:e}},b.isV=function(a){return a instanceof b},b.isVElement=b.isV;var c=b("svg").node;return b.createSVGMatrix=function(a){var b=c.createSVGMatrix();for(var d in a)b[d]=a[d];return b},b.createSVGTransform=function(a){return b.isUndefined(a)?c.createSVGTransform():(a instanceof SVGMatrix||(a=b.createSVGMatrix(a)),c.createSVGTransformFromMatrix(a))},b.createSVGPoint=function(a,b){var d=c.createSVGPoint();return d.x=a,d.y=b,d},b.transformRect=function(a,b){var d=c.createSVGPoint();d.x=a.x,d.y=a.y;var e=d.matrixTransform(b);d.x=a.x+a.width,d.y=a.y;var f=d.matrixTransform(b);d.x=a.x+a.width,d.y=a.y+a.height;var g=d.matrixTransform(b);d.x=a.x,d.y=a.y+a.height;var h=d.matrixTransform(b),i=Math.min(e.x,f.x,g.x,h.x),j=Math.max(e.x,f.x,g.x,h.x),k=Math.min(e.y,f.y,g.y,h.y);return{x:i,y:k,width:j-i,height:Math.max(e.y,f.y,g.y,h.y)-k}},b.transformPoint=function(a,c){return b.createSVGPoint(a.x,a.y).matrixTransform(c)},b.styleToObject=function(a){for(var b={},c=a.split(";"),d=0;d<c.length;d++){var e=c[d],f=e.split("=");b[f[0].trim()]=f[1].trim()}return b},b.createSlicePathData=function(a,b,c,d){var e=2*Math.PI-1e-6,f=a,g=b,h=c,i=d,j=(i<h&&(j=h,h=i,i=j),i-h),k=j<Math.PI?"0":"1",l=Math.cos(h),m=Math.sin(h),n=Math.cos(i),o=Math.sin(i);return j>=e?f?"M0,"+g+"A"+g+","+g+" 0 1,1 0,"+-g+"A"+g+","+g+" 0 1,1 0,"+g+"M0,"+f+"A"+f+","+f+" 0 1,0 0,"+-f+"A"+f+","+f+" 0 1,0 0,"+f+"Z":"M0,"+g+"A"+g+","+g+" 0 1,1 0,"+-g+"A"+g+","+g+" 0 1,1 0,"+g+"Z":f?"M"+g*l+","+g*m+"A"+g+","+g+" 0 "+k+",1 "+g*n+","+g*o+"L"+f*n+","+f*o+"A"+f+","+f+" 0 "+k+",0 "+f*l+","+f*m+"Z":"M"+g*l+","+g*m+"A"+g+","+g+" 0 "+k+",1 "+g*n+","+g*o+"L0,0Z"},b.mergeAttrs=function(a,c){for(var d in c)"class"===d?a[d]=a[d]?a[d]+" "+c[d]:c[d]:"style"===d?b.isObject(a[d])&&b.isObject(c[d])?a[d]=b.mergeAttrs(a[d],c[d]):b.isObject(a[d])?a[d]=b.mergeAttrs(a[d],b.styleToObject(c[d])):b.isObject(c[d])?a[d]=b.mergeAttrs(b.styleToObject(a[d]),c[d]):a[d]=b.mergeAttrs(b.styleToObject(a[d]),b.styleToObject(c[d])):a[d]=c[d];return a},b.annotateString=function(a,c,d){c=c||[],d=d||{};for(var e,f,g,h=d.offset||0,i=[],j=[],k=0;k<a.length;k++){f=j[k]=a[k];for(var l=0;l<c.length;l++){var m=c[l],n=m.start+h,o=m.end+h;k>=n&&k<o&&(b.isObject(f)?f.attrs=b.mergeAttrs(b.mergeAttrs({},f.attrs),m.attrs):f=j[k]={t:a[k],attrs:m.attrs},d.includeAnnotationIndices&&(f.annotations||(f.annotations=[])).push(l))}g=j[k-1],g?b.isObject(f)&&b.isObject(g)?JSON.stringify(f.attrs)===JSON.stringify(g.attrs)?e.t+=f.t:(i.push(e),e=f):b.isObject(f)?(i.push(e),e=f):b.isObject(g)?(i.push(e),e=f):e=(e||"")+f:e=f}return e&&i.push(e),i},b.findAnnotationsAtIndex=function(a,b){var c=[];return a&&a.forEach(function(a){a.start<b&&b<=a.end&&c.push(a)}),c},b.findAnnotationsBetweenIndexes=function(a,b,c){var d=[];return a&&a.forEach(function(a){(b>=a.start&&b<a.end||c>a.start&&c<=a.end||a.start>=b&&a.end<c)&&d.push(a)}),d},b.shiftAnnotations=function(a,b,c){return a&&a.forEach(function(a){a.start<b&&a.end>=b?a.end+=c:a.start>=b&&(a.start+=c,a.end+=c)}),a},b.convertLineToPathData=function(a){return a=b(a),["M",a.attr("x1"),a.attr("y1"),"L",a.attr("x2"),a.attr("y2")].join(" ")},b.convertPolygonToPathData=function(a){var c=b.getPointsFromSvgNode(b(a).node);return c.length>0?b.svgPointsToPath(c)+" Z":null},b.convertPolylineToPathData=function(a){var c=b.getPointsFromSvgNode(b(a).node);return c.length>0?b.svgPointsToPath(c):null},b.svgPointsToPath=function(a){var b;for(b=0;b<a.length;b++)a[b]=a[b].x+" "+a[b].y;return"M "+a.join(" L")},b.getPointsFromSvgNode=function(a){var b,c=[];for(b=0;b<a.points.numberOfItems;b++)c.push(a.points.getItem(b));return c},b.KAPPA=.5522847498307935,b.convertCircleToPathData=function(a){a=b(a);var c=parseFloat(a.attr("cx"))||0,d=parseFloat(a.attr("cy"))||0,e=parseFloat(a.attr("r")),f=e*b.KAPPA;return["M",c,d-e,"C",c+f,d-e,c+e,d-f,c+e,d,"C",c+e,d+f,c+f,d+e,c,d+e,"C",c-f,d+e,c-e,d+f,c-e,d,"C",c-e,d-f,c-f,d-e,c,d-e,"Z"].join(" ")},b.convertEllipseToPathData=function(a){a=b(a);var c=parseFloat(a.attr("cx"))||0,d=parseFloat(a.attr("cy"))||0,e=parseFloat(a.attr("rx")),f=parseFloat(a.attr("ry"))||e,g=e*b.KAPPA,h=f*b.KAPPA;return["M",c,d-f,"C",c+g,d-f,c+e,d-h,c+e,d,"C",c+e,d+h,c+g,d+f,c,d+f,"C",c-g,d+f,c-e,d+h,c-e,d,"C",c-e,d-h,c-g,d-f,c,d-f,"Z"].join(" ")},b.convertRectToPathData=function(a){a=b(a);var c,d=parseFloat(a.attr("x"))||0,e=parseFloat(a.attr("y"))||0,g=parseFloat(a.attr("width"))||0,h=parseFloat(a.attr("height"))||0,i=parseFloat(a.attr("rx"))||0,j=parseFloat(a.attr("ry"))||0,k=f.rect(d,e,g,h);if(i||j){var l=d+g,m=e+h;c=["M",d+i,e,"L",l-i,e,"Q",l,e,l,e+j,"L",l,e+h-j,"Q",l,m,l-i,m,"L",d+i,m,"Q",d,m,d,m-i,"L",d,e+j,"Q",d,e,d+i,e,"Z"].join(" ")}else c=["M",k.origin().x,k.origin().y,"H",k.corner().x,"V",k.corner().y,"H",k.origin().x,"V",k.origin().y,"Z"].join(" ");return c},b.rectToPath=function(a){var b=a.rx||a["top-rx"]||0,c=a.rx||a["bottom-rx"]||0,d=a.ry||a["top-ry"]||0,e=a.ry||a["bottom-ry"]||0;return["M",a.x,a.y+d,"v",a.height-d-e,"a",c,e,0,0,0,c,e,"h",a.width-2*c,"a",c,e,0,0,0,c,-e,"v",-(a.height-e-d),"a",b,d,0,0,0,-b,-d,"h",-(a.width-2*b),"a",b,d,0,0,0,-b,d].join(" ")},b.toNode=function(a){return b.isV(a)?a.node:a.nodeName&&a||a[0]},b}();var g={version:"1.0.3",config:{classNamePrefix:"joint-",defaultTheme:"default"},dia:{},ui:{},layout:{},shapes:{},format:{},connectors:{},highlighters:{},routers:{},mvc:{views:{}},setTheme:function(a,b){b=b||{},c.invoke(g.mvc.views,"setTheme",a,b),g.mvc.View.prototype.defaultTheme=a},env:{_results:{},_tests:{svgforeignobject:function(){return!!document.createElementNS&&/SVGForeignObject/.test({}.toString.call(document.createElementNS("http://www.w3.org/2000/svg","foreignObject")))}},addTest:function(a,b){return g.env._tests[a]=b},test:function(a){var b=g.env._tests[a];if(!b)throw new Error('Test not defined ("'+a+'"). Use `joint.env.addTest(name, fn) to add a new test.`');var c=g.env._results[a];if(void 0!==c)return c;try{c=b()}catch(a){c=!1}return g.env._results[a]=c,c}},util:{hashCode:function(a){var b=0;if(0==a.length)return b;for(var c=0;c<a.length;c++){b=(b<<5)-b+a.charCodeAt(c),b&=b}return b},getByPath:function(a,b,c){c=c||"/";for(var d,e=b.split(c);e.length;){if(d=e.shift(),!(Object(a)===a&&d in a))return;a=a[d]}return a},setByPath:function(a,b,c,d){d=d||"/";var e=b.split(d),f=a,g=0;if(b.indexOf(d)>-1){for(var h=e.length;g<h-1;g++)f=f[e[g]]||(f[e[g]]={});f[e[h-1]]=c}else a[b]=c;return a},unsetByPath:function(a,b,c){c=c||"/";var d=b.lastIndexOf(c);if(d>-1){var e=g.util.getByPath(a,b.substr(0,d),c);e&&delete e[b.slice(d+1)]}else delete a[b];return a},flattenObject:function(a,b,c){b=b||"/";var d={};for(var e in a)if(a.hasOwnProperty(e)){var f="object"==typeof a[e];if(f&&c&&c(a[e])&&(f=!1),f){
var g=this.flattenObject(a[e],b,c);for(var h in g)g.hasOwnProperty(h)&&(d[e+b+h]=g[h])}else d[e]=a[e]}return d},uuid:function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(a){var b=16*Math.random()|0;return("x"==a?b:3&b|8).toString(16)})},guid:function(a){return this.guid.id=this.guid.id||1,a.id=void 0===a.id?"j_"+this.guid.id++:a.id,a.id},mixin:c.assign,supplement:c.defaults,deepMixin:c.mixin,deepSupplement:c.defaultsDeep,normalizeEvent:function(a){var b=a.originalEvent&&a.originalEvent.changedTouches&&a.originalEvent.changedTouches[0];if(b){for(var c in a)void 0===b[c]&&(b[c]=a[c]);return b}return a},nextFrame:function(){var a;if("undefined"!=typeof window&&(a=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame),!a){var b=0;a=function(a){var c=(new Date).getTime(),d=Math.max(0,16-(c-b)),e=setTimeout(function(){a(c+d)},d);return b=c+d,e}}return function(b,d){return a(d?c.bind(b,d):b)}}(),cancelFrame:function(){var a,b="undefined"!=typeof window;return b&&(a=window.cancelAnimationFrame||window.webkitCancelAnimationFrame||window.webkitCancelRequestAnimationFrame||window.msCancelAnimationFrame||window.msCancelRequestAnimationFrame||window.oCancelAnimationFrame||window.oCancelRequestAnimationFrame||window.mozCancelAnimationFrame||window.mozCancelRequestAnimationFrame),a=a||clearTimeout,b?c.bind(a,window):a}(),shapePerimeterConnectionPoint:function(a,b,c,d){var g,h;if(!c){var i=b.$(".scalable")[0],j=b.$(".rotatable")[0];i&&i.firstChild?c=i.firstChild:j&&j.firstChild&&(c=j.firstChild)}return c?(h=e(c).findIntersection(d,a.paper.viewport))||(g=f.rect(e(c).bbox(!1,a.paper.viewport))):(g=b.model.getBBox(),h=g.intersectionWithLineFromCenterToPoint(d)),h||g.center()},breakText:function(a,b,c,d){d=d||{};var f=b.width,g=b.height,h=d.svgDocument||e("svg").node,i=e("<text><tspan></tspan></text>").attr(c||{}).node,j=i.firstChild,k=document.createTextNode("");i.style.opacity=0,i.style.display="block",j.style.display="block",j.appendChild(k),h.appendChild(i),d.svgDocument||document.body.appendChild(h);for(var l,m=a.split(" "),n=[],o=[],p=0,q=0,r=m.length;p<r;p++){var s=m[p];if(k.data=o[q]?o[q]+" "+s:s,j.getComputedTextLength()<=f)o[q]=k.data,l&&(n[q++]=!0,l=0);else{if(!o[q]||l){var t=!!l;if(l=s.length-1,t||!l){if(!l){if(!o[q]){o=[];break}m.splice(p,2,s+m[p+1]),r--,n[q++]=!0,p--;continue}m[p]=s.substring(0,l),m[p+1]=s.substring(l)+m[p+1]}else m.splice(p,1,s.substring(0,l),s.substring(l)),r++,q&&!n[q-1]&&q--;p--;continue}q++,p--}if(void 0!==g){var u=u||1.25*i.getBBox().height;if(u*o.length>g){o.splice(Math.floor(g/u));break}}}return d.svgDocument?h.removeChild(i):document.body.removeChild(h),o.join("\n")},imageToDataUri:function(a,b){if(!a||"data:"===a.substr(0,"data:".length))return setTimeout(function(){b(null,a)},0);var c=function(b,c){if(200===b.status){var d=new FileReader;d.onload=function(a){var b=a.target.result;c(null,b)},d.onerror=function(){c(new Error("Failed to load image "+a))},d.readAsDataURL(b.response)}else c(new Error("Failed to load image "+a))},d=function(b,c){if(200===b.status){var d=new Uint8Array(b.response),e=a.split(".").pop()||"png";c(null,"data:image/"+({svg:"svg+xml"}[e]||e)+";base64,"+btoa(function(a){for(var b=[],c=0;c<a.length;c+=32768)b.push(String.fromCharCode.apply(null,a.subarray(c,c+32768)));return b.join("")}(d)))}else c(new Error("Failed to load image "+a))},e=new XMLHttpRequest;e.open("GET",a,!0),e.addEventListener("error",function(){b(new Error("Failed to load image "+a))}),e.responseType=window.FileReader?"blob":"arraybuffer",e.addEventListener("load",function(){window.FileReader?c(e,b):d(e,b)}),e.send()},getElementBBox:function(a){var b=d(a);if(0===b.length)throw new Error("Element not found");var c=b[0],f=c.ownerDocument,g=c.getBoundingClientRect(),h=0,i=0;if(c.ownerSVGElement){var j=e(c).bbox();h=g.width-j.width,i=g.height-j.height}return{x:g.left+window.pageXOffset-f.documentElement.offsetLeft+h/2,y:g.top+window.pageYOffset-f.documentElement.offsetTop+i/2,width:g.width-h,height:g.height-i}},sortElements:function(a,b){var c=d(a),e=c.map(function(){var a=this,b=a.parentNode,c=b.insertBefore(document.createTextNode(""),a.nextSibling);return function(){if(b===this)throw new Error("You can't sort elements if any one is a descendant of another.");b.insertBefore(this,c),b.removeChild(c)}});return Array.prototype.sort.call(c,b).each(function(a){e[a].call(this)})},setAttributesBySelector:function(a,b){var e=d(a);c.each(b,function(a,b){var d=e.find(b).addBack().filter(b);c.has(a,"class")&&(d.addClass(a.class),a=c.omit(a,"class")),d.attr(a)})},normalizeSides:function(a){return Object(a)!==a?(a=a||0,{top:a,bottom:a,left:a,right:a}):{top:a.top||0,bottom:a.bottom||0,left:a.left||0,right:a.right||0}},timing:{linear:function(a){return a},quad:function(a){return a*a},cubic:function(a){return a*a*a},inout:function(a){if(a<=0)return 0;if(a>=1)return 1;var b=a*a,c=b*a;return 4*(a<.5?c:3*(a-b)+c-.75)},exponential:function(a){return Math.pow(2,10*(a-1))},bounce:function(a){for(var b=0,c=1;1;b+=c,c/=2)if(a>=(7-4*b)/11){var d=(11-6*b-11*a)/4;return-d*d+c*c}},reverse:function(a){return function(b){return 1-a(1-b)}},reflect:function(a){return function(b){return.5*(b<.5?a(2*b):2-a(2-2*b))}},clamp:function(a,b,c){return b=b||0,c=c||1,function(d){var e=a(d);return e<b?b:e>c?c:e}},back:function(a){return a||(a=1.70158),function(b){return b*b*((a+1)*b-a)}},elastic:function(a){return a||(a=1.5),function(b){return Math.pow(2,10*(b-1))*Math.cos(20*Math.PI*a/3*b)}}},interpolate:{number:function(a,b){var c=b-a;return function(b){return a+c*b}},object:function(a,b){var d=c.keys(a);return function(c){var e,f,g={};for(e=d.length-1;-1!=e;e--)f=d[e],g[f]=a[f]+(b[f]-a[f])*c;return g}},hexColor:function(a,b){var c=parseInt(a.slice(1),16),d=parseInt(b.slice(1),16),e=255&c,f=(255&d)-e,g=65280&c,h=(65280&d)-g,i=16711680&c,j=(16711680&d)-i;return function(a){return"#"+(1<<24|e+f*a&255|g+h*a&65280|i+j*a&16711680).toString(16).slice(1)}},unit:function(a,b){var c=/(-?[0-9]*.[0-9]*)(px|em|cm|mm|in|pt|pc|%)/,d=c.exec(a),e=c.exec(b),f=e[1].indexOf("."),g=f>0?e[1].length-f-1:0;a=+d[1];var h=+e[1]-a,i=d[2];return function(b){return(a+h*b).toFixed(g)+i}}},filter:{outline:function(a){var b=c.isFinite(a.margin)?a.margin:2,d=c.isFinite(a.width)?a.width:1;return g.util.template('<filter><feFlood flood-color="${color}" flood-opacity="${opacity}" result="colored"/><feMorphology in="SourceAlpha" result="morphedOuter" operator="dilate" radius="${outerRadius}" /><feMorphology in="SourceAlpha" result="morphedInner" operator="dilate" radius="${innerRadius}" /><feComposite result="morphedOuterColored" in="colored" in2="morphedOuter" operator="in"/><feComposite operator="xor" in="morphedOuterColored" in2="morphedInner" result="outline"/><feMerge><feMergeNode in="outline"/><feMergeNode in="SourceGraphic"/></feMerge></filter>')({color:a.color||"blue",opacity:c.isFinite(a.opacity)?a.opacity:1,outerRadius:b+d,innerRadius:b})},highlight:function(a){return g.util.template('<filter><feFlood flood-color="${color}" flood-opacity="${opacity}" result="colored"/><feMorphology result="morphed" in="SourceGraphic" operator="dilate" radius="${width}"/><feComposite result="composed" in="colored" in2="morphed" operator="in"/><feGaussianBlur result="blured" in="composed" stdDeviation="${blur}"/><feBlend in="SourceGraphic" in2="blured" mode="normal"/></filter>')({color:a.color||"red",width:c.isFinite(a.width)?a.width:1,blur:c.isFinite(a.blur)?a.blur:0,opacity:c.isFinite(a.opacity)?a.opacity:1})},blur:function(a){var b=c.isFinite(a.x)?a.x:2;return g.util.template('<filter><feGaussianBlur stdDeviation="${stdDeviation}"/></filter>')({stdDeviation:c.isFinite(a.y)?[b,a.y]:b})},dropShadow:function(a){var b="SVGFEDropShadowElement"in window?'<filter><feDropShadow stdDeviation="${blur}" dx="${dx}" dy="${dy}" flood-color="${color}" flood-opacity="${opacity}"/></filter>':'<filter><feGaussianBlur in="SourceAlpha" stdDeviation="${blur}"/><feOffset dx="${dx}" dy="${dy}" result="offsetblur"/><feFlood flood-color="${color}"/><feComposite in2="offsetblur" operator="in"/><feComponentTransfer><feFuncA type="linear" slope="${opacity}"/></feComponentTransfer><feMerge><feMergeNode/><feMergeNode in="SourceGraphic"/></feMerge></filter>';return g.util.template(b)({dx:a.dx||0,dy:a.dy||0,opacity:c.isFinite(a.opacity)?a.opacity:1,color:a.color||"black",blur:c.isFinite(a.blur)?a.blur:4})},grayscale:function(a){var b=c.isFinite(a.amount)?a.amount:1;return g.util.template('<filter><feColorMatrix type="matrix" values="${a} ${b} ${c} 0 0 ${d} ${e} ${f} 0 0 ${g} ${b} ${h} 0 0 0 0 0 1 0"/></filter>')({a:.2126+.7874*(1-b),b:.7152-.7152*(1-b),c:.0722-.0722*(1-b),d:.2126-.2126*(1-b),e:.7152+.2848*(1-b),f:.0722-.0722*(1-b),g:.2126-.2126*(1-b),h:.0722+.9278*(1-b)})},sepia:function(a){var b=c.isFinite(a.amount)?a.amount:1;return g.util.template('<filter><feColorMatrix type="matrix" values="${a} ${b} ${c} 0 0 ${d} ${e} ${f} 0 0 ${g} ${h} ${i} 0 0 0 0 0 1 0"/></filter>')({a:.393+.607*(1-b),b:.769-.769*(1-b),c:.189-.189*(1-b),d:.349-.349*(1-b),e:.686+.314*(1-b),f:.168-.168*(1-b),g:.272-.272*(1-b),h:.534-.534*(1-b),i:.131+.869*(1-b)})},saturate:function(a){var b=c.isFinite(a.amount)?a.amount:1;return g.util.template('<filter><feColorMatrix type="saturate" values="${amount}"/></filter>')({amount:1-b})},hueRotate:function(a){return g.util.template('<filter><feColorMatrix type="hueRotate" values="${angle}"/></filter>')({angle:a.angle||0})},invert:function(a){var b=c.isFinite(a.amount)?a.amount:1;return g.util.template('<filter><feComponentTransfer><feFuncR type="table" tableValues="${amount} ${amount2}"/><feFuncG type="table" tableValues="${amount} ${amount2}"/><feFuncB type="table" tableValues="${amount} ${amount2}"/></feComponentTransfer></filter>')({amount:b,amount2:1-b})},brightness:function(a){return g.util.template('<filter><feComponentTransfer><feFuncR type="linear" slope="${amount}"/><feFuncG type="linear" slope="${amount}"/><feFuncB type="linear" slope="${amount}"/></feComponentTransfer></filter>')({amount:c.isFinite(a.amount)?a.amount:1})},contrast:function(a){var b=c.isFinite(a.amount)?a.amount:1;return g.util.template('<filter><feComponentTransfer><feFuncR type="linear" slope="${amount}" intercept="${amount2}"/><feFuncG type="linear" slope="${amount}" intercept="${amount2}"/><feFuncB type="linear" slope="${amount}" intercept="${amount2}"/></feComponentTransfer></filter>')({amount:b,amount2:.5-b/2})}},format:{number:function(a,b,c){function d(a){for(var b=a.length,d=[],e=0,f=c.grouping[0];b>0&&f>0;)d.push(a.substring(b-=f,b+f)),f=c.grouping[e=(e+1)%c.grouping.length];return d.reverse().join(c.thousands)}c=c||{currency:["$",""],decimal:".",thousands:",",grouping:[3]};var e=/(?:([^{])?([<>=^]))?([+\- ])?([$#])?(0)?(\d+)?(,)?(\.-?\d+)?([a-z%])?/i,f=e.exec(a),g=f[1]||" ",h=f[2]||">",i=f[3]||"",j=f[4]||"",k=f[5],l=+f[6],m=f[7],n=f[8],o=f[9],p=1,q="",r="",s=!1;switch(n&&(n=+n.substring(1)),(k||"0"===g&&"="===h)&&(k=g="0",h="=",m&&(l-=Math.floor((l-1)/4))),o){case"n":m=!0,o="g";break;case"%":p=100,r="%",o="f";break;case"p":p=100,r="%",o="r";break;case"b":case"o":case"x":case"X":"#"===j&&(q="0"+o.toLowerCase());break;case"c":case"d":s=!0,n=0;break;case"s":p=-1,o="r"}"$"===j&&(q=c.currency[0],r=c.currency[1]),"r"!=o||n||(o="g"),null!=n&&("g"==o?n=Math.max(1,Math.min(21,n)):"e"!=o&&"f"!=o||(n=Math.max(0,Math.min(20,n))));var t=k&&m;if(s&&b%1)return"";var u=b<0||0===b&&1/b<0?(b=-b,"-"):i,v=r;if(p<0){var w=this.prefix(b,n);b=w.scale(b),v=w.symbol+r}else b*=p;b=this.convert(o,b,n);var x=b.lastIndexOf("."),y=x<0?b:b.substring(0,x),z=x<0?"":c.decimal+b.substring(x+1);!k&&m&&c.grouping&&(y=d(y));var A=q.length+y.length+z.length+(t?0:u.length),B=A<l?new Array(A=l-A+1).join(g):"";return t&&(y=d(B+y)),u+=q,b=y+z,("<"===h?u+b+B:">"===h?B+u+b:"^"===h?B.substring(0,A>>=1)+u+b+B.substring(A):u+(t?b:B+b))+v},string:function(a,b){for(var c,d="{",e=!1,f=[];-1!==(c=a.indexOf(d));){var g,h,i;if(g=a.slice(0,c),e){h=g.split(":"),i=h.shift().split("."),g=b;for(var j=0;j<i.length;j++)g=g[i[j]];h.length&&(g=this.number(h,g))}f.push(g),a=a.slice(c+1),d=(e=!e)?"}":"{"}return f.push(a),f.join("")},convert:function(a,b,c){switch(a){case"b":return b.toString(2);case"c":return String.fromCharCode(b);case"o":return b.toString(8);case"x":return b.toString(16);case"X":return b.toString(16).toUpperCase();case"g":return b.toPrecision(c);case"e":return b.toExponential(c);case"f":return b.toFixed(c);case"r":return(b=this.round(b,this.precision(b,c))).toFixed(Math.max(0,Math.min(20,this.precision(b*(1+1e-15),c))));default:return b+""}},round:function(a,b){return b?Math.round(a*(b=Math.pow(10,b)))/b:Math.round(a)},precision:function(a,b){return b-(a?Math.ceil(Math.log(a)/Math.LN10):1)},prefix:function(a,b){var d=c.map(["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"],function(a,b){var c=Math.pow(10,3*Math.abs(8-b));return{scale:b>8?function(a){return a/c}:function(a){return a*c},symbol:a}}),e=0;return a&&(a<0&&(a*=-1),b&&(a=this.round(a,this.precision(a,b))),e=1+Math.floor(1e-12+Math.log(a)/Math.LN10),e=Math.max(-24,Math.min(24,3*Math.floor((e<=0?e+1:e-1)/3)))),d[8+e/3]}},template:function(a){return function(b){return b=b||{},a.replace(/<%= ([^ ]+) %>|\$\{ ?([^\{\} ]+) ?\}|\{\{([^\{\} ]+)\}\}/g,function(a){for(var d=Array.prototype.slice.call(arguments),e=c.find(d.slice(1,4),function(a){return!!a}),f=e.split("."),g=b[f.shift()];!c.isUndefined(g)&&f.length;)g=g[f.shift()];return c.isUndefined(g)?"":g})}},toggleFullScreen:function(a){function b(a,b){for(var d=["webkit","moz","ms","o",""],e=0;e<d.length;e++){var f=d[e],g=f?f+b:b.substr(0,1).toLowerCase()+b.substr(1);if(!c.isUndefined(a[g]))return c.isFunction(a[g])?a[g]():a[g]}}a=a||document.body,b(document,"FullScreen")||b(document,"IsFullScreen")?b(document,"CancelFullScreen"):b(a,"RequestFullScreen")},addClassNamePrefix:function(a){return a?c.map(a.toString().split(" "),function(a){return a.substr(0,g.config.classNamePrefix.length)!==g.config.classNamePrefix&&(a=g.config.classNamePrefix+a),a}).join(" "):a},removeClassNamePrefix:function(a){return a?c.map(a.toString().split(" "),function(a){return a.substr(0,g.config.classNamePrefix.length)===g.config.classNamePrefix&&(a=a.substr(g.config.classNamePrefix.length)),a}).join(" "):a},wrapWith:function(a,b,d){if(c.isString(d)){if(!g.util.wrappers[d])throw new Error('Unknown wrapper: "'+d+'"');d=g.util.wrappers[d]}if(!c.isFunction(d))throw new Error("Wrapper must be a function.");c.each(b,function(b){a[b]=d(a[b])})},wrappers:{cells:function(a){return function(){var b=Array.prototype.slice.call(arguments),d=b.length>0&&c.first(b)||[],e=b.length>1&&c.last(b)||{};return c.isArray(d)||(e instanceof g.dia.Cell?(d=b,e={}):d=c.initial(b)),a.call(this,d,e)}}}}};if(g.mvc.View=b.View.extend({options:{},theme:null,themeClassNamePrefix:g.util.addClassNamePrefix("theme-"),requireSetThemeOverride:!1,defaultTheme:g.config.defaultTheme,constructor:function(a){b.View.call(this,a)},initialize:function(a){this.requireSetThemeOverride=a&&!!a.theme,this.options=c.extend({},this.options,a),c.bindAll(this,"setTheme","onSetTheme","remove","onRemove"),g.mvc.views[this.cid]=this,this.setTheme(this.options.theme||this.defaultTheme),this._ensureElClassName(),this.init()},_ensureElClassName:function(){var a=c.result(this,"className"),b=g.util.addClassNamePrefix(a);this.$el.removeClass(a),this.$el.addClass(b)},init:function(){},onRender:function(){},setTheme:function(a,b){if(b=b||{},!this.theme||!this.requireSetThemeOverride||b.override)return this.removeThemeClassName(),this.addThemeClassName(a),this.onSetTheme(this.theme,a),this.theme=a,this},addThemeClassName:function(a){a=a||this.theme;var b=this.themeClassNamePrefix+a;return this.$el.addClass(b),this},removeThemeClassName:function(a){a=a||this.theme;var b=this.themeClassNamePrefix+a;return this.$el.removeClass(b),this},onSetTheme:function(a,b){},remove:function(){return this.onRemove(),g.mvc.views[this.cid]=null,b.View.prototype.remove.apply(this,arguments),this},onRemove:function(){}}),function(){g.mvc.View._extend=g.mvc.View.extend,g.mvc.View.extend=function(a,b){a=a||{};var c=a.render||this.prototype.render||null;return a.render=function(){return c&&c.apply(this,arguments),this.onRender(),this},g.mvc.View._extend.call(this,a,b)}}(),g.dia.GraphCells=b.Collection.extend({cellNamespace:g.shapes,initialize:function(a,b){b.cellNamespace&&(this.cellNamespace=b.cellNamespace),this.graph=b.graph},model:function(a,b){var c=b.collection,d=c.cellNamespace,e="link"===a.type?g.dia.Link:g.util.getByPath(d,a.type,".")||g.dia.Element,f=new e(a,b);return f.graph=c.graph,f},comparator:function(a){return a.get("z")||0}}),g.dia.Graph=b.Model.extend({_batches:{},initialize:function(a,c){c=c||{};var d=new g.dia.GraphCells([],{model:c.cellModel,cellNamespace:c.cellNamespace,graph:this});b.Model.prototype.set.call(this,"cells",d),d.on("all",this.trigger,this),this.on("change:z",this._sortOnChangeZ,this),this.on("batch:stop",this._onBatchStop,this),this._out={},this._in={},this._nodes={},this._edges={},d.on("add",this._restructureOnAdd,this),d.on("remove",this._restructureOnRemove,this),d.on("reset",this._restructureOnReset,this),d.on("change:source",this._restructureOnChangeSource,this),d.on("change:target",this._restructureOnChangeTarget,this),d.on("remove",this._removeCell,this)},_sortOnChangeZ:function(){this.hasActiveBatch("to-front")||this.hasActiveBatch("to-back")||this.get("cells").sort()},_onBatchStop:function(a){var b=a&&a.batchName;"to-front"!==b&&"to-back"!==b||this.hasActiveBatch(b)||this.get("cells").sort()},_restructureOnAdd:function(a){if(a.isLink()){this._edges[a.id]=!0;var b=a.get("source"),c=a.get("target");b.id&&((this._out[b.id]||(this._out[b.id]={}))[a.id]=!0),c.id&&((this._in[c.id]||(this._in[c.id]={}))[a.id]=!0)}else this._nodes[a.id]=!0},_restructureOnRemove:function(a){if(a.isLink()){delete this._edges[a.id];var b=a.get("source"),c=a.get("target");b.id&&this._out[b.id]&&this._out[b.id][a.id]&&delete this._out[b.id][a.id],c.id&&this._in[c.id]&&this._in[c.id][a.id]&&delete this._in[c.id][a.id]}else delete this._nodes[a.id]},_restructureOnReset:function(a){a=a.models,this._out={},this._in={},this._nodes={},this._edges={},c.each(a,this._restructureOnAdd,this)},_restructureOnChangeSource:function(a){var b=a.previous("source");b.id&&this._out[b.id]&&delete this._out[b.id][a.id];var c=a.get("source");c.id&&((this._out[c.id]||(this._out[c.id]={}))[a.id]=!0)},_restructureOnChangeTarget:function(a){var b=a.previous("target");b.id&&this._in[b.id]&&delete this._in[b.id][a.id];var c=a.get("target");c.id&&((this._in[c.id]||(this._in[c.id]={}))[a.id]=!0)},getOutboundEdges:function(a){return this._out&&this._out[a]||{}},getInboundEdges:function(a){return this._in&&this._in[a]||{}},toJSON:function(){var a=b.Model.prototype.toJSON.apply(this,arguments);return a.cells=this.get("cells").toJSON(),a},fromJSON:function(a,b){if(!a.cells)throw new Error("Graph JSON must contain cells array.");return this.set(a,b)},set:function(a,d,e){var f;return"object"==typeof a?(f=a,e=d):(f={})[a]=d,f.hasOwnProperty("cells")&&(this.resetCells(f.cells,e),f=c.omit(f,"cells")),b.Model.prototype.set.call(this,f,e)},clear:function(a){a=c.extend({},a,{clear:!0});var b=this.get("cells");if(0===b.length)return this;this.startBatch("clear",a);var d=b.sortBy(function(a){return a.isLink()?1:2});do{d.shift().remove(a)}while(d.length>0);return this.stopBatch("clear"),this},_prepareCell:function(a,d){var e;if(a instanceof b.Model?(e=a.attributes,a.graph||d&&d.dry||(a.graph=this)):e=a,!c.isString(e.type))throw new TypeError("dia.Graph: cell type must be a string.");return a},maxZIndex:function(){var a=this.get("cells").last();return a?a.get("z")||0:0},addCell:function(a,d){return c.isArray(a)?this.addCells(a,d):(a instanceof b.Model?a.has("z")||a.set("z",this.maxZIndex()+1):c.isUndefined(a.z)&&(a.z=this.maxZIndex()+1),this.get("cells").add(this._prepareCell(a,d),d||{}),this)},addCells:function(a,b){return a.length&&(a=c.flattenDeep(a),b.position=a.length,this.startBatch("add"),c.each(a,function(a){b.position--,this.addCell(a,b)},this),this.stopBatch("add")),this},resetCells:function(a,b){var d=c.map(a,c.bind(this._prepareCell,this,c,b));return this.get("cells").reset(d,b),this},removeCells:function(a,b){return a.length&&(this.startBatch("remove"),c.invoke(a,"remove",b),this.stopBatch("remove")),this},_removeCell:function(a,b,c){c=c||{},c.clear||(c.disconnectLinks?this.disconnectLinks(a,c):this.removeLinks(a,c)),this.get("cells").remove(a,{silent:!0}),a.graph===this&&(a.graph=null)},getCell:function(a){return this.get("cells").get(a)},getCells:function(){return this.get("cells").toArray()},getElements:function(){return c.map(this._nodes,function(a,b){return this.getCell(b)},this)},getLinks:function(){return c.map(this._edges,function(a,b){return this.getCell(b)},this)},getFirstCell:function(){return this.get("cells").first()},getLastCell:function(){return this.get("cells").last()},getConnectedLinks:function(a,b){b=b||{};var d=b.inbound,e=b.outbound;c.isUndefined(d)&&c.isUndefined(e)&&(d=e=!0);var f=[],g={};if(e&&c.each(this.getOutboundEdges(a.id),function(a,b){g[b]||(f.push(this.getCell(b)),g[b]=!0)},this),d&&c.each(this.getInboundEdges(a.id),function(a,b){g[b]||(f.push(this.getCell(b)),g[b]=!0)},this),b.deep){var h=a.getEmbeddedCells({deep:!0}),i={};c.each(h,function(a){a.isLink()&&(i[a.id]=!0)}),c.each(h,function(a){a.isLink()||(e&&c.each(this.getOutboundEdges(a.id),function(a,b){g[b]||i[b]||(f.push(this.getCell(b)),g[b]=!0)},this),d&&c.each(this.getInboundEdges(a.id),function(a,b){g[b]||i[b]||(f.push(this.getCell(b)),g[b]=!0)},this))},this)}return f},getNeighbors:function(a,b){b=b||{};var d=b.inbound,e=b.outbound;c.isUndefined(d)&&c.isUndefined(e)&&(d=e=!0);var f=c.transform(this.getConnectedLinks(a,b),function(f,g){var h=g.get("source"),i=g.get("target"),j=g.hasLoop(b);if(d&&c.has(h,"id")&&!f[h.id]){var k=this.getCell(h.id);!j&&(!k||k===a||b.deep&&k.isEmbeddedIn(a))||(f[h.id]=k)}if(e&&c.has(i,"id")&&!f[i.id]){var l=this.getCell(i.id);!j&&(!l||l===a||b.deep&&l.isEmbeddedIn(a))||(f[i.id]=l)}},{},this);return c.values(f)},getCommonAncestor:function(){var a=c.map(arguments,function(a){for(var b=[],c=a.get("parent");c;)b.push(c),c=this.getCell(c).get("parent");return b},this);a=c.sortBy(a,"length");var b=c.find(a.shift(),function(b){return c.every(a,function(a){return c.contains(a,b)})});return this.getCell(b)},getSuccessors:function(a,b){b=b||{};var d=[];return this.search(a,function(b){b!==a&&d.push(b)},c.extend({},b,{outbound:!0})),d},cloneCells:function(a){a=c.unique(a);var b=c.transform(a,function(a,b){a[b.id]=b.clone()},{});return c.each(a,function(a){var d=b[a.id];if(d.isLink()){var e=d.get("source"),f=d.get("target");e.id&&b[e.id]&&d.prop("source/id",b[e.id].id),f.id&&b[f.id]&&d.prop("target/id",b[f.id].id)}var g=a.get("parent");g&&b[g]&&d.set("parent",b[g].id);var h=c.reduce(a.get("embeds"),function(a,c){return b[c]&&a.push(b[c].id),a},[]);c.isEmpty(h)||d.set("embeds",h)}),b},cloneSubgraph:function(a,b){var c=this.getSubgraph(a,b);return this.cloneCells(c)},getSubgraph:function(a,b){b=b||{};var d=[],e={},f=[],g=[];return c.each(a,function(a){if(e[a.id]||(d.push(a),e[a.id]=a,a.isLink()?g.push(a):f.push(a)),b.deep){var h=a.getEmbeddedCells({deep:!0});c.each(h,function(a){e[a.id]||(d.push(a),e[a.id]=a,a.isLink()?g.push(a):f.push(a))})}}),c.each(g,function(a){var b=a.get("source"),c=a.get("target");if(b.id&&!e[b.id]){var g=this.getCell(b.id);d.push(g),e[g.id]=g,f.push(g)}if(c.id&&!e[c.id]){var h=this.getCell(c.id);d.push(this.getCell(c.id)),e[h.id]=h,f.push(h)}},this),c.each(f,function(a){var f=this.getConnectedLinks(a,b);c.each(f,function(a){var b=a.get("source"),c=a.get("target");!e[a.id]&&b.id&&e[b.id]&&c.id&&e[c.id]&&(d.push(a),e[a.id]=a)})},this),d},getPredecessors:function(a,b){b=b||{};var d=[];return this.search(a,function(b){b!==a&&d.push(b)},c.extend({},b,{inbound:!0})),d},search:function(a,b,c){c=c||{},c.breadthFirst?this.bfs(a,b,c):this.dfs(a,b,c)},bfs:function(a,b,d){d=d||{};var e={},f={},g=[];for(g.push(a),f[a.id]=0;g.length>0;){var h=g.shift();if(!e[h.id]){if(e[h.id]=!0,!1===b(h,f[h.id]))return;c.each(this.getNeighbors(h,d),function(a){f[a.id]=f[h.id]+1,g.push(a)})}}},dfs:function(a,b,d,e,f){d=d||{};var g=e||{},h=f||0;!1!==b(a,h)&&(g[a.id]=!0,c.each(this.getNeighbors(a,d),function(a){g[a.id]||this.dfs(a,b,d,g,h+1)},this))},getSources:function(){var a=[];return c.each(this._nodes,function(b,d){this._in[d]&&!c.isEmpty(this._in[d])||a.push(this.getCell(d))},this),a},getSinks:function(){var a=[];return c.each(this._nodes,function(b,d){this._out[d]&&!c.isEmpty(this._out[d])||a.push(this.getCell(d))},this),a},isSource:function(a){return!this._in[a.id]||c.isEmpty(this._in[a.id])},isSink:function(a){return!this._out[a.id]||c.isEmpty(this._out[a.id])},isSuccessor:function(a,b){var c=!1;return this.search(a,function(d){if(d===b&&d!==a)return c=!0,!1},{outbound:!0}),c},isPredecessor:function(a,b){var c=!1;return this.search(a,function(d){if(d===b&&d!==a)return c=!0,!1},{inbound:!0}),c},isNeighbor:function(a,b,d){d=d||{};var e=d.inbound,f=d.outbound;c.isUndefined(e)&&c.isUndefined(f)&&(e=f=!0);var g=!1;return c.each(this.getConnectedLinks(a,d),function(a){var d=a.get("source"),h=a.get("target");return e&&c.has(d,"id")&&d.id===b.id?(g=!0,!1):f&&c.has(h,"id")&&h.id===b.id?(g=!0,!1):void 0}),g},disconnectLinks:function(a,b){c.each(this.getConnectedLinks(a),function(c){c.set(c.get("source").id===a.id?"source":"target",f.point(0,0),b)})},removeLinks:function(a,b){c.invoke(this.getConnectedLinks(a),"remove",b)},findModelsFromPoint:function(a){return c.filter(this.getElements(),function(b){return b.getBBox().containsPoint(a)})},findModelsInArea:function(a,b){a=f.rect(a),b=c.defaults(b||{},{strict:!1});var d=b.strict?"containsRect":"intersect";return c.filter(this.getElements(),function(b){return a[d](b.getBBox())})},findModelsUnderElement:function(a,b){b=c.defaults(b||{},{searchBy:"bbox"});var d=a.getBBox(),e="bbox"==b.searchBy?this.findModelsInArea(d):this.findModelsFromPoint(d[b.searchBy]());return c.reject(e,function(b){return a.id==b.id||b.isEmbeddedIn(a)})},getBBox:function(a,b){return this.getCellsBBox(a||this.getElements(),b)},getCellsBBox:function(a,b){return c.reduce(a,function(a,c){return c.isLink()?a:a?a.union(c.getBBox(b)):c.getBBox(b)},null)},translate:function(a,b,d){var e=c.reject(this.getCells(),function(a){return a.isEmbedded()});c.invoke(e,"translate",a,b,d)},resize:function(a,b,c){return this.resizeCells(a,b,this.getCells(),c)},resizeCells:function(a,b,d,e){var f=this.getCellsBBox(d);if(f){var g=Math.max(a/f.width,0),h=Math.max(b/f.height,0);c.invoke(d,"scale",g,h,f.origin(),e)}return this},startBatch:function(a,b){return b=b||{},this._batches[a]=(this._batches[a]||0)+1,this.trigger("batch:start",c.extend({},b,{batchName:a}))},stopBatch:function(a,b){return b=b||{},this._batches[a]=(this._batches[a]||0)-1,this.trigger("batch:stop",c.extend({},b,{batchName:a}))},hasActiveBatch:function(a){return a?this._batches[a]:c.any(this._batches,function(a){return a>0})}}),g.util.wrapWith(g.dia.Graph.prototype,["resetCells","addCells","removeCells"],"cells"),g.dia.Cell=b.Model.extend({constructor:function(a,b){var d,e=a||{};this.cid=c.uniqueId("c"),this.attributes={},b&&b.collection&&(this.collection=b.collection),b&&b.parse&&(e=this.parse(e,b)||{}),(d=c.result(this,"defaults"))&&(e=c.merge({},d,e)),this.set(e,b),this.changed={},this.initialize.apply(this,arguments)},translate:function(a,b,c){throw new Error("Must define a translate() method.")},toJSON:function(){var a=this.constructor.prototype.defaults.attrs||{},b=this.attributes.attrs,d={};c.each(b,function(b,e){var f=a[e];c.each(b,function(a,b){c.isObject(a)&&!c.isArray(a)?c.each(a,function(a,g){f&&f[b]&&c.isEqual(f[b][g],a)||(d[e]=d[e]||{},(d[e][b]||(d[e][b]={}))[g]=a)}):f&&c.isEqual(f[b],a)||(d[e]=d[e]||{},d[e][b]=a)})});var e=c.cloneDeep(c.omit(this.attributes,"attrs"));return e.attrs=d,e},initialize:function(a){a&&a.id||this.set("id",g.util.uuid(),{silent:!0}),this._transitionIds={},this.processPorts(),this.on("change:attrs",this.processPorts,this)},processPorts:function(){var a=this.ports,b={};c.each(this.get("attrs"),function(a,d){a&&a.port&&(c.isUndefined(a.port.id)?b[a.port]={id:a.port}:b[a.port.id]=a.port)});var d={};if(c.each(a,function(a,c){b[c]||(d[c]=!0)}),this.graph&&!c.isEmpty(d)){var e=this.graph.getConnectedLinks(this,{inbound:!0});c.each(e,function(a){d[a.get("target").port]&&a.remove()});var f=this.graph.getConnectedLinks(this,{outbound:!0});c.each(f,function(a){d[a.get("source").port]&&a.remove()})}this.ports=b},remove:function(a){a=a||{};var b=this.graph;b&&b.startBatch("remove");var d=this.get("parent");if(d){(b&&b.getCell(d)).unembed(this)}return c.invoke(this.getEmbeddedCells(),"remove",a),this.trigger("remove",this,this.collection,a),b&&b.stopBatch("remove"),this},toFront:function(a){if(this.graph){a=a||{};var b=(this.graph.getLastCell().get("z")||0)+1;if(this.startBatch("to-front").set("z",b,a),a.deep){var d=this.getEmbeddedCells({deep:!0,breadthFirst:!0});c.each(d,function(c){c.set("z",++b,a)})}this.stopBatch("to-front")}return this},toBack:function(a){if(this.graph){a=a||{};var b=(this.graph.getFirstCell().get("z")||0)-1;if(this.startBatch("to-back"),a.deep){var d=this.getEmbeddedCells({deep:!0,breadthFirst:!0});c.eachRight(d,function(c){c.set("z",b--,a)})}this.set("z",b,a).stopBatch("to-back")}return this},embed:function(a,b){if(this===a||this.isEmbeddedIn(a))throw new Error("Recursive embedding not allowed.");this.startBatch("embed");var d=c.clone(this.get("embeds")||[]);return d[a.isLink()?"unshift":"push"](a.id),a.set("parent",this.id,b),this.set("embeds",c.uniq(d),b),this.stopBatch("embed"),this},unembed:function(a,b){return this.startBatch("unembed"),a.unset("parent",b),this.set("embeds",c.without(this.get("embeds"),a.id),b),this.stopBatch("unembed"),this},getAncestors:function(){var a=[],b=this.get("parent");if(!this.graph)return a;for(;void 0!==b;){var c=this.graph.getCell(b);if(void 0===c)break;a.push(c),b=c.get("parent")}return a},getEmbeddedCells:function(a){if(a=a||{},this.graph){var b;if(a.deep)if(a.breadthFirst){b=[];for(var d=this.getEmbeddedCells();d.length>0;){var e=d.shift();b.push(e),d.push.apply(d,e.getEmbeddedCells())}}else b=this.getEmbeddedCells(),c.each(b,function(c){b.push.apply(b,c.getEmbeddedCells(a))});else b=c.map(this.get("embeds"),this.graph.getCell,this.graph);return b}return[]},isEmbeddedIn:function(a,b){var d=c.isString(a)?a:a.id,e=this.get("parent");if(b=c.defaults({deep:!0},b),this.graph&&b.deep){for(;e;){if(e===d)return!0;e=this.graph.getCell(e).get("parent")}return!1}return e===d},isEmbedded:function(){return!!this.get("parent")},clone:function(a){if(a=a||{},a.deep)return c.values(g.dia.Graph.prototype.cloneCells.call(null,[this].concat(this.getEmbeddedCells({deep:!0}))));var d=b.Model.prototype.clone.apply(this,arguments);return d.set("id",g.util.uuid()),d.unset("embeds"),d.unset("parent"),d},prop:function(a,b,d){if(c.isString(a)){if(arguments.length>1){var e=a,f=e.split("/"),h=f[0];if(f.shift(),d=d||{},d.propertyPath=e,d.propertyValue=b,0===f.length)return this.set(h,b,d);var i={},j=i,k=h;c.each(f,function(a){j=j[k]=c.isFinite(Number(a))?[]:{},k=a}),i=g.util.setByPath(i,e,b,"/");var l=c.merge({},this.attributes);d.rewrite&&g.util.unsetByPath(l,e,"/");var m=c.merge(l,i);return this.set(h,m[h],d)}return g.util.getByPath(this.attributes,a,"/")}return this.set(c.merge({},this.attributes,a),b)},removeProp:function(a,b){b=b||{},b.dirty=!0;var d=a.split("/");if(1===d.length)return this.unset(a,b);var e=d[0],f=d.slice(1).join("/"),h=c.merge({},this.get(e));return g.util.unsetByPath(h,f,"/"),this.set(e,h,b)},attr:function(a,b,d){var e=Array.prototype.slice.call(arguments);return c.isString(a)?e[0]="attrs/"+a:e[0]={attrs:a},this.prop.apply(this,e)},removeAttr:function(a,b){
return c.isArray(a)?(c.each(a,function(a){this.removeAttr(a,b)},this),this):this.removeProp("attrs/"+a,b)},transition:function(a,b,d,e){e=e||"/";var f={duration:100,delay:10,timingFunction:g.util.timing.linear,valueFunction:g.util.interpolate.number};d=c.extend(f,d);var h,i=0,j=c.bind(function(b){var c,e,f;i=i||b,b-=i,e=b/d.duration,e<1?this._transitionIds[a]=c=g.util.nextFrame(j):(e=1,delete this._transitionIds[a]),f=h(d.timingFunction(e)),d.transitionId=c,this.prop(a,f,d),c||this.trigger("transition:end",this,a)},this),k=c.bind(function(c){this.stopTransitions(a),h=d.valueFunction(g.util.getByPath(this.attributes,a,e),b),this._transitionIds[a]=g.util.nextFrame(c),this.trigger("transition:start",this,a)},this);return c.delay(k,d.delay,j)},getTransitions:function(){return c.keys(this._transitionIds)},stopTransitions:function(a,b){b=b||"/";var d=a&&a.split(b);return c(this._transitionIds).keys().filter(d&&function(a){return c.isEqual(d,a.split(b).slice(0,d.length))}).each(function(a){g.util.cancelFrame(this._transitionIds[a]),delete this._transitionIds[a],this.trigger("transition:end",this,a)},this),this},addTo:function(a,b){return a.addCell(this,b),this},findView:function(a){return a.findViewByModel(this)},isElement:function(){return!1},isLink:function(){return!1},startBatch:function(a,b){return this.graph&&this.graph.startBatch(a,c.extend({},b,{cell:this})),this},stopBatch:function(a,b){return this.graph&&this.graph.stopBatch(a,c.extend({},b,{cell:this})),this}}),g.dia.CellView=g.mvc.View.extend({tagName:"g",className:function(){var a=["cell"],b=this.model.get("type");return b&&c.each(b.toLowerCase().split("."),function(b,c,d){a.push("type-"+d.slice(0,c+1).join("-"))}),a.join(" ")},attributes:function(){return{"model-id":this.model.id}},constructor:function(a){a.id=a.id||g.util.guid(this),g.mvc.View.call(this,a)},init:function(){c.bindAll(this,"remove","update"),this.$el.data("view",this),this.$el.attr("data-type",this.model.get("type")),this.listenTo(this.model,"change:attrs",this.onChangeAttrs)},onChangeAttrs:function(a,b,c){return c.dirty?this.render():this.update(a,b,c)},can:function(a){var b=c.isFunction(this.options.interactive)?this.options.interactive(this):this.options.interactive;return c.isObject(b)&&!1!==b[a]||c.isBoolean(b)&&!1!==b},_ensureElement:function(){var a;if(this.el)a=c.result(this,"el");else{var b=c.extend({id:this.id},c.result(this,"attributes"));this.className&&(b.class=c.result(this,"className")),a=e(c.result(this,"tagName"),b).node}this.setElement(a,!1)},_setElement:function(a){this.$el=a instanceof b.$?a:b.$(a),this.el=this.$el[0],this.vel=e(this.el)},findBySelector:function(a){return"."===a?this.$el:this.$el.find(a)},notify:function(a){if(this.paper){var b=Array.prototype.slice.call(arguments,1);this.trigger.apply(this,[a].concat(b)),this.paper.trigger.apply(this.paper,[a,this].concat(b))}},getStrokeBBox:function(a){var b=!!a;a=a||this.el;var c,d=e(a).bbox(!1,this.paper.viewport);return c=b?e(a).attr("stroke-width"):this.model.attr("rect/stroke-width")||this.model.attr("circle/stroke-width")||this.model.attr("ellipse/stroke-width")||this.model.attr("path/stroke-width"),c=parseFloat(c)||0,f.rect(d).moveAndExpand({x:-c/2,y:-c/2,width:c,height:c})},getBBox:function(){return f.rect(this.vel.bbox())},highlight:function(a,b){return a=a?this.$(a)[0]||this.el:this.el,b=b||{},b.partial=a!==this.el,this.notify("cell:highlight",a,b),this},unhighlight:function(a,b){return a=a?this.$(a)[0]||this.el:this.el,b=b||{},b.partial=a!=this.el,this.notify("cell:unhighlight",a,b),this},findMagnet:function(a){var b=this.$(a),c=this.$el;0===b.length&&(b=c);do{var d=b.attr("magnet");if((d||b.is(c))&&"false"!==d)return b[0];b=b.parent()}while(b.length>0)},applyFilter:function(a,b){var f=c.isString(a)?this.findBySelector(a):d(a),h=b.name+this.paper.svg.id+g.util.hashCode(JSON.stringify(b));if(!this.paper.svg.getElementById(h)){var i=g.util.filter[b.name]&&g.util.filter[b.name](b.args||{});if(!i)throw new Error("Non-existing filter "+b.name);var j=e(i);j.attr({filterUnits:"objectBoundingBox",x:-1,y:-1,width:3,height:3}),b.attrs&&j.attr(b.attrs),j.node.id=h,e(this.paper.svg).defs().append(j)}f.each(function(){e(this).attr("filter","url(#"+h+")")})},applyGradient:function(a,b,f){var h=c.isString(a)?this.findBySelector(a):d(a),i=f.type+this.paper.svg.id+g.util.hashCode(JSON.stringify(f));if(!this.paper.svg.getElementById(i)){var j=["<"+f.type+">",c.map(f.stops,function(a){return'<stop offset="'+a.offset+'" stop-color="'+a.color+'" stop-opacity="'+(c.isFinite(a.opacity)?a.opacity:1)+'" />'}).join(""),"</"+f.type+">"].join(""),k=e(j);f.attrs&&k.attr(f.attrs),k.node.id=i,e(this.paper.svg).defs().append(k)}h.each(function(){e(this).attr(b,"url(#"+i+")")})},getSelector:function(a,b){if(a===this.el)return b;var c;if(a){var d=e(a).index()+1;c=a.tagName+":nth-child("+d+")",b&&(c+=" > "+b),c=this.getSelector(a.parentNode,c)}return c},pointerdblclick:function(a,b,c){this.notify("cell:pointerdblclick",a,b,c)},pointerclick:function(a,b,c){this.notify("cell:pointerclick",a,b,c)},pointerdown:function(a,b,c){this.model.graph&&(this.model.startBatch("pointer"),this._graph=this.model.graph),this.notify("cell:pointerdown",a,b,c)},pointermove:function(a,b,c){this.notify("cell:pointermove",a,b,c)},pointerup:function(a,b,c){this.notify("cell:pointerup",a,b,c),this._graph&&(this._graph.stopBatch("pointer",{cell:this.model}),delete this._graph)},mouseover:function(a){this.notify("cell:mouseover",a)},mouseout:function(a){this.notify("cell:mouseout",a)},mousewheel:function(a,b,c,d){this.notify("cell:mousewheel",a,b,c,d)},contextmenu:function(a,b,c){this.notify("cell:contextmenu",a,b,c)},setInteractivity:function(a){this.options.interactive=a}}),g.dia.Element=g.dia.Cell.extend({defaults:{position:{x:0,y:0},size:{width:1,height:1},angle:0},initialize:function(){this._initializePorts(),g.dia.Cell.prototype.initialize.apply(this,arguments)},_initializePorts:function(){},isElement:function(){return!0},position:function(a,b,d){var e=c.isNumber(b);if(d=(e?d:a)||{},d.parentRelative){if(!this.graph)throw new Error("Element must be part of a graph.");var g=this.graph.getCell(this.get("parent")),h=g&&!g.isLink()?g.get("position"):{x:0,y:0}}if(e)return d.parentRelative&&(a+=h.x,b+=h.y),this.set("position",{x:a,y:b},d);var i=f.point(this.get("position"));return d.parentRelative?i.difference(h):i},translate:function(a,b,d){if(a=a||0,b=b||0,0===a&&0===b)return this;d=d||{},d.translateBy=d.translateBy||this.id;var e=this.get("position")||{x:0,y:0};if(d.restrictedArea&&d.translateBy===this.id){var f=this.getBBox({deep:!0}),h=d.restrictedArea,i=e.x-f.x,j=e.y-f.y,k=Math.max(h.x+i,Math.min(h.x+h.width+i-f.width,e.x+a)),l=Math.max(h.y+j,Math.min(h.y+h.height+j-f.height,e.y+b));a=k-e.x,b=l-e.y}var m={x:e.x+a,y:e.y+b};return d.tx=a,d.ty=b,d.transition?(c.isObject(d.transition)||(d.transition={}),this.transition("position",m,c.extend({},d.transition,{valueFunction:g.util.interpolate.object}))):this.set("position",m,d),c.invoke(this.getEmbeddedCells(),"translate",a,b,d),this},resize:function(a,b,c){if(c=c||{},this.startBatch("resize",c),c.direction){var d=this.get("size");switch(c.direction){case"left":case"right":b=d.height;break;case"top":case"bottom":a=d.width}var e=f.normalizeAngle(this.get("angle")||0),g={"top-right":0,right:0,"top-left":1,top:1,"bottom-left":2,left:2,"bottom-right":3,bottom:3}[c.direction];c.absolute&&(g+=Math.floor((e+45)/90),g%=4);var h=this.getBBox(),i=h[["bottomLeft","corner","topRight","origin"][g]](),j=f.point(i).rotate(h.center(),-e),k=Math.sqrt(a*a+b*b)/2,l=g*Math.PI/2;l+=Math.atan(g%2==0?b/a:a/b),l-=f.toRad(e);var m=f.point.fromPolar(k,l,j),n=f.point(m).offset(a/-2,b/-2);this.set("size",{width:a,height:b},c),this.position(n.x,n.y,c)}else this.set("size",{width:a,height:b},c);return this.stopBatch("resize",c),this},scale:function(a,b,c,d){var e=this.getBBox().scale(a,b,c);return this.startBatch("scale",d),this.position(e.x,e.y,d),this.resize(e.width,e.height,d),this.stopBatch("scale"),this},fitEmbeds:function(a){if(a=a||{},!this.graph)throw new Error("Element must be part of a graph.");var b=this.getEmbeddedCells();if(b.length>0){this.startBatch("fit-embeds",a),a.deep&&c.invoke(b,"fitEmbeds",a);var d=this.graph.getCellsBBox(b),e=g.util.normalizeSides(a.padding);d.moveAndExpand({x:-e.left,y:-e.top,width:e.right+e.left,height:e.bottom+e.top}),this.set({position:{x:d.x,y:d.y},size:{width:d.width,height:d.height}},a),this.stopBatch("fit-embeds")}return this},rotate:function(a,b,d,e){if(d){var f=this.getBBox().center(),g=this.get("size"),h=this.get("position");f.rotate(d,this.get("angle")-a);var i=f.x-g.width/2-h.x,j=f.y-g.height/2-h.y;this.startBatch("rotate",{angle:a,absolute:b,origin:d}),this.translate(i,j,c.clone(e)),this.rotate(a,b,null,e),this.stopBatch("rotate")}else this.set("angle",b?a:(this.get("angle")+a)%360,e);return this},getBBox:function(a){if(a=a||{},a.deep&&this.graph){var b=this.getEmbeddedCells({deep:!0,breadthFirst:!0});return b.push(this),this.graph.getCellsBBox(b)}var c=this.get("position"),d=this.get("size");return f.rect(c.x,c.y,d.width,d.height)}}),g.dia.ElementView=g.dia.CellView.extend({SPECIAL_ATTRIBUTES:["style","text","html","ref-x","ref-y","ref-dx","ref-dy","ref-width","ref-height","ref","x-alignment","y-alignment","port"],_removePorts:function(){},_renderPorts:function(){},className:function(){var a=g.dia.CellView.prototype.className.apply(this).split(" ");return a.push("element"),a.join(" ")},initialize:function(){g.dia.CellView.prototype.initialize.apply(this,arguments);var a=this.model;this.listenTo(a,"change:position",this.translate),this.listenTo(a,"change:size",this.resize),this.listenTo(a,"change:angle",this.rotate),this.listenTo(a,"change:markup",this.render),this._initializePorts()},_initializePorts:function(){},updateAttr:function(a,b){var f=this.SPECIAL_ATTRIBUTES.slice();c.isObject(b.filter)&&(f.push("filter"),this.applyFilter(a,b.filter)),c.isObject(b.fill)&&(f.push("fill"),this.applyGradient(a,"fill",b.fill)),c.isObject(b.stroke)&&(f.push("stroke"),this.applyGradient(a,"stroke",b.stroke)),c.isUndefined(b.text)||(a.each(function(){c.isUndefined(b.x)||(e(this).attr("x",b.x),f.push("x")),c.isUndefined(b.y)||(e(this).attr("y",b.y),f.push("y")),e(this).text(b.text+"",{lineHeight:b.lineHeight,textPath:b.textPath,annotations:b.annotations})}),f.push("lineHeight","textPath","annotations"));var g=c.omit(b,f);a.each(function(){e(this).attr(g)}),b.port&&a.attr("port",c.isUndefined(b.port.id)?b.port:b.port.id),b.style&&a.css(b.style),c.isUndefined(b.html)||a.each(function(){d(this).html(b.html+"")})},update:function(a,b){this._removePorts();var d=this.model.get("attrs"),f=this.rotatableNode;if(f){var g=f.attr("transform");f.attr("transform","")}var h=[],i={};c.each(b||d,function(a,b){var d="."===b?this.$el:this.findBySelector(b),e=d.length;if(0!==e&&(i[b]=d,this.updateAttr(d,a),!(c.isUndefined(a["ref-x"])&&c.isUndefined(a["ref-y"])&&c.isUndefined(a["ref-dx"])&&c.isUndefined(a["ref-dy"])&&c.isUndefined(a["x-alignment"])&&c.isUndefined(a["y-alignment"])&&c.isUndefined(a["ref-width"])&&c.isUndefined(a["ref-height"]))))for(var f=0;f<e;f++){var g=d.eq(f);g.selector=b,h.push(g)}},this);var j=this.model.get("size"),k={x:0,y:0,width:j.width,height:j.height};b=b||{},c.each(h,function(a){var f=b[a.selector],g=f?c.merge({},d[a.selector],f):d[a.selector];this.positionRelative(e(a[0]),k,g,i)},this),f&&f.attr("transform",g||""),this._renderPorts()},positionRelative:function(a,b,d,f){var g=d.ref,h=parseFloat(d["ref-dx"]),i=parseFloat(d["ref-dy"]),j=d["y-alignment"],k=d["x-alignment"],l=d["ref-y"],m=c.isString(l)&&"%"===l.slice(-1);l=parseFloat(l),m&&(l/=100);var n=d["ref-x"],o=c.isString(n)&&"%"===n.slice(-1);n=parseFloat(n),o&&(n/=100);var p=d["ref-width"],q=c.isString(p)&&"%"===p.slice(-1);p=parseFloat(p),q&&(p/=100);var r=d["ref-height"],s=c.isString(r)&&"%"===r.slice(-1);r=parseFloat(r),s&&(r/=100);var t=a.findParentByClass("scalable",this.el);if(g){var u;if(!(u=f&&f[g]?e(f[g][0]):"."===g?this.vel:this.vel.findOne(g)))throw new Error("dia.ElementView: reference does not exists.");b=u.bbox(!1,this.el)}a.attr("transform")&&a.attr("transform",a.attr("transform").replace(/translate\([^)]*\)/g,"").trim()||""),isFinite(p)&&(q||p>=0&&p<=1?a.attr("width",p*b.width):a.attr("width",Math.max(p+b.width,0))),isFinite(r)&&(s||r>=0&&r<=1?a.attr("height",r*b.height):a.attr("height",Math.max(r+b.height,0)));var v,w=0,x=0;if(isFinite(h)&&(t?(v=v||t.scale(),w=b.x+b.width+h/v.sx):w=b.x+b.width+h),isFinite(i)&&(t?(v=v||t.scale(),x=b.y+b.height+i/v.sy):x=b.y+b.height+i),isFinite(n)&&(o||n>0&&n<1?w=b.x+b.width*n:t?(v=v||t.scale(),w=b.x+n/v.sx):w=b.x+n),isFinite(l)&&(m||l>0&&l<1?x=b.y+b.height*l:t?(v=v||t.scale(),x=b.y+l/v.sy):x=b.y+l),!c.isUndefined(j)||!c.isUndefined(k)){var y=a.node,z=a.bbox(!1,y.parentNode),A=y.nodeName.toUpperCase();"TEXT"!==A&&"TSPAN"!==A||(z.height+=z.y,z.width+=z.x),t&&(v=v||t.scale(),z.width*=v.sx,z.height*=v.sy),"middle"===j?x-=z.height/2:"bottom"===j?x-=z.height:isFinite(j)&&(x+=j>-1&&j<1?z.height*j:j),"middle"===k?w-=z.width/2:"right"===k?w-=z.width:isFinite(k)&&(w+=k>-1&&k<1?z.width*k:k)}a.translate(w,x)},renderMarkup:function(){var a=this.model.get("markup")||this.model.markup;if(!a)throw new Error("properties.markup is missing while the default render() implementation is used.");var b=g.util.template(a)(),c=e(b);this.vel.append(c)},render:function(){return this.$el.empty(),this.renderMarkup(),this.rotatableNode=this.vel.findOne(".rotatable"),this.scalableNode=this.vel.findOne(".scalable"),this.update(),this.resize(),this.rotate(),this.translate(),this},scale:function(a,b){this.vel.scale(a,b)},resize:function(a,b,c){var d=this.model,e=d.get("size")||{width:1,height:1},f=d.get("angle")||0,g=this.scalableNode;if(!g)return 0!==f&&this.rotate(),void this.update();var h=g.bbox(!0);g.attr("transform","scale("+e.width/(h.width||1)+","+e.height/(h.height||1)+")");var i=this.rotatableNode,j=i&&i.attr("transform");if(j&&"null"!==j){i.attr("transform",j+" rotate("+-f+","+e.width/2+","+e.height/2+")");var k=g.bbox(!1,this.paper.viewport);d.set("position",{x:k.x,y:k.y},c),this.rotate()}this.update()},translate:function(a,b,c){var d=this.model.get("position")||{x:0,y:0};this.vel.attr("transform","translate("+d.x+","+d.y+")")},rotate:function(){var a=this.rotatableNode;if(a){var b=this.model.get("angle")||0,c=this.model.get("size")||{width:1,height:1},d=c.width/2,e=c.height/2;0!==b?a.attr("transform","rotate("+b+","+d+","+e+")"):a.removeAttr("transform")}},getBBox:function(a){if(a&&a.useModelGeometry){var b=this.model.getBBox().bbox(this.model.get("angle")),c=this.paper.viewport.getCTM();return f.rect(e.transformRect(b,c))}return g.dia.CellView.prototype.getBBox.apply(this,arguments)},prepareEmbedding:function(a){a=a||{};var b=a.model||this.model,d=a.paper||this.paper,e=d.model;b.startBatch("to-front",a),b.toFront({deep:!0,ui:!0});var f=e.get("cells").max("z").get("z"),g=e.getConnectedLinks(b,{deep:!0});c.invoke(g,"set","z",f+1,{ui:!0}),b.stopBatch("to-front");var h=b.get("parent");h&&e.getCell(h).unembed(b,{ui:!0})},processEmbedding:function(a){a=a||{};var b=a.model||this.model,c=a.paper||this.paper,d=c.options,e=c.model.findModelsUnderElement(b,{searchBy:d.findParentBy});d.frontParentOnly&&(e=e.slice(-1));for(var f=null,g=this._candidateEmbedView,h=e.length-1;h>=0;h--){var i=e[h];if(g&&g.model.id==i.id){f=g;break}var j=i.findView(c);if(d.validateEmbedding.call(c,this,j)){f=j;break}}f&&f!=g&&(this.clearEmbedding(),this._candidateEmbedView=f.highlight(null,{embedding:!0})),!f&&g&&this.clearEmbedding()},clearEmbedding:function(){var a=this._candidateEmbedView;a&&(a.unhighlight(null,{embedding:!0}),this._candidateEmbedView=null)},finalizeEmbedding:function(a){a=a||{};var b=this._candidateEmbedView,d=a.model||this.model,e=a.paper||this.paper;b&&(b.model.embed(d,{ui:!0}),b.unhighlight(null,{embedding:!0}),delete this._candidateEmbedView),c.invoke(e.model.getConnectedLinks(d,{deep:!0}),"reparent",{ui:!0})},pointerdown:function(a,b,c){var d=this.paper;if(a.target.getAttribute("magnet")&&this.can("addLinkFromMagnet")&&d.options.validateMagnet.call(d,this,a.target)){this.model.startBatch("add-link");var e=d.getDefaultLink(this,a.target);e.set({source:{id:this.model.id,selector:this.getSelector(a.target),port:a.target.getAttribute("port")},target:{x:b,y:c}}),d.model.addCell(e);var f=this._linkView=d.findViewByModel(e);f.pointerdown(a,b,c),f.startArrowheadMove("target",{whenNotAllowed:"remove"})}else this._dx=b,this._dy=c,this.restrictedArea=d.getRestrictedArea(this),g.dia.CellView.prototype.pointerdown.apply(this,arguments),this.notify("element:pointerdown",a,b,c)},pointermove:function(a,b,c){if(this._linkView)this._linkView.pointermove(a,b,c);else{var d=this.paper.options.gridSize;if(this.can("elementMove")){var e=this.model.get("position"),h=f.snapToGrid(e.x,d)-e.x+f.snapToGrid(b-this._dx,d),i=f.snapToGrid(e.y,d)-e.y+f.snapToGrid(c-this._dy,d);this.model.translate(h,i,{restrictedArea:this.restrictedArea,ui:!0}),this.paper.options.embeddingMode&&(this._inProcessOfEmbedding||(this.prepareEmbedding(),this._inProcessOfEmbedding=!0),this.processEmbedding())}this._dx=f.snapToGrid(b,d),this._dy=f.snapToGrid(c,d),g.dia.CellView.prototype.pointermove.apply(this,arguments),this.notify("element:pointermove",a,b,c)}},pointerup:function(a,b,c){this._linkView?(this._linkView.pointerup(a,b,c),this._linkView=null,this.model.stopBatch("add-link")):(this._inProcessOfEmbedding&&(this.finalizeEmbedding(),this._inProcessOfEmbedding=!1),this.notify("element:pointerup",a,b,c),g.dia.CellView.prototype.pointerup.apply(this,arguments))}}),g.dia.Link=g.dia.Cell.extend({markup:['<path class="connection" stroke="black" d="M 0 0 0 0"/>','<path class="marker-source" fill="black" stroke="black" d="M 0 0 0 0"/>','<path class="marker-target" fill="black" stroke="black" d="M 0 0 0 0"/>','<path class="connection-wrap" d="M 0 0 0 0"/>','<g class="labels"/>','<g class="marker-vertices"/>','<g class="marker-arrowheads"/>','<g class="link-tools"/>'].join(""),labelMarkup:['<g class="label">',"<rect />","<text />","</g>"].join(""),toolMarkup:['<g class="link-tool">','<g class="tool-remove" event="remove">','<circle r="11" />','<path transform="scale(.8) translate(-16, -16)" d="M24.778,21.419 19.276,15.917 24.777,10.415 21.949,7.585 16.447,13.087 10.945,7.585 8.117,10.415 13.618,15.917 8.116,21.419 10.946,24.248 16.447,18.746 21.948,24.248z" />',"<title>Remove link.</title>","</g>",'<g class="tool-options" event="link:options">','<circle r="11" transform="translate(25)"/>','<path fill="white" transform="scale(.55) translate(29, -16)" d="M31.229,17.736c0.064-0.571,0.104-1.148,0.104-1.736s-0.04-1.166-0.104-1.737l-4.377-1.557c-0.218-0.716-0.504-1.401-0.851-2.05l1.993-4.192c-0.725-0.91-1.549-1.734-2.458-2.459l-4.193,1.994c-0.647-0.347-1.334-0.632-2.049-0.849l-1.558-4.378C17.165,0.708,16.588,0.667,16,0.667s-1.166,0.041-1.737,0.105L12.707,5.15c-0.716,0.217-1.401,0.502-2.05,0.849L6.464,4.005C5.554,4.73,4.73,5.554,4.005,6.464l1.994,4.192c-0.347,0.648-0.632,1.334-0.849,2.05l-4.378,1.557C0.708,14.834,0.667,15.412,0.667,16s0.041,1.165,0.105,1.736l4.378,1.558c0.217,0.715,0.502,1.401,0.849,2.049l-1.994,4.193c0.725,0.909,1.549,1.733,2.459,2.458l4.192-1.993c0.648,0.347,1.334,0.633,2.05,0.851l1.557,4.377c0.571,0.064,1.148,0.104,1.737,0.104c0.588,0,1.165-0.04,1.736-0.104l1.558-4.377c0.715-0.218,1.399-0.504,2.049-0.851l4.193,1.993c0.909-0.725,1.733-1.549,2.458-2.458l-1.993-4.193c0.347-0.647,0.633-1.334,0.851-2.049L31.229,17.736zM16,20.871c-2.69,0-4.872-2.182-4.872-4.871c0-2.69,2.182-4.872,4.872-4.872c2.689,0,4.871,2.182,4.871,4.872C20.871,18.689,18.689,20.871,16,20.871z"/>',"<title>Link options.</title>","</g>","</g>"].join(""),vertexMarkup:['<g class="marker-vertex-group" transform="translate(<%= x %>, <%= y %>)">','<circle class="marker-vertex" idx="<%= idx %>" r="10" />','<path class="marker-vertex-remove-area" idx="<%= idx %>" d="M16,5.333c-7.732,0-14,4.701-14,10.5c0,1.982,0.741,3.833,2.016,5.414L2,25.667l5.613-1.441c2.339,1.317,5.237,2.107,8.387,2.107c7.732,0,14-4.701,14-10.5C30,10.034,23.732,5.333,16,5.333z" transform="translate(5, -33)"/>','<path class="marker-vertex-remove" idx="<%= idx %>" transform="scale(.8) translate(9.5, -37)" d="M24.778,21.419 19.276,15.917 24.777,10.415 21.949,7.585 16.447,13.087 10.945,7.585 8.117,10.415 13.618,15.917 8.116,21.419 10.946,24.248 16.447,18.746 21.948,24.248z">',"<title>Remove vertex.</title>","</path>","</g>"].join(""),arrowheadMarkup:['<g class="marker-arrowhead-group marker-arrowhead-group-<%= end %>">','<path class="marker-arrowhead" end="<%= end %>" d="M 26 0 L 0 13 L 26 26 z" />',"</g>"].join(""),defaults:{type:"link",source:{},target:{}},isLink:function(){return!0},disconnect:function(){return this.set({source:f.point(0,0),target:f.point(0,0)})},label:function(a,b){a=a||0;var d=this.get("labels")||[];if(0===arguments.length||1===arguments.length)return d[a];var e=c.merge({},d[a],b),f=d.slice();return f[a]=e,this.set({labels:f})},translate:function(a,b,c){return c=c||{},c.translateBy=c.translateBy||this.id,c.tx=a,c.ty=b,this.applyToPoints(function(c){return{x:(c.x||0)+a,y:(c.y||0)+b}},c)},scale:function(a,b,c,d){return this.applyToPoints(function(d){return f.point(d).scale(a,b,c).toJSON()},d)},applyToPoints:function(a,b){if(!c.isFunction(a))throw new TypeError("dia.Link: applyToPoints expects its first parameter to be a function.");var d={},e=this.get("source");e.id||(d.source=a(e));var f=this.get("target");f.id||(d.target=a(f));var g=this.get("vertices");return g&&g.length>0&&(d.vertices=c.map(g,a)),this.set(d,b)},reparent:function(a){var b;if(this.graph){var c=this.graph.getCell(this.get("source").id),d=this.graph.getCell(this.get("target").id),e=this.graph.getCell(this.get("parent"));c&&d&&(b=this.graph.getCommonAncestor(c,d)),!e||b&&b.id===e.id||e.unembed(this,a),b&&b.embed(this,a)}return b},hasLoop:function(a){a=a||{};var b=this.get("source").id,c=this.get("target").id;if(!b||!c)return!1;var d=b===c;if(!d&&a.deep&&this.graph){var e=this.graph.getCell(b),f=this.graph.getCell(c);d=e.isEmbeddedIn(f)||f.isEmbeddedIn(e)}return d},getSourceElement:function(){var a=this.get("source");return a&&a.id&&this.graph&&this.graph.getCell(a.id)||null},getTargetElement:function(){var a=this.get("target");return a&&a.id&&this.graph&&this.graph.getCell(a.id)||null},getRelationshipAncestor:function(){var a;if(this.graph){var b=c.compact([this,this.getSourceElement(),this.getTargetElement()]);a=this.graph.getCommonAncestor.apply(this.graph,b)}return a||null},isRelationshipEmbeddedIn:function(a){var b=c.isString(a)?a:a.id,d=this.getRelationshipAncestor();return!!d&&(d.id===b||d.isEmbeddedIn(b))}},{endsEqual:function(a,b){var c=a.port===b.port||!a.port&&!b.port;return a.id===b.id&&c}}),g.dia.LinkView=g.dia.CellView.extend({className:function(){var a=g.dia.CellView.prototype.className.apply(this).split(" ");return a.push("link"),a.join(" ")},options:{shortLinkLength:100,doubleLinkTools:!1,longLinkLength:160,linkToolsOffset:40,doubleLinkToolsOffset:60,sampleInterval:50},_z:null,initialize:function(a){g.dia.CellView.prototype.initialize.apply(this,arguments),"function"!=typeof this.constructor.prototype.watchSource&&(this.constructor.prototype.watchSource=this.createWatcher("source"),this.constructor.prototype.watchTarget=this.createWatcher("target")),this._labelCache={},this._markerCache={},this.startListening()},startListening:function(){var a=this.model;this.listenTo(a,"change:markup",this.render),this.listenTo(a,"change:smooth change:manhattan change:router change:connector",this.update),this.listenTo(a,"change:toolMarkup",this.onToolsChange),this.listenTo(a,"change:labels change:labelMarkup",this.onLabelsChange),this.listenTo(a,"change:vertices change:vertexMarkup",this.onVerticesChange),this.listenTo(a,"change:source",this.onSourceChange),this.listenTo(a,"change:target",this.onTargetChange)},onSourceChange:function(a,b,c){this.watchSource(a,b),c.translateBy&&this.model.get("target").id||(c.updateConnectionOnly=!0,this.update(this.model,null,c))},onTargetChange:function(a,b,c){this.watchTarget(a,b),c.translateBy||(c.updateConnectionOnly=!0,this.update(this.model,null,c))},onVerticesChange:function(a,b,c){this.renderVertexMarkers(),c.translateBy&&c.translateBy!==this.model.id||(c.updateConnectionOnly=!0,this.update(a,null,c))},onToolsChange:function(){this.renderTools().updateToolsPosition()},onLabelsChange:function(){this.renderLabels().updateLabelPositions()},render:function(){this.$el.empty();var a=this.model,b=a.get("markup")||a.markup,f=e(b);if(c.isArray(f)||(f=[f]),this._V={},c.each(f,function(a){var b=a.attr("class");b&&(b=g.util.removeClassNamePrefix(b),this._V[d.camelCase(b)]=a)},this),!this._V.connection)throw new Error("link: no connection path in the markup");return this.renderTools(),this.renderVertexMarkers(),this.renderArrowheadMarkers(),this.vel.append(f),this.renderLabels(),this.watchSource(a,a.get("source")).watchTarget(a,a.get("target")).update(),this},renderLabels:function(){if(!this._V.labels)return this;this._labelCache={};var a=d(this._V.labels.node).empty(),b=this.model.get("labels")||[];if(!b.length)return this;var f=g.util.template(this.model.get("labelMarkup")||this.model.labelMarkup),h=e(f()),i=this.can("labelMove");return c.each(b,function(b,f){var j=h.clone().node;e(j).attr("label-idx",f),i&&e(j).attr("cursor","move"),this._labelCache[f]=e(j);var k=d(j).find("text"),l=d(j).find("rect"),m=c.extend({"text-anchor":"middle","font-size":14},g.util.getByPath(b,"attrs/text","/"));k.attr(c.omit(m,"text")),c.isUndefined(m.text)||e(k[0]).text(m.text+"",{annotations:m.annotations}),a.append(j);var n=e(k[0]).bbox(!0,a[0]);e(k[0]).translate(0,-n.height/2);var o=c.extend({fill:"white",rx:3,ry:3},g.util.getByPath(b,"attrs/rect","/"));l.attr(c.extend(o,{x:n.x,y:n.y-n.height/2,width:n.width,height:n.height}))},this),this},renderTools:function(){if(!this._V.linkTools)return this;var a=d(this._V.linkTools.node).empty(),b=g.util.template(this.model.get("toolMarkup")||this.model.toolMarkup),c=e(b());if(a.append(c.node),this._toolCache=c,this.options.doubleLinkTools){var f;this.model.get("doubleToolMarkup")||this.model.doubleToolMarkup?(b=g.util.template(this.model.get("doubleToolMarkup")||this.model.doubleToolMarkup),f=e(b())):f=c.clone(),a.append(f.node),this._tool2Cache=f}return this},renderVertexMarkers:function(){if(!this._V.markerVertices)return this;var a=d(this._V.markerVertices.node).empty(),b=g.util.template(this.model.get("vertexMarkup")||this.model.vertexMarkup);return c.each(this.model.get("vertices"),function(d,f){a.append(e(b(c.extend({idx:f},d))).node)}),this},renderArrowheadMarkers:function(){if(!this._V.markerArrowheads)return this;var a=d(this._V.markerArrowheads.node);a.empty();var b=g.util.template(this.model.get("arrowheadMarkup")||this.model.arrowheadMarkup);return this._V.sourceArrowhead=e(b({end:"source"})),this._V.targetArrowhead=e(b({end:"target"})),a.append(this._V.sourceArrowhead.node,this._V.targetArrowhead.node),this},update:function(a,b,c){return c=c||{},c.updateConnectionOnly||this.updateAttributes(),this.updateConnection(c),this.updateLabelPositions(),this.updateToolsPosition(),this.updateArrowheadMarkers(),this.options.perpendicular=null,this.updatePostponed=!1,this},updateConnection:function(a){a=a||{};var b,d=this.model;if(a.translateBy&&d.isRelationshipEmbeddedIn(a.translateBy)){var e=a.tx||0,g=a.ty||0;b=this.route=c.map(this.route,function(a){return f.point(a).offset(e,g)}),this._translateConnectionPoints(e,g)}else b=this.route=this.findRoute(d.get("vertices")||[],a),this._findConnectionPoints(b);var h=this.getPathData(b);this._V.connection.attr("d",h),this._V.connectionWrap&&this._V.connectionWrap.attr("d",h),this._translateAndAutoOrientArrows(this._V.markerSource,this._V.markerTarget)},updateAttributes:function(){c.each(this.model.get("attrs"),function(a,b){var d=[];c.isObject(a.fill)&&(this.applyGradient(b,"fill",a.fill),d.push("fill")),c.isObject(a.stroke)&&(this.applyGradient(b,"stroke",a.stroke),d.push("stroke")),c.isObject(a.filter)&&(this.applyFilter(b,a.filter),d.push("filter")),d.length>0&&(d.unshift(a),a=c.omit.apply(c,d)),this.findBySelector(b).attr(a)},this)},_findConnectionPoints:function(a){var b,d,e,g,h=c.first(a);b=this.getConnectionPoint("source",this.model.get("source"),h||this.model.get("target")).round();var i=c.last(a);d=this.getConnectionPoint("target",this.model.get("target"),i||b).round();var j=this._markerCache;this._V.markerSource&&(j.sourceBBox=j.sourceBBox||this._V.markerSource.bbox(!0),e=f.point(b).move(h||d,j.sourceBBox.width*this._V.markerSource.scale().sx*-1).round()),this._V.markerTarget&&(j.targetBBox=j.targetBBox||this._V.markerTarget.bbox(!0),g=f.point(d).move(i||b,j.targetBBox.width*this._V.markerTarget.scale().sx*-1).round()),j.sourcePoint=e||b,j.targetPoint=g||d,this.sourcePoint=b,this.targetPoint=d},_translateConnectionPoints:function(a,b){var c=this._markerCache;c.sourcePoint.offset(a,b),c.targetPoint.offset(a,b),this.sourcePoint.offset(a,b),this.targetPoint.offset(a,b)},updateLabelPositions:function(){if(!this._V.labels)return this;var a=this.model.get("labels")||[];if(!a.length)return this;var b=this._V.connection.node,d=b.getTotalLength();if(!c.isNaN(d)){var e;c.each(a,function(a,g){var h=a.position,i=c.isObject(h)?h.distance:h,j=c.isObject(h)?h.offset:{x:0,y:0};c.isNaN(i)?i=d/2:(i=i>d?d:i,i=i<0?d+i:i,i=i>1?i:d*i);var k=b.getPointAtLength(i);if(c.isObject(j))k=f.point(k).offset(j.x,j.y);else if(c.isNumber(j)){e||(e=this._samples||this._V.connection.sample(this.options.sampleInterval));for(var l,m,n,o=1/0,p=0;p<e.length;p++)m=e[p],(n=f.line(m,k).squaredLength())<o&&(o=n,l=p);var q=e[l-1],r=e[l+1],s=0;r?s=f.point(k).theta(r):q&&(s=f.point(q).theta(k)),k=f.point(k).offset(j).rotate(k,s-90)}this._labelCache[g].attr("transform","translate("+k.x+", "+k.y+")")},this)}return this},updateToolsPosition:function(){if(!this._V.linkTools)return this;var a="",b=this.options.linkToolsOffset,d=this.getConnectionLength();if(!c.isNaN(d)){d<this.options.shortLinkLength&&(a="scale(.5)",b/=2);var e=this.getPointAtLength(b);if(this._toolCache.attr("transform","translate("+e.x+", "+e.y+") "+a),this.options.doubleLinkTools&&d>=this.options.longLinkLength){var f=this.options.doubleLinkToolsOffset||b;e=this.getPointAtLength(d-f),this._tool2Cache.attr("transform","translate("+e.x+", "+e.y+") "+a),this._tool2Cache.attr("visibility","visible")}else this.options.doubleLinkTools&&this._tool2Cache.attr("visibility","hidden")}return this},updateArrowheadMarkers:function(){if(!this._V.markerArrowheads)return this;if("none"===d.css(this._V.markerArrowheads.node,"display"))return this;var a=this.getConnectionLength()<this.options.shortLinkLength?.5:1;return this._V.sourceArrowhead.scale(a),this._V.targetArrowhead.scale(a),this._translateAndAutoOrientArrows(this._V.sourceArrowhead,this._V.targetArrowhead),this},createWatcher:function(a){function b(b,c){c=c||{};var e=null,f=b.previous(a)||{};return f.id&&this.stopListening(this.paper.getModelById(f.id),"change",d),c.id&&(e=this.paper.getModelById(c.id),this.listenTo(e,"change",d)),d.call(this,e,{cacheOnly:!0}),this}var d=c.partial(this.onEndModelChange,a);return b},onEndModelChange:function(a,b,d){var e=!d.cacheOnly,g=this.model,h=g.get(a)||{};if(b){var i=this.constructor.makeSelector(h),j="source"==a?"target":"source",k=g.get(j)||{},l=k.id&&this.constructor.makeSelector(k);if(d.handleBy===this.cid&&i==l)this[a+"BBox"]=this[j+"BBox"],this[a+"View"]=this[j+"View"],this[a+"Magnet"]=this[j+"Magnet"];else if(d.translateBy){var m=this[a+"BBox"];m.x+=d.tx,m.y+=d.ty}else{var n=this.paper.findViewByModel(h.id),o=n.el.querySelector(i);this[a+"BBox"]=n.getStrokeBBox(o),this[a+"View"]=n,this[a+"Magnet"]=o}if(d.handleBy===this.cid&&d.translateBy&&g.isEmbeddedIn(b)&&!c.isEmpty(g.get("vertices"))&&(e=!1),!this.updatePostponed&&k.id){var p=this.paper.getModelById(k.id);h.id===k.id&&(d.handleBy=this.cid),
(d.handleBy===this.cid||d.translateBy&&p.isEmbeddedIn(d.translateBy))&&(this.updatePostponed=!0,e=!1)}}else this[a+"BBox"]=f.rect(h.x||0,h.y||0,1,1),this[a+"View"]=this[a+"Magnet"]=null;e&&(d.updateConnectionOnly=!0,this.update(g,null,d))},_translateAndAutoOrientArrows:function(a,b){a&&a.translateAndAutoOrient(this.sourcePoint,c.first(this.route)||this.targetPoint,this.paper.viewport),b&&b.translateAndAutoOrient(this.targetPoint,c.last(this.route)||this.sourcePoint,this.paper.viewport)},removeVertex:function(a){var b=c.clone(this.model.get("vertices"));return b&&b.length&&(b.splice(a,1),this.model.set("vertices",b,{ui:!0})),this},addVertex:function(a){for(var b=(this.model.get("vertices")||[]).slice(),c=b.slice(),d=this._V.connection.node.cloneNode(!1),f=d.getTotalLength(),g=b.length+1;g--&&(b.splice(g,0,a),e(d).attr("d",this.getPathData(this.findRoute(b))),d.getTotalLength()-f>20);)b=c.slice();return-1===g&&(g=0,b.splice(g,0,a)),this.model.set("vertices",b,{ui:!0}),g},sendToken:function(a,b,d){b=b||1e3,e(this.paper.viewport).append(a),e(a).animateAlongPath({dur:b+"ms",repeatCount:1},this._V.connection.node),c.delay(function(){e(a).remove(),d&&d()},b)},findRoute:function(a){var b=g.routers,d=this.model.get("router"),e=this.paper.options.defaultRouter;if(!d)if(this.model.get("manhattan"))d={name:"orthogonal"};else{if(!e)return a;d=e}var f=d.args||{},h=c.isFunction(d)?d:b[d.name];if(!c.isFunction(h))throw new Error('unknown router: "'+d.name+'"');return h.call(this,a||[],f,this)},getPathData:function(a){var b=g.connectors,d=this.model.get("connector"),e=this.paper.options.defaultConnector;d||(d=this.model.get("smooth")?{name:"smooth"}:e||{});var f=c.isFunction(d)?d:b[d.name],h=d.args||{};if(!c.isFunction(f))throw new Error('unknown connector: "'+d.name+'"');return f.call(this,this._markerCache.sourcePoint,this._markerCache.targetPoint,a||this.model.get("vertices")||{},h,this)},getConnectionPoint:function(a,b,d){var e;if(c.isEmpty(b)&&(b={x:0,y:0}),c.isEmpty(d)&&(d={x:0,y:0}),b.id){var g,h=f.Rect("source"===a?this.sourceBBox:this.targetBBox);if(d.id){var i=f.Rect("source"===a?this.targetBBox:this.sourceBBox);g=i.intersectionWithLineFromCenterToPoint(h.center()),g=g||i.center()}else g=f.Point(d);var j=this.paper.options;if(j.perpendicularLinks||this.options.perpendicular){var k=h.origin(),l=h.corner();if(k.y<=g.y&&g.y<=l.y)switch(h.sideNearestToPoint(g)){case"left":e=f.Point(k.x,g.y);break;case"right":e=f.Point(l.x,g.y);break;default:e=h.center()}else if(k.x<=g.x&&g.x<=l.x)switch(h.sideNearestToPoint(g)){case"top":e=f.Point(g.x,k.y);break;case"bottom":e=f.Point(g.x,l.y);break;default:e=h.center()}else e=h.intersectionWithLineFromCenterToPoint(g),e=e||h.center()}else if(j.linkConnectionPoint){var m="target"===a?this.targetView:this.sourceView,n="target"===a?this.targetMagnet:this.sourceMagnet;e=j.linkConnectionPoint(this,m,n,g)}else e=h.intersectionWithLineFromCenterToPoint(g),e=e||h.center()}else e=f.Point(b);return e},getConnectionLength:function(){return this._V.connection.node.getTotalLength()},getPointAtLength:function(a){return this._V.connection.node.getPointAtLength(a)},_beforeArrowheadMove:function(){this._z=this.model.get("z"),this.model.toFront(),this.el.style.pointerEvents="none",this.paper.options.markAvailable&&this._markAvailableMagnets()},_afterArrowheadMove:function(){c.isNull(this._z)||(this.model.set("z",this._z,{ui:!0}),this._z=null),this.el.style.pointerEvents="visiblePainted",this.paper.options.markAvailable&&this._unmarkAvailableMagnets()},_createValidateConnectionArgs:function(a){function b(a,b){return c[f]=a,c[f+1]=a.el===b?void 0:b,c}var c=[];c[4]=a,c[5]=this;var d,e=0,f=0;"source"===a?(e=2,d="target"):(f=2,d="source");var g=this.model.get(d);return g.id&&(c[e]=this.paper.findViewByModel(g.id),c[e+1]=g.selector&&c[e].el.querySelector(g.selector)),b},_markAvailableMagnets:function(){function a(a,b){var c=a.paper;return c.options.validateConnection.apply(c,this._validateConnectionArgs(a,b))}var b=this.paper,d=b.model.getElements();this._marked={},c.chain(d).map(b.findViewByModel,b).each(function(b){var d=Array.prototype.slice.call(b.el.querySelectorAll("[magnet]"));"false"!==b.el.getAttribute("magnet")&&d.push(b.el);var e=c.filter(d,c.partial(a,b),this);e.length>0&&(c.each(e,c.partial(b.highlight,c,{magnetAvailability:!0}),b),b.highlight(null,{elementAvailability:!0}),this._marked[b.model.id]=e)},this).value()},_unmarkAvailableMagnets:function(){c.each(this._marked,function(a,b){var d=this.paper.findViewByModel(b);d&&(c.each(a,c.partial(d.unhighlight,c,{magnetAvailability:!0}),d),d.unhighlight(null,{elementAvailability:!0}))},this),this._marked=null},startArrowheadMove:function(a,b){b=c.defaults(b||{},{whenNotAllowed:"revert"}),this._action="arrowhead-move",this._whenNotAllowed=b.whenNotAllowed,this._arrowhead=a,this._initialMagnet=this[a+"Magnet"]||(this[a+"View"]?this[a+"View"].el:null),this._initialEnd=c.clone(this.model.get(a))||{x:0,y:0},this._validateConnectionArgs=this._createValidateConnectionArgs(this._arrowhead),this._beforeArrowheadMove()},pointerdown:function(a,b,c){if(g.dia.CellView.prototype.pointerdown.apply(this,arguments),this.notify("link:pointerdown",a,b,c),this._dx=b,this._dy=c,null==a.target.getAttribute("magnet")){var d,f=g.util.removeClassNamePrefix(a.target.getAttribute("class")),h=g.util.removeClassNamePrefix(a.target.parentNode.getAttribute("class"));switch("label"===h?(f=h,d=a.target.parentNode):d=a.target,f){case"marker-vertex":this.can("vertexMove")&&(this._action="vertex-move",this._vertexIdx=a.target.getAttribute("idx"));break;case"marker-vertex-remove":case"marker-vertex-remove-area":this.can("vertexRemove")&&this.removeVertex(a.target.getAttribute("idx"));break;case"marker-arrowhead":this.can("arrowheadMove")&&this.startArrowheadMove(a.target.getAttribute("end"));break;case"label":this.can("labelMove")&&(this._action="label-move",this._labelIdx=parseInt(e(d).attr("label-idx"),10),this._samples=this._V.connection.sample(1),this._linkLength=this._V.connection.node.getTotalLength());break;default:var i=a.target.parentNode.getAttribute("event");i?this.can("useLinkTools")&&("remove"===i?this.model.remove():this.notify(i,a,b,c)):this.can("vertexAdd")&&(this._vertexIdx=this.addVertex({x:b,y:c}),this._action="vertex-move")}}},pointermove:function(a,b,d){switch(this._action){case"vertex-move":var h=c.clone(this.model.get("vertices"));h[this._vertexIdx]={x:b,y:d},this.model.set("vertices",h,{ui:!0});break;case"label-move":for(var i,j,k,l,m={x:b,y:d},n=this._samples,o=1/0,p=0,q=n.length;p<q;p++)k=n[p],(l=f.line(k,m).squaredLength())<o&&(o=l,i=k,j=p);var r=n[j-1],s=n[j+1],t=0;r&&s?t=f.line(r,s).pointOffset(m):r?t=f.line(r,i).pointOffset(m):s&&(t=f.line(i,s).pointOffset(m)),this.model.label(this._labelIdx,{position:{distance:i.distance/this._linkLength,offset:t}});break;case"arrowhead-move":if(this.paper.options.snapLinks){var u=this.paper.options.snapLinks.radius||50,v=this.paper.findViewsInArea({x:b-u,y:d-u,width:2*u,height:2*u});this._closestView&&this._closestView.unhighlight(this._closestEnd.selector,{connecting:!0,snapping:!0}),this._closestView=this._closestEnd=null;var w,x=Number.MAX_VALUE,y=f.point(b,d);c.each(v,function(a){"false"!==a.el.getAttribute("magnet")&&(w=a.model.getBBox().center().distance(y))<u&&w<x&&this.paper.options.validateConnection.apply(this.paper,this._validateConnectionArgs(a,null))&&(x=w,this._closestView=a,this._closestEnd={id:a.model.id}),a.$("[magnet]").each(c.bind(function(b,c){var d=e(c).bbox(!1,this.paper.viewport);(w=y.distance({x:d.x+d.width/2,y:d.y+d.height/2}))<u&&w<x&&this.paper.options.validateConnection.apply(this.paper,this._validateConnectionArgs(a,c))&&(x=w,this._closestView=a,this._closestEnd={id:a.model.id,selector:a.getSelector(c),port:c.getAttribute("port")})},this))},this),this._closestView&&this._closestView.highlight(this._closestEnd.selector,{connecting:!0,snapping:!0}),this.model.set(this._arrowhead,this._closestEnd||{x:b,y:d},{ui:!0})}else{var z="mousemove"===a.type?a.target:document.elementFromPoint(a.clientX,a.clientY);this._targetEvent!==z&&(this._magnetUnderPointer&&this._viewUnderPointer.unhighlight(this._magnetUnderPointer,{connecting:!0}),this._viewUnderPointer=this.paper.findView(z),this._viewUnderPointer?(this._magnetUnderPointer=this._viewUnderPointer.findMagnet(z),this._magnetUnderPointer&&this.paper.options.validateConnection.apply(this.paper,this._validateConnectionArgs(this._viewUnderPointer,this._magnetUnderPointer))?this._magnetUnderPointer&&this._viewUnderPointer.highlight(this._magnetUnderPointer,{connecting:!0}):this._magnetUnderPointer=null):this._magnetUnderPointer=null),this._targetEvent=z,this.model.set(this._arrowhead,{x:b,y:d},{ui:!0})}}this._dx=b,this._dy=d,g.dia.CellView.prototype.pointermove.apply(this,arguments),this.notify("link:pointermove",a,b,d)},pointerup:function(a,b,c){if("label-move"===this._action)this._samples=null;else if("arrowhead-move"===this._action){var d,e=this.paper,f=e.options,h=this._arrowhead,i=this._initialEnd;if(f.snapLinks)this._closestView&&(this._closestView.unhighlight(this._closestEnd.selector,{connecting:!0,snapping:!0}),d=this._closestView.findMagnet(this._closestEnd.selector)),this._closestView=this._closestEnd=null;else{var j=this._viewUnderPointer;if(d=this._magnetUnderPointer,this._viewUnderPointer=null,this._magnetUnderPointer=null,d){j.unhighlight(d,{connecting:!0});var k=j.getSelector(d),l=d.getAttribute("port"),m={id:j.model.id};null!=k&&(m.port=l),null!=l&&(m.selector=k),this.model.set(h,m,{ui:!0})}}if(!e.linkAllowed(this))switch(this._whenNotAllowed){case"remove":this.model.remove();break;case"revert":default:this.model.set(h,i,{ui:!0})}f.embeddingMode&&this.model.reparent()&&(this._z=null);var n=this.model.prop(h)||{},o=!g.dia.Link.endsEqual(i,n);o&&(i.id&&this.notify("link:disconnect",a,e.findViewByModel(i.id),this._initialMagnet,h),n.id&&this.notify("link:connect",a,e.findViewByModel(n.id),d,h)),this._afterArrowheadMove()}this._action=null,this._whenNotAllowed=null,this._initialMagnet=null,this._initialEnd=null,this._validateConnectionArgs=null,this.notify("link:pointerup",a,b,c),g.dia.CellView.prototype.pointerup.apply(this,arguments)}},{makeSelector:function(a){var b='[model-id="'+a.id+'"]';return a.port?b+=' [port="'+a.port+'"]':a.selector&&(b+=" "+a.selector),b}}),g.dia.Paper=g.mvc.View.extend({className:"paper",options:{width:800,height:600,origin:{x:0,y:0},gridSize:1,drawGrid:!1,perpendicularLinks:!1,elementView:g.dia.ElementView,linkView:g.dia.LinkView,snapLinks:!1,multiLinks:!0,guard:function(a,b){return!1},highlighting:{default:{name:"stroke",options:{padding:3}},magnetAvailability:{name:"addClass",options:{className:"available-magnet"}},elementAvailability:{name:"addClass",options:{className:"available-cell"}}},preventContextMenu:!0,restrictTranslate:!1,markAvailable:!1,defaultLink:new g.dia.Link,defaultConnector:{name:"normal"},defaultRouter:{name:"normal"},validateMagnet:function(a,b){return"passive"!==b.getAttribute("magnet")},validateConnection:function(a,b,c,d,e,f){return("target"===e?c:a)instanceof g.dia.ElementView},embeddingMode:!1,validateEmbedding:function(a,b){return!0},findParentBy:"bbox",frontParentOnly:!0,interactive:{labelMove:!1},linkPinning:!0,clickThreshold:0,cellViewNamespace:g.shapes,highlighterNamespace:g.highlighters},events:{mousedown:"pointerdown",dblclick:"mousedblclick",click:"mouseclick",touchstart:"pointerdown",touchend:"mouseclick",touchmove:"pointermove",mousemove:"pointermove","mouseover .joint-cell":"cellMouseover","mouseout .joint-cell":"cellMouseout",contextmenu:"contextmenu",mousewheel:"mousewheel",DOMMouseScroll:"mousewheel"},_highlights:[],init:function(){c.bindAll(this,"pointerup"),this.model=this.options.model||new g.dia.Graph,this.options.origin=c.clone(this.options.origin),this.options.defaultConnector=c.clone(this.options.defaultConnector),c.defaults(this.options.highlighting,this.constructor.prototype.options.highlighting),this.options.highlighting=c.cloneDeep(this.options.highlighting),this.svg=e("svg").node,this.viewport=e("g").addClass(g.util.addClassNamePrefix("viewport")).node,this.defs=e("defs").node,e(this.svg).append([this.viewport,this.defs]),this.$el.append(this.svg),this.listenTo(this.model,"add",this.onCellAdded),this.listenTo(this.model,"remove",this.removeView),this.listenTo(this.model,"reset",this.resetViews),this.listenTo(this.model,"sort",this._onSort),this.listenTo(this.model,"batch:stop",this._onBatchStop),this.setOrigin(),this.setDimensions(),d(document).on("mouseup touchend",this.pointerup),this._mousemoved=0,this._views={},this.on("cell:highlight",this.onCellHighlight,this),this.on("cell:unhighlight",this.onCellUnhighlight,this)},_onSort:function(){this.model.hasActiveBatch("add")||this.sortViews()},_onBatchStop:function(a){"add"!==(a&&a.batchName)||this.model.hasActiveBatch("add")||this.sortViews()},onRemove:function(){this.removeViews(),d(document).off("mouseup touchend",this.pointerup)},setDimensions:function(a,b){a=this.options.width=a||this.options.width,b=this.options.height=b||this.options.height,e(this.svg).attr({width:a,height:b}),this.trigger("resize",a,b)},setOrigin:function(a,b){this.options.origin.x=a||0,this.options.origin.y=b||0,e(this.viewport).translate(a,b,{absolute:!0}),this.trigger("translate",a,b),this.options.drawGrid&&this.drawGrid()},fitToContent:function(a,b,d,f){c.isObject(a)?(f=a,a=f.gridWidth||1,b=f.gridHeight||1,d=f.padding||0):(f=f||{},a=a||1,b=b||1,d=d||0),d=g.util.normalizeSides(d);var h=e(this.viewport).bbox(!0,this.svg),i=e(this.viewport).scale();h.x*=i.sx,h.y*=i.sy,h.width*=i.sx,h.height*=i.sy;var j=Math.max(Math.ceil((h.width+h.x)/a),1)*a,k=Math.max(Math.ceil((h.height+h.y)/b),1)*b,l=0,m=0;("negative"==f.allowNewOrigin&&h.x<0||"positive"==f.allowNewOrigin&&h.x>=0||"any"==f.allowNewOrigin)&&(l=Math.ceil(-h.x/a)*a,l+=d.left,j+=l),("negative"==f.allowNewOrigin&&h.y<0||"positive"==f.allowNewOrigin&&h.y>=0||"any"==f.allowNewOrigin)&&(m=Math.ceil(-h.y/b)*b,m+=d.top,k+=m),j+=d.right,k+=d.bottom,j=Math.max(j,f.minWidth||0),k=Math.max(k,f.minHeight||0),j=Math.min(j,f.maxWidth||Number.MAX_VALUE),k=Math.min(k,f.maxHeight||Number.MAX_VALUE);var n=j!=this.options.width||k!=this.options.height;(l!=this.options.origin.x||m!=this.options.origin.y)&&this.setOrigin(l,m),n&&this.setDimensions(j,k)},scaleContentToFit:function(a){var b=this.getContentBBox();if(b.width&&b.height){a=a||{},c.defaults(a,{padding:0,preserveAspectRatio:!0,scaleGrid:null,minScale:0,maxScale:Number.MAX_VALUE});var d=a.padding,g=a.minScaleX||a.minScale,h=a.maxScaleX||a.maxScale,i=a.minScaleY||a.minScale,j=a.maxScaleY||a.maxScale,k=a.fittingBBox||{x:this.options.origin.x,y:this.options.origin.y,width:this.options.width,height:this.options.height};k=f.rect(k).moveAndExpand({x:d,y:d,width:-2*d,height:-2*d});var l=e(this.viewport).scale(),m=k.width/b.width*l.sx,n=k.height/b.height*l.sy;if(a.preserveAspectRatio&&(m=n=Math.min(m,n)),a.scaleGrid){var o=a.scaleGrid;m=o*Math.floor(m/o),n=o*Math.floor(n/o)}m=Math.min(h,Math.max(g,m)),n=Math.min(j,Math.max(i,n)),this.scale(m,n);var p=this.getContentBBox(),q=k.x-p.x,r=k.y-p.y;this.setOrigin(q,r)}},getContentBBox:function(){var a=this.viewport.getBoundingClientRect(),b=this.viewport.getScreenCTM(),c=this.viewport.getCTM();return f.rect({x:a.left-b.e+c.e,y:a.top-b.f+c.f,width:a.width,height:a.height})},getArea:function(){var a=this.viewport.getCTM().inverse(),b={x:0,y:0,width:this.options.width,height:this.options.height};return f.rect(e.transformRect(b,a))},getRestrictedArea:function(){return c.isFunction(this.options.restrictTranslate)?this.options.restrictTranslate.apply(this,arguments):!0===this.options.restrictTranslate?this.getArea():this.options.restrictTranslate||null},createViewForModel:function(a){var c,d,e=this.options.cellViewNamespace,f=a.get("type")+"View",h=g.util.getByPath(e,f,".");return a.isLink()?(c=this.options.linkView,d=g.dia.LinkView):(c=this.options.elementView,d=g.dia.ElementView),new(c.prototype instanceof b.View?h||c:c.call(this,a)||h||d)({model:a,interactive:this.options.interactive})},onCellAdded:function(a,b,d){if(this.options.async&&!1!==d.async&&c.isNumber(d.position)){if(this._asyncCells=this._asyncCells||[],this._asyncCells.push(a),0==d.position){if(this._frameId)throw new Error("another asynchronous rendering in progress");this.asyncRenderViews(this._asyncCells,d),delete this._asyncCells}}else this.renderView(a)},removeView:function(a){var b=this._views[a.id];return b&&(b.remove(),delete this._views[a.id]),b},renderView:function(a){var b=this._views[a.id]=this.createViewForModel(a);return e(this.viewport).append(b.el),b.paper=this,b.render(),d(b.el).find("image").on("dragstart",function(){return!1}),b},beforeRenderViews:function(a){return a.sort(function(a){return a instanceof g.dia.Link?1:-1}),a},afterRenderViews:function(){this.sortViews()},resetViews:function(a,b){this.removeViews();var d=a.models.slice();d=this.beforeRenderViews(d,b)||d,this._frameId&&(g.util.cancelFrame(this._frameId),delete this._frameId),this.options.async?this.asyncRenderViews(d,b):(c.each(d,this.renderView,this),this.sortViews())},removeViews:function(){c.invoke(this._views,"remove"),this._views={}},asyncBatchAdded:c.noop,asyncRenderViews:function(a,b){if(this._frameId){var d=this.options.async&&this.options.async.batchSize||50,e=a.splice(0,d),f=this.model.get("cells");c.each(e,function(a){a.collection===f&&this.renderView(a)},this),this.asyncBatchAdded()}a.length?this._frameId=g.util.nextFrame(function(){this.asyncRenderViews(a,b)},this):(delete this._frameId,this.afterRenderViews(b),this.trigger("render:done",b))},sortViews:function(){var a=d(this.viewport).children("[model-id]"),b=this.model.get("cells");g.util.sortElements(a,function(a,c){var e=b.get(d(a).attr("model-id")),f=b.get(d(c).attr("model-id"));return(e.get("z")||0)>(f.get("z")||0)?1:-1})},scale:function(a,b,d,f){b=b||a,c.isUndefined(d)&&(d=0,f=0),e(this.viewport).attr("transform","");var g=this.options.origin.x,h=this.options.origin.y;if(d||f||g||h){var i=g-d*(a-1),j=h-f*(b-1);this.setOrigin(i,j)}return e(this.viewport).scale(a,b),this.trigger("scale",a,b,d,f),this.options.drawGrid&&this.drawGrid(),this},rotate:function(a,b,d){if(c.isUndefined(b)){var f=this.viewport.getBBox();b=f.width/2,d=f.height/2}e(this.viewport).rotate(a,b,d)},findView:function(a){for(var b=c.isString(a)?this.viewport.querySelector(a):a instanceof d?a[0]:a;b&&b!==this.el&&b!==document;){var e=b.getAttribute("model-id");if(e)return this._views[e];b=b.parentNode}},findViewByModel:function(a){var b=c.isString(a)?a:a.id;return this._views[b]},findViewsFromPoint:function(a){a=f.point(a);var b=c.map(this.model.getElements(),this.findViewByModel,this);return c.filter(b,function(b){return b&&f.rect(b.vel.bbox(!1,this.viewport)).containsPoint(a)},this)},findViewsInArea:function(a,b){b=c.defaults(b||{},{strict:!1}),a=f.rect(a);var d=c.map(this.model.getElements(),this.findViewByModel,this),e=b.strict?"containsRect":"intersect";return c.filter(d,function(b){return b&&a[e](f.rect(b.vel.bbox(!1,this.viewport)))},this)},getModelById:function(a){return this.model.getCell(a)},snapToGrid:function(a){var b=e(this.viewport).toLocalPoint(a.x,a.y);return{x:f.snapToGrid(b.x,this.options.gridSize),y:f.snapToGrid(b.y,this.options.gridSize)}},clientToLocalPoint:function(a){a=f.point(a);var b=e("rect",{width:this.options.width,height:this.options.height,x:0,y:0,opacity:0});e(this.svg).prepend(b);var c=d(this.svg).offset();b.remove();var g=document.body.scrollTop||document.documentElement.scrollTop,h=document.body.scrollLeft||document.documentElement.scrollLeft;return a.offset(h-c.left,g-c.top),e.transformPoint(a,this.viewport.getCTM().inverse())},linkAllowed:function(a){var b;if(a instanceof g.dia.Link)b=a;else{if(!(a instanceof g.dia.LinkView))throw new Error("Must provide link model or view.");b=a.model}if(!this.options.multiLinks){var d=b.get("source"),e=b.get("target");if(d.id&&e.id){var f=b.getSourceElement();if(f){var h=this.model.getConnectedLinks(f,{outbound:!0,inbound:!1});if(c.filter(h,function(a){var b=a.get("source"),c=a.get("target");return b&&b.id===d.id&&(!b.port||b.port===d.port)&&c&&c.id===e.id&&(!c.port||c.port===e.port)}).length>1)return!1}}}return!!(this.options.linkPinning||c.has(b.get("source"),"id")&&c.has(b.get("target"),"id"))},getDefaultLink:function(a,b){return c.isFunction(this.options.defaultLink)?this.options.defaultLink.call(this,a,b):this.options.defaultLink.clone()},resolveHighlighter:function(a){a=a||{};var b=a.highlighter,d=this.options;if(c.isUndefined(b)){var e=c.chain(a).pick("embedding","connecting","magnetAvailability","elementAvailability").keys().first().value();b=e&&d.highlighting[e]||d.highlighting.default}if(!b)return!1;c.isString(b)&&(b={name:b});var f=b.name,g=d.highlighterNamespace[f];if(!g)throw new Error('Unknown highlighter ("'+f+'")');if("function"!=typeof g.highlight)throw new Error('Highlighter ("'+f+'") is missing required highlight() method');if("function"!=typeof g.unhighlight)throw new Error('Highlighter ("'+f+'") is missing required unhighlight() method');return{highlighter:g,options:b.options||{},name:f}},onCellHighlight:function(a,b,d){if(d=this.resolveHighlighter(d)){var e=d.name+b.id+JSON.stringify(d.options);if(!this._highlights[e]){var f=d.highlighter;f.highlight(a,b,c.clone(d.options)),this._highlights[e]={cellView:a,magnetEl:b,opt:d.options,highlighter:f}}}},onCellUnhighlight:function(a,b,c){if(c=this.resolveHighlighter(c)){var d=c.name+b.id+JSON.stringify(c.options),e=this._highlights[d];e&&(e.highlighter.unhighlight(e.cellView,e.magnetEl,e.opt),this._highlights[d]=null)}},mousedblclick:function(a){a.preventDefault(),a=g.util.normalizeEvent(a);var b=this.findView(a.target);if(!this.guard(a,b)){var c=this.snapToGrid({x:a.clientX,y:a.clientY});b?b.pointerdblclick(a,c.x,c.y):this.trigger("blank:pointerdblclick",a,c.x,c.y)}},mouseclick:function(a){if(this._mousemoved<=this.options.clickThreshold){a=g.util.normalizeEvent(a);var b=this.findView(a.target);if(this.guard(a,b))return;var c=this.snapToGrid({x:a.clientX,y:a.clientY});b?b.pointerclick(a,c.x,c.y):this.trigger("blank:pointerclick",a,c.x,c.y)}},guard:function(a,b){return!(!this.options.guard||!this.options.guard(a,b))||(a.data&&!c.isUndefined(a.data.guarded)?a.data.guarded:!(b&&b.model&&b.model instanceof g.dia.Cell)&&(this.svg!==a.target&&this.el!==a.target&&!d.contains(this.svg,a.target)))},contextmenu:function(a){a=g.util.normalizeEvent(a),this.options.preventContextMenu&&a.preventDefault();var b=this.findView(a.target);if(!this.guard(a,b)){var c=this.snapToGrid({x:a.clientX,y:a.clientY});b?b.contextmenu(a,c.x,c.y):this.trigger("blank:contextmenu",a,c.x,c.y)}},pointerdown:function(a){a=g.util.normalizeEvent(a);var b=this.findView(a.target);if(!this.guard(a,b)){a.preventDefault(),this._mousemoved=0;var c=this.snapToGrid({x:a.clientX,y:a.clientY});b?(this.sourceView=b,b.pointerdown(a,c.x,c.y)):this.trigger("blank:pointerdown",a,c.x,c.y)}},pointermove:function(a){if(this.sourceView){a.preventDefault(),a=g.util.normalizeEvent(a),this._mousemoved++;var b=this.snapToGrid({x:a.clientX,y:a.clientY});this.sourceView.pointermove(a,b.x,b.y)}},pointerup:function(a){a=g.util.normalizeEvent(a);var b=this.snapToGrid({x:a.clientX,y:a.clientY});this.sourceView?(this.sourceView.pointerup(a,b.x,b.y),this.sourceView=null):this.trigger("blank:pointerup",a,b.x,b.y)},mousewheel:function(a){a=g.util.normalizeEvent(a);var b=this.findView(a.target);if(!this.guard(a,b)){var c=a.originalEvent,d=this.snapToGrid({x:c.clientX,y:c.clientY}),e=Math.max(-1,Math.min(1,c.wheelDelta||-c.detail));b?b.mousewheel(a,d.x,d.y,e):this.trigger("blank:mousewheel",a,d.x,d.y,e)}},cellMouseover:function(a){a=g.util.normalizeEvent(a);var b=this.findView(a.target);if(b){if(this.guard(a,b))return;b.mouseover(a)}},cellMouseout:function(a){a=g.util.normalizeEvent(a);var b=this.findView(a.target);if(b){if(this.guard(a,b))return;b.mouseout(a)}},setGridSize:function(a){return this.options.gridSize=a,this.options.drawGrid&&this.drawGrid(),this},clearGrid:function(){return this.el.style.backgroundImage="none",this},drawGrid:function(a){a=c.defaults(a||{},this.options.drawGrid,{color:"#aaa",thickness:1});var b=this.options.gridSize;if(b<=1)return this.clearGrid();var d=e(this.viewport).scale(),f=d.sx,g=d.sy,h=this.options.origin.x,i=this.options.origin.y,j=b*f,k=b*g,l=document.createElement("canvas");l.width=j,l.height=k,j=h>=0?h%j:j+h%j,k=i>=0?i%k:k+i%k;var m=l.getContext("2d");m.beginPath(),m.rect(j,k,a.thickness*f,a.thickness*g),m.fillStyle=a.color,m.fill();var n=l.toDataURL("image/png");return this.el.style.backgroundImage='url("'+n+'")',this},setInteractivity:function(a){this.options.interactive=a,c.invoke(this._views,"setInteractivity",a)}}),function(a,b){var c=function(a){var c=b.cloneDeep(a);this.ports=[],this.groups=this._getNormalizedGroups(c),this._init(c)};c.prototype={getPorts:function(){return this.ports},getPort:function(a){return b.find(this.ports,function(b){return b.id===a})},getGroup:function(a){return this.groups[a]||this._createGroupNode()},addPort:function(a){a=this._evaluatePort(a),this.ports.push(a)},_init:function(a){a=a||{};var c=a.items||[];b.each(c,function(a){this.addPort(a)},this)},_evaluatePort:function(a){var c=b.clone(a),d=b.extend(this._createGroupNode(),a.group?this.groups[a.group]:null);return c.markup=c.markup||d.markup,c.attrs=b.merge({},d.attrs,c.attrs),c.position=b.merge(this._createPositionNode(),d.position,{args:c.args}),c.label=b.merge({},d.label,this._getLabel(c)),c.z=this._getZIndex(c.z,d.z),c},_getZIndex:function(a,c){return b.isNumber(a)?a:b.isNumber(c)||"auto"===c?c:"auto"},_createPositionNode:function(){return{name:"left",args:{}}},_createGroupNode:function(){return{position:{},label:{position:{name:"left",args:{}}}}},_getNormalizedGroups:function(a){return a=a||{},a.groups=a.groups||{},b.each(a.groups,function(a){a.position=this._getPosition(a.position,!0),a.label=this._getLabel(a,!0)},this),a.groups},_getPosition:function(a,c){var d,e={};b.isFunction(a)?(d="fn",e.fn=a):b.isString(a)?d=a:b.isUndefined(a)?d=c?"left":null:b.isArray(a)?(d="absolute",e.x=a[0],e.y=a[1]):b.isObject(a)&&(d=a.name,b.extend(e,a.args));var f={args:e};return d&&(f.name=d),f},_getLabel:function(a,b){var c=a.label||{},d=c;return d.position=this._getPosition(c.position,b),d}},b.extend(a.dia.Element.prototype,{_initializePorts:function(){this._createPortData(),this.on("change:ports",function(){this._processRemovedPort(),this._createPortData()},this)},_processRemovedPort:function(){var a=this.get("ports")||{},c={};b.each(a.items,function(a){c[a.id]=!0});var d=this.previous("ports")||{},e={};b.each(d.items,function(a){c[a.id]||(e[a.id]=!0)});var f=this.graph;if(f&&!b.isEmpty(e)){var g=f.getConnectedLinks(this,{inbound:!0});b.each(g,function(a){e[a.get("target").port]&&a.remove()});var h=f.getConnectedLinks(this,{outbound:!0});b.each(h,function(a){e[a.get("source").port]&&a.remove()})}},hasPorts:function(){return this.prop("ports/items").length>0},hasPort:function(a){return-1!==this.getPortIndex(a)},getPorts:function(){return b.cloneDeep(this.prop("ports/items"))||[]},getPort:function(a){return b.cloneDeep(b.find(this.prop("ports/items"),function(b){return b.id&&b.id===a}))},getPortIndex:function(a){var c=b.isObject(a)?a.id:a;return this._isValidPortId(c)?b.findIndex(this.prop("ports/items"),{id:c}):-1},addPort:function(a,c){if(!b.isObject(a)||b.isArray(a))throw new Error("Element: addPort requires an object.");var d=b.clone(this.prop("ports/items"))||[];return d.push(a),this.prop("ports/items",d,c),this},portProp:function(a,c,d,e){var f=this.getPortIndex(a);if(-1===f)throw new Error("Element: unable to find port with id "+a);var g;return b.isString(c)?(g=Array.prototype.slice.call(arguments,1),g[0]=["ports/items/",f,"/",c].join("")):g=["ports/items/"+f,c,d],this.prop.apply(this,g)},_validatePorts:function(){var c=this.get("ports")||{},d=[];c=c||{};var e=c.items||[];return b.each(e,function(b){this._isValidPortId(b.id)||(b.id=a.util.uuid())},this),b.uniq(e,"id").length!==e.length&&d.push("Element: found id duplicities in ports."),d},_isValidPortId:function(a){return!b.isNull(a)&&!b.isUndefined(a)&&!b.isObject(a)},addPorts:function(a,c){return a.length&&this.prop("ports/items",(b.clone(this.prop("ports/items"))||[]).concat(a),c),this},removePort:function(a,c){var d=c||{},e=b.clone(this.prop("ports/items")),f=this.getPortIndex(a);return-1!==f&&(e.splice(f,1),d.rewrite=!0,this.prop("ports/items",e,d)),this},_createPortData:function(){var a=this._validatePorts();if(a.length>0)throw this.set("ports",this.previous("ports")),new Error(a.join(" "));this.portData=new c(this.get("ports"))}}),b.extend(a.dia.ElementView.prototype,{portContainerMarkup:'<g class="joint-port"/>',portMarkup:'<circle class="joint-port-body" r="10" fill="#FFFFFF" stroke="#000000"/>',portLabelMarkup:'<text class="joint-port-label" fill="#000000"/>',_portElementsCache:null,_initializePorts:function(){this._portElementsCache={},this.listenTo(this.model,"change:ports",function(){this._refreshPorts()})},_refreshPorts:function(){this._removePorts(),this._portElementsCache={},this._renderPorts()},_renderPorts:function(){var a=[],c=this._getContainerElement();b.each(c.node.childNodes,function(b){a.push(b)});var d=b.groupBy(this.model.portData.getPorts(),"z");b.each(d.auto,function(b){var d=this._getPortElement(b);c.append(d),a.push(d)},this),b.each(d,function(b,c){if("auto"!==c){var e=parseInt(c,10);this._appendPorts(d[c],e,a)}},this),this._updatePorts()},_getContainerElement:function(){return this.rotatableNode||this.vel},_appendPorts:function(a,c,d){var f=this._getContainerElement(),g=b.map(a,this._getPortElement,this);d[c]||c<0?e(d[Math.max(c,0)]).before(g):f.append(g)},_getPortElement:function(a){return this._portElementsCache[a.id]?this._portElementsCache[a.id].portElement:this._createPortElement(a)},_updatePorts:function(){var a=f.rect(this.model.get("size")),c=this.model.portData.getPorts();b.each(b.groupBy(c,"group"),function(c,d){var e=this.model.portData.getGroup(d);b.each(c,this._updatePortAttrs,this),this._layoutPorts(c,e,a.clone())},this)},_removePorts:function(){b.invoke(this._portElementsCache,"portElement.remove")},_createPortElement:function(a){var b=e(this._getPortMarkup(a)),c=e(this._getPortLabelMarkup(a.label));if(b&&b.length>1)throw new Error("ElementView: Invalid port markup - multiple roots.");b.attr({port:a.id,"port-group":a.group});var d=e(this.portContainerMarkup).append(b).append(c);return this._portElementsCache[a.id]={portElement:d,portLabelElement:c},d},_updatePortAttrs:function(a){var b=a.attrs||{},c=this._portElementsCache[a.id];c&&this._updateAllAttrs(c.portElement.node,b)},_updateAllAttrs:function(a,c){b.each(c,function(b,c){var e="."===c?d(a):d(a).find(c);this.updateAttr(e,b)},this)},_layoutPorts:function(c,d,e){var g=d.position.name,h=a.layout.Port;h[g]||(g="left");var i=h[g](b.pluck(c,"position.args"),e,d.position.args||{});b.each(i,function(b,d){var g=this.model.portData.getPort(c[d].id),h=this._portElementsCache[g.id]||{};this.applyPortTransform(h.portElement,b);var i=a.layout.PortLabel,j=g.label.position.name;if(i[j]){var k=i[j](f.point(b),e,g.label.position.args);this.applyPortTransform(h.portLabelElement,k,-(b.angle||0))}},this)},applyPortTransform:function(a,b,c){var d=e.createSVGMatrix().rotate(c||0).translate(b.x||0,b.y||0).rotate(b.angle||0);a.transform(d,{absolute:!0}),this._updateAllAttrs(a.node,b.attrs||{})},_getPortMarkup:function(a){return a.markup||this.model.get("portMarkup")||this.model.portMarkup||this.portMarkup},_getPortLabelMarkup:function(a){return a.markup||this.model.get("portLabelMarkup")||this.model.portLabelMarkup||this.portLabelMarkup}})}(g,c),g.shapes.basic={},g.shapes.basic.Generic=g.dia.Element.extend({defaults:c.defaultsDeep({type:"basic.Generic",attrs:{".":{fill:"#ffffff",stroke:"none"}}},g.dia.Element.prototype.defaults)}),g.shapes.basic.Rect=g.shapes.basic.Generic.extend({
markup:'<g class="rotatable"><g class="scalable"><rect/></g><text/></g>',defaults:c.defaultsDeep({type:"basic.Rect",attrs:{rect:{fill:"#ffffff",stroke:"#000000",width:100,height:60},text:{fill:"#000000",text:"","font-size":14,"ref-x":.5,"ref-y":.5,"text-anchor":"middle","y-alignment":"middle","font-family":"Arial, helvetica, sans-serif"}}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.basic.TextView=g.dia.ElementView.extend({initialize:function(){g.dia.ElementView.prototype.initialize.apply(this,arguments),this.listenTo(this.model,"change:attrs",this.resize)}}),g.shapes.basic.Text=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><text/></g></g>',defaults:c.defaultsDeep({type:"basic.Text",attrs:{text:{"font-size":18,fill:"#000000"}}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.basic.Circle=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><circle/></g><text/></g>',defaults:c.defaultsDeep({type:"basic.Circle",size:{width:60,height:60},attrs:{circle:{fill:"#ffffff",stroke:"#000000",r:30,cx:30,cy:30},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-y":.5,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.basic.Ellipse=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><ellipse/></g><text/></g>',defaults:c.defaultsDeep({type:"basic.Ellipse",size:{width:60,height:40},attrs:{ellipse:{fill:"#ffffff",stroke:"#000000",rx:30,ry:20,cx:30,cy:20},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-y":.5,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.basic.Polygon=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><polygon/></g><text/></g>',defaults:c.defaultsDeep({type:"basic.Polygon",size:{width:60,height:40},attrs:{polygon:{fill:"#ffffff",stroke:"#000000"},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-dy":20,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.basic.Polyline=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><polyline/></g><text/></g>',defaults:c.defaultsDeep({type:"basic.Polyline",size:{width:60,height:40},attrs:{polyline:{fill:"#ffffff",stroke:"#000000"},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-dy":20,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.basic.Image=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><image/></g><text/></g>',defaults:c.defaultsDeep({type:"basic.Image",attrs:{text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-dy":20,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.basic.Path=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><path/></g><text/></g>',defaults:c.defaultsDeep({type:"basic.Path",size:{width:60,height:60},attrs:{path:{fill:"#ffffff",stroke:"#000000"},text:{"font-size":14,text:"","text-anchor":"middle",ref:"path","ref-x":.5,"ref-dy":10,fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.basic.Rhombus=g.shapes.basic.Path.extend({defaults:c.defaultsDeep({type:"basic.Rhombus",attrs:{path:{d:"M 30 0 L 60 30 30 60 0 30 z"},text:{"ref-y":.5,"y-alignment":"middle"}}},g.shapes.basic.Path.prototype.defaults)}),g.shapes.basic.PortsModelInterface={initialize:function(){this.updatePortsAttrs(),this.on("change:inPorts change:outPorts",this.updatePortsAttrs,this),this.constructor.__super__.constructor.__super__.initialize.apply(this,arguments)},updatePortsAttrs:function(a){if(this._portSelectors){var b=c.omit(this.get("attrs"),this._portSelectors);this.set("attrs",b,{silent:!0})}this._portSelectors=[];var d={};c.each(this.get("inPorts"),function(a,b,e){var f=this.getPortAttrs(a,b,e.length,".inPorts","in");this._portSelectors=this._portSelectors.concat(c.keys(f)),c.extend(d,f)},this),c.each(this.get("outPorts"),function(a,b,e){var f=this.getPortAttrs(a,b,e.length,".outPorts","out");this._portSelectors=this._portSelectors.concat(c.keys(f)),c.extend(d,f)},this),this.attr(d,{silent:!0}),this.processPorts(),this.trigger("process:ports")},getPortSelector:function(a){var b=".inPorts",c=this.get("inPorts").indexOf(a);if(c<0&&(b=".outPorts",(c=this.get("outPorts").indexOf(a))<0))throw new Error("getPortSelector(): Port doesn't exist.");return b+">g:nth-child("+(c+1)+")>.port-body"}},g.shapes.basic.PortsViewInterface={initialize:function(){this.listenTo(this.model,"process:ports",this.update),g.dia.ElementView.prototype.initialize.apply(this,arguments)},update:function(){this.renderPorts(),g.dia.ElementView.prototype.update.apply(this,arguments)},renderPorts:function(){var a=this.$(".inPorts").empty(),b=this.$(".outPorts").empty(),d=g.util.template(this.model.portMarkup);c.each(c.filter(this.model.ports,function(a){return"in"===a.type}),function(b,c){a.append(e(d({id:c,port:b})).node)}),c.each(c.filter(this.model.ports,function(a){return"out"===a.type}),function(a,c){b.append(e(d({id:c,port:a})).node)})}},g.shapes.basic.TextBlock=g.shapes.basic.Generic.extend({markup:['<g class="rotatable">','<g class="scalable"><rect/></g>',g.env.test("svgforeignobject")?'<foreignObject class="fobj"><body xmlns="http://www.w3.org/1999/xhtml"><div class="content"/></body></foreignObject>':'<text class="content"/>',"</g>"].join(""),defaults:c.defaultsDeep({type:"basic.TextBlock",attrs:{rect:{fill:"#ffffff",stroke:"#000000",width:80,height:100},text:{fill:"#000000","font-size":14,"font-family":"Arial, helvetica, sans-serif"},".content":{text:"",ref:"rect","ref-x":.5,"ref-y":.5,"y-alignment":"middle","x-alignment":"middle"}},content:""},g.shapes.basic.Generic.prototype.defaults),initialize:function(){this.listenTo(this,"change:size",this.updateSize),this.listenTo(this,"change:content",this.updateContent),this.updateSize(this,this.get("size")),this.updateContent(this,this.get("content")),g.shapes.basic.Generic.prototype.initialize.apply(this,arguments)},updateSize:function(a,b){this.attr({".fobj":c.clone(b),div:{style:c.clone(b)}})},updateContent:function(a,b){g.env.test("svgforeignobject")?this.attr({".content":{html:b}}):this.attr({".content":{text:b}})},setForeignObjectSize:function(){this.updateSize.apply(this,arguments)},setDivContent:function(){this.updateContent.apply(this,arguments)}}),g.shapes.basic.TextBlockView=g.dia.ElementView.extend({initialize:function(){g.dia.ElementView.prototype.initialize.apply(this,arguments),this.noSVGForeignObjectElement=!g.env.test("svgforeignobject"),g.env.test("svgforeignobject")||this.listenTo(this.model,"change:content change:size",function(a){this.updateContent(a)})},update:function(a,b){if(g.env.test("svgforeignobject"))g.dia.ElementView.prototype.update.call(this,d,b);else{var d=this.model,e=c.omit(b||d.get("attrs"),".content");g.dia.ElementView.prototype.update.call(this,d,e),b&&!c.has(b,".content")||this.updateContent(d,b)}},updateContent:function(a,b){var d=c.merge({},(b||a.get("attrs"))[".content"]);d=c.omit(d,"text");var e=g.util.breakText(a.get("content"),a.get("size"),d,{svgDocument:this.paper.svg}),f=g.util.setByPath({},".content",d,"/");f[".content"].text=e,g.dia.ElementView.prototype.update.call(this,a,f)}}),g.routers.manhattan=function(a,b,c){"use strict";function d(a){this.map={},this.options=a,this.mapGridSize=100}function e(){this.items=[],this.hash={},this.values={},this.OPEN=1,this.CLOSE=2}function f(b){return a.point(0===b.x?0:Math.abs(b.x)/b.x,0===b.y?0:Math.abs(b.y)/b.y)}function g(b,c,d,e){for(var g,h=[],i=f(e.difference(c)),j=c;g=b[j];){var k=f(j.difference(g));k.equals(i)||(h.unshift(j),i=k),j=g}return f(a.point(j).difference(d)).equals(i)||h.unshift(j),h}function h(a,c,d){var e=d.step,f=a.center();return b.chain(d.directionMap).pick(c).map(function(b){var c=b.x*a.width/2,d=b.y*a.height/2,g=f.clone().offset(c,d);return a.containsPoint(g)&&g.offset(b.x*e,b.y*e),g.snapToGrid(e)}).value()}function i(b,c,d){var e=360/d;return Math.floor(a.normalizeAngle(b.theta(c)+e/2)/e)*e}function j(a,b){var c=Math.abs(a-b);return c>180?360-c:c}function k(a,b){for(var c=1/0,d=0,e=b.length;d<e;d++){var f=a.manhattanDistance(b[d]);f<c&&(c=f)}return c}function l(c,d,f,l){var m,n,o,p,q=l.step;if(c instanceof a.rect?(m=h(c,l.startDirections,l),o=c.center().snapToGrid(q)):(o=c.clone().snapToGrid(q),m=[o]),d instanceof a.rect?(n=h(d,l.endDirections,l),p=d.center().snapToGrid(q)):(p=d.clone().snapToGrid(q),n=[p]),m=b.filter(m,f.isPointAccessible,f),n=b.filter(n,f.isPointAccessible,f),m.length>0&&n.length>0){var r=new e,s={},t={};b.each(m,function(a){var b=a.toString();r.add(b,k(a,n)),t[b]=0});for(var u,v,w=l.directions,x=w.length,y=l.maximumLoops,z=b.invoke(n,"toString");!r.isEmpty()&&y>0;){var A=r.pop(),B=a.point(A),C=t[A],D=E,E=s[A]?i(s[A],B,x):null!=l.previousDirAngle?l.previousDirAngle:i(o,B,x);if(z.indexOf(A)>=0&&(v=j(E,i(B,p,x)),B.equals(p)||v<180))return l.previousDirAngle=E,g(s,B,o,p);for(var F=0;F<x;F++)if(u=w[F],v=j(E,u.angle),!(D&&v>l.maxAllowedDirectionChange)){var G=B.clone().offset(u.offsetX,u.offsetY),H=G.toString();if(!r.isClose(H)&&f.isPointAccessible(G)){var I=C+u.cost+l.penalties[v];(!r.isOpen(H)||I<t[H])&&(s[H]=B,t[H]=I,r.add(H,I+k(G,n)))}}y--}}return l.fallbackRoute(o,p,l)}function m(c){c.directions=b.result(c,"directions"),c.penalties=b.result(c,"penalties"),c.paddingBox=b.result(c,"paddingBox"),b.each(c.directions,function(b){var c=a.point(0,0),d=a.point(b.offsetX,b.offsetY);b.angle=a.normalizeAngle(c.theta(d))})}function n(e,f){m(f),this.options.perpendicular=!!f.perpendicular;for(var g=a.rect(this.sourceBBox).moveAndExpand(f.paddingBox),h=a.rect(this.targetBBox).moveAndExpand(f.paddingBox),i=new d(f).build(this.paper.model,this.model),j=b.map(e,a.point),k=[],n=g.center().snapToGrid(f.step),o=0,p=j.length;o<=p;o++){var q=null,r=s||g,s=j[o];if(!s){s=h;if((!this.model.get("source").id||!this.model.get("target").id)&&b.isFunction(f.draggingRoute)){var t=r instanceof a.rect?r.center():r;q=f.draggingRoute(t,s.origin(),f)}}if(null===(q=q||l(r,s,i,f))){if(!b.isFunction(c.routers.orthogonal))throw new Error("Manhattan requires the orthogonal router.");return c.routers.orthogonal(e,f,this)}var u=b.first(q);u&&u.equals(n)&&q.shift(),n=b.last(q)||n,Array.prototype.push.apply(k,q)}return k}var o={step:10,perpendicular:!0,excludeEnds:[],excludeTypes:["basic.Text"],maximumLoops:2e3,startDirections:["left","right","top","bottom"],endDirections:["left","right","top","bottom"],directionMap:{right:{x:1,y:0},bottom:{x:0,y:1},left:{x:-1,y:0},top:{x:0,y:-1}},maxAllowedDirectionChange:90,paddingBox:function(){var a=this.step;return{x:-a,y:-a,width:2*a,height:2*a}},directions:function(){var a=this.step;return[{offsetX:a,offsetY:0,cost:a},{offsetX:0,offsetY:a,cost:a},{offsetX:-a,offsetY:0,cost:a},{offsetX:0,offsetY:-a,cost:a}]},penalties:function(){return{0:0,45:this.step/2,90:this.step/2}},fallbackRoute:b.constant(null),draggingRoute:null};return d.prototype.build=function(a,c){var d=this.options,e=b.chain(d.excludeEnds).map(c.get,c).pluck("id").map(a.getCell,a).value(),f=[],g=a.getCell(c.get("source").id);g&&(f=b.union(f,b.map(g.getAncestors(),"id")));var h=a.getCell(c.get("target").id);h&&(f=b.union(f,b.map(h.getAncestors(),"id")));var i=this.mapGridSize;return b.chain(a.getElements()).difference(e).reject(function(a){return b.contains(d.excludeTypes,a.get("type"))||b.contains(f,a.id)}).invoke("getBBox").invoke("moveAndExpand",d.paddingBox).foldl(function(a,b){for(var c=b.origin().snapToGrid(i),d=b.corner().snapToGrid(i),e=c.x;e<=d.x;e+=i)for(var f=c.y;f<=d.y;f+=i){var g=e+"@"+f;a[g]=a[g]||[],a[g].push(b)}return a},this.map).value(),this},d.prototype.isPointAccessible=function(a){var c=a.clone().snapToGrid(this.mapGridSize).toString();return b.every(this.map[c],function(b){return!b.containsPoint(a)})},e.prototype.add=function(a,c){this.hash[a]?this.items.splice(this.items.indexOf(a),1):this.hash[a]=this.OPEN,this.values[a]=c;var d=b.sortedIndex(this.items,a,function(a){return this.values[a]},this);this.items.splice(d,0,a)},e.prototype.remove=function(a){this.hash[a]=this.CLOSE},e.prototype.isOpen=function(a){return this.hash[a]===this.OPEN},e.prototype.isClose=function(a){return this.hash[a]===this.CLOSE},e.prototype.isEmpty=function(){return 0===this.items.length},e.prototype.pop=function(){var a=this.items.shift();return this.remove(a),a},function(a,c,d){return n.call(d,a,b.extend({},o,c))}}(f,c,g),g.routers.metro=function(){if(!c.isFunction(g.routers.manhattan))throw new Error("Metro requires the manhattan router.");var a={diagonalCost:null,directions:function(){var a=this.step,b=this.diagonalCost||Math.ceil(Math.sqrt(a*a<<1));return[{offsetX:a,offsetY:0,cost:a},{offsetX:a,offsetY:a,cost:b},{offsetX:0,offsetY:a,cost:a},{offsetX:-a,offsetY:a,cost:b},{offsetX:-a,offsetY:0,cost:a},{offsetX:-a,offsetY:-a,cost:b},{offsetX:0,offsetY:-a,cost:a},{offsetX:a,offsetY:-a,cost:b}]},maxAllowedDirectionChange:45,fallbackRoute:function(a,b,c){var d=a.theta(b),e={x:b.x,y:a.y},g={x:a.x,y:b.y};if(d%180>90){var h=e;e=g,g=h}var i=d%90<45?e:g,j=f.line(a,i),k=90*Math.ceil(d/90),l=f.point.fromPolar(j.squaredLength(),f.toRad(k+135),i),m=f.line(b,l),n=j.intersection(m);return n?[n.round(),b]:[b]}};return function(b,d,e){return g.routers.manhattan(b,c.extend({},a,d),e)}}(),g.routers.normal=function(a,b,c){return a},g.routers.oneSide=function(a,b,c){var d,e,f,g=b.side||"bottom",h=b.padding||40,i=c.sourceBBox,j=c.targetBBox,k=i.center(),l=j.center();switch(g){case"bottom":f=1,d="y",e="height";break;case"top":f=-1,d="y",e="height";break;case"left":f=-1,d="x",e="width";break;case"right":f=1,d="x",e="width";break;default:throw new Error("Router: invalid side")}return k[d]+=f*(i[e]/2+h),l[d]+=f*(j[e]/2+h),f*(k[d]-l[d])>0?l[d]=k[d]:k[d]=l[d],[k].concat(a,l)},g.routers.orthogonal=function(){function a(a,b){return a.x==b.x?a.y>b.y?"N":"S":a.y==b.y?a.x>b.x?"W":"E":null}function b(a,b){return a["W"==b||"E"==b?"width":"height"]}function d(a,b){return f.rect(a).moveAndExpand({x:-b,y:-b,width:2*b,height:2*b})}function e(a){return f.rect(a.x,a.y,0,0)}function g(a,b){var c=Math.min(a.x,b.x),d=Math.min(a.y,b.y),e=Math.max(a.x+a.width,b.x+b.width),g=Math.max(a.y+a.height,b.y+b.height);return f.rect(c,d,e-c,g-d)}function h(a,b,c){var d=f.point(a.x,b.y);return c.containsPoint(d)&&(d=f.point(b.x,a.y)),d}function i(b,c,d){var e=f.point(b.x,c.y),g=f.point(c.x,b.y),h=a(b,e),i=a(b,g),j=o[d],k=h==d||h!=j&&(i==j||i!=d)?e:g;return{points:[k],direction:a(k,c)}}function j(b,c,d){var e=h(b,c,d);return{points:[e],direction:a(e,c)}}function k(d,e,g,i){var j,k={},l=[f.point(d.x,e.y),f.point(e.x,d.y)],m=c.filter(l,function(a){return!g.containsPoint(a)}),n=c.filter(m,function(b){return a(b,d)!=i});if(n.length>0)j=c.filter(n,function(b){return a(d,b)==i}).pop(),j=j||n[0],k.points=[j],k.direction=a(j,e);else{j=c.difference(l,m)[0];var o=f.point(e).move(j,-b(g,i)/2),p=h(o,d,g);k.points=[p,o],k.direction=a(o,e)}return k}function l(c,d,e,g){var h=j(d,c,g),k=h.points[0];if(e.containsPoint(k)){h=j(c,d,e);var l=h.points[0];if(g.containsPoint(l)){var m=f.point(c).move(l,-b(e,a(c,l))/2),n=f.point(d).move(k,-b(g,a(d,k))/2),o=f.line(m,n).midpoint(),p=j(c,o,e),q=i(o,d,p.direction);h.points=[p.points[0],q.points[0]],h.direction=q.direction}}return h}function m(b,c,e,i,j){var k,l,m,n={},o=d(g(e,i),1),q=o.center().distance(c)>o.center().distance(b),r=q?c:b,s=q?b:c;return j?(k=f.point.fromPolar(o.width+o.height,p[j],r),k=o.pointNearestToPoint(k).move(k,-1)):k=o.pointNearestToPoint(r).move(r,1),l=h(k,s,o),k.round().equals(l.round())?(l=f.point.fromPolar(o.width+o.height,f.toRad(k.theta(r))+Math.PI/2,s),l=o.pointNearestToPoint(l).move(s,1).round(),m=h(k,l,o),n.points=q?[l,m,k]:[k,m,l]):n.points=q?[l,k]:[k,l],n.direction=q?a(k,c):a(l,c),n}function n(b,g,h){var n=g.elementPadding||20,o=[],p=d(h.sourceBBox,n),q=d(h.targetBBox,n);b=c.map(b,f.point),b.unshift(p.center()),b.push(q.center());for(var r,s=0,t=b.length-1;s<t;s++){var u=null,v=b[s],w=b[s+1],x=!!a(v,w);if(0==s)s+1==t?p.intersect(d(q,1))?u=m(v,w,p,q):x||(u=l(v,w,p,q)):p.containsPoint(w)?u=m(v,w,p,d(e(w),n)):x||(u=j(v,w,p));else if(s+1==t){var y=x&&a(w,v)==r;q.containsPoint(v)||y?u=m(v,w,d(e(v),n),q,r):x||(u=k(v,w,q,r))}else x||(u=i(v,w,r));u?(Array.prototype.push.apply(o,u.points),r=u.direction):r=a(v,w),s+1<t&&o.push(w)}return o}var o={N:"S",S:"N",E:"W",W:"E"},p={N:-Math.PI/2*3,S:-Math.PI/2,E:0,W:Math.PI};return n}(),g.connectors.normal=function(a,b,d){var e=["M",a.x,a.y];return c.each(d,function(a){e.push(a.x,a.y)}),e.push(b.x,b.y),e.join(" ")},g.connectors.rounded=function(a,b,d,e){e=e||{};var g,h,i,j,k,l,m=e.radius||10,n=["M",a.x,a.y];return c.each(d,function(c,e){k=d[e-1]||a,l=d[e+1]||b,i=j||f.point(c).distance(k)/2,j=f.point(c).distance(l)/2,g=f.point(c).move(k,-Math.min(m,i)).round(),h=f.point(c).move(l,-Math.min(m,j)).round(),n.push(g.x,g.y,"S",c.x,c.y,h.x,h.y,"L")}),n.push(b.x,b.y),n.join(" ")},g.connectors.smooth=function(a,b,c){var d;if(c.length)d=f.bezier.curveThroughPoints([a].concat(c).concat([b]));else{var e=(a.x+b.x)/2;d=["M",a.x,a.y,"C",e,a.y,e,b.y,b.x,b.y]}return d.join(" ")},g.connectors.jumpover=function(a,b){function c(a,c,d){var e=[].concat(a,d,c);return e.reduce(function(a,c,d){var f=e[d+1];return null!=f&&(a[d]=b.line(c,f)),a},[])}function d(a){var b=a.paper._jumpOverUpdateList;null==b&&(b=a.paper._jumpOverUpdateList=[],a.paper.on("cell:pointerup",e),a.paper.model.on("reset",function(){b=[]})),b.indexOf(a)<0&&(b.push(a),a.listenToOnce(a.model,"change:connector remove",function(){b.splice(b.indexOf(a),1)}))}function e(){for(var a=this._jumpOverUpdateList,b=0;b<a.length;b++)a[b].update()}function f(b,c){return a(c).map(function(a){return b.intersection(a)}).compact().value()}function g(a,c){return b.line(a,c).squaredLength()}function h(a,c,d){return c.reduce(function(e,f,g){if(!0===f.skip)return e;var h=e.pop()||a,i=b.point(f).move(h.start,-d),j=b.point(f).move(h.start,+d),l=c[g+1];if(null!=l){var m=j.distance(l);m<=d&&(j=l.move(h.start,m),l.skip=!0)}else{if(i.distance(h.end)<2*d+k)return e.push(h),e}if(j.distance(h.start)<2*d+k)return e.push(h),e;var n=b.line(i,j);return n.isJump=!0,e.push(b.line(h.start,i),n,b.line(j,h.end)),e},[])}function i(c,d,e){var f=["M",c[0].start.x,c[0].start.y],g=a(c).map(function(a){if(a.isJump){var c;if("arc"===e){c=a.start.difference(a.end);var f=Number(c.x<0&&c.y<0);return["A",d,d,0,0,f,a.end.x,a.end.y]}if("gap"===e)return["M",a.end.x,a.end.y];if("cubic"===e){c=a.start.difference(a.end);var g=a.start.theta(a.end),h=.6*d,i=1.35*d;c.x<0&&c.y<0&&(i*=-1);var j=b.point(a.start.x+h,a.start.y+i).rotate(a.start,g),k=b.point(a.end.x-h,a.end.y+i).rotate(a.end,g);return["C",j.x,j.y,k.x,k.y,a.end.x,a.end.y]}}return["L",a.end.x,a.end.y]}).flatten().value();return[].concat(f,g).join(" ")}var j=["arc","gap","cubic"],k=1,l=["smooth"];return function(b,e,k,m){d(this);var n=m.size||5,o=m.jump&&(""+m.jump).toLowerCase(),p=m.ignoreConnectors||l;-1===j.indexOf(o)&&(o=j[0]);var q=this.paper,r=q.model,s=r.getLinks();if(1===s.length)return i(c(b,e,k),n,o);var t=this.model,u=s.indexOf(t),v=q.options.defaultConnector||{},w=s.filter(function(b,c){var d=b.get("connector")||v;return!a.contains(p,d.name)&&(!(c>u)||"jumpover"!==d.name)}),x=w.map(function(a){return q.findViewByModel(a)}),y=c(b,e,k),z=x.map(function(a){return null==a?[]:a===this?y:c(a.sourcePoint,a.targetPoint,a.route)},this);return i(y.reduce(function(b,c){var d=a(w).map(function(a,b){return a===t?null:f(c,z[b])}).flatten().compact().sortBy(a.partial(g,c.start)).value();return d.length>0?b.push.apply(b,h(c,d,n)):b.push(c),b},[]),n,o)}}(c,f),function(a,b,c){function d(b,c,d){var e=b.toJSON();return e.angle=c||0,a.defaults({},d,e)}function e(c,e,f){return a.map(c,function(a,b,c){var e=this.pointAt((b+.5)/c.length);return(a.dx||a.dy)&&e.offset(a.dx||0,a.dy||0),d(e.round(),0,a)},b.line(e,f))}function f(c,e,f,g){var h=e.center(),i=e.width/e.height,j=e.topMiddle(),k=b.Ellipse.fromRect(e);return a.map(c,function(a,b,c){var e=f+g(b,c.length),l=j.clone().rotate(h,-e).scale(i,1,h),m=a.compensateRotation?-k.tangentTheta(l):0;return(a.dx||a.dy)&&l.offset(a.dx||0,a.dy||0),a.dr&&l.move(h,a.dr),d(l.round(),m,a)})}function g(c,d){var e=d.x;a.isString(e)&&(e=parseFloat(e)/100*c.width);var f=d.y;return a.isString(f)&&(f=parseFloat(f)/100*c.height),b.point(e||0,f||0)}c.layout.Port={absolute:function(b,c,d){return a.map(b,a.partial(g,c))},fn:function(a,b,c){return c.fn(a,b,c)},line:function(a,b,c){return e(a,g(b,c.start||b.origin()),g(b,c.end||b.corner()))},left:function(a,b,c){return e(a,b.origin(),b.bottomLeft())},right:function(a,b,c){return e(a,b.topRight(),b.corner())},top:function(a,b,c){return e(a,b.origin(),b.topRight())},bottom:function(a,b,c){return e(a,b.bottomLeft(),b.corner())},ellipseSpread:function(a,b,c){var d=c.startAngle||0,e=c.step||360/a.length;return f(a,b,d,function(a){return a*e})},ellipse:function(a,b,c){var d=c.startAngle||0,e=c.step||20;return f(a,b,d,function(a,b){return(a+.5-b/2)*e})}}}(c,f,g),function(a,b,c){function d(b,c){return a.defaultsDeep({},b,c,{x:0,y:0,angle:0,attrs:{".":{y:"0","text-anchor":"start"}}})}function e(b,c,e,g){g=a.defaults({},g,{offset:15});var h,i,j,k,l=c.center().theta(b),m=f(c),n=g.offset,o=0;l<m[1]||l>m[2]?(j=".3em",h=n,i=0,k="start"):l<m[0]?(j="0",h=0,i=-n,e?(o=-90,k="start"):k="middle"):l<m[3]?(j=".3em",h=-n,i=0,k="end"):(j=".6em",h=0,i=n,e?(o=90,k="start"):k="middle");var p=Math.round;return d({x:p(h),y:p(i),angle:o,attrs:{".":{y:j,"text-anchor":k}}})}function f(a){var b=a.center(),c=b.theta(a.origin()),d=b.theta(a.bottomLeft()),e=b.theta(a.corner());return[c,b.theta(a.topRight()),e,d]}function g(b,c,e,g){var h=c.center().theta(b);g=a.defaults({},g,{offset:15});var i,j,k,l,m=g.offset,n=0,o=f(c);h<o[1]||h>o[2]?(k=".3em",i=-m,j=0,l="end"):h<o[0]?(k=".6em",i=0,j=m,e?(n=90,l="start"):l="middle"):h<o[3]?(k=".3em",i=m,j=0,l="start"):(k="0em",i=0,j=-m,e?(n=-90,l="start"):l="middle");var p=Math.round;return d({x:p(i),y:p(j),angle:n,attrs:{".":{y:k,"text-anchor":l}}})}function h(c,e,f){f=a.defaults({},f,{offset:20});var g,h=b.point(0,0),i=-c.theta(h),j=i,k=c.clone().move(h,f.offset).difference(c).round(),l=".3em";(i+90)%180==0?(g=e?"end":"middle",e||-270!==i||(l="0em")):i>-270&&i<-90?(g="start",j=i-180):g="end";var m=Math.round;return d({x:m(k.x),y:m(k.y),angle:e?j:0,attrs:{".":{y:l,"text-anchor":g}}})}c.layout.PortLabel={manual:a.rearg(d,2),left:function(a,b,c){return d(c,{x:-15,attrs:{".":{y:".3em","text-anchor":"end"}}})},right:function(a,b,c){return d(c,{x:15,attrs:{".":{y:".3em","text-anchor":"start"}}})},top:function(a,b,c){return d(c,{y:-15,attrs:{".":{"text-anchor":"middle"}}})},bottom:function(a,b,c){return d(c,{y:15,attrs:{".":{y:".6em","text-anchor":"middle"}}})},outsideOriented:function(a,b,c){return e(a,b,!0,c)},outside:function(a,b,c){return e(a,b,!1,c)},insideOriented:function(a,b,c){return g(a,b,!0,c)},inside:function(a,b,c){return g(a,b,!1,c)},radial:function(a,b,c){return h(a.difference(b.center()),!1,c)},radialOriented:function(a,b,c){return h(a.difference(b.center()),!0,c)}}}(c,f,g),g.highlighters.addClass={className:g.util.addClassNamePrefix("highlighted"),highlight:function(a,b,c){var d=c||{},f=d.className||this.className;e(b).addClass(f)},unhighlight:function(a,b,c){var d=c||{},f=d.className||this.className;e(b).removeClass(f)}},g.highlighters.opacity={highlight:function(a,b){e(b).addClass(g.util.addClassNamePrefix("highlight-opacity"))},unhighlight:function(a,b){e(b).removeClass(g.util.addClassNamePrefix("highlight-opacity"))}},g.highlighters.stroke={defaultOptions:{padding:3,rx:0,ry:0,attrs:{"stroke-width":3,stroke:"#FEB663"}},_views:{},highlight:function(a,b,d){if(!this._views[b.id]){var f=c.defaults(d||{},this.defaultOptions),h=e(b),i=h.bbox(!0);try{var j=h.convertToPathData()}catch(a){j=e.rectToPath(c.extend({},f,i))}var k=e("path").attr({d:j,"pointer-events":"none","vector-effect":"non-scaling-stroke",fill:"none"}).attr(f.attrs);k.transform(a.el.getCTM().inverse()),k.transform(b.getCTM());var l=f.padding;if(l){var m=i.x+i.width/2,n=i.y+i.height/2,o=(i.width+l)/i.width,p=(i.height+l)/i.height;k.transform({a:o,b:0,c:0,d:p,e:m-o*m,f:n-p*n})}var q=this._views[b.id]=new g.mvc.View({className:"highlight-stroke",el:k.node,$el:k});q.listenTo(a.model,"remove",q.remove),a.vel.append(k)}},unhighlight:function(a,b,c){this._views[b.id]&&(this._views[b.id].remove(),this._views[b.id]=null)}},g.shapes.erd={},g.shapes.erd.Entity=g.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><polygon class="outer"/><polygon class="inner"/></g><text/></g>',defaults:c.defaultsDeep({type:"erd.Entity",size:{width:150,height:60},attrs:{".outer":{fill:"#2ECC71",stroke:"#27AE60","stroke-width":2,points:"100,0 100,60 0,60 0,0"},".inner":{fill:"#2ECC71",stroke:"#27AE60","stroke-width":2,points:"95,5 95,55 5,55 5,5",display:"none"},text:{text:"Entity","font-family":"Arial","font-size":14,"ref-x":.5,"ref-y":.5,"y-alignment":"middle","text-anchor":"middle"}}},g.dia.Element.prototype.defaults)}),g.shapes.erd.WeakEntity=g.shapes.erd.Entity.extend({defaults:c.defaultsDeep({type:"erd.WeakEntity",attrs:{".inner":{display:"auto"},text:{text:"Weak Entity"}}},g.shapes.erd.Entity.prototype.defaults)}),g.shapes.erd.Relationship=g.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><polygon class="outer"/><polygon class="inner"/></g><text/></g>',defaults:c.defaultsDeep({type:"erd.Relationship",size:{width:80,height:80},attrs:{".outer":{fill:"#3498DB",stroke:"#2980B9","stroke-width":2,points:"40,0 80,40 40,80 0,40"},".inner":{fill:"#3498DB",stroke:"#2980B9","stroke-width":2,points:"40,5 75,40 40,75 5,40",display:"none"},text:{text:"Relationship","font-family":"Arial","font-size":12,"ref-x":.5,"ref-y":.5,"y-alignment":"middle","text-anchor":"middle"}}},g.dia.Element.prototype.defaults)}),g.shapes.erd.IdentifyingRelationship=g.shapes.erd.Relationship.extend({defaults:c.defaultsDeep({type:"erd.IdentifyingRelationship",attrs:{".inner":{display:"auto"},text:{text:"Identifying"}}},g.shapes.erd.Relationship.prototype.defaults)}),g.shapes.erd.Attribute=g.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><ellipse class="outer"/><ellipse class="inner"/></g><text/></g>',defaults:c.defaultsDeep({type:"erd.Attribute",size:{width:100,height:50},attrs:{ellipse:{transform:"translate(50, 25)"},".outer":{stroke:"#D35400","stroke-width":2,cx:0,cy:0,rx:50,ry:25,fill:"#E67E22"},".inner":{stroke:"#D35400","stroke-width":2,cx:0,cy:0,rx:45,ry:20,fill:"#E67E22",display:"none"},text:{"font-family":"Arial","font-size":14,"ref-x":.5,"ref-y":.5,"y-alignment":"middle","text-anchor":"middle"}}},g.dia.Element.prototype.defaults)}),g.shapes.erd.Multivalued=g.shapes.erd.Attribute.extend({defaults:c.defaultsDeep({type:"erd.Multivalued",attrs:{".inner":{display:"block"},text:{text:"multivalued"}}},g.shapes.erd.Attribute.prototype.defaults)}),g.shapes.erd.Derived=g.shapes.erd.Attribute.extend({defaults:c.defaultsDeep({type:"erd.Derived",attrs:{".outer":{"stroke-dasharray":"3,5"},text:{text:"derived"}}},g.shapes.erd.Attribute.prototype.defaults)}),g.shapes.erd.Key=g.shapes.erd.Attribute.extend({defaults:c.defaultsDeep({type:"erd.Key",attrs:{ellipse:{"stroke-width":4},text:{text:"key","font-weight":"800","text-decoration":"underline"}}},g.shapes.erd.Attribute.prototype.defaults)}),g.shapes.erd.Normal=g.shapes.erd.Attribute.extend({defaults:c.defaultsDeep({type:"erd.Normal",attrs:{text:{text:"Normal"}}},g.shapes.erd.Attribute.prototype.defaults)}),g.shapes.erd.ISA=g.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><polygon/></g><text/></g>',defaults:c.defaultsDeep({type:"erd.ISA",size:{width:100,height:50},attrs:{polygon:{points:"0,0 50,50 100,0",fill:"#F1C40F",stroke:"#F39C12","stroke-width":2},text:{text:"ISA","font-size":18,"ref-x":.5,"ref-y":.3,"y-alignment":"middle","text-anchor":"middle"}}},g.dia.Element.prototype.defaults)}),g.shapes.erd.Line=g.dia.Link.extend({defaults:{type:"erd.Line"},cardinality:function(a){this.set("labels",[{position:-20,attrs:{text:{dy:-8,text:a}}}])}}),g.shapes.fsa={},g.shapes.fsa.State=g.shapes.basic.Circle.extend({defaults:c.defaultsDeep({type:"fsa.State",attrs:{circle:{"stroke-width":3},text:{"font-weight":"800"}}},g.shapes.basic.Circle.prototype.defaults)}),g.shapes.fsa.StartState=g.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><circle/></g></g>',defaults:c.defaultsDeep({type:"fsa.StartState",size:{width:20,height:20},attrs:{circle:{transform:"translate(10, 10)",r:10,fill:"#000000"}}},g.dia.Element.prototype.defaults)}),g.shapes.fsa.EndState=g.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><circle class="outer"/><circle class="inner"/></g></g>',defaults:c.defaultsDeep({type:"fsa.EndState",size:{width:20,height:20},attrs:{".outer":{transform:"translate(10, 10)",r:10,fill:"#ffffff",stroke:"#000000"},".inner":{transform:"translate(10, 10)",r:6,fill:"#000000"}}},g.dia.Element.prototype.defaults)}),g.shapes.fsa.Arrow=g.dia.Link.extend({defaults:c.defaultsDeep({type:"fsa.Arrow",attrs:{".marker-target":{d:"M 10 0 L 0 5 L 10 10 z"}},smooth:!0},g.dia.Link.prototype.defaults)}),g.shapes.org={},g.shapes.org.Member=g.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><rect class="card"/><image/></g><text class="rank"/><text class="name"/></g>',defaults:c.defaultsDeep({type:"org.Member",size:{width:180,height:70},attrs:{rect:{width:170,height:60},".card":{fill:"#FFFFFF",stroke:"#000000","stroke-width":2,"pointer-events":"visiblePainted",rx:10,ry:10},image:{width:48,height:48,ref:".card","ref-x":10,"ref-y":5},".rank":{"text-decoration":"underline",ref:".card","ref-x":.9,"ref-y":.2,"font-family":"Courier New","font-size":14,"text-anchor":"end"},".name":{"font-weight":"800",ref:".card","ref-x":.9,"ref-y":.6,"font-family":"Courier New","font-size":14,"text-anchor":"end"}}},g.dia.Element.prototype.defaults)}),g.shapes.org.Arrow=g.dia.Link.extend({defaults:{type:"org.Arrow",source:{selector:".card"},target:{selector:".card"},attrs:{".connection":{stroke:"#585858","stroke-width":3}},z:-1}}),g.shapes.chess={},g.shapes.chess.KingWhite=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="fill:none; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;"><path      d="M 22.5,11.63 L 22.5,6"      style="fill:none; stroke:#000000; stroke-linejoin:miter;" />    <path      d="M 20,8 L 25,8"      style="fill:none; stroke:#000000; stroke-linejoin:miter;" />    <path      d="M 22.5,25 C 22.5,25 27,17.5 25.5,14.5 C 25.5,14.5 24.5,12 22.5,12 C 20.5,12 19.5,14.5 19.5,14.5 C 18,17.5 22.5,25 22.5,25"      style="fill:#ffffff; stroke:#000000; stroke-linecap:butt; stroke-linejoin:miter;" />    <path      d="M 11.5,37 C 17,40.5 27,40.5 32.5,37 L 32.5,30 C 32.5,30 41.5,25.5 38.5,19.5 C 34.5,13 25,16 22.5,23.5 L 22.5,27 L 22.5,23.5 C 19,16 9.5,13 6.5,19.5 C 3.5,25.5 11.5,29.5 11.5,29.5 L 11.5,37 z "      style="fill:#ffffff; stroke:#000000;" />    <path      d="M 11.5,30 C 17,27 27,27 32.5,30"      style="fill:none; stroke:#000000;" />    <path      d="M 11.5,33.5 C 17,30.5 27,30.5 32.5,33.5"      style="fill:none; stroke:#000000;" />    <path      d="M 11.5,37 C 17,34 27,34 32.5,37"      style="fill:none; stroke:#000000;" />  </g></g></g>',defaults:c.defaultsDeep({type:"chess.KingWhite",size:{width:42,height:38}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.chess.KingBlack=g.shapes.basic.Generic.extend({
markup:'<g class="rotatable"><g class="scalable"><g style="fill:none; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path       d="M 22.5,11.63 L 22.5,6"       style="fill:none; stroke:#000000; stroke-linejoin:miter;"       id="path6570" />    <path       d="M 22.5,25 C 22.5,25 27,17.5 25.5,14.5 C 25.5,14.5 24.5,12 22.5,12 C 20.5,12 19.5,14.5 19.5,14.5 C 18,17.5 22.5,25 22.5,25"       style="fill:#000000;fill-opacity:1; stroke-linecap:butt; stroke-linejoin:miter;" />    <path       d="M 11.5,37 C 17,40.5 27,40.5 32.5,37 L 32.5,30 C 32.5,30 41.5,25.5 38.5,19.5 C 34.5,13 25,16 22.5,23.5 L 22.5,27 L 22.5,23.5 C 19,16 9.5,13 6.5,19.5 C 3.5,25.5 11.5,29.5 11.5,29.5 L 11.5,37 z "       style="fill:#000000; stroke:#000000;" />    <path       d="M 20,8 L 25,8"       style="fill:none; stroke:#000000; stroke-linejoin:miter;" />    <path       d="M 32,29.5 C 32,29.5 40.5,25.5 38.03,19.85 C 34.15,14 25,18 22.5,24.5 L 22.51,26.6 L 22.5,24.5 C 20,18 9.906,14 6.997,19.85 C 4.5,25.5 11.85,28.85 11.85,28.85"       style="fill:none; stroke:#ffffff;" />    <path       d="M 11.5,30 C 17,27 27,27 32.5,30 M 11.5,33.5 C 17,30.5 27,30.5 32.5,33.5 M 11.5,37 C 17,34 27,34 32.5,37"       style="fill:none; stroke:#ffffff;" />  </g></g></g>',defaults:c.defaultsDeep({type:"chess.KingBlack",size:{width:42,height:38}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.chess.QueenWhite=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:#ffffff; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(-1,-1)" />    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(15.5,-5.5)" />    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(32,-1)" />    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(7,-4.5)" />    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(24,-4)" />    <path      d="M 9,26 C 17.5,24.5 30,24.5 36,26 L 38,14 L 31,25 L 31,11 L 25.5,24.5 L 22.5,9.5 L 19.5,24.5 L 14,10.5 L 14,25 L 7,14 L 9,26 z "      style="stroke-linecap:butt;" />    <path      d="M 9,26 C 9,28 10.5,28 11.5,30 C 12.5,31.5 12.5,31 12,33.5 C 10.5,34.5 10.5,36 10.5,36 C 9,37.5 11,38.5 11,38.5 C 17.5,39.5 27.5,39.5 34,38.5 C 34,38.5 35.5,37.5 34,36 C 34,36 34.5,34.5 33,33.5 C 32.5,31 32.5,31.5 33.5,30 C 34.5,28 36,28 36,26 C 27.5,24.5 17.5,24.5 9,26 z "      style="stroke-linecap:butt;" />    <path      d="M 11.5,30 C 15,29 30,29 33.5,30"      style="fill:none;" />    <path      d="M 12,33.5 C 18,32.5 27,32.5 33,33.5"      style="fill:none;" />  </g></g></g>',defaults:c.defaultsDeep({type:"chess.QueenWhite",size:{width:42,height:38}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.chess.QueenBlack=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:#000000; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <g style="fill:#000000; stroke:none;">      <circle cx="6"    cy="12" r="2.75" />      <circle cx="14"   cy="9"  r="2.75" />      <circle cx="22.5" cy="8"  r="2.75" />      <circle cx="31"   cy="9"  r="2.75" />      <circle cx="39"   cy="12" r="2.75" />    </g>    <path       d="M 9,26 C 17.5,24.5 30,24.5 36,26 L 38.5,13.5 L 31,25 L 30.7,10.9 L 25.5,24.5 L 22.5,10 L 19.5,24.5 L 14.3,10.9 L 14,25 L 6.5,13.5 L 9,26 z"       style="stroke-linecap:butt; stroke:#000000;" />    <path       d="M 9,26 C 9,28 10.5,28 11.5,30 C 12.5,31.5 12.5,31 12,33.5 C 10.5,34.5 10.5,36 10.5,36 C 9,37.5 11,38.5 11,38.5 C 17.5,39.5 27.5,39.5 34,38.5 C 34,38.5 35.5,37.5 34,36 C 34,36 34.5,34.5 33,33.5 C 32.5,31 32.5,31.5 33.5,30 C 34.5,28 36,28 36,26 C 27.5,24.5 17.5,24.5 9,26 z"       style="stroke-linecap:butt;" />    <path       d="M 11,38.5 A 35,35 1 0 0 34,38.5"       style="fill:none; stroke:#000000; stroke-linecap:butt;" />    <path       d="M 11,29 A 35,35 1 0 1 34,29"       style="fill:none; stroke:#ffffff;" />    <path       d="M 12.5,31.5 L 32.5,31.5"       style="fill:none; stroke:#ffffff;" />    <path       d="M 11.5,34.5 A 35,35 1 0 0 33.5,34.5"       style="fill:none; stroke:#ffffff;" />    <path       d="M 10.5,37.5 A 35,35 1 0 0 34.5,37.5"       style="fill:none; stroke:#ffffff;" />  </g></g></g>',defaults:c.defaultsDeep({type:"chess.QueenBlack",size:{width:42,height:38}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.chess.RookWhite=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:#ffffff; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 9,39 L 36,39 L 36,36 L 9,36 L 9,39 z "      style="stroke-linecap:butt;" />    <path      d="M 12,36 L 12,32 L 33,32 L 33,36 L 12,36 z "      style="stroke-linecap:butt;" />    <path      d="M 11,14 L 11,9 L 15,9 L 15,11 L 20,11 L 20,9 L 25,9 L 25,11 L 30,11 L 30,9 L 34,9 L 34,14"      style="stroke-linecap:butt;" />    <path      d="M 34,14 L 31,17 L 14,17 L 11,14" />    <path      d="M 31,17 L 31,29.5 L 14,29.5 L 14,17"      style="stroke-linecap:butt; stroke-linejoin:miter;" />    <path      d="M 31,29.5 L 32.5,32 L 12.5,32 L 14,29.5" />    <path      d="M 11,14 L 34,14"      style="fill:none; stroke:#000000; stroke-linejoin:miter;" />  </g></g></g>',defaults:c.defaultsDeep({type:"chess.RookWhite",size:{width:32,height:34}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.chess.RookBlack=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:#000000; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 9,39 L 36,39 L 36,36 L 9,36 L 9,39 z "      style="stroke-linecap:butt;" />    <path      d="M 12.5,32 L 14,29.5 L 31,29.5 L 32.5,32 L 12.5,32 z "      style="stroke-linecap:butt;" />    <path      d="M 12,36 L 12,32 L 33,32 L 33,36 L 12,36 z "      style="stroke-linecap:butt;" />    <path      d="M 14,29.5 L 14,16.5 L 31,16.5 L 31,29.5 L 14,29.5 z "      style="stroke-linecap:butt;stroke-linejoin:miter;" />    <path      d="M 14,16.5 L 11,14 L 34,14 L 31,16.5 L 14,16.5 z "      style="stroke-linecap:butt;" />    <path      d="M 11,14 L 11,9 L 15,9 L 15,11 L 20,11 L 20,9 L 25,9 L 25,11 L 30,11 L 30,9 L 34,9 L 34,14 L 11,14 z "      style="stroke-linecap:butt;" />    <path      d="M 12,35.5 L 33,35.5 L 33,35.5"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />    <path      d="M 13,31.5 L 32,31.5"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />    <path      d="M 14,29.5 L 31,29.5"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />    <path      d="M 14,16.5 L 31,16.5"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />    <path      d="M 11,14 L 34,14"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />  </g></g></g>',defaults:c.defaultsDeep({type:"chess.RookBlack",size:{width:32,height:34}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.chess.BishopWhite=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:none; fill-rule:evenodd; fill-opacity:1; stroke:#000000; stroke-width:1.5; stroke-linecap:round; stroke-linejoin:round; stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <g style="fill:#ffffff; stroke:#000000; stroke-linecap:butt;">       <path        d="M 9,36 C 12.39,35.03 19.11,36.43 22.5,34 C 25.89,36.43 32.61,35.03 36,36 C 36,36 37.65,36.54 39,38 C 38.32,38.97 37.35,38.99 36,38.5 C 32.61,37.53 25.89,38.96 22.5,37.5 C 19.11,38.96 12.39,37.53 9,38.5 C 7.646,38.99 6.677,38.97 6,38 C 7.354,36.06 9,36 9,36 z" />      <path        d="M 15,32 C 17.5,34.5 27.5,34.5 30,32 C 30.5,30.5 30,30 30,30 C 30,27.5 27.5,26 27.5,26 C 33,24.5 33.5,14.5 22.5,10.5 C 11.5,14.5 12,24.5 17.5,26 C 17.5,26 15,27.5 15,30 C 15,30 14.5,30.5 15,32 z" />      <path        d="M 25 8 A 2.5 2.5 0 1 1  20,8 A 2.5 2.5 0 1 1  25 8 z" />    </g>    <path      d="M 17.5,26 L 27.5,26 M 15,30 L 30,30 M 22.5,15.5 L 22.5,20.5 M 20,18 L 25,18"      style="fill:none; stroke:#000000; stroke-linejoin:miter;" />  </g></g></g>',defaults:c.defaultsDeep({type:"chess.BishopWhite",size:{width:38,height:38}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.chess.BishopBlack=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:none; fill-rule:evenodd; fill-opacity:1; stroke:#000000; stroke-width:1.5; stroke-linecap:round; stroke-linejoin:round; stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <g style="fill:#000000; stroke:#000000; stroke-linecap:butt;">       <path        d="M 9,36 C 12.39,35.03 19.11,36.43 22.5,34 C 25.89,36.43 32.61,35.03 36,36 C 36,36 37.65,36.54 39,38 C 38.32,38.97 37.35,38.99 36,38.5 C 32.61,37.53 25.89,38.96 22.5,37.5 C 19.11,38.96 12.39,37.53 9,38.5 C 7.646,38.99 6.677,38.97 6,38 C 7.354,36.06 9,36 9,36 z" />      <path        d="M 15,32 C 17.5,34.5 27.5,34.5 30,32 C 30.5,30.5 30,30 30,30 C 30,27.5 27.5,26 27.5,26 C 33,24.5 33.5,14.5 22.5,10.5 C 11.5,14.5 12,24.5 17.5,26 C 17.5,26 15,27.5 15,30 C 15,30 14.5,30.5 15,32 z" />      <path        d="M 25 8 A 2.5 2.5 0 1 1  20,8 A 2.5 2.5 0 1 1  25 8 z" />    </g>    <path       d="M 17.5,26 L 27.5,26 M 15,30 L 30,30 M 22.5,15.5 L 22.5,20.5 M 20,18 L 25,18"       style="fill:none; stroke:#ffffff; stroke-linejoin:miter;" />  </g></g></g>',defaults:c.defaultsDeep({type:"chess.BishopBlack",size:{width:38,height:38}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.chess.KnightWhite=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:none; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 22,10 C 32.5,11 38.5,18 38,39 L 15,39 C 15,30 25,32.5 23,18"      style="fill:#ffffff; stroke:#000000;" />    <path      d="M 24,18 C 24.38,20.91 18.45,25.37 16,27 C 13,29 13.18,31.34 11,31 C 9.958,30.06 12.41,27.96 11,28 C 10,28 11.19,29.23 10,30 C 9,30 5.997,31 6,26 C 6,24 12,14 12,14 C 12,14 13.89,12.1 14,10.5 C 13.27,9.506 13.5,8.5 13.5,7.5 C 14.5,6.5 16.5,10 16.5,10 L 18.5,10 C 18.5,10 19.28,8.008 21,7 C 22,7 22,10 22,10"      style="fill:#ffffff; stroke:#000000;" />    <path      d="M 9.5 25.5 A 0.5 0.5 0 1 1 8.5,25.5 A 0.5 0.5 0 1 1 9.5 25.5 z"      style="fill:#000000; stroke:#000000;" />    <path      d="M 15 15.5 A 0.5 1.5 0 1 1  14,15.5 A 0.5 1.5 0 1 1  15 15.5 z"      transform="matrix(0.866,0.5,-0.5,0.866,9.693,-5.173)"      style="fill:#000000; stroke:#000000;" />  </g></g></g>',defaults:c.defaultsDeep({type:"chess.KnightWhite",size:{width:38,height:37}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.chess.KnightBlack=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:none; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 22,10 C 32.5,11 38.5,18 38,39 L 15,39 C 15,30 25,32.5 23,18"      style="fill:#000000; stroke:#000000;" />    <path      d="M 24,18 C 24.38,20.91 18.45,25.37 16,27 C 13,29 13.18,31.34 11,31 C 9.958,30.06 12.41,27.96 11,28 C 10,28 11.19,29.23 10,30 C 9,30 5.997,31 6,26 C 6,24 12,14 12,14 C 12,14 13.89,12.1 14,10.5 C 13.27,9.506 13.5,8.5 13.5,7.5 C 14.5,6.5 16.5,10 16.5,10 L 18.5,10 C 18.5,10 19.28,8.008 21,7 C 22,7 22,10 22,10"      style="fill:#000000; stroke:#000000;" />    <path      d="M 9.5 25.5 A 0.5 0.5 0 1 1 8.5,25.5 A 0.5 0.5 0 1 1 9.5 25.5 z"      style="fill:#ffffff; stroke:#ffffff;" />    <path      d="M 15 15.5 A 0.5 1.5 0 1 1  14,15.5 A 0.5 1.5 0 1 1  15 15.5 z"      transform="matrix(0.866,0.5,-0.5,0.866,9.693,-5.173)"      style="fill:#ffffff; stroke:#ffffff;" />    <path      d="M 24.55,10.4 L 24.1,11.85 L 24.6,12 C 27.75,13 30.25,14.49 32.5,18.75 C 34.75,23.01 35.75,29.06 35.25,39 L 35.2,39.5 L 37.45,39.5 L 37.5,39 C 38,28.94 36.62,22.15 34.25,17.66 C 31.88,13.17 28.46,11.02 25.06,10.5 L 24.55,10.4 z "      style="fill:#ffffff; stroke:none;" />  </g></g></g>',defaults:c.defaultsDeep({type:"chess.KnightBlack",size:{width:38,height:37}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.chess.PawnWhite=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><path d="M 22,9 C 19.79,9 18,10.79 18,13 C 18,13.89 18.29,14.71 18.78,15.38 C 16.83,16.5 15.5,18.59 15.5,21 C 15.5,23.03 16.44,24.84 17.91,26.03 C 14.91,27.09 10.5,31.58 10.5,39.5 L 33.5,39.5 C 33.5,31.58 29.09,27.09 26.09,26.03 C 27.56,24.84 28.5,23.03 28.5,21 C 28.5,18.59 27.17,16.5 25.22,15.38 C 25.71,14.71 26,13.89 26,13 C 26,10.79 24.21,9 22,9 z "  style="opacity:1; fill:#ffffff; fill-opacity:1; fill-rule:nonzero; stroke:#000000; stroke-width:1.5; stroke-linecap:round; stroke-linejoin:miter; stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;" /></g></g>',defaults:c.defaultsDeep({type:"chess.PawnWhite",size:{width:28,height:33}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.chess.PawnBlack=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><path d="M 22,9 C 19.79,9 18,10.79 18,13 C 18,13.89 18.29,14.71 18.78,15.38 C 16.83,16.5 15.5,18.59 15.5,21 C 15.5,23.03 16.44,24.84 17.91,26.03 C 14.91,27.09 10.5,31.58 10.5,39.5 L 33.5,39.5 C 33.5,31.58 29.09,27.09 26.09,26.03 C 27.56,24.84 28.5,23.03 28.5,21 C 28.5,18.59 27.17,16.5 25.22,15.38 C 25.71,14.71 26,13.89 26,13 C 26,10.79 24.21,9 22,9 z "  style="opacity:1; fill:#000000; fill-opacity:1; fill-rule:nonzero; stroke:#000000; stroke-width:1.5; stroke-linecap:round; stroke-linejoin:miter; stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;" /></g></g>',defaults:c.defaultsDeep({type:"chess.PawnBlack",size:{width:28,height:33}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.pn={},g.shapes.pn.Place=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><circle class="root"/><g class="tokens" /></g><text class="label"/></g>',defaults:c.defaultsDeep({type:"pn.Place",size:{width:50,height:50},attrs:{".root":{r:25,fill:"#ffffff",stroke:"#000000",transform:"translate(25, 25)"},".label":{"text-anchor":"middle","ref-x":.5,"ref-y":-20,ref:".root",fill:"#000000","font-size":12},".tokens > circle":{fill:"#000000",r:5},".tokens.one > circle":{transform:"translate(25, 25)"},".tokens.two > circle:nth-child(1)":{transform:"translate(19, 25)"},".tokens.two > circle:nth-child(2)":{transform:"translate(31, 25)"},".tokens.three > circle:nth-child(1)":{transform:"translate(18, 29)"},".tokens.three > circle:nth-child(2)":{transform:"translate(25, 19)"},".tokens.three > circle:nth-child(3)":{transform:"translate(32, 29)"},".tokens.alot > text":{transform:"translate(25, 18)","text-anchor":"middle",fill:"#000000"}}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.pn.PlaceView=g.dia.ElementView.extend({initialize:function(){g.dia.ElementView.prototype.initialize.apply(this,arguments),this.model.on("change:tokens",function(){this.renderTokens(),this.update()},this)},render:function(){g.dia.ElementView.prototype.render.apply(this,arguments),this.renderTokens(),this.update()},renderTokens:function(){var a=this.$(".tokens").empty();a[0].className.baseVal="tokens";var b=this.model.get("tokens");if(b)switch(b){case 1:a[0].className.baseVal+=" one",a.append(e("<circle/>").node);break;case 2:a[0].className.baseVal+=" two",a.append(e("<circle/>").node,e("<circle/>").node);break;case 3:a[0].className.baseVal+=" three",a.append(e("<circle/>").node,e("<circle/>").node,e("<circle/>").node);break;default:a[0].className.baseVal+=" alot",a.append(e("<text/>").text(b+"").node)}}}),g.shapes.pn.Transition=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><rect class="root"/></g></g><text class="label"/>',defaults:c.defaultsDeep({type:"pn.Transition",size:{width:12,height:50},attrs:{rect:{width:12,height:50,fill:"#000000",stroke:"#000000"},".label":{"text-anchor":"middle","ref-x":.5,"ref-y":-20,ref:"rect",fill:"#000000","font-size":12}}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.pn.Link=g.dia.Link.extend({defaults:c.defaultsDeep({type:"pn.Link",attrs:{".marker-target":{d:"M 10 0 L 0 5 L 10 10 z"}}},g.dia.Link.prototype.defaults)}),g.shapes.devs={},g.shapes.devs.Model=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><rect class="body"/><text class="label"/></g>',portMarkup:'<circle class="port-body"/>',portLabelMarkup:'<text class="port-label"/>',defaults:c.defaultsDeep({type:"devs.Model",inPorts:[],outPorts:[],size:{width:80,height:80},attrs:{".":{magnet:!1},".label":{text:"Model","ref-x":.5,"ref-y":10,"font-size":18,"text-anchor":"middle",fill:"#000"},".body":{"ref-width":"100%","ref-height":"100%",stroke:"#000"}},ports:{groups:{in:{position:{name:"left"},attrs:{".port-label":{fill:"#000"},".port-body":{fill:"#fff",stroke:"#000",r:10,magnet:!0}},label:{position:{name:"left",args:{y:10}}}},out:{position:{name:"right"},attrs:{".port-label":{fill:"#000"},".port-body":{fill:"#fff",stroke:"#000",r:10,magnet:!0}},label:{position:{name:"right",args:{y:10}}}}}}},g.shapes.basic.Generic.prototype.defaults),initialize:function(){g.shapes.basic.Generic.prototype.initialize.apply(this,arguments),this.on("change:inPorts change:outPorts",this.updatePortItems,this),this.updatePortItems()},updatePortItems:function(a,b,d){var e=c.uniq(this.get("inPorts")),f=c.difference(c.uniq(this.get("outPorts")),e),g=this.createPortItems("in",e),h=this.createPortItems("out",f);this.prop("ports/items",g.concat(h),c.extend({rewrite:!0},d))},createPortItem:function(a,b){return{id:b,group:a,attrs:{".port-label":{text:b}}}},createPortItems:function(a,b){return c.map(b,c.bind(this.createPortItem,this,a))},_addGroupPort:function(a,b,d){var e=this.get(b);return this.set(b,c.isArray(e)?e.concat(a):[a],d)},addOutPort:function(a,b){return this._addGroupPort(a,"outPorts",b)},addInPort:function(a,b){return this._addGroupPort(a,"inPorts",b)},_removeGroupPort:function(a,b,d){return this.set(b,c.without(this.get(b),a),d)},removeOutPort:function(a,b){return this._removeGroupPort(a,"outPorts",b)},removeInPort:function(a,b){return this._removeGroupPort(a,"inPorts",b)},_changeGroup:function(a,b,d){return this.prop("ports/groups/"+a,c.isObject(b)?b:{},d)},changeInGroup:function(a,b){return this._changeGroup("in",a,b)},changeOutGroup:function(a,b){return this._changeGroup("out",a,b)}}),g.shapes.devs.Atomic=g.shapes.devs.Model.extend({defaults:c.defaultsDeep({type:"devs.Atomic",size:{width:80,height:80},attrs:{".label":{text:"Atomic"}}},g.shapes.devs.Model.prototype.defaults)}),g.shapes.devs.Coupled=g.shapes.devs.Model.extend({defaults:c.defaultsDeep({type:"devs.Coupled",size:{width:200,height:300},attrs:{".label":{text:"Coupled"}}},g.shapes.devs.Model.prototype.defaults)}),g.shapes.devs.Link=g.dia.Link.extend({defaults:{type:"devs.Link",attrs:{".connection":{"stroke-width":2}}}}),g.shapes.uml={},g.shapes.uml.Class=g.shapes.basic.Generic.extend({markup:['<g class="rotatable">','<g class="scalable">','<rect class="uml-class-name-rect"/><rect class="uml-class-attrs-rect"/><rect class="uml-class-methods-rect"/>',"</g>",'<text class="uml-class-name-text"/><text class="uml-class-attrs-text"/><text class="uml-class-methods-text"/>',"</g>"].join(""),defaults:c.defaultsDeep({type:"uml.Class",attrs:{rect:{width:200},".uml-class-name-rect":{stroke:"black","stroke-width":2,fill:"#3498db"},".uml-class-attrs-rect":{stroke:"black","stroke-width":2,fill:"#2980b9"},".uml-class-methods-rect":{stroke:"black","stroke-width":2,fill:"#2980b9"},".uml-class-name-text":{ref:".uml-class-name-rect","ref-y":.5,"ref-x":.5,"text-anchor":"middle","y-alignment":"middle","font-weight":"bold",fill:"black","font-size":12,"font-family":"Times New Roman"},".uml-class-attrs-text":{ref:".uml-class-attrs-rect","ref-y":5,"ref-x":5,fill:"black","font-size":12,"font-family":"Times New Roman"},".uml-class-methods-text":{ref:".uml-class-methods-rect","ref-y":5,"ref-x":5,fill:"black","font-size":12,"font-family":"Times New Roman"}},name:[],attributes:[],methods:[]},g.shapes.basic.Generic.prototype.defaults),initialize:function(){this.on("change:name change:attributes change:methods",function(){this.updateRectangles(),this.trigger("uml-update")},this),this.updateRectangles(),g.shapes.basic.Generic.prototype.initialize.apply(this,arguments)},getClassName:function(){return this.get("name")},updateRectangles:function(){var a=this.get("attrs"),b=[{type:"name",text:this.getClassName()},{type:"attrs",text:this.get("attributes")},{type:"methods",text:this.get("methods")}],d=0;c.each(b,function(b){var e=c.isArray(b.text)?b.text:[b.text],f=20*e.length+20;a[".uml-class-"+b.type+"-text"].text=e.join("\n"),a[".uml-class-"+b.type+"-rect"].height=f,a[".uml-class-"+b.type+"-rect"].transform="translate(0,"+d+")",d+=f})}}),g.shapes.uml.ClassView=g.dia.ElementView.extend({initialize:function(){g.dia.ElementView.prototype.initialize.apply(this,arguments),this.listenTo(this.model,"uml-update",function(){this.update(),this.resize()})}}),g.shapes.uml.Abstract=g.shapes.uml.Class.extend({defaults:c.defaultsDeep({type:"uml.Abstract",attrs:{".uml-class-name-rect":{fill:"#e74c3c"},".uml-class-attrs-rect":{fill:"#c0392b"},".uml-class-methods-rect":{fill:"#c0392b"}}},g.shapes.uml.Class.prototype.defaults),getClassName:function(){return["<<Abstract>>",this.get("name")]}}),g.shapes.uml.AbstractView=g.shapes.uml.ClassView,g.shapes.uml.Interface=g.shapes.uml.Class.extend({defaults:c.defaultsDeep({type:"uml.Interface",attrs:{".uml-class-name-rect":{fill:"#f1c40f"},".uml-class-attrs-rect":{fill:"#f39c12"},".uml-class-methods-rect":{fill:"#f39c12"}}},g.shapes.uml.Class.prototype.defaults),getClassName:function(){return["<<Interface>>",this.get("name")]}}),g.shapes.uml.InterfaceView=g.shapes.uml.ClassView,g.shapes.uml.Generalization=g.dia.Link.extend({defaults:{type:"uml.Generalization",attrs:{".marker-target":{d:"M 20 0 L 0 10 L 20 20 z",fill:"white"}}}}),g.shapes.uml.Implementation=g.dia.Link.extend({defaults:{type:"uml.Implementation",attrs:{".marker-target":{d:"M 20 0 L 0 10 L 20 20 z",fill:"white"},".connection":{"stroke-dasharray":"3,3"}}}}),g.shapes.uml.Aggregation=g.dia.Link.extend({defaults:{type:"uml.Aggregation",attrs:{".marker-target":{d:"M 40 10 L 20 20 L 0 10 L 20 0 z",fill:"white"}}}}),g.shapes.uml.Composition=g.dia.Link.extend({defaults:{type:"uml.Composition",attrs:{".marker-target":{d:"M 40 10 L 20 20 L 0 10 L 20 0 z",fill:"black"}}}}),g.shapes.uml.Association=g.dia.Link.extend({defaults:{type:"uml.Association"}}),g.shapes.uml.State=g.shapes.basic.Generic.extend({markup:['<g class="rotatable">','<g class="scalable">','<rect class="uml-state-body"/>',"</g>",'<path class="uml-state-separator"/>','<text class="uml-state-name"/>','<text class="uml-state-events"/>',"</g>"].join(""),defaults:c.defaultsDeep({type:"uml.State",attrs:{".uml-state-body":{width:200,height:200,rx:10,ry:10,fill:"#ecf0f1",stroke:"#bdc3c7","stroke-width":3},".uml-state-separator":{stroke:"#bdc3c7","stroke-width":2},".uml-state-name":{ref:".uml-state-body","ref-x":.5,"ref-y":5,"text-anchor":"middle",fill:"#000000","font-family":"Courier New","font-size":14},".uml-state-events":{ref:".uml-state-separator","ref-x":5,"ref-y":5,fill:"#000000","font-family":"Courier New","font-size":14}},name:"State",events:[]},g.shapes.basic.Generic.prototype.defaults),initialize:function(){this.on({"change:name":this.updateName,"change:events":this.updateEvents,"change:size":this.updatePath},this),this.updateName(),this.updateEvents(),this.updatePath(),g.shapes.basic.Generic.prototype.initialize.apply(this,arguments)},updateName:function(){this.attr(".uml-state-name/text",this.get("name"))},updateEvents:function(){this.attr(".uml-state-events/text",this.get("events").join("\n"))},updatePath:function(){var a="M 0 20 L "+this.get("size").width+" 20";this.attr(".uml-state-separator/d",a,{silent:!0})}}),g.shapes.uml.StartState=g.shapes.basic.Circle.extend({defaults:c.defaultsDeep({type:"uml.StartState",attrs:{circle:{fill:"#34495e",stroke:"#2c3e50","stroke-width":2,rx:1}}},g.shapes.basic.Circle.prototype.defaults)}),g.shapes.uml.EndState=g.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><circle class="outer"/><circle class="inner"/></g></g>',defaults:c.defaultsDeep({type:"uml.EndState",size:{width:20,height:20},attrs:{"circle.outer":{transform:"translate(10, 10)",r:10,fill:"#ffffff",stroke:"#2c3e50"},"circle.inner":{transform:"translate(10, 10)",r:6,fill:"#34495e"}}},g.shapes.basic.Generic.prototype.defaults)}),g.shapes.uml.Transition=g.dia.Link.extend({defaults:{type:"uml.Transition",attrs:{".marker-target":{d:"M 10 0 L 0 5 L 10 10 z",fill:"#34495e",stroke:"#2c3e50"},".connection":{stroke:"#2c3e50"}}}}),g.shapes.logic={},g.shapes.logic.Gate=g.shapes.basic.Generic.extend({defaults:c.defaultsDeep({type:"logic.Gate",size:{width:80,height:40},attrs:{".":{magnet:!1},".body":{width:100,height:50},circle:{r:7,stroke:"black",fill:"transparent","stroke-width":2}}},g.shapes.basic.Generic.prototype.defaults),operation:function(){return!0}}),g.shapes.logic.IO=g.shapes.logic.Gate.extend({markup:'<g class="rotatable"><g class="scalable"><rect class="body"/></g><path class="wire"/><circle/><text/></g>',defaults:c.defaultsDeep({type:"logic.IO",size:{width:60,height:30},attrs:{".body":{fill:"white",stroke:"black","stroke-width":2},".wire":{ref:".body","ref-y":.5,stroke:"black"},text:{fill:"black",ref:".body","ref-x":.5,"ref-y":.5,"y-alignment":"middle","text-anchor":"middle","font-weight":"bold","font-variant":"small-caps","text-transform":"capitalize","font-size":"14px"}}},g.shapes.logic.Gate.prototype.defaults)}),g.shapes.logic.Input=g.shapes.logic.IO.extend({defaults:c.defaultsDeep({type:"logic.Input",attrs:{".wire":{"ref-dx":0,d:"M 0 0 L 23 0"},circle:{ref:".body","ref-dx":30,"ref-y":.5,magnet:!0,class:"output",port:"out"},text:{text:"input"}}},g.shapes.logic.IO.prototype.defaults)}),g.shapes.logic.Output=g.shapes.logic.IO.extend({defaults:c.defaultsDeep({type:"logic.Output",attrs:{".wire":{"ref-x":0,d:"M 0 0 L -23 0"},circle:{ref:".body","ref-x":-30,"ref-y":.5,magnet:"passive",class:"input",port:"in"},text:{text:"output"}}},g.shapes.logic.IO.prototype.defaults)}),g.shapes.logic.Gate11=g.shapes.logic.Gate.extend({markup:'<g class="rotatable"><g class="scalable"><image class="body"/></g><circle class="input"/><circle class="output"/></g>',defaults:c.defaultsDeep({type:"logic.Gate11",attrs:{".input":{ref:".body","ref-x":-2,"ref-y":.5,magnet:"passive",port:"in"},".output":{ref:".body","ref-dx":2,"ref-y":.5,magnet:!0,port:"out"}}},g.shapes.logic.Gate.prototype.defaults)}),g.shapes.logic.Gate21=g.shapes.logic.Gate.extend({markup:'<g class="rotatable"><g class="scalable"><image class="body"/></g><circle class="input input1"/><circle  class="input input2"/><circle class="output"/></g>',defaults:c.defaultsDeep({type:"logic.Gate21",attrs:{".input1":{ref:".body","ref-x":-2,"ref-y":.3,magnet:"passive",port:"in1"},".input2":{ref:".body","ref-x":-2,"ref-y":.7,magnet:"passive",port:"in2"},".output":{ref:".body","ref-dx":2,"ref-y":.5,magnet:!0,port:"out"}}},g.shapes.logic.Gate.prototype.defaults)}),g.shapes.logic.Repeater=g.shapes.logic.Gate11.extend({defaults:c.defaultsDeep({type:"logic.Repeater",attrs:{image:{
"xlink:href":"data:image/svg+xml;base64,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"}}},g.shapes.logic.Gate11.prototype.defaults),operation:function(a){return a}}),g.shapes.logic.Not=g.shapes.logic.Gate11.extend({defaults:c.defaultsDeep({type:"logic.Not",attrs:{image:{"xlink:href":"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhLS0gQ3JlYXRlZCB3aXRoIElua3NjYXBlIChodHRwOi8vd3d3Lmlua3NjYXBlLm9yZy8pIC0tPgo8c3ZnCiAgIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyIKICAgeG1sbnM6Y2M9Imh0dHA6Ly9jcmVhdGl2ZWNvbW1vbnMub3JnL25zIyIKICAgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIgogICB4bWxuczpzdmc9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogICB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciCiAgIHhtbG5zOnNvZGlwb2RpPSJodHRwOi8vc29kaXBvZGkuc291cmNlZm9yZ2UubmV0L0RURC9zb2RpcG9kaS0wLmR0ZCIKICAgeG1sbnM6aW5rc2NhcGU9Imh0dHA6Ly93d3cuaW5rc2NhcGUub3JnL25hbWVzcGFjZXMvaW5rc2NhcGUiCiAgIHdpZHRoPSIxMDAiCiAgIGhlaWdodD0iNTAiCiAgIGlkPSJzdmcyIgogICBzb2RpcG9kaTp2ZXJzaW9uPSIwLjMyIgogICBpbmtzY2FwZTp2ZXJzaW9uPSIwLjQ2IgogICB2ZXJzaW9uPSIxLjAiCiAgIHNvZGlwb2RpOmRvY25hbWU9Ik5PVCBBTlNJLnN2ZyIKICAgaW5rc2NhcGU6b3V0cHV0X2V4dGVuc2lvbj0ib3JnLmlua3NjYXBlLm91dHB1dC5zdmcuaW5rc2NhcGUiPgogIDxkZWZzCiAgICAgaWQ9ImRlZnM0Ij4KICAgIDxpbmtzY2FwZTpwZXJzcGVjdGl2ZQogICAgICAgc29kaXBvZGk6dHlwZT0iaW5rc2NhcGU6cGVyc3AzZCIKICAgICAgIGlua3NjYXBlOnZwX3g9IjAgOiAxNSA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF95PSIwIDogMTAwMCA6IDAiCiAgICAgICBpbmtzY2FwZTp2cF96PSI1MCA6IDE1IDogMSIKICAgICAgIGlua3NjYXBlOnBlcnNwM2Qtb3JpZ2luPSIyNSA6IDEwIDogMSIKICAgICAgIGlkPSJwZXJzcGVjdGl2ZTI3MTQiIC8+CiAgICA8aW5rc2NhcGU6cGVyc3BlY3RpdmUKICAgICAgIHNvZGlwb2RpOnR5cGU9Imlua3NjYXBlOnBlcnNwM2QiCiAgICAgICBpbmtzY2FwZTp2cF94PSIwIDogMC41IDogMSIKICAgICAgIGlua3NjYXBlOnZwX3k9IjAgOiAxMDAwIDogMCIKICAgICAgIGlua3NjYXBlOnZwX3o9IjEgOiAwLjUgOiAxIgogICAgICAgaW5rc2NhcGU6cGVyc3AzZC1vcmlnaW49IjAuNSA6IDAuMzMzMzMzMzMgOiAxIgogICAgICAgaWQ9InBlcnNwZWN0aXZlMjgwNiIgLz4KICAgIDxpbmtzY2FwZTpwZXJzcGVjdGl2ZQogICAgICAgaWQ9InBlcnNwZWN0aXZlMjgxOSIKICAgICAgIGlua3NjYXBlOnBlcnNwM2Qtb3JpZ2luPSIzNzIuMDQ3MjQgOiAzNTAuNzg3MzkgOiAxIgogICAgICAgaW5rc2NhcGU6dnBfej0iNzQ0LjA5NDQ4IDogNTI2LjE4MTA5IDogMSIKICAgICAgIGlua3NjYXBlOnZwX3k9IjAgOiAxMDAwIDogMCIKICAgICAgIGlua3NjYXBlOnZwX3g9IjAgOiA1MjYuMTgxMDkgOiAxIgogICAgICAgc29kaXBvZGk6dHlwZT0iaW5rc2NhcGU6cGVyc3AzZCIgLz4KICAgIDxpbmtzY2FwZTpwZXJzcGVjdGl2ZQogICAgICAgaWQ9InBlcnNwZWN0aXZlMjc3NyIKICAgICAgIGlua3NjYXBlOnBlcnNwM2Qtb3JpZ2luPSI3NSA6IDQwIDogMSIKICAgICAgIGlua3NjYXBlOnZwX3o9IjE1MCA6IDYwIDogMSIKICAgICAgIGlua3NjYXBlOnZwX3k9IjAgOiAxMDAwIDogMCIKICAgICAgIGlua3NjYXBlOnZwX3g9IjAgOiA2MCA6IDEiCiAgICAgICBzb2RpcG9kaTp0eXBlPSJpbmtzY2FwZTpwZXJzcDNkIiAvPgogICAgPGlua3NjYXBlOnBlcnNwZWN0aXZlCiAgICAgICBpZD0icGVyc3BlY3RpdmUzMjc1IgogICAgICAgaW5rc2NhcGU6cGVyc3AzZC1vcmlnaW49IjUwIDogMzMuMzMzMzMzIDogMSIKICAgICAgIGlua3NjYXBlOnZwX3o9IjEwMCA6IDUwIDogMSIKICAgICAgIGlua3NjYXBlOnZwX3k9IjAgOiAxMDAwIDogMCIKICAgICAgIGlua3NjYXBlOnZwX3g9IjAgOiA1MCA6IDEiCiAgICAgICBzb2RpcG9kaTp0eXBlPSJpbmtzY2FwZTpwZXJzcDNkIiAvPgogICAgPGlua3NjYXBlOnBlcnNwZWN0aXZlCiAgICAgICBpZD0icGVyc3BlY3RpdmU1NTMzIgogICAgICAgaW5rc2NhcGU6cGVyc3AzZC1vcmlnaW49IjMyIDogMjEuMzMzMzMzIDogMSIKICAgICAgIGlua3NjYXBlOnZwX3o9IjY0IDogMzIgOiAxIgogICAgICAgaW5rc2NhcGU6dnBfeT0iMCA6IDEwMDAgOiAwIgogICAgICAgaW5rc2NhcGU6dnBfeD0iMCA6IDMyIDogMSIKICAgICAgIHNvZGlwb2RpOnR5cGU9Imlua3NjYXBlOnBlcnNwM2QiIC8+CiAgICA8aW5rc2NhcGU6cGVyc3BlY3RpdmUKICAgICAgIGlkPSJwZXJzcGVjdGl2ZTI1NTciCiAgICAgICBpbmtzY2FwZTpwZXJzcDNkLW9yaWdpbj0iMjUgOiAxNi42NjY2NjcgOiAxIgogICAgICAgaW5rc2NhcGU6dnBfej0iNTAgOiAyNSA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF95PSIwIDogMTAwMCA6IDAiCiAgICAgICBpbmtzY2FwZTp2cF94PSIwIDogMjUgOiAxIgogICAgICAgc29kaXBvZGk6dHlwZT0iaW5rc2NhcGU6cGVyc3AzZCIgLz4KICA8L2RlZnM+CiAgPHNvZGlwb2RpOm5hbWVkdmlldwogICAgIGlkPSJiYXNlIgogICAgIHBhZ2Vjb2xvcj0iI2ZmZmZmZiIKICAgICBib3JkZXJjb2xvcj0iIzY2NjY2NiIKICAgICBib3JkZXJvcGFjaXR5PSIxLjAiCiAgICAgaW5rc2NhcGU6cGFnZW9wYWNpdHk9IjAuMCIKICAgICBpbmtzY2FwZTpwYWdlc2hhZG93PSIyIgogICAgIGlua3NjYXBlOnpvb209IjgiCiAgICAgaW5rc2NhcGU6Y3g9Ijg0LjY4NTM1MiIKICAgICBpbmtzY2FwZTpjeT0iMTUuMjg4NjI4IgogICAgIGlua3NjYXBlOmRvY3VtZW50LXVuaXRzPSJweCIKICAgICBpbmtzY2FwZTpjdXJyZW50LWxheWVyPSJsYXllcjEiCiAgICAgc2hvd2dyaWQ9InRydWUiCiAgICAgaW5rc2NhcGU6Z3JpZC1iYm94PSJ0cnVlIgogICAgIGlua3NjYXBlOmdyaWQtcG9pbnRzPSJ0cnVlIgogICAgIGdyaWR0b2xlcmFuY2U9IjEwMDAwIgogICAgIGlua3NjYXBlOndpbmRvdy13aWR0aD0iMTM5OSIKICAgICBpbmtzY2FwZTp3aW5kb3ctaGVpZ2h0PSI4NzQiCiAgICAgaW5rc2NhcGU6d2luZG93LXg9IjMzIgogICAgIGlua3NjYXBlOndpbmRvdy15PSIwIgogICAgIGlua3NjYXBlOnNuYXAtYmJveD0idHJ1ZSI+CiAgICA8aW5rc2NhcGU6Z3JpZAogICAgICAgaWQ9IkdyaWRGcm9tUHJlMDQ2U2V0dGluZ3MiCiAgICAgICB0eXBlPSJ4eWdyaWQiCiAgICAgICBvcmlnaW54PSIwcHgiCiAgICAgICBvcmlnaW55PSIwcHgiCiAgICAgICBzcGFjaW5neD0iMXB4IgogICAgICAgc3BhY2luZ3k9IjFweCIKICAgICAgIGNvbG9yPSIjMDAwMGZmIgogICAgICAgZW1wY29sb3I9IiMwMDAwZmYiCiAgICAgICBvcGFjaXR5PSIwLjIiCiAgICAgICBlbXBvcGFjaXR5PSIwLjQiCiAgICAgICBlbXBzcGFjaW5nPSI1IgogICAgICAgdmlzaWJsZT0idHJ1ZSIKICAgICAgIGVuYWJsZWQ9InRydWUiIC8+CiAgPC9zb2RpcG9kaTpuYW1lZHZpZXc+CiAgPG1ldGFkYXRhCiAgICAgaWQ9Im1ldGFkYXRhNyI+CiAgICA8cmRmOlJERj4KICAgICAgPGNjOldvcmsKICAgICAgICAgcmRmOmFib3V0PSIiPgogICAgICAgIDxkYzpmb3JtYXQ+aW1hZ2Uvc3ZnK3htbDwvZGM6Zm9ybWF0PgogICAgICAgIDxkYzp0eXBlCiAgICAgICAgICAgcmRmOnJlc291cmNlPSJodHRwOi8vcHVybC5vcmcvZGMvZGNtaXR5cGUvU3RpbGxJbWFnZSIgLz4KICAgICAgPC9jYzpXb3JrPgogICAgPC9yZGY6UkRGPgogIDwvbWV0YWRhdGE+CiAgPGcKICAgICBpbmtzY2FwZTpsYWJlbD0iTGF5ZXIgMSIKICAgICBpbmtzY2FwZTpncm91cG1vZGU9ImxheWVyIgogICAgIGlkPSJsYXllcjEiPgogICAgPHBhdGgKICAgICAgIHN0eWxlPSJmaWxsOm5vbmU7c3Ryb2tlOiMwMDAwMDA7c3Ryb2tlLXdpZHRoOjEuOTk5OTk5ODg7c3Ryb2tlLWxpbmVjYXA6YnV0dDtzdHJva2UtbGluZWpvaW46bWl0ZXI7c3Ryb2tlLW9wYWNpdHk6MSIKICAgICAgIGQ9Ik0gNzkuMTU2OTEsMjUgTCA5NSwyNSIKICAgICAgIGlkPSJwYXRoMzA1OSIKICAgICAgIHNvZGlwb2RpOm5vZGV0eXBlcz0iY2MiIC8+CiAgICA8cGF0aAogICAgICAgc3R5bGU9ImZpbGw6bm9uZTtzdHJva2U6IzAwMDAwMDtzdHJva2Utd2lkdGg6MjtzdHJva2UtbGluZWNhcDpidXR0O3N0cm9rZS1saW5lam9pbjptaXRlcjtzdHJva2Utb3BhY2l0eToxIgogICAgICAgZD0iTSAyOS4wNDM0NzgsMjUgTCA1LjA0MzQ3ODEsMjUiCiAgICAgICBpZD0icGF0aDMwNjEiIC8+CiAgICA8cGF0aAogICAgICAgc3R5bGU9ImZpbGw6IzAwMDAwMDtmaWxsLW9wYWNpdHk6MTtzdHJva2U6bm9uZTtzdHJva2Utd2lkdGg6MztzdHJva2UtbGluZWpvaW46bWl0ZXI7bWFya2VyOm5vbmU7c3Ryb2tlLW9wYWNpdHk6MTt2aXNpYmlsaXR5OnZpc2libGU7ZGlzcGxheTppbmxpbmU7b3ZlcmZsb3c6dmlzaWJsZTtlbmFibGUtYmFja2dyb3VuZDphY2N1bXVsYXRlIgogICAgICAgZD0iTSAyOC45Njg3NSwyLjU5Mzc1IEwgMjguOTY4NzUsNSBMIDI4Ljk2ODc1LDQ1IEwgMjguOTY4NzUsNDcuNDA2MjUgTCAzMS4xMjUsNDYuMzQzNzUgTCA3Mi4xNTYyNSwyNi4zNDM3NSBMIDcyLjE1NjI1LDIzLjY1NjI1IEwgMzEuMTI1LDMuNjU2MjUgTCAyOC45Njg3NSwyLjU5Mzc1IHogTSAzMS45Njg3NSw3LjQwNjI1IEwgNjguMDkzNzUsMjUgTCAzMS45Njg3NSw0Mi41OTM3NSBMIDMxLjk2ODc1LDcuNDA2MjUgeiIKICAgICAgIGlkPSJwYXRoMjYzOCIKICAgICAgIHNvZGlwb2RpOm5vZGV0eXBlcz0iY2NjY2NjY2NjY2NjYyIgLz4KICAgIDxwYXRoCiAgICAgICBzb2RpcG9kaTp0eXBlPSJhcmMiCiAgICAgICBzdHlsZT0iZmlsbDpub25lO2ZpbGwtb3BhY2l0eToxO3N0cm9rZTojMDAwMDAwO3N0cm9rZS13aWR0aDozO3N0cm9rZS1saW5lam9pbjptaXRlcjttYXJrZXI6bm9uZTtzdHJva2Utb3BhY2l0eToxO3Zpc2liaWxpdHk6dmlzaWJsZTtkaXNwbGF5OmlubGluZTtvdmVyZmxvdzp2aXNpYmxlO2VuYWJsZS1iYWNrZ3JvdW5kOmFjY3VtdWxhdGUiCiAgICAgICBpZD0icGF0aDI2NzEiCiAgICAgICBzb2RpcG9kaTpjeD0iNzYiCiAgICAgICBzb2RpcG9kaTpjeT0iMjUiCiAgICAgICBzb2RpcG9kaTpyeD0iNCIKICAgICAgIHNvZGlwb2RpOnJ5PSI0IgogICAgICAgZD0iTSA4MCwyNSBBIDQsNCAwIDEgMSA3MiwyNSBBIDQsNCAwIDEgMSA4MCwyNSB6IgogICAgICAgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoLTEsMCkiIC8+CiAgPC9nPgo8L3N2Zz4K"}}},g.shapes.logic.Gate11.prototype.defaults),operation:function(a){return!a}}),g.shapes.logic.Or=g.shapes.logic.Gate21.extend({defaults:c.defaultsDeep({type:"logic.Or",attrs:{image:{"xlink:href":"data:image/svg+xml;base64,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"}}},g.shapes.logic.Gate21.prototype.defaults),operation:function(a,b){return a||b}}),g.shapes.logic.And=g.shapes.logic.Gate21.extend({defaults:c.defaultsDeep({type:"logic.And",attrs:{image:{"xlink:href":"data:image/svg+xml;base64,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"}}},g.shapes.logic.Gate21.prototype.defaults),operation:function(a,b){return a&&b}}),g.shapes.logic.Nor=g.shapes.logic.Gate21.extend({defaults:c.defaultsDeep({type:"logic.Nor",attrs:{image:{
"xlink:href":"data:image/svg+xml;base64,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"}}},g.shapes.logic.Gate21.prototype.defaults),operation:function(a,b){return!(a||b)}}),g.shapes.logic.Nand=g.shapes.logic.Gate21.extend({defaults:c.defaultsDeep({type:"logic.Nand",attrs:{image:{"xlink:href":"data:image/svg+xml;base64,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"}}},g.shapes.logic.Gate21.prototype.defaults),operation:function(a,b){return!(a&&b)}}),g.shapes.logic.Xor=g.shapes.logic.Gate21.extend({defaults:c.defaultsDeep({type:"logic.Xor",attrs:{image:{"xlink:href":"data:image/svg+xml;base64,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"}}},g.shapes.logic.Gate21.prototype.defaults),operation:function(a,b){return(!a||b)&&(a||!b)}}),g.shapes.logic.Xnor=g.shapes.logic.Gate21.extend({defaults:c.defaultsDeep({type:"logic.Xnor",attrs:{image:{
"xlink:href":"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhLS0gQ3JlYXRlZCB3aXRoIElua3NjYXBlIChodHRwOi8vd3d3Lmlua3NjYXBlLm9yZy8pIC0tPgo8c3ZnCiAgIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyIKICAgeG1sbnM6Y2M9Imh0dHA6Ly9jcmVhdGl2ZWNvbW1vbnMub3JnL25zIyIKICAgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIgogICB4bWxuczpzdmc9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogICB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciCiAgIHhtbG5zOnNvZGlwb2RpPSJodHRwOi8vc29kaXBvZGkuc291cmNlZm9yZ2UubmV0L0RURC9zb2RpcG9kaS0wLmR0ZCIKICAgeG1sbnM6aW5rc2NhcGU9Imh0dHA6Ly93d3cuaW5rc2NhcGUub3JnL25hbWVzcGFjZXMvaW5rc2NhcGUiCiAgIHdpZHRoPSIxMDAiCiAgIGhlaWdodD0iNTAiCiAgIGlkPSJzdmcyIgogICBzb2RpcG9kaTp2ZXJzaW9uPSIwLjMyIgogICBpbmtzY2FwZTp2ZXJzaW9uPSIwLjQ2IgogICB2ZXJzaW9uPSIxLjAiCiAgIHNvZGlwb2RpOmRvY25hbWU9IlhOT1IgQU5TSS5zdmciCiAgIGlua3NjYXBlOm91dHB1dF9leHRlbnNpb249Im9yZy5pbmtzY2FwZS5vdXRwdXQuc3ZnLmlua3NjYXBlIj4KICA8ZGVmcwogICAgIGlkPSJkZWZzNCI+CiAgICA8aW5rc2NhcGU6cGVyc3BlY3RpdmUKICAgICAgIHNvZGlwb2RpOnR5cGU9Imlua3NjYXBlOnBlcnNwM2QiCiAgICAgICBpbmtzY2FwZTp2cF94PSIwIDogMTUgOiAxIgogICAgICAgaW5rc2NhcGU6dnBfeT0iMCA6IDEwMDAgOiAwIgogICAgICAgaW5rc2NhcGU6dnBfej0iNTAgOiAxNSA6IDEiCiAgICAgICBpbmtzY2FwZTpwZXJzcDNkLW9yaWdpbj0iMjUgOiAxMCA6IDEiCiAgICAgICBpZD0icGVyc3BlY3RpdmUyNzE0IiAvPgogICAgPGlua3NjYXBlOnBlcnNwZWN0aXZlCiAgICAgICBzb2RpcG9kaTp0eXBlPSJpbmtzY2FwZTpwZXJzcDNkIgogICAgICAgaW5rc2NhcGU6dnBfeD0iMCA6IDAuNSA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF95PSIwIDogMTAwMCA6IDAiCiAgICAgICBpbmtzY2FwZTp2cF96PSIxIDogMC41IDogMSIKICAgICAgIGlua3NjYXBlOnBlcnNwM2Qtb3JpZ2luPSIwLjUgOiAwLjMzMzMzMzMzIDogMSIKICAgICAgIGlkPSJwZXJzcGVjdGl2ZTI4MDYiIC8+CiAgICA8aW5rc2NhcGU6cGVyc3BlY3RpdmUKICAgICAgIGlkPSJwZXJzcGVjdGl2ZTI4MTkiCiAgICAgICBpbmtzY2FwZTpwZXJzcDNkLW9yaWdpbj0iMzcyLjA0NzI0IDogMzUwLjc4NzM5IDogMSIKICAgICAgIGlua3NjYXBlOnZwX3o9Ijc0NC4wOTQ0OCA6IDUyNi4xODEwOSA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF95PSIwIDogMTAwMCA6IDAiCiAgICAgICBpbmtzY2FwZTp2cF94PSIwIDogNTI2LjE4MTA5IDogMSIKICAgICAgIHNvZGlwb2RpOnR5cGU9Imlua3NjYXBlOnBlcnNwM2QiIC8+CiAgICA8aW5rc2NhcGU6cGVyc3BlY3RpdmUKICAgICAgIGlkPSJwZXJzcGVjdGl2ZTI3NzciCiAgICAgICBpbmtzY2FwZTpwZXJzcDNkLW9yaWdpbj0iNzUgOiA0MCA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF96PSIxNTAgOiA2MCA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF95PSIwIDogMTAwMCA6IDAiCiAgICAgICBpbmtzY2FwZTp2cF94PSIwIDogNjAgOiAxIgogICAgICAgc29kaXBvZGk6dHlwZT0iaW5rc2NhcGU6cGVyc3AzZCIgLz4KICAgIDxpbmtzY2FwZTpwZXJzcGVjdGl2ZQogICAgICAgaWQ9InBlcnNwZWN0aXZlMzI3NSIKICAgICAgIGlua3NjYXBlOnBlcnNwM2Qtb3JpZ2luPSI1MCA6IDMzLjMzMzMzMyA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF96PSIxMDAgOiA1MCA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF95PSIwIDogMTAwMCA6IDAiCiAgICAgICBpbmtzY2FwZTp2cF94PSIwIDogNTAgOiAxIgogICAgICAgc29kaXBvZGk6dHlwZT0iaW5rc2NhcGU6cGVyc3AzZCIgLz4KICAgIDxpbmtzY2FwZTpwZXJzcGVjdGl2ZQogICAgICAgaWQ9InBlcnNwZWN0aXZlNTUzMyIKICAgICAgIGlua3NjYXBlOnBlcnNwM2Qtb3JpZ2luPSIzMiA6IDIxLjMzMzMzMyA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF96PSI2NCA6IDMyIDogMSIKICAgICAgIGlua3NjYXBlOnZwX3k9IjAgOiAxMDAwIDogMCIKICAgICAgIGlua3NjYXBlOnZwX3g9IjAgOiAzMiA6IDEiCiAgICAgICBzb2RpcG9kaTp0eXBlPSJpbmtzY2FwZTpwZXJzcDNkIiAvPgogICAgPGlua3NjYXBlOnBlcnNwZWN0aXZlCiAgICAgICBpZD0icGVyc3BlY3RpdmUyNTU3IgogICAgICAgaW5rc2NhcGU6cGVyc3AzZC1vcmlnaW49IjI1IDogMTYuNjY2NjY3IDogMSIKICAgICAgIGlua3NjYXBlOnZwX3o9IjUwIDogMjUgOiAxIgogICAgICAgaW5rc2NhcGU6dnBfeT0iMCA6IDEwMDAgOiAwIgogICAgICAgaW5rc2NhcGU6dnBfeD0iMCA6IDI1IDogMSIKICAgICAgIHNvZGlwb2RpOnR5cGU9Imlua3NjYXBlOnBlcnNwM2QiIC8+CiAgPC9kZWZzPgogIDxzb2RpcG9kaTpuYW1lZHZpZXcKICAgICBpZD0iYmFzZSIKICAgICBwYWdlY29sb3I9IiNmZmZmZmYiCiAgICAgYm9yZGVyY29sb3I9IiM2NjY2NjYiCiAgICAgYm9yZGVyb3BhY2l0eT0iMS4wIgogICAgIGlua3NjYXBlOnBhZ2VvcGFjaXR5PSIwLjAiCiAgICAgaW5rc2NhcGU6cGFnZXNoYWRvdz0iMiIKICAgICBpbmtzY2FwZTp6b29tPSI0IgogICAgIGlua3NjYXBlOmN4PSI5NS43MjM2NiIKICAgICBpbmtzY2FwZTpjeT0iLTI2Ljc3NTAyMyIKICAgICBpbmtzY2FwZTpkb2N1bWVudC11bml0cz0icHgiCiAgICAgaW5rc2NhcGU6Y3VycmVudC1sYXllcj0ibGF5ZXIxIgogICAgIHNob3dncmlkPSJ0cnVlIgogICAgIGlua3NjYXBlOmdyaWQtYmJveD0idHJ1ZSIKICAgICBpbmtzY2FwZTpncmlkLXBvaW50cz0idHJ1ZSIKICAgICBncmlkdG9sZXJhbmNlPSIxMDAwMCIKICAgICBpbmtzY2FwZTp3aW5kb3ctd2lkdGg9IjEzOTkiCiAgICAgaW5rc2NhcGU6d2luZG93LWhlaWdodD0iODc0IgogICAgIGlua3NjYXBlOndpbmRvdy14PSIzMyIKICAgICBpbmtzY2FwZTp3aW5kb3cteT0iMCIKICAgICBpbmtzY2FwZTpzbmFwLWJib3g9InRydWUiPgogICAgPGlua3NjYXBlOmdyaWQKICAgICAgIGlkPSJHcmlkRnJvbVByZTA0NlNldHRpbmdzIgogICAgICAgdHlwZT0ieHlncmlkIgogICAgICAgb3JpZ2lueD0iMHB4IgogICAgICAgb3JpZ2lueT0iMHB4IgogICAgICAgc3BhY2luZ3g9IjFweCIKICAgICAgIHNwYWNpbmd5PSIxcHgiCiAgICAgICBjb2xvcj0iIzAwMDBmZiIKICAgICAgIGVtcGNvbG9yPSIjMDAwMGZmIgogICAgICAgb3BhY2l0eT0iMC4yIgogICAgICAgZW1wb3BhY2l0eT0iMC40IgogICAgICAgZW1wc3BhY2luZz0iNSIKICAgICAgIHZpc2libGU9InRydWUiCiAgICAgICBlbmFibGVkPSJ0cnVlIiAvPgogIDwvc29kaXBvZGk6bmFtZWR2aWV3PgogIDxtZXRhZGF0YQogICAgIGlkPSJtZXRhZGF0YTciPgogICAgPHJkZjpSREY+CiAgICAgIDxjYzpXb3JrCiAgICAgICAgIHJkZjphYm91dD0iIj4KICAgICAgICA8ZGM6Zm9ybWF0PmltYWdlL3N2Zyt4bWw8L2RjOmZvcm1hdD4KICAgICAgICA8ZGM6dHlwZQogICAgICAgICAgIHJkZjpyZXNvdXJjZT0iaHR0cDovL3B1cmwub3JnL2RjL2RjbWl0eXBlL1N0aWxsSW1hZ2UiIC8+CiAgICAgIDwvY2M6V29yaz4KICAgIDwvcmRmOlJERj4KICA8L21ldGFkYXRhPgogIDxnCiAgICAgaW5rc2NhcGU6bGFiZWw9IkxheWVyIDEiCiAgICAgaW5rc2NhcGU6Z3JvdXBtb2RlPSJsYXllciIKICAgICBpZD0ibGF5ZXIxIj4KICAgIDxwYXRoCiAgICAgICBzdHlsZT0iZmlsbDpub25lO3N0cm9rZTojMDAwMDAwO3N0cm9rZS13aWR0aDoyLjAwMDAwMDI0O3N0cm9rZS1saW5lY2FwOmJ1dHQ7c3Ryb2tlLWxpbmVqb2luOm1pdGVyO3N0cm9rZS1vcGFjaXR5OjEiCiAgICAgICBkPSJNIDc4LjMzMzMzMiwyNSBDIDkxLjY2NjY2NiwyNSA5NSwyNSA5NSwyNSIKICAgICAgIGlkPSJwYXRoMzA1OSIKICAgICAgIHNvZGlwb2RpOm5vZGV0eXBlcz0iY2MiIC8+CiAgICA8cGF0aAogICAgICAgc3R5bGU9ImZpbGw6bm9uZTtzdHJva2U6IzAwMDAwMDtzdHJva2Utd2lkdGg6MS45OTk5OTk4ODtzdHJva2UtbGluZWNhcDpidXR0O3N0cm9rZS1saW5lam9pbjptaXRlcjtzdHJva2Utb3BhY2l0eToxIgogICAgICAgZD0iTSAzMC4zODU3MTcsMTUgTCA0Ljk5OTk5OTgsMTUiCiAgICAgICBpZD0icGF0aDMwNjEiIC8+CiAgICA8cGF0aAogICAgICAgc3R5bGU9ImZpbGw6bm9uZTtzdHJva2U6IzAwMDAwMDtzdHJva2Utd2lkdGg6MS45OTk5OTk3NjtzdHJva2UtbGluZWNhcDpidXR0O3N0cm9rZS1saW5lam9pbjptaXRlcjtzdHJva2Utb3BhY2l0eToxIgogICAgICAgZD0iTSAzMS4zNjIwOTEsMzUgTCA0Ljk5OTk5OTgsMzUiCiAgICAgICBpZD0icGF0aDM5NDQiIC8+CiAgICA8ZwogICAgICAgaWQ9ImcyNTYwIgogICAgICAgaW5rc2NhcGU6bGFiZWw9IkxheWVyIDEiCiAgICAgICB0cmFuc2Zvcm09InRyYW5zbGF0ZSgyNi41LC0zOS41KSI+CiAgICAgIDxwYXRoCiAgICAgICAgIGlkPSJwYXRoMzUxNiIKICAgICAgICAgc3R5bGU9ImZpbGw6IzAwMDAwMDtmaWxsLW9wYWNpdHk6MTtmaWxsLXJ1bGU6ZXZlbm9kZDtzdHJva2U6bm9uZTtzdHJva2Utd2lkdGg6MztzdHJva2UtbGluZWNhcDpidXR0O3N0cm9rZS1saW5lam9pbjptaXRlcjtzdHJva2Utb3BhY2l0eToxIgogICAgICAgICBkPSJNIC0yLjI1LDgxLjUwMDAwNSBDIC0zLjg0NzM3NCw4NC4xNDQ0MDUgLTQuNSw4NC41MDAwMDUgLTQuNSw4NC41MDAwMDUgTCAtOC4xNTYyNSw4NC41MDAwMDUgTCAtNi4xNTYyNSw4Mi4wNjI1MDUgQyAtNi4xNTYyNSw4Mi4wNjI1MDUgLTAuNSw3NS4wNjI0NTEgLTAuNSw2NC41IEMgLTAuNSw1My45Mzc1NDkgLTYuMTU2MjUsNDYuOTM3NSAtNi4xNTYyNSw0Ni45Mzc1IEwgLTguMTU2MjUsNDQuNSBMIC00LjUsNDQuNSBDIC0zLjcxODc1LDQ1LjQzNzUgLTMuMDc4MTI1LDQ2LjE1NjI1IC0yLjI4MTI1LDQ3LjUgQyAtMC40MDg1MzEsNTAuNTk5ODE1IDIuNSw1Ni41MjY2NDYgMi41LDY0LjUgQyAyLjUsNzIuNDUwNjUgLTAuMzk2Njk3LDc4LjM3OTQyNSAtMi4yNSw4MS41MDAwMDUgeiIKICAgICAgICAgc29kaXBvZGk6bm9kZXR5cGVzPSJjY2Njc2NjY2NzYyIgLz4KICAgICAgPHBhdGgKICAgICAgICAgc3R5bGU9ImZpbGw6IzAwMDAwMDtmaWxsLW9wYWNpdHk6MTtmaWxsLXJ1bGU6ZXZlbm9kZDtzdHJva2U6bm9uZTtzdHJva2Utd2lkdGg6MztzdHJva2UtbGluZWNhcDpidXR0O3N0cm9rZS1saW5lam9pbjptaXRlcjtzdHJva2Utb3BhY2l0eToxIgogICAgICAgICBkPSJNIC0yLjQwNjI1LDQ0LjUgTCAtMC40MDYyNSw0Ni45Mzc1IEMgLTAuNDA2MjUsNDYuOTM3NSA1LjI1LDUzLjkzNzU0OSA1LjI1LDY0LjUgQyA1LjI1LDc1LjA2MjQ1MSAtMC40MDYyNSw4Mi4wNjI1IC0wLjQwNjI1LDgyLjA2MjUgTCAtMi40MDYyNSw4NC41IEwgMC43NSw4NC41IEwgMTQuNzUsODQuNSBDIDE3LjE1ODA3Niw4NC41MDAwMDEgMjIuNDM5Njk5LDg0LjUyNDUxNCAyOC4zNzUsODIuMDkzNzUgQyAzNC4zMTAzMDEsNzkuNjYyOTg2IDQwLjkxMTUzNiw3NC43NTA0ODQgNDYuMDYyNSw2NS4yMTg3NSBMIDQ0Ljc1LDY0LjUgTCA0Ni4wNjI1LDYzLjc4MTI1IEMgMzUuNzU5Mzg3LDQ0LjcxNTU5IDE5LjUwNjU3NCw0NC41IDE0Ljc1LDQ0LjUgTCAwLjc1LDQ0LjUgTCAtMi40MDYyNSw0NC41IHogTSAzLjQ2ODc1LDQ3LjUgTCAxNC43NSw0Ny41IEMgMTkuNDM0MTczLDQ3LjUgMzMuMDM2ODUsNDcuMzY5NzkzIDQyLjcxODc1LDY0LjUgQyAzNy45NTE5NjQsNzIuOTI5MDc1IDMyLjE5NzQ2OSw3Ny4xODM5MSAyNyw3OS4zMTI1IEMgMjEuNjM5MzM5LDgxLjUwNzkyNCAxNy4xNTgwNzUsODEuNTAwMDAxIDE0Ljc1LDgxLjUgTCAzLjUsODEuNSBDIDUuMzczNTg4NCw3OC4zOTE1NjYgOC4yNSw3Mi40NTA2NSA4LjI1LDY0LjUgQyA4LjI1LDU2LjUyNjY0NiA1LjM0MTQ2ODYsNTAuNTk5ODE1IDMuNDY4NzUsNDcuNSB6IgogICAgICAgICBpZD0icGF0aDQ5NzMiCiAgICAgICAgIHNvZGlwb2RpOm5vZGV0eXBlcz0iY2NzY2NjY3NjY2NjY2NjY2NzY2NzYyIgLz4KICAgIDwvZz4KICAgIDxwYXRoCiAgICAgICBzb2RpcG9kaTp0eXBlPSJhcmMiCiAgICAgICBzdHlsZT0iZmlsbDpub25lO2ZpbGwtb3BhY2l0eToxO3N0cm9rZTojMDAwMDAwO3N0cm9rZS13aWR0aDozO3N0cm9rZS1saW5lam9pbjptaXRlcjttYXJrZXI6bm9uZTtzdHJva2Utb3BhY2l0eToxO3Zpc2liaWxpdHk6dmlzaWJsZTtkaXNwbGF5OmlubGluZTtvdmVyZmxvdzp2aXNpYmxlO2VuYWJsZS1iYWNrZ3JvdW5kOmFjY3VtdWxhdGUiCiAgICAgICBpZD0icGF0aDM1NTEiCiAgICAgICBzb2RpcG9kaTpjeD0iNzUiCiAgICAgICBzb2RpcG9kaTpjeT0iMjUiCiAgICAgICBzb2RpcG9kaTpyeD0iNCIKICAgICAgIHNvZGlwb2RpOnJ5PSI0IgogICAgICAgZD0iTSA3OSwyNSBBIDQsNCAwIDEgMSA3MSwyNSBBIDQsNCAwIDEgMSA3OSwyNSB6IiAvPgogIDwvZz4KPC9zdmc+Cg=="}}},g.shapes.logic.Gate21.prototype.defaults),operation:function(a,b){return(!a||!b)&&(a||b)}}),g.shapes.logic.Wire=g.dia.Link.extend({arrowheadMarkup:['<g class="marker-arrowhead-group marker-arrowhead-group-<%= end %>">','<circle class="marker-arrowhead" end="<%= end %>" r="7"/>',"</g>"].join(""),vertexMarkup:['<g class="marker-vertex-group" transform="translate(<%= x %>, <%= y %>)">','<circle class="marker-vertex" idx="<%= idx %>" r="10" />','<g class="marker-vertex-remove-group">','<path class="marker-vertex-remove-area" idx="<%= idx %>" d="M16,5.333c-7.732,0-14,4.701-14,10.5c0,1.982,0.741,3.833,2.016,5.414L2,25.667l5.613-1.441c2.339,1.317,5.237,2.107,8.387,2.107c7.732,0,14-4.701,14-10.5C30,10.034,23.732,5.333,16,5.333z" transform="translate(5, -33)"/>','<path class="marker-vertex-remove" idx="<%= idx %>" transform="scale(.8) translate(9.5, -37)" d="M24.778,21.419 19.276,15.917 24.777,10.415 21.949,7.585 16.447,13.087 10.945,7.585 8.117,10.415 13.618,15.917 8.116,21.419 10.946,24.248 16.447,18.746 21.948,24.248z">',"<title>Remove vertex.</title>","</path>","</g>","</g>"].join(""),defaults:c.defaultsDeep({type:"logic.Wire",attrs:{".connection":{"stroke-width":2},".marker-vertex":{r:7}},router:{name:"orthogonal"},connector:{name:"rounded",args:{radius:10}}},g.dia.Link.prototype.defaults)}),"object"==typeof exports)var h=require("graphlib"),i=require("dagre");return h=h||"undefined"!=typeof window&&window.graphlib,i=i||"undefined"!=typeof window&&window.dagre,g.layout.DirectedGraph={layout:function(a,b){var d;d=a instanceof g.dia.Graph?a:(new g.dia.Graph).resetCells(a,{dry:!0}),a=null,b=c.defaults(b||{},{resizeClusters:!0,clusterPadding:10});var e=d.toGraphLib({directed:!0,multigraph:!0,compound:!0,setNodeLabel:function(a){return{width:a.get("size").width,height:a.get("size").height,rank:a.get("rank")}},setEdgeLabel:function(a){return{minLen:a.get("minLen")||1}},setEdgeName:function(a){return a.id}}),h={},j=b.marginX||0,k=b.marginY||0;b.rankDir&&(h.rankdir=b.rankDir),b.align&&(h.align=b.align),b.nodeSep&&(h.nodesep=b.nodeSep),b.edgeSep&&(h.edgesep=b.edgeSep),b.rankSep&&(h.ranksep=b.rankSep),j&&(h.marginx=j),k&&(h.marginy=k),e.setGraph(h),i.layout(e,{debugTiming:!!b.debugTiming}),d.startBatch("layout"),d.fromGraphLib(e,{importNode:function(a,c){var d=this.getCell(a),e=c.node(a);b.setPosition?b.setPosition(d,e):d.set("position",{x:e.x-e.width/2,y:e.y-e.height/2})},importEdge:function(a,c){var d=this.getCell(a.name),e=c.edge(a),f=e.points||[];b.setLinkVertices&&(b.setVertices?b.setVertices(d,f):d.set("vertices",f.slice(1,f.length-1)))}}),b.resizeClusters&&c.chain(e.nodes()).filter(function(a){return e.children(a).length>0}).map(d.getCell,d).sortBy(function(a){return-a.getAncestors().length}).invoke("fitEmbeds",{padding:b.clusterPadding}).value(),d.stopBatch("layout");var l=e.graph();return f.Rect(j,k,Math.abs(l.width-2*j),Math.abs(l.height-2*k))},fromGraphLib:function(a,b){b=b||{};var d=b.importNode||c.noop,e=b.importEdge||c.noop,f=this instanceof g.dia.Graph?this:new g.dia.Graph;return a.nodes().forEach(function(c){d.call(f,c,a,f,b)}),a.edges().forEach(function(c){e.call(f,c,a,f,b)}),f},toGraphLib:function(a,b){b=b||{};var d=c.pick(b,"directed","compound","multigraph"),e=new h.Graph(d),f=b.setNodeLabel||c.noop,g=b.setEdgeLabel||c.noop,i=b.setEdgeName||c.noop;return a.get("cells").each(function(a){if(a.isLink()){var b=a.get("source"),c=a.get("target");if(!b.id||!c.id)return;e.setEdge(b.id,c.id,g(a),i(a))}else e.setNode(a.id,f(a)),e.isCompound()&&a.has("parent")&&e.setParent(a.id,a.get("parent"))}),e}},g.dia.Graph.prototype.toGraphLib=function(a){return g.layout.DirectedGraph.toGraphLib(this,a)},g.dia.Graph.prototype.fromGraphLib=function(a,b){return g.layout.DirectedGraph.fromGraphLib.call(this,a,b)},g.g=f,g.V=g.Vectorizer=e,g});