<?php
/**
 * Created by PhpStorm.
 * User: Ovidiu
 * Date: 5/21/2018
 * Time: 4:55 PM
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Silence is golden
}

class TCB_Contact_Form_Label_Element extends TCB_Element_Abstract {

	/**
	 * Name of the Element
	 *
	 * @return string
	 */
	public function name() {

		return __( 'Contact Form Label', 'thrive-cb' );
	}

	/**
	 * Section element identifier
	 *
	 * @return string
	 */
	public function identifier() {
		return '.tve-cf-item label';
	}

	/**
	 * There is no need for HTML for this element since we need it only for control filter
	 *
	 * @return string
	 */
	protected function html() {
		return '';
	}

	/**
	 * Hide Element From Sidebar Menu
	 *
	 * @return bool
	 */
	public function hide() {
		return true;
	}


	/**
	 * Component and control config
	 *
	 * @return array
	 */
	public function own_components() {
		return array(
			'typography'       => array(
				'disabled_controls' => array( 'TextAlign', '.tve-advanced-controls' ),
				'config'            => array(
					'css_suffix'    => '',
					'FontSize'      => array(
						'css_suffix' => '',
					),
					'FontColor'     => array(
						'css_suffix' => '',
					),
					'LineHeight'    => array(
						'css_suffix' => '',
					),
					'LetterSpacing' => array(
						'css_suffix' => '',
					),
					'FontFace'      => array(
						'css_suffix' => '',
					),
					'TextStyle'     => array(
						'css_suffix' => '',
					),
				),
			),
			'animation'        => array(
				'hidden' => true,
			),
			'responsive'       => array(
				'hidden' => true,
			),
			'styles-templates' => array(
				'hidden' => true,
			),
		);
	}
}
