<?php
/**
 * FileName  class-tcb-symbols-dashboard.php.
 * @project: thrive-visual-editor
 * @developer: Dragos Petcu
 * @company: BitStone
 */

class TCB_Symbols_Dashboard {

	/**
	 * @var string
	 */
	private $_symbols_dashboard_page = 'tcb_symbols_dashboard';

	private $_tcb_admin_dashboard = 'tcb_admin_dashboard';

	/**
	 * Setup everything for the symbols dashboard
	 *
	 * TCB_Symbols_Dashboard constructor.
	 */
	public function __construct() {
		$this->hooks();
		$this->includes();
	}

	public function includes() {
	}

	/**
	 * Hooks used for the symbol dashboard
	 */
	public function hooks() {
		//add dashboard page so we can access it
		add_action( 'admin_menu', array( $this, 'admin_menu' ) );

		//add symbols card in thrive dashboard
		add_action( 'current_screen', array( $this, 'dash_features' ) );
	}

	/**
	 * Add symbols card in thrive dashboard
	 */
	public function dash_features() {
		if ( ! $screen = get_current_screen() ) {
			return;
		}

		/**
		 * if screen = main dashboard then enable and display the feature
		 */
		if ( $screen->id === 'toplevel_page_tve_dash_section' ) {
			add_filter( 'tve_dash_filter_features', array( $this, 'admin_symbols_feature' ) );
			add_filter( 'tve_dash_features', array( $this, 'admin_enable_feature' ) );
		}

	}

	/**
	 * Add new feature ( card ) to thrive dashboard
	 *
	 * @param array $features
	 *
	 * @return mixed
	 */
	public function admin_symbols_feature( $features ) {
		$features['symbols_manager'] = array(
			'icon'        => 'tvd-ct-symbols-icon',
			'title'       => __( 'Global Elements', 'thrive-cb' ),
			'description' => __( 'Create and manage templates, symbols, headers and footers', 'thrive-cb' ),
			'btn_link'    => add_query_arg( 'page', $this->_tcb_admin_dashboard . '#templatessymbols', admin_url( 'admin.php' ) ),
			'btn_text'    => __( 'Manage Global Elements', 'thrive-cb' ),
		);

		return $features;
	}

	/**
	 * Enable feature ( card ) in thrive dashboard
	 *
	 * @param array $features
	 *
	 * @return mixed
	 */
	public function admin_enable_feature( $features ) {
		$features['symbols_manager'] = true;

		return $features;
	}

	/**
	 * Create page for symbols dashboard
	 */
	public function admin_menu() {
		add_submenu_page( null, __( 'Symbols', 'thrive-cb' ), __( 'Symbols', 'thrive-cb' ), 'manage_options', $this->_symbols_dashboard_page, array(
			$this,
			'admin_symbols_dashboard',
		) );
	}

	/**
	 * Include the file for the symbols dashboard
	 */
	public function admin_symbols_dashboard() {
		include TVE_TCB_ROOT_PATH . 'inc/views/symbols/symbols-dashboard.php';
	}
}

global $tcb_symbol_dashboard;
/**
 * Main instance of TCB Symbols Dashboard
 *
 * @return TCB_Symbols_Dashboard
 */
function tcb_symbol_dashboard() {
	global $tcb_symbol_dashboard;

	if ( ! $tcb_symbol_dashboard ) {
		$tcb_symbol_dashboard = new TCB_Symbols_Dashboard();
	}

	return $tcb_symbol_dashboard;
}

tcb_symbol_dashboard();
