<?php
/**
 * Widget Name: Form
 * Description: Third party plugin Plus Form style.
 * Author: Theplus
 * Author URI: https://posimyth.com
 *
 * @package ThePlus
 */

namespace TheplusAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\controls\change;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class ThePlus_Plus_Form.
 */
class ThePlus_Plus_Form extends Widget_Base {

	/**
	 * Document Link For Need help.
	 *
	 * @var tp_doc of the class.
	 */
	public $tp_doc = THEPLUS_TPDOC;

	/**
	 * Helpdesk Link For Need help.
	 *
	 * @var tp_help of the class.
	 */
	public $tp_help = THEPLUS_HELP;

	/**
	 * Get Widget Name.
	 *
	 * @since   6.0.4
	 */
	public function get_name() {
		return 'tp-plus-form';
	}

	/**
	 * Get Widget Title.
	 *
	 * @since   6.0.4
	 */
	public function get_title() {
		return esc_html__( 'Form', 'theplus' );
	}

	/**
	 * Get Widget Icon.
	 *
	 * @since   6.0.4
	 */
	public function get_icon() {
		return 'theplus-i-form tpae-editor-logo';
	}

	/**
	 * Get Widget categories.
	 *
	 * @since   6.0.4
	 */
	public function get_categories() {
		return array( 'plus-forms' );
	}

	/**
	 * Get Widget keywords.
	 *
	 * @since   6.0.4
	 */
	public function get_keywords() {
		return array( 'Form', 'Plus Form', 'Forms' );
	}

	/**
	 * Get Widget categories.
	 *
	 * @since   6.0.4
	 */
	public function get_custom_help_url() {
		$help_url = $this->tp_help;

		return esc_url( $help_url );
	}

	/**
	 * Check if the widget has an inner wrapper.
	 *
	 * @since 6.0.4
	 *
	 * @return bool True if inner wrapper exists, false otherwise.
	 */
	public function has_widget_inner_wrapper(): bool {
		return ! \Elementor\Plugin::$instance->experiments->is_feature_active( 'e_optimized_markup' );
	}

	/**
	 * Register controls.
	 *
	 * @since   6.0.4
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__( 'General', 'theplus' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'form_title',
			array(
				'label'       => wp_kses_post( 'Form Name', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'New Plus Form', 'theplus' ),
				'placeholder' => esc_html__( 'Enter Form Name', 'theplus' ),
				'dynamic'     => array(
					'active' => false,
				),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$repeater = new \Elementor\Repeater();

		$repeater->start_controls_tabs( 'tabs_form_button_style' );

		$repeater->start_controls_tab(
			'field_content',
			array(
				'label' => esc_html__( 'Content', 'theplus' ),
			)
		);

		$repeater->add_control(
			'form_fields',
			array(
				'label'       => esc_html__( 'Type', 'theplus' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => esc_html__( 'text', 'theplus' ),
				'options'     => array(
					'text'           => esc_html__( 'Text', 'theplus' ),
					'textarea'       => esc_html__( 'Long Text', 'theplus' ),
					'email'          => esc_html__( 'Email', 'theplus' ),
					'number'         => esc_html__( 'Number', 'theplus' ),
					'hidden'         => esc_html__( 'Hidden', 'theplus' ),
					'honeypot'       => esc_html__( 'HoneyPot', 'theplus' ),
					'dropdown'       => esc_html__( 'Dropdown', 'theplus' ),
					'phone_number'   => esc_html__( 'Phone Number', 'theplus' ),
					'radio'          => esc_html__( 'Radio', 'theplus' ),
					'checkbox'       => esc_html__( 'Checkbox', 'theplus' ),
					'url'            => esc_html__( 'URL', 'theplus' ),
					'agree_to_terms' => esc_html__( 'Agree to Terms', 'theplus' ),
					'date'           => esc_html__( 'Date', 'theplus' ),
					'time'           => esc_html__( 'Time', 'theplus' ),
					'cloudflare'     => esc_html__( 'Cloudflare', 'theplus' ),
					'recaptcha'      => esc_html__( 'ReCAPTCHA', 'theplus' ),
				),
				'label_block' => false,
			)
		);
		$repeater->add_control(
			'cloudflare_note',
			array(
				'type'            => Controls_Manager::RAW_HTML,
				'raw'             => esc_html__( 'Note : You can add your key from The Plus Addons Dashboard by navigating to: Widgets > Form (Click the Settings icon on the Form widget)', 'theplus' ),
				'content_classes' => 'tp-controller-notice',
				'condition'       => array(
					'form_fields' => array( 'cloudflare', 'recaptcha' ),
				),
			)
		);

		$repeater->add_control(
			'field_label',
			array(
				'label'       => esc_html__( 'Label', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Field Label', 'theplus' ),
				'default'     => esc_html__( 'Field Label', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
				'condition'   => array(
					'form_fields!' => array( 'hidden', 'honeypot', 'cloudflare', 'recaptcha' ),
				),
			)
		);

		$repeater->add_control(
			'dropdown_options',
			array(
				'label'       => esc_html__( 'Options', 'theplus' ),
				'type'        => Controls_Manager::TEXTAREA,
				'description' => esc_html__( 'Enter each option on a new line.', 'theplus' ),
				'condition'   => array(
					'form_fields' => array( 'dropdown', 'radio', 'checkbox' ),
				),
			)
		);
		$repeater->add_control(
			'place_holder',
			array(
				'label'       => esc_html__( 'Placeholder', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Placeholder Text', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
				'condition'   => array(
					'form_fields' => array( 'text', 'textarea', 'email', 'number', 'phone_number', 'url' ),
				),
			)
		);


		$repeater->add_control(
			'required',
			array(
				'label'     => esc_html__( 'Required', 'theplus' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'no',
				'label_on'  => esc_html__( 'Yes', 'theplus' ),
				'label_off' => esc_html__( 'No', 'theplus' ),
				'condition' => array(
					'form_fields!' => array( 'hidden', 'honeypot', 'cloudflare', 'recaptcha' ),
				),
			)
		);

		$repeater->add_control(
			'autofill',
			array(
				'label'        => esc_html__( 'Autofill', 'theplus' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'on',
				'default'      => 'on',
				'label_on'     => esc_html__( 'Yes', 'theplus' ),
				'label_off'    => esc_html__( 'No', 'theplus' ),
				'condition'    => array(
					'form_fields' => array( 'text', 'textarea', 'email', 'number', 'phone_number', 'url' ),
				),
			)
		);

		$repeater->add_control(
			'enable_link',
			array(
				'label'     => esc_html__( 'Enable Link', 'theplus' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'no',
				'label_on'  => esc_html__( 'Yes', 'theplus' ),
				'label_off' => esc_html__( 'No', 'theplus' ),
				'condition' => array(
					'form_fields' => array( 'agree_to_terms' ),
				),
			)
		);

		$repeater->add_control(
			'link_label',
			array(
				'label'       => esc_html__( 'Link Label', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Link', 'theplus' ),
				'default'     => esc_html__( 'Link ', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
				'label_block' => false,
				'condition'   => array(
					'enable_link' => 'yes',
					'form_fields' => array( 'agree_to_terms' ),
				),
			)
		);

		$repeater->add_control(
			'terms_url',
			array(
				'label'       => esc_html__( 'URL', 'theplus' ),
				'type'        => Controls_Manager::URL,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Terms and Conditions URL', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
				'condition'   => array(
					'enable_link' => 'yes',
					'form_fields' => array( 'agree_to_terms' ),
				),
			)
		);

		$repeater->add_responsive_control(
			'column_width',
			array(
				'type'       => Controls_Manager::SLIDER,
				'label'      => esc_html__( 'Column Width', 'theplus' ),
				'size_units' => array( '%' ),
				'range'      => array(
					'%' => array(
						'min'  => 10,
						'max'  => 100,
						'step' => 2,
					),
				),

				'condition'  => array(
					'form_fields!' => array( 'hidden', 'honeypot', 'cloudflare', 'recaptcha' ),
				),
			)
		);

		$repeater->add_responsive_control(
			'country_code_width',
			array(
				'label'      => esc_html__( 'Country Code Width', 'theplus' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'default'    => array(
					'size' => 25,
					'unit' => '%',
				),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-phone-country-code' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .tpaep-phone-country-code' => 'width: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'form_fields' => array( 'phone_number' ),
				),
			)
		);

		$repeater->add_responsive_control(
			'options_direction',
			array(
				'label'       => esc_html__( 'Position', 'theplus' ),
				'type'        => Controls_Manager::CHOOSE,
				'options'     => array(
					'column' => array(
						'title' => esc_html__( 'Vertical', 'theplus' ),
						'icon'  => 'eicon-navigation-vertical',
					),
					'row'    => array(
						'title' => esc_html__( 'Horizontal', 'theplus' ),
						'icon'  => 'eicon-navigation-horizontal',
					),
				),
				'selectors'   => array(
					'{{WRAPPER}} {{CURRENT_ITEM}}.tpaep-radio-checkbox' => 'flex-direction: {{VALUE}};',
				),
				'default'     => 'column',
				'toggle'      => true,
				'label_block' => false,
				'condition'   => array(
					'form_fields' => array( 'radio', 'checkbox' ),
				),
			)
		);

		$repeater->add_responsive_control(
			'options_position',
			array(
				'label'       => esc_html__( 'Option Position', 'theplus' ),
				'type'        => Controls_Manager::CHOOSE,
				'options'     => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'theplus' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'theplus' ),
						'icon'  => 'eicon-h-align-center',
					),
					'end'    => array(
						'title' => esc_html__( 'Right', 'theplus' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'selectors'   => array(
					'{{WRAPPER}} {{CURRENT_ITEM}}.tpaep-radio-checkbox' => 'text-align: {{VALUE}}; justify-content: space-between ;',
				),
				'default'     => 'left',
				'toggle'      => true,
				'label_block' => false,
				'condition'   => array(
					'form_fields' => array( 'radio', 'checkbox' ),
				),
			)
		);

		$repeater->add_responsive_control(
			'option_gap',
			array(
				'type'       => Controls_Manager::SLIDER,
				'label'      => esc_html__( 'Option Gap', 'theplus' ),
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 50,
						'step' => 2,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} {{CURRENT_ITEM}}.tpaep-radio-checkbox' => 'gap: {{SIZE}}{{UNIT}} ;',
				),
				'condition'  => array(
					'form_fields' => array( 'radio', 'checkbox' ),
				),
			)
		);

		$repeater->add_control(
			'textarea_rows',
			array(
				'label'     => esc_html__( 'Rows', 'theplus' ),
				'type'      => Controls_Manager::NUMBER,
				'dynamic'   => array(
					'active' => false,
				),
				'ai'        => array(
					'active' => false,
				),
				'default'   => '4',
				'condition' => array(
					'form_fields' => array( 'textarea' ),
				),
			)
		);

		$repeater->end_controls_tab();

		$repeater->start_controls_tab(
			'field_advance',
			array(
				'label' => esc_html__( 'Advance', 'theplus' ),
			)
		);

		$repeater->add_control(
			'field_default_value',
			array(
				'label'       => esc_html__( 'Default Value', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Default Value', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
				'condition'   => array(
					'form_fields!' => array( 'honeypot', 'cloudflare', 'recaptcha' ),
				),
			)
		);

		$repeater->add_control(
			'field_help',
			array(
				'label'       => esc_html__( 'Help Text', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Help Text', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
				'condition'   => array(
					'form_fields!' => array( 'hidden', 'honeypot', 'cloudflare', 'recaptcha' ),
				),
			)
		);

		$repeater->add_control(
			'field_ad',
			array(
				'label'       => esc_html__( 'Aria Description', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Aria Description', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
				'condition'   => array(
					'form_fields!' => array( 'hidden', 'honeypot', 'cloudflare', 'recaptcha' ),
				),
			)
		);

		$repeater->add_control(
			'field_id',
			array(
				'label'       => esc_html__( 'Unique ID', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'ID', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$repeater->add_control(
			'unique_id_notice',
			array(
				'type'        => Controls_Manager::RAW_HTML,
				'raw'         => '<p class="tp-controller-notice"><i>Note : Ensure the ID is unique and not duplicated anywhere else on the page displaying this form. Valid entries include uppercase and lowercase letters (A-Z, a-z), numbers (0-9), and underscores, but spaces are not allowed.</i></p>',
				'label_block' => true,
			)
		);

		$repeater->add_control(
			'field_shortcode',
			array(
				'label'       => esc_html__( 'Data Shortcode', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Shortcode', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
				'condition'   => array(
					'form_fields!' => array( 'hidden', 'honeypot', 'cloudflare', 'recaptcha' ),
				),
			)
		);

		$repeater->end_controls_tab();

		$repeater->end_controls_tabs();

		$this->add_control(
			'tabs',
			array(
				'label'       => '',
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => array(
					array(
						'field_label'         => esc_html__( 'First Name', 'theplus' ),
						'place_holder'        => esc_html__( 'Enter First Name', 'theplus' ),
						'form_fields'         => 'text',
						'column_width'        => array(
							'size' => 49.5,
							'unit' => '%',
						),
						'required'            => 'no',
						'field_default_value' => '',
						'field_id'            => 'first_name',
						'field_shortcode'     => '[value_id="first_name"]',
					),
					array(
						'field_label'         => esc_html__( 'Last Name', 'theplus' ),
						'place_holder'        => esc_html__( 'Enter Last Name', 'theplus' ),
						'form_fields'         => 'text',
						'column_width'        => array(
							'size' => 49.5,
							'unit' => '%',
						),
						'required'            => 'no',
						'field_default_value' => '',
						'field_id'            => 'last_name',
						'field_shortcode'     => '[value_id="last_name"]',
					),
					array(
						'field_label'         => esc_html__( 'Email', 'theplus' ),
						'place_holder'        => esc_html__( 'Enter Email Address', 'theplus' ),
						'form_fields'         => 'email',
						'column_width'        => array(
							'size' => 100,
							'unit' => '%',
						),
						'required'            => 'yes',
						'field_default_value' => '',
						'field_id'            => 'email',
						'field_shortcode'     => '[value_id="email"]',
					),
					array(
						'field_label'         => esc_html__( 'Mobile Number', 'theplus' ),
						'place_holder'        => esc_html__( 'Enter Mobile Number', 'theplus' ),
						'form_fields'         => 'number',
						'column_width'        => array(
							'size' => 100,
							'unit' => '%',
						),
						'required'            => 'no',
						'field_default_value' => '',
						'field_id'            => 'mobile_number',
						'field_shortcode'     => '[value_id="mobile_number"]',
					),
					array(
						'field_label'         => esc_html__( 'Subject', 'theplus' ),
						'place_holder'        => esc_html__( 'Enter Subject', 'theplus' ),
						'form_fields'         => 'text',
						'column_width'        => array(
							'size' => 100,
							'unit' => '%',
						),
						'required'            => 'no',
						'field_default_value' => '',
						'field_id'            => 'subject',
						'field_shortcode'     => '[value_id="subject"]',
					),
					array(
						'field_label'         => esc_html__( 'Message', 'theplus' ),
						'place_holder'        => esc_html__( 'Share why you are contacting', 'theplus' ),
						'form_fields'         => 'textarea',
						'column_width'        => array(
							'size' => 100,
							'unit' => '%',
						),
						'required'            => 'no',
						'field_default_value' => '',
						'field_id'            => 'message',
						'field_shortcode'     => '[value_id="message"]',
					),
					array(
						'field_label'         => esc_html__( 'I Agree to', 'theplus' ),
						'form_fields'         => 'agree_to_terms',
						'enable_link'         => 'yes',
						'link_label'          => 'Terms & Conditions',
						'terms_url'           => '#',
						'column_width'        => array(
							'size' => 100,
							'unit' => '%',
						),
						'required'            => 'yes',
						'field_default_value' => '',
						'field_id'            => 'agree_to_terms',
						'field_shortcode'     => '[value_id="agree_to_terms"]',
					),
				),
				'title_field' => '{{{ field_label }}}',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'button_section',
			array(
				'label' => esc_html__( 'Button', 'theplus' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->start_controls_tabs( 'tabs_form_btn' );

		$this->start_controls_tab(
			'button_content',
			array(
				'label' => esc_html__( 'Content', 'theplus' ),
			)
		);

		$this->add_control(
			'button_submit',
			array(
				'label'       => esc_html__( 'Button Text', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'default'     => esc_html__( 'Send', 'theplus' ),
				'placeholder' => esc_html__( 'Enter Button Text', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'button_icon_style',
			array(
				'label'   => esc_html__( 'Icon Font', 'theplus' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => array(
					'font_awesome_5' => esc_html__( 'Font Awesome 5', 'theplus' ),
					'none'           => esc_html__( 'None', 'theplus' ),
				),
			)
		);

		$this->add_control(
			'icon_fontawesome_5',
			array(
				'label'       => esc_html__( 'Icon Library', 'theplus' ),
				'type'        => Controls_Manager::ICONS,
				'default'     => array(
					'value'   => 'fas fa-plus',
					'library' => 'solid',
				),
				'condition'   => array(
					'button_icon_style' => 'font_awesome_5',
				),
				'label_block' => true,
			)
		);

		$this->add_control(
			'icon_position',
			array(
				'label'       => esc_html__( 'Icon Position', 'theplus' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => esc_html__( 'after', 'theplus' ),
				'options'     => array(
					'after'  => esc_html__( 'After', 'theplus' ),
					'before' => esc_html__( 'Before', 'theplus' ),
				),
				'label_block' => false,
				'condition'   => array(
					'button_icon_style' => 'font_awesome_5',
				),
			)
		);

		$this->add_control(
			'inline_button',
			array(
				'label'     => esc_html__( 'Inline Button', 'theplus' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'no',
				'label_on'  => esc_html__( 'Yes', 'theplus' ),
				'label_off' => esc_html__( 'No', 'theplus' ),
			)
		);

		$this->add_responsive_control(
			'button_inline_width',
			array(
				'label'       => esc_html__( 'Button Width', 'theplus' ),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => array( '%', 'px' ),
				'range'       => array(
					'%' => array(
						'min'  => 10,
						'max'  => 100,
						'step' => 2,
					),
				),
				'default'     => array(
					'unit' => '%',
					'size' => 50,
				),
				'label_block' => true,
				'selectors'   => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-submit-container' => 'width: {{SIZE}}{{UNIT}};',
				),
				'condition'   => array(
					'inline_button' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'button_column_width',
			array(
				'label'       => esc_html__( 'Button Width', 'theplus' ),
				'type'        => Controls_Manager::SLIDER,
				'size_units'  => array( '%', 'px' ),
				'range'       => array(
					'%' => array(
						'min'  => 10,
						'max'  => 100,
						'step' => 2,
					),
				),
				'default'     => array(
					'unit' => '%',
					'size' => 50,
				),
				'label_block' => true,
				'selectors'   => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button' => 'width: {{SIZE}}{{UNIT}};',
				),
				'condition'   => array(
					'inline_button!' => 'yes',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'button_advance',
			array(
				'label' => esc_html__( 'Advance', 'theplus' ),
			)
		);

		$this->add_control(
			'button_id',
			array(
				'label'       => esc_html__( 'Button ID', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'ai'          => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter Button ID', 'theplus' ),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'submit_actions',
			array(
				'label' => esc_html__( 'Submit Actions', 'theplus' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'add_action',
			array(
				'label'       => esc_html__( 'Add Action', 'theplus' ),
				'type'        => Controls_Manager::SELECT2,
				'default'     => esc_html__( 'email', 'theplus' ),
				'multiple'    => true,
				'options'     => array(
					'database_entry'     => esc_html__( 'Database Entry', 'theplus' ),
					'email'              => esc_html__( 'Email', 'theplus' ),
					'auto_respond_email' => esc_html__( 'Auto Respond Email', 'theplus' ),
					'redirect'           => esc_html__( 'Redirect', 'theplus' ),
					'active_campaign'    => esc_html__( 'Active Campaign', 'theplus' ),
					'brevo'              => esc_html__( 'Brevo', 'theplus' ),
					'convertkit'         => esc_html__( 'ConvertKit', 'theplus' ),
					'get_response'       => esc_html__( 'GetResponse', 'theplus' ),
					'mailchimp'          => esc_html__( 'Mailchimp', 'theplus' ),
					'mailerlite'         => esc_html__( 'MailerLite', 'theplus' ),
					'drip'               => esc_html__( 'Drip', 'theplus' ),
					'webhook'            => esc_html__( 'Webhook', 'theplus' ),
					'slack'              => esc_html__( 'Slack', 'theplus' ),
					'discord'            => esc_html__( 'Discord', 'theplus' ),
				),
				'label_block' => true,
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'email_settings',
			array(
				'label'     => esc_html__( 'Email Settings', 'theplus' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'dynamic'   => array(
					'active' => false,
				),
				'ai'        => array(
					'active' => false,
				),
				'condition' => array(
					'add_action' => 'email',
				),
			)
		);

		$this->start_controls_tabs( 'tabs_email' );

		$this->start_controls_tab(
			'email_to_tab',
			array(
				'label' => esc_html__( 'To', 'theplus' ),
			)
		);

		$this->add_control(
			'email_to',
			array(
				'label'       => esc_html__( 'Email Address', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'ai'          => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter To Email Address', 'theplus' ),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'email_cc_tab',
			array(
				'label' => esc_html__( 'CC', 'theplus' ),
			)
		);

		$this->add_control(
			'email_cc',
			array(
				'label'       => esc_html__( 'Email Address', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'ai'          => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter CC Email Address', 'theplus' ),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'email_bcc_tab',
			array(
				'label' => esc_html__( 'BCC', 'theplus' ),
			)
		);

		$this->add_control(
			'email_bcc',
			array(
				'label'       => esc_html__( 'Email Address', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'ai'          => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter BCC Email Address', 'theplus' ),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'email_subject',
			array(
				'label'       => esc_html__( 'Subject', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'ai'          => array(
					'active' => false,
				),
				'separator'   => 'before',
				'placeholder' => esc_html__( 'Enter Subject', 'theplus' ),
				'default'     => 'New Form Submission',
			)
		);

		$this->add_control(
			'email_heading',
			array(
				'label'       => esc_html__( 'Email Heading', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'ai'          => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter Email Heading', 'theplus' ),
				'default'     => 'New Form Submission',
			)
		);

		$this->add_control(
			'email_message',
			array(
				'label'   => esc_html__( 'Message', 'theplus' ),
				'type'    => Controls_Manager::TEXTAREA,
				'dynamic' => array(
					'active' => false,
				),
				'default' => '[all-values]',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'field_message_notice',
			array(
				'type'        => Controls_Manager::RAW_HTML,
				'raw'         => '<p class="tp-controller-notice"><i>Note : To retrieve all values, use the [all-values] shortcode in the description. You can customize this by using the individual value shortcodes from each field above.</i></p>',
				'label_block' => true,
			)
		);

		$this->add_control(
			'email_from',
			array(
				'label'       => esc_html__( 'From Email', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'ai'          => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter From Email', 'theplus' ),
			)
		);

		$this->add_control(
			'email_from_name',
			array(
				'label'       => esc_html__( 'From Name', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'ai'          => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter From Name', 'theplus' ),
			)
		);

		$this->add_control(
			'email_reply_to',
			array(
				'label'       => esc_html__( 'Reply-To', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'ai'          => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter Reply-To', 'theplus' ),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'redirect_settings',
			array(
				'label'     => esc_html__( 'Redirect Settings', 'theplus' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => array(
					'add_action' => 'redirect',
				),
			)
		);

		$this->add_control(
			'redirect_to',
			array(
				'label'       => esc_html__( 'Redirect To', 'theplus' ),
				'type'        => Controls_Manager::URL,
				'options'     => array( 'url', 'is_external', 'nofollow' ),
				'default'     => array(
					'url'         => '',
					'is_external' => false,
					'nofollow'    => true,
				),
				'label_block' => true,
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'auto_respond_email_settings',
			array(
				'label'     => esc_html__( 'Auto Respond Email', 'theplus' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => array(
					'add_action' => 'auto_respond_email',
				),
			)
		);

		$this->add_control(
			'ar_email_subject',
			array(
				'label'       => esc_html__( 'Subject', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'ai'          => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter Subject', 'theplus' ),
				'default'     => 'New Form Submission',
			)
		);

		$this->add_control(
			'ar_email_heading',
			array(
				'label'       => esc_html__( 'Email Heading', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'ai'          => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter Email Heading', 'theplus' ),
				'default'     => 'New Form Submission',
			)
		);

		$this->add_control(
			'ar_email_message',
			array(
				'label'   => esc_html__( 'Message', 'theplus' ),
				'type'    => Controls_Manager::TEXTAREA,
				'dynamic' => array(
					'active' => false,
				),
				'default' => '[all-values]',
				'ai'      => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'ar_field_message_notice',
			array(
				'type'        => Controls_Manager::RAW_HTML,
				'raw'         => '<p class="tp-controller-notice"><i>Note : To retrieve all values, use the [all-values] shortcode in the description. You can customize this by using the individual value shortcodes from each field above.</i></p>',
				'label_block' => true,
			)
		);

		$this->add_control(
			'ar_email_from',
			array(
				'label'       => esc_html__( 'From Email', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'ai'          => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter From Email', 'theplus' ),
			)
		);

		$this->add_control(
			'ar_email_from_name',
			array(
				'label'       => esc_html__( 'From Name', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter From Name', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'ar_email_reply_to',
			array(
				'label'       => esc_html__( 'Reply-To', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter Reply-To', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'active_campaign_settings',
			array(
				'label'     => esc_html__( 'Active Campaign', 'theplus' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => array(
					'add_action' => 'active_campaign',
				),
			)
		);

		$this->add_control(
			'ac_custom_key',
			array(
				'label'       => esc_html__( 'API Key', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter API Key', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'ac_custom_url',
			array(
				'label'       => esc_html__( 'API URL', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter API URL', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'brevo_settings',
			array(
				'label'     => esc_html__( 'Brevo', 'theplus' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => array(
					'add_action' => 'brevo',
				),
			)
		);

		$this->add_control(
			'brevo_api_key',
			array(
				'label'       => esc_html__( 'API Key', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter API Key', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'brevo_list_id',
			array(
				'label'       => esc_html__( 'List ID', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter List ID', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'convertkit_settings',
			array(
				'label'     => esc_html__( 'ConvertKit', 'theplus' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => array(
					'add_action' => 'convertkit',
				),
			)
		);

		$this->add_control(
			'convertkey_api_key',
			array(
				'label'       => esc_html__( 'API Key', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter API Key', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'convertkey_form_id',
			array(
				'label'       => esc_html__( 'Form ID', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter Form ID', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'getresponse_settings',
			array(
				'label'     => esc_html__( 'GetResponse', 'theplus' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => array(
					'add_action' => 'get_response',
				),
			)
		);

		$this->add_control(
			'getresponse_api_key',
			array(
				'label'       => esc_html__( 'API Key', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter API Key', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'getresponse_list_token',
			array(
				'label'       => esc_html__( 'List Token', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter List Token', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'mailchimp_settings',
			array(
				'label'     => esc_html__( 'Mailchimp', 'theplus' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => array(
					'add_action' => 'mailchimp',
				),
			)
		);

		$this->add_control(
			'mailchimp_api_key',
			array(
				'label'       => esc_html__( 'API Key', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter API Key', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'mailchimp_audience_id',
			array(
				'label'       => esc_html__( 'Audience ID', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter Audience ID', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'mailerlite_settings',
			array(
				'label'     => esc_html__( 'MailerLite', 'theplus' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => array(
					'add_action' => 'mailerlite',
				),
			)
		);

		$this->add_control(
			'mailerlite_api_key',
			array(
				'label'       => esc_html__( 'API Key', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter API Key', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'mailerlite_group_id',
			array(
				'label'       => esc_html__( 'Group ID', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter Group ID', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'drip_settings',
			array(
				'label'     => esc_html__( 'Drip', 'theplus' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => array(
					'add_action' => 'drip',
				),
			)
		);

		$this->add_control(
			'drip_api_key',
			array(
				'label'       => esc_html__( 'API Key', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter API Key', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'drip_account_id',
			array(
				'label'       => esc_html__( 'Account ID', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter Account ID', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'webhook_settings',
			array(
				'label'     => esc_html__( 'Webhook', 'theplus' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => array(
					'add_action' => 'webhook',
				),
			)
		);

		$this->add_control(
			'webhook_url',
			array(
				'label'       => esc_html__( 'URL', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter URL', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slack_settings',
			array(
				'label'     => esc_html__( 'Slack', 'theplus' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => array(
					'add_action' => 'slack',
				),
			)
		);

		$this->add_control(
			'slack_token',
			array(
				'label'       => esc_html__( 'User OAuth Token', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter OAuth Token', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'slack_channel_name',
			array(
				'label'       => esc_html__( 'Channel Name', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter Channel Name', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'discord_settings',
			array(
				'label'     => esc_html__( 'Discord', 'theplus' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => array(
					'add_action' => 'discord',
				),
			)
		);

		$this->add_control(
			'discord_url',
			array(
				'label'       => esc_html__( 'Discord URL', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'ai'          => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter Discord URL', 'theplus' ),
			)
		);

		$this->add_control(
			'discord_username',
			array(
				'label'       => esc_html__( 'Username', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'ai'          => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter Username', 'theplus' ),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'message_content',
			array(
				'label' => esc_html__( 'Message Content', 'theplus' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);
		$this->add_control(
			'success_message',
			array(
				'label'       => esc_html__( 'Success Message', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'label_block' => true,
				'placeholder' => esc_html__( 'Enter Success Message Text', 'theplus' ),
				'default'     => 'Form Submitted Successfully',
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'required_fields',
			array(
				'label'       => esc_html__( 'Mandatory Fields', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'label_block' => true,
				'placeholder' => esc_html__( 'Enter Mandatory Fields Text', 'theplus' ),
				'default'     => 'Field is Required.',
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'invalid_form',
			array(
				'label'       => esc_html__( 'Form Validation Error', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'label_block' => true,
				'placeholder' => esc_html__( 'Enter Validation Error Text', 'theplus' ),
				'default'     => 'Invalid form! Please check it again.',
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'form_error',
			array(
				'label'       => esc_html__( 'Submission Issue', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'label_block' => true,
				'placeholder' => esc_html__( 'Enter Submission Issue Text', 'theplus' ),
				'default'     => 'There was an error in submitting the form.',
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'server_error',
			array(
				'label'       => esc_html__( 'Server Issue', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'label_block' => true,
				'placeholder' => esc_html__( 'Enter Server Issue Text', 'theplus' ),
				'default'     => 'A server error occurred.',
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'Additiona_Options',
			array(
				'label' => esc_html__( 'Extra Options', 'theplus' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'form_id',
			array(
				'label'       => esc_html__( 'Form ID', 'theplus' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => array(
					'active' => false,
				),
				'placeholder' => esc_html__( 'Enter Form ID', 'theplus' ),
				'ai'          => array(
					'active' => false,
				),
			)
		);

		$this->add_control(
			'form_id_notice',
			array(
				'type'        => Controls_Manager::RAW_HTML,
				'raw'         => '<p class="tp-controller-notice"><i>Note : Ensure the ID is unique and not duplicated anywhere else on the page displaying this form. Valid entries include uppercase and lowercase letters (A-Z, a-z), numbers (0-9), and underscores, but spaces are not allowed.</i></p>',
				'label_block' => true,
			)
		);

		$this->add_control(
			'form_title_display',
			array(
				'label'     => esc_html__( 'Show Form Title', 'theplus' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'no',
				'label_on'  => esc_html__( 'Yes', 'theplus' ),
				'label_off' => esc_html__( 'No', 'theplus' ),

			)
		);

		$this->add_control(
			'label_display',
			array(
				'label'     => esc_html__( 'Show Label', 'theplus' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'label_on'  => esc_html__( 'Yes', 'theplus' ),
				'label_off' => esc_html__( 'No', 'theplus' ),

			)
		);

		$this->add_control(
			'required_mask',
			array(
				'label'     => esc_html__( 'Required Mark', 'theplus' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'label_on'  => esc_html__( 'Yes', 'theplus' ),
				'label_off' => esc_html__( 'No', 'theplus' ),
				'condition' => array(
					'label_display' => 'yes',
				),

			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'theplus_section_needhelp',
			array(
				'label' => esc_html__( 'Need Help?', 'theplus' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);
		$this->add_control(
			'theplus_help_requests',
			array(
				'label'   => __( 'Need Help', 'theplus' ),
				'type'    => 'tpae_need_help',
				'default' => array(
					array(
						'label' => __( 'Read Docs', 'theplus' ),
						'url'   => 'https://theplusaddons.com/help/form-builder/?utm_source=wpbackend&utm_medium=elementoreditor&utm_campaign=widget',
					),
					array(
						'label' => __( 'Watch Video', 'theplus' ),
						'url'   => 'https://www.youtube.com/watch?v=7DVDIACjSSQ&t',
					),
				),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'form_style',
			array(
				'label' => esc_html__( 'General', 'theplus' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'form_column_gap',
			array(
				'type'        => Controls_Manager::SLIDER,
				'label'       => esc_html__( 'Columns Gap', 'theplus' ),
				'size_units'  => array( 'px' ),
				'range'       => array(
					'px' => array(
						'min'  => 0,
						'max'  => 50,
						'step' => 1,
					),
				),
				'default'     => array(
					'unit' => 'px',
					'size' => 0,
				),
				'render_type' => 'ui',
				'selectors'   => array(
					'{{WRAPPER}} .tpaep-form-container .tpaep-form' => 'column-gap: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'form_row_gap',
			array(
				'type'        => Controls_Manager::SLIDER,
				'label'       => esc_html__( 'Rows Gap', 'theplus' ),
				'size_units'  => array( 'px' ),
				'range'       => array(
					'px' => array(
						'min'  => 1,
						'max'  => 50,
						'step' => 1,
					),
				),
				'default'     => array(
					'unit' => 'px',
					'size' => 10,
				),
				'render_type' => 'ui',
				'selectors'   => array(
					'{{WRAPPER}} .tpaep-form-container .tpaep-form' => 'row-gap: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'form_title_heading',
			array(
				'label'     => esc_html__( 'Form Title', 'theplus' ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'form_title_display' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'form_title_padding',
			array(
				'label'      => esc_html__( 'Padding', 'theplus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'form_title_margin',
			array(
				'label'      => esc_html__( 'Margin', 'theplus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'form_title_typography',
				'label'     => esc_html__( 'Typography', 'theplus' ),
				'selector'  => '{{WRAPPER}} .tpaep-form-name',
				'condition' => array(
					'form_title_display' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'form_title_position',
			array(
				'label'       => esc_html__( 'Text Align', 'theplus' ),
				'type'        => Controls_Manager::CHOOSE,
				'options'     => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'theplus' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'theplus' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'theplus' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'selectors'   => array(
					'{{WRAPPER}} .tpaep-form-name' => 'justify-content: {{VALUE}};',
				),
				'default'     => 'center',
				'toggle'      => true,
				'label_block' => false,
				'condition'   => array(
					'form_title_display' => 'yes',
				),
			)
		);

		$this->start_controls_tabs(
			'tabs_form_title_colors',
			array(
				'condition' => array(
					'label_display' => 'yes',
				),
			)
		);

		$this->start_controls_tab(
			'form_title_normal',
			array(
				'label' => esc_html__( 'Normal', 'theplus' ),
			)
		);

		$this->add_control(
			'form_title_color',
			array(
				'label'     => esc_html__( 'Text Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-name' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'form_title_bg_color',
				'label'    => esc_html__( 'Background', 'theplus' ),
				'types'    => array( 'classic', 'gradient' ),
				'selector' => '{{WRAPPER}} .tpaep-form-name',
				'exclude'  => array( 'image' ),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'form_title_border_normal',
				'label'    => esc_html__( 'Border', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-form-name',
			)
		);

		$this->add_responsive_control(
			'form_title_border_radius_normal',
			array(
				'label'      => esc_html__( 'Border Radius', 'theplus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form-name' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'form_title_hover',
			array(
				'label' => esc_html__( 'Hover', 'theplus' ),
			)
		);

		$this->add_control(
			'form_title_color_hover',
			array(
				'label'     => esc_html__( 'Text Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-name:hover' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'form_title_bg_color_hover',
				'label'    => esc_html__( 'Background', 'theplus' ),
				'types'    => array( 'classic', 'gradient' ),
				'selector' => '{{WRAPPER}} .tpaep-form-name:hover',
				'exclude'  => array( 'image' ),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'form_title_border_hover',
				'label'    => esc_html__( 'Border', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-form-name:hover',
			)
		);

		$this->add_responsive_control(
			'form_title_border_radius_hover',
			array(
				'label'      => esc_html__( 'Border Radius', 'theplus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form-name:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'form_label_heading',
			array(
				'label'     => esc_html__( 'Label', 'theplus' ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'label_display' => 'yes',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'      => 'form_label_typography',
				'label'     => esc_html__( 'Typography', 'theplus' ),
				'selector'  => '{{WRAPPER}} .tpaep-form-label',
				'condition' => array(
					'label_display' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'form_label_spacing',
			array(
				'type'        => Controls_Manager::SLIDER,
				'label'       => esc_html__( 'Spacing', 'theplus' ),
				'size_units'  => array( 'px' ),
				'range'       => array(
					'px' => array(
						'min'  => 1,
						'max'  => 50,
						'step' => 1,
					),
				),
				'default'     => array(
					'unit' => 'px',
					'size' => 10,
				),
				'render_type' => 'ui',
				'selectors'   => array(
					'{{WRAPPER}} .tpaep-form-label' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				),
				'condition'   => array(
					'label_display' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'form_label_position',
			array(
				'label'       => esc_html__( 'Text Align', 'theplus' ),
				'type'        => Controls_Manager::CHOOSE,
				'options'     => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'theplus' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'theplus' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'theplus' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'selectors'   => array(
					'{{WRAPPER}} .tpaep-form-label' => 'text-align: {{VALUE}};',
				),
				'default'     => 'left',
				'toggle'      => true,
				'label_block' => false,
				'condition'   => array(
					'label_display' => 'yes',
				),
			)
		);

		$this->start_controls_tabs(
			'tabs_form_label_colors',
			array(
				'condition' => array(
					'label_display' => 'yes',
				),
			)
		);

		$this->start_controls_tab(
			'form_label_normal',
			array(
				'label' => esc_html__( 'Normal', 'theplus' ),
			)
		);

		$this->add_control(
			'form_text_color',
			array(
				'label'     => esc_html__( 'Text Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-label, {{WRAPPER}} .tpaep-form input, {{WRAPPER}} .tpaep-form select, {{WRAPPER}} .tpaep-form textarea' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'form_label_hover',
			array(
				'label' => esc_html__( 'Hover', 'theplus' ),
			)
		);

		$this->add_control(
			'form_text_color_hover',
			array(
				'label'     => esc_html__( 'Text Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-label:hover, {{WRAPPER}} .tpaep-form input, {{WRAPPER}} .tpaep-form select, {{WRAPPER}} .tpaep-form textarea' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'form_required_mark_color',
			array(
				'label'     => esc_html__( 'Required Mark Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ff0000',
				'separator' => 'before',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-required-asterisk' => 'color: {{VALUE}};',
				),
				'condition' => array(
					'required_mask' => 'yes',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'form_field_style',
			array(
				'label' => esc_html__( 'Fields', 'theplus' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'form_field_padding',
			array(
				'label'      => esc_html__( 'Padding', 'theplus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form input, {{WRAPPER}} .tpaep-form select, {{WRAPPER}} .tpaep-form textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'form_field_margin',
			array(
				'label'      => esc_html__( 'Margin', 'theplus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form input, {{WRAPPER}} .tpaep-form select, {{WRAPPER}} .tpaep-form textarea' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'form_text_field_typography',
				'label'    => esc_html__( 'Typography', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-form input::placeholder, {{WRAPPER}} .tpaep-form textarea::placeholder, {{WRAPPER}} .tpaep-form input, {{WRAPPER}} .tpaep-form select, {{WRAPPER}} .tpaep-form textarea',
			)
		);

		$this->add_responsive_control(
			'form_placeholder_position',
			array(
				'label'       => esc_html__( 'Input Text Align', 'theplus' ),
				'type'        => Controls_Manager::CHOOSE,
				'options'     => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'theplus' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'theplus' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'theplus' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'selectors'   => array(
					'{{WRAPPER}} .tpaep-form-field input::placeholder, {{WRAPPER}} .tpaep-form-field textarea::placeholder, {{WRAPPER}} .tpaep-form-field select' => 'text-align: {{VALUE}};',
				),
				'default'     => 'left',
				'toggle'      => true,
				'label_block' => false,
			)
		);

		$this->start_controls_tabs( 'tabs_field_bg' );

		$this->start_controls_tab(
			'tab_field_bg_normal',
			array(
				'label' => esc_html__( 'Normal', 'theplus' ),
			)
		);

		$this->add_control(
			'form_placeholder_text_color',
			array(
				'label'     => esc_html__( 'Text Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#888888',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-field input, {{WRAPPER}} .tpaep-form select, {{WRAPPER}} .tpaep-form-field input::placeholder, {{WRAPPER}} .tpaep-form-field textarea::placeholder, {{WRAPPER}} .tpaep-form-field input[type="date"]::placeholder, {{WRAPPER}} .tpaep-form-field input[type="time"]::placeholder' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'form_field_bg_color_normal',
			array(
				'label'     => esc_html__( 'Background Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form input, {{WRAPPER}} .tpaep-form select, {{WRAPPER}} .tpaep-form textarea' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'form_field_border_normal',
				'label'    => esc_html__( 'Border', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-form input, {{WRAPPER}} .tpaep-form select, {{WRAPPER}} .tpaep-form textarea',
			)
		);

		$this->add_responsive_control(
			'form_field_border_radius_normal',
			array(
				'label'      => esc_html__( 'Border Radius', 'theplus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form input, {{WRAPPER}} .tpaep-form select, {{WRAPPER}} .tpaep-form textarea' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_field_bg_clr_hover',
			array(
				'label' => esc_html__( 'Hover', 'theplus' ),
			)
		);

		$this->add_control(
			'form_placeholder_text_color_hover',
			array(
				'label'     => esc_html__( 'Text Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000000',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-field input:hover::placeholder,
 					{{WRAPPER}} .tpaep-form-field textarea:hover::placeholder' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'form_field_bg_clr_hover',
			array(
				'label'     => esc_html__( 'Background Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form input:hover, {{WRAPPER}} .tpaep-form select:hover, {{WRAPPER}} .tpaep-form select:hover, {{WRAPPER}} .tpaep-form textarea:hover' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'form_field_border_hover',
				'label'    => esc_html__( 'Border', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-form input:hover, {{WRAPPER}} .tpaep-form select:hover, {{WRAPPER}} .tpaep-form textarea:hover',
			)
		);

		$this->add_responsive_control(
			'form_field_border_radius_hover',
			array(
				'label'      => esc_html__( 'Border Radius', 'theplus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form input:hover, {{WRAPPER}} .tpaep-form select:hover, {{WRAPPER}} .tpaep-form textarea:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_field_bg_clr_active',
			array(
				'label' => esc_html__( 'Active', 'theplus' ),
			)
		);

		$this->add_control(
			'form_placeholder_text_color_active',
			array(
				'label'     => esc_html__( 'Text Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000000',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form input:not([type="date"]):not([type="time"]), {{WRAPPER}} .tpaep-form select:focus, {{WRAPPER}} .tpaep-form textarea:focus, {{WRAPPER}} .tpaep-form textarea, {{WRAPPER}} .tpaep-form input:not([type="date"]):not([type="time"]):focus' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .tpaep-form-field input[type="date"]:focus, {{WRAPPER}} .tpaep-form-field input[type="time"]:focus' => 'color: {{VALUE}} !important;',
				),
			)
		);

		$this->add_control(
			'form_field_bg_clr_active',
			array(
				'label'     => esc_html__( 'Background Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form input:focus, {{WRAPPER}} .tpaep-form textarea:focus' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'form_field_border_active',
				'label'    => esc_html__( 'Border', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-form input:focus, {{WRAPPER}} .tpaep-form textarea:focus',
			)
		);

		$this->add_responsive_control(
			'form_field_border_radius_active',
			array(
				'label'      => esc_html__( 'Border Radius', 'theplus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form input:focus, {{WRAPPER}} .tpaep-form textarea:focus' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'form_field_box_shadow',
				'label'    => esc_html__( 'Box Shadow', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-form input, {{WRAPPER}} .tpaep-form select, {{WRAPPER}} .tpaep-form textarea',
			)
		);

		/** Radio-button Styles*/
		$this->add_control(
			'dropdown_checkbox_radio',
			array(
				'label'     => esc_html__( 'Radio', 'theplus' ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);
		$this->add_responsive_control(
			'form_radio_checkbox_padding',
			array(
				'label'      => esc_html__( 'Option Padding', 'theplus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form-field .tpaep-radio-checkbox.tpaep-radio span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->add_responsive_control(
			'cr_input_scale',
			array(
				'type'        => Controls_Manager::SLIDER,
				'label'       => esc_html__( 'Input Scale', 'theplus' ),
				'range'       => array(
					'px' => array(
						'min'  => 0,
						'max'  => 10,
						'step' => 0.1,
					),
				),
				'default'     => array(
					'unit' => 'px',
					'size' => 1,
				),
				'render_type' => 'ui',
				'selectors'   => array(
					'{{WRAPPER}} .tpaep-form-container .tpaep-radio-checkbox.tpaep-radio input' => 'transform: scale({{SIZE}}); transform-origin: top left;',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'form_radio_checkbox_typography',
				'label'    => esc_html__( 'Typography', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-form-field .tpaep-radio-checkbox.tpaep-radio span',
			)
		);
		$this->start_controls_tabs( 'tabs_dd_cb_radio' );
		$this->start_controls_tab(
			'tab_dd_cb_radio_normal',
			array(
				'label' => esc_html__( 'Normal', 'theplus' ),
			)
		);
		$this->add_control(
			'radio_cb_text_color',
			array(
				'label'     => esc_html__( 'Text Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#888888',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-field .tpaep-radio-checkbox.tpaep-radio span' => 'color: {{VALUE}};',
				),
			)
		);
		$this->add_control(
			'radio_cb_option_color',
			array(
				'label'     => esc_html__( 'Option Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#888888',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-field input[type="radio"]' => 'accent-color: {{VALUE}};',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'radio_cb_color_bg',
				'label'    => esc_html__( 'Background', 'theplus' ),
				'types'    => array( 'classic', 'gradient' ),
				'selector' => '{{WRAPPER}} .tpaep-form-field .tpaep-radio-checkbox.tpaep-radio span',
				'exclude'  => array( 'image' ),
			)
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_dd_cb_radio_hover',
			array(
				'label' => esc_html__( 'Hover', 'theplus' ),
			)
		);
		$this->add_control(
			'radio_cb_text_color_hover',
			array(
				'label'     => esc_html__( 'Text Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#888888',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-field .tpaep-radio-checkbox.tpaep-radio span:hover' => 'color: {{VALUE}};',
				),
			)
		);
		$this->add_control(
			'radio_cb_option_color_hover',
			array(
				'label'     => esc_html__( 'Option Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#888888',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-field input[type="radio"]:hover' => 'accent-color: {{VALUE}};',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'radio_cb_color_bg_hover',
				'label'    => esc_html__( 'Background', 'theplus' ),
				'types'    => array( 'classic', 'gradient' ),
				'selector' => '{{WRAPPER}} .tpaep-form-field .tpaep-radio-checkbox.tpaep-radio span:hover',
				'exclude'  => array( 'image' ),
			)
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();

		/** Radio-button Styles*/
		$this->add_control(
			'checkbox_style_heading',
			array(
				'label'     => esc_html__( 'Checkbox', 'theplus' ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);
		$this->add_responsive_control(
			'form_checkbox_padding',
			array(
				'label'      => esc_html__( 'Option Padding', 'theplus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form-field .tpaep-radio-checkbox.tpaep-checkbox span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		$this->add_responsive_control(
			'cb_input_scale',
			array(
				'type'        => Controls_Manager::SLIDER,
				'label'       => esc_html__( 'Input Scale', 'theplus' ),
				'range'       => array(
					'px' => array(
						'min'  => 0,
						'max'  => 10,
						'step' => 0.1,
					),
				),
				'default'     => array(
					'unit' => 'px',
					'size' => 1,
				),
				'render_type' => 'ui',
				'selectors'   => array(
					'{{WRAPPER}} .tpaep-form-container .tpaep-radio-checkbox.tpaep-checkbox input' => 'transform: scale({{SIZE}}); transform-origin: top left;',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'form_checkbox_typography',
				'label'    => esc_html__( 'Typography', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-form-field .tpaep-radio-checkbox.tpaep-checkbox span',
			)
		);
		$this->start_controls_tabs( 'tabs_dd_checkbox' );
		$this->start_controls_tab(
			'tab_dd_checkbox_normal',
			array(
				'label' => esc_html__( 'Normal', 'theplus' ),
			)
		);
		$this->add_control(
			'checkbox_text_color',
			array(
				'label'     => esc_html__( 'Text Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#888888',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-field .tpaep-radio-checkbox.tpaep-checkbox span' => 'color: {{VALUE}};',
				),
			)
		);
		$this->add_control(
			'checkbox_option_color',
			array(
				'label'     => esc_html__( 'Option Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#888888',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-field input[type="checkbox"]' => 'accent-color: {{VALUE}};',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'checkbox_color_bg',
				'label'    => esc_html__( 'Background', 'theplus' ),
				'types'    => array( 'classic', 'gradient' ),
				'selector' => '{{WRAPPER}} .tpaep-form-field .tpaep-radio-checkbox.tpaep-checkbox span',
				'exclude'  => array( 'image' ),
			)
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_dd_checkbox_hover',
			array(
				'label' => esc_html__( 'Hover', 'theplus' ),
			)
		);
		$this->add_control(
			'checkbox_text_color_hover',
			array(
				'label'     => esc_html__( 'Text Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#888888',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-field .tpaep-radio-checkbox.tpaep-checkbox span:hover' => 'color: {{VALUE}};',
				),
			)
		);
		$this->add_control(
			'checkbox_option_color_hover',
			array(
				'label'     => esc_html__( 'Option Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#888888',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-field input[type="checkbox"]:hover' => 'accent-color: {{VALUE}};',
				),
			)
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'checkbox_color_bg_hover',
				'label'    => esc_html__( 'Background', 'theplus' ),
				'types'    => array( 'classic', 'gradient' ),
				'selector' => '{{WRAPPER}} .tpaep-form-field .tpaep-radio-checkbox.tpaep-checkbox span:hover',
				'exclude'  => array( 'image' ),
			)
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();

		/** Dropdown Styles*/
		$this->add_control(
			'dropdown_styles',
			array(
				'label'     => esc_html__( 'Dropdown', 'theplus' ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);
		$this->add_control(
			'dropdown_option_color',
			array(
				'label'     => esc_html__( 'Option Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-field select option' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'dropdown_bg_color',
				'label'    => esc_html__( 'Option Background', 'theplus' ),
				'types'    => array( 'classic' ),
				'selector' => '{{WRAPPER}} .tpaep-form-field select option',
				'exclude'  => array( 'image' ),
			)
		);

		$this->add_control(
			'att_styles',
			array(
				'label'     => esc_html__( 'Agree to Terms', 'theplus' ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'form_title_display' => 'yes',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'att_typography',
				'label'    => esc_html__( 'Typography', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-att',
			)
		);

		$this->start_controls_tabs( 'tabs_att' );

		$this->start_controls_tab(
			'att_normal',
			array(
				'label' => esc_html__( 'Normal', 'theplus' ),
			)
		);

		$this->add_control(
			'agree_to_terms_link_clr',
			array(
				'label'     => esc_html__( 'Link Text Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#035AE4',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-field label a' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'att_hover',
			array(
				'label' => esc_html__( 'Hover', 'theplus' ),
			)
		);

		$this->add_control(
			'agree_to_terms_link_clr_hover',
			array(
				'label'     => esc_html__( 'Link Text Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#035AE4',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-field label a:hover' => 'color: {{VALUE}};',
				),
			)
		);
		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'form_button_style',
			array(
				'label' => esc_html__( 'Submit Button', 'theplus' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'form_button_padding',
			array(
				'label'      => esc_html__( 'Padding', 'theplus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'form_button_margin',
			array(
				'label'      => esc_html__( 'Margin', 'theplus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'form_button_typography',
				'label'    => esc_html__( 'Typography', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-form .tpaep-form-button',
			)
		);

		$this->add_responsive_control(
			'form_button_position',
			array(
				'label'       => esc_html__( 'Position', 'theplus' ),
				'type'        => Controls_Manager::CHOOSE,
				'options'     => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'theplus' ),
						'icon'  => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'theplus' ),
						'icon'  => 'eicon-h-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'theplus' ),
						'icon'  => 'eicon-h-align-right',
					),
				),
				'selectors'   => array(
					'{{WRAPPER}} .tpaep-form-submit-container' => 'display: flex; justify-content: {{VALUE}};',
				),
				'default'     => 'center',
				'toggle'      => true,
				'label_block' => false,
			)
		);

		$this->add_responsive_control(
			'form_button_alignment',
			array(
				'label'       => esc_html__( 'Alignment', 'theplus' ),
				'type'        => Controls_Manager::CHOOSE,
				'options'     => array(
					'left'    => array(
						'title' => esc_html__( 'Left', 'theplus' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center'  => array(
						'title' => esc_html__( 'Center', 'theplus' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'   => array(
						'title' => esc_html__( 'Right', 'theplus' ),
						'icon'  => 'eicon-text-align-right',
					),
					'stretch' => array(
						'title' => esc_html__( 'Stretch', 'theplus' ),
						'icon'  => 'eicon-text-align-justify',
					),
				),
				'selectors'   => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button.tpaep-form-submit' => 'justify-content: {{VALUE}};',
				),
				'default'     => 'center',
				'toggle'      => true,
				'label_block' => false,
			)
		);

		$this->add_responsive_control(
			'form_button_icon_spacing',
			array(
				'label'      => esc_html__( 'Icon Spacing', 'theplus' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 50,
						'step' => 1,
					),
				),
				'default'    => array(
					'size' => 10,
					'unit' => 'px',
				),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button.tpaep-icon-before' => 'gap: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .tpaep-form .tpaep-form-button.tpaep-icon-after' => 'gap: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'button_icon_style' => 'font_awesome_5',
				),
			)
		);

		$this->add_responsive_control(
			'form_button_icon_size',
			array(
				'label'      => esc_html__( 'Icon Size', 'theplus' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', '%' ),
				'range'      => array(
					'px' => array(
						'min'  => 10,
						'max'  => 50,
						'step' => 1,
					),
				),
				'default'    => array(
					'size' => 18,
					'unit' => 'px',
				),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .tpaep-form .tpaep-form-button i::before' => 'font-size: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'button_icon_style' => 'font_awesome_5',
				),
			)
		);

		$this->start_controls_tabs( 'submit_btn_style' );

		$this->start_controls_tab(
			'submit_btn_style_n',
			array(
				'label' => esc_html__( 'Normal', 'theplus' ),
			)
		);

		$this->add_control(
			'form_button_text_color',
			array(
				'label'     => esc_html__( 'Text Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'form_button_icon_color',
			array(
				'label'     => esc_html__( 'Icon Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form-button svg path, {{WRAPPER}} .tpaep-form-button i' => 'fill: {{VALUE}};',
					'{{WRAPPER}} .tpaep-form-button i' => 'color: {{VALUE}};',
				),
				'condition' => array(
					'button_icon_style' => 'font_awesome_5',
				),
			)
		);
		$this->add_control(
				'icon_fill_color',
				array(
					'label'     => esc_html__( 'Fill', 'theplus' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .tpaep-form .tpaep-form-button svg path' => 'fill: {{VALUE}} !important;; ',
						'{{WRAPPER}} .tpaep-form .tpaep-form-button svg' => 'fill: {{VALUE}} !important;',

					),
					'condition' => array(
						'button_icon_style' => 'font_awesome_5',
					),
				)
			);
			$this->add_control(
				'icon_stroke_color',
				array(
					'label'     => esc_html__( 'Stroke', 'theplus' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .tpaep-form .tpaep-form-button svg path' => 'stroke: {{VALUE}} !important;; ',
						'{{WRAPPER}} .tpaep-form .tpaep-form-button svg' => 'stroke: {{VALUE}} !important;',

					),
					'condition' => array(
						'button_icon_style' => 'font_awesome_5',
					),
				)
			);

		$this->add_control(
			'form_btn_bg_type',
			array(
				'label'       => esc_html__( 'Background Type', 'theplus' ),
				'type'        => Controls_Manager::CHOOSE,
				'options'     => array(
					'color'    => array(
						'title' => esc_html__( 'Color', 'theplus' ),
						'icon'  => 'eicon-paint-brush',
					),
					'gradient' => array(
						'title' => esc_html__( 'Gradient', 'theplus' ),
						'icon'  => 'eicon-barcode',
					),
				),
				'label_block' => false,
				'default'     => 'color',
			)
		);
		$this->add_control(
			'form_button_background_color',
			array(
				'label'     => esc_html__( 'Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'form_btn_bg_type' => 'color',
				),
			)
		);
		$this->add_control(
			'form_btn_gradient_color1',
			array(
				'label'     => esc_html__( 'Color 1', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'condition' => array(
					'form_btn_bg_type' => 'gradient',
				),
				'of_type'   => 'gradient',
			)
		);
		$this->add_control(
			'form_btn_gradient_color1_control',
			array(
				'type'        => Controls_Manager::SLIDER,
				'label'       => esc_html__( 'Color 1 Location', 'theplus' ),
				'size_units'  => array( '%' ),
				'default'     => array(
					'unit' => '%',
					'size' => 0,
				),
				'render_type' => 'ui',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button' => 'background: linear-gradient({{SIZE}}{{UNIT}}, {{form_btn_gradient_color1.VALUE}} {{form_btn_gradient_color1_control.SIZE}}{{form_btn_gradient_color1_control.UNIT}}, {{form_btn_gradient_color2.VALUE}} {{form_btn_gradient_color2_control.SIZE}}{{form_btn_gradient_color2_control.UNIT}})',
				),
				'condition'   => array(
					'form_btn_bg_type' => 'gradient',
				),
				'of_type'     => 'gradient',
			)
		);
		$this->add_control(
			'form_btn_gradient_color2',
			array(
				'label'     => esc_html__( 'Color 2', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'condition' => array(
					'form_btn_bg_type' => 'gradient',
				),
				'of_type'   => 'gradient',
			)
		);
		$this->add_control(
			'form_btn_gradient_color2_control',
			array(
				'type'        => Controls_Manager::SLIDER,
				'label'       => esc_html__( 'Color 2 Location', 'theplus' ),
				'size_units'  => array( '%' ),
				'default'     => array(
					'unit' => '%',
					'size' => 100,
				),
				'render_type' => 'ui',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button' => 'background: linear-gradient({{SIZE}}{{UNIT}}, {{form_btn_gradient_color1.VALUE}} {{form_btn_gradient_color1_control.SIZE}}{{form_btn_gradient_color1_control.UNIT}}, {{form_btn_gradient_color2.VALUE}} {{form_btn_gradient_color2_control.SIZE}}{{form_btn_gradient_color2_control.UNIT}})',
				),
				'condition'   => array(
					'form_btn_bg_type' => 'gradient',
				),
				'of_type'     => 'gradient',
			)
		);
		$this->add_control(
			'form_btn_gradient_style',
			array(
				'type'      => Controls_Manager::SELECT,
				'label'     => esc_html__( 'Gradient Style', 'theplus' ),
				'default'   => 'linear',
				'options'   => theplus_get_gradient_styles(),
				'condition' => array(
					'form_btn_bg_type' => 'gradient',
				),
				'of_type'   => 'gradient',
			)
		);
		$this->add_control(
			'form_btn_gradient_angle',
			array(
				'label'      => esc_html__( 'Gradient Angle', 'theplus' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'deg' ),
				'default'    => array(
					'unit' => 'deg',
					'size' => 180,
				),
				'range'      => array(
					'deg' => array(
						'step' => 10,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button' => 'background: linear-gradient({{SIZE}}{{UNIT}}, {{form_btn_gradient_color1.VALUE}} {{form_btn_gradient_color1_control.SIZE}}{{form_btn_gradient_color1_control.UNIT}}, {{form_btn_gradient_color2.VALUE}} {{form_btn_gradient_color2_control.SIZE}}{{form_btn_gradient_color2_control.UNIT}})',
				),
				'condition'  => array(
					'form_btn_bg_type' => 'gradient',
					'form_btn_gradient_style' => array( 'linear' ),
				),
				'of_type'    => 'gradient',
			)
		);
		$this->add_control(
			'form_btn_gradient_position',
			array(
				'type'      => Controls_Manager::SELECT,
				'label'     => esc_html__( 'Position', 'theplus' ),
				'options'   => theplus_get_position_options(),
				'default'   => 'center center',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button' => 'background: radial-gradient(at {{VALUE}}, {{form_btn_gradient_color1.VALUE}} {{form_btn_gradient_color1_control.SIZE}}{{form_btn_gradient_color1_control.UNIT}}, {{form_btn_gradient_color2.VALUE}} {{form_btn_gradient_color2_control.SIZE}}{{form_btn_gradient_color2_control.UNIT}})',
				),
				'condition' => array(
					'form_btn_bg_type' => 'gradient',
					'form_btn_gradient_style' => array( 'radial' ),
				),
				'of_type'   => 'gradient',
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'form_button_border',
				'label'    => esc_html__( 'Button Border', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-form .tpaep-form-button',
			)
		);

		$this->add_responsive_control(
			'form_button_border_radius',
			array(
				'label'      => esc_html__( 'Border Radius', 'theplus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'form_button_box_shadow',
				'label'    => esc_html__( 'Button Box Shadow', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-form .tpaep-form-button',
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'submit_btn_style_h',
			array(
				'label' => esc_html__( 'Hover', 'theplus' ),
			)
		);

			$this->add_control(
				'form_button_hover_text_color',
				array(
					'label'     => esc_html__( 'Text Color', 'theplus' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '#fff',
					'selectors' => array(
						'{{WRAPPER}} .tpaep-form .tpaep-form-button:hover' => 'color: {{VALUE}};',
					),
				)
			);

		$this->add_control(
			'form_button_icon_hover_color',
			array(
				'label'     => esc_html__( 'Icon Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button:hover i::before' => 'color: {{VALUE}};',
					'{{WRAPPER}} .tpaep-form .tpaep-form-button:hover svg, {{WRAPPER}} .tpaep-form .tpaep-form-button:hover svg path' => 'fill: {{VALUE}};',
				),
				'condition' => array(
					'button_icon_style' => 'font_awesome_5',
				),
			)
		);
		$this->add_control(
			'icon_fill_color_hover',
			array(
				'label'     => esc_html__( 'Hover Fill', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button:hover svg path' => 'fill: {{VALUE}} !important;; ',
					'{{WRAPPER}} .tpaep-form .tpaep-form-button:hover svg' => 'fill: {{VALUE}} !important;',

				),
				'condition' => array(
					'button_icon_style' => 'font_awesome_5',
				),
			)
		);
		$this->add_control(
			'icon_stroke_color_hover',
			array(
				'label'     => esc_html__( 'Hover Stroke', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button:hover svg path' => 'stroke: {{VALUE}} !important;; ',
					'{{WRAPPER}} .tpaep-form .tpaep-form-button:hover svg' => 'stroke: {{VALUE}} !important;',

				),
				'condition' => array(
					'button_icon_style' => 'font_awesome_5',
				),
			)
		);

		$this->add_control(
			'form_btn_hvr_bg_type',
			array(
				'label'       => esc_html__( 'Background Type', 'theplus' ),
				'type'        => Controls_Manager::CHOOSE,
				'options'     => array(
					'color'    => array(
						'title' => esc_html__( 'Color', 'theplus' ),
						'icon'  => 'eicon-paint-brush',
					),
					'gradient' => array(
						'title' => esc_html__( 'Gradient', 'theplus' ),
						'icon'  => 'eicon-barcode',
					),
				),
				'label_block' => false,
				'default'     => 'color',
			)
		);
		$this->add_control(
			'form_button_hover_background_color',
			array(
				'label'     => esc_html__( 'Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button:hover' => 'background-color: {{VALUE}};',
				),
				'condition' => array(
					'form_btn_hvr_bg_type' => 'color',
				),
			)
		);
		$this->add_control(
			'form_btn_hvr_gradient_color1',
			array(
				'label'     => esc_html__( 'Color 1', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'condition' => array(
					'form_btn_hvr_bg_type' => 'gradient',
				),
				'of_type'   => 'gradient',
			)
		);
		$this->add_control(
			'form_btn_hvr_gradient_color1_control',
			array(
				'type'        => Controls_Manager::SLIDER,
				'label'       => esc_html__( 'Color 1 Location', 'theplus' ),
				'size_units'  => array( '%' ),
				'default'     => array(
					'unit' => '%',
					'size' => 0,
				),
				'render_type' => 'ui',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button:hover' => 'background: linear-gradient({{SIZE}}{{UNIT}}, {{form_btn_hvr_gradient_color1.VALUE}} {{form_btn_hvr_gradient_color1_control.SIZE}}{{form_btn_hvr_gradient_color1_control.UNIT}}, {{form_btn_hvr_gradient_color2.VALUE}} {{form_btn_hvr_gradient_color2_control.SIZE}}{{form_btn_hvr_gradient_color2_control.UNIT}})',
				),
				'condition'   => array(
					'form_btn_hvr_bg_type' => 'gradient',
				),
				'of_type'     => 'gradient',
			)
		);
		$this->add_control(
			'form_btn_hvr_gradient_color2',
			array(
				'label'     => esc_html__( 'Color 2', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'condition' => array(
					'form_btn_hvr_bg_type' => 'gradient',
				),
				'of_type'   => 'gradient',
			)
		);
		$this->add_control(
			'form_btn_hvr_gradient_color2_control',
			array(
				'type'        => Controls_Manager::SLIDER,
				'label'       => esc_html__( 'Color 2 Location', 'theplus' ),
				'size_units'  => array( '%' ),
				'default'     => array(
					'unit' => '%',
					'size' => 100,
				),
				'render_type' => 'ui',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button:hover' => 'background: linear-gradient({{SIZE}}{{UNIT}}, {{form_btn_hvr_gradient_color1.VALUE}} {{form_btn_hvr_gradient_color1_control.SIZE}}{{form_btn_hvr_gradient_color1_control.UNIT}}, {{form_btn_hvr_gradient_color2.VALUE}} {{form_btn_hvr_gradient_color2_control.SIZE}}{{form_btn_hvr_gradient_color2_control.UNIT}})',
				),
				'condition'   => array(
					'form_btn_hvr_bg_type' => 'gradient',
				),
				'of_type'     => 'gradient',
			)
		);
		$this->add_control(
			'form_btn_hvr_gradient_style',
			array(
				'type'      => Controls_Manager::SELECT,
				'label'     => esc_html__( 'Gradient Style', 'theplus' ),
				'default'   => 'linear',
				'options'   => theplus_get_gradient_styles(),
				'condition' => array(
					'form_btn_hvr_bg_type' => 'gradient',
				),
				'of_type'   => 'gradient',
			)
		);
		$this->add_control(
			'form_btn_hvr_gradient_angle',
			array(
				'label'      => esc_html__( 'Gradient Angle', 'theplus' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'deg' ),
				'default'    => array(
					'unit' => 'deg',
					'size' => 180,
				),
				'range'      => array(
					'deg' => array(
						'step' => 10,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button:hover' => 'background: linear-gradient({{SIZE}}{{UNIT}}, {{form_btn_hvr_gradient_color1.VALUE}} {{form_btn_hvr_gradient_color1_control.SIZE}}{{form_btn_hvr_gradient_color1_control.UNIT}}, {{form_btn_hvr_gradient_color2.VALUE}} {{form_btn_hvr_gradient_color2_control.SIZE}}{{form_btn_hvr_gradient_color2_control.UNIT}})',
				),
				'condition'  => array(
					'form_btn_hvr_bg_type' => 'gradient',
					'form_btn_hvr_gradient_style' => array( 'linear' ),
				),
				'of_type'    => 'gradient',
			)
		);
		$this->add_control(
			'form_btn_hvr_gradient_position',
			array(
				'type'      => Controls_Manager::SELECT,
				'label'     => esc_html__( 'Position', 'theplus' ),
				'options'   => theplus_get_position_options(),
				'default'   => 'center center',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button:hover' => 'background: radial-gradient(at {{VALUE}}, {{form_btn_hvr_gradient_color1.VALUE}} {{form_btn_hvr_gradient_color1_control.SIZE}}{{form_btn_hvr_gradient_color1_control.UNIT}}, {{form_btn_hvr_gradient_color2.VALUE}} {{form_btn_hvr_gradient_color2_control.SIZE}}{{form_btn_hvr_gradient_color2_control.UNIT}})',
				),
				'condition' => array(
					'form_btn_hvr_bg_type' => 'gradient',
					'form_btn_hvr_gradient_style' => array( 'radial' ),
				),
				'of_type'   => 'gradient',
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'     => 'form_button_border_hover',
				'label'    => esc_html__( 'Button Border', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-form .tpaep-form-button:hover',
			)
		);

		$this->add_responsive_control(
			'form_button_hover_border_radius',
			array(
				'label'      => esc_html__( 'Border Radius', 'theplus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'form_button_box_shadow_hover',
				'label'    => esc_html__( 'Button Box Shadow', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-form .tpaep-form-button:hover',
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'button_spinner',
			array(
				'label'     => esc_html__( 'Spinner', 'theplus' ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);
		$this->add_responsive_control(
			'button_spinner_size',
			array(
				'label'      => esc_html__( 'Spinner Size', 'theplus' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', 'em', '%' ),
				'default'    => [
						'size' => 18,
						'unit' => 'px',
					],
				'range'      => array(
					'px' => array(
						'min'  => 10,
						'max'  => 100,
						'step' => 1,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button .tpaep-spinner' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				),
			)
		);
		$this->add_control(
			'spinner_inner_color',
			array(
				'label'     => esc_html__( 'Spinner Inner Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button .tpaep-spinner' => 'border-color: {{VALUE}} !important;',
				),
			)
		);
		$this->add_control(
			'spinner_color',
			array(
				'label'     => esc_html__( 'Spinner Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-button .tpaep-spinner' => 'border-top-color: {{VALUE}} !important;',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'form_help_text',
			array(
				'label' => esc_html__( 'Help Text', 'theplus' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'form_help_padding',
			array(
				'label'      => esc_html__( 'Padding', 'theplus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form .tpaep-help-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'form_help_margin',
			array(
				'label'      => esc_html__( 'Margin', 'theplus' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .tpaep-form .tpaep-help-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'help_text_typography',
				'label'    => esc_html__( 'Typography', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-form .tpaep-help-text',
			)
		);

		$this->add_control(
			'help_text_color',
			array(
				'label'     => esc_html__( 'Text Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-help-text' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			array(
				'name'     => 'help_text_bg',
				'label'    => esc_html__( 'Background', 'theplus' ),
				'types'    => array( 'classic', 'gradient' ),
				'selector' => '{{WRAPPER}} .tpaep-form .tpaep-help-text',
				'exclude'  => array( 'image' ),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'form_message_style',
			array(
				'label' => esc_html__( 'Message Content', 'theplus' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'form_message_typography',
				'label'    => esc_html__( 'Typography', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-form .tpaep-form-message',
			)
		);

		$this->add_responsive_control(
			'form_msg_align',
			array(
				'label'       => esc_html__( 'Message Text Align', 'theplus' ),
				'type'        => Controls_Manager::CHOOSE,
				'options'     => array(
					'left'   => array(
						'title' => esc_html__( 'Left', 'theplus' ),
						'icon'  => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'theplus' ),
						'icon'  => 'eicon-text-align-center',
					),
					'right'  => array(
						'title' => esc_html__( 'Right', 'theplus' ),
						'icon'  => 'eicon-text-align-right',
					),
				),
				'selectors'   => array(
					'{{WRAPPER}} .tpaep-form-message' => 'text-align: {{VALUE}};',
				),
				'default'     => 'left',
				'toggle'      => true,
				'label_block' => false,
			)
		);

		$this->start_controls_tabs( 'tabs_msg_clr' );

		$this->start_controls_tab(
			'msg_clr_normal',
			array(
				'label' => esc_html__( 'Normal', 'theplus' ),
			)
		);

		$this->add_control(
			'form_success_message_color',
			array(
				'label'     => esc_html__( 'Success Message Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#28a745',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-message.success' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'form_error_message_color',
			array(
				'label'     => esc_html__( 'Error Message Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#dc3545',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-message.error' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'form_success_msg_bg_clr',
			array(
				'label'     => esc_html__( 'Success Message Background Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-message' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'form_error_msg_bg_clr',
			array(
				'label'     => esc_html__( 'Error Message Background Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-message.error' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'form_inline_message_color',
			array(
				'label'     => esc_html__( 'Inline Message Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-message.tpaep-form-inline' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'msg_clr_hover',
			array(
				'label' => esc_html__( 'Hover', 'theplus' ),
			)
		);

		$this->add_control(
			'form_success_msg_clr_hover',
			array(
				'label'     => esc_html__( 'Success Message Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#28a745',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-message.success:hover' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'form_error_msg_clr_hover',
			array(
				'label'     => esc_html__( 'Error Message Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#dc3545',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-message.error:hover' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'form_success_msg_bg_clr_hover',
			array(
				'label'     => esc_html__( 'Success Message Background Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-message:hover' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'form_error_msg_bg_clr_hover',
			array(
				'label'     => esc_html__( 'Error Message Background Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-message.error:hover' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'form_inline_message_color_hover',
			array(
				'label'     => esc_html__( 'Inline Message Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-form-message.tpaep-form-inline:hover' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'mandatory_field_message',
			array(
				'label'     => esc_html__( 'Mandatory Field Message', 'theplus' ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'form_title_display' => 'yes',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'mandatory_field_typography',
				'label'    => esc_html__( 'Typography', 'theplus' ),
				'selector' => '{{WRAPPER}} .tpaep-form .tpaep-field-error',
			)
		);

		$this->add_control(
			'mandatory_field_message_color',
			array(
				'label'     => esc_html__( 'Color', 'theplus' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#dc3545',
				'selectors' => array(
					'{{WRAPPER}} .tpaep-form .tpaep-field-error' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();

	}

	/**
	 * Render.
	 *
	 * @since 6.0.4
	 */
	public function render() {
		$settings  = $this->get_settings_for_display();
		$widget_id = $this->get_id();
		$tabs      = ! empty( $settings['tabs'] ) ? $settings['tabs'] : array();

		$unique_form_name = ! empty( $settings['form_title'] ) ? $settings['form_title'] : array();

		$submit_button      = ! empty( $settings['button_submit'] ) ? $settings['button_submit'] : 'Submit';
		$label_display      = ! empty( $settings['label_display'] ) ? $settings['label_display'] : '';
		$submit_action      = ! empty( $settings['add_action'] ) ? (array) $settings['add_action'] : array();
		$form_title_display = ! empty( $settings['form_title_display'] ) ? $settings['form_title_display'] : '';
		$button_column      = ! empty( $settings['button_column_width']['size'] ) ? $settings['button_column_width']['size'] : '100';

		$button_input_size = ! empty( $settings['input_size'] ) ? $settings['input_size'] : 'medium';
		$button_icon_style = ! empty( $settings['button_icon_style'] ) ? $settings['button_icon_style'] : 'font_awesome_5';

		$icon_position       = ! empty( $settings['icon_position'] ) ? $settings['icon_position'] : 'after';
		$icon_position_class = 'before' === $icon_position ? 'tpaep-icon-before' : 'tpaep-icon-after';

		$captcha_keys = get_option( 'theplus_widgets_settings' );

		if ( ! empty( $captcha_keys ) && isset( $captcha_keys['tp_plus_form'] ) && is_array( $captcha_keys['tp_plus_form'] ) ) {
			$google_site_key   = isset( $captcha_keys['tp_plus_form']['google_site_key'] ) ? $captcha_keys['tp_plus_form']['google_site_key'] : '';
			$google_secret_key = isset( $captcha_keys['tp_plus_form']['google_secret_key'] ) ? $captcha_keys['tp_plus_form']['google_secret_key'] : '';
			$cf_site_key       = isset( $captcha_keys['tp_plus_form']['cloudflare_site_key'] ) ? $captcha_keys['tp_plus_form']['cloudflare_site_key'] : '';
			$cf_secret_key     = isset( $captcha_keys['tp_plus_form']['cloudflare_secret_key'] ) ? $captcha_keys['tp_plus_form']['cloudflare_secret_key'] : '';
		}
		
		$button_id   = ! empty( $settings['button_id'] ) ? $settings['button_id'] : 'tpaep-form-button';
		$button_icon = '';

		$integration_data = array();

		$integration_fields = array(
			'active_campaign' => array( 'ac_custom_key', 'ac_custom_url' ),
			'brevo'           => array( 'brevo_api_key', 'brevo_list_id' ),
			'convertkit'      => array( 'convertkey_api_key', 'convertkey_form_id' ),
			'get_response'    => array( 'getresponse_api_key', 'getresponse_list_token' ),
			'mailchimp'       => array( 'mailchimp_api_key', 'mailchimp_audience_id' ),
			'mailerlite'      => array( 'mailerlite_api_key', 'mailerlite_group_id' ),
			'drip'            => array( 'drip_api_key', 'drip_account_id' ),
			'webhook'         => array( 'webhook_url' ),
			'slack'           => array( 'slack_token', 'slack_channel_name' ),
			'discord'         => array( 'discord_url', 'discord_username' ),
		);

		foreach ( $integration_fields as $integration => $fields ) {
			if ( in_array( $integration, $submit_action, true ) ) {
				foreach ( $fields as $field ) {
					$integration_data[ $integration ][ $field ] = ! empty( $settings[ $field ] ) ? $settings[ $field ] : '';
				}
			}
		}

		if ( in_array( 'redirect', $submit_action, true ) ) {
			$integration_data['redirect'] = array(
				'redirection' => ! empty( $settings['redirect_to']['url'] ) ? array(
					'url'         => esc_url( $settings['redirect_to']['url'] ),
					'is_external' => ! empty( $settings['redirect_to']['is_external'] ),
					'nofollow'    => ! empty( $settings['redirect_to']['nofollow'] ),
				) : '',
			);
		}

		if ( in_array( 'email', $submit_action, true ) ) {
			$integration_data['email'] = array(
				'email_to'        => is_email( $settings['email_to'] ) ? sanitize_email( $settings['email_to'] ) : '',
				'email_subject'   => ! empty( $settings['email_subject'] ) ? $settings['email_subject'] : '',
				'email_heading'   => ! empty( $settings['email_message'] ) ? $settings['email_heading'] : '',
				'email_message'   => ! empty( $settings['email_message'] ) ? $settings['email_message'] : '',
				'email_from'      => ! empty( $settings['email_from'] ) ? $settings['email_from'] : '',
				'email_from_name' => ! empty( $settings['email_from_name'] ) ? $settings['email_from_name'] : '',
				'email_reply_to'  => ! empty( $settings['email_reply_to'] ) ? $settings['email_reply_to'] : '',
				'email_cc'        => ! empty( $settings['email_cc'] ) ? sanitize_email( $settings['email_cc'] ) : '',
				'email_bcc'       => ! empty( $settings['email_bcc'] ) ? sanitize_email( $settings['email_bcc'] ) : '',
			);
		}

		if ( in_array( 'auto_respond_email', $submit_action, true ) ) {
			$integration_data['auto_respond_email'] = array(
				'ar_email_subject'   => ! empty( $settings['ar_email_subject'] ) ? $settings['ar_email_subject'] : '',
				'ar_email_heading'   => ! empty( $settings['ar_email_heading'] ) ? $settings['ar_email_heading'] : '',
				'ar_email_message'   => ! empty( $settings['ar_email_message'] ) ? $settings['ar_email_message'] : '',
				'ar_email_from'      => ! empty( $settings['ar_email_from'] ) ? $settings['ar_email_from'] : '',
				'ar_email_from_name' => ! empty( $settings['ar_email_from_name'] ) ? $settings['ar_email_from_name'] : '',
				'ar_email_reply_to'  => ! empty( $settings['ar_email_reply_to'] ) ? $settings['ar_email_reply_to'] : '',
			);
		}

		$integration_data['nonce'] = array(
			'nonce' => wp_create_nonce( 'tp-form-nonce' ),
			'google_secret_key' => $google_secret_key,
			'cf_secret_key' => $cf_secret_key,
		);

		if ( in_array( 'database_entry', $submit_action, true ) ) {
			$post_id = isset( $_POST['post_id'] ) ? absint( $_POST['post_id'] ) : get_the_ID();

			$integration_data['database_entry'] = array(
				'form_id'    => ! empty( $settings['form_id'] ) ? esc_attr( $settings['form_id'] ) : 'tpaep-form-main',
				'form_name'  => $unique_form_name,
				'post_id'    => $post_id,
				'element_id' => $widget_id,
			);
		}

		$form_id = ! empty( $settings['form_id'] ) ? esc_attr( $settings['form_id'] ) : 'tpaep-form-main';

		if ( 'font_awesome_5' === $button_icon_style && ! empty( $settings['icon_fontawesome_5']['value'] ) ) {
			ob_start();
				\Elementor\Icons_Manager::render_icon( $settings['icon_fontawesome_5'], array( 'aria-hidden' => 'true' ) );
				$button_icon = ob_get_contents();
			ob_end_clean();
		}

		$has_recaptcha = false;

		foreach ( $tabs as $tab ) {
			if ( isset( $tab['form_fields'] ) && 'recaptcha' === $tab['form_fields'] ) {
				$has_recaptcha = true;
				break;
			}
		}

		if ( $has_recaptcha && $google_site_key ) {
			wp_enqueue_script( 'google-recaptcha-v3', 'https://www.google.com/recaptcha/api.js?render=' . $google_site_key, array(), time(), true );
		}

		$error_message = array(
			'form_id'         => $form_id,
			'Required_mask'   => 'yes' === $settings['required_mask'] ? 'show-asterisks' : 'hide-asterisks',
			'invalid_form'    => ! empty( $settings['invalid_form'] ) ? $settings['invalid_form'] : '',
			'required_fields' => ! empty( $settings['required_fields'] ) ? $settings['required_fields'] : '',
			'form_error'      => ! empty( $settings['form_error'] ) ? $settings['form_error'] : '',
			'success_message' => ! empty( $settings['success_message'] ) ? $settings['success_message'] : '',
			'server_error'    => ! empty( $settings['server_error'] ) ? $settings['server_error'] : '',
			'google_site_key' => $google_site_key,
		);

		$required_fields = array();
		foreach ( $tabs as $tab ) {
			if ( ! empty( $tab['required'] ) && 'yes' === $tab['required'] ) {
				$required_fields[] = ! empty( $tab['field_id'] ) ? $tab['field_id'] : '';
			}
		}

		$inline_button = ! empty( $settings['inline_button'] ) ? $settings['inline_button'] : 'no';

		$integration_data = tp_plus_simple_decrypt( wp_json_encode( $integration_data ), 'ey' );

		$error_message = 'data-formdata="' . htmlspecialchars( wp_json_encode( $error_message, true ), ENT_QUOTES, 'UTF-8' ) . '"';

		$integration_data = 'data-integration="' . htmlspecialchars( wp_json_encode( $integration_data, true ), ENT_QUOTES, 'UTF-8' ) . '"';

		$form_markup = '<div class="tpaep-form-container" ' . $error_message . ' ' . $integration_data . '>';

		if ( 'yes' === $inline_button ) {
			$form_markup .= "<style> .elementor-element-$widget_id .tpaep-form-submit-container .tpaep-form-button{ width:100%!important } </style>";
		} elseif ( 'no' === $inline_button ) {
			$form_markup .= "<style> .elementor-element-$widget_id .tpaep-form-submit-container{ width:100%!important } </style>";
		}

		if ( 'yes' === $form_title_display ) {
			$form_markup .= '<div class="tpaep-form-name">' . esc_attr( $unique_form_name ) . '</div>';
		}

		$form_markup .= '<form novalidate id="' . esc_attr( $form_id ) . '" class="tpaep-form" method="post">';

		foreach ( $tabs as $tab ) {
			$tab_column        = ! empty( $tab['column_width']['size'] ) ? $tab['column_width']['size'] : '';
			$tab_id            = ! empty( $tab['field_id'] ) ? $tab['field_id'] : 'tab_' . uniqid();
			$tab_label         = ! empty( $tab['field_label'] ) ? $tab['field_label'] : '';
			$tab_placeholder   = ! empty( $tab['place_holder'] ) ? $tab['place_holder'] : '';
			$tab_default       = ! empty( $tab['field_default_value'] ) ? $tab['field_default_value'] : '';
			$tab_required      = ( ! empty( $tab['required'] ) && 'yes' === $tab['required'] ) ? 'required' : '';
			$tab_input_size    = ! empty( $settings['input_size'] ) ? $settings['input_size'] : 'medium';
			$tab_field_type    = ! empty( $tab['form_fields'] ) ? $tab['form_fields'] : 'text';
			$tab_textarea_rows = ! empty( $tab['textarea_rows'] ) ? $tab['textarea_rows'] : 3;
			$tab_help          = ! empty( $tab['field_help'] ) ? $tab['field_help'] : '';
			$tab_ad            = ! empty( $tab['field_ad'] ) ? $tab['field_ad'] : '';
			$tab_url           = ! empty( $tab['terms_url']['url'] ) ? esc_url( $tab['terms_url']['url'] ) : '';
			$tab_link_label    = ! empty( $tab['link_label'] ) ? $tab['link_label'] : '';
			$tab_autofill      = ! empty( $tab['autofill'] ) && 'on' === $tab['autofill'] ? 'on' : 'off';

			$tab_column_tablet = ! empty( $tab['column_width_tablet']['size'] ) ? $tab['column_width_tablet']['size'] : '';
			$tab_column_mobile = ! empty( $tab['column_width_mobile']['size'] ) ? $tab['column_width_mobile']['size'] : '';

			$form_markup .= '<div class="tpaep-form-field" data-width="' . esc_attr( $tab_column ) . '" data-tablet-width="' . esc_attr( $tab_column_tablet ) . '" data-mobile-width="' . esc_attr( $tab_column_mobile ) . '"> ';

			if ( 'yes' === $label_display && ! in_array( $tab_field_type, array( 'recaptcha', 'honeypot', 'hidden', 'agree_to_terms' ), true ) ) {
				$form_markup .= '<label for="form_fields[' . esc_attr( $tab_id ) . ']" class="tpaep-form-label">';
				$form_markup .= esc_html( $tab_label );

				if ( ! empty( $tab_required ) ) {
					$form_markup .= ' <span class="tpaep-required-asterisk">*</span>';
				}
				$form_markup .= '</label>';
			}

			if ( $tab_required ) {
				$required_fields[] = esc_attr( $tab_id );
			}

			switch ( $tab_field_type ) {
				case 'text':
				case 'email':
				case 'number':
					$input_type   = ( 'phone_number' === $tab_field_type ) ? 'tel' : esc_attr( $tab_field_type );
					$form_markup .= '<input type="' . $input_type . '" name="' . esc_attr( $tab_id ) . '" id="' . esc_attr( $tab_id ) . '" placeholder="' . esc_attr( $tab_placeholder ) . '" ' . $tab_required . ' class="' . esc_attr( $tab_input_size ) . '" value="' . esc_attr( $tab_default ) . '" autocomplete="' . esc_attr( $tab_autofill ) . '"/>';
					break;

				case 'phone_number':
					$form_markup .= '<div class="tpaep-phone-wrapper">';
					$form_markup .= '<select id="' . esc_attr( $tab_id ) . '_country_code" name="' . esc_attr( $tab_id ) . '_country_code" class="tpaep-phone-country-code">';
					$form_markup .= '<option value="">Code</option>';
					$form_markup .= '</select>';
					$form_markup .= '<input type="number" name="' . esc_attr( $tab_id ) . '" id="' . esc_attr( $tab_id ) . '" placeholder="' . esc_attr( $tab_placeholder ) . '" ' . $tab_required . ' class="' . esc_attr( $tab_input_size ) . '" value="' . esc_attr( $tab_default ) . '" autocomplete="' . esc_attr( $tab_autofill ) . '"/>';
					$form_markup .= '</div>';
					break;

				case 'textarea':
					$form_markup .= '<textarea name="' . esc_attr( $tab_id ) . '" rows="' . esc_attr( $tab_textarea_rows ) . '" id="' . esc_attr( $tab_id ) . '" placeholder="' . esc_attr( $tab_placeholder ) . '" ' . $tab_required . ' class="' . esc_attr( $tab_input_size ) . '">' . esc_textarea( $tab_default ) . '</textarea>';
					break;

				case 'hidden':
					$form_markup .= '<input type="hidden" name="' . esc_attr( $tab_id ) . '" value="' . esc_attr( $tab_default ) . '" />';
					break;

				case 'honeypot':
					$form_markup .= '<input class="tpaep-honey" type="text" name="honeypot" />';
					break;

				case 'url':
					$form_markup .= '<input type="url" name="' . esc_attr( $tab_id ) . '" id="' . esc_attr( $tab_id ) . '" placeholder="' . esc_attr( $tab_placeholder ) . '" ' . $tab_required . ' class="' . esc_attr( $tab_input_size ) . '" value="' . esc_attr( $tab_default ) . '" autocomplete="' . esc_attr( $tab_autofill ) . '"/>';
					break;

				case 'dropdown':
					$options      = ! empty( $tab['dropdown_options'] ) ? explode( "\n", $tab['dropdown_options'] ) : array();
					$form_markup .= '<select name="' . esc_attr( $tab_id ) . '" id="' . esc_attr( $tab_id ) . '" class="' . esc_attr( $tab_input_size ) . '" ' . esc_attr( $tab_required ) . '>';
					foreach ( $options as $option ) {
						$option = trim( $option );
						if ( ! empty( $option ) ) {
							$form_markup .= '<option value="' . esc_attr( $option ) . '">' . esc_html( $option ) . '</option>';
						}
					}
					$form_markup .= '</select>';
					break;

				case 'checkbox':
				case 'radio':
					$options_key  = 'dropdown_options';
					$options      = ! empty( $tab[ $options_key ] ) ? explode( "\n", $tab[ $options_key ] ) : array();
					// $form_markup .= '<fieldset class="elementor-repeater-item-' . esc_attr( $tab['_id'] ) . ' tpaep-radio-checkbox">';

					$field_type_class = ( 'checkbox' === $tab_field_type ) ? 'tpaep-checkbox' : 'tpaep-radio';
					$form_markup .= '<fieldset class="elementor-repeater-item-' . esc_attr( $tab['_id'] ) . ' tpaep-radio-checkbox ' . esc_attr( $field_type_class ) . '">';
					$first        = true;
					foreach ( $options as $option ) {
						$option_value = trim( $option );
						if ( ! empty( $option_value ) ) {
							$input_type   = ( 'checkbox' === $tab_field_type ) ? 'checkbox' : 'radio';
							$input_name   = ( 'checkbox' === $tab_field_type ) ? esc_attr( $tab_id ) . '[]' : esc_attr( $tab_id );
							$is_required  = ( $tab_required && $first ) ? 'required' : '';
							$form_markup .= '<div><input type="' . esc_attr( $input_type ) . '" name="' . esc_attr( $input_name ) . '" value="' . esc_attr( $option_value ) . '" ' . $is_required . '> <span>' . esc_html( $option_value ) . '</span></div>';
							$first        = false;
						}
					}
					$form_markup .= '</fieldset>';
					break;

					case 'date':				
					case 'time':
						$form_markup .= '<input type="' . esc_attr( $tab_field_type ) . '" name="' . esc_attr( $tab_id ) . '" id="' . esc_attr( $tab_id ) . '" placeholder="' . esc_attr( $tab_placeholder ) . '" ' . $tab_required . ' class="' . esc_attr( $tab_input_size ) . '" value="' . esc_attr( $tab_default ) . '" />';
						break;
					

				case 'agree_to_terms':
					$form_markup .= '<div class="tpaep-form-field" data-width="" data-tablet-width="" data-mobile-width="">';
					$form_markup .= '<fieldset>';
					$form_markup .= '<label class="tpaep-form-label tpaep-att">';
					$form_markup .= '<input type="checkbox" name="' . esc_attr( $tab_id ) . '" ' . $tab_required . '> ';
					$form_markup .= ' ' . esc_html( $tab_label ) . ' ';
					$form_markup .= '<a href="' . esc_url( $tab_url ) . '" target="_blank" rel="noopener noreferrer"> ' . $tab_link_label . '</a>';
					$form_markup .= '</label>';
					$form_markup .= '</fieldset>';
					$form_markup .= '</div>';
					break;

				case 'cloudflare':
					if ( empty( $cf_site_key ) || empty( $cf_secret_key ) ) {
						$form_markup .= '<div class="tpaep-captcha-warning" style="color:red;">Please add Cloudflare Turnstile Site Key and Secret Key.</div>';
					} else {
						$form_markup .= '<script src="https://challenges.cloudflare.com/turnstile/v0/api.js" async defer></script>';
						$form_markup .= '<div class="cf-turnstile" data-sitekey="' . esc_attr( $cf_site_key ) . '" data-callback="onTurnstileSuccess" data-size="invisible"></div>';
					}
					break;

				case 'recaptcha':
					if ( empty( $google_site_key ) || empty( $google_secret_key ) ) {
						$form_markup .= '<div class="tpaep-captcha-warning" style="color:red;">Please add reCAPTCHA Site Key and Secret Key.</div>';
					} else {
						$form_markup .= '<input type="hidden" name="g-recaptcha-response" value="">';
					}
					break;
			}

			if ( ! empty( $tab_help ) ) {
				$form_markup .= '<div class="tpaep-help-text">' . esc_html( $tab_help ) . '</div>';
			}

				$form_markup .= '</div>';
		}

				$form_markup .= '<div class="tpaep-form-submit-container">';

				// $form_markup .= '<button id="' . esc_attr( $button_id ) . '" type="submit" class="tpaep-form-submit tpaep-form-button ' . esc_attr( $icon_position_class ) . '" >' . $button_icon . ' ' . esc_html( $submit_button ) . '</button>';

				$form_markup .= '<button id="' . esc_attr( $button_id ) . '" type="submit" class="tpaep-form-submit tpaep-form-button">';

					$form_markup .= '<span class="tpaep-button-text">' . $button_icon . ' ' . esc_html( $submit_button ) . '</span>';
					$form_markup .= '<span class="tpaep-button-loader" style="display:none;"><span class="tpaep-spinner"></span></span>';
	
				$form_markup .= '</button>';

				$form_markup .= '</div>';

			$form_markup .= '</form>';

			if ( $has_recaptcha && $google_site_key ) {
				$form_markup .= "<script>
									document.addEventListener('DOMContentLoaded', function () {
										grecaptcha.ready(function() {
											grecaptcha.execute('" . esc_js( $google_site_key ) . "', {action: 'submit'}).then(function(token) {
												var recaptchaField = document.querySelector('input[name=\"g-recaptcha-response\"]');
												if (recaptchaField) {
													recaptchaField.value = token;
												}
											});
										});
									});
								</script>";
			}

			$form_markup .= '</div>';

		echo $form_markup;
	}
}
