<?php

/******************************************************************************/
/******************************************************************************/

class WPBakeryShortCode_VC_Templatica_Template
{
    /**************************************************************************/
    
    function __construct() 
    {
        add_action('init',array($this,'vcMapping'));
        add_shortcode(TemplaticaTemplate::createTemplateShortcode(0,true),array($this,'vcHTML'));
    }
     
    /**************************************************************************/     

    public function vcMapping()
    {
        $Template=new TemplaticaTemplate();
        $VisualComposer=new TemplaticaVisualComposer();
        
        vc_map
        ( 
            array
            (
                'base'                                                          =>  TemplaticaTemplate::createTemplateShortcode(0,true),
                'name'                                                          =>  __('Template','templatica'),
                'description'                                                   =>  __('Display template from Templatica.','templatica'), 
                'category'                                                      =>  __('Content','templatica'),  
                'params'                                                        =>  array
                (   
                    array
                    (
                        'type'                                                  =>  'dropdown',
                        'param_name'                                            =>  'template_id',
                        'heading'                                               =>  __('Template','templatica'),
                        'description'                                           =>  __('Select template which has to be displayed.','templatica'),
                        'value'                                                 =>  $VisualComposer->createParamDictionary($Template->getDictionary()),
                        'admin_label'                                           =>  true
                    )  
                )
            )
        );         
    } 
    
    /**************************************************************************/
     
    public function vcHTML($attr) 
    {
        global $post;
        
        $default=array
        (
            'template_id'                                                       =>  '0'
        );
        
        $attribute=shortcode_atts($default,$attr);
        
        if($post->ID===$attribute['template_id']) return;
        
        $template=get_post($attribute['template_id']);
        if(is_null($template)) return;
        
        $html=$template->post_content;
        return($html);        
    } 
    
    /**************************************************************************/
} 
 
new WPBakeryShortCode_VC_Templatica_Template(); 