<?php
	global $TS_ADVANCED_TABLESWP;

	function TS_TablesWP_Generator_Codestar(array $shortcodes) {
		global $TS_ADVANCED_TABLESWP;
		
		// Retrieve Required Settings
		$TS_ADVANCED_TABLESWP->TS_TablesWP_GetTablesCoreData();
		
		// Create Select Options for Table ID's
		$select_tables								= array();
		if (count($TS_ADVANCED_TABLESWP->TS_TablesWP_Custom_Tables) > 0) {
			foreach ($TS_ADVANCED_TABLESWP->TS_TablesWP_Custom_Tables as $tables => $table) {
				$select_tables[] 					= $table['id'];
			}
		}
		$select_tables								= implode(",", $select_tables);
		
		// Create Shortcode Generator Options
		$shortcodes[]      							= array(
			'name'            						=> 'TS_Advanced_Tables',
			'title'         						=> 'Tablenator - Advanced Tables for WordPress & WP Bakery Page Builder',
			'shortcodes'      						=> array(
				array(
					'name'      					=> 'TS_Advanced_Tables',
					'title'     					=> 'Advanced Tables Shortcode',
					'fields'    					=> array(
						// Table Selection + Output
						array(
							"type"					=> "heading",
							"content"				=> __( "Table Selection + Scope", "ts_visual_composer_extend" ),
						),
						array(
							'id'    				=> 'id',
							'type'  				=> 'advanced_tables',
							'title' 				=> __( "Table: ID", "ts_visual_composer_extend" ),
							'help'  				=> __( "Select the advanced table you want to display.", "ts_visual_composer_extend" ),
						),
						array(
							'id'    				=> 'table_formatting',
							'type'  				=> 'select',
							'title' 				=> __( "Table: Formatting Source", "ts_visual_composer_extend" ),
							'options'				=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Format_Sources),
							'default'  				=> 'metadata',
							'dependency'   			=> array('id', 'any', $select_tables),
							'help'  				=> __( "Define if and what formatting data should be used for table cells.", "ts_visual_composer_extend" ),
						),
						array(
							'id'    				=> 'table_scope',
							'type'  				=> 'select',
							'title' 				=> __( "Table: Theme / Scope", "ts_visual_composer_extend" ),
							'options'				=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Styling_TableThemes),
							'default'  				=> 'none',
							'dependency'   			=> array('id', 'any', $select_tables),
							'help'  				=> __( "Define what style and/or type of table you want to render.", "ts_visual_composer_extend" ),
						),
						array(
							'id'    				=> 'datatables_theme',
							'type'  				=> 'select',
							'title' 				=> __( "Table: Color Theme", "ts_visual_composer_extend" ),
							'options'				=> array(
								"default" 						=> __( "Default", "ts_visual_composer_extend" ),
								"yellow" 						=> __( "Yellow", "ts_visual_composer_extend" ),
								"blue"							=> __( "Blue", "ts_visual_composer_extend" ),
							),
							'default'  				=> 'default',
							'dependency'   			=> array('table_scope', '==', 'datatable'),
							'help'  				=> __( "Define the color theme to be used for the table.", "ts_visual_composer_extend" ),
						),
						// Table Exclusions
						array(
							'id' 					=> 'exclude_rows',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Exclude: Rows", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the rows within the table dataset you want to exclude when rendering the table; separate rows with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id' 					=> 'exclude_columns',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Exclude: Columns", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns within the table dataset you want to exclude when rendering the table; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|any', $select_tables . '|none,minimal,simplelittle,blank,tablesaw'),
						),
						// Table Extra Output
						array(
							"type"					=> "subheading",
							"content"				=> __( "Other Output Settings", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id'      				=> 'show_name',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Table: Show Name", "ts_visual_composer_extend" ),					
							'default' 				=> 'false',
							'dependency'   			=> array('id', 'any', $select_tables),
							'help' 					=> __( "Switch the toggle if you want to show the table name above the table.", "ts_visual_composer_extend" ),
						),
						array(
							'id'      				=> 'show_info',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Table: Show Info", "ts_visual_composer_extend" ),					
							'default' 				=> 'false',
							'dependency'   			=> array('id', 'any', $select_tables),
							'help' 					=> __( "Switch the toggle if you want to show the optional table information above the table.", "ts_visual_composer_extend" ),
						),
						array(
							'id'      				=> 'show_comments',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Table: Show Comments", "ts_visual_composer_extend" ),					
							'default' 				=> 'false',
							'dependency'   			=> array('id', 'any', $select_tables),
							'help' 					=> __( "Switch the toggle if you want to show applied cell comments via tooltip when hovering over a cell.", "ts_visual_composer_extend" ),
						),
						array(
							'id'      				=> 'show_indicator',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Table: Show Indicator", "ts_visual_composer_extend" ),					
							'default' 				=> 'true',
							'dependency'   			=> array('id|show_comments', 'any|==', $select_tables . '|true'),
							'help' 					=> __( "Switch the toggle if you want to show a tooltip indicator icon for all cells with a comment.", "ts_visual_composer_extend" ),
						),
						array(
							'type'    				=> 'notice',
							'class'   				=> 'warning',
							'content' 				=> __( "Based on the content a shortcode will result in after getting processed, the table responsiveness and/or other features, such as sorting or filtering, might be negatively impacted. It is best to only use shortcodes if they generate basic cell content such as numbers. The more cells the table contains, the longer the table rendering will take, as every cell must be checked for shortcode content first, which requires additional processing time.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id'      				=> 'table_shortcodes',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Table: Shortcode Content", "ts_visual_composer_extend" ),					
							'default' 				=> 'false',
							'dependency'   			=> array('id', 'any', $select_tables),
							'help' 					=> __( "Define if the plugin should check table cells for shortcode content and process them accordingly.", "ts_visual_composer_extend" ),
						),
						// Preloader Settings
						array(
							"type"					=> "subheading",
							"content"				=> __( "Preloader Settings", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id'      				=> 'preloader_use',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Preloader: Show Animation", "ts_visual_composer_extend" ),
							'default' 				=> 'false',
							'dependency'   			=> array('id', 'any', $select_tables),
							'help' 					=> __( "Switch the toggle if you want to show a preloader animation while the table is rendering; useful for large tables with advanced features.", "ts_visual_composer_extend" ),
						),						
						array(
							'id'      				=> 'preloader_style',
							'type'    				=> 'livepreview',
							'title'   				=> __( "Preloader: Style", "ts_visual_composer_extend" ),
							'default' 				=> 0,
							'preview'				=> 'preloaders',
							'shownone'				=> 'false',
							'dependency'   			=> array('id|preloader_use', 'any|==', $select_tables . '|true'),
							'help'					=> __( "Select the style for the preloader animation to be shown while the table is rendering.", "ts_visual_composer_extend" ),
						),						
						array(
							'id'      				=> 'preloader_background',
							'type'    				=> 'color_picker',
							'title'   				=> __( "Preloader: Background Color", "ts_visual_composer_extend" ),
							'default' 				=> 'rgba(255, 255, 255, 0.90)',
							'rgba'    				=> true,
							'dependency'   			=> array('id|preloader_use', 'any|==', $select_tables . '|true'),
							'help'					=> __( "Define the background color for the preloader container.", "ts_visual_composer_extend" ),
						),
						// Header + Footer Settings
						array(
							"type"					=> "subheading",
							"content"				=> __( "Header + Footer Settings", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id'      				=> 'header_use',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Header: Create Header", "ts_visual_composer_extend" ),				
							'default' 				=> 'true',
							'dependency'   			=> array('id', 'any', $select_tables),
							'help' 					=> __( "Switch the toggle if you want to use some rows as official table header.", "ts_visual_composer_extend" ),
						),
						array(
							'id'      				=> 'header_rows',
							'type'    				=> 'number',
							'title'   				=> __( "Header: Rows", "ts_visual_composer_extend" ),
							'default' 				=> '1',
							'dependency'   			=> array('id|header_use', 'any|==', $select_tables . '|true'),
							'help'    				=> __( "Define the number of top rows that should be used as header.", "ts_visual_composer_extend" ),
							'attributes' 			=> array(
								'min' 				=> '1',
								'max'				=> '3',
							),
						),
						array(
							'type'    				=> 'notice',
							'class'   				=> 'warning',
							'content' 				=> __( "The Footable script is currently unable to handle footer rows, as the footer is a reserved space for the paging component only.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						array(
							'id'      				=> 'footer_use',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Footer: Create Footer", "ts_visual_composer_extend" ),			
							'default' 				=> 'false',
							'dependency'   			=> array('id|table_scope', 'any|any', $select_tables . '|none,minimal,simplelittle,blank,tablesaw,datatable'),
							'help' 					=> __( "Switch the toggle if you want to use the last row as official table footer.", "ts_visual_composer_extend" ),
						),
						/*array(
							'id'      				=> 'footer_rows',
							'type'    				=> 'number',
							'title'   				=> __( "Footer: Rows", "ts_visual_composer_extend" ),
							'default' 				=> '1',
							'dependency'   			=> array('id|footer_use', 'any|==', $select_tables . '|true'),
							'help'    				=> __( "Define the number of bottom rows that should be used as footer.", "ts_visual_composer_extend" ),
							'attributes' 			=> array(
								'min' 				=> '1',
								'max'				=> '3',
							),
						),*/
						// Column Format Settings
						array(
							'type'					=> 'heading',
							'content'				=> __( "Columns Format Settings", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'type'    				=> 'notice',
							'class'   				=> 'warning',
							'content' 				=> __( "Advanced table scripts will attempt to parse the column content to determine the format of the content, which is relevant for any sorting feature to work correctly. Using the inputs below, you can manually assign columns to specific formats.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'type'    				=> 'notice',
							'class'   				=> 'danger',
							'content' 				=> __( "The FooTable script requires you to manually assign each column to a specific format, in order to ensure that the content is formatted (and sorted) correctly.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						/*array(
							'type'    				=> 'notice',
							'class'   				=> 'danger',
							'content' 				=> __( "The TableSaw script requires you to manually assign each column to a specific format, in order to ensure that the content is formatted (and sorted) correctly.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|tablesaw'),
						),*/						
						array(
							'type'					=> 'subheading',
							'content'				=> __( "Standard Column Formats", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'id' 					=> 'format_html',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Columns: HTML/Text Content", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns that contain HTML and/or text content only; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id' 					=> 'format_number',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Columns: Numeric Content", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns that contain standard numbers only; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id' 					=> 'format_currency',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Columns: Currency Content", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns that contain currency numbers only; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id' 					=> 'format_percent',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Columns: Percent Content", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns that contain percent numbers only; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id' 					=> 'format_date',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Columns: Date Content", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns that contain date strings only; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id' 					=> 'format_time',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Columns: Time Content", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns that contain time strings only; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						// Hybrid Column Formats
						array(
							'type'					=> 'subheading',
							'content'				=> __( "Hybrid Column Formats", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'id' 					=> 'format_natural_simple',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Columns: Alpha-Numeric (Case Sensitive)", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns that contain alpha-numeric strings only (normal sorting); separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'id' 					=> 'format_natural_nocase',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Columns: Alpha-Numeric (Case Insensitive)", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns that contain alpha-numeric strings only (case insensitive sorting); separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'id' 					=> 'format_numeric_html',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Columns: Numeric-HTML", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns that contain numeric strings within HTML tags only; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						// Table Custom Formatting
						array(
							'type'					=> 'heading',
							'content'				=> __( "Custom Format Settings", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
						),
						array(
							'type'    				=> 'notice',
							'class'   				=> 'warning',
							'content' 				=> __( "The following settings will replace any custom formatting added to individal table cells, using the toolbar in the table editor. Formats will instead be applied based on the column format assignments made above.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
						),
						array(
							"type"					=> "subheading",
							"content"				=> __( "Content Alignments", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
						),
						array(
							'id'    				=> 'numbers_horizontal',
							'type'  				=> 'select',
							'title' 				=> __( "Format: Horizontal Alignment", "ts_visual_composer_extend" ),
							'options'				=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Alignment_Horizontal),
							'default'  				=> 'none',
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
							'help'  				=> __( "Define the horizontal alignment for any cell content.", "ts_visual_composer_extend" ),
						),
						array(
							'id'    				=> 'numbers_vertical',
							'type'  				=> 'select',
							'title' 				=> __( "Format: Vertical Alignment", "ts_visual_composer_extend" ),
							'options'				=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Alignment_Vertical),
							'default'  				=> 'none',
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
							'help'  				=> __( "Define the vertical alignment for any cell content.", "ts_visual_composer_extend" ),
						),
						array(
							"type"					=> "subheading",
							"content"				=> __( "Currency Formatting", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
						),
						array(
							'id'    				=> 'numbers_locale',
							'type'  				=> 'select',
							'title' 				=> __( "Format: Cell Locale", "ts_visual_composer_extend" ),
							'options'				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_NumbroJS_Locales,
							'default'  				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_EditorLocale,
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
							'help'  				=> __( "Define the locale that should be used for any number formatting.", "ts_visual_composer_extend" ),
						),
						array(
							'id'    				=> 'numbers_symbol',
							'type'  				=> 'select',
							'title' 				=> __( "Format: Currency Placement", "ts_visual_composer_extend" ),
							'options'				=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Currency_Placement),
							'default'  				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_CurrencyPlacement,
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
							'help'  				=> __( "Define the placement of the currency symbol in relation to the value.", "ts_visual_composer_extend" ),
						),
						array(
							'id'      				=> 'numbers_space_currency',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Format: Currency Space", "ts_visual_composer_extend" ),
							'default' 				=> ($TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_CurrencySpace == true ? 'true' : 'false'),				
							'help' 					=> __( "Switch the toggle if you want to add a space between the currency symbol and the value.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
						),
						array(
							'id'      				=> 'numbers_decimals_currency',
							'type'    				=> 'number',
							'title'   				=> __( "Format: Currency Decimals", "ts_visual_composer_extend" ),
							'default' 				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DecimalsCurrency,
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
							'help'    				=> __( "Define the number of decimals to be used for currency values.", "ts_visual_composer_extend" ),
							'attributes' 			=> array(
								'min' 				=> '0',
								'max'				=> '6',
							),
						),
						array(
							"type"					=> "subheading",
							"content"				=> __( "Percentage Formatting", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
						),
						array(
							'id'      				=> 'numbers_space_percent',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Format: Percent Space", "ts_visual_composer_extend" ),
							'default' 				=> ($TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_PercentSpace == true ? 'true' : 'false'),				
							'help' 					=> __( "Switch the toggle if you want to add a space between the percentage symbol and the value.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
						),
						array(
							'id'      				=> 'numbers_decimals_percent',
							'type'    				=> 'number',
							'title'   				=> __( "Format: Percent Decimals", "ts_visual_composer_extend" ),
							'default' 				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DecimalsPercent,
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
							'help'    				=> __( "Define the number of decimals to be used for percentage values.", "ts_visual_composer_extend" ),
							'attributes' 			=> array(
								'min' 				=> '0',
								'max'				=> '6',
							),
						),
						array(
							"type"					=> "subheading",
							"content"				=> __( "Numbers Formatting", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
						),
						array(
							'id'      				=> 'numbers_decimals_numeric',
							'type'    				=> 'number',
							'title'   				=> __( "Format: Numbers Decimals", "ts_visual_composer_extend" ),
							'default' 				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DecimalsPercent,
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
							'help'    				=> __( "Define the number of decimals to be used for standard numeric values.", "ts_visual_composer_extend" ),
							'attributes' 			=> array(
								'min' 				=> '0',
								'max'				=> '6',
							),
						),
						array(
							"type"					=> "subheading",
							"content"				=> __( "Date + Time Formatting", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
						),
						array(
							'id'    				=> 'numbers_date',
							'type'  				=> 'select',
							'title' 				=> __( "Format: Dates", "ts_visual_composer_extend" ),
							'options'				=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Format_Dates),
							'default'  				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FormatDate,
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
							'help'  				=> __( "Define the desired format for all date values.", "ts_visual_composer_extend" ),
						),
						array(
							'id'    				=> 'numbers_time_hours',
							'type'  				=> 'select',
							'title' 				=> __( "Format: Hours", "ts_visual_composer_extend" ),
							'options'				=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Format_Hours),
							'default'  				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FormatTimeHours,
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
							'help'  				=> __( "Define the desired format for hours in all time values.", "ts_visual_composer_extend" ),
						),
						array(
							'id'    				=> 'numbers_time_minutes',
							'type'  				=> 'select',
							'title' 				=> __( "Format: Minutes", "ts_visual_composer_extend" ),
							'options'				=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Format_Minutes),
							'default'  				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FormatTimeMinutes,
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
							'help'  				=> __( "Define the desired format for minutes in all time values.", "ts_visual_composer_extend" ),
						),
						array(
							'id'    				=> 'numbers_time_seconds',
							'type'  				=> 'select',
							'title' 				=> __( "Format: Seconds", "ts_visual_composer_extend" ),
							'options'				=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Format_Seconds),
							'default'  				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FormatTimeSeconds,
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
							'help'  				=> __( "Define the desired format for seconds in all time values.", "ts_visual_composer_extend" ),
						),
						array(
							"type"					=> "subheading",
							"content"				=> __( "Other Formatting", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
						),
						array(
							'id'      				=> 'numbers_header',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Format: Process Header", "ts_visual_composer_extend" ),
							'default' 				=> 'false',
							'help' 					=> __( "Switch the toggle if you want to apply the formatting to header cells as well.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
						),
						array(
							'id'      				=> 'numbers_footer',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Format: Process Footer", "ts_visual_composer_extend" ),
							'default' 				=> 'true',
							'help' 					=> __( "Switch the toggle if you want to apply the formatting to footer cells as well.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
						),
						array(
							'id' 					=> 'numbers_exclude',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Format: Excluded Rows", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the rows that should be excluded from formatting; separate rows with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_formatting', 'any|==', $select_tables . '|custom'),
						),
						// Table Column Widths
						array(
							'type'					=> 'heading',
							'content'				=> __( "Columns Width Settings", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'type'    				=> 'notice',
							'class'   				=> 'warning',
							'content' 				=> __( "In order to ensure at least a basic responsive behavior for the table, absolute fixed column widths are not possible, as the table must be able to adjust column widths based on the applied responsive behavior. But you can use the options below to at least define a desired minimum and maximum width for the columns, and the applied table theme or advanced table script will attempt to use those settings, if at all possible. Without any defined desired widths, the browser will determine all column widths based on content solely.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id'      				=> 'columns_widthlimit',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Columns: Desired Widths", "ts_visual_composer_extend" ),
							'default' 				=> 'true',							
							'help' 					=> __( "Switch the toggle if you want to assign desired minimum and maximum widths for columns within this table.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id'      				=> 'columns_widthmin',
							'type'    				=> 'number',
							'title'   				=> __( "Columns: Minimum Width", "ts_visual_composer_extend" ),
							'default' 				=> '100',
							'dependency'   			=> array('id|columns_widthlimit', 'any|==', $select_tables . '|true'),
							'help'    				=> __( "Define the desired minimum width for columns.", "ts_visual_composer_extend" ),
							'attributes' 			=> array(
								'min' 				=> '120',
								'max'				=> '250',
							),
						),
						array(
							'id'      				=> 'columns_widthmax',
							'type'    				=> 'number',
							'title'   				=> __( "Columns: Maximum Width", "ts_visual_composer_extend" ),
							'default' 				=> '300',
							'dependency'   			=> array('id|columns_widthlimit', 'any|==', $select_tables . '|true'),
							'help'    				=> __( "Define the desired maximum width for columns.", "ts_visual_composer_extend" ),
							'attributes' 			=> array(
								'min' 				=> '250',
								'max'				=> '500',
							),
						),
						// Table Feature Settings
						array(
							'type'					=> 'heading',
							'content'				=> __( "Table Features", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id'    				=> 'responsive_type',
							'type'  				=> 'select',
							'title' 				=> __( "Table: Responsiveness", "ts_visual_composer_extend" ),
							'options'				=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Styling_TableResponsive),
							'default'  				=> 'none',
							'dependency'   			=> array('id|table_scope', 'any|any', $select_tables . '|none,minimal,simplelittle,blank'),
							'help'  				=> __( "Define what type of responsive behavior should be applied to the table.", "ts_visual_composer_extend" ),
						),
						array(
						  'id'      				=> 'responsive_switch',
						  'type'    				=> 'number',
						  'title'   				=> __( "Table: Layout Trigger", "ts_visual_composer_extend" ),
						  'default' 				=> '640',
						  'dependency'   			=> array('id|table_scope|responsive_type', 'any|any|any', $select_tables . '|none,minimal,simplelittle,blank|tiles,stack,split,flexflow,flexflip'),
						  'help'    				=> __( "Select the table width at which the table should switch into responsive mode.", "ts_visual_composer_extend" ),
							'attributes' 			=> array(
								'min' 				=> '360',
								'max'				=> '1280',
							),
						),
						array(
							'id'    				=> 'responsive_heighttype',
							'type'  				=> 'select',
							'title' 				=> __( "Table: Maximum Height", "ts_visual_composer_extend" ),
							'options'				=> array(
								"none"							=> __( "No Maximum Height", "ts_visual_composer_extend" ),
								"dynamic"						=> __( "Dynamic Maximum Height", "ts_visual_composer_extend" ),
								"fixed"							=> __( "Fixed Maximum Height", "ts_visual_composer_extend" ),	
							),
							'default'  				=> 'none',
						  'dependency'   			=> array('id|table_scope|responsive_type', 'any|any|any', $select_tables . '|none,minimal,simplelittle,blank|tiles,stack'),
							'help'  				=> __( "Define if and how the maximum height for the adjusted table should be set.", "ts_visual_composer_extend" ),
						),
						array(
						  'id'      				=> 'responsive_heightppercent',
						  'type'    				=> 'number',
						  'title'   				=> __( "Table: Dynamic Height (Percent)", "ts_visual_composer_extend" ),
						  'default' 				=> '75',
						  'dependency'   			=> array('id|table_scope|responsive_type|responsive_heighttype', 'any|any|any|==', $select_tables . '|none,minimal,simplelittle,blank|tiles,stack|dynamic'),
						  'help'    				=> __( "Define the maximum dynamic height for the adjusted table (as a percentage of visible browser height).", "ts_visual_composer_extend" ),
							'attributes' 			=> array(
								'min' 				=> '50',
								'max'				=> '200',
							),
						),
						array(
						  'id'      				=> 'responsive_heightpixel',
						  'type'    				=> 'number',
						  'title'   				=> __( "Table: Fixed Height (Pixel)", "ts_visual_composer_extend" ),
						  'default' 				=> '800',
						  'dependency'   			=> array('id|table_scope|responsive_type|responsive_heighttype', 'any|any|any|==', $select_tables . '|none,minimal,simplelittle,blank|tiles,stack|fixed'),
						  'help'    				=> __( "Define the maximum fixed height for the adjusted table.", "ts_visual_composer_extend" ),
							'attributes' 			=> array(
								'min' 				=> '400',
								'max'				=> '1600',
							),
						),
						// Relevant Warnings
						array(
							'type'    				=> 'notice',
							'class'   				=> 'warning',
							'content' 				=> __( "When using advanced table scripts, please ensure that you do not use merged cells within the last header row, the table body and the table footer, as advanced features such as sorting of columns do not work with merged cells.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|any', $select_tables . '|tablesaw,footable,datatable'),
						),
						array(
							'type'    				=> 'notice',
							'class'   				=> 'danger',
							'content' 				=> __( "In order to use a table sorting routine, a table header is required to be present so that the sort controls can be attached correctly!", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|header_use', 'any|any|==', $select_tables . '|tablesaw,footable,datatable|false'),
						),
						// TableSaw Settings
						array(
							'type'					=> 'subheading',
							'content'				=> __( "TableSaw Column Sorting", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|header_use', 'any|==|==', $select_tables . '|tablesaw|true'),
						),
						array(
							'id'      				=> 'tablesaw_sort',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Sort: Column Sort", "ts_visual_composer_extend" ),
							'default' 				=> 'false',							
							'help' 					=> __( "Switch the toggle if you want to provide a sort option for the table columns.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|header_use', 'any|==|==', $select_tables . '|tablesaw|true'),
						),
						array(
							'id'      				=> 'tablesaw_initial',
							'type'    				=> 'number',
							'title'   				=> __( "Sort: Initial Column", "ts_visual_composer_extend" ),
							'default' 				=> '1',						  
							'help'    				=> __( "Define the column by which the table should be initially sorted by.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|header_use|tablesaw_sort', 'any|==|==|==', $select_tables . '|tablesaw|true|true'),
							'attributes' 			=> array(
								'min' 				=> '1',
								'max'				=> '99',
							),
						),
						array(
							'id'    				=> 'tablesaw_order',
							'type'  				=> 'select',
							'title' 				=> __( "Sort: Initial Order", "ts_visual_composer_extend" ),
							'options'				=> array(
								"ascending"						=> __( "Ascending", "ts_visual_composer_extend" ),
								"descending"					=> __( "Descending", "ts_visual_composer_extend" ),
							),
							'default'  				=> 'ascending',						
							'help'  				=> __( "Define the initial sort order for the column defined above.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|header_use|tablesaw_sort', 'any|==|==|==', $select_tables . '|tablesaw|true|true'),
						),
						array(
							'id' 					=> 'tablesaw_noorder',
							'type' 					=> 'tag_editor',
							'title' 				=> __( "Sort: Exclude Columns", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns to be excluded from sort controls; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|header_use|tablesaw_sort', 'any|==|==|==', $select_tables . '|tablesaw|true|true'),
						),
						array(
							'id'      				=> 'tablesaw_sortswitch',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Sort: Main Control", "ts_visual_composer_extend" ),
							'default' 				=> 'false',							
							'help' 					=> __( "Switch the toggle if you want to provide an additional main sort controls for all columns above the table.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|header_use|tablesaw_sort', 'any|==|==|==', $select_tables . '|tablesaw|true|true'),
						),
						array(
							'type'					=> 'subheading',
							'content'				=> __( "TableSaw Responsiveness", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|tablesaw'),
						),
						array(
							'id'    				=> 'tablesaw_scope',
							'type'  				=> 'select',
							'title' 				=> __( "Responsiveness: Table Mode", "ts_visual_composer_extend" ),
							'options'				=> array(
								"swipe"							=> __( "Columns Swipe", "ts_visual_composer_extend" ),								
								"columntoggle"					=> __( "Columns Toggle", "ts_visual_composer_extend" ),
							),
							'default'  				=> 'swipe',							
							'help'  				=> __( "Define what type of responsive table mode should be applied to the table.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|tablesaw'),
						),
						array(
							'id'      				=> 'tablesaw_modeswitch',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Responsiveness: Mode Switch", "ts_visual_composer_extend" ),
							'default' 				=> 'false',							
							'help' 					=> __( "Switch the toggle if you want to provide an option to the end user to switch between the different responsive modes.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|tablesaw'),
						),
						array(
							'id' 					=> 'tablesaw_persist',
							'type' 					=> 'tag_editor',
							'title' 				=> __( "Responsiveness: Always Visible", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the persistent columns to be shown at all times; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'default'				=> '1',
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|tablesaw'),
						),						
						array(
							'id'      				=> 'tablesaw_fixwidth',
							'type'    				=> 'number',
							'title'   				=> __( "Responsiveness: Persist Width", "ts_visual_composer_extend" ),
							'default' 				=> '0',						  
							'help'    				=> __( "Define the fixed width for the persistent columns that should be maintained; set to zero (0) for automatic adjustment. Using this option can cause display issues with narrow table widths.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|tablesaw'),
							'attributes' 			=> array(
								'min' 				=> '0',
								'max'				=> '400',
							),
						),						
						array(
							'id'      				=> 'tablesaw_minimap',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Responsiveness: Mini Map", "ts_visual_composer_extend" ),
							'default' 				=> 'true',							
							'help' 					=> __( "Switch the toggle if you want to provide a visual indicator about visible and currently hidden columns.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|tablesaw'),
						),
						// Footable Settings
						array(
							'type'					=> 'subheading',
							'content'				=> __( "FooTable Column Sort", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|header_use', 'any|==|==', $select_tables . '|footable|true'),
						),
						array(
							'id'      				=> 'footable_sort',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Sort: Column Sort", "ts_visual_composer_extend" ),
							'default' 				=> 'false',							
							'help' 					=> __( "Switch the toggle if you want to provide a sort option for the table columns.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|header_use', 'any|==|==', $select_tables . '|footable|true'),
						),						
						array(
							'id'      				=> 'footable_initial',
							'type'    				=> 'number',
							'title'   				=> __( "Sort: Initial Column", "ts_visual_composer_extend" ),
							'default' 				=> '1',						  
							'help'    				=> __( "Define the column by which the table should be initially sorted by.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|header_use|footable_search', 'any|==|==|==', $select_tables . '|footable|true|true'),
							'attributes' 			=> array(
								'min' 				=> '1',
								'max'				=> '99',
							),
						),
						array(
							'id'    				=> 'footable_order',
							'type'  				=> 'select',
							'title' 				=> __( "Sort: Initial Order", "ts_visual_composer_extend" ),
							'options'				=> array(
								"ASC"							=> __( "Ascending", "ts_visual_composer_extend" ),
								"DESC"							=> __( "Descending", "ts_visual_composer_extend" ),
							),
							'default'  				=> 'ASC',						
							'help'  				=> __( "Define the initial sort order for the column defined above.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|header_use|footable_search', 'any|==|==|==', $select_tables . '|footable|true|true'),
						),
						array(
							'id' 					=> 'footable_noorder',
							'type' 					=> 'text',
							'title' 				=> __( "Sort: Exclude Columns", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns to be excluded from sort controls; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|header_use|footable_search', 'any|==|==|==', $select_tables . '|footable|true|true'),
						),
						array(
							'type'					=> 'subheading',
							'content'				=> __( "FooTable Pagination", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						array(
							'id'      				=> 'footable_pages',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Pagination: Use Pagination", "ts_visual_composer_extend" ),
							'default' 				=> 'false',							
							'help' 					=> __( "Switch the toggle if you want to paginate the tables if there are too many rows.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),	
						array(
							'id'    				=> 'footable_length',
							'type'  				=> 'select',
							'title' 				=> __( "Pagination: Page Length", "ts_visual_composer_extend" ),
							'options'				=> array(
								"5"								=> __( "5 Rows", "ts_visual_composer_extend" ),
								"10"							=> __( "10 Rows", "ts_visual_composer_extend" ),
								"25"							=> __( "25 Rows", "ts_visual_composer_extend" ),
								"50"							=> __( "50 Rows", "ts_visual_composer_extend" ),
								"75"							=> __( "75 Rows", "ts_visual_composer_extend" ),
								"100"							=> __( "100 Rows", "ts_visual_composer_extend" ),
								"custom"						=> __( "Custom Rows", "ts_visual_composer_extend" ),
							),
							'default'  				=> '10',						
							'help'  				=> __( "Define the number of rows to be shown per page.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|footable_pages', 'any|==|==', $select_tables . '|footable|true'),
						),
						array(
							'id'      				=> 'footable_lengthcustom',
							'type'    				=> 'number',
							'title'   				=> __( "Pagination: Custom Length", "ts_visual_composer_extend" ),
							'default' 				=> '10',						  
							'help'    				=> __( "Define the initial number of rows to be shown for each page.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|footable_pages|footable_length', 'any|==|==|==', $select_tables . '|footable|true|custom'),
							'attributes' 			=> array(
								'min' 				=> '5',
								'max'				=> '200',
							),
						),
						array(
							'id' 					=> 'footable_lengthoptions',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							"default"				=> "5,10,15,25,50,75,100,150,200",
							'title' 				=> __( "Pagination: Length Options", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the options that should be made available to the viewer in order to change the pagination length.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|footable_pages', 'any|==|==', $select_tables . '|footable|true'),
						),
						array(
							'id'    				=> 'footable_pagesspot',
							'type'  				=> 'select',
							'title' 				=> __( "Pagination: Controls Placement", "ts_visual_composer_extend" ),
							'options'				=> array(
								"left"							=> __( "Left", "ts_visual_composer_extend" ),
								"center"						=> __( "Center", "ts_visual_composer_extend" ),
								"right"							=> __( "Right", "ts_visual_composer_extend" ),
							),
							'default'  				=> 'center',						
							'help'  				=> __( "Define the placement of the pagination controls below the table.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|footable_pages', 'any|==|==', $select_tables . '|footable|true'),
						),
						array(
							'type'					=> 'subheading',
							'content'				=> __( "FooTable Table Search", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						array(
							'id'      				=> 'footable_search',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Search: Table Search", "ts_visual_composer_extend" ),
							'default' 				=> 'false',							
							'help' 					=> __( "Switch the toggle if you want to provide a search input for the table.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						array(
							'id'    				=> 'footable_searchspot',
							'type'  				=> 'select',
							'title' 				=> __( "Search: Placement", "ts_visual_composer_extend" ),
							'options'				=> array(
								"left"							=> __( "Left", "ts_visual_composer_extend" ),
								"center"						=> __( "Center", "ts_visual_composer_extend" ),
								"right"							=> __( "Right", "ts_visual_composer_extend" ),
							),
							'default'  				=> 'right',			
							'help'  				=> __( "Define the placement of the search controls above the table.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|footable_search', 'any|==|==', $select_tables . '|footable|true'),
						),
						array(
							'id' 					=> 'footable_nosearch',
							'type' 					=> 'text',
							'title' 				=> __( "Search: Exclude Columns", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns to be excluded from the table search; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|footable_search', 'any|==|==', $select_tables . '|footable|true'),
						),
						// DataTable Settings
						array(
							'type'					=> 'subheading',
							'content'				=> __( "Datatable Column Sort", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|header_use', 'any|==|==', $select_tables . '|datatable|true'),
						),
						array(
							'id'      				=> 'datatables_sort',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Sort: Column Sort", "ts_visual_composer_extend" ),
							'default' 				=> 'false',							
							'help' 					=> __( "Switch the toggle if you want to provide a sort option for the table columns.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|header_use', 'any|==|==', $select_tables . '|datatable|true'),
						),						
						array(
							'id'      				=> 'footable_initial',
							'type'    				=> 'number',
							'title'   				=> __( "Sort: Initial Column", "ts_visual_composer_extend" ),
							'default' 				=> '1',						  
							'help'    				=> __( "Define the column by which the table should be initially sorted by.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|header_use|datatables_sort', 'any|==|==|==', $select_tables . '|datatable|true|true'),
							'attributes' 			=> array(
								'min' 				=> '1',
								'max'				=> '99',
							),
						),
						array(
							'id'    				=> 'footable_order',
							'type'  				=> 'select',
							'title' 				=> __( "Sort: Initial Order", "ts_visual_composer_extend" ),
							'options'				=> array(
								"asc"							=> __( "Ascending", "ts_visual_composer_extend" ),
								"desc"							=> __( "Descending", "ts_visual_composer_extend" ),
							),
							'default'  				=> 'asc',					
							'help'  				=> __( "Define the initial sort order for the column defined above.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|header_use|datatables_sort', 'any|==|==|==', $select_tables . '|datatable|true|true'),
						),
						array(
							'id' 					=> 'footable_noorder',
							'type' 					=> 'text',
							'title' 				=> __( "Sort: Exclude Columns", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns to be excluded from sort controls; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|header_use|datatables_sort', 'any|==|==|==', $select_tables . '|datatable|true|true'),
						),
						array(
							'type'					=> 'subheading',
							'content'				=> __( "DataTable Pagination", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'id'      				=> 'datatables_pages',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Pagination: Use Pagination", "ts_visual_composer_extend" ),
							'default' 				=> 'false',							
							'help' 					=> __( "Switch the toggle if you want to paginate the tables if there are too many rows.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),	
						array(
							'id'    				=> 'datatables_length',
							'type'  				=> 'select',
							'title' 				=> __( "Pagination: Page Length", "ts_visual_composer_extend" ),
							'options'				=> array(
								"5"								=> __( "5 Rows", "ts_visual_composer_extend" ),
								"10"							=> __( "10 Rows", "ts_visual_composer_extend" ),
								"25"							=> __( "25 Rows", "ts_visual_composer_extend" ),
								"50"							=> __( "50 Rows", "ts_visual_composer_extend" ),
								"75"							=> __( "75 Rows", "ts_visual_composer_extend" ),
								"100"							=> __( "100 Rows", "ts_visual_composer_extend" ),
								"custom"						=> __( "Custom Rows", "ts_visual_composer_extend" ),
							),
							'default'  				=> '10',					
							'help'  				=> __( "Define the number of rows to be shown per page.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_pages', 'any|==|==', $select_tables . '|datatable|true'),
						),						
						array(
							'id'      				=> 'datatables_lengthcustom',
							'type'    				=> 'number',
							'title'   				=> __( "Pagination: Custom Length", "ts_visual_composer_extend" ),
							'default' 				=> '10',						  
							'help'    				=> __( "Define the initial number of rows to be shown for each page.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_pages|datatables_length', 'any|==|==|==', $select_tables . '|datatable|true|custom'),
							'attributes' 			=> array(
								'min' 				=> '5',
								'max'				=> '200',
							),
						),
						array(
							'id' 					=> 'datatables_lengthoptions',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							"default"				=> "5,10,15,25,50,75,100,150,200",
							'title' 				=> __( "Pagination: Length Options", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the options that should be made available to the viewer in order to change the pagination length.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_pages', 'any|==|==', $select_tables . '|datatable|true'),
						),						
						array(
							'id'    				=> 'datatables_pagetype',
							'type'  				=> 'select',
							'title' 				=> __( "Pagination: Controls Type", "ts_visual_composer_extend" ),
							'options'				=> array(
								"numbers"						=> __( "Numbers Only", "ts_visual_composer_extend" ),
								"simple"						=> __( "Simple", "ts_visual_composer_extend" ),
								"simple_numbers"				=> __( "Simple Numbers", "ts_visual_composer_extend" ),
								"full"							=> __( "Full", "ts_visual_composer_extend" ),
								"full_numbers"					=> __( "Full Numbers", "ts_visual_composer_extend" ),
							),
							'default'  				=> 'simple_numbers',				
							'help'  				=> __( "Define the type and extent of the pagination controls.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_pages', 'any|==|==', $select_tables . '|datatable|true'),
						),
						array(
							'type'					=> 'subheading',
							'content'				=> __( "DataTable Table Search", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'id'      				=> 'datatables_search',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Search: Table Search", "ts_visual_composer_extend" ),
							'default' 				=> 'false',							
							'help' 					=> __( "Switch the toggle if you want to provide a search input for the table.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'id' 					=> 'datatables_nosearch',
							'type' 					=> 'text',
							'title' 				=> __( "Search: Exclude Columns", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns to be excluded from the table search; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_search', 'any|==|==', $select_tables . '|datatable|true'),
						),
						array(
							'type'					=> 'subheading',
							'content'				=> __( "DataTable Export Settings", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'id'      				=> 'datatables_buttons',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Export: Export Options", "ts_visual_composer_extend" ),
							'default' 				=> 'false',							
							'help' 					=> __( "Switch the toggle if you want to provide buttons to export the table content in various formats.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),						
						array(
							'id'      				=> 'datatables_printshow',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Export: Print Button", "ts_visual_composer_extend" ),
							'default' 				=> 'true',							
							'help' 					=> __( "Switch the toggle if you want to provide a print button for the table.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_buttons', 'any|==|==', $select_tables . '|datatable|true'),
						),
						array(
							'id'      				=> 'datatables_pdfshow',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Export: PDF Button", "ts_visual_composer_extend" ),
							'default' 				=> 'true',							
							'help' 					=> __( "Switch the toggle if you want to provide a PDF export button for the table.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_buttons', 'any|==|==', $select_tables . '|datatable|true'),
						),
						array(
							'id'      				=> 'datatables_excelshow',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Export: Excel Button", "ts_visual_composer_extend" ),
							'default' 				=> 'true',							
							'help' 					=> __( "Switch the toggle if you want to provide a Excel export button for the table.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_buttons', 'any|==|==', $select_tables . '|datatable|true'),
						),
						array(
							'id'      				=> 'datatables_csvshow',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Export: CSV Button", "ts_visual_composer_extend" ),
							'default' 				=> 'true',							
							'help' 					=> __( "Switch the toggle if you want to provide a CSV export button for the table.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_buttons', 'any|==|==', $select_tables . '|datatable|true'),
						),
						array(
							'id'      				=> 'datatables_copyshow',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Export: Copy Button", "ts_visual_composer_extend" ),
							'default' 				=> 'true',							
							'help' 					=> __( "Switch the toggle if you want to provide a copy to clipboard button for the table.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_buttons', 'any|==|==', $select_tables . '|datatable|true'),
						),						
						array(
							'type'					=> 'subheading',
							'content'				=> __( "DataTable Other Settings", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'id'      				=> 'datatables_info',
							'type'    				=> 'switch_button',
							'title'    				=> __( "DataTable: Table Info", "ts_visual_composer_extend" ),
							'default' 				=> 'true',							
							'help' 					=> __( "Switch the toggle if you want to provide a showing summary below the table, updated after search or pagination changes.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'id'      				=> 'datatables_topfixed',
							'type'    				=> 'switch_button',
							'title'    				=> __( "DataTable: Fixed Header", "ts_visual_composer_extend" ),
							'default' 				=> 'false',							
							'help' 					=> __( "Switch the toggle if you want to fix the table header at the top of the screen when scrolling a large table.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						// Footable Column Visibility Settings
						array(
							'type'					=> 'heading',
							'content'				=> __( "Visibility Settings", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						array(
							'type'    				=> 'notice',
							'class'   				=> 'warning',
							'content' 				=> __( "When assigning columns to the respective inputs below, please ensure that you do not define conflicting settings. Breakpoints are based on actual table width, and not available screen width.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						array(
							'id' 					=> 'footable_notever',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Visibility: Removed Columns", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns that will NEVER be shown; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						array(
							'id' 					=> 'footable_collapsed',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Visibility: Collapsed Columns", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns you want to initially collapse (toggle to show/hide content will be shown instead); separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						array(
							'id'      				=> 'footable_cascade',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Visibility: Cascade Breakpoints", "ts_visual_composer_extend" ),
							'default' 				=> 'true',							
							'help' 					=> __( "Switch the toggle if you want to cascade the breakpoint settings below.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						array(
							'type'    				=> 'notice',
							'class'   				=> 'info',
							'content' 				=> __( "Cascading means that if a column is set to be collapsed (for example) on medium size screens, it will automatically be collapsed on small and extra small screens as well. Without cascading, you can make a column hidden on medium size screens but show the same column on any smaller screens again.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						array(
							'type'					=> 'subheading',
							'content'				=> __( "Large Sized Devices", "ts_visual_composer_extend" ) . ' [x > ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FootableLarge . ']',
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						array(
							'id' 					=> 'footable_breaklg',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Visibility: Not On Large Devices", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns that will not be shown on large devices; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						array(
							'type'					=> 'subheading',
							'content'				=> __( "Medium Sized Devices", "ts_visual_composer_extend" ) . ' [' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FootableMedium . ' < x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FootableLarge . ']',
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						array(
							'id' 					=> 'footable_breakmd',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Visibility: Not On Medium Devices", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns that will be not be shown on medium sized devices; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						array(
							'type'					=> 'subheading',
							'content'				=> __( "Small Sized Devices", "ts_visual_composer_extend" ) . ' [' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FootableSmall . ' < x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FootableMedium . ']',
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						array(
							'id' 					=> 'footable_breaksm',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Visibility: Not On Small Devices", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns that will not be shown on small devices; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						array(
							'type'					=> 'subheading',
							'content'				=> __( "Extra Small Devices", "ts_visual_composer_extend" ) . ' [x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FootableSmall . ']', 
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						array(
							'id' 					=> 'footable_breakxs',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Visibility: Not On Extra Small Devices", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns that will not be shown on extra small devices; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|footable'),
						),
						// Datatable Visibility Settings
						array(
							'type'					=> 'heading',
							'content'				=> __( "Visibility Settings", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'type'    				=> 'notice',
							'class'   				=> 'warning',
							'content' 				=> __( "When assigning columns to the respective inputs below, please ensure that you do not define conflicting settings. For example, a column can either be collapsed or hidden at all times, but not both.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'id'      				=> 'datatables_togglerow',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Visibility: Collapsed Toggle", "ts_visual_composer_extend" ),
							'default' 				=> 'false',							
							'help' 					=> __( "Switch the toggle if you want to toggle collapsed columns by clicking anywhere on the row, or just the dedicated toggle indicator.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'id' 					=> 'datatables_collapsed',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Visibility: Collapsed Columns", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns you want to initially collapse (toggle to show/hide content will be shown instead); separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'id' 					=> 'datatables_notever',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Visibility: Removed Columns", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns that will NEVER be shown; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),						
						array(
							'id' 					=> 'datatables_always',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Visibility: Visible Columns", "ts_visual_composer_extend" ),
							'help' 					=> __( "Define the columns that will ALWAYS be shown; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),						
						array(
							'id' 					=> 'datatables_groupit',
							'type'    				=> 'switch_button',
							'title' 				=> __( "Visibility: Group Tablet + Mobile Formats", "ts_visual_composer_extend" ),
							'default' 				=> 'true',	
							'help' 					=> __( "Switch the toggle if you want to group tablet and mobile devices, or if you want to separate each into respective landscape and portrait formats.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),						
						array(
							'type'					=> 'subheading',
							'content'				=> __( "Desktop Devices", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'id' 					=> 'datatables_desktopnot',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Visibility: Not On Desktops", "ts_visual_composer_extend" ) . ' [x > ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableTabletL . ']',
							'help' 					=> __( "Define the columns that will not be visible on desktop devices; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'type'					=> 'subheading',
							'content'				=> __( "Tablet Devices", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'id' 					=> 'datatables_tabletnot',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Visibility: Not On Tablets", "ts_visual_composer_extend" ) . ' [' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableMobileL . ' < x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableTabletL . ']',
							'help' 					=> __( "Define the columns that will not be visible on tablet devices; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_groupit', 'any|==|==', $select_tables . '|datatable|true'),
						),						
						array(
							'id' 					=> 'datatables_tabletnot_l',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Visibility: Not On Tablets (Landscape)", "ts_visual_composer_extend" ) . ' [' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableTabletP . ' < x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableTabletL . ']',
							'help' 					=> __( "Define the columns that will not be visible on tablet devices in landscape format; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_groupit', 'any|==|==', $select_tables . '|datatable|false'),
						),
						array(
							'id' 					=> 'datatables_tabletnot_p',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Visibility: Not On Tablets (Portrait)", "ts_visual_composer_extend" ) . ' [' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableMobileL . ' < x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableTabletP . ']',
							'help' 					=> __( "Define the columns that will not be visible on tablet devices in portrait format; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_groupit', 'any|==|==', $select_tables . '|datatable|false'),
						),
						array(
							'type'					=> 'subheading',
							'content'				=> __( "Mobile Devices", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|==', $select_tables . '|datatable'),
						),
						array(
							'id' 					=> 'datatables_mobilenot',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Visibility: Not On Mobile", "ts_visual_composer_extend" ) . ' [x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableMobileL . ']',
							'help' 					=> __( "Define the columns that will not be visible on mobile devices; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_groupit', 'any|==|==', $select_tables . '|datatable|true'),
						),
						array(
							'id' 					=> 'datatables_mobilenot_l',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Visibility: Not On Mobile (Landscape)", "ts_visual_composer_extend" ) . ' [' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableMobileP . ' < x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableMobileL . ']',
							'help' 					=> __( "Define the columns that will not be visible on mobile devices in landscape format; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_groupit', 'any|==|==', $select_tables . '|datatable|false'),
						),
						array(
							'id' 					=> 'datatables_mobilenot_p',
							'type' 					=> 'tag_editor',
							"delimiter"				=> ", ",
							"numbersonly"			=> "true",
							'title' 				=> __( "Visibility: Not On Mobile (Portrait)", "ts_visual_composer_extend" ) . ' [x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableMobileP . ']',
							'help' 					=> __( "Define the columns that will not be visible on mobile devices in portrait format; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_groupit', 'any|==|==', $select_tables . '|datatable|false'),
						),
						// Language Settings
						array(
							'type'					=> 'heading',
							'content'				=> __( "Locale Text Strings", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|any', $select_tables . '|tablesaw,footable,datatable'),
						),
						array(
							'type'    				=> 'notice',
							'class'   				=> 'warning',
							'content' 				=>  __( "Based on selections made in prior options, the plugin will use certain text strings when rendering some table features. If utilized, you can change those text strings using the inputs below.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|any', $select_tables . '|tablesaw,footable,datatable'),
						),
						array(
							'id'      				=> 'language_modify',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Language: Change Text Strings", "ts_visual_composer_extend" ),
							'default' 				=> 'false',							
							'help' 					=> __( "Switch the toggle if you want to change some of the text strings used on the frontend when rendering the table.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope', 'any|any', $select_tables . '|tablesaw,footable,datatable'),
						),
						array(
							'type'					=> 'subheading',
							'content'				=> __( "TableSaw Text Strings", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|language_modify', 'any|==|==', $select_tables . '|tablesaw|true'),
						),
						array(
							'id' 					=> 'tablesaw_text_reponsive',
							'type' 					=> 'text',
							'title' 				=> __( "Mode Switch: Responsiveness", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawResponsive']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawResponsive'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['tablesawResponsive']),
							'dependency'   			=> array('id|table_scope|tablesaw_modeswitch|language_modify', 'any|==|==|==', $select_tables . '|tablesaw|true|true'),
						),
						array(
							'id' 					=> 'tablesaw_text_stack',
							'type' 					=> 'text',
							'title' 				=> __( "Mode Switch: Stack", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawStack']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawStack'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['tablesawStack']),
							'dependency'   			=> array('id|table_scope|tablesaw_modeswitch|language_modify', 'any|==|==|==', $select_tables . '|tablesaw|true|true'),
						),
						array(
							'id' 					=> 'tablesaw_text_swipe',
							'type' 					=> 'text',
							'title' 				=> __( "Mode Switch: Swipe", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawSwipe']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawSwipe'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['tablesawSwipe']),
							'dependency'   			=> array('id|table_scope|tablesaw_modeswitch|language_modify', 'any|==|==|==', $select_tables . '|tablesaw|true|true'),
						),
						array(
							'id' 					=> 'tablesaw_text_toggle',
							'type' 					=> 'text',
							'title' 				=> __( "Mode Switch: Toggle", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawSort']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawSort'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['tablesawSort']),
							'dependency'   			=> array('id|table_scope|tablesaw_modeswitch|language_modify', 'any|==|==|==', $select_tables . '|tablesaw|true|true'),
						),						
						array(
							'id' 					=> 'tablesaw_text_sort',
							'type' 					=> 'text',
							'title' 				=> __( "Sort: Sort Columns", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawToggle']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawToggle'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['tablesawToggle']),
							'dependency'   			=> array('id|table_scope|tablesaw_modeswitch|language_modify', 'any|==|==|==', $select_tables . '|tablesaw|true|true'),
						),						
						array(
							'id' 					=> 'tablesaw_text_columns',
							'type' 					=> 'text',
							'title' 				=> __( "Other: Columns", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawColumns']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawColumns'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['tablesawColumns']),
							'dependency'   			=> array('id|table_scope|language_modify', 'any|==|==', $select_tables . '|tablesaw|true'),
						),
						array(
							'id' 					=> 'tablesaw_text_error',
							'type' 					=> 'text',
							'title' 				=> __( "Other: No eligible columns.", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawError']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawError'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['tablesawError']),
							'dependency'   			=> array('id|table_scope|language_modify', 'any|==|==', $select_tables . '|tablesaw|true'),
						),
						array(
							'type'					=> 'subheading',
							'content'				=> __( "FooTable Text Strings", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|language_modify', 'any|==|==', $select_tables . '|footable|true'),
						),
						array(
							'id' 					=> 'footable_placeholder',
							'type' 					=> 'text',
							'title' 				=> __( "Search: Placeholder", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footablePlaceholder']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footablePlaceholder'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['footablePlaceholder']),
							'dependency'   			=> array('id|table_scope|footable_search|language_modify', 'any|==|==|==', $select_tables . '|footable|true|true'),
						),
						array(
							'id' 					=> 'footable_noresults',
							'type' 					=> 'text',
							'title' 				=> __( "Search: No Results", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footableNoResults']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footableNoResults'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['footableNoResults']),
							'dependency'   			=> array('id|table_scope|footable_search|language_modify', 'any|==|==|==', $select_tables . '|footable|true|true'),
						),
						array(
							'id' 					=> 'footable_lengthall',
							'type' 					=> 'text',
							'title' 				=> __( "Pagination: All", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footableLengthAll']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footableLengthAll'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['footableLengthAll']),
							'dependency'   			=> array('id|table_scope|footable_pages|language_modify', 'any|==|==|==', $select_tables . '|footable|true|true'),
						),
						array(
							'id' 					=> 'footable_lengthmenu',
							'type' 					=> 'text',
							'title' 				=> __( "Pagination: Show {LM} Entries", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footableLengthMenu']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footableLengthMenu'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['footableLengthMenu']),
							'dependency'   			=> array('id|table_scope|footable_pages|language_modify', 'any|==|==|==', $select_tables . '|footable|true|true'),
						),
						array(
							'type'    				=> 'notice',
							'class'   				=> 'info',
							'content' 				=>  __( "The {LM} placeholder in this language string will be replaced with the possible page length options of (5, 10, 25, ... etc.) and is required for the page length select option to be rendered correctly.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|footable_pages|language_modify', 'any|==|==|==', $select_tables . '|footable|true|true'),
						),
						array(
							'id' 					=> 'footable_countformat',
							'type' 					=> 'text',
							'title' 				=> __( "Pagination: Count Format", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footableCountFormat']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footableCountFormat'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['footableCountFormat']),
							'dependency'   			=> array('id|table_scope|footable_pages|language_modify', 'any|==|==|==', $select_tables . '|footable|true|true'),
						),
						array(
							'type'    				=> 'notice',
							'class'   				=> 'info',
							'content' 				=>  __( "The default count format uses the current page and total pages placeholders which are substituted at run time for the actual values. The below lists all available placeholders that you can use when supplying your own format.<br/><br/>{CP} - The current page.<br/>{TP} - The total number of pages available.<br/>{PF} - The first row number of the current page.<br/>{PL} - The last row number of the current page.<br/>{TR} - The total number of rows available.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|footable_pages|language_modify', 'any|==|==|==', $select_tables . '|footable|true|true'),
						),
						array(
							'type'					=> 'subheading',
							'content'				=> __( "DataTable Text Strings", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|language_modify', 'any|==|==', $select_tables . '|datatable|true'),
						),
						array(
							'id' 					=> 'datatable_text_processing',
							'type' 					=> 'text',
							'title' 				=> __( "General: Processing", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableProcessing']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableProcessing'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableProcessing']),
							'dependency'   			=> array('id|table_scope|language_modify', 'any|==|==', $select_tables . '|datatable|true'),
						),
						array(
							'id' 					=> 'datatable_text_search',
							'type' 					=> 'text',
							'title' 				=> __( "Search: Search All Entries:", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableSearch']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableSearch'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableSearch']),
							'dependency'   			=> array('id|table_scope|datatables_search|language_modify', 'any|==|==|==', $select_tables . '|datatable|true|true'),
						),
						array(
							'id' 					=> 'datatable_text_placeholder',
							'type' 					=> 'text',
							'title' 				=> __( "Search: Enter keyword here ...", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatablePlaceholder']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatablePlaceholder'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatablePlaceholder']),
							'dependency'   			=> array('id|table_scope|datatables_search|language_modify', 'any|==|==|==', $select_tables . '|datatable|true|true'),
						),
						array(
							'id' 					=> 'datatable_text_zerorecords',
							'type' 					=> 'text',
							'title' 				=> __( "Search: No Entries To Display!", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableZeroRecords']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableZeroRecords'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableZeroRecords']),
							'dependency'   			=> array('id|table_scope|datatables_search|language_modify', 'any|==|==|==', $select_tables . '|datatable|true|true'),
						),
						array(
							'id' 					=> 'datatable_text_lengthall',
							'type' 					=> 'text',
							'title' 				=> __( "Pagination: All", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableLengthAll']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableLengthAll'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableLengthAll']),
							'dependency'   			=> array('id|table_scope|datatables_pages|language_modify', 'any|==|==|==', $select_tables . '|datatable|true|true'),
						),
						array(
							'id' 					=> 'datatable_text_lengthmenu',
							'type' 					=> 'text',
							'title' 				=> __( "Pagination: Show _MENU_ Entries", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableLengthMenu']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableLengthMenu'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableLengthMenu']),
							'dependency'   			=> array('id|table_scope|datatables_pages|language_modify', 'any|==|==|==', $select_tables . '|datatable|true|true'),
						),
						array(
							'type'    				=> 'notice',
							'class'   				=> 'info',
							'content' 				=>  __( "The _MENU_ placeholder in this language string will be replaced with the possible page length options of (5, 10, 25, ... etc.) and is required for the page length select option to be rendered correctly.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_pages|language_modify', 'any|==|==|==', $select_tables . '|datatable|true|true'),
						),
						array(
							'id' 					=> 'datatable_text_infomain',
							'type' 					=> 'text',
							'title' 				=> __( "Pagination: Showing _START_ to _END_ of _TOTAL_ Entries", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableInfoMain']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableInfoMain'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableInfoMain']),
							'dependency'   			=> array('id|table_scope|datatables_pages|language_modify', 'any|==|==|==', $select_tables . '|datatable|true|true'),
						),
						array(
							'type'    				=> 'notice',
							'class'   				=> 'info',
							'content' 				=>  __( "This string gives information to the end user about the information that is currently on display on the page. The following tokens can be used in the string and will be dynamically replaced as the table display updates.<br/><br/>_START_ - Display index of the first record on the current page.<br/>_END_ - Display index of the last record on the current page.<br/>_TOTAL_ - Number of records in the table after filtering.<br/>_MAX_ - Number of records in the table without filtering.<br/>_PAGE_ - Current page number.<br/>_PAGES_ - Total number of pages of data in the table.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_pages|language_modify', 'any|==|==|==', $select_tables . '|datatable|true|true'),
						),
						array(
							'id' 					=> 'datatable_text_infoempty',
							'type' 					=> 'text',
							'title' 				=> __( "Pagination: No Entries To Show!", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableInfoEmpty']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableInfoEmpty'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableInfoEmpty']),
							'dependency'   			=> array('id|table_scope|datatables_pages|language_modify', 'any|==|==|==', $select_tables . '|datatable|true|true'),
						),
						array(
							'id' 					=> 'datatable_text_infofiltered',
							'type' 					=> 'text',
							'title' 				=> __( "Pagination: - filtered from _MAX_ records.", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableInfoFiltered']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableInfoFiltered'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableInfoFiltered']),
							'dependency'   			=> array('id|table_scope|datatables_pages|language_modify', 'any|==|==|==', $select_tables . '|datatable|true|true'),
						),
						array(
							'type'    				=> 'notice',
							'class'   				=> 'info',
							'content' 				=>  __( "When a user filters the information in a table via search, this string is appended to the information summary to give an idea of how strong the filtering is. The token _MAX_ will be replaced with the number of total records in the table.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|table_scope|datatables_pages|language_modify', 'any|==|==|==', $select_tables . '|datatable|true|true'),
						),
						array(
							'id' 					=> 'datatable_text_first',
							'type' 					=> 'text',
							'title' 				=> __( "Pagination: First", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableFirst']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableFirst'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableFirst']),
							'dependency'   			=> array('id|table_scope|datatables_pages|language_modify', 'any|==|==|==', $select_tables . '|datatable|true|true'),
						),
						array(
							'id' 					=> 'datatable_text_previous',
							'type' 					=> 'text',
							'title' 				=> __( "Pagination: Previous", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatablePrevious']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatablePrevious'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatablePrevious']),
							'dependency'   			=> array('id|table_scope|datatables_pages|language_modify', 'any|==|==|==', $select_tables . '|datatable|true|true'),
						),
						array(
							'id' 					=> 'datatable_text_next',
							'type' 					=> 'text',
							'title' 				=> __( "Pagination: Next", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableNext']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableNext'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableNext']),
							'dependency'   			=> array('id|table_scope|datatables_pages|language_modify', 'any|==|==|==', $select_tables . '|datatable|true|true'),
						),
						array(
							'id' 					=> 'datatable_text_last',
							'type' 					=> 'text',
							'title' 				=> __( "Pagination: Last", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableLast']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableLast'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableLast']),
							'dependency'   			=> array('id|table_scope|datatables_pages|language_modify', 'any|==|==|==', $select_tables . '|datatable|true|true'),
						),
						array(
							'id' 					=> 'datatables_printtext',
							'type' 					=> 'text',
							'title' 				=> __( "Export: Print", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatablePrint']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatablePrint'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatablePrint']),
							'dependency'   			=> array('id|table_scope|datatables_buttons|datatables_printshow|language_modify', 'any|==|==|==|==', $select_tables . '|datatable|true|true|true'),
						),
						array(
							'id' 					=> 'datatables_pdftext',
							'type' 					=> 'text',
							'title' 				=> __( "Export: PDF", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatablePDF']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatablePDF'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatablePDF']),
							'dependency'   			=> array('id|table_scope|datatables_buttons|datatables_pdfshow|language_modify', 'any|==|==|==|==', $select_tables . '|datatable|true|true|true'),
						),
						array(
							'id' 					=> 'datatables_exceltext',
							'type' 					=> 'text',
							'title' 				=> __( "Export: Excel", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableExcel']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableExcel'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableExcel']),
							'dependency'   			=> array('id|table_scope|datatables_buttons|datatables_excelshow|language_modify', 'any|==|==|==|==', $select_tables . '|datatable|true|true|true'),
						),
						array(
							'id' 					=> 'datatables_csvtext',
							'type' 					=> 'text',
							'title' 				=> __( "Export: CSV", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableCSV']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableCSV'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableCSV']),
							'dependency'   			=> array('id|table_scope|datatables_buttons|datatables_csvshow|language_modify', 'any|==|==|==|==', $select_tables . '|datatable|true|true|true'),
						),
						array(
							'id' 					=> 'datatables_copytext',
							'type' 					=> 'text',
							'title' 				=> __( "Export: Copy", "ts_visual_composer_extend" ),
							'default'				=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableCopy']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableCopy'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableCopy']),
							'dependency'   			=> array('id|table_scope|datatables_buttons|datatables_copyshow|language_modify', 'any|==|==|==|==', $select_tables . '|datatable|true|true|true'),
						),
						// Style Settings
						array(
							'type'					=> 'heading',
							'content'				=> __( "Style Settings", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id'      				=> 'styling_customize',
							'type'    				=> 'switch_button',
							'title'    				=> __( "Styling: Basic Customizations", "ts_visual_composer_extend" ),
							'default' 				=> 'false',							
							'help' 					=> __( "Switch the toggle if you want to adjust some basic styling attributes for the table.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'type'    				=> 'notice',
							'class'   				=> 'warning',
							'content' 				=> __( "Any style settings done to individual cells using the table editor will overrule any of the global style settings made below.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id|styling_customize', 'any|==', $select_tables . '|true'),
						),
						array(
							'id'      				=> 'styling_size_head',
							'type'    				=> 'number',
							'title'   				=> __( "Table Head: Font Size", "ts_visual_composer_extend" ),
							'default' 				=> '16',						  
							'help'    				=> __( "Define the desired font size for the table header section.", "ts_visual_composer_extend" ),
							'attributes' 			=> array(
								'min' 				=> '12',
								'max'				=> '36',
							),
							'dependency'   			=> array('id|styling_customize', 'any|==', $select_tables . '|true'),
						),
						array(
							'id'    				=> 'styling_weight_head',
							'type'  				=> 'select',
							'title' 				=> __( "Table Head: Font Weight", "ts_visual_composer_extend" ),
							'options'				=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Styling_FontWeights),
							'default'  				=> 'bold',
							'dependency'   			=> array('id|styling_customize', 'any|==', $select_tables . '|true'),
							'help'  				=> __( "Select the font weight for the table header section.", "ts_visual_composer_extend" ),
						),
						array(
							'id'    				=> 'styling_transform_head',
							'type'  				=> 'select',
							'title' 				=> __( "Table Head: Text Transform", "ts_visual_composer_extend" ),
							'options'				=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Styling_TextTransforms),
							'default'  				=> 'none',
							'dependency'   			=> array('id|styling_customize', 'any|==', $select_tables . '|true'),
							'help'  				=> __( "Select the text transform property for the table header section.", "ts_visual_composer_extend" ),
						),
						array(
							'id'      				=> 'styling_size_body',
							'type'    				=> 'number',
							'title'   				=> __( "Table Body: Font Size", "ts_visual_composer_extend" ),
							'default' 				=> '13',						  
							'help'    				=> __( "Define the desired font size for the table body section.", "ts_visual_composer_extend" ),
							'attributes' 			=> array(
								'min' 				=> '12',
								'max'				=> '24',
							),
							'dependency'   			=> array('id|styling_customize', 'any|==', $select_tables . '|true'),
						),
						array(
							'id'    				=> 'styling_weight_body',
							'type'  				=> 'select',
							'title' 				=> __( "Table Body: Font Weight", "ts_visual_composer_extend" ),
							'options'				=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Styling_FontWeights),
							'default'  				=> 'normal',
							'dependency'   			=> array('id|styling_customize', 'any|==', $select_tables . '|true'),
							'help'  				=> __( "Select the font weight for the table body section.", "ts_visual_composer_extend" ),
						),
						array(
							'id'    				=> 'styling_transform_body',
							'type'  				=> 'select',
							'title' 				=> __( "Table Body: Text Transform", "ts_visual_composer_extend" ),
							'options'				=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Styling_TextTransforms),
							'default'  				=> 'none',
							'dependency'   			=> array('id|styling_customize', 'any|==', $select_tables . '|true'),
							'help'  				=> __( "Select the text transform property for the table body section.", "ts_visual_composer_extend" ),
						),
						array(
							'id'      				=> 'styling_size_foot',
							'type'    				=> 'number',
							'title'   				=> __( "Table Foot: Font Size", "ts_visual_composer_extend" ),
							'default' 				=> '16',						  
							'help'    				=> __( "Define the desired font size for the table footer section.", "ts_visual_composer_extend" ),
							'attributes' 			=> array(
								'min' 				=> '12',
								'max'				=> '36',
							),
							'dependency'   			=> array('id|styling_customize', 'any|==', $select_tables . '|true'),
						),
						array(
							'id'    				=> 'styling_weight_foot',
							'type'  				=> 'select',
							'title' 				=> __( "Table Foot: Font Weight", "ts_visual_composer_extend" ),
							'options'				=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Styling_FontWeights),
							'default'  				=> 'bold',
							'dependency'   			=> array('id|styling_customize', 'any|==', $select_tables . '|true'),
							'help'  				=> __( "Select the font weight for the table footer section.", "ts_visual_composer_extend" ),
						),
						array(
							'id'    				=> 'styling_transform_foot',
							'type'  				=> 'select',
							'title' 				=> __( "Table Foot: Text Transform", "ts_visual_composer_extend" ),
							'options'				=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Styling_TextTransforms),
							'default'  				=> 'none',
							'dependency'   			=> array('id|styling_customize', 'any|==', $select_tables . '|true'),
							'help'  				=> __( "Select the text transform property for the table footer section.", "ts_visual_composer_extend" ),
						),
						// Other Settings
						array(
							'type'					=> 'heading',
							'content'				=> __( "Other Settings", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id'      				=> 'margin_top',
							'type'    				=> 'number',
							'title'   				=> __( "Margin: Top", "ts_visual_composer_extend" ),
							'default' 				=> '0',						  
							'help'    				=> __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
							'attributes' 			=> array(
								'min' 				=> '-50',
								'max'				=> '200',
							),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id'      				=> 'margin_bottom',
							'type'    				=> 'number',
							'title'   				=> __( "Margin: Bottom", "ts_visual_composer_extend" ),
							'default' 				=> '0',						  
							'help'    				=> __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
							'attributes' 			=> array(
								'min' 				=> '-50',
								'max'				=> '200',
							),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id' 					=> 'el_id',
							'type' 					=> 'text',
							'title' 				=> __( "Define ID Name", "ts_visual_composer_extend" ),
							'help' 					=> __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
						array(
							'id' 					=> 'el_class',
							'type' 					=> 'tag_editor',
							'title' 				=> __( "Extra Class Names", "ts_visual_composer_extend" ),
							'help' 					=> __( "Enter additional class names for the element.", "ts_visual_composer_extend" ),
							'dependency'   			=> array('id', 'any', $select_tables),
						),
					),
				),			
			),
		);
			
		return $shortcodes;
	}	
	add_filter('cs_shortcode_options', 'TS_TablesWP_Generator_Codestar');
?>