<?php
    global $TS_ADVANCED_TABLESWP;
	// Register Container and Child Shortcode with Visual Composer
	if ((class_exists('WPBakeryShortCode')) && (!class_exists('WPBakeryShortCode_TS_Advanced_Tables'))) {
		class WPBakeryShortCode_TS_Advanced_Tables extends WPBakeryShortCode {};
	}
	// Create Data Array for Element
	$TS_ADVANCED_TABLESWP->TS_TablesWP_VisualComposer_Element = array(
		"name" 							=> __("TS Advanced Table", "ts_visual_composer_extend"),
		"base" 							=> "TS_Advanced_Tables",
		"icon" 							=> "ts-composer-element-icon-advanced-tables",
		"category" 						=> __('VC Extensions', "ts_visual_composer_extend"),
		"description"					=> __("Place an advanced table element", "ts_visual_composer_extend"),
		"admin_enqueue_js"				=> "",
		"admin_enqueue_css"				=> "",
		"show_settings_on_create" 		=> true,
		"params" 						=> array(
			// Table Selector
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_a01",
				"seperator"				=>  __( "Table Selection", "ts_visual_composer_extend" ),
			),
			/*array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Table: Source", "ts_visual_composer_extend" ),
				"param_name"        	=> "source",
				"value"             	=> array(
					__( "Internal Table", "ts_visual_composer_extend" )								=> "internal",
					__( "Google Spreadsheet", "ts_visual_composer_extend" )							=> "google",
				),
				"description"			=> __( "Select the source for the table data.", "ts_visual_composer_extend" ),
			),*/
			array(
				"type"              	=> "advanced_tables",
				"heading"           	=> __( "Table: ID", "ts_visual_composer_extend" ),
				"param_name"        	=> "id",
				"google"				=> "true",
				"value" 				=> "",
				"admin_label"       	=> true,
				"description"       	=> __( "Select the advanced table you want to display.", "ts_visual_composer_extend" ),
				//"dependency"        	=> array( 'element' => "source", 'value' => 'internal' ),
			),
			// Table Scope
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Table: Formatting Source", "ts_visual_composer_extend" ),
				"param_name"        	=> "table_formatting",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Format_Sources,
				"admin_label"       	=> true,
				"description"			=> __( "Define if and what formatting data should be used for table cells.", "ts_visual_composer_extend" ),
			),	
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Table: Theme / Scope", "ts_visual_composer_extend" ),
				"param_name"        	=> "table_scope",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Styling_TableThemes,
				"admin_label"       	=> true,
				"description"			=> __( "Define what style and/or type of table you want to render.", "ts_visual_composer_extend" ),
			),			
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Table: Color Theme", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_theme",
				"value"             	=> array(
					__( "Default", "ts_visual_composer_extend" )									=> "default",
					__( "Yellow", "ts_visual_composer_extend" )										=> "yellow",
					__( "Blue", "ts_visual_composer_extend" )										=> "blue",
				),
				"description"			=> __( "Define the color theme to be used for the table.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => 'datatable' )
			),
			// Table Exclusion
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Exclude: Rows", "ts_visual_composer_extend" ),
				"param_name"        	=> "exclude_rows",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the rows within the table dataset you want to exclude when rendering the table; separate rows with comma and use only numeric values.", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Exclude: Columns", "ts_visual_composer_extend" ),
				"param_name"        	=> "exclude_columns",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns within the table dataset you want to exclude when rendering the table; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('none', 'minimal', 'simplelittle', 'blank', 'tablesaw') )
			),
			// Table Extra Output
			array(
				"type"					=> "seperator",
				"param_name"			=> "seperator_a02",
				"seperator"				=> __( "Other Output Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Table: Show Name", "ts_visual_composer_extend" ),
				"param_name"        	=> "show_name",
				"value"             	=> "false",
				"admin_label"       	=> true,
				"description"       	=> __( "Switch the toggle if you want to show the table name above the table.", "ts_visual_composer_extend" )
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Table: Show Info", "ts_visual_composer_extend" ),
				"param_name"        	=> "show_info",
				"value"             	=> "false",
				"admin_label"       	=> true,
				"description"       	=> __( "Switch the toggle if you want to show the optional table information above the table.", "ts_visual_composer_extend" )
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Table: Show Comments", "ts_visual_composer_extend" ),
				"param_name"        	=> "show_comments",
				"value"             	=> "false",
				"admin_label"       	=> true,
				"description"       	=> __( "Switch the toggle if you want to show applied cell comments via tooltip when hovering over a cell.", "ts_visual_composer_extend" )
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Table: Show Indicator", "ts_visual_composer_extend" ),
				"param_name"        	=> "show_indicator",
				"value"             	=> "true",
				"description"       	=> __( "Switch the toggle if you want to show a tooltip indicator icon for all cells with a comment.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "show_comments", 'value' => 'true' ),
			),
			array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger_a01",
				"color"					=> "#006BB7",
				"size"					=> "13",
				"layout"				=> "notice",
				"level"					=> "warning",
				"message"            	=> __( "Based on the content a shortcode will result in after getting processed, the table responsiveness and/or other features, such as sorting or filtering, might be negatively impacted. It is best to only use shortcodes if they generate basic cell content such as numbers. The more cells the table contains, the longer the table rendering will take, as every cell must be checked for shortcode content first, which requires additional processing time.", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "switch_button",
				"heading"           	=> __( "Table: Shortcode Content", "ts_visual_composer_extend" ),
				"param_name"        	=> "table_shortcodes",
				"value"             	=> "false",
				"description"			=> __( "Define if the plugin should check table cells for shortcode content and process them accordingly.", "ts_visual_composer_extend" ),
			),
			// Preloader Settings
			array(
				"type"					=> "seperator",
				"param_name"			=> "seperator_a03",
				"seperator"				=> __( "Preloader Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"				=> __( "Preloader: Show Animation", "ts_visual_composer_extend" ),
				"param_name"			=> "preloader_use",
				"value"					=> "false",
				"description"			=> __( "Switch the toggle if you want to show a preloader animation while the table is rendering; useful for large tables with advanced features.", "ts_visual_composer_extend" )
			),		
			array(
				"type"					=> "livepreview",
				"heading"				=> __( "Preloader: Style", "ts_visual_composer_extend" ),
				"param_name"			=> "preloader_style",
				"preview"				=> "preloaders",
				"shownone"				=> "false",
				"value"					=> 0,
				"description"			=> __( "Select the style for the preloader animation to be shown while the table is rendering.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "preloader_use", 'value' => 'true' ),
			),
			array(
				"type"					=> "colorpicker",
				"heading"				=> __( "Preloader: Background Color", "ts_visual_composer_extend" ),
				"param_name"			=> "preloader_background",
				"value"					=> "rgba(255, 255, 255, 0.90)",
				"description"			=> __( "Define the background color for the preloader container.", "ts_visual_composer_extend" ),
				"dependency"			=> array( 'element' => "preloader_use", 'value' => 'true' ),
			),
			// Table Header / Footers
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_a04",
				"seperator"				=> __( "Header + Footer Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Header: Create Header", "ts_visual_composer_extend" ),
				"param_name"        	=> "header_use",
				"value"             	=> "true",
				"admin_label"       	=> true,
				"description"       	=> __( "Switch the toggle if you want to use some rows as official table header.", "ts_visual_composer_extend" )
			),
			array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger_a02",
				"color"					=> "#006BB7",
				"size"					=> "13",
				"layout"				=> "notice",
				"level"					=> "critical",
				"message"            	=> __( "The advanced TableSaw script requires at least one header row. Even if you disable the header option, the plugin will forcibly use the first row as header in order to prevent a failure of the TableSaw script.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('tablesaw') ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Header: Rows", "ts_visual_composer_extend" ),
				"param_name"        	=> "header_rows",
				"value"             	=> "1",
				"min"               	=> "1",
				"max"               	=> "3",
				"step"              	=> "1",
				"unit"              	=> '',
				"description"       	=> __( "Define the number of top rows that should be used as header.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "header_use", 'value' => 'true' )
			),
			array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger_a03",
				"color"					=> "#006BB7",
				"size"					=> "13",
				"layout"				=> "notice",
				"level"					=> "critical",
				"message"            	=> __( "The Footable script is currently unable to handle footer rows, as the footer is a reserved space for the paging component only.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Footer: Create Footer", "ts_visual_composer_extend" ),
				"param_name"        	=> "footer_use",
				"value"             	=> "false",
				"admin_label"       	=> true,
				"description"       	=> __( "Switch the toggle if you want to use the last row as official table footer.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('none', 'minimal', 'simplelittle', 'blank', 'tablesaw', 'datatable') ),
			),
			/*array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Footer: Rows", "ts_visual_composer_extend" ),
				"param_name"        	=> "footer_rows",
				"value"             	=> "1",
				"min"               	=> "1",
				"max"               	=> "3",
				"step"              	=> "1",
				"unit"              	=> '',
				"description"       	=> __( "Define the number of bottom rows that should be used as footer.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "footer_use", 'value' => 'true' )
			),*/
			// Table Column Formats
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_a05",
				"seperator"				=> __( "Columns Format Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger_a04",
				"color"					=> "#006BB7",
				"size"					=> "13",
				"layout"				=> "notice",
				"level"					=> "warning",
				"message"            	=> __( "Advanced table scripts will attempt to parse the column content to determine the format of the content, which is relevant for any sorting feature to work correctly. Using the inputs below, you can manually assign columns to specific formats.", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger_a05",
				"color"					=> "#006BB7",
				"size"					=> "13",
				"layout"				=> "notice",
				"level"					=> "critical",
				"message"            	=> __( "The FooTable script requires you to manually assign each column to a specific format, in order to ensure that the content is formatted (and sorted) correctly.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
			),
			/*array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger_a06",
				"color"					=> "#006BB7",
				"size"					=> "13",
				"layout"				=> "notice",
				"level"					=> "critical",
				"message"            	=> __( "The TableSaw script requires you to manually assign each column to a specific format, in order to ensure that the content is formatted (and sorted) correctly.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('tablesaw') ),
			),*/
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_a06",
				"seperator"				=> __( "Standard Column Formats", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Columns: HTML/Text Content", "ts_visual_composer_extend" ),
				"param_name"        	=> "format_html",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that contain HTML and/or text content only; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Columns: Numeric Content", "ts_visual_composer_extend" ),
				"param_name"        	=> "format_number",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that contain standard numbers only; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Columns: Currency Content", "ts_visual_composer_extend" ),
				"param_name"        	=> "format_currency",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that contain currency numbers only; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Columns: Percent Content", "ts_visual_composer_extend" ),
				"param_name"        	=> "format_percent",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that contain percent numbers only; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Columns: Date Content", "ts_visual_composer_extend" ),
				"param_name"        	=> "format_date",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that contain date strings only; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Columns: Time Content", "ts_visual_composer_extend" ),
				"param_name"        	=> "format_time",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that contain time strings only; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
			),
			// Hybrid Column Formats
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_a07",
				"seperator"				=> __( "Hybrid Column Formats", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Columns: Alpha-Numeric (Case Sensitive)", "ts_visual_composer_extend" ),
				"param_name"        	=> "format_natural_simple",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"description"			=> __( "Define the columns that contain alpha-numeric strings only (normal sorting); separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Columns: Alpha-Numeric (Case Insensitive)", "ts_visual_composer_extend" ),
				"param_name"        	=> "format_natural_nocase",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"description"			=> __( "Define the columns that contain alpha-numeric strings only (case insensitive sorting); separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Columns: Numeric-HTML", "ts_visual_composer_extend" ),
				"param_name"        	=> "format_numeric_html",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"description"			=> __( "Define the columns that contain numeric strings within HTML tags only; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
			),
			// Table Custom Formatting
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_a08",
				"seperator"				=> __( "Custom Format Settings", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger_a07",
				"color"					=> "#006BB7",
				"size"					=> "13",
				"layout"				=> "notice",
				"level"					=> "warning",
				"message"            	=> __( "The following settings will replace any custom formatting added to individal table cells, using the toolbar in the table editor. Formats will instead be applied based on the column format assignments made above.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_a09",
				"seperator"				=> __( "Content Alignments", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Format: Horizontal Alignment", "ts_visual_composer_extend" ),
				"param_name"        	=> "numbers_horizontal",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Alignment_Horizontal,
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"description"			=> __( "Define the horizontal alignment for any cell content.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),	
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Format: Vertical Alignment", "ts_visual_composer_extend" ),
				"param_name"        	=> "numbers_vertical",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Alignment_Vertical,
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"description"			=> __( "Define the vertical alignment for any cell content.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_a10",
				"seperator"				=> __( "Currency Formatting", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Format: Cell Locale", "ts_visual_composer_extend" ),
				"param_name"        	=> "numbers_locale",
				"value"             	=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_NumbroJS_Locales),
				"default"				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_EditorLocale,
				"standard"				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_EditorLocale,
				"std"					=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_EditorLocale,
				"description"			=> __( "Define the locale that should be used for any number formatting.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Format: Currency Symbol", "ts_visual_composer_extend" ),
				"param_name"        	=> "numbers_symbol",
				"value"             	=> array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Currency_HTML_Inverted) + array_flip($TS_ADVANCED_TABLESWP->TS_TablesWP_Currency_CountryCodes),
				"default"				=> "36",
				"standard"				=> "36",
				"std"					=> "36",
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"description"			=> __( "Define the symbol to be used for currency formatting.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Format: Currency Placement", "ts_visual_composer_extend" ),
				"param_name"        	=> "numbers_placement",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Currency_Placement,
				"default"				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_CurrencyPlacement,
				"standard"				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_CurrencyPlacement,
				"std"					=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_CurrencyPlacement,
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"description"			=> __( "Define the placement of the currency symbol in relation to the value.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),			
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Format: Currency Space", "ts_visual_composer_extend" ),
				"param_name"        	=> "numbers_space_currency",
				"value"             	=> ($TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_CurrencySpace == true ? 'true' : 'false'),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"description"       	=> __( "Switch the toggle if you want to add a space between the currency symbol and the value.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Format: Currency Decimals", "ts_visual_composer_extend" ),
				"param_name"        	=> "numbers_decimals_currency",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DecimalsCurrency,
				"min"               	=> "0",
				"max"               	=> "6",
				"step"              	=> "1",
				"unit"              	=> 'x',
				"description"       	=> __( "Define the number of decimals to be used for currency values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_a11",
				"seperator"				=> __( "Percentage Formatting", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Format: Percent Space", "ts_visual_composer_extend" ),
				"param_name"        	=> "numbers_space_percent",
				"value"             	=> ($TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_PercentSpace == true ? 'true' : 'false'),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"description"       	=> __( "Switch the toggle if you want to add a space between the percentage symbol and the value.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Format: Percent Decimals", "ts_visual_composer_extend" ),
				"param_name"        	=> "numbers_decimals_percent",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DecimalsPercent,
				"min"               	=> "0",
				"max"               	=> "6",
				"step"              	=> "1",
				"unit"              	=> 'x',
				"description"       	=> __( "Define the number of decimals to be used for percentage values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_a12",
				"seperator"				=> __( "Numbers Formatting", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Format: Numbers Decimals", "ts_visual_composer_extend" ),
				"param_name"        	=> "numbers_decimals_numeric",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DecimalsNumeric,
				"min"               	=> "0",
				"max"               	=> "6",
				"step"              	=> "1",
				"unit"              	=> 'x',
				"description"       	=> __( "Define the number of decimals to be used for standard numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_a13",
				"seperator"				=> __( "Date + Time Formatting", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Format: Dates", "ts_visual_composer_extend" ),
				"param_name"        	=> "numbers_date",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Format_Dates,
				"default"				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FormatDate,
				"standard"				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FormatDate,
				"std"					=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FormatDate,
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"description"			=> __( "Define the desired format for all date values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),			
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Format: Hours", "ts_visual_composer_extend" ),
				"param_name"        	=> "numbers_time_hours",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Format_Hours,
				"default"				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FormatTimeHours,
				"standard"				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FormatTimeHours,
				"std"					=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FormatTimeHours,
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"description"			=> __( "Define the desired format for hours in all time values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),	
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Format: Minutes", "ts_visual_composer_extend" ),
				"param_name"        	=> "numbers_time_minutes",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Format_Minutes,
				"default"				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FormatTimeMinutes,
				"standard"				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FormatTimeMinutes,
				"std"					=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FormatTimeMinutes,
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"description"			=> __( "Define the desired format for minutes in all time values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),	
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Format: Seconds", "ts_visual_composer_extend" ),
				"param_name"        	=> "numbers_time_seconds",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Format_Seconds,
				"default"				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FormatTimeSeconds,
				"standard"				=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FormatTimeSeconds,
				"std"					=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FormatTimeSeconds,
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"description"			=> __( "Define the desired format for seconds in all time values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_a14",
				"seperator"				=> __( "Other Formatting", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Format: Process Header", "ts_visual_composer_extend" ),
				"param_name"        	=> "numbers_header",
				"value"             	=> "false",
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"description"       	=> __( "Switch the toggle if you want to apply the formatting to header cells as well.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Format: Process Footer", "ts_visual_composer_extend" ),
				"param_name"        	=> "numbers_footer",
				"value"             	=> "true",
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"description"       	=> __( "Switch the toggle if you want to apply the formatting to footer cells as well.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Format: Excluded Rows", "ts_visual_composer_extend" ),
				"param_name"        	=> "numbers_exclude",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the rows that should be excluded from formatting; separate rows with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_formatting", 'value' => 'custom' ),
			),
			// Table Column Widths
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_a15",
				"seperator"				=> __( "Columns Width Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger_a08",
				"color"					=> "#006BB7",
				"size"					=> "13",
				"layout"				=> "notice",
				"level"					=> "warning",
				"message"            	=> __( "In order to ensure at least a basic responsive behavior for the table, absolute fixed column widths are not possible, as the table must be able to adjust column widths based on the applied responsive behavior. But you can use the options below to at least define a desired minimum and maximum width for the columns, and the applied table theme or advanced table script will attempt to use those settings, if at all possible. Without any defined desired widths, the browser will determine all column widths based on content solely.", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Columns: Desired Widths", "ts_visual_composer_extend" ),
				"param_name"        	=> "columns_widthlimit",
				"value"             	=> "true",
				"admin_label"       	=> true,
				"description"       	=> __( "Switch the toggle if you want to assign desired minimum and maximum widths for columns within this table.", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Columns: Minimum Width", "ts_visual_composer_extend" ),
				"param_name"        	=> "columns_widthmin",
				"value"             	=> "120",
				"min"               	=> "100",
				"max"               	=> "250",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Define the desired minimum width for columns.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "columns_widthlimit", 'value' =>'true' ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Columns: Maximum Width", "ts_visual_composer_extend" ),
				"param_name"        	=> "columns_widthmax",
				"value"             	=> "300",
				"min"               	=> "250",
				"max"               	=> "500",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Define the desired maximum width for columns.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "columns_widthlimit", 'value' =>'true' ),
			),			
			// Table Styling
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_b01",
				"seperator"				=> __( "Table Features", "ts_visual_composer_extend" ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Table: Responsiveness", "ts_visual_composer_extend" ),
				"param_name"        	=> "responsive_type",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Styling_TableResponsive,
				"description"			=> __( "Define what type of responsive behavior should be applied to the table.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('none', 'minimal', 'simplelittle', 'blank') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Table: Layout Trigger", "ts_visual_composer_extend" ),
				"param_name"        	=> "responsive_switch",
				"value"             	=> "640",
				"min"               	=> "360",
				"max"               	=> "1280",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Select the table width at which the table should switch into responsive mode.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "responsive_type", 'value' => array('tiles', 'stack', 'split', 'flexflow', 'flexflip') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Table: Maximum Height", "ts_visual_composer_extend" ),
				"param_name"        	=> "responsive_heighttype",
				"value"             	=> array(
					__( "No Maximum Height", "ts_visual_composer_extend" )						=> "none",
					__( "Dynamic Maximum Height", "ts_visual_composer_extend" )					=> "dynamic",
					__( "Fixed Maximum Height", "ts_visual_composer_extend" )					=> "fixed",					
				),
				"description"			=> __( "Define if and how the maximum height for the adjusted table should be set.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "responsive_type", 'value' => array('tiles', 'stack') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Table: Dynamic Height (Percent)", "ts_visual_composer_extend" ),
				"param_name"        	=> "responsive_heightppercent",
				"value"             	=> "75",
				"min"               	=> "50",
				"max"               	=> "200",
				"step"              	=> "1",
				"unit"              	=> '%',
				"description"       	=> __( "Define the maximum dynamic height for the adjusted table (as a percentage of visible browser height).", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "responsive_heighttype", 'value' => "dynamic" ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),	
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Table: Fixed Height (Pixel)", "ts_visual_composer_extend" ),
				"param_name"        	=> "responsive_heightpixel",
				"value"             	=> "800",
				"min"               	=> "400",
				"max"               	=> "1600",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Define the maximum fixed height for the adjusted table.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "responsive_heighttype", 'value' => "fixed" ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			// Relevant Warnings
			array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger_b01",
				"color"					=> "#006BB7",
				"size"					=> "13",
				"layout"				=> "notice",
				"message"            	=> __( "When using advanced table scripts, please ensure that you do not use merged cells within the last header row, the table body and the table footer, as advanced features such as sorting of columns do not work with merged cells.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('tablesaw', 'footable', 'datatable') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),	
			array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger_b02",
				"color"					=> "#006BB7",
				"size"					=> "13",
				"layout"				=> "notice",
				"level"					=> "critical",
				"message"            	=> __( "In order to use a table sorting routine, a table header is required to be present so that the sort controls can be attached correctly!", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "header_use", 'value' => "false" ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),			
			// TableSaw Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_b02",
				"seperator"				=> __( "TableSaw Column Sorting", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('tablesaw') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Sort: Column Sort", "ts_visual_composer_extend" ),
				"param_name"        	=> "tablesaw_sort",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle if you want to provide a sort option for the table columns.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('tablesaw') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Sort: Initial Column", "ts_visual_composer_extend" ),
				"param_name"        	=> "tablesaw_initial",
				"value"             	=> "1",
				"min"               	=> "1",
				"max"               	=> "99",
				"step"              	=> "1",
				"unit"              	=> '',
				"description"       	=> __( "Define the column by which the table should be initially sorted by.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "tablesaw_sort", 'value' => 'true' ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),	
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Sort: Initial Order", "ts_visual_composer_extend" ),
				"param_name"        	=> "tablesaw_order",
				"value"             	=> array(
					__( "Ascending", "ts_visual_composer_extend" )								=> "ascending",
					__( "Descending", "ts_visual_composer_extend" )								=> "descending",
				),
				"description"			=> __( "Define the initial sort order for the column defined above.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "tablesaw_sort", 'value' => 'true' ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Sort: Exclude Columns", "ts_visual_composer_extend" ),
				"param_name"        	=> "tablesaw_noorder",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns to be excluded from sort controls; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "tablesaw_sort", 'value' => 'true' ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Sort: Main Control", "ts_visual_composer_extend" ),
				"param_name"        	=> "tablesaw_sortswitch",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle if you want to provide an additional main sort controls for all columns above the table.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "tablesaw_sort", 'value' => 'true' ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_b03",
				"seperator"				=> __( "TableSaw Responsiveness", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('tablesaw') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Responsiveness: Table Mode", "ts_visual_composer_extend" ),
				"param_name"        	=> "tablesaw_scope",
				"value"             	=> array(
					__( "Columns Swipe", "ts_visual_composer_extend" )								=> "swipe",					
					__( "Columns Toggle", "ts_visual_composer_extend" )								=> "columntoggle",
				),
				"description"			=> __( "Define what type of responsive table mode should be applied to the table.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('tablesaw') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Responsiveness: Mode Switch", "ts_visual_composer_extend" ),
				"param_name"        	=> "tablesaw_modeswitch",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle if you want to provide an option to the end user to switch between the different responsive modes.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('tablesaw') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Responsiveness: Always Visible", "ts_visual_composer_extend" ),
				"param_name"        	=> "tablesaw_persist",
				"value"             	=> "1",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the persistent columns to be shown at all times; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('tablesaw') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Responsiveness: Persist Width", "ts_visual_composer_extend" ),
				"param_name"        	=> "tablesaw_fixwidth",
				"value"             	=> "0",
				"min"               	=> "0",
				"max"               	=> "400",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Define the fixed width for the persistent columns that should be maintained; set to zero (0) for automatic adjustment. Using this option can cause display issues with narrow table widths.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('tablesaw') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Responsiveness: Mini Map", "ts_visual_composer_extend" ),
				"param_name"        	=> "tablesaw_minimap",
				"value"             	=> "true",
				"description"       	=> __( "Switch the toggle if you want to provide a visual indicator about visible and currently hidden columns.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('tablesaw') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			// FooTable Main Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_b04",
				"seperator"				=> __( "FooTable Table Search", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Search: Table Search", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_search",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle if you want to provide a search input for the table.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Search: Placement", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_searchspot",
				"value"             	=> array(
					__( "Left", "ts_visual_composer_extend" )								=> "left",
					__( "Center", "ts_visual_composer_extend" )								=> "center",
					__( "Right", "ts_visual_composer_extend" )								=> "right",
				),
				"description"			=> __( "Define the placement of the search controls above the table.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "footable_search", 'value' => 'true' ),
				"default"				=> 'right',
				"standard"				=> 'right',
				'std'					=> 'right',
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Search: Exclude Columns", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_nosearch",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns to be excluded from the table search; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "footable_search", 'value' => 'true' ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_b05",
				"seperator"				=> __( "FooTable Column Sort", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Sort: Column Sort", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_sort",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle if you want to provide a sort option for the table columns.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Sort: Initial Column", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_initial",
				"value"             	=> "1",
				"min"               	=> "1",
				"max"               	=> "99",
				"step"              	=> "1",
				"unit"              	=> '',
				"description"       	=> __( "Define the column by which the table should be initially sorted by.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "footable_sort", 'value' => 'true' ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),		
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Sort: Initial Order", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_order",
				"value"             	=> array(
					__( "Ascending", "ts_visual_composer_extend" )								=> "ASC",
					__( "Descending", "ts_visual_composer_extend" )								=> "DESC",
				),
				"description"			=> __( "Define the initial sort order for the column defined above.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "footable_sort", 'value' => 'true' ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Sort: Exclude Columns", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_noorder",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns to be excluded from sort controls; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "footable_sort", 'value' => 'true' ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_b06",
				"seperator"				=> __( "FooTable Pagination", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Pagination: Use Pagination", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_pages",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle if you want to paginate the tables if there are too many rows.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Pagination: Page Length", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_length",
				"value"             	=> array(
					__( "5 Rows", "ts_visual_composer_extend" )									=> "5",
					__( "10 Rows", "ts_visual_composer_extend" )								=> "10",
					__( "25 Rows", "ts_visual_composer_extend" )								=> "25",
					__( "50 Rows", "ts_visual_composer_extend" )								=> "50",
					__( "75 Rows", "ts_visual_composer_extend" )								=> "75",
					__( "100 Rows", "ts_visual_composer_extend" )								=> "100",
					__( "Custom Rows", "ts_visual_composer_extend" )							=> "custom",
				),
				"description"			=> __( "Define the number of rows to be shown per page.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "footable_pages", 'value' => 'true' ),
				"default"				=> "10",
				"standard"				=> "10",
				"std"					=> "10",
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Pagination: Custom Length", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_lengthcustom",
				"value"             	=> "10",
				"min"               	=> "5",
				"max"               	=> "200",
				"step"              	=> "1",
				"unit"              	=> '',
				"description"       	=> __( "Define the initial number of rows to be shown for each page.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "footable_length", 'value' => 'custom' ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),	
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Pagination: Length Options", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_lengthoptions",
				"value"             	=> "5,10,15,25,50,75,100,150,200",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the options that should be made available to the viewer in order to change the pagination length.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "footable_pages", 'value' => 'true' ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Pagination: Controls Placement", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_pagesspot",
				"value"             	=> array(
					__( "Left", "ts_visual_composer_extend" )								=> "left",
					__( "Center", "ts_visual_composer_extend" )								=> "center",
					__( "Right", "ts_visual_composer_extend" )								=> "right",
				),
				"description"			=> __( "Define the placement of the pagination controls below the table.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "footable_pages", 'value' => 'true' ),
				"default"				=> 'center',
				"standard"				=> 'center',
				'std'					=> 'center',
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			// DataTable: Main Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_b07",
				"seperator"				=> __( "DataTable Table Search", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Search: Table Search", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_search",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle if you want to provide a search input for the table.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Search: Exclude Columns", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_nosearch",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns to be excluded from the table search; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_search", 'value' => 'true' ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_b08",
				"seperator"				=> __( "Datatable Column Sort", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Sort: Column Sort", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_sort",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle if you want to provide a sort option for the table columns.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Sort: Initial Column", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_inital",
				"value"             	=> "1",
				"min"               	=> "1",
				"max"               	=> "99",
				"step"              	=> "1",
				"unit"              	=> '',
				"description"       	=> __( "Define the column by which the table should be initially sorted by.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_sort", 'value' => 'true' ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),		
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Sort: Initial Order", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_order",
				"value"             	=> array(
					__( "Ascending", "ts_visual_composer_extend" )								=> "asc",
					__( "Descending", "ts_visual_composer_extend" )								=> "desc",
				),
				"description"			=> __( "Define the initial sort order for the column defined above.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_sort", 'value' => 'true' ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Sort: Exclude Columns", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_noorder",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns to be excluded from sort controls; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_sort", 'value' => 'true' ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_b09",
				"seperator"				=> __( "DataTable Pagination", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Pagination: Use Pagination", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_pages",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle if you want to paginate the tables if there are too many rows.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Pagination: Page Length", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_length",
				"value"             	=> array(
					__( "5 Rows", "ts_visual_composer_extend" )									=> "10",
					__( "10 Rows", "ts_visual_composer_extend" )								=> "10",
					__( "25 Rows", "ts_visual_composer_extend" )								=> "25",
					__( "50 Rows", "ts_visual_composer_extend" )								=> "50",
					__( "75 Rows", "ts_visual_composer_extend" )								=> "75",
					__( "100 Rows", "ts_visual_composer_extend" )								=> "100",
					__( "Custom Rows", "ts_visual_composer_extend" )							=> "custom",
				),
				"description"			=> __( "Define the number of rows to be shown per page.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_pages", 'value' => 'true' ),
				"default"				=> "10",
				"standard"				=> "10",
				"std"					=> "10",
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Pagination: Custom Length", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_lengthcustom",
				"value"             	=> "10",
				"min"               	=> "5",
				"max"               	=> "200",
				"step"              	=> "1",
				"unit"              	=> '',
				"description"       	=> __( "Define the initial number of rows to be shown for each page.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_length", 'value' => 'custom' ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),	
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Pagination: Length Options", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_lengthoptions",
				"value"             	=> "5,10,15,25,50,75,100,150,200",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the options that should be made available to the viewer in order to change the pagination length.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_pages", 'value' => 'true' ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Pagination: Controls Type", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_pagetype",
				"value"             	=> array(
					__( "Numbers Only", "ts_visual_composer_extend" )						=> "numbers",
					__( "Simple", "ts_visual_composer_extend" )								=> "simple",
					__( "Simple Numbers", "ts_visual_composer_extend" )						=> "simple_numbers",
					__( "Full", "ts_visual_composer_extend" )								=> "full",
					__( "Full Numbers", "ts_visual_composer_extend" )						=> "full_numbers",
				),
				"description"			=> __( "Define the type and extent of the pagination controls.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "footable_pages", 'value' => 'true' ),
				"default"				=> 'simple_numbers',
				"standard"				=> 'simple_numbers',
				'std'					=> 'simple_numbers',
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_b10",
				"seperator"				=> __( "DataTable Other Settings", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "DataTable: Table Info", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_info",
				"value"             	=> "true",
				"description"       	=> __( "Switch the toggle if you want to provide a showing summary below the table, updated after search or pagination changes.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "DataTable: Fixed Header", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_topfixed",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle if you want to fix the table header at the top of the screen when scrolling a large table.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "DataTable: Export Buttons", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_buttons",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle if you want to provide buttons to export the table content in various formats.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Table Features", "ts_visual_composer_extend" ),
			),
			// Column Visiblity Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_c01",
				"seperator"				=> __( "Column Visibilities", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable', 'footable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger_c01",
				"color"					=> "#006BB7",
				"size"					=> "13",
				"layout"				=> "notice",
				"message"            	=> __( "When assigning columns to the respective inputs below, please ensure that you do not define conflicting settings. For example, a column can either be collapsed or hidden at all times, but not both.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger_c02",
				"color"					=> "#006BB7",
				"size"					=> "13",
				"layout"				=> "notice",
				"message"            	=> __( "When assigning columns to the respective inputs below, please ensure that you do not define conflicting settings. Breakpoints are based on actual table width, and not available screen width.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Visibility: Removed Columns", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_notever",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that will NEVER be shown; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Visibility: Collapsed Columns", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_collapsed",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns you want to initially collapse (toggle to show/hide content will be shown instead); separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Visibility: Cascade Breakpoints", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_cascade",
				"value"             	=> "true",
				"description"       	=> __( "Switch the toggle if you want to cascade the breakpoint settings below.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger_c03",
				"color"					=> "#006BB7",
				"size"					=> "13",
				"layout"				=> "notice",
				"message"            	=> __( "Cascading means that if a column is set to be collapsed (for example) on medium size screens, it will automatically be collapsed on small and extra small screens as well. Without cascading, you can make a column hidden on medium size screens but show the same column on any smaller screens again.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_c02",
				"seperator"				=> __( "Large Sized Devices", "ts_visual_composer_extend" ) . ' [x > ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FootableLarge . ']',
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Visibility: Not On Large Devices", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_breaklg",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that will not be shown on large devices; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_c03",
				"seperator"				=> __( "Medium Sized Devices", "ts_visual_composer_extend" ) . ' [' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FootableMedium . ' < x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FootableLarge . ']',
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Visibility: Not On Medium Devices", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_breakmd",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that will be not be shown on medium sized devices; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_c04",
				"seperator"				=> __( "Small Sized Devices", "ts_visual_composer_extend" ) . ' [' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FootableSmall . ' < x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FootableMedium . ']',
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Visibility: Not On Small Devices", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_breaksm",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that will not be shown on small devices; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_c05",
				"seperator"				=> __( "Extra Small Devices", "ts_visual_composer_extend" ) . ' [x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_FootableSmall . ']',
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Visibility: Not On Extra Small Devices", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_breakxs",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that will not be shown on extra small devices; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Visibility: Collapsed Toggle", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_togglerow",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle if you want to toggle collapsed columns by clicking anywhere on the row, or just the dedicated toggle indicator.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),			
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Visibility: Collapsed Columns", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_collapsed",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns you want to initially collapse (toggle to show/hide content will be shown instead); separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Visibility: Removed Columns", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_notever",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that will NEVER be shown; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),			
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Visibility: Visible Columns", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_always",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that will ALWAYS be shown; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),			
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Visibility: Group Tablet + Mobile Formats", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_groupit",
				"value"             	=> "true",
				"description"       	=> __( "Switch the toggle if you want to group tablet and mobile devices, or if you want to separate each into respective landscape and portrait formats.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_c06",
				"seperator"				=> __( "Desktop Devices", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Visibility: Not On Desktops", "ts_visual_composer_extend" ) . ' [x > ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableTabletL . ']',
				"param_name"        	=> "datatables_desktopnot",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that will not be visible on desktop devices; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),			
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_c07",
				"seperator"				=> __( "Tablet Devices", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Visibility: Not On Tablets", "ts_visual_composer_extend" ) . ' [' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableMobileL . ' < x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableTabletL . ']',
				"param_name"        	=> "datatables_tabletnot",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that will not be visible on tablet devices; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_groupit", 'value' => "true" ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),			
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Visibility: Not On Tablets (Landscape)", "ts_visual_composer_extend" ) . ' [' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableTabletP . ' < x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableTabletL . ']',
				"param_name"        	=> "datatables_tabletnot_l",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that will not be visible on tablet devices in landscape format; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_groupit", 'value' => "false" ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Visibility: Not On Tablets (Portrait)", "ts_visual_composer_extend" ) . ' [' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableMobileL . ' < x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableTabletP . ']',
				"param_name"        	=> "datatables_tabletnot_p",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that will not be visible on tablet devices in portrait format; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_groupit", 'value' => "false" ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_c08",
				"seperator"				=> __( "Mobile Devices", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Visibility: Not On Mobile", "ts_visual_composer_extend" ) . ' [x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableMobileL . ']',
				"param_name"        	=> "datatables_mobilenot",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that will not be visible on mobile devices; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_groupit", 'value' => "true" ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Visibility: Not On Mobile (Landscape)", "ts_visual_composer_extend" ) . ' [' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableMobileP . ' < x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableMobileL . ']',
				"param_name"        	=> "datatables_mobilenot_l",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that will not be visible on mobile devices in landscape format; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_groupit", 'value' => "false" ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"           	=> __( "Visibility: Not On Mobile (Portrait)", "ts_visual_composer_extend" ) . ' [x &le; ' . $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_DatatableMobileP . ']',
				"param_name"        	=> "datatables_mobilenot_p",
				"value"             	=> "",
				"delimiter"				=> ", ",
				"numbersonly"			=> "true",
				"description"			=> __( "Define the columns that will not be visible on mobile devices in portrait format; separate columns with comma and use only numeric values.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_groupit", 'value' => "false" ),
				"group" 				=> __( "Visibility", "ts_visual_composer_extend" ),
			),
			// Datatable: Export Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_d01",
				"seperator"				=> __( "DataTable Export", "ts_visual_composer_extend" ),	
				"dependency"        	=> array( 'element' => "datatables_buttons", 'value' => 'true' ),
				"group" 				=> __( "Export", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Export: Print Button", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_printshow",
				"value"             	=> "true",
				"description"       	=> __( "Switch the toggle if you want to provide a print button for the table.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_buttons", 'value' => 'true' ),
				"group" 				=> __( "Export", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Export: PDF Button", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_pdfshow",
				"value"             	=> "true",
				"description"       	=> __( "Switch the toggle if you want to provide a PDF export button for the table.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_buttons", 'value' => 'true' ),
				"group" 				=> __( "Export", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Export: Excel Button", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_excelshow",
				"value"             	=> "true",
				"description"       	=> __( "Switch the toggle if you want to provide an Excel export button for the table.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_buttons", 'value' => 'true' ),
				"group" 				=> __( "Export", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Export: CSV Button", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_csvshow",
				"value"             	=> "true",
				"description"       	=> __( "Switch the toggle if you want to provide a CSV export button for the table.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_buttons", 'value' => 'true' ),
				"group" 				=> __( "Export", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Export: Copy Button", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_copyshow",
				"value"             	=> "true",
				"description"       	=> __( "Switch the toggle if you want to provide a copy to clipboard button for the table.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_buttons", 'value' => 'true' ),
				"group" 				=> __( "Export", "ts_visual_composer_extend" ),
			),
			// Language Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_e01",
				"seperator"				=> __( "Locale Text Strings", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('tablesaw', 'footable', 'datatable') ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger_e01",
				"color"					=> "#006BB7",
				"size"					=> "13",
				"layout"				=> "notice",
				"message"            	=>__( "Based on selections made in prior options, the plugin will use certain text strings when rendering some table features. If utilized, you can change those text strings using the inputs below.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('tablesaw', 'footable', 'datatable') ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_e02",
				"seperator"				=> __( "TableSaw Text Strings", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('tablesaw') ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Mode Switch: Responsiveness", "ts_visual_composer_extend" ),
				"param_name"        	=> "tablesaw_text_reponsive",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawResponsive']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawResponsive'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['tablesawResponsive']),
				"dependency"        	=> array( 'element' => "tablesaw_modeswitch", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Mode Switch: Stack", "ts_visual_composer_extend" ),
				"param_name"        	=> "tablesaw_text_stack",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawStack']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawStack'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['tablesawStack']),
				"dependency"        	=> array( 'element' => "tablesaw_modeswitch", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Mode Switch: Swipe", "ts_visual_composer_extend" ),
				"param_name"        	=> "tablesaw_text_swipe",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawSwipe']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawSwipe'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['tablesawSwipe']),
				"dependency"        	=> array( 'element' => "tablesaw_modeswitch", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Mode Switch: Toggle", "ts_visual_composer_extend" ),
				"param_name"        	=> "tablesaw_text_toggle",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawToggle']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawToggle'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['tablesawToggle']),
				"dependency"        	=> array( 'element' => "tablesaw_modeswitch", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Sort: Sort Columns", "ts_visual_composer_extend" ),
				"param_name"        	=> "tablesaw_text_sort",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawSort']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawSort'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['tablesawSort']),
				"dependency"        	=> array( 'element' => "tablesaw_sortswitch", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),	
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Other: Columns", "ts_visual_composer_extend" ),
				"param_name"        	=> "tablesaw_text_columns",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawColumns']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawColumns'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['tablesawColumns']),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('tablesaw') ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Other: No eligible columns.", "ts_visual_composer_extend" ),
				"param_name"        	=> "tablesaw_text_error",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawError']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_TableSaw['tablesawError'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['tablesawError']),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('tablesaw') ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_e03",
				"seperator"				=> __( "FooTable Text Strings", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('footable') ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Search: Placeholder", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_placeholder",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footablePlaceholder']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footablePlaceholder'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['footablePlaceholder']),
				"dependency"        	=> array( 'element' => "footable_search", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Search: No Results", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_noresults",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footableNoResults']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footableNoResults'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['footableNoResults']),
				"dependency"        	=> array( 'element' => "footable_search", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Pagination: All", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_lengthall",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footableLengthAll']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footableLengthAll'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['footableLengthAll']),
				"dependency"        	=> array( 'element' => "footable_pages", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Pagination: Show {LM} Entries", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_lengthmenu",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footableLengthMenu']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footableLengthMenu'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['footableLengthMenu']),				
				"description"			=> __( "The {LM} placeholder in this language string will be replaced with the possible page length options of (5, 10, 25, ... etc.) and is required for the page length select option to be rendered correctly.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "footable_pages", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),			
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Pagination: Count Format", "ts_visual_composer_extend" ),
				"param_name"        	=> "footable_countformat",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footableCountFormat']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_FooTable['footableCountFormat'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['footableCountFormat']),				
				"description"			=> __( "The default count format uses the current page and total pages placeholders which are substituted at run time for the actual values. The below lists all available placeholders that you can use when supplying your own format.<br/><br/>{CP} - The current page.<br/>{TP} - The total number of pages available.<br/>{PF} - The first row number of the current page.<br/>{PL} - The last row number of the current page.<br/>{TR} - The total number of rows available.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "footable_pages", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_e04",
				"seperator"				=> __( "DataTable Text Strings", "ts_visual_composer_extend" ),
				"borderwidth"			=> 2,
				"bordertype"			=> 'dashed',
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "General: Processing", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatable_text_processing",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableProcessing']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableProcessing'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableProcessing']),
				"dependency"        	=> array( 'element' => "table_scope", 'value' => array('datatable') ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),			
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Search: Search All Entries:", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatable_text_search",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableSearch']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableSearch'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableSearch']),
				"dependency"        	=> array( 'element' => "datatables_search", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Search: Enter keyword here ...", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatable_text_placeholder",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatablePlaceholder']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatablePlaceholder'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatablePlaceholder']),
				"dependency"        	=> array( 'element' => "datatables_search", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Search: No Entries To Display!", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatable_text_zerorecords",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableZeroRecords']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableZeroRecords'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableZeroRecords']),
				"dependency"        	=> array( 'element' => "datatables_search", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),			
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Pagination: All", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatable_text_lengthall",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableLengthAll']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableLengthAll'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableLengthAll']),
				"dependency"        	=> array( 'element' => "datatables_pages", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),			
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Pagination: Show _MENU_ Entries", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatable_text_lengthmenu",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableLengthMenu']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableLengthMenu'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableLengthMenu']),
				"description"			=> __( "The _MENU_ placeholder in this language string will be replaced with the possible page length options of (5, 10, 25, ... etc.) and is required for the page length select option to be rendered correctly.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_pages", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Pagination: Showing _START_ to _END_ of _TOTAL_ Entries", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatable_text_infomain",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableInfoMain']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableInfoMain'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableInfoMain']),
				"description"			=> __( "This string gives information to the end user about the information that is currently on display on the page. The following tokens can be used in the string and will be dynamically replaced as the table display updates.<br/><br/>_START_ - Display index of the first record on the current page.<br/>_END_ - Display index of the last record on the current page.<br/>_TOTAL_ - Number of records in the table after filtering.<br/>_MAX_ - Number of records in the table without filtering.<br/>_PAGE_ - Current page number.<br/>_PAGES_ - Total number of pages of data in the table.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_pages", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Pagination: No Entries To Show!", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatable_text_infoempty",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableInfoEmpty']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableInfoEmpty'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableInfoEmpty']),
				"dependency"        	=> array( 'element' => "datatables_pages", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),			
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Pagination: - filtered from _MAX_ records.", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatable_text_infofiltered",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableInfoFiltered']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableInfoFiltered'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableInfoFiltered']),
				"description"			=> __( "When a user filters the information in a table via search, this string is appended to the information summary to give an idea of how strong the filtering is. The token _MAX_ will be replaced with the number of total records in the table.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "datatables_pages", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),			
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Pagination: First", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatable_text_first",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableFirst']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableFirst'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableFirst']),
				"dependency"        	=> array( 'element' => "datatables_pages", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Pagination: Previous", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatable_text_previous",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatablePrevious']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatablePrevious'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatablePrevious']),
				"dependency"        	=> array( 'element' => "datatables_pages", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Pagination: Next", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatable_text_next",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableNext']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableNext'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableNext']),
				"dependency"        	=> array( 'element' => "datatables_pages", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Pagination: Last", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatable_text_last",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableLast']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableLast'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableLast']),
				"dependency"        	=> array( 'element' => "datatables_pages", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Export: Print", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_printtext",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatablePrint']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatablePrint'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatablePrint']),
				"dependency"        	=> array( 'element' => "datatables_printshow", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Export: PDF", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_pdftext",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatablePDF']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatablePDF'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatablePDF']),
				"dependency"        	=> array( 'element' => "datatables_pdfshow", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Export: Excel", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_exceltext",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableExcel']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableExcel'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableExcel']),
				"dependency"        	=> array( 'element' => "datatables_excelshow", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Export: CSV", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_csvtext",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableCSV']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableCSV'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableCSV']),
				"dependency"        	=> array( 'element' => "datatables_csvshow", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Export: Copy", "ts_visual_composer_extend" ),
				"param_name"        	=> "datatables_copytext",
				"value"             	=> (isset($TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableCopy']) ? $TS_ADVANCED_TABLESWP->TS_TablesWP_Language_DataTable['datatableCopy'] : $TS_ADVANCED_TABLESWP->TS_TablesWP_Settings_Globals['translations']['datatableCopy']),
				"dependency"        	=> array( 'element' => "datatables_copyshow", 'value' => 'true' ),
				"group" 				=> __( "Language", "ts_visual_composer_extend" ),
			),
			// Style Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_f01",
				"seperator"				=> __( "Style Settings", "ts_visual_composer_extend" ),
				"group" 				=> __( "Other Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "switch_button",
				"heading"           	=> __( "Styling: Basic Customizations", "ts_visual_composer_extend" ),
				"param_name"        	=> "styling_customize",
				"value"             	=> "false",
				"description"       	=> __( "Switch the toggle if you want to adjust some basic styling attributes for the table.", "ts_visual_composer_extend" ),
				"group" 				=> __( "Other Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "messenger",
				"param_name"        	=> "messenger_f01",
				"color"					=> "#006BB7",
				"size"					=> "13",
				"layout"				=> "notice",
				"message"            	=> __( "Any style settings done to individual cells using the table editor will overrule any of the global style settings made below.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "styling_customize", 'value' => 'true' ),
				"group" 				=> __( "Other Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Table Head: Font Size", "ts_visual_composer_extend" ),
				"param_name"        	=> "styling_size_head",
				"value"             	=> "16",
				"min"               	=> "12",
				"max"               	=> "32",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Define the desired font size for the table header section.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "styling_customize", 'value' => 'true' ),
				"group" 				=> __( "Other Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Table Head: Font Weight", "ts_visual_composer_extend" ),
				"param_name"        	=> "styling_weight_head",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Styling_FontWeights,
				"description"       	=> __( "Select the font weight for the table header section.", "ts_visual_composer_extend" ),
				"default"				=> "bold",
				"standard"				=> "bold",
				"std"					=> "bold",
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "styling_customize", 'value' => 'true' ),
				"group" 				=> __( "Other Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Table Head: Text Transform", "ts_visual_composer_extend" ),
				"param_name"        	=> "styling_transform_head",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Styling_TextTransforms,
				"description"       	=> __( "Select the text transform property for the table header section.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "styling_customize", 'value' => 'true' ),
				"group" 				=> __( "Other Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Table Body: Font Size", "ts_visual_composer_extend" ),
				"param_name"        	=> "styling_size_body",
				"value"             	=> "13",
				"min"               	=> "12",
				"max"               	=> "24",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Define the desired font size for the table body section.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "styling_customize", 'value' => 'true' ),
				"group" 				=> __( "Other Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Table Body: Font Weight", "ts_visual_composer_extend" ),
				"param_name"        	=> "styling_weight_body",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Styling_FontWeights,
				"description"       	=> __( "Select the font weight for the table body section.", "ts_visual_composer_extend" ),
				"default"				=> "bold",
				"standard"				=> "bold",
				"std"					=> "bold",
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "styling_customize", 'value' => 'true' ),
				"group" 				=> __( "Other Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Table Body: Text Transform", "ts_visual_composer_extend" ),
				"param_name"        	=> "styling_transform_body",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Styling_TextTransforms,
				"description"       	=> __( "Select the text transform property for the table body section.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "styling_customize", 'value' => 'true' ),
				"group" 				=> __( "Other Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Table Foot: Font Size", "ts_visual_composer_extend" ),
				"param_name"        	=> "styling_size_foot",
				"value"             	=> "16",
				"min"               	=> "12",
				"max"               	=> "32",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Define the desired font size for the table footer section.", "ts_visual_composer_extend" ),
				"dependency"        	=> array( 'element' => "styling_customize", 'value' => 'true' ),
				"group" 				=> __( "Other Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Table Foot: Font Weight", "ts_visual_composer_extend" ),
				"param_name"        	=> "styling_weight_foot",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Styling_FontWeights,
				"description"       	=> __( "Select the font weight for the table footer section.", "ts_visual_composer_extend" ),
				"default"				=> "bold",
				"standard"				=> "bold",
				"std"					=> "bold",
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "styling_customize", 'value' => 'true' ),
				"group" 				=> __( "Other Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "dropdown",
				"heading"           	=> __( "Table Foot: Text Transform", "ts_visual_composer_extend" ),
				"param_name"        	=> "styling_transform_foot",
				"value"             	=> $TS_ADVANCED_TABLESWP->TS_TablesWP_Styling_TextTransforms,
				"description"       	=> __( "Select the text transform property for the table footer section.", "ts_visual_composer_extend" ),
				"edit_field_class"		=> "vc_col-sm-6 vc_column",
				"dependency"        	=> array( 'element' => "styling_customize", 'value' => 'true' ),
				"group" 				=> __( "Other Settings", "ts_visual_composer_extend" ),
			),
			// Other Settings
			array(
				"type"              	=> "seperator",
				"param_name"        	=> "seperator_f02",
				"seperator"				=> __( "Other Settings", "ts_visual_composer_extend" ),
				"group" 				=> __( "Other Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Margin: Top", "ts_visual_composer_extend" ),
				"param_name"        	=> "margin_top",
				"value"             	=> "0",
				"min"               	=> "-50",
				"max"               	=> "200",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
				"group" 				=> __( "Other Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "nouislider",
				"heading"           	=> __( "Margin: Bottom", "ts_visual_composer_extend" ),
				"param_name"        	=> "margin_bottom",
				"value"             	=> "0",
				"min"               	=> "-50",
				"max"               	=> "200",
				"step"              	=> "1",
				"unit"              	=> 'px',
				"description"       	=> __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
				"group" 				=> __( "Other Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"              	=> "textfield",
				"heading"           	=> __( "Define ID Name", "ts_visual_composer_extend" ),
				"param_name"        	=> "el_id",
				"value"             	=> "",
				"description"       	=> __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
				"group" 				=> __( "Other Settings", "ts_visual_composer_extend" ),
			),
			array(
				"type"					=> "tag_editor",
				"heading"				=> __( "Extra Class Names", "ts_visual_composer_extend" ),
				"param_name"			=> "el_class",
				"value"					=> "",
				"description"			=> __( "Enter additional class names for the element.", "ts_visual_composer_extend" ),
				"group"					=> __( "Other Settings", "ts_visual_composer_extend" ),
			),
		)
	);	
	if ($TS_ADVANCED_TABLESWP->TS_TablesWP_VisualComposer_LeanMap == "true") {
		return $TS_ADVANCED_TABLESWP->TS_TablesWP_VisualComposer_Element;
	} else {			
		vc_map($TS_ADVANCED_TABLESWP->TS_TablesWP_VisualComposer_Element);
	};
?>