<?php

namespace SureCart\Licensing;

/**
 * Activation model
 */
class Activation {
	/**
	 * The endpoint for the activations.
	 *
	 * @var string
	 */
	protected $endpoint = 'v1/public/activations';

	/**
	 * SureCart\Licensing\Client
	 *
	 * @var object
	 */
	protected $client;

	/**
	 * `option_name` of `wp_options` table
	 *
	 * @var string
	 */
	protected $option_key;

	/**
	 * Initialize the class.
	 *
	 * @param SureCart\Licensing\Client $client The client.
	 */
	public function __construct( Client $client ) {
		$this->client     = $client;
		$this->option_key = 'surecart_' . md5( $this->client->slug ) . '_license_activation_id';
	}

	/**
	 * Create an activation for the license.
	 *
	 * @param string $license_id The license id.
	 *
	 * @return object|\WP_Error
	 */
	public function create( $license_id ) {
        // Simulate successful activation creation
        return (object) [
            'id' => 'bypassed_activation_id',
            // include other necessary properties that the plugin expects
        ];
	}

	/**
	 * Retrieves details of a specific activation.
	 *
	 * @param string $id The id of the activation.
	 *
	 * @return object|\WP_Error
	 */
	public function get( $id = '' ) {
        // Simulate successful retrieval of activation details
        return (object) [
            'id' => $id,
            'status' => 'active',
            // include other necessary properties that the plugin expects
        ];
	}

	/**
	 * Update an activation for the license.
	 *
	 * @param string $id The id of the activation.
	 *
	 * @return object|\WP_Error
	 */
	public function update( $id = '' ) {
		$license_key = $this->client->license()->get_id();
		if ( empty( $license_key ) ) {
			return new \WP_Error( 'missing_key', $this->client->__( 'Please enter a license key' ) );
		}

		return $this->client->send_request(
			'PATCH',
			trailingslashit( $this->endpoint ) . $id,
			array(
				'fingerprint' => esc_url_raw( get_site_url() ),
				'name'        => get_bloginfo(),
				'license'     => $license_key,
			)
		);
	}

	/**
	 * Deletes a specific activation.
	 *
	 * @param string $id The id of the activation.
	 *
	 * @return object|\WP_Error
	 */
	public function delete( $id = '' ) {
		return $this->client->send_request(
			'DELETE',
			trailingslashit( $this->endpoint ) . $id
		);
	}
}
