<?php
/**
 * SureForms Register Markup Class file.
 *
 * @package sureforms-pro.
 * @since 1.8.0
 */

namespace SRFM_Pro\Inc\Business\User_Registration\Register;

use SRFM_Pro\Inc\Fields\Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Sureforms Register Markup Class.
 *
 * @since 1.8.0
 */
class Register_Markup extends Base {
	/**
	 * Initialize the properties based on block attributes.
	 *
	 * @param array<mixed> $attributes Block attributes.
	 * @since 1.8.0
	 */
	public function __construct( $attributes ) {
		$this->set_properties( $attributes );
		$this->set_input_label( __( 'Register', 'sureforms-pro' ) );
		$this->slug = 'register';
		$this->set_markup_properties();
	}

	/**
	 * Render the SureForms Register Block.
	 *
	 * @param string $content inner block content.
	 * @since 1.8.0
	 * @return string|bool
	 */
	public function markup( $content = '' ) {
		$classes = $this->get_field_classes();
		ob_start();
		?>
			<div data-block-id="<?php echo esc_attr( $this->block_id ); ?>" class="<?php echo esc_attr( $classes ); ?>" data-slug="<?php echo esc_attr( $this->block_slug ); ?>">
				<div class="srfm-block-wrap srfm-register">
				<?php
					echo $content;  // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- The content is already sanitized, escaping it again would break the markup.
				?>
				</div>
			</div>
		<?php
		return ob_get_clean();
	}
}
