<?php
/**
 * SureForms Link Markup Class file.
 *
 * @package sureforms-pro.
 * @since 1.8.0
 */

namespace SRFM_Pro\Inc\Business\User_Registration\Link;

use SRFM\Inc\Helper;
use SRFM_Pro\Inc\Fields\Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * SureForms Link Markup Class.
 *
 * @since 1.8.0
 */
class Link_Markup extends Base {
	/**
	 * Prefix Text.
	 *
	 * @var string
	 * @since 1.8.0
	 */
	protected $prefix_text = '';

	/**
	 * Suffix Text.
	 *
	 * @var string
	 * @since 1.8.0
	 */
	protected $suffix_text = '';

	/**
	 * Hyperlink Text.
	 *
	 * @var string
	 * @since 1.8.0
	 */
	protected $hyperlink_text = '';

	/**
	 * Hyperlink URL.
	 *
	 * @var string
	 * @since 1.8.0
	 */
	protected $hyperlink_url = '';

	/**
	 * Text Alignment.
	 *
	 * @var string
	 * @since 1.8.0
	 */
	protected $text_alignment = 'left';

	/**
	 * Initialize the properties based on block attributes.
	 *
	 * @param array<mixed> $attributes Block attributes.
	 * @since 1.8.0
	 */
	public function __construct( $attributes ) {
		$this->set_properties( $attributes );
		$this->slug = 'link';
		$this->set_markup_properties();

		// Link Block Properties.
		$this->prefix_text    = $attributes['prefixText'] ?? '';
		$this->suffix_text    = $attributes['suffixText'] ?? '';
		$this->hyperlink_text = $attributes['hyperlinkText'] ?? '';
		$this->hyperlink_url  = $attributes['hyperlinkURL'] ?? '';
		$this->text_alignment = $attributes['textAlignment'] ?? 'left';
	}

	/**
	 * Render the sureforms link markup.
	 *
	 * @since 1.8.0
	 * @return string|bool
	 */
	public function markup() {
		$classes = [
			'srfm-block',
			"srfm-{$this->slug}-block-wrap",
			$this->block_width,
		];
		ob_start(); ?>
			<div data-block-id="<?php echo esc_attr( $this->block_id ); ?>" class="<?php echo esc_attr( Helper::join_strings( $classes ) ); ?>">
				<div class="srfm-block-wrap srfm-<?php echo esc_attr( $this->text_alignment ); ?>-content">
					<p class="srfm-link-wrap">
						<span class="srfm-link-text"><?php echo esc_html( $this->prefix_text ); ?></span>
						<a href="<?php echo esc_attr( $this->hyperlink_url ); ?>"><?php echo esc_html( $this->hyperlink_text ); ?></a>
						<span class="srfm-link-text"><?php echo esc_html( $this->suffix_text ); ?></span>
					</p>
				</div>
				<div class="srfm-error-wrap"></div>
			</div>
		<?php
		return ob_get_clean();
	}
}
