(function($) { // Hide scope, no $ conflict

    // Init WP Image Browser
    SUPER.init_image_browser = function(){

        var $doc = $(document);
        $doc.find('.browse-images:not(.initialized), .browse-files:not(.initialized)').each(function () {
            var $editing = $('.super-preview-elements .super-element.editing');
            var $this = $(this);

            $this.addClass('initialized');
            var $title = 'Select an Image';
            var $btn_name = 'Add Image';
            var $file_type = '';
            if(typeof $this.data('file-type') !== 'undefined'){
                var $file_type = $this.data('file-type');
            }
            var $multiple = '';
            if(typeof $this.data('multiple') !== 'undefined'){
                var $multiple = $this.data('multiple');
            }

            var $button = $this.children('.button');
            var $preview = $this.children('.image-preview');
            var $field = $this.children('input');
            var $frame;
            var $id = $field.val();
            if($this.hasClass('browse-files')){
                $title = 'Select an File';
                $btn_name = 'Add File';
                $preview = $this.children('.file-preview');
            }
            
            $preview.on('click', 'a.delete', function () {
                var $this = $(this);
                var $index = $this.parents('.super-multi-items:eq(0)').index()-1;
                var $item = $editing.find('.super-field-wrapper').children('label:eq('+($index)+')');
                var $value = $item.children('input').val();
                var $label = $item.children('.super-item-label').text();
                $item.html('<input type="checkbox" value="'+$value+'">'+$label);
                $item.removeClass('super-has-image');
                $item.children('.image').remove();

                var $parent = $this.parents('ul:eq(0)');
                $parent.html('');
                $field.val('');

                var $edit_panel = $('.super-edit-element-panel');

                // Prepare multi-items options
                $edit_panel.find('.multi-items').each(function(){
                    SUPER.update_multi_items($(this));
                });

                $editing.children('textarea[name="element-data"]').val(SUPER.get_current_editing_fields());
                SUPER.regenerate_element_inner($('.super-preview-elements'), '', 1);

                // Reposition Edit Element Panel when height of editing element is changed
                SUPER.reposition_edit_element_panel();

            });

            $button.on('click', function () {
                var $editing = $('.super-preview-elements .super-element.editing');
                var $tag = $editing.attr('data-shortcode-tag');
                    
                $('.ui-widget-overlay').hide();
                $this.parents('.shortcode-dialog').hide();

                // If the media frame already exists, reopen it.
                if ($frame) {
                    $frame.open();
                    return;
                }

                // Create the media frame.
                $frame = wp.media.frames.downloadable_file = wp.media({
                    title: $title,
                    button: {
                        text: $btn_name
                    },
                    library: { 
                        type: $file_type
                    },
                    multiple: $multiple
                });

                // When an image is selected, run a callback.
                if($this.hasClass('browse-images')){
                    $frame.on('select', function () {
                        var $selection = $frame.state().get('selection');
                        $selection.map(function ($attachment) {
                            $attachment = $attachment.toJSON();
                            if ($attachment.id) {
                                $id = $attachment.id;
                                var $url = $attachment.url;
                                if ($attachment.sizes.thumbnail) $url = $attachment.sizes.thumbnail.url;

                                var $data = $editing.children('textarea[name="element-data"]').val();
                                $data = JSON.parse($data);
                                if($this.parent().hasClass('super-multi-items')){
                                    if( ($tag=='checkbox') || ($tag=='radio') ) {
                                        var $item = $button.parents('.super-multi-items:eq(0)');
                                        var $value = $item.children('input[name="value"]').val();
                                        var $label = $item.children('input[name="label"]').val();
                                        if($tag=='checkbox'){
                                            $data = $data.checkbox_items[$this.parent().index()-1];
                                        }
                                        if($tag=='radio'){
                                            $data = $data.radio_items[$this.parent().index()-1];
                                        }
                                    }
                                }

                                var $wh = '';
                                if($this.parent().hasClass('super-multi-items')){
                                    $wh += '<input type="number" placeholder="width" value="' + (typeof $data.width !=='undefined' ? $data.width : '') + '" name="width" />';
                                    $wh += '<span>px</span>';
                                    $wh += '<input type="number" placeholder="height" value="' + (typeof $data.height !=='undefined' ? $data.height : '') + '" name="height" />';
                                    $wh += '<span>px</span>';                                    
                                }

                                var $html = '<li data-file="'+$id+'">';
                                $html += '<div class="image"><img src="' + $url + '" /></div>';
                                $html += $wh;
                                $html += '<a href="#" class="delete">Delete</a></li>';

                                // @since 4.2.0 - update background image for columns in builder (Back-end)
                                if($editing.length){
                                    var $class = '';
                                    if($editing.hasClass('super-column')){
                                        $editing.css('background-image','url("'+$url+'")');
                                        $class = ' class="element-field"';
                                    }else{
                                        var $index = $this.parents('.super-multi-items:eq(0)').index()-1;
                                        var $item = $editing.find('.super-field-wrapper').children('label:eq('+($index)+')');
                                        $item.addClass('super-has-image');

                                        var $item_html = '<div class="image">';
                                        $item_html += '<img src="'+$url+'"';
                                        var $item_styles = '';
                                        if( typeof $data.width !== 'undefined' ) {
                                            if( ($data.width.toLowerCase().indexOf('px') != -1) && ($data.width.indexOf('%') != -1) ) {
                                                $data.width = $data.width.replace('px','').trim()+'px';
                                            }else{
                                                if( $data.width.indexOf('%') != -1 ) {
                                                    $data.width = $data.width.replace('%','').trim()+'%';
                                                }else{
                                                    $data.width = $data.width.replace('px','').trim()+'px';
                                                }
                                            }
                                            $item_styles += 'width:'+$data.width+';';
                                        }
                                        if( typeof $data.height !== 'undefined' ) {
                                            if( ($data.height.toLowerCase().indexOf('px') != -1) && ($data.height.indexOf('%') != -1) ) {
                                                $data.height = $data.height.replace('px','').trim()+'px';
                                            }else{
                                                if( $data.height.indexOf('%') != -1 ) {
                                                    $data.height = $data.height.replace('%','').trim()+'%';
                                                }else{
                                                    $data.height = $data.height.replace('px','').trim()+'px';
                                                }
                                            }
                                            $item_styles += 'height:'+$data.height+';';
                                        }
                                        if($item_styles!=''){
                                            $item_html += ' style="'+$item_styles+'"';
                                        }
                                        $item_html += '>';
                                        $item_html += '</div>';
                                        if($tag=='checkbox'){
                                            $item_html += '<input type="checkbox" value="'+$value+'">';
                                        }
                                        if($tag=='radio'){
                                            $item_html += '<input type="radio" value="'+$value+'">';
                                        }
                                        $item_html += '<span class="super-item-label">'+$label+'</span>';
                                        $item.html($item_html);
                                        $item.children('.image').css('background-image','url("'+$url+'")');
                                    }

                                    // Background size
                                    var $size = $data.bg_size;
                                    var $options = {
                                        'cover':'Cover (default)', 
                                        'auto':'Auto', 
                                        'contain':'Contain', 
                                        'inherit':'Inherit', 
                                        'initial':'Initial', 
                                        'unset':'Unset', 
                                        'custom':'Custom'
                                    };
                                    $html += '<select name="bg_size"' + $class + '>';
                                    $html += '<option value="">- background size -</option>';
                                    $.each($options, function(k, v){
                                        $html += '<option value="' + k +'"' + ($size==k ? ' selected="selected"' : '') + '>' + v + '</option>';
                                    });
                                    $html += '</select>';
                                    $html += '<input' + $class + ' type="text" name="bg_size_custom" value="" placeholder="Background size e.g 235px" style="display:none;" />';

                                    // Background repeat
                                    var $repeat = $data.bg_repeat;
                                    var $options = {
                                        'no-repeat':'No repeat (default)', 
                                        'inherit':'Inherit', 
                                        'initial':'Initial', 
                                        'repeat':'Repeat', 
                                        'repeat-x':'Repeat X axis', 
                                        'repeat-y':'Repeat Y axis', 
                                        'round':'Round',
                                        'space':'Space',
                                        'unset':'Unset'
                                    };
                                    $html += '<select name="bg_repeat"' + $class + '>';
                                    $html += '<option value="">- background repeat -</option>';
                                    $.each($options, function(k, v){
                                        $html += '<option value="' + k +'"' + ($repeat==k ? ' selected="selected"' : '') + '>' + v + '</option>';
                                    });
                                    $html += '</select>';

                                    // Background position
                                    var $position = $data.bg_position;
                                    var $options = {
                                        'center':'Center (default)',
                                        'bottom':'Bottom',
                                        'inherit':'Inherit',
                                        'initial':'Initial',
                                        'left':'Left',
                                        'right':'Right',
                                        'top':'Top',
                                        'unset':'Unset'
                                    };
                                    $html += '<select name="bg_position"' + $class + '>';
                                    $html += '<option value="">- background position -</option>';
                                    $.each($options, function(k, v){
                                        $html += '<option value="' + k +'"' + ($position==k ? ' selected="selected"' : '') + '>' + v + '</option>';
                                    });
                                    $html += '</select>';
                                }

                                $preview.html($html);
                            }
                        });
                        $field.val($id);
            
                        
                        var $edit_panel = $('.super-edit-element-panel');

                        // Prepare multi-items options
                        $edit_panel.find('.multi-items').each(function(){
                            SUPER.update_multi_items($(this));
                        });

                        $editing.children('textarea[name="element-data"]').val(SUPER.get_current_editing_fields());
                        SUPER.regenerate_element_inner($('.super-preview-elements'), '', 1);

                        // Reposition Edit Element Panel when height of editing element is changed
                        SUPER.reposition_edit_element_panel();

                    });
                }

                // When a file is selected, run a callback.
                if($this.hasClass('browse-files')){
                    $frame.on('select', function () {
                        var $selection = $frame.state().get('selection');
                        var $id = $field.val();
                        $selection.map(function ($attachment) {
                            $attachment = $attachment.toJSON();
                            if ($attachment.id) {
                                if($multiple==true){
                                    $id = $id ? $id + "," + $attachment.id : $attachment.id;
                                    $('<li data-file="'+$attachment.id+'"><div class="image"><img src="' + $attachment.icon + '" /></div><a href="">' + $attachment.filename + '</a><a href="#" class="delete">Delete</a></li>').appendTo($preview);
                                }else{
                                    $id = $attachment.id;
                                    $preview.html('<li data-file="'+$attachment.id+'"><div class="image"><img src="' + $attachment.icon + '" /></div><a href="">' + $attachment.filename + '</a><a href="#" class="delete">Delete</a></li>');
                                }

                                // Reposition Edit Element Panel when height of editing element is changed
                                SUPER.reposition_edit_element_panel();
                                SUPER.reposition_edit_element_panel();

                            }
                        });
                        $field.val($id);
                    });
                }

                $frame.on('close', function () {
                    $('.ui-widget-overlay').show();
                    $this.parents('.shortcode-dialog').show();
                });
                
                // Finally, open the modal.
                $frame.open();
                
            });
        });
    }

    jQuery(document).ready(function ($) {
        var $doc = $(document);
        $doc.on('click', '.super-form-button > .super-button-wrap', function (e) {
            var $form = $(this).parents('.super-form:eq(0)');
            SUPER.conditional_logic(undefined, $form );
            SUPER.validate_form( $form, $(this), undefined, e );
            return false;
        });
    });

})(jQuery);