(function($) { // Hide scope, no $ conflict
	
    jQuery(document).ready(function ($) {
    
	    var $doc = $(document);
	    
	    $doc.on('click', '.super-form-button > a', function (e) {
	        var $this = $(this);
	        var $form = $this.parents('.super-form:eq(0)');
	        
	        // @since 2.0.0 - clear the form action
	        var $action = $this.children('.super-button-name').data('action');
	        if($action=='clear'){
	        	SUPER.init_clear_form($form);
        		return false;
	        }

	        // @since 3.1.0 - print form data
	        if($action=='print'){
	        	SUPER.init_print_form($form);
        		return false;
	        }

	        var $url = $this.attr('href');

	        // @since 1.9
	        var $proceed = SUPER.before_submit_button_click_hook(e, $this);

	        if($proceed==true){
		        if( ($url!='') && (typeof $url !== 'undefined') ){
					var $regular_expression = /\{(.*?)\}/g;
				    var $array = [];
					var $i = 0;
				    while (($match = $regular_expression.exec($url)) != null) {
				    	$array[$i] = $match[1];
				    	$i++;
				    }
					for (var $i = 0; $i < $array.length; $i++) {
				        var $name = $array[$i];
				        var $element = $form.find('.super-shortcode-field[name="'+$name+'"]');
				        if($element.length){
							$value = $element.val();
							$url = $url.replace('{'+$name+'}', $value);
							
				        }
				    }
				    $url = $url.replace('{', '').replace('}', '');
				    $this.attr('href', $url);
				    if( $url=='#' ) {
				    	return false;
				    }
		        }else{
		            if(!$this.parent('.super-form-button').hasClass('super-loading')){
		            	SUPER.validate_form( $form, $this );
		        	}
		        	return false;
		        }
	        }

	    });

	    SUPER.init_tooltips(); 
	    SUPER.init_distance_calculators();
	    SUPER.init_super_form_frontend();
		
		$( document ).ajaxComplete(function() {
			SUPER.init_super_form_frontend();
		});
	   
	});

})(jQuery);
