(function($) { // Hide scope, no $ conflict

    // Loading States
    SUPER.loading_states = function(button, status){
        status = status || 'loading';
        if(status=='loading'){
            var old_html = button.html();
            button.data('old-html',old_html);
            button.parents('.super-form-button:eq(0)').addClass('super-loading');
            button.html('<i class="fa fa-refresh fa-spin"></i>');
        }else{
            button.parents('.super-form-button:eq(0)').removeClass('super-loading')
            button.html(button.data('old-html'));
        }
    }

    // Check if the added field has an unique field name
    SUPER.check_for_unique_field_name = function($element){
        var $field = $element.find('.super-shortcode-field');
        // @since v1.2.3 check if we are not importing predefined element
        if($field.length==1){
            if( typeof $field !== 'undefined' ) {
                if( typeof $field.attr('name') !== 'undefined' ) {
                    var $name = $field.attr('name').replace('[','').replace(']','');
                    var $exists = $('.super-preview-elements .super-shortcode-field[name="'+$name+'"]');
                    if($exists.length==0){
                        var $field = $element.find('.super-selected-files');
                        var $name = $field.attr('name').replace('[','').replace(']','');
                        var $exists = $('.super-preview-elements .super-selected-files[name="'+$name+'"]');
                    }
                    if($exists.length>0){
                        var $unique_name = SUPER.generate_unique_field_name($field, $name, $name, 0);
                        $field.attr('name',$unique_name);
                        var $data = $.parseJSON($element.children('textarea[name="element-data"]').val());
                        $data.name = $unique_name;
                        var $data = JSON.stringify($data);
                        $element.children('textarea[name="element-data"]').val($data);
                    }
                }
            }
        }
    }

    // Generate unique field name for a given element
    SUPER.generate_unique_field_name = function($field, $name, $new_name, $counter){
        var $exists = $('.super-preview-elements .super-shortcode-field[name="'+$new_name+'"]');
        if( $exists.length==0 ) {
            var $exists = $('.super-preview-elements .super-selected-files[name="'+$new_name+'"]');
        }
        if( $exists.length>1 ) {
            $counter++;
            $new_name = $name+'_'+$counter;
            $field.attr('name',$new_name);
            return SUPER.generate_unique_field_name($field, $name, $new_name, $counter);
        }else{
            return $new_name;
        }
    }

    // Regenerate Element Final Output (inner)
    SUPER.regenerate_element_inner = function($target){
        if($target==2){
            var $elements = $('textarea[name="_super_elements"].active').val();
        }else{
            var $elements = [];
            $target.children('.super-element').each(function(){
                var $this = $(this);
                var $tag = $this.data('shortcode-tag');
                var $group = $this.data('group');
                var $data = $.parseJSON($this.children('textarea[name="element-data"]').val());
                if(typeof $this.attr('data-minimized') === 'undefined' ) {
                    $data.minimized = 'no';
                }else{
                    $data.minimized = $this.attr('data-minimized');
                }
                if($tag=='column'){
                    var $size = $this.attr('data-size');
                    $data.size = $size;
                }
                $elements.push({ 
                    tag: $tag,
                    group:$group,
                    inner:SUPER.regenerate_element_inner_children($this),
                    data:$data
                });
            });
           var $elements = JSON.stringify($elements);
        }
        $('textarea[name="_super_elements"].active').val($elements);
        if($target==2){
            SUPER.save_form($('.super-actions .save'), 2);
        }else{
            SUPER.trigger_redo_undo();
        }
    }

    // Also collect all inner items
    SUPER.regenerate_element_inner_children = function($target){
        var $target = $target.children('.super-element-inner');
        if($target.children('.super-element').length){
            var $elements = [];
            $target.children('.super-element').each(function(){
                var $this = $(this);
                var $tag = $this.data('shortcode-tag');
                var $group = $this.data('group');
                var $data = $.parseJSON($this.children('textarea[name="element-data"]').val());
                if(typeof $this.attr('data-minimized') === 'undefined' ) {
                    $data.minimized = 'no';
                }else{
                    $data.minimized = $this.attr('data-minimized');
                }
                if($tag=='column'){
                    var $size = $this.attr('data-size');
                    $data.size = $size;
                }
                $elements.push({ 
                    tag: $tag,
                    group:$group,
                    inner:SUPER.regenerate_element_inner_children($this),
                    data:$data
                });
            });
            return $elements;
        }else{
            return '';
        }
    }

    // Re initialize drop here placeholder (image)
    SUPER.init_drop_here_placeholder = function(){
        $('.super-preview-elements').addClass('drop-here-placeholder');
        SUPER.init_drag_and_drop();
    }

    // Initialize elements so they can be sortable
    SUPER.init_drag_and_drop = function(){
        $('.super-preview-elements').sortable({
            scroll: false,
            scrollSensitivity: 100,
            opacity: 0.8,
            forcePlaceholderSize: true,
            forceHelperSize: true,
            connectWith: ".super-preview-elements > .super-element, .super-preview-elements > .super-element .super-element-inner",
            stop: function( event, ui ) {
                var $tag = ui.item.data('shortcode-tag');
                var $parent_tag = ui.item.parents('.super-element:eq(0)').data('shortcode-tag');
                if( typeof $parent_tag !== 'undefined' ) {
                    if( ( $tag==='multipart_pre' ) && ( $tag == $parent_tag ) ) {
                        alert(super_create_form_i18n.alert_multipart_error);
                        return false;
                    }
                }
                SUPER.init_drop_here_placeholder();
                SUPER.regenerate_element_inner($('.super-preview-elements'), '', 1);
            }
        });    
        var $target = $('.super-preview-elements .super-element.super-column > .super-element-inner, .super-preview-elements .super-element.multipart > .super-element-inner');
        $target.sortable({
            scroll: false,
            scrollSensitivity: 100,
            opacity: 0.8,
            forcePlaceholderSize: true,
            forceHelperSize: true,
            connectWith: ".super-preview-elements, .super-preview-elements > .super-element .super-element-inner",
            stop: function( event, ui ) {
                var $tag = ui.item.data('shortcode-tag');
                var $parent_tag = ui.item.parents('.super-element:eq(0)').data('shortcode-tag');
                if( typeof $parent_tag !== 'undefined' ) {
                    if( ( $tag==='multipart_pre' ) && ( $tag == $parent_tag ) ) {
                        alert(super_create_form_i18n.alert_multipart_error);
                        return false;
                    }
                }
                SUPER.init_drop_here_placeholder();
                SUPER.regenerate_element_inner($('.super-preview-elements'), '', 1);
            }
        });
    }

    // Scroll function when dropable or sortable element is activated
    SUPER.handleNear = function(){
        var $scrolled = $(window).scrollTop();
        var $buffer = 20;
        var $docHeight = $(document).outerHeight(true);
        var $windowHeight = $(window).outerHeight(true);
        var $near_top = $scrolled - this.ev.y >= $buffer;  
        var $near_bottom = $scrolled + $windowHeight - this.ev.y <= $buffer;  
        if($near_top){
            window.scrollTo(0, $scrolled - $buffer);
        }
        if(($near_bottom) && ((this.ev.y+$buffer) < $docHeight)){
            window.scrollTo(0, this.ev.y + $buffer - $windowHeight);
        }        
    }

    SUPER.init_previously_created_fields = function(){
        $('.super-multi-items .super-previously-created').each(function(){
            var $this = $(this);
            var $value = $this.data('value');
            if($this.parent().hasClass('address-auto-popuplate-item')) $this.append('<option value="">- select a field -</option>');  
            $('.super-preview-elements .super-element').each(function(){
                var $data = $(this).find('textarea[name="element-data"]').val();
                var $data = JSON.parse($data);
                var $name = $data.name;
                var $email = $data.email;
                var $found = $this.find('option[value="'+$name+'"]').length;

                if( ( typeof $name !== 'undefined' ) && ( $found==0 ) ) {
                    if($value==$name){
                        $this.append('<option selected="selected" value="'+$name+'">'+$email+' ('+$name+')</option>');
                    }else{
                        $this.append('<option value="'+$name+'">'+$email+' ('+$name+')</option>');  
                    }
                }
            });
        });
        $('.super-element-settings .super-elements-container select[name="connected_min"]').each(function(){
            var $this = $(this);
            var $current = $('.super-element.editing').find('.super-shortcode-field');
            var $connected_min = $current.attr('data-connected_min');
            $('.super-preview-elements .super-element').each(function(){
                if($(this).find('.super-date').length){
                    var $data = $(this).find('textarea[name="element-data"]').val();
                    var $data = JSON.parse($data);
                    var $name = $data.name;
                    var $email = $data.email;
                    var $found = $this.find('option[value="'+$name+'"]').length;
                    if( ( typeof $name !== 'undefined' ) && ( $found==0 ) ) {
                        if($connected_min==$name){
                            $this.append('<option selected="selected" value="'+$name+'">'+$email+' ('+$name+')</option>');  
                        }else{
                            $this.append('<option value="'+$name+'">'+$email+' ('+$name+')</option>');  
                        }
                    }
                }
            });
        });
        $('.super-element-settings .super-elements-container select[name="connected_max"]').each(function(){
            var $this = $(this);
            var $current = $('.super-element.editing').find('.super-shortcode-field');
            var $connected_max = $current.attr('data-connected_max');
            $('.super-preview-elements .super-element').each(function(){
                if($(this).find('.super-date').length){
                    var $data = $(this).find('textarea[name="element-data"]').val();
                    var $data = JSON.parse($data);
                    var $name = $data.name;
                    var $email = $data.email;
                    var $found = $this.find('option[value="'+$name+'"]').length;
                    if( ( typeof $name !== 'undefined' ) && ( $found==0 ) ) {
                        if($connected_max==$name){
                            $this.append('<option selected="selected" value="'+$name+'">'+$email+' ('+$name+')</option>');  
                        }else{
                            $this.append('<option value="'+$name+'">'+$email+' ('+$name+')</option>');  
                        }
                    }
                }
            });
        });
    }

    SUPER.update_multi_items = function($this){
        var $parent = $this.parents('.field-input:eq(0)');
        var $items = [];
        $parent.find('.super-multi-items').each(function(){
            var $this = $(this);
            if($this.hasClass('super-conditional-item')){
                $items.push({ 
                    field: $this.children('select[name="conditional_field"]').val(),
                    logic: $this.children('select[name="conditional_logic"]').val(),
                    value: $this.children('input[name="conditional_value"]').val(),
                    and_method: $this.children('select[name="conditional_and_method"]').val(),
                    field_and: $this.children('select[name="conditional_field_and"]').val(),
                    logic_and: $this.children('select[name="conditional_logic_and"]').val(),
                    value_and: $this.children('input[name="conditional_value_and"]').val(),
                    new_value: $this.children('textarea[name="conditional_new_value"]').val()
                });
            }else if($this.hasClass('address-auto-popuplate-item')){
                $items.push({ 
                    key: $this.children('input[name="key"]').val(),
                    field: $this.children('select[name="field"]').val(),
                    type: $this.children('select[name="type"]').val()
                });
            }else{
                if($this.children('input[type="checkbox"]').length){
                    var $checked = $this.children('input[type="checkbox"]').is(':checked');
                }
                if($this.children('input[type="radio"]').length){
                    var $checked = $this.children('input[type="radio"]').is(':checked');
                }
                $items.push({ 
                    checked: $checked,
                    image: $this.find('input[name="image"]').val(),
                    max_width: $this.find('input[name="max_width"]').val(),
                    max_height: $this.find('input[name="max_height"]').val(),
                    label: $this.children('input[name="label"]').val(),
                    value: $this.children('input[name="value"]').val()
                });
            }
        });
        var $items = JSON.stringify($items);
        $parent.children('textarea').val($items);
    }

    SUPER.init_dragable_elements = function() {
        $('.draggable-element').pep({
            activeClass: 'active',
            droppableActiveClass: 'dropping-allowed',
            droppable: '.super-dropable',
            start: function(ev, obj){
                SUPER.init_drop_here_placeholder();
                obj.noCenter = true;
                var top = obj.$el.css('top').replace('px','');
                var left = obj.$el.css('left').replace('px','');
                if(typeof obj.$el.attr('data-start-position-top') === 'undefined'){
                    obj.$el.attr('data-start-position-top', top)
                    obj.$el.attr('data-start-position-left', left)
                }            
            },
            drag:function(e) {  
                SUPER.handleNear.apply(this);
            },
            stop: function(ev, obj){
                if(this.activeDropRegions.length>0){
                    var $tag = obj.$el.data('shortcode');
                    var $target = $('.dropping-allowed:not(:has(.dropping-allowed))');
                    var $multipart_found = $target.closest('[data-shortcode-tag="multipart"]').length;
                    if( ( ($multipart_found>0) && ($tag==='multipart_pre') ) ) {
                        alert(super_create_form_i18n.alert_multipart_error);
                        return false;
                    }
                    var $predefined = '';
                    if( typeof obj.$el.find('.predefined').val() !== 'undefined' ) {
                        $predefined = JSON.parse(obj.$el.find('.predefined').val());
                    }
                    $.ajax({
                        type: 'post',
                        url: ajaxurl,
                        data: {
                            action: 'super_get_element_builder_html',
                            tag: obj.$el.data('shortcode'),
                            group: obj.$el.data('group'),
                            predefined: $predefined,
                            form_id: $('input[name="form_id"]').val()
                        },
                        success: function (data) {
                            var $element = $(data).appendTo($target);
                            SUPER.init_resize_element_labels();
                            SUPER.check_for_unique_field_name($element);
                            SUPER.regenerate_element_inner($('.super-preview-elements'), '', 1);
                            SUPER.init_skype();
                            SUPER.init_tooltips();
                            SUPER.init_datepicker();
                            SUPER.init_masked_input();
                            SUPER.init_currency_input();
                            SUPER.init_colorpicker();
                            SUPER.init_slider_field();
                            SUPER.init_button_colors();
                            SUPER.init_drop_here_placeholder();
                        }
                    });
                }else{
                    obj.cssX = 0
                    obj.cssY = 0
                    obj.translation = "matrix(1, 0, 0, 1, 0, 0)"
                    obj.transform(obj.translation)
                    obj.$el.css('top', '0').css('left', '0');
                }
            },
            revert: true,
            cssEaseDuration: 0,
        });
    }
    SUPER.save_form = function( $this, $preview ) {
        var $fields = $('.super-preview-elements .super-shortcode-field, .super-preview-elements .super-selected-files');
        var $error = false;
        $fields.each(function(){
            var $origin_field = $(this);
            if($origin_field.parents('.super-file:eq(0)').length) {
                var $duplicate_fields = $('.super-preview-elements .super-selected-files[name="'+$(this).attr('name')+'"]');
            }else{
                var $duplicate_fields = $('.super-preview-elements .super-shortcode-field[name="'+$(this).attr('name')+'"]');
            }
            if($duplicate_fields.length > 1){
                $duplicate_fields.parents('.super-element').addClass('error');
                $error = true;
            }else{
                $duplicate_fields.parents('.super-element').removeClass('error');
            }
        });
        if($error == true) {
            alert(super_create_form_i18n.alert_duplicate_field_names);
            return false;
        }        
        
        $this.html('<i class="fa fa-save"></i>Saving...');
        var $settings = [];
        $('.super-create-form .super-form-settings .element-field').each(function(){
            $settings.push({'name':$(this).attr('name'), 'value':$(this).val()});
        });
        $.ajax({
            type: 'post',
            url: ajaxurl,
            data: {
                action: 'super_save_form',
                id: $('.super-create-form input[name="form_id"]').val(),
                title: $('.super-create-form input[name="title"]').val(),
                shortcode: $('textarea[name="_super_elements"].active').val(),
                settings: $settings,
            },
            success: function (data) {
                $('.super-create-form .super-get-form-shortcodes').val('[super_form id="'+data+'"]');
                $('.super-create-form input[name="form_id"]').val(data);
                $('.super-create-form .super-actions .save').html('<i class="fa fa-save"></i>Save');
                if($preview==1){
                    var $this = $('.super-create-form .super-actions .preview:eq(3)');
                    SUPER.preview_form($this);
                }else{
                    var href = window.location.href;
                    var page = href.substr(href.lastIndexOf('/') + 1);
                    var str2 = "admin.php?page=super_create_form&id";
                    if(page.indexOf(str2) == -1){
                        window.location.href = "admin.php?page=super_create_form&id="+data;
                    }else{
                        if($preview==2){
                            location.reload();
                        }                    
                    }
                }
            }
        });
    }
    SUPER.preview_form = function( $this ) {  
        if($('input[name="form_id"]').val()==''){
            alert(super_create_form_i18n.alert_save);
            return false;
        }
        if(!$this.hasClass('active')){
            $this.html('Loading...');
            $('.super-live-preview').html('');
            $('.super-preview-elements').css('display','none');
            $('.super-live-preview').addClass('loading').css('display','block');
            var $form_id = $('.super-create-form input[name="form_id"]').val();
            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action: 'super_load_preview',
                    id: $form_id,
                },
                success: function (data) {
                    $('.super-live-preview').removeClass('loading');
                    $('.super-live-preview').html(data);
                    $this.html('Builder');
                },
                complete: function () {
                    SUPER.handle_columns();
                    SUPER.init_button_colors();
                    SUPER.init_super_responsive_form_fields();
                    SUPER.init_super_form_frontend();
                    SUPER.after_preview_loaded_hook($form_id);
                }
            });
        }else{
            $('.super-live-preview').css('display','none');
            $('.super-preview-elements').css('display','block');
            $this.html('Preview');
        }
        $this.toggleClass('active');
    }

    // Update export json
    SUPER.init_update_export_json = function( $this ) {
        var $settings = {};
        $('.super-create-form .super-form-settings .element-field').each(function(){
            $settings[$(this).attr('name')] = $(this).val();
        });
        var $settings = JSON.stringify($settings);
        $('.super-export-import textarea[name="export-json"]').val($settings); 
    }

    // Update export json
    SUPER.init_resize_element_labels = function() {
        $('.super-create-form .super-element-header .super-element-label > input').each(function(){
            var $span = $(this).parent().children('span');
            var $width = $span.outerWidth(true);
            $(this).parent().css('width', $width+'px').css('margin-left', '-'+($width/2)+'px');
        });   
    }

    // @since 2.9.0 - form setup wizard
    SUPER.update_wizard_preview = function($theme, $size, $icon, $save) {
        if($theme==null) $theme = $('.super-theme-style-wizard li.super-active').attr('data-value');
        if($size==null) $size = $('.super-field-size-wizard li.super-active').attr('data-value');
        if($icon==null) $icon = $('.super-theme-hide-icons-wizard li.super-active').attr('data-value');
        if($theme=='squared') $theme_setting = '';
        if($theme=='rounded') $theme_setting = 'super-default-rounded';
        if($theme=='full-rounded') $theme_setting = 'super-full-rounded';
        if($theme=='minimal') $theme_setting = 'super-style-one';
        if($icon=='no') $icon_setting = 'yes';
        if($icon=='yes') $icon_setting = 'no';
        if($save==true){
            $('.super-create-form select[name="theme_style"]').val($theme_setting);
            $('.super-create-form select[name="theme_field_size"]').val($size);
            $('.super-create-form select[name="theme_hide_icons"]').val($icon_setting);
            $('.super-create-form input[name="title"]').val($('.super-create-form input[name="wizard_title"]').val());
            
            $('.super-create-form input[name="header_to"]').val($('.super-create-form input[name="wizard_header_to"]').val());
            $('.super-create-form select[name="header_from_type"]').val('custom');
            $('.super-create-form input[name="header_from"]').val($('.super-create-form input[name="wizard_header_from"]').val());
            $('.super-create-form input[name="header_from_name"]').val($('.super-create-form input[name="wizard_header_from_name"]').val());
            $('.super-create-form input[name="header_subject"]').val($('.super-create-form input[name="wizard_header_subject"]').val());
            $('.super-create-form textarea[name="email_body_open"]').val($('.super-create-form textarea[name="wizard_email_body_open"]').val());

            $('.super-create-form input[name="confirm_to"]').val($('.super-create-form input[name="wizard_confirm_to"]').val());
            $('.super-create-form select[name="confirm_from_type"]').val('custom');
            $('.super-create-form input[name="confirm_from"]').val($('.super-create-form input[name="wizard_confirm_from"]').val());
            $('.super-create-form input[name="confirm_from_name"]').val($('.super-create-form input[name="wizard_confirm_from_name"]').val());
            $('.super-create-form input[name="confirm_subject"]').val($('.super-create-form input[name="wizard_confirm_subject"]').val());
            $('.super-create-form textarea[name="confirm_body_open"]').val($('.super-create-form textarea[name="wizard_confirm_body_open"]').val());

            $('.super-create-form input[name="form_thanks_title"]').val($('.super-create-form input[name="wizard_form_thanks_title"]').val());
            $('.super-create-form textarea[name="form_thanks_description"]').val($('.super-create-form textarea[name="wizard_form_thanks_description"]').val());

        }
        var $img_preview = $theme+'-'+$size;
        if($icon=='yes') $img_preview = $img_preview+'-icon';
        var $img_preview_url = $('.super-wizard-preview img').attr('data-preview-url')+'assets/images/wizard-preview/'+$img_preview+'.png';
        $('.super-wizard-preview img').attr('src', $img_preview_url);
    }

    // @since 3.1.0 - trigger undo/redo after _super_elements was changed
    SUPER.trigger_redo_undo = function() {
        var $code = $('textarea[name="_super_elements"].active');
        var $clone = $code.clone();
        $('textarea[name="_super_elements"].active').removeClass('active').addClass('fake-active');
        $clone.addClass('active');
        $clone.insertAfter($('textarea[name="_super_elements"].fake-active'));
        $('textarea[name="_super_elements"].fake-active').removeClass('fake-active');
        var $html = $('.super-preview .super-preview-elements').html();
        $('<div>'+$html+'</div>').appendTo($('.super-history-html'));
        if($code.parent().children('textarea').length>1){
            if($('textarea[name="_super_elements"].active').index()==0){
                $('.super-form-history .super-undo').addClass('super-disabled');
            }else{
                $('.super-form-history .super-undo').removeClass('super-disabled');
            }
            if($('textarea[name="_super_elements"].active').index()==($('.super-debug textarea[name="_super_elements"]').length-1)){
                $('.super-form-history .super-redo').addClass('super-disabled');
            }else{
                $('.super-form-history .super-redo').removeClass('super-disabled');
            }
        }
    }

    jQuery(document).ready(function ($) {
        
        var $doc = $(document);

        // @since 3.1.0 - backup history
        $doc.on('click', '.super-form-history .super-backups', function(){
            $('.super-backup-history, .super-first-time-setup-bg').addClass('super-active')
            $('.super-backup-history').addClass('super-loading');
            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action: 'super_restore_backup',
                    form_id: $('.super-create-form input[name="form_id"]').val()
                },
                success: function (data) {
                    $('.super-wizard-backup-history > ul').remove();
                    $('.super-wizard-backup-history').find('i').remove();
                    $(data).appendTo($('.super-wizard-backup-history'));
                },
                complete: function(){
                    $('.super-backup-history').removeClass('super-loading');
                }
            });

        });
        $doc.on('click', '.super-wizard-backup-history > ul > li > span', function(){
            $(this).html('Restoring...').addClass('loading');
            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action: 'super_restore_backup',
                    form_id: $('.super-create-form input[name="form_id"]').val(),
                    backup_id: $(this).parent('li').attr('data-id')
                },
                success: function (data) {
                    location.reload();
                }
            });
        });
        $doc.on('click', '.super-wizard-backup-history > ul > li > i', function(){
            var $parent = $(this).parents('ul:eq(0)');
            var $delete = confirm(super_create_form_i18n.confirm_deletion);
            if($delete == true) {
                var $backup = $(this).parent();
                $backup.html(super_create_form_i18n.deleting);
                $.ajax({
                    type: 'post',
                    url: ajaxurl,
                    data: {
                        action: 'super_delete_backups',
                        backup_id: $backup.data('id')
                    },
                    success: function (data) {
                        $backup.slideUp("normal", function(){
                            $(this).remove();
                            if($parent.children('li').length==0){
                                $('.super-wizard-backup-history > ul').remove();
                                $('<i>'+super_create_form_i18n.no_backups_found+'</i>').appendTo($('.super-wizard-backup-history'));
                            }
                        });
                    }
                });
            }

        });
        $doc.on('click', '.delete-backups', function(){
            var $old_html = $(this).html();
            var $button = $(this);
            $button.html(super_create_form_i18n.deleting).addClass('loading');
            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action: 'super_delete_backups',
                    form_id: $('.super-create-form input[name="form_id"]').val()
                },
                success: function (data) {
                    $('.super-wizard-backup-history > ul').remove();
                    $('<i>'+super_create_form_i18n.no_backups_found+'</i>').appendTo($('.super-wizard-backup-history'));
                    $button.html($old_html).removeClass('loading');
                }
            });
        });


        // @since 3.1.0 - undo/redo buttons
        $doc.on('click', '.super-form-history .super-redo:not(.super-disabled)', function(){
            var $e = $('textarea[name="_super_elements"].active').next();
            if($e.index()<0){
                $('.super-form-history .super-redo').addClass('super-disabled');
                return false;
            }
            $('textarea[name="_super_elements"]').removeClass('active');
            $e.addClass('active');
            $('.super-history-html').removeClass('active');
            $('.super-history-html > div:eq('+$e.index()+')').addClass('active');
            $('.super-preview .super-preview-elements').html($('.super-history-html > div:eq('+$e.index()+')').html());
            $('.super-form-history .super-undo').removeClass('super-disabled');
            if($('textarea[name="_super_elements"].active').index()==($('.super-debug textarea[name="_super_elements"]').length-1)){
                $('.super-form-history .super-redo').addClass('super-disabled');
            }
            SUPER.init_resize_element_labels();
        });
        $doc.on('click', '.super-form-history .super-undo:not(.super-disabled)', function(){
            var $e = $('textarea[name="_super_elements"].active').prev();
            if($e.index()<0){
                $('.super-form-history .super-undo').addClass('super-disabled');
                return false;
            }
            $('textarea[name="_super_elements"]').removeClass('active');
            $e.addClass('active');
            $('.super-history-html').removeClass('active');
            $('.super-history-html > div:eq('+$e.index()+')').addClass('active');
            $('.super-preview .super-preview-elements').html($('.super-history-html > div:eq('+$e.index()+')').html());
            $('.super-form-history .super-redo').removeClass('super-disabled');
            if($('textarea[name="_super_elements"].active').index()==0){
                $('.super-form-history .super-undo').addClass('super-disabled');
            }
            SUPER.init_resize_element_labels();
        });


        SUPER.init_drop_here_placeholder();
        SUPER.init_dragable_elements();
        SUPER.init_image_browser();

        $('.super-layout-elements .super-elements-container').css('display','block');

        $doc.on('change keydown keyup blur','.super-create-form .super-form-settings .element-field',function(){
            SUPER.init_update_export_json($(this));
        });

        SUPER.init_resize_element_labels();

        // @since 2.9.0 - Form setup wizard
        $doc.on('click', '.super-theme-style-wizard > li, .super-field-size-wizard > li, .super-theme-hide-icons-wizard > li', function(){
            var $this = $(this);
            var $parent = $this.parent();
            $parent.children('li').removeClass('super-active');
            $this.addClass('super-active');
            var $value = $this.attr('data-value');
            if($parent.hasClass('super-theme-style-wizard')) SUPER.update_wizard_preview($value, null, null, false);
            if($parent.hasClass('super-field-size-wizard')) SUPER.update_wizard_preview(null, $value, null, false);
            if($parent.hasClass('super-theme-hide-icons-wizard')) SUPER.update_wizard_preview(null, null, $value, false);
        });
        $doc.on('click', '.skip-wizard', function(){
            $('.super-first-time-setup, .super-first-time-setup-bg').removeClass('super-active');
        });        

        $doc.on('click', '.save-wizard', function(){
            $(this).addClass('loading').html('Saving settings...');
            SUPER.update_wizard_preview(null, null, null, true);
            $('.super-actions .save').trigger('click');
        });
        $doc.on('click', '.super-wizard-settings .super-tabs > li', function(){
            var $index = $(this).index();
            $(this).parent().children('li').removeClass('super-active');
            $(this).addClass('super-active');
            $('.super-wizard-settings .super-tab-content > li').removeClass('super-active');
            $('.super-wizard-settings .super-tab-content > li:eq('+$index+')').addClass('super-active');
        });


        // @since 1.5
        $doc.on('change keyup blur','.super-element.super-element-settings input[name="name"]',function(){
            var $editing = $('.super-preview-elements .super-element.editing');
            var $tag = $editing.data('shortcode-tag');
            if( $tag!='button' ) {
                var $value = $(this).val().replace(/\s+/gi,'_');
                var $value = $value.replace(/ /g,"_");
                var $value = $value.replace(/\//g,"");
                var $value = $value.replace(/[^a-zA-Z0-9-_\.]+/g,"");
                var $value = $value.replace(/\.+/g, "_");
                var $value = $value.replace(/[--]+/g, "-");
                var $value = $value.replace(/[__]+/g, "_");
                $(this).val($value);
            }
        });

        $doc.on('change keydown keyup blur','.super-create-form .super-element-header .super-element-label > input',function(){
            var $value = $(this).val();
            var $span = $(this).parent().children('span');
            $span.html($value);
            var $width = $span.outerWidth(true);
            $(this).parent().css('width', $width+'px').css('margin-left', '-'+($width/2)+'px');
            var $parent = $(this).parents('.super-element:eq(0)');
            var $data = $parent.children('textarea[name="element-data"]').val();
            var $tag = $parent.data('shortcode-tag');
            var $data = JSON.parse($data);
            if( ($tag=='column') || ($tag=='multipart') ) {
                $data.label = $value;
            }
            var $data = JSON.stringify($data);
            $parent.children('textarea[name="element-data"]').val($data);
            SUPER.regenerate_element_inner($('.super-preview-elements'), '', 1);

        });

        $doc.on('click','.super-element-actions .duplicate',function(){
            var $parent = $(this).parents('.super-element:eq(0)');
            $parent.find('.tooltip').remove();
            var $new = $parent.clone();
            $new.removeClass('editing');
            $new.insertAfter($parent);
            $new.slideUp(0);
            $new.slideDown(300);
            SUPER.regenerate_element_inner($('.super-preview-elements'), '', 1);
        });
        $doc.on('click', '.super-element-actions .minimize', function(){
            var $this = $(this).parents('.super-element:eq(0)');
            var $minimized = $this.attr('data-minimized');
            if( $minimized === 'undefined' ) $minimized = 'no';
            if($minimized=='yes'){
                $this.attr('data-minimized', 'no').removeClass('super-minimized');
            }else{
                $this.attr('data-minimized', 'yes').addClass('super-minimized');
            }
            SUPER.regenerate_element_inner($('.super-preview-elements'), '', 1);
        });
        $doc.on('click', '.super-element-actions .delete', function(){
            $(this).parents('.super-element:eq(0)').remove();
            SUPER.regenerate_element_inner($('.super-preview-elements'), '', 1);
            cancel_update();
        });
        $doc.on('click','.super-element > .super-element-header > .resize > span',function(){
            var $parent = $(this).parents('.super-element:eq(0)');
            var $data = $parent.find('textarea[name="element-data"]').val();
            var $data = JSON.parse($data);
            var $size = $data.size;
            if( typeof $parent.attr('data-size') !== 'undefined' ){
                var $size = $parent.attr('data-size');
            }
            var $sizes = {
                '1/1':'super_one_full',
                '4/5':'super_four_fifth',
                '3/4':'super_three_fourth',
                '2/3':'super_two_third',
                '3/5':'super_three_fifth',
                '1/2':'super_one_half',
                '2/5':'super_two_fifth',
                '1/3':'super_one_third',
                '1/4':'super_one_fourth',
                '1/5':'super_one_fifth'};
            var $keys = ['1/1','4/5','3/4','2/3','3/5','1/2','2/5','1/3','1/4','1/5'];
            var $start = $size;
            var $next = $keys[($.inArray($start, $keys) + 1) % $keys.length];
            var $prev = $keys[($.inArray($start, $keys) - 1 + $keys.length) % $keys.length];
            if($(this).hasClass('smaller')){
                if($size=='1/5'){
                    return false;
                }
                $parent.attr('data-size',$next);
                $parent.removeClass($sizes[$start]).addClass($sizes[$next]);
                $parent.children('.super-element-header').find('.resize > .current').html($next);
            }
            if($(this).hasClass('bigger')){
                if($size=='1/1'){
                    return false;
                }
                $parent.attr('data-size',$prev);
                $parent.removeClass($sizes[$start]).addClass($sizes[$prev]);
                $parent.children('.super-element-header').find('.resize > .current').html($prev);
            }
            SUPER.regenerate_element_inner($('.super-preview-elements'), '', 1);
        });
        $doc.on('click','.super-switch-forms',function(){
            var $this = $(this);
            if($this.hasClass('active')){
                $this.children('.fa').removeClass('fa-chevron-up').addClass('fa-chevron-down');
                $this.removeClass('active');
                $this.children('ul').slideUp(300);
            }else{
                $this.children('.fa').removeClass('fa-chevron-down').addClass('fa-chevron-up');
                $this.addClass('active');
                $this.children('ul').slideDown(300);
            }
        });
        $doc.on('mouseleave','.super-switch-forms ul',function(){
            var $this = $(this).parent();
            $this.children('.fa').removeClass('fa-chevron-up').addClass('fa-chevron-down');
            $this.removeClass('active');
            $this.children('ul').slideUp(300);
        });

        $doc.on('change','.super-form-settings-tabs > select, .super-element-settings-tabs > select',function(){
            $(this).parents('.super-elements-container:eq(0)').children('.tab-content').removeClass('active');
            $(this).parents('.super-elements-container:eq(0)').children('.tab-content:eq('+($(this).val())+')').addClass('active');
        });
        
        $doc.on('click','.super-multi-items .add',function(){
            var $this = $(this);
            var $parent = $this.parents('.field-input:eq(0)');
            var $item = $parent.children('.super-multi-items:eq(0)').clone();
            var $item = $item.insertAfter($parent.find('.super-multi-items').last());
            $item.find('.initialized').removeClass('initialized');
            $parent.find('.super-multi-items').last().find('input[type="radio"]').prop('checked', false);
            if($parent.find('.super-multi-items').length > 1){
                $parent.find('.delete').css('visibility','');
            }else{
                $parent.find('.delete').css('visibility','hidden');
            }
            SUPER.init_image_browser();
        });    

        $doc.on('click','.super-multi-items .delete',function(){
            var $this = $(this);
            var $parent = $this.parents('.field-input:eq(0)');
            if($parent.find('.super-multi-items').length <= 2){
                $parent.find('.delete').css('visibility','hidden');
            }else{
                $parent.find('.delete').css('visibility','');
            }
            $(this).parent().remove();
        }); 
        
        $doc.on('click','.super-element-settings .update-element',function(){
            var $button = $(this);
            $button.addClass('loading');
            $(this).parents('.super-elements-container:eq(0)').find('.super-multi-items').each(function(){
                SUPER.update_multi_items($(this));
            });
            var $fields = {};
            $('.super-element-settings .element-field').each(function(){
                var $this = $(this);
                var $name = $this.attr('name');
                var $value = $this.val();
                if($this.parents('.field-input:eq(0)').find('.super-multi-items').length){
                    $fields[$name] = $.parseJSON($value);   
                }else{
                    $fields[$name] = $value;
                }
            });
            if( (typeof $fields['name'] !== 'undefined') && ($fields['name']=='') ){
                $button.removeClass('loading');
                $('.super-element-settings .element-field[name="name"]').css('border','1px solid #ff9898').css('background-color', '#ffefef');
                alert(super_create_form_i18n.alert_empty_field_name);
                return false;
            }
            $('.super-element-settings .element-field[name="name"]').css('border','').css('background-color', '');

            var $value = JSON.stringify($fields);
            
            var $element = $('.super-element.editing');
            $element.children('textarea[name="element-data"]').val($value);

            var $tag = $element.data('shortcode-tag');
            var $group = $element.data('group');

            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action: 'super_get_element_builder_html',
                    tag: $tag,
                    group: $group,
                    builder: 0,
                    data: $fields,
                    form_id: $('input[name="form_id"]').val()
                },
                success: function (data) {
                    if( $element.children('.super-element-inner').hasClass('super-dropable') ) {
                        $shortcode = $element.children('.super-element-inner').children('.super-shortcode')
                        $(data).insertAfter($shortcode);
                        $shortcode.remove();
                    }else{
                        $element.children('.super-element-inner').html(data);
                    }
                },
                complete: function() {
                    if($tag=='column'){
                        var $sizes = {
                            '1/1':'super_one_full',
                            '4/5':'super_four_fifth',
                            '3/4':'super_three_fourth',
                            '2/3':'super_two_third',
                            '3/5':'super_three_fifth',
                            '1/2':'super_one_half',
                            '2/5':'super_two_fifth',
                            '1/3':'super_one_third',
                            '1/4':'super_one_fourth',
                            '1/5':'super_one_fifth'
                        };
                        $element.attr('class', 'super-element drop-here '+$sizes[$fields['size']]+' editing');
                        $element.attr('data-size', $fields['size']).find('.super-element-header .resize .current').html($fields['size']);
                    }
                    SUPER.regenerate_element_inner($('.super-preview-elements'), '', 1);        
                    SUPER.init_skype();
                    SUPER.init_tooltips();
                    SUPER.init_datepicker();
                    SUPER.init_masked_input();
                    SUPER.init_currency_input();
                    SUPER.init_colorpicker();
                    SUPER.init_slider_field();
                    SUPER.init_button_colors();
                    SUPER.init_text_editors();
                    $button.removeClass('loading');
                }
            });
            //$('.super-element.editing .super-element-inner .super-shortcode');
        });
        
        function cancel_update(){
            $('.super-preview-elements .super-element').removeClass('editing');
            $('.super-element.super-element-settings .super-elements-container').html('<p>'+super_create_form_i18n.not_editing_an_element+'</p>');
        }

        $doc.on('click','.super-element-settings .cancel-update',function(){
            cancel_update();
        });
        
        $doc.on('change click blur keyup keydown focus', '.super-multi-items *',function(){
            SUPER.update_multi_items($(this));
        });

        $doc.on('click', '.super-checkbox input[type="checkbox"]',function(){
            var $this = $(this);
            var $parent = $this.parents('.super-checkbox:eq(0)');
            var $field = $parent.parent().children('.element-field');
            var $selected = '';
            var $counter = 0;
            $parent.find('input[type="checkbox"]').each(function(){
                if($(this).prop('checked')==true){
                    if($counter==0){
                        $selected += $(this).val();
                    }else{
                        $selected += ','+$(this).val();
                    }
                    $counter++;
                }
            });
            $field.val($selected);
        });
        
        $doc.on('click','.super-multi-items.super-dropdown-item .sorting span.up i',function(){
            var $parent = $(this).parents('.field-input:eq(0)');
            var $count = $parent.find('.super-multi-items').length;
            if($count>1){
                var $this = $(this).parents('.super-multi-items:eq(0)');
                var $prev = $this.prev();
                var $index = $this.index();
                if($index>0){
                    $this.insertBefore($prev);
                }else{
                    $this.insertAfter($parent.find('.super-multi-items').last());
                }
            }
        });

        $doc.on('click','.super-multi-items.super-dropdown-item .sorting span.down i',function(){
            var $parent = $(this).parents('.field-input:eq(0)');
            var $count = $parent.find('.super-multi-items').length;
            if($count>1){
                var $this = $(this).parents('.super-multi-items:eq(0)');
                var $next = $this.next();
                var $index = $this.index();
                if($index+1 == $count){
                    $this.insertBefore($parent.find('.super-multi-items').first());
                }else{
                    $this.insertAfter($next);
                }
            }
        });

        $doc.on('click','.super-multi-items.super-dropdown-item input[type="checkbox"]',function(){
            var $prev = $(this).attr('data-prev');
            if($prev=='true'){
                $(this).prop('checked', false).attr('data-prev','false');
            }else{
                $(this).prop('checked', true).attr('data-prev','true');
            }
        });

        $doc.on('click','.super-multi-items.super-dropdown-item input[type="radio"]',function(){
            var $prev = $(this).attr('data-prev');
            $(this).parents('.field-input:eq(0)').find('input[type="radio"]').prop('checked',false).attr('data-prev','false');
            if($prev=='true'){
                $(this).prop('checked', false).attr('data-prev','false');
            }else{
                $(this).prop('checked', true).attr('data-prev','true');
            }
        });

        $doc.on('click','.super-elements .super-element h3',function(){
            $(this).parent().children('.super-elements-container').slideToggle();
            $(this).parent().siblings().children().next('.super-elements-container').slideUp();
            return false;
        });
        
        $doc.on('click','.super-create-form .super-actions .clear',function(){
            var $clear = confirm(super_create_form_i18n.confirm_clear_form);
            if($clear == true) {
                $('.super-debug textarea[name="_super_elements"]').val('');
                $('.super-preview-elements').html('');
                $('.super-element.super-element-settings .super-elements-container').html('<p>'+super_create_form_i18n.not_editing_an_element+'</p>');
            }
        });

        $doc.on('click','.super-create-form .super-actions .delete',function(){
            var $delete = confirm(super_create_form_i18n.confirm_deletion);
            if($delete == true) {
                var $this = $(this);
                $this.html('<i class="fa fa-trash-o"></i>'+super_create_form_i18n.deleting);
                $.ajax({
                    type: 'post',
                    url: ajaxurl,
                    data: {
                        action: 'super_delete_form',
                        id: $('.super-create-form input[name="form_id"]').val(),
                    },
                    success: function (data) {
                        $this.html('<i class="fa fa-check"></i>Deleted!');
                        window.location.href = "edit.php?post_type=super_form";
                    }
                }); 
            }
        });

        $doc.on('click','.super-load-form .load-form',function(){
            var $confirm = confirm(super_create_form_i18n.confirm_load_form);
            if($confirm == true) {
                var $parent = $(this).parent();
                var $value = $('select[name="super-forms"]').val();
                if($value==''){
                    alert(super_create_form_i18n.alert_select_form);
                }else{
                    if(($value%1)===0) {
                        $.ajax({
                            type: 'post',
                            url: ajaxurl,
                            data: {
                                action: 'super_load_form',
                                id: $('select[name="super-forms"]').val(),
                            },
                            success: function (data) {
                                $('textarea[name="_super_elements"]').val(data);
                                SUPER.regenerate_element_inner(2);
                            }
                        });
                    }else{
                        $html = $parent.find('textarea[name="'+$value+'"]').val();
                        $('.super-debug textarea[name="_super_elements"]').html($html);
                        SUPER.regenerate_element_inner(2);
                    }
                }
            }
            return false;
        });    
        

        $doc.on('click','.super-element-actions .edit',function(){
            var $parent = $(this).parents('.super-element:eq(0)');
            if($parent.hasClass('editing')){
                return false;
            }
            var $data = $parent.children('textarea[name="element-data"]').val();
            var $tag = $parent.data('shortcode-tag');
            var $group = $parent.data('group');
            var $data = JSON.parse($data);
            if($tag=='column'){
                $data.size = $parent.attr('data-size');
            }
            var $target = $('.super-element-settings > .super-elements-container');
            $target.html('');
            $('.super-preview-elements .super-element').removeClass('editing');
            $parent.addClass('editing');
            $('.super-element .super-elements-container').slideUp();
            $('.super-element.super-element-settings').siblings().children().next('.super-elements-container').slideUp();
            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action: 'super_load_element_settings',
                    tag: $tag,
                    group: $group,
                    data: $data,
                },
                success: function (data) {
                    $target.html(data);
                    init_form_settings_container_heights();
                },
                complete: function () {
                    SUPER.init_previously_created_fields();
                    SUPER.init_slider_field();
                    SUPER.init_tooltips();
                    SUPER.init_image_browser();
                    SUPER.init_color_pickers();
                    $('.super-element .super-elements-container').slideUp();
                    $('.super-element.super-element-settings .super-elements-container').slideDown();
                    SUPER.init_field_filter_visibility();
                }
            });
            return false;
        });
        
        $doc.on('click','.super-create-form .super-actions .save',function(){
            var $this = $(this);
            SUPER.save_form($this);
        });

        $doc.on('click','.super-create-form .super-actions .preview',function(){
            var $this = $('.super-create-form .super-actions .preview:eq(3)');
            if($(this).hasClass('mobile')){
                $('.super-live-preview').removeClass('tablet');
                $('.super-create-form .super-actions .preview.tablet').removeClass('active');
                $('.super-create-form .super-actions .preview.desktop').removeClass('active');    
                $(this).addClass('active');
                $('.super-live-preview').addClass('mobile');
                if(!$this.hasClass('active')){
                    $this.html('Loading...');
                    SUPER.save_form($('.super-actions .save'), 1);
                }
                SUPER.init_super_responsive_form_fields();
                return false;
            }
            if($(this).hasClass('tablet')){
                $('.super-live-preview').removeClass('mobile');
                $('.super-create-form .super-actions .preview.mobile').removeClass('active');
                $('.super-create-form .super-actions .preview.desktop').removeClass('active');
                $(this).addClass('active');
                $('.super-live-preview').addClass('tablet');
                if(!$this.hasClass('active')){
                    $this.html('Loading...');
                    SUPER.save_form($('.super-actions .save'), 1);
                }
                SUPER.init_super_responsive_form_fields();
                return false;
            }
            if($(this).hasClass('desktop')){
                $('.super-live-preview').removeClass('tablet');
                $('.super-live-preview').removeClass('mobile');
                $('.super-create-form .super-actions .preview.mobile').removeClass('active');
                $('.super-create-form .super-actions .preview.tablet').removeClass('active');
                $(this).addClass('active');
                if(!$this.hasClass('active')){
                    $this.html('Loading...');
                    SUPER.save_form($('.super-actions .save'), 1);
                }
                SUPER.init_super_responsive_form_fields();
                return false;
            } 
            if(!$this.hasClass('active')){
                $this.html('Loading...');
                SUPER.save_form($('.super-actions .save'), 1);
            }else{
                $('.super-live-preview').css('display','none');
                $('.super-preview-elements').css('display','block');
                $this.html('Preview').removeClass('active');
            }
        });


        // @since 3.4.0 - reset submission counter
        $doc.on('click','.reset-submission-counter', function(){
            var $button = $(this);
            $button.addClass('loading');
            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action: 'super_reset_submission_counter',
                    counter: $('.super-create-form input[name="form_locker_submission_reset"]').val(),
                    id: $('.super-create-form input[name="form_id"]').val()
                },
                complete: function(){
                    $button.removeClass('loading');
                }
            });
        });
        

        // @since   1.0.6
        $doc.on('focus','.super-get-form-shortcodes, .super-export-import textarea[name="export-json"]',function(){
            var $this = $(this);
            $this.select();

            // Work around Chrome's little problem
            $this.mouseup(function() {
                // Prevent further mouseup intervention
                $this.unbind("mouseup");
                return false;
            });
        });
        $doc.on('click','.super-export-import .import-settings, .super-export-import .load-default-settings',function(){
            var $method = 'import';
            var $button = $(this);
            var $settings = $('.super-export-import textarea[name="import-json"]').val();
            $button.addClass('loading');
            if($button.hasClass('load-default-settings')){
                $method = 'load-default-form-settings';
            }
            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action: 'super_import_settings',
                    title: $('.super-create-form input[name="title"]').val(),
                    shortcode: $('.super-create-form textarea[name="_super_elements"]').val(),
                    id: $('.super-create-form input[name="form_id"]').val(),
                    settings: $settings,
                    method: $method
                },
                success: function(data){
                    var href = window.location.href;
                    var page = href.substr(href.lastIndexOf('/') + 1);
                    var str2 = "admin.php?page=super_create_form&id";
                    if(page.indexOf(str2) == -1){
                        window.location.href = "admin.php?page=super_create_form&id="+data;
                    }else{
                        location.reload();
                    }
                },
                complete: function(){
                    $button.removeClass('loading');
                }
            });
        });

        // @since   1.0.6
        var $window = $(window).outerHeight(true);
        var $header = $('.super-header').outerHeight(true);
        var $viewport = $window-$header;    
        var $offset = $('.super-create-form .super-elements').offset().top;
        var $elements = $('.super-create-form .super-elements');
        var timer;
        $(window).on('load scroll resize', function() {
            var $width = $elements.outerWidth(true);
            init_form_settings_container_heights();
            var $window_width = $(window).outerWidth(true);
            if($window_width >= 983){ 
                var $scroll = $(window).scrollTop(); 
                if($scroll > 40){
                    $('.super-create-form .super-elements').css('max-width', $width+'px');
                    $('.super-create-form').addClass('sticky');
                }else{
                    $('.super-create-form .super-elements').css('max-width','');
                    $('.super-create-form').removeClass('sticky');
                }
            }else{
                $('.super-create-form .super-elements').css('max-width','');
                $('.super-create-form').removeClass('sticky');
            }
        });
        function init_form_settings_container_heights(){
            var $window_height = $(window).outerHeight(true);
            var $wp_admin_bar = $('#wpadminbar').outerHeight(true) + 55;
            var $offset_top = $('.super-create-form').offset().top;
            var $tabs_height = 0;
            var $container_padding = 50;
            var $settings_tab = 20;
            $('.super-create-form .super-elements > .super-element h3').each(function(){
                $tabs_height = $(this).outerHeight(true) + $tabs_height;  
            });
            var $max_height = $window_height - $tabs_height - $wp_admin_bar - $offset_top;
            $('.super-element-settings > .super-elements-container > .tab-content').css('max-height',$max_height-$settings_tab-$container_padding);
            $('.super-form-settings > .super-elements-container > .tab-content').css('max-height',$max_height-$settings_tab-$container_padding);
            $('.super-form-elements > .super-elements-container').css('max-height',$max_height); 
            $('.super-shortcode-fields .tabs_content').css('max-height',($window_height/2));  
        }
    });
})(jQuery);