<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly
}

echo '= ' . wp_kses_post( $email_heading ) . ' =</br>' ;

/* translators: 1: subscription number */
printf( wp_kses_post( __( 'Your Subscription #%s is currently Paused', 'sumosubscriptions' ) ), esc_html( sumo_get_subscription_number( $post_id ) ) );

if ( ! empty( $_REQUEST[ 'auto_resume_on' ] ) ) {
	/* translators: 1: resume scheduled date */
	printf( wp_kses_post( __( ' your Subscription will be automatically resume on %s.', 'sumosubscriptions' ) ), esc_html( wc_clean( wp_unslash( $_REQUEST[ 'auto_resume_on' ] ) ) ) ) ;
}

echo "\n\n" ;

echo "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n" ;

do_action( 'woocommerce_email_before_order_table', $order, $sent_to_admin, $plain_text, $email ) ;

echo esc_html__( 'Subscription Details are shown below for your reference', 'sumosubscriptions' ) . "\n" ;

/* translators: 1: subscription number */
echo sprintf( wp_kses_post( __( 'Subscription #%s', 'sumosubscriptions' ) ), esc_html( sumo_get_subscription_number( $post_id ) ) ) . '</br>';

echo '(' . esc_html( date_i18n( __( 'jS F Y', 'sumosubscriptions' ), strtotime( $order->get_date_created() ) ) ) . ')</br>' ;

do_action( 'woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text, $email ) ;

echo "\n" ;

do_action( 'sumosubscriptions_email_order_details', $order, $post_id, $email ) ;

echo "==========\n\n" ;

do_action( 'sumosubscriptions_email_order_meta', $order, $post_id, $email, true ) ;

echo "\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n" ;

do_action( 'woocommerce_email_after_order_table', $order, $sent_to_admin, $plain_text, $email ) ;

do_action( 'woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email ) ;

echo "\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n" ;

echo wp_kses_post( apply_filters( 'woocommerce_email_footer_text', get_option( 'woocommerce_email_footer_text' ) ) ) ;
