<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly
}

echo '= ' . wp_kses_post( $email_heading ) . ' =</br>' ;

/* translators: 1: blog name */
echo sprintf( wp_kses_post( __( 'Hi,<br> Your recent Subscription order on %s has been Completed. Your order details are shown below for your reference', 'sumosubscriptions' ) ), esc_html( get_option( 'blogname' ) ) ) . "\n\n" ;

echo "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n" ;

do_action( 'woocommerce_email_before_order_table', $order, $sent_to_admin, $plain_text, $email ) ;

if ( sumosubs_is_parent_order( $order ) && doing_action( 'woocommerce_order_status_changed' ) ) {
	/* translators: 1: order number */
	echo sprintf( wp_kses_post( __( 'Order #%s', 'sumosubscriptions' ) ), esc_html( $order->get_id() ) ) . "\n";
} else {
	/* translators: 1: subscription number */
	echo sprintf( wp_kses_post( __( 'Subscription #%s', 'sumosubscriptions' ) ), esc_html( sumo_get_subscription_number( $post_id ) ) ) . '</br>';
}

echo '(' . esc_html( date_i18n( __( 'jS F Y', 'sumosubscriptions' ), strtotime( $order->get_date_created() ) ) ) . ')</br>' ;

do_action( 'woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text, $email ) ;

echo "\n" ;

do_action( 'sumosubscriptions_email_order_details', $order, $post_id, $email ) ;

echo "==========\n\n" ;

do_action( 'sumosubscriptions_email_order_meta', $order, $post_id, $email, true ) ;

echo "\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n" ;

do_action( 'woocommerce_email_after_order_table', $order, $sent_to_admin, $plain_text, $email ) ;

do_action( 'woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email ) ;

echo "\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n" ;

echo wp_kses_post( apply_filters( 'woocommerce_email_footer_text', get_option( 'woocommerce_email_footer_text' ) ) ) ;
