<?php

declare(strict_types = 1);

/**
 * Class SUMOSubs_WC_PayPal_Payments_Trial_Handler
 */
trait SUMOSubs_WC_PayPal_Payments_Trial_Handler {

    /**
     * Checks if the cart contains only free trial.
     *
     * @return bool
     */
    protected function is_free_trial_cart(): bool {
        $cart = WC()->cart;
        if ( ! $cart || $cart->is_empty() || ( float ) $cart->get_total( 'numeric' ) > 0 ) {
            return false;
        }

        foreach ( $cart->get_cart() as $item ) {
            $product = $item[ 'data' ] ?? null;
            if ( $product && sumo_is_subscription_product( $product->get_id() ) ) {
                return true;
            }
        }

        return false;
    }

    /**
     * Checks if the current product contains free trial.
     *
     * @return bool
     */
    protected function is_free_trial_product(): bool {

        $product = wc_get_product();

        if ( ! $product || ! sumo_is_subscription_product( $product->get_id() ) ) {
            return false;
        }

        if ( sumo_subscription_has_free_trial( 0, $product->get_id() ) || SUMOSubs_Synchronization::is_subscription_synced( $product ) ) {
            return true;
        }

        return false;
    }

    /**
     * Checks if the given order contains only free trial.
     *
     * @param object $wc_order The WooCommerce order.
     * @return bool
     */
    protected function is_free_trial_order( $wc_order ): bool {
        if ( ( float ) $wc_order->get_total( 'numeric' ) > 0 ) {
            return false;
        }

        $subs = sumo_order_contains_subscription( $wc_order );

        return ! empty( $subs );
    }
}
