<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

/**
 * Handle subscription background process.
 * 
 * @class SUMOSubs_Legacy_Background_Process
 */
class SUMOSubs_Legacy_Background_Process {

    /**
     * Cron Interval in Seconds.
     * 
     * @var int
     */
    private static $cron_interval = 300;

    /**
     * Cron hook identifier
     *
     * @var mixed
     */
    protected static $cron_hook_identifier;

    /**
     * Cron interval identifier
     *
     * @var mixed
     */
    protected static $cron_interval_identifier;

    /**
     * Init SUMOSubs_Legacy_Background_Process
     */
    public static function init() {
        self::$cron_hook_identifier     = 'sumosubscriptions_background_updater';
        self::$cron_interval_identifier = 'sumosubscriptions_cron_interval';
        self::schedule_event();

        add_action( self::$cron_hook_identifier, __CLASS__ . '::run' );
    }

    /**
     * Schedule event
     */
    public static function schedule_event() {
        //may be preventing the recurrence Cron interval not to be greater than 300
        if ( ( wp_next_scheduled( self::$cron_hook_identifier ) - sumo_get_subscription_timestamp() ) > self::$cron_interval ) {
            wp_clear_scheduled_hook( self::$cron_hook_identifier );
        }

        //Schedule Recurrence Cron job
        if ( ! wp_next_scheduled( self::$cron_hook_identifier ) ) {
            wp_schedule_event( sumo_get_subscription_timestamp() + self::$cron_interval, self::$cron_interval_identifier, self::$cron_hook_identifier );
        }
    }

    /**
     * Fire when recurrence Cron gets Elapsed
     * 
     * Background process.
     */
    public static function run() {
        $crons = sumosubscriptions()->query->get( array(
            'type'   => 'sumosubs_cron_events',
            'status' => 'publish',
                ) );

        if ( empty( $crons ) ) {
            return;
        }

        //Loop through each Cron Event Query post and check whether time gets elapsed
        foreach ( $crons as $cron_id ) {
            $cron_events = get_post_meta( $cron_id, '_sumo_subscription_cron_events', true );
            if ( ! is_array( $cron_events ) ) {
                continue;
            }

            foreach ( $cron_events as $subscription_id => $events ) {
                foreach ( $events as $_event_name => $args ) {
                    if ( ! is_array( $args ) ) {
                        continue;
                    }

                    foreach ( $args as $event_timestamp => $event_args ) {
                        if ( ! is_int( $event_timestamp ) || ! $event_timestamp ) {
                            continue;
                        }

                        if ( sumo_get_subscription_timestamp() >= $event_timestamp ) {
                            $action_args = array_merge( array(
                                'subscription_id' => $subscription_id,
                                    ), $event_args );

                            switch ( $_event_name ) {
                                case 'start_subscription':
                                    SUMOSubs_Background_Process::subscription_activation( $action_args );
                                    break;
                                case 'automatic_resume':
                                    SUMOSubs_Background_Process::subscription_reactivation( $action_args );
                                    break;
                                case 'create_renewal_order':
                                    SUMOSubs_Background_Process::subscription_due_order_creation( $action_args );
                                    break;
                                case 'automatic_pay':
                                case 'retry_automatic_pay_in_overdue':
                                case 'retry_automatic_pay_in_suspended':
                                    SUMOSubs_Background_Process::subscription_due_payment_automatic( $action_args );
                                    break;
                                case 'notify_invoice_reminder':
                                case 'notify_expiry_reminder':
                                    SUMOSubs_Background_Process::subscription_reminder( $action_args );
                                    break;
                                case 'notify_overdue':
                                    SUMOSubs_Background_Process::subscription_overdue( $action_args );
                                    break;
                                case 'notify_suspend':
                                    SUMOSubs_Background_Process::subscription_suspend( $action_args );
                                    break;
                                case 'notify_cancel':
                                    SUMOSubs_Background_Process::subscription_cancel( $action_args );
                                    break;
                                case 'notify_expire':
                                    SUMOSubs_Background_Process::subscription_expiration( $action_args );
                                    break;
                            }

                            //Refresh post.
                            $cron_events = get_post_meta( $cron_id, '_sumo_subscription_cron_events', true );

                            //Clear the Event when the corresponding Subscription Event Hook gets fired.
                            if ( isset( $cron_events[ $subscription_id ][ $_event_name ][ $event_timestamp ] ) ) {
                                unset( $cron_events[ $subscription_id ][ $_event_name ][ $event_timestamp ] );
                            }
                        }
                    }
                    //Flush the meta once the timestamp is not available for the specific Event
                    if ( isset( $cron_events[ $subscription_id ][ $_event_name ] ) && empty( $cron_events[ $subscription_id ][ $_event_name ] ) ) {
                        unset( $cron_events[ $subscription_id ][ $_event_name ] );
                    }
                }
            }
            //Get updated post.
            if ( is_array( $cron_events ) ) {
                update_post_meta( $cron_id, '_sumo_subscription_cron_events', $cron_events );
            }
        }
    }
}
