/* global sumosubs_order_subscription_params */

jQuery(function ($) {
    // sumosubs_order_subscription_params is required to continue, ensure the object exists
    if (typeof sumosubs_order_subscription_params === 'undefined') {
        return false;
    }

    var is_blocked = function ($node) {
        return $node.is('.processing') || $node.parents('.processing').length;
    };

    /**
     * Block a node sumosubs-order-subsription for processing.
     *
     * @param {JQuery Object} $node
     */
    var block = function ($node) {
        if (!is_blocked($node)) {
            $node.addClass('processing').block({
                message: null,
                overlayCSS: {
                    background: '#fff',
                    opacity: 0.6
                }
            });
        }
    };

    /**
     * Unblock a node after processing is complete.
     *
     * @param {JQuery Object} $node
     */
    var unblock = function ($node) {
        $node.removeClass('processing').unblock();
    };

    var order_subscription = {
        /**
         * Manage edit order page events.
         */
        init: function () {
            this.onPageLoad();

            $(document).on('change', '#sumosubs_manual_order_subscribed', this.toggleManualOrderSubscription);
            $(document).on('change', '#sumosubs_manual_order_duration', this.toggleOrderSubscriptionDuration);
            // Validate manual order subscription
            $(document).on('click', '.save_order', this.validate_create_order_subscription);
        },
        onPageLoad: function () {
            this.mayBeDisplayOrderSubscription();
        },
        toggleManualOrderSubscription: function (evt) {
            evt.preventDefault();
            order_subscription.mayBeDisplayOrderSubscription();
            var $this = $(evt.currentTarget);
            var wrapper = $('#sumosubscription_order_subscription_creation');
            block(wrapper);
            $.ajax({
                type: 'POST',
                url: sumosubs_order_subscription_params.wp_ajax_url,
                data: {
                    action: 'sumosubscription_subscribe_to_order_manual',
                    security: sumosubs_order_subscription_params.subscribe_to_order_manual_nonce,
                    order_id: $('#post_ID').val(),
                    is_subscribed: $($this).is(':checked'),
                },
                success: function (response) {
                    if (response.success) {
                        $('#woocommerce-order-items').trigger('wc_order_items_reload');
                    } else if (response.data.error) {
                        window.alert(response.data.error);
                        $($this).prop('checked', false);
                        order_subscription.mayBeDisplayOrderSubscription();
                    }

                    unblock(wrapper);
                }
            });
            return false;
        },
        toggleOrderSubscriptionDuration: function (evt) {
            evt.preventDefault();
            var $elements = $('#sumosubs_manual_order_duration_value');
            $elements.empty();

            switch ($(evt.currentTarget).val()) {
                case 'W':
                    duration_options = sumosubs_order_subscription_params.subscription_week_duration_options;
                    break;
                case 'M':
                    duration_options = sumosubs_order_subscription_params.subscription_month_duration_options;
                    break;
                case 'Y':
                    duration_options = sumosubs_order_subscription_params.subscription_year_duration_options;
                    break;
                default:
                    duration_options = sumosubs_order_subscription_params.subscription_day_duration_options;
                    break;
            }

            $.each(duration_options, function (value, key) {
                $elements.append($('<option></option>').attr('value', value).text(key));
            });
        },
        mayBeDisplayOrderSubscription: function () {
            $('.sumosubs_manual_order_duration_value_field').slideUp();
            $('.sumosubs_manual_order_recurring_field').slideUp();

            if ($('#sumosubs_manual_order_subscribed').is(':checked')) {
                $('.sumosubs_manual_order_duration_value_field').slideDown();
                $('.sumosubs_manual_order_recurring_field').slideDown();
            }
        },
        validate_create_order_subscription: function (event) {          
            if (!$('#sumosubs_manual_order_subscribed').is(':checked')) {
                return true;
            }

            event.preventDefault();

            var wrapper = $('#woocommerce-order-items'),
                $this = $(this);
            block(wrapper);

            $.ajax({
                type: 'POST',
                url: sumosubs_order_subscription_params.wp_ajax_url,
                data: {
                    action: 'sumosubscription_validate_manual_order_subscription_creation',
                    security: sumosubs_order_subscription_params.validate_manual_order_creation_nonce,
                    order_id: $('#post_ID').val(),
                    customer_id: $('#customer_user').val(),
                },
                success: function (response) {
                    if (response.success) {
                        $this.closest('form').submit();
                    } else if (response.data.error) {
                        window.alert(response.data.error);
                    }

                    unblock(wrapper);
                }
            });
            return false;
        },
    };
    order_subscription.init();
});
