<?php

// Integrate WP List Table for Users for Viewing Log

if (!class_exists('WP_List_Table')) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

class WP_List_Table_for_View_Log extends WP_List_Table {

    // Prepare Items
    public function prepare_items() {
        $columns = $this->get_columns();
        $hidden = $this->get_hidden_columns();
        $sortable = $this->get_sortable_columns();

        $data = $this->table_data();

        if (isset($_REQUEST['s'])) {
            $searchvalue = $_REQUEST['s'];
            $keyword = "/$searchvalue/";

            $newdata = array();
            foreach ($data as $eacharray => $value) {
                $searchfunction = preg_grep($keyword, $value);
                if (!empty($searchfunction)) {
                    $newdata[] = $data[$eacharray];
                }
            }
            usort($newdata, array(&$this, 'sort_data'));

            $perPage = 10;
            $currentPage = $this->get_pagenum();
            $totalItems = count($newdata);

            $this->set_pagination_args(array(
                'total_items' => $totalItems,
                'per_page' => $perPage
            ));

            $newdata = array_slice($newdata, (($currentPage - 1) * $perPage), $perPage);

            $this->_column_headers = array($columns, $hidden, $sortable);

            $this->items = $newdata;
        } else {
            usort($data, array(&$this, 'sort_data'));

            $perPage = 10;
            $currentPage = $this->get_pagenum();
            $totalItems = count($data);

            $this->set_pagination_args(array(
                'total_items' => $totalItems,
                'per_page' => $perPage
            ));

            $data = array_slice($data, (($currentPage - 1) * $perPage), $perPage);

            $this->_column_headers = array($columns, $hidden, $sortable);

            $this->items = $data;
        }
    }

    public function get_columns() {
        $columns = array(
            'sno' => __('S.No', 'rewardsystem'),
            'user_name' => __('User Name', 'rewardsystem'),
            'reward_for' => __('Reward for', 'rewardsystem'),
            'earned_points' => __('Earned Points', 'rewardsystem'),
            'redeemed_points' => __('Redeemed Points', 'rewardsystem'),
            'total_points' => __('Total Points', 'rewardsystem'),
            'log_date' => __('Date', 'rewardsystem'),
        );

        return $columns;
    }

    public function get_hidden_columns() {
        return array();
    }

    public function get_sortable_columns() {
        return array('user_name' => array('user_name', false),
            'sno' => array('sno', false),
            'redeemed_points' => array('redeemed_points', false),
            'earned_points' => array('earned_points', false),
            'log_date' => array('log_date', false),
            'total_points' => array('total_points', false),
        );
    }

    private function table_data() {
        $data = array();
        $i = 1;
        $roundofftype = get_option('rs_round_off_type') == '1' ? '2' : '0';

        $user_ID = $_GET['view'];
        $getuserbyid = get_user_by('id', $user_ID);
        $fetcharray = get_user_meta($user_ID, '_my_points_log', true);

        if (is_array($fetcharray)) {
            foreach ($fetcharray as $newarray) {

                if (is_array($newarray)) {
                    if (!empty($newarray['points_earned_order'])) {
                         if (get_option('rs_round_off_type') == '1') {
                            $pointsearned = $newarray['points_earned_order'];
                        } else {
                            $pointsearned = number_format($newarray['points_earned_order']);
                        }
                    } else {
                        $pointsearned = "0";
                    }

                    if (!empty($newarray['before_order_points'])) {
                        if (is_float($newarray['before_order_points'])) {
                            $beforepoints = number_format($newarray['before_order_points'], 2);
                        } else {
                            $beforepoints = number_format($newarray['before_order_points']);
                        }
                    } else {
                        $beforepoints = "0";
                    }

                    if (!empty($newarray['points_redeemed'])) {
                         if (get_option('rs_round_off_type') == '1') {
                            $redeemedpoints = $newarray['points_redeemed'];
                        } else {
                            $redeemedpoints = number_format((float) $newarray['points_redeemed']);
                        }
                    } else {
                        $redeemedpoints = "0";
                    }
                    if (!empty($newarray['totalpoints'])) {
                        if (get_option('rs_round_off_type') == '1') {
                            $totalpoints = $newarray['totalpoints'];
                        } else {
                            $totalpoints = number_format($newarray['totalpoints']);
                        }
                    } else {
                        $totalpoints = "0";
                    }

                    $usernickname = get_user_meta($newarray['userid'], 'nickname', true);
                    if (!empty($newarray['rewarder_for'])) {
                        $rewarderfor = $newarray['rewarder_for'];
                    } else {
                        $rewarderfor = '';
                    }


                    $data[] = array(
                        'sno' => $i,
                        'user_name' => $getuserbyid->user_login,
                        'reward_for' => $rewarderfor,
                        'earned_points' => $pointsearned,
                        'redeemed_points' => $redeemedpoints,
                        'total_points' => $totalpoints,
                        'log_date' => $newarray['date'],
                    );
                    $i++;
                }
            }
        }


        //var_dump($data);
        return $data;
    }

    public function column_id($item) {
        return $item['sno'];
    }

    public function column_default($item, $column_name) {
        switch ($column_name) {
            case 'sno':
            case 'user_name':
            case 'reward_for':
            case 'earned_points':
            case 'redeemed_points':
            case 'total_points':
            case 'log_date':

                return $item[$column_name];

            default:
                return print_r($item, true);
        }
    }

    private function sort_data($a, $b) {

        $orderby = 'sno';
        $order = 'asc';

        if (!empty($_GET['orderby'])) {
            $orderby = $_GET['orderby'];
        }

        if (!empty($_GET['order'])) {
            $order = $_GET['order'];
        }

        $result = strnatcmp($a[$orderby], $b[$orderby]);

        if ($order === 'asc') {
            return $result;
        }

        return -$result;
    }

}
