<?php

class FPRewardSystemReferralRewardLog {

    public static function reward_system_tab_settings($settings_tabs) {
        $settings_tabs['rewardsystem_referral_log'] = __('Referral Rewards Table', 'rewardsystem');
        return $settings_tabs;
    }

    // Add Admin Fields in the Array Format

    /**
     * RewardSystem Add Custom Field to the RewardSystem Admin Settings
     */
    public static function rewardsystem_admin_fields() {
        return apply_filters('woocommerce_rewardsystem_userpoints_settings', array(
            array(
                'type' => 'display_referral_reward_log',
            ),
        ));
    }

    public static function list_referral_rewards_log() {
        ?>
        <style type="text/css">
            p.submit {
                display:none;
            }
            #mainforms {
                display:none;
            }
        </style>
        <?php
        if ((!isset($_GET['view']))) {
            $newwp_list_table_for_users = new WP_List_Table_for_Referral_Table();
            $newwp_list_table_for_users->prepare_items();
            $newwp_list_table_for_users->search_box('Search', 'search_id');
            $newwp_list_table_for_users->display();
        } else {

            $newwp_list_table_for_users = new WP_List_Table_for_View_Referral_Table();
            $newwp_list_table_for_users->prepare_items();
            $newwp_list_table_for_users->search_box('Search', 'search_id');
            $newwp_list_table_for_users->display();
            ?>


            <a href="<?php echo esc_url_raw(remove_query_arg(array('view'), get_permalink())); ?>">Go Back</a>
            <?php
        }
    }

    /**
     * Registering Custom Field Admin Settings of RewardSystem in woocommerce admin fields funtion
     */
    public static function reward_system_register_admin_settings() {
        woocommerce_admin_fields(FPRewardSystemReferralRewardLog::rewardsystem_admin_fields());
    }

    /**
     * Update the Settings on Save Changes may happen in RewardSystem
     */
    public static function reward_system_update_settings() {
        woocommerce_update_options(FPRewardSystemReferralRewardLog::rewardsystem_admin_fields());
    }

    /**
     * Initialize the Default Settings by looping this function
     */
    public static function reward_system_default_settings() {
        global $woocommerce;
        foreach (FPRewardSystemReferralRewardLog::rewardsystem_admin_fields() as $setting)
            if (isset($setting['newids']) && ($setting['std'])) {
                add_option($setting['newids'], $setting['std']);
            }
    }

}

new FPRewardSystemReferralRewardLog();



/* * ***************************************************************************************
 * ***************Essential Stuff to Register the New Tabs in WooCommerce*******************
 * *****************************************************************************************
 */

add_action('woocommerce_admin_field_display_referral_reward_log', array('FPRewardSystemReferralRewardLog', 'list_referral_rewards_log'));

// Add Filter for WooCommerce Update Options Reward System
add_filter('woocommerce_rs_settings_tabs_array', array('FPRewardSystemReferralRewardLog', 'reward_system_tab_settings'), 150);

// call the woocommerce_update_options_{slugname} to update the reward system
add_action('woocommerce_update_options_rewardsystem_referral_log', array('FPRewardSystemReferralRewardLog', 'reward_system_update_settings'));

// call the init function to update the default settings on page load
add_action('init', array('FPRewardSystemReferralRewardLog', 'reward_system_default_settings'));

// Call to register the admin settings in the Reward System Submenu with general Settings tab
add_action('woocommerce_rs_settings_tabs_rewardsystem_referral_log', array('FPRewardSystemReferralRewardLog', 'reward_system_register_admin_settings'));
?>