<?php

	/*
	Plugin Name: Stellar Video Player
	Plugin URI: https://codecanyon.net/item/stellar-video-player-wordpress-plugin/20939246
	Description: Stellar Video Player
	Version: 2.5
	Author: پرشین اسکریپت
	Author URI: https://persianscript.ir
	*/

	//define( 'WP_DEBUG', true );
	define('STELLAR_PLAYER_DIR', plugin_dir_url( __FILE__ ));
	define('STELLAR_PLAYER_VERSION', '2.5');
	
	function stellar_vp_trace($var){
		echo("<pre style='background:#fcc;color:#000;font-size:12px;font-weight:bold'>");
		print_r($var);
		echo("</pre>");
	}

	if(!is_admin()) {
		include("includes/plugin-frontend.php");
	}
	else {
		include("includes/plugin-admin.php");
		register_deactivation_hook( __FILE__, "deactivate_stellar_player");
		add_filter("plugin_action_links_" . plugin_basename(__FILE__), "stellar_player_admin_link");
        
        add_action( 'wp_ajax_stellar_save', 'stellar_save_callback' );
		add_action( 'wp_ajax_nopriv_stellar_save', 'stellar_save_callback' );
        
        add_action( 'wp_default_scripts', 'wp_default_custom_scripts_stellar' );
	}
    
	function stellar_player_scripts() {
		wp_enqueue_script("stellar_embed", plugins_url()."/Stellar-video-player/js/embed.min.js", array('jquery'),STELLAR_PLAYER_VERSION);
		wp_enqueue_script("stellar_hls", "https://cdn.jsdelivr.net/npm/hls.js@latest", array('jquery'),STELLAR_PLAYER_VERSION);
		wp_enqueue_script("stellar_vimeo", "https://player.vimeo.com/api/player.js", array('jquery'),STELLAR_PLAYER_VERSION);
		wp_enqueue_script("stellar_jquery.mCustomScrollbar", plugins_url()."/Stellar-video-player/js/jquery.mCustomScrollbar.min.js", array('jquery'),STELLAR_PLAYER_VERSION);
		wp_enqueue_script("stellar_playlist", plugins_url()."/Stellar-video-player/js/Playlist.min.js", array('jquery'),STELLAR_PLAYER_VERSION);
		wp_enqueue_script("stellar_video_player", plugins_url()."/Stellar-video-player/js/videoPlayer.min.js", array(),STELLAR_PLAYER_VERSION);
		
		wp_enqueue_style( 'stellar_player_style', plugins_url()."/Stellar-video-player/css/stellar.min.css" , array(),STELLAR_PLAYER_VERSION);
		wp_enqueue_style( 'stellar_player_icons', plugins_url()."/Stellar-video-player/css/stellar-font-awesome.min.css" , array(),STELLAR_PLAYER_VERSION);
		wp_enqueue_style( 'stellar_player_scrollbar', plugins_url()."/Stellar-video-player/css/jquery.mCustomScrollbar.min.css" , array(),STELLAR_PLAYER_VERSION); 
	}
	add_action( 'wp_enqueue_scripts', 'stellar_player_scripts' );
    
    function wp_default_custom_scripts_stellar( $scripts ){
		$scripts->add( 'wp-color-picker', "/wp-admin/js/color-picker.js", array( 'iris' ), false, 1 );
		did_action( 'init' ) && $scripts->localize(
			'wp-color-picker',
			'wpColorPickerL10n',
			array(
				'clear'            => __( 'Clear' ),
				'clearAriaLabel'   => __( 'Clear color' ),
				'defaultString'    => __( 'Default' ),
				'defaultAriaLabel' => __( 'Select default color' ),
				'pick'             => __( 'Select Color' ),
				'defaultLabel'     => __( 'Color value' ),
			)
		);
	}
	
	function stellar_player_admin_scripts() {

	}
	add_action( 'wp_enqueue_scripts', 'stellar_player_admin_scripts' );
	
	function stellar_player_admin_link($links) {
		array_unshift($links, '<a href="' . get_admin_url() . 'options-general.php?page=stellar_player_admin">Admin</a>');
		return $links;
	}
	
	function deactivate_stellar_player() {
		
	}
    
    function stellar_save_callback() {

		$current_id = $page_id = '';
		// handle action from url

		$stellar_players = get_option("stellar_players");
		if (isset($_GET['playerId']) )
		{
			$current_id = $_GET['playerId'];
			$stellar_player = $stellar_players[$current_id];
			$videos = $stellar_player["videos"];
		}

		foreach ($stellar_players as $stellar_player) {
					$player_id = $stellar_player["id"];

				}

		add_option("stellar_players", $stellar_players);
		
		update_option("stellar_players", $stellar_players);

		$new = array_merge($stellar_player, $_POST);
		$stellar_players[$current_id] = $new;
        
        
                //reset indexes because of sortable videos can be rearranged
				$oldvideos = $stellar_players[$current_id]["videos"];
				$newvideos = array();
				$index = 0;
				foreach($oldvideos as $p){
					$newvideos[$index] = $p;
					$index++;
				}
				$stellar_players[$current_id]["videos"] = $newvideos;


		$stellar_players[$current_id]['status'] = 'published';
						
		update_option("stellar_players", $stellar_players);

		echo json_encode($new);

		wp_die(); // this is required to terminate immediately and return a proper response
		
		

	}