<?php
	$stellar_players = get_option("stellar_players");

	if(!$stellar_players){
		$stellar_players = array();
		add_option("stellar_players", $stellar_players);
	}

	function read_stellar_player_admin_init(){

	}
	add_action("admin_init", "read_stellar_player_admin_init");
	
	function read_stellar_player_admin_menu(){
		add_options_page("Stellar Video Player Admin", "Stellar Video Player", "manage_options", "stellar_player_admin", "stellar_player_admin");
		add_menu_page("Stellar Video Player Admin", "Stellar Video Player", "manage_options", "stellar_player_admin", "stellar_player_admin",'dashicons-format-video');		
	}
	add_action("admin_menu", "read_stellar_player_admin_menu");
	
	//options page
	function stellar_player_admin()
    {
		$current_action = "";
		// handle action from url
		if (isset($_GET['action']) ) {
			$current_action = $_GET['action'];
		}

		$stellar_players = get_option("stellar_players");
		if (isset($_GET['playerId']) )
		{
			$current_id = $_GET['playerId'];
			$stellar_player = $stellar_players[$current_id];
			$videos = $stellar_player["videos"];
		}

		switch( $current_action ) {

		
			case 'edit':

				include("edit-player.php");
				break;
				
			case 'delete':
				//delete new player with id from url
				unset($stellar_players[$current_id]);
				update_option("stellar_players", $stellar_players);
				include("players.php");
				break;
			
			case 'delete_all':
				update_option("stellar_players", array());
				include("players.php");
				break;	
			
			case 'duplicate':
				$highest_id = 0;
				foreach ($stellar_players as $stellar_player) {
					$duplicate_id = $stellar_player["id"];
					if($duplicate_id > $highest_id) {
						$highest_id = $duplicate_id;
					}
				}
				$new_id = $highest_id + 1;
				$stellar_players[$new_id] = $stellar_players[$current_id];
				$stellar_players[$new_id]["id"] = $new_id;
				$stellar_players[$new_id]["instanceName"] = $stellar_players[$current_id]["instanceName"]." (copy)";
				update_option("stellar_players", $stellar_players);
				include("players.php");
				break;	
			case 'add_new':
				//generate ID 
				$new_id = 0;
				$highest_id = 0;
				foreach ($stellar_players as $stellar_player) {
					$player_id = $stellar_player["id"];
					if($player_id > $highest_id) {
						$highest_id = $player_id;
					}
				}
				$current_id = $highest_id + 1;
				//create new player 
				$new_stellar_player = array(	'id' => $current_id, 
										"instanceName" => "Player " . $current_id,
										"videos" => array()
						);
				$stellar_players[$current_id] = $new_stellar_player;
				update_option("stellar_players", $stellar_players);
				include("edit-player.php");
				break;
				
			case 'save_settings':
				$new = array_merge($stellar_player, $_POST);
				$stellar_players[$current_id] = $new;
				//reset indexes because of sortable videos can be rearranged
				$oldvideos = $stellar_players[$current_id]["videos"];
				$newvideos = array();
				$index = 0;
				foreach($oldvideos as $p){
					$newvideos[$index] = $p;
					$index++;
				}
				$stellar_players[$current_id]["videos"] = $newvideos;

				//convert values to boolean and integer where needed
				$formatted = array_map("stellar_cast", $stellar_players[$current_id]);
				// stripslashes($players[$current_id]["embedCode"]);
					// trace($players[$current_id]["embedCode"]);
					// trace (stripslashes($players[$current_id]["embedCode"]));
				
				$stellar_players[$current_id] = $formatted;
				//for each video
				for($i = 0; $i < count($stellar_players[$current_id]["videos"]); $i++){
					$p = $stellar_players[$current_id]["videos"][$i];
				}
				update_option("stellar_players", $stellar_players);
				include("edit-player.php");
				break;


			case 'import_from_json_confirm':

				$json = stripslashes($_POST['players']);


				if((string)$json != "" ){

					$newPlayers = stellar_objectToArray(json_decode($json));

					update_option('stellar_players', $newPlayers);
				}
				
				include("players.php");
				break;



			default:
				include("players.php");
				break;
				
		}
    }
	
	function stellar_cast($n)
	{
		if($n === "true") {
			return true;
		}else if ($n === "false"){
			return false;
		}else if(is_numeric($n)){
			// return (int)$n;
			return floatval($n);
		}else{
			return $n;
		}
	}

	function stellar_objectToArray($d) {
		if (is_object($d)) {
			// Gets the properties of the given object
			// with get_object_vars function
			$d = get_object_vars($d);
		}

		if (is_array($d)) {
			/*
			* Return array converted to object
			* Using __FUNCTION__ (Magic constant)
			* for recursive call
			*/
			return array_map(__FUNCTION__, $d);
		}
		else {
			// Return array
			return $d;
		}
	}				