<div class="wrap">
	<h2>Manage Players
		<a href='<?php echo admin_url( "admin.php?page=stellar_player_admin&action=add_new" ); ?>' class='add-new-h2'>Add New</a>
	</h2>
	
	<table class='players-table wp-list-table widefat fixed'>
		<thead>
			<tr>
				<th width='5%'>ID</th>
				<th width='50%'>Name</th>
				<th width='30%'>Actions</th>
				<th width='20%'>Shortcode</th>						
			</tr>
		</thead>
		<tbody>
			<?php 
				
				$stellar_players = get_option("stellar_players");

				// trace($stellar_players);

				if (count($stellar_players) == 0) {
					echo '<tr>'.
							 '<td colspan="100%">No players found.</td>'.
						 '</tr>';
				} else {
					$stellar_player_display_name;
					
					foreach ($stellar_players as $stellar_player) {
						$stellar_player_display_name = $stellar_player["instanceName"];
						if(!$stellar_player_display_name) {
							$stellar_player_display_name = 'Player #' . $stellar_player["id"] . ' (no name)';
						}
						echo '<tr>'.
								'<td>' . $stellar_player["id"] . '</td>'.								
								'<td>' . '<a href="' . admin_url('admin.php?page=stellar_player_admin&action=edit&playerId=' . $stellar_player["id"]) . '" title="Edit">'.$stellar_player_display_name.'</a>' . '</td>'.
								'<td>' . '<a href="' . admin_url('admin.php?page=stellar_player_admin&action=edit&playerId=' . $stellar_player["id"]) . '" title="Edit this player">Edit</a> | '.									  
										 '<a href="' . admin_url('admin.php?page=stellar_player_admin&action=delete&playerId='  . $stellar_player["id"]) . '" title="Delete player permanently" >Delete</a> | '.
										 '<a href="' . admin_url('admin.php?page=stellar_player_admin&action=duplicate&playerId='  . $stellar_player["id"]) . '" title="Duplicate player" >Duplicate</a>'.
								'</td>'.
								'<td>[Stellar_video_player  id="' . $stellar_player["id"] . '"]</td>'.															
							'</tr>';
					}
				}
			?>
		</tbody>		 
	</table>

	<p>			
		<a class='button-primary' href='<?php echo admin_url( "admin.php?page=stellar_player_admin&action=add_new" ); ?>'>Create New Player</a> 
		<a class='button-primary' href='<?php echo admin_url( "admin.php?page=stellar_player_admin&action=delete_all" ); ?>'>Delete All Players</a>		
	</p>    
	
	<p></p>


		<br/>
	<br/>
	<br/>
	<h3>Import / Export</h3>
	<div>
		<a class='button-secondary' href='<?php echo admin_url( "admin.php?page=stellar_player_admin&action=generate_json" ); ?>'>Export (Generate JSON)</a>
	</div>

	</p>    
	
	<form method="post" enctype="multipart/form-data" action="admin.php?page=stellar_player_admin&amp;action=import_from_json_confirm">
	
		<?php 
				if (isset($_GET['action']) && $_GET['action'] == "generate_json") {
					echo '<textarea id="stellar_player-admin-json" rows="20" cols="100" >' . json_encode($stellar_players) . '</textarea>';
				}
			?>
			<br/>
			<br/>
			<br/>
			<p>Import players from JSON( overwrite existing players)</p>
			
			<textarea name="players" id="stellar_player-admin-json" rows="20" cols="100" placeholder="Paste JSON here"></textarea>
			<p class="submit"><input type="submit" name="submit" id="submit" class="button save-button button-secondary" value="Import"></p>
	
	</form>



</div>