<?php

if (!class_exists('SpeedyGallery_Main')) :

    /**
     * Main SpeedyGallery_Main Class
     *
     */	 
	class SpeedyGallery_Main {

		private static $instance;	
		
        public static function instance() {
            if (!isset(self::$instance) && !(self::$instance instanceof SpeedyGallery_Main)) {

                self::$instance = new SpeedyGallery_Main;

                //self::$instance->setup_constants();

                add_action('plugins_loaded', array(self::$instance, 'load_plugin_textdomain'));

                add_action('plugins_loaded', array(self::$instance, 'includes_files'));

                add_action('plugins_loaded', array(self::$instance, 'include_addons'));

				add_action('wp_enqueue_scripts', array(self::$instance, 'load_general_scripts'));
				
                //self::$instance->hooks();

            }
            return self::$instance;
        }

        /**
         * Load Plugin Text Domain
         */
        public function load_plugin_textdomain() {
			$path = dirname(plugin_basename( __FILE__ )) . '/languages/';
			$loaded = load_plugin_textdomain( 'speedygallery', false, $path);
        }		
		
		
        /**
         * Include required files
         *
         */
        public function includes_files() {

            /* Load VC Field Types */
            include_once( plugin_dir_path( __FILE__ ) . 'includes/speedygallery_functions.php' );
			include_once( plugin_dir_path( __FILE__ ) . 'includes/speedygallery_helper.php' );
			
        }		

        /**
         * Include VC Addons
         *
         */
        public function include_addons() {

			include_once( plugin_dir_path( __FILE__ ) . 'addons/gallery/class-speedygallery-gallery.php' );
			include_once( plugin_dir_path( __FILE__ ) . 'addons/gallery_instagram/class-speedygallery-gallery-instagram.php' );
			include_once( plugin_dir_path( __FILE__ ) . 'addons/gallery_image_posts/class-speedygallery-gallery-image-posts.php' );
			
        }

        /**
         * Load general scripts
         */
        public function load_general_scripts() {

			if (!class_exists('Mulse_Main')) {
				wp_enqueue_style( 'speedygallery-fonts',  plugin_dir_url( __FILE__ ) . 'assets/css/fonts.css' );
			}
			wp_register_style( 'speedygallery-bootstrap',  plugin_dir_url( __FILE__ ) . 'assets/css/bootstrap.css' );
			wp_register_style( 'speedygallery-animations',  plugin_dir_url( __FILE__ ) . 'assets/css/animations.min.css' );
			wp_register_style( 'speedygallery-gallery',  plugin_dir_url( __FILE__ ) . 'assets/css/style_gallery.css' );
			wp_register_style( 'speedygallery-prettyphoto',  plugin_dir_url( __FILE__ ) . 'assets/css/gallery/prettyPhoto.css' );
			wp_register_style( 'speedygallery-magnific-popup',  plugin_dir_url( __FILE__ ) . 'assets/css/gallery/magnific-popup.css' );
			wp_register_style( 'speedygallery-lightgallery',  plugin_dir_url( __FILE__ ) . 'assets/css/gallery/lightGallery.css' );
			wp_enqueue_script( 'jquery');
			wp_register_script( 'speedygallery-appear',  plugin_dir_url( __FILE__ ) . 'assets/js/appear.min.js' );
			wp_register_script( 'speedygallery-js-animations',  plugin_dir_url( __FILE__ ) . 'assets/js/animations.min.js' );
			wp_register_script( 'speedygallery-js-prettyphoto',  plugin_dir_url( __FILE__ ) . 'assets/js/gallery/jquery.prettyPhoto.js' );
			wp_register_script( 'speedygallery-js-magnific-popup',  plugin_dir_url( __FILE__ ) . 'assets/js/gallery/jquery.magnific-popup.js' );
			wp_register_script( 'speedygallery-js-lightgallery',  plugin_dir_url( __FILE__ ) . 'assets/js/gallery/lightGallery.min.js' );
			wp_enqueue_script( 'speedygallery-js',  plugin_dir_url( __FILE__ ) . 'assets/js/speedygallery.js' );			
						
        }			

	}
	
	
endif; // End if class_exists check

function SPEEDYGALLERY() {
    return SpeedyGallery_Main::instance();
}

// Get SPEEDYGALLERY Running
SPEEDYGALLERY();