<?php

/*
Addon: MPAVC Functions 
*/

/** Thumbnails **/
add_action( 'after_setup_theme', 'speedygallery_setup' );
if(!function_exists('speedygallery_setup')) {
	function speedygallery_setup() {
		add_image_size( 'speedygallery-large', 1000, 800, true );
		add_image_size( 'speedygallery-normal', 800 , 800 , true);
		add_image_size( 'speedygallery-masonry', 500 );		
		add_image_size( 'speedygallery-blog-large', 1600 , 914 , true);
		add_image_size( 'speedygallery-blog-medium', 700 , 400 , true);
		add_image_size( 'speedygallery-blog-medium-vertical', 700 , 800 , true);
		add_image_size( 'speedygallery-blog-small', 325 , 235 , true);
		add_image_size( 'speedygallery-posts-medium', 600, 500, true );
		add_image_size( 'speedygallery-header', 800 , 600 , true);
		add_image_size( 'speedygallery-vc-header-medium', 446 , 248 , true);
		add_image_size( 'speedygallery-vc-header-small', 300 , 200 , true);
		add_image_size( 'speedygallery-vc-posts-medium-large', 800 , 350 , true);	
	}
}	


/** Get Category **/
if(!function_exists('speedygallery_get_category')) {
	function speedygallery_get_category($source,$posts_type,$css_link,$limit = 1) {
		$separator = ' ';
		$output = '';	
		$count = 1;
		if($source=='post') {			
			$categories = get_the_category();
			if($categories){
				foreach($categories as $category) {
					$output .= '<a href="'.get_category_link( $category->term_id ).'" title="' . esc_attr( sprintf( __( "View all posts in %s",'speedygallery' ), $category->name ) ) . '" '.$css_link.'>'.$category->cat_name.'</a>'.$separator;
					if($count == $limit) { break; }
					$count++;
				}
			}
		} elseif($source=='post_type') {
			global $post;
			$taxonomy_names = get_object_taxonomies( $posts_type );
			$term_list = wp_get_post_terms($post->ID,$taxonomy_names);
			if($term_list){
				foreach ($term_list as $tax_term) {
					$output .= '<a href="' . esc_attr(get_term_link($tax_term, $posts_type)) . '" title="' . sprintf( __( "View all posts in %s",'speedygallery' ), $tax_term->name ) . '" '.$css_link.'>' . $tax_term->name.'</a>'.$separator;
				}
			}
		}
		$return = trim($output, $separator);
		return $return;
	}
}

/** Get Author **/
if(!function_exists('speedygallery_get_author')) {
	function speedygallery_get_author($css_link) {
		$return = '<a href="'.get_author_posts_url( get_the_author_meta( 'ID' ) ).'" '.$css_link.'>'.get_the_author_meta( 'display_name' ).'</a>';
		return $return;
	}	
}

/** Get Comments **/
if(!function_exists('speedygallery_get_num_comments')) {	
	function speedygallery_get_num_comments($css_comment,$css_comment_link) {
			$num_comments = get_comments_number();

			if ( $num_comments == 0 ) {
					$comments = esc_html__('No Comments','speedygallery');
					$return = $comments;
			} elseif ( $num_comments > 1 ) {
					$comments = $num_comments . esc_html__(' Comments','speedygallery');
					$return = '<a href="' . get_comments_link() .'" '.$css_comment_link.'>'. $comments.'</a>';
			} else {
					$comments = esc_html__('1 Comment','speedygallery');
					$return = '<a href="' . get_comments_link() .'" '.$css_comment_link.'>'. $comments.'</a>';
			}
			return $return;
	}
}

if(!function_exists('speedygallery_get_only_num_comments')) {
	function speedygallery_get_only_num_comments($css_comment,$css_comment_link) {
			$num_comments = get_comments_number();

			if ( $num_comments == 0 ) {
					$return = '<span '.$css_comment.'>'.$num_comments.'</span>';
			} elseif ( $num_comments > 1 ) {
					$return = '<a href="' . get_comments_link() .'" '.$css_comment_link.'>'. $num_comments.'</a>';
			} else {
					$return = '<a href="' . get_comments_link() .'" '.$css_comment_link.'>'. $num_comments.'</a>';
			}
			return $return;
	}
}

/** Get Thumbnails **/
if(!function_exists('speedygallery_get_thumb')) {
	function speedygallery_get_thumb($thumbs_size = 'speedygallery-normal') {
		global $post;
		global $speedygallery_theme;
		$link = get_the_permalink();
		if(has_post_thumbnail()){ 
				$id_post = get_the_id();					
				$single_image = wp_get_attachment_image_src( get_post_thumbnail_id($id_post), $thumbs_size );	
				if($speedygallery_theme['speedygallery_lazy_load']) :
					$return = '<a href="'.$link.'"><img class="speedygallery-lazy-load" data-original="'.$single_image[0].'" alt="'.get_the_title().'"></a>';				
				else :
					$return = '<a href="'.$link.'"><img class="speedygallery-thumbs" src="'.$single_image[0].'" alt="'.get_the_title().'"></a>';
				endif;
			} else {               
				$return = '';                 
		}
		return $return;
	}
}

/** Get Blog Thumbnails **/
if(!function_exists('speedygallery_get_blogs_thumb')) {
	function speedygallery_get_blogs_thumb($columns,$post_id) {
		global $post; 		
		if($columns == '1') :
			$return = speedygallery_get_thumb('speedygallery-blog-large');
		elseif($columns == '2') :
			$return = speedygallery_get_thumb('speedygallery-blog-medium');
		else :
			$return = speedygallery_get_thumb('speedygallery-blog-small');
		endif;	
		return $return;
	}
}	


/** Get Blog Excerpt **/
if(!function_exists('speedygallery_get_blogs_excerpt')) {
	function speedygallery_get_blogs_excerpt($excerpt = 'default',$readmore = 'on',$css_link = '') {
		global $post;
		if($excerpt == 'default') : 
			$return = get_the_excerpt();
		else :
			$return = substr(get_the_excerpt(), 0, $excerpt);
			if($readmore == 'on') :
				$return .= '<a class="article-read-more" href="'. get_permalink($post->ID) . '" '.$css_link.'>'.esc_html__('Read More','speedygallery').'</a>';
			else :
				$return .= '...';
			endif;
		endif;
		return $return;
	}
}

/** Get News Excerpt **/
if(!function_exists('speedygallery_get_news_excerpt')) {
	function speedygallery_get_news_excerpt($excerpt = 'default',$readmore = 'on',$css_link) {
		global $post;
		if($excerpt == 'default') : 
			$return = get_the_excerpt();
		else :
			$return = substr(get_the_excerpt(), 0, $excerpt);
			if($readmore == 'on') :
				$return .= '<a class="article-read-more" href="'. get_permalink($post->ID) . '" '.$css_link.'><i class="fa fa-angle-double-right"></i></a>';
			else :
				$return .= '...';
			endif;
		endif;
		return $return;
	}
}

/** Get News Excerpt **/
if(!function_exists('speedygallery_get_news_v2_excerpt')) {
	function speedygallery_get_news_v2_excerpt($excerpt = 'default',$readmore = 'on',$css_link) {
		global $post;
		if($excerpt == 'default') : 
			$return = get_the_excerpt();
		else :
			$return = substr(get_the_excerpt(), 0, $excerpt);
			if($readmore == 'on') :
				$return .= '<a class="article-read-more" href="'. get_permalink($post->ID) . '" '.$css_link.'>...</a>';
			else :
				$return .= '...';
			endif;
		endif;
		return $return;
	}
}

/** Check Post Format **/
if(!function_exists('speedygallery_check_post_format')) {
	function speedygallery_check_post_format() {
		global $post;
		$format = get_post_format_string( get_post_format() );
		if($format == 'Video') :
			$return = '<span class="speedygallery-format-type fa fa-play-circle-o"></span>';
		elseif($format == 'Audio') :
			$return = '<span class="speedygallery-format-type fa fa-headphones"></span>';
		else :
			$return = '';
		endif;
		return $return;
	}
}

/** Post Social Share **/
if(!function_exists('speedygallery_post_social_share')) {
	function speedygallery_post_social_share($css_link) {
		
		$return = '<div class="container-social">
			<a target="_blank" href="http://www.facebook.com/sharer.php?u='.get_the_permalink().'&amp;t='.get_the_title().'" title="'.esc_html__('Click to share this post on Facebook','speedygallery').'" '.$css_link.'><i class="fa fa-facebook"></i></a>
			<a target="_blank" href="http://twitter.com/home?status='.get_the_permalink().'" title="'.esc_html__('Click to share this post on Twitter','speedygallery').'"><i class="fa fa-twitter" '.$css_link.'></i></a>
			<a target="_blank" href="https://plus.google.com/share?url='.get_the_permalink().'" title="'.esc_html__('Click to share this post on Google+','speedygallery').'"><i class="fa fa-google-plus" '.$css_link.'></i></a>
			<a target="_blank" href="http://www.linkedin.com/shareArticle?mini=true&amp;url='.get_the_permalink().'" title="'.esc_html__('Click to share this post on Linkedin','speedygallery').'"><i class="fa fa-linkedin" '.$css_link.'></i></a></div>';
		
		return $return;
	}
}
/** Get Numeric Pagination **/
if(!function_exists('speedygallery_posts_numeric_pagination')) {
	function speedygallery_posts_numeric_pagination($pages = '', $range = 2,$loop,$paged,$css_current_pag_num,$css_link) {  
		 $showitems = ($range * 2)+1;  

		 if(empty($paged)) $paged = 1;

		 if($pages == '')
		 {
			 $pages = $loop->max_num_pages;
			 if(!$pages)
			 {
				 $pages = 1;
			 }
		 }   
		
		 $return = '';
		
		 if(1 != $pages) {		 	
			 $return .= "<div class='fnwp-numeric-pagination'>";
			 if($paged > 2 && $paged > $range+1 && $showitems < $pages) $return .=  "<a href='".get_pagenum_link(1)."' class=\"fnwp-pagination-numeric-arrow\" ".$css_link."><i class=\"fa fa-angle-double-left fnwp-icon-double-left\"></i></a>";
			 if($paged > 1 && $showitems < $pages) $return .=  "<a href='".get_pagenum_link($paged - 1)."' class=\"fnwp-pagination-numeric-arrow\" ".$css_link."><i class=\"fa fa-angle-left fnwp-icon-left\"></i></a>";

			 for ($i=1; $i <= $pages; $i++)
			 {
				 if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
				 {
					 $return .=  ($paged == $i)? "<span class='current' ".$css_current_pag_num.">".$i."</span>":"<a href='".get_pagenum_link($i)."' class='inactive' ".$css_link.">".$i."</a>";
				 }
			 }

			 if ($paged < $pages && $showitems < $pages) $return .= "<a href='".get_pagenum_link($paged + 1)."' class=\"fnwp-pagination-numeric-arrow\" ".$css_link."><i class=\"fa fa-angle-right fnwp-icon-right\"></i></a>";
			 if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) $return .=  "<a href='".get_pagenum_link($pages)."' class=\"fnwp-pagination-numeric-arrow\" ".$css_link."><i class=\"fa fa-angle-double-right fnwp-icon-double-right\"></i></a>";
			 $return .=  "</div>\n";
		 }
		 
		 return $return;
	}
}

/* Gallery Pagination */
function get_speedygallery_gallery_pagination($num_page_for_pagination,$pagination) {
	$output = '<ul class="speedygallery_gallery_pagination">';
	for($i=1; $i <= $num_page_for_pagination; $i++) {
		
		if($i == $pagination) {
			$output .= '<li class="mg_current">'.$i.'</li>'; // CURRENT PAGE
		} else {
			$output .= '<li><a href="'.get_post_permalink().'&mg_page='.$i.'">'.$i.'</a></li>'; // OTHER PAGE
		}
	}
	$output .= '</ul>';
	return $output;
}

/* Var Gallery Pagination */
function add_query_vars_speedygallery_gallery_pagination( $vars ){
  $vars[] = "mg_page";
  return $vars;
}
add_filter( 'query_vars', 'add_query_vars_speedygallery_gallery_pagination' );

/* Gallery Share Button */
function speedygallery_share_button($id,$image_lightbox,$text_caption) {
	$return = '';
	$return .= '<a href="" class="fa fa-share-alt"></a>';
	$return .= '<div class="speedygallery-gallery-social-share-container">';
		$return .= '<div class="speedygallery-gallery-social-share-container-content">';
			$return .= '<a target="_blank" href="http://www.facebook.com/sharer.php?caption='.$text_caption.'&description='.$text_caption.'&u='.$image_lightbox.'&picture='.$image_lightbox.'"><i class="fa fa-facebook"></i></a>';
		$return .= '</div>';
	$return .= '</div>';
	return $return;
	
}