<?php
/*
Addon: Gallery Image Posts
*/

class SPEEDYGALLERY_Gallery_Image_Posts {

	/*
	 * Contruct
	 */
    public function __construct() {

        add_action('wp_enqueue_scripts', array($this, 'load_scripts'));

        add_shortcode('speedygallery_gallery_image_posts', array($this, 'shortcode_addon_func'));

        add_action('init', array($this, 'map_vc_addon'));

    }

    function load_scripts() {
		
		wp_enqueue_style( 'speedygallery-bootstrap' );
        wp_enqueue_style( 'speedygallery-style' );
        wp_enqueue_style( 'speedygallery-gallery' );
		wp_enqueue_style( 'font-awesome' );
		wp_enqueue_style( 'speedygallery-animations' );
		wp_enqueue_script( 'speedygallery-appear' );
		wp_enqueue_script( 'speedygallery-js-animations' );
		
    }

	/*
	 * Addon View
	 */
    public function shortcode_addon_func($atts, $content = null, $tag) {
		static $instance;
		$instance++;

        extract(shortcode_atts(array(

				'gallery_name' => '',
				'gallery_name_show' => 'false',
				'columns' => '1',
				'type' => 'prettyphoto',
				'size' => 'normal',
				'responsive' => 'responsive',
				'style' => 'style1',
				'over_image' => 'over-image-on',
				'thumbs_one' => 'off',
				'social_share_active' => 'on',
				'pagination_active' => 'off',
				'pagination_number' => '10',
				'pagination_style' => 'pagination_style1',
				'icon_border_radius' => 'off',
				'icon_border_radius_value' => '50%',
				'custom_style' => 'off',
				'bg_color' => '#000000',
				'text_icon_color' => '#FFFFFF',
				'icon_bg_color' => '#FFFFFF',
				'icon_h_color' => '#FFFFFF',
				'icon_bg_h_color' => '#009688',
				'spacing_active' => 'off',
				'spacing' => '5px',
				'gallery_name_font_size' => '20',
				'gallery_name_font_color' => '#FC615D',
				'gallery_name_text_align' => 'center',
				'image_lightbox' => 'fa fa-handshake-o',		
				'images' => '',
				'pp_animation_speed' => 'fast',
				'pp_autoplay' => 'true',
				'pp_time' => '2000',
				'pp_title' => 'true',
				'pp_social' => 'true',
				'pb_thumbs' => 'true',
				'pb_time' => '2000',
				'pb_autoplay' => 'true',				
				'pb_counter' => 'true',
				'pb_history' => 'false',
				'pb_loop' => 'true',
				'caption' => 'off',
				'thumbs_grid' => 'speedygallery-normal',
				'thumbs_masonry' => 'speedygallery-masonry',
				'thumbs_lightbox' => 'large',
				'lg_mode' => 'slide',
				'lg_speed' => '2000',
				'lg_thumbnail' => 'true',
				'lg_controls' => 'true',
				'custom_url_target' => '_blank', 
				'active_custom_responsive' => 'responsive',
				'smartphone_p_columns' => '1',
				'smartphone_l_columns' => '1',
				'tablet_p_columns' => '1',
				'tablet_l_columns' => '1',
				'desktop_medium_columns' => '1',
				'desktop_small_columns' => '1',
			
			// Query
			'source' 				=> 'post',
			'posts_source' 			=> 'all_posts',
			'posts_type' 			=> '',
			'categories' 			=> '',									
			'categories_post_type' 	=> '',
			'pagination' 			=> 'off',
			'pagination_type' 		=> 'numeric',
			'num_posts_page' 		=> '',
			'num_posts' 			=> '', 	
			'orderby' 				=> 'date',
			'order' 				=> 'DESC',
			
			// Animations
			'addon_animate'			=> 'off',
			'effect'				=> 'fade-in',
			'delay'					=> '0',
			

        ), $atts));
		
		$return = $caption_check = $masonry_class = $css_custom_space = $data_value = $js_class = '';
		if($size == 'masonry') :
				wp_enqueue_script( 'masonry' ); 
				$thumbs_size_value = $thumbs_masonry;
				$masonry_class = 'speedygallery-gallery-masonry';
		else :		
				$thumbs_size_value = $thumbs_grid;
		endif;
		
		// PAGINATION		
		if($pagination == 'yes') {
			if ( get_query_var('paged') ) {
				$paged = get_query_var('paged');				
			} elseif ( get_query_var('page') ) {			
				$paged = get_query_var('page');			
			} else {			
				$paged = 1;			
			}
		}
		// #PAGINATION			
		
		// Get Gallery Image Posts Images
		$query = speedygallery_query( $source,
							$posts_source, 
							$posts_type, 
							$categories,
							$categories_post_type, 
							$order, 
							$orderby, 
							$pagination, 
							$pagination_type,
							$num_posts, 
							$num_posts_page );

		// Start Query Loop
		$loop = new WP_Query($query);								
							
							
		// CHECK CUSTOM RESPONSIVE
		if($responsive == 'responsive') :
			if($active_custom_responsive == 'responsive') :
				$responsive = 'speedygallery_gallery_responsive';
			else :
				$responsive = 'speedygallery_smartphone_p_col-'.$smartphone_p_columns.' speedygallery_smartphone_l_col-'.$smartphone_l_columns.' speedygallery_tablet_p_col-'.$tablet_p_columns.' speedygallery_tablet_l_col-'.$tablet_l_columns.' speedygallery_desktop_medium_col-'.$desktop_medium_columns.' speedygallery_desktop_small_col-'.$desktop_small_columns.'';				
			endif;
		endif;

		if($custom_style == 'on') :
			$css_style_to_append = '<style>.speedygallery-gallery-'.$instance.' .speedygallery-gallery-item:hover .speedygallery-gallery-item-content {
					background:'.$bg_color.';
			}
			.speedygallery-gallery-'.$instance.' .speedygallery-gallery-social-share a, 
			.speedygallery-gallery-'.$instance.' .speedygallery-gallery-lightbox a {
				color:'.$text_icon_color.';
				background:'.$icon_bg_color.';
			}
			.speedygallery-gallery-'.$instance.' .speedygallery-gallery-caption-container {
				color:'.$text_icon_color.';
			}				
			.speedygallery-gallery-'.$instance.' .speedygallery-gallery-social-share a:hover, 
			.speedygallery-gallery-'.$instance.' .speedygallery-gallery-lightbox a:hover {
				color:'.$icon_h_color.';
				background:'.$icon_bg_h_color.';
			}
			.speedygallery-gallery-social-share-container-content a i,
			.speedygallery-gallery-social-share-container .speedygallery-gallery-social-share-popup	{
				color:'.$text_icon_color.';
			}
			.speedygallery-gallery-social-share-container-content a:hover i,
			.speedygallery-gallery-social-share-container .speedygallery-gallery-social-share-popup:hover {
				color:'.$icon_h_color.';
			}			
			</style>';
			$data_value = 'data-speedygallery-custom-css="'.$css_style_to_append.'"';
			$js_class = 'speedygallery-custom-js';
		endif;
		
		
		// Check Custom Space Between Items
		if($spacing_active == 'on') : $css_custom_space = 'style="padding:'.$spacing.'"'; endif;
		
		if($icon_border_radius == 'on') : $border_radius_style = 'style="border-radius:'.$icon_border_radius_value.'"'; endif;
		
		/**
		 ** PrettyPhoto
		 **/
		 
		if($type == 'prettyphoto') {
				wp_enqueue_style( 'speedygallery-gallery' );
				wp_enqueue_style( 'speedygallery-prettyphoto' );
				wp_enqueue_script( 'speedygallery-js-prettyphoto');

				$return .= '<div 
					data-speedygallery-gallery-pp-speed="'.$pp_animation_speed.'"
					data-speedygallery-gallery-pp-slideshow="'.$pp_time.'"
					data-speedygallery-gallery-pp-autoplay="'.$pp_autoplay.'"
					data-speedygallery-gallery-pp-title="'.$pp_title.'"
					data-speedygallery-gallery-pp-social="'.$pp_social.'"
					class="speedygallery-gallery speedygallery-gallery-pp speedygallery-gallery-'.$instance.' '.$js_class.' speedygallery-gallery-social-share-'.$social_share_active.' speedygallery-gallery-border-radius-'.$icon_border_radius.' speedygallery-gallery-columns-'.$columns.' '.$responsive.' speedygallery-gallery-'.$style.' speedygallery-gallery-'.$over_image.' '.$masonry_class.'" '.$data_value.'>';
					if($loop) :
						while ( $loop->have_posts() ) : $loop->the_post();
							$id_post = get_the_id();
							$link = get_permalink(); 						
							$caption_div = $caption_check = '';
							$image_thumb = wp_get_attachment_image_src( get_post_thumbnail_id($id_post), $thumbs_size_value );
							$image_large = wp_get_attachment_image_src( get_post_thumbnail_id($id_post), $thumbs_lightbox );
							$image_info = get_post( $id );
							$title = get_the_title();
							$text_caption = get_the_title();
							if($caption == 'off'  || empty($text_caption) || $text_caption == ' ') : 
								$caption_check = 'speedygallery-gallery-no-caption'; 
							else :
								$caption_div = '<div class="speedygallery-gallery-caption-container"><span class="speedygallery-gallery-caption">'.$text_caption.'</span></div>';
							endif;
							$return .= '<div class="speedygallery-gallery-item'.speedygallery_animate_class($addon_animate,$effect,$delay).' '.$css_custom_space.'>';
								$return .= '<img src="'.$image_thumb[0].'" alt="">';
								$return .=	'<div class="speedygallery-gallery-item-content '.$caption_check.'"><div class="speedygallery-gallery-item-content-container">';
									$return .= $caption_div;
									$return .= '<div class="speedygallery-gallery-item-conteiner-link"><div class="speedygallery-gallery-lightbox"><a href="'.$image_large[0].'" title="'.$title.'" data-speedygallery-rel-pp="prettyPhoto[album-'.$instance.']" class="speedygallery-zoom-icon '.$image_lightbox.'" '.$border_radius_style.'></a></div>';
									if($social_share_active == 'on') :
										$return .= '<div class="speedygallery-gallery-social-share">
											<a data-speedygallery-gallery-share-link="'.$image_large[0].'"
											data-speedygallery-gallery-share-caption="'.$text_caption.'"
											class="speedygallery-gallery-share-image fa fa-share-alt" '.$border_radius_style.'></a></div>';
									endif;		
								$return .= '</div></div></div>';
							$return .= '</div>';
							$i++;
						endwhile;
					endif;	
				$return .= '<div class="speedygallery-clear"></div></div>';
		}	

		/**
		 ** Magnific PopUp
		 **/
		 
		if($type == 'magnific-popup') {
				wp_enqueue_style( 'speedygallery-gallery' );
				wp_enqueue_style( 'speedygallery-magnific-popup' );
				wp_enqueue_script( 'speedygallery-js-magnific-popup');

				$return .= '<div class="speedygallery-gallery speedygallery-gallery-mp speedygallery-gallery-'.$instance.' '.$js_class.' speedygallery-gallery-social-share-'.$social_share_active.' speedygallery-gallery-border-radius-'.$icon_border_radius.' speedygallery-gallery-columns-'.$columns.' '.$responsive.' speedygallery-gallery-'.$style.' speedygallery-gallery-'.$over_image.' '.$masonry_class.'" '.$data_value.'>';
					if($loop) :
						while ( $loop->have_posts() ) : $loop->the_post();
							$id_post = get_the_id();
							$link = get_permalink(); 						
							$caption_div = $caption_check = '';
							$image_thumb = wp_get_attachment_image_src( get_post_thumbnail_id($id_post), $thumbs_size_value );
							$image_large = wp_get_attachment_image_src( get_post_thumbnail_id($id_post), $thumbs_lightbox );
							$image_info = get_post( $id );
							$title = get_the_title();
							$text_caption = get_the_title();
							if($caption == 'off'  || empty($text_caption) || $text_caption == ' ') : 
								$caption_check = 'speedygallery-gallery-no-caption'; 
							else :
								$caption_div = '<div class="speedygallery-gallery-caption-container"><span class="speedygallery-gallery-caption">'.$text_caption.'</span></div>';
							endif;
							$return .= '<div class="speedygallery-gallery-item'.speedygallery_animate_class($addon_animate,$effect,$delay).' '.$css_custom_space.'>';
								$return .= '<img src="'.$image_thumb[0].'" alt="">';
								$return .=	'<div class="speedygallery-gallery-item-content '.$caption_check.'"><div class="speedygallery-gallery-item-content-container">';
									$return .= $caption_div;
									$return .= '<div class="speedygallery-gallery-item-conteiner-link"><div class="speedygallery-gallery-lightbox"><a href="'.$image_large[0].'" title="'.$title.'" class="speedygallery-gallery-magnific-popup speedygallery-zoom-icon '.$image_lightbox.'" '.$border_radius_style.'><img src="'.$image_thumb[0].'" alt="" style="display:none"></a></div>';
									if($social_share_active == 'on') :
										$return .= '<div class="speedygallery-gallery-social-share">
											<a data-speedygallery-gallery-share-link="'.$image_large[0].'"
											data-speedygallery-gallery-share-caption="'.$text_caption.'"
											class="speedygallery-gallery-share-image fa fa-share-alt" '.$border_radius_style.'></a></div>';
									endif;		
								$return .= '</div></div></div>';
							$return .= '</div>';
							$i++;
						endwhile;
					endif;	
				$return .= '<div class="speedygallery-clear"></div></div>';
		}

		/**
		 ** Light Gallery
		 **/
		 
		if($type == 'lightgallery') {
				wp_enqueue_style( 'speedygallery-gallery' );
				wp_enqueue_style( 'speedygallery-lightgallery' );
				wp_enqueue_script( 'speedygallery-js-lightgallery');

				$return .= '<div 
					data-speedygallery-gallery-lg-mode="'.$lg_mode.'"
					data-speedygallery-gallery-lg-speed="'.$lg_speed.'"
					data-speedygallery-gallery-lg-thumbnail="'.$lg_thumbnail.'"
					data-speedygallery-gallery-lg-controls="'.$lg_controls.'"				
					class="speedygallery-gallery speedygallery-gallery-lg speedygallery-gallery-'.$instance.' '.$js_class.' speedygallery-gallery-social-share-'.$social_share_active.' speedygallery-gallery-border-radius-'.$icon_border_radius.' speedygallery-gallery-columns-'.$columns.' '.$responsive.' speedygallery-gallery-'.$style.' speedygallery-gallery-'.$over_image.' '.$masonry_class.'" '.$data_value.'>';
					if($loop) :
						while ( $loop->have_posts() ) : $loop->the_post();
							$id_post = get_the_id();
							$link = get_permalink(); 						
							$caption_div = $caption_check = '';
							$image_thumb = wp_get_attachment_image_src( get_post_thumbnail_id($id_post), $thumbs_size_value );
							$image_large = wp_get_attachment_image_src( get_post_thumbnail_id($id_post), $thumbs_lightbox );
							$image_info = get_post( $id );
							$title = get_the_title();
							$text_caption = get_the_title();
							if($caption == 'off'  || empty($text_caption) || $text_caption == ' ') : 
								$caption_check = 'speedygallery-gallery-no-caption'; 
							else :
								$caption_div = '<div class="speedygallery-gallery-caption-container"><span class="speedygallery-gallery-caption">'.$text_caption.'</span></div>';
							endif;
							$return .= '<div class="speedygallery-gallery-item'.speedygallery_animate_class($addon_animate,$effect,$delay).' '.$css_custom_space.'>';
								$return .= '<img src="'.$image_thumb[0].'" alt="">';
								$return .=	'<div class="speedygallery-gallery-item-content '.$caption_check.'"><div class="speedygallery-gallery-item-content-container">';
									$return .= $caption_div;
									$return .= '<div class="speedygallery-gallery-item-conteiner-link"><div class="speedygallery-gallery-lightbox"><a data-src="'.$image_large[0].'" href="'.$image_large[0].'" title="'.$title.'" class="speedygallery-zoom-icon '.$image_lightbox.'" '.$border_radius_style.'><img src="'.$image_thumb[0].'" alt="" style="display:none"></a></div>';
									if($social_share_active == 'on') :
										$return .= '<div class="speedygallery-gallery-social-share">
											<a data-speedygallery-gallery-share-link="'.$image_large[0].'"
											data-speedygallery-gallery-share-caption="'.$text_caption.'"
											class="speedygallery-gallery-share-image fa fa-share-alt"  '.$border_radius_style.'></a></div>';
									endif;		
								$return .= '</div></div></div>';
							$return .= '</div>';
							$i++;
						endwhile;
					endif;	
				$return .= '<div class="speedygallery-clear"></div></div>';
		}

		
		/**
		 ** Only Image
		 **/
		 
		if($type == 'only_image') {
				wp_enqueue_style( 'speedygallery-gallery' );

				$return .= '<div class="speedygallery-gallery speedygallery-gallery-oi speedygallery-gallery-'.$instance.' '.$js_class.' speedygallery-gallery-social-share-'.$social_share_active.' speedygallery-gallery-border-radius-'.$icon_border_radius.' speedygallery-gallery-columns-'.$columns.' '.$responsive.' speedygallery-gallery-'.$style.' speedygallery-gallery-'.$over_image.' '.$masonry_class.'" '.$data_value.'>';
					if($loop) :
						while ( $loop->have_posts() ) : $loop->the_post();
							$id_post = get_the_id();
							$link = get_permalink(); 						
							$caption_div = $caption_check = '';
							$image_thumb = wp_get_attachment_image_src( get_post_thumbnail_id($id_post), $thumbs_size_value );
							$image_large = wp_get_attachment_image_src( get_post_thumbnail_id($id_post), $thumbs_lightbox );
							$image_info = get_post( $id );
							$title = get_the_title();
							$text_caption = get_the_title();
							if($caption == 'off'  || empty($text_caption) || $text_caption == ' ') : 
								$caption_check = 'speedygallery-gallery-no-caption'; 
							else :
								$caption_div = '<div class="speedygallery-gallery-caption-container"><span class="speedygallery-gallery-caption">'.$text_caption.'</span></div>';
							endif;
							$return .= '<div class="speedygallery-gallery-item'.speedygallery_animate_class($addon_animate,$effect,$delay).' '.$css_custom_space.'>';
								$return .= '<img src="'.$image_thumb[0].'" alt="">';
								$return .=	'<div class="speedygallery-gallery-item-content '.$caption_check.'"><div class="speedygallery-gallery-item-content-container">';
									$return .= $caption_div;
									if($social_share_active == 'on') :
										$return .= '<div class="speedygallery-gallery-social-share">
											<a data-speedygallery-gallery-share-link="'.$image_large[0].'"
											data-speedygallery-gallery-share-caption="'.$text_caption.'"
											class="speedygallery-gallery-share-image fa fa-share-alt" '.$border_radius_style.'></a></div>';
									endif;		
								$return .= '</div></div>';
							$return .= '</div>';
							$i++;
						endwhile;
					endif;	
				$return .= '<div class="speedygallery-clear"></div></div>';
		}			
		
		/**
		 ** Post URL
		 **/
		 
		if($type == 'post_url') {
				wp_enqueue_style( 'speedygallery-gallery' );

				$return .= '<div class="speedygallery-gallery speedygallery-gallery-cu speedygallery-gallery-'.$instance.' '.$js_class.' speedygallery-gallery-columns-'.$columns.' speedygallery-gallery-border-radius-'.$icon_border_radius.' '.$responsive.' speedygallery-gallery-'.$style.' speedygallery-gallery-'.$over_image.' '.$masonry_class.'" '.$data_value.'>';
					if($loop) :
						while ( $loop->have_posts() ) : $loop->the_post();
							$id_post = get_the_id();
							$url = get_permalink(); 						
							$caption_div = $caption_check = '';
							$image_thumb = wp_get_attachment_image_src( get_post_thumbnail_id($id_post), $thumbs_size_value );
							$image_large = wp_get_attachment_image_src( get_post_thumbnail_id($id_post), $thumbs_lightbox );
							$image_info = get_post( $id );
							$title = get_the_title();
							$text_caption = get_the_title();
							if($caption == 'off'  || empty($text_caption) || $text_caption == ' ') : 
								$caption_check = 'speedygallery-gallery-no-caption'; 
							else :
								$caption_div = '<div class="speedygallery-gallery-caption-container"><span class="speedygallery-gallery-caption">'.$text_caption.'</span></div>';
							endif;
							$return .= '<div class="speedygallery-gallery-item'.speedygallery_animate_class($addon_animate,$effect,$delay).' '.$css_custom_space.'>';
								$return .= '<img src="'.$image_thumb[0].'" alt="">';
								$return .=	'<div class="speedygallery-gallery-item-content '.$caption_check.'"><div class="speedygallery-gallery-item-content-container">';
									$return .= $caption_div;
									$return .= '<div class="speedygallery-gallery-item-conteiner-link"><div class="speedygallery-gallery-lightbox"><a href="'.$url.'" title="'.$title.'" target="'.$post_url_target.'" class="speedygallery-zoom-icon '.$image_lightbox.'" '.$border_radius_style.'></a></div>';
									if($social_share_active == 'on') :
										$return .= '<div class="speedygallery-gallery-social-share">
											<a data-speedygallery-gallery-share-link="'.$image_large[0].'"
											data-speedygallery-gallery-share-caption="'.$text_caption.'"
											class="speedygallery-gallery-share-image fa fa-share-alt"  '.$border_radius_style.'></a></div>';
									endif;		
								$return .= '</div></div></div>';
							$return .= '</div>';	
							$i++;
						endwhile;
					endif;	
				$return .= '<div class="speedygallery-clear"></div></div>';
		}		
		
		
		
		/**********************************************************************/
		/****************************** PAGINATION ****************************/
		/**********************************************************************/ 
		if($pagination == 'yes') {
				$return .= '<div class="speedygallery-gallery-pagination speedygallery_gallery_pagination-'.$instance.' speedygallery_gallery_pagination-'.$pagination_style.'"">';
				$return .= speedygallery_posts_numeric_pagination($pages = '', $range = 2,$loop,$paged,'','');
				$return .= '<div class="speedygallery-clear"></div></div>';
		}
		/**********************************************************************/
		/***************************** #PAGINATION ****************************/
		/**********************************************************************/ 
		
		$return .= '<div class="speedygallery-clear"></div>';
		wp_reset_query();
		return $return;
    }

	/*
	 * Addon Backend
	 */	
    function map_vc_addon() {
        if (function_exists("vc_map")) {

            vc_map(array(
                "name" => esc_html__("Gallery Image Posts", "speedygallery"),
                "base" => "speedygallery_gallery_image_posts",
                "content_element" => true,
                "show_settings_on_create" => true,
                "category" => esc_html__("Speedy Gallery", "speedygallery"),
                'description' => esc_html__('add your images gallery', 'speedygallery'),
                "icon" => SPEEDYGALLERY_URL . '/assets/img/vc-gallery.png',
                "params" => array(
					array(
							"type" => "textfield",
							"class" => "",
							"heading" => esc_html__("Gallery Image Posts Display Name",'speedygallery'),
							"param_name" => "name",
							"admin_label" => true,				  				  			  				  
					),
					array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Columns", 'speedygallery'),
							"param_name" => "columns",
							"value" => array(
											'1' => '1',
											'2' => '2',
											'3' => '3',
											'4' => '4',
											'5' => '5',
											'6' => '6',
											'7' => '7',
											'8' => '8',
											'9' => '9'
							)
					),
				    array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Type Gallery", 'speedygallery'),
							"param_name" => "type",
							"value" => array(
										'PrettyPhoto' => 'prettyphoto',
										'Magnific Popup' => 'magnific-popup',
										'Light Gallery' => 'lightgallery',
										'Post URL' => 'post_url',
										'Only Image (no Lightbox)' => 'only_image'
							)
				    ),
					array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Over Image", 'speedygallery'),
							"param_name" => "over_image",
							"value" => array(
										'On' => 'over-image-on',
										'Off' => 'over-image-off'
							)
					),			  			  
					array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__("Show Caption Image", 'speedygallery'),
							"param_name" => "caption",
							"value" => array(
										'Off' => 'off',
										'On' => 'on'
							)
					),
					
					// ADVANCED SETTINGS
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Social Share", 'speedygallery'),
						"param_name" => "social_share_active",
						"value" => array(
										'On'  => 'on',
										'Off' => 'off'
										
						),
						"group" => "Advanced",
					),

					// QUERY
					array(
					  "type" => "dropdown",
					  "class" => "",
					  "heading" => esc_html__("Source", 'speedygallery'),
					  "param_name" => "source",
					  "value" => array(
										esc_html__('Wordpress Posts','speedygallery') 		=> 'post',
										esc_html__('Custom Posts Type','speedygallery')  	=> 'post_type',
					   ),
					   "group" => "Query"				   			   
					),

					array(
					  "type" => "dropdown",
					  "class" => "",
					  "heading" => esc_html__("All Posts/Sticky Posts", 'speedygallery'),
					  "param_name" => "blogs_source",
					  "value" => array(
										esc_html__('All Posts','speedygallery') 		 		=> 'all_posts',
										esc_html__('Only Sticky Posts','speedygallery')  	=> 'sticky_posts',
					   ),
					   "group" => "Query",
					  "dependency" => array(
								'element' => 'source',
								'value' => array( 'post' )
					  ),					   				   			   
					),

					array(
					  "type" => "posttypes", 
					  "class" => "",
					  "heading" => esc_html__("Select Post Type Source",'speedygallery'),
					  "param_name" => "posts_type",
					  "group" => "Query",
					  "dependency" => array(
								'element' => 'source',
								'value' => array( 'post_type' )
					  ),					  				  					  				  			  				  
					),
					array(
					  "type" => "checkbox", 
					  "class" => "",
					  "heading" => esc_html__("Categories",'speedygallery'),
					  "param_name" => "categories",
					  "group" => "Query", 
					  "value" => speedygallery_get_category_array(),	  
					  "dependency" => array(
								'element' => 'source',
								'value' => array( 'post' )
					  ),				  					  				  					  				  			  				  
					),				
						
					array(
					  "type" => "textfield", 
					  "class" => "",
					  "heading" => esc_html__("Categories Post Type",'speedygallery'),
					  "param_name" => "categories_post_type",
					  "description" => esc_html__("Write Categories slug separate by comma(,) for example: cat-slug1, cat-slug2, cat-slug3 (Leave empty for all categories)","speedygallery"),
					  "group" => "Query",
					  "dependency" => array(
								'element' => 'source',
								'value' => array( 'post_type' )
					  ),				  					  				  					  				  			  				  
					),

					array(
					  "type" => "dropdown",
					  "class" => "",
					  "heading" => esc_html__("Order", 'speedygallery'),
					  "param_name" => "order",
					  "value" => array(
										esc_html__('DESC','speedygallery')  	=> 'DESC',
										esc_html__('ASC','speedygallery') 	=> 'ASC'
										
					   ),
					   "group" => "Query"				   			   
					),

					array(
					  "type" => "dropdown",
					  "class" => "",
					  "heading" => esc_html__("Order By", 'speedygallery'),
					  "param_name" => "orderby",
					  "value" => array(
										esc_html__('Date','speedygallery') 				=> 'date',
										esc_html__('ID','speedygallery')  				=> 'ID',
										esc_html__('Author','speedygallery') 			=> 'author',
										esc_html__('Title','speedygallery')  			=> 'title',
										esc_html__('Name','speedygallery') 				=> 'name',
										esc_html__('Modified','speedygallery')  			=> 'modified',
										esc_html__('Parent','speedygallery') 			=> 'parent',
										esc_html__('Rand','speedygallery')  				=> 'rand',
										esc_html__('Comments Count','speedygallery')  	=> 'comment_count',
										esc_html__('Views','speedygallery')				=> 'views',
										esc_html__('None','speedygallery')  				=> 'none',																																													
					   ),
					   "group" => "Query"				   			   
					),												

					array(
					  "type" => "dropdown",
					  "class" => "",
					  "heading" => esc_html__("Pagination", 'speedygallery'),
					  "param_name" => "pagination",
					  "value" => array(
										esc_html__('No','speedygallery')  						=> 'no',
										esc_html__('Yes','speedygallery') 						=> 'yes'								
					   ),				   
					  "group" => "Query"				   			   
					),

					array(
					  "type" => "textfield", 
					  "class" => "",
					  "heading" => esc_html__("Number Posts",'speedygallery'),
					  "param_name" => "num_posts",
					  "description" => "ex 10",
					  "group" => "Query",
					  "dependency" => array(
								'element' => 'pagination',
								'value' => array( 'no' )
					  ),					  				  					  				  			  				  
					),
					array(
					  "type" => "textfield", 
					  "class" => "",
					  "heading" => esc_html__("Number Posts For Page",'speedygallery'),
					  "param_name" => "num_posts_page",
					  "description" => "ex 10",
					  "group" => "Query",
					  "dependency" => array(
								'element' => 'pagination',
								'value' => array( 'yes','load-more' )
					  ),					  				  					  				  			  				  
					),				
					
			  /* PRETTYPHOTO */
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Animation Speed", 'speedygallery'),
                  "param_name" => "pp_animation_speed",
                  "value" => array(
									'Fast' 	 => 'fast',
									'Normal' => 'normal',
									'Slow' 	 => 'slow'																		
				   ),
				  'dependency' => array(
						'element' => 'type',
						'value' => array( 'prettyphoto' )
				  ),
				  "group" => "Prettyphoto Options",				   
              ),
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Autoplay", 'speedygallery'),
                  "param_name" => "pp_autoplay",
                  "value" => array(
									'On' => 'true',
									'Off' => 'false'																		
				   ),
				  'dependency' => array(
						'element' => 'type',
						'value' => array( 'prettyphoto' )
				  ),
				  "group" => "Prettyphoto Options",				   
              ),		  
			  array(
				  "type" => "textfield",
				  "class" => "",
				  "heading" => esc_html__("Autoplay Time",'speedygallery'),
				  "param_name" => "pp_time",
				  "value" => "2000",
				  "description" => esc_html__("time in ms (1000 = 1sec). Example: 2000",'speedygallery'),
				  'dependency' => array(
						'element' => 'type',
						'value' => array( 'prettyphoto' )
				  ),
				  "group" => "Prettyphoto Options",
			  ),
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Show Title", 'speedygallery'),
                  "param_name" => "pp_title",
                  "value" => array(
									'On' => 'true',
									'Off' => 'false'																		
				   ),
				  'dependency' => array(
						'element' => 'type',
						'value' => array( 'prettyphoto' )
				  ),
				  "group" => "Prettyphoto Options",				   
              ),
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Show Social", 'speedygallery'),
                  "param_name" => "pp_social",
                  "value" => array(
									'On' => 'true',
									'Off' => 'false'																		
				   ),
				  'dependency' => array(
						'element' => 'type',
						'value' => array( 'prettyphoto' )
				  ),
				  "group" => "Prettyphoto Options",				   
              ),
			  			  
			  /* LIGHT GALLERY */
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Mode", 'speedygallery'),
                  "param_name" => "lg_mode",
                  "value" => array(
									'Slide' => 'slide',
									'Fade' => 'fade'																		
				   ),
				  'dependency' => array(
						'element' => 'type',
						'value' => array( 'lightgallery' )
				  ),
				  "group" => "Light Gallery",				   
              ),
			  array(
				  "type" => "textfield",
				  "class" => "",
				  "heading" => esc_html__("Speed",'speedygallery'),
				  "param_name" => "lg_speed",
				  "value" => "2000",
				  "description" => esc_html__("time in ms (1000 = 1sec). Example: 2000",'speedygallery'),
				  'dependency' => array(
						'element' => 'type',
						'value' => array( 'lightgallery' )
				  ),
				  "group" => "Light Gallery",
			  ),			  			  			  
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Thumbnail", 'speedygallery'),
                  "param_name" => "lg_thumbnail",
                  "value" => array(
									'On' => 'true',
									'Off' => 'false'																		
				   ),
				  'dependency' => array(
						'element' => 'type',
						'value' => array( 'lightgallery' )
				  ),
				  "group" => "Light Gallery",				   
              ),
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Controls", 'speedygallery'),
                  "param_name" => "lg_controls",
                  "value" => array(
									'On' => 'true',
									'Off' => 'false'																		
				   ),
				  'dependency' => array(
						'element' => 'type',
						'value' => array( 'lightgallery' )
				  ),
				  "group" => "Light Gallery",				   
              ),
			  /* POST URL */
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Target", 'vcfg'),
                  "param_name" => "post_url_target",
                  "value" => array(
									'Blank (New Window)' => '_blank',
									'Self (Same Widow)'	 => '_self'																		
				   ),
				  'dependency' => array(
						'element' => 'type',
						'value' => array( 'post_url' )
				  ),
				  "group" => "Post Url",				   
              ),			  
			  // THUMBNAILS CONTROLS
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Grid Thumbnails Size", 'vcfg'),
                  "param_name" => "thumbs_grid",
                  "value" => array(
									'Default (800px)' => 'speedygallery-normal',
									'Thumbnail' => 'thumbnail',
									'Medium' => 'medium',
									'Large' => 'large',
									'Full' => 'full'
				   ),
				  'dependency' => array(
						'element' => 'size',
						'value' => array( 'normal' )
				  ),
				  "group" => "Thumbnails",
              )	,			  
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Masonry Thumbnails Size", 'vcfg'),
                  "param_name" => "thumbs_masonry",
                  "value" => array(
									'Default (500px)' => 'speedygallery-masonry',
									'Thumbnail' => 'thumbnail',
									'Medium' => 'medium',
									'Large' => 'large',
									'Full' => 'full'
				   ),
				  'dependency' => array(
						'element' => 'size',
						'value' => array( 'masonry' )
				  ),
				  "group" => "Thumbnails",
              )	,
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Lightbox Thumbs", 'vcfg'),
                  "param_name" => "thumbs_lightbox",
                  "value" => array(	
				  					'Large (Default)'  => 'large',
									'Full' 	 => 'full',									
									'Medium' => 'medium',									
									'Thumbnail'  => 'thumbnail',
				   ),
				  "group" => "Thumbnails",
              )	,
			  
			  /* MOBILE COLUMNS */
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Active Custom Responsive", 'speedygallery'),
                  "param_name" => "active_custom_responsive",
                  "value" => array(
									'Defatul Value' => 'responsive',
									'Active Custom Responsive' => 'active_custom_responsive',
				  ),
				  'dependency' => array(
						'element' => 'responsive',
						'value' => array( 'responsive' )
				  ),				   
				  "group" => "Responsive",
              ),			  
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Smartphone Portrait", 'speedygallery'),
                  "param_name" => "smartphone_p_columns",
                  "value" => array(
									'1' => '1',
									'2' => '2',
									'3' => '3',
									'4' => '4',
									'5' => '5',
									'6' => '6',
									'7' => '7',
									'8' => '8',
									'9' => '9'
				  ),
				  'dependency' => array(
						'element' => 'responsive',
						'value' => array( 'responsive' )
				  ),				   
				  "group" => "Responsive",
              ),
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Smartphone Landscape", 'speedygallery'),
                  "param_name" => "smartphone_l_columns",
                  "value" => array(
									'1' => '1',
									'2' => '2',
									'3' => '3',
									'4' => '4',
									'5' => '5',
									'6' => '6',
									'7' => '7',
									'8' => '8',
									'9' => '9'
				  ),
				  'dependency' => array(
						'element' => 'responsive',
						'value' => array( 'responsive' )
				  ),				   
				  "group" => "Responsive",
              ),
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Tablet Portrait", 'speedygallery'),
                  "param_name" => "tablet_p_columns",
                  "value" => array(
									'1' => '1',
									'2' => '2',
									'3' => '3',
									'4' => '4',
									'5' => '5',
									'6' => '6',
									'7' => '7',
									'8' => '8',
									'9' => '9'
				  ),
				  'dependency' => array(
						'element' => 'responsive',
						'value' => array( 'responsive' )
				  ),				   
				  "group" => "Responsive",
              ),			  	
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Tablet Landscape", 'speedygallery'),
                  "param_name" => "tablet_l_columns",
                  "value" => array(
									'1' => '1',
									'2' => '2',
									'3' => '3',
									'4' => '4',
									'5' => '5',
									'6' => '6',
									'7' => '7',
									'8' => '8',
									'9' => '9'
				  ),
				  'dependency' => array(
						'element' => 'responsive',
						'value' => array( 'responsive' )
				  ),				   
				  "group" => "Responsive",
              ),
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Desktop (min value 640px - max value 1024px)", 'speedygallery'),
                  "param_name" => "desktop_medium_columns",
                  "value" => array(
									'1' => '1',
									'2' => '2',
									'3' => '3',
									'4' => '4',
									'5' => '5',
									'6' => '6',
									'7' => '7',
									'8' => '8',
									'9' => '9'
				  ),
				  'dependency' => array(
						'element' => 'responsive',
						'value' => array( 'responsive' )
				  ),				   
				  "group" => "Responsive",
              ),
              array(
                  "type" => "dropdown",
                  "class" => "",
                  "heading" => esc_html__("Desktop (max 639px)", 'speedygallery'),
                  "param_name" => "desktop_small_columns",
                  "value" => array(
									'1' => '1',
									'2' => '2',
									'3' => '3',
									'4' => '4',
									'5' => '5',
									'6' => '6',
									'7' => '7',
									'8' => '8',
									'9' => '9'
				  ),
				  'dependency' => array(
						'element' => 'responsive',
						'value' => array( 'responsive' )
				  ),				   
				  "group" => "Responsive",
              ),		  
					// STYLE 
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Style", 'speedygallery'),
						"param_name" => "style",
						"value" => array(
										'Style 1' => 'style1',
										'Style 2' => 'style2',
										'Style 3' => 'style3',
										'Style 4' => 'style4',
										'No Style' => 'no_style',																		
						),
						"group" => "Style",
					),
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Icon Border Radius", 'speedygallery'),
						"param_name" => "icon_border_radius",
						"value" => array(
										'Off (Icon Square)' => 'off',
										'On' => 'on',																		
						),
						"group" => "Style",
					),
					array(
						"type" => "textfield",
						"class" => "",
						"heading" => esc_html__("Border Radius",'speedygallery'),
						"param_name" => "icon_border_radius_value",
						"description" => "ex 50% or 50px",					  
						"dependency" => array(
							"element" => "icon_border_radius",
							"value" => array( "on" )
						),
						"value" => "50%",
						"group" => "Style"					  
					),						
					array(
						"type" => "iconpicker",
						"heading" => esc_html__( "Image Lightbox", "speedygallery" ),
						"param_name" => "image_lightbox",
						"settings" => array(
							"emptyIcon" 	=> false,
							"type" 			=> "fontawesome",
							"iconsPerPage" 	=> 200,
						),						
						"description" => esc_html__( "Select lightbox icon from library.", "speedygallery" ),
						"group" => "Style",
					),
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Custom Style", 'speedygallery'),
						"param_name" => "custom_style",
						"value" => array(
										'Off' => 'off',
										'On' => 'on'																	
					   ),
					   "group" => "Style",			   				   
					),					
					array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => esc_html__("Background Color", 'speedygallery'),
						"param_name" => "bg_color",
						"value" => '#000000',
						"group" => "Style",
						'dependency' => array(
							'element' => 'custom_style',
							'value' => array( 'on' )
						),							
					),	  
					array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => esc_html__("Text/Icon Color", 'speedygallery'),
						"param_name" => "text_icon_color",
						"value" => '#FFFFFF',
						"group" => "Style",
						'dependency' => array(
							'element' => 'custom_style',
							'value' => array( 'on' )
						),							
					),
					array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => esc_html__("Background Icon", 'speedygallery'),
						"param_name" => "icon_bg_color",
						"value" => '#FFFFFF',
						"group" => "Style",
						'dependency' => array(
							'element' => 'custom_style',
							'value' => array( 'on' )
						),							
					),
					array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => esc_html__("Over Icon", 'speedygallery'),
						"param_name" => "icon_h_color",
						"value" => '#FFFFFF',
						"group" => "Style",
						'dependency' => array(
							'element' => 'custom_style',
							'value' => array( 'on' )
						),							
					),	
					array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => esc_html__("Background Over Icon", 'speedygallery'),
						"param_name" => "icon_bg_h_color",
						"value" => '#009688',
						"group" => "Style",
						'dependency' => array(
							'element' => 'custom_style',
							'value' => array( 'on' )
						),							
					),						
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Custom spacing between the photos", 'speedygallery'),
						"param_name" => "spacing_active",
						"value" => array(
										'Off' => 'off',
										'On' => 'on'																	
					   ),
					   "group" => "Style",					   
					),
					array(
						"type" => "textfield",
						"class" => "",
						"heading" => esc_html__("spacing between the photos",'speedygallery'),
						"param_name" => "spacing",
						"value" => "5px",
						"description" => esc_html__("Enter pixel value (examples: 20px)",'speedygallery'),
						'dependency' => array(
							'element' => 'spacing_active',
							'value' => array( 'on' )
						),
						"group" => "Style",
					),				
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Pagination Style", 'speedygallery'),
						"param_name" => "pagination_style",
						"value" => array(
										'Style 1'  => 'pagination_style1',
										'Style 2'  => 'pagination_style2'
						),
						'dependency' => array(
							'element' => 'pagination_active',
							'value' => array( 'on' )
						),	
						"group" => "Style",			   
					),				  						
					// ANIMATION								  							  		  
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Animate", 'speedygallery'),
						"param_name" => "addon_animate",
						"value" => array(
										esc_html__('Off','speedygallery') 	=> 'off',
										esc_html__('On','speedygallery') 	=> 'on'
										
						),
						"dependency" => array(
							"element" => "pagination",
							"value" => array( "no", "yes" )
						),						
						"group" => "Animation"
					),			  
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Animate Effects", 'speedygallery'),
						"param_name" => "effect",
						"value" => speedygallery_animation_effect(),
						"dependency" => array(
							"element" => "addon_animate",
							"value" => array( "on" )
						),
						"group" => "Animation"				   
					),				  
					array(
						"type" => "textfield",
						"class" => "",
						"heading" => esc_html__("Animate Delay (ms)",'speedygallery'),
						"param_name" => "delay",
						"description" => "ex 1000",					  
						"dependency" => array(
							"element" => "addon_animate",
							"value" => array( "on" )
						),
						"value" => "0",
						"group" => "Animation"					  
					),
                ),
            ));


        }
    }


} // End Class

if (class_exists('WPBakeryShortCode')) {
    class WPBakeryShortCode_SPEEDYGALLERY_Gallery_Image_Posts extends WPBakeryShortCode {
    }
}

// Initialize Element Class
if (class_exists('SPEEDYGALLERY_Gallery_Image_Posts')) {
    new SPEEDYGALLERY_Gallery_Image_Posts();
}