<?php
/*
Plugin Name: Elfsight Social Share Buttons CC
Description: Elfsight Social Share Buttons allows your to add social buttons widget to Wordpress website
Plugin URI: https://elfsight.com/social-media-share-buttons/wordpress/?utm_source=markets&utm_medium=codecanyon&utm_campaign=social-share-buttons&utm_content=plugin-site
Version: 1.4.0
Author: پرشین اسکریپت
Author URI: https://persianscript.ir
*/

if (!defined('ABSPATH')) exit;


require_once('core/elfsight-plugin.php');

$elfsight_social_share_buttons_config_path = plugin_dir_path(__FILE__) . 'config.json';
$elfsight_social_share_buttons_config = json_decode(file_get_contents($elfsight_social_share_buttons_config_path), true);

new ElfsightSocialShareButtonsPlugin(array(
        'name' => esc_html__('Social Share Buttons'),
        'description' => esc_html__('Elfsight Social Share Buttons allows your to add social buttons widget to Wordpress website'),
        'slug' => 'elfsight-social-share-buttons',
        'version' => '1.4.0',
        'text_domain' => 'elfsight-social-share-buttons',
        'editor_settings' => $elfsight_social_share_buttons_config['settings'],
        'editor_preferences' => $elfsight_social_share_buttons_config['preferences'],
        'script_url' => plugins_url('assets/elfsight-social-share-buttons.js', __FILE__),

        'plugin_name' => esc_html__('Elfsight Social Share Buttons'),
        'plugin_file' => __FILE__,
        'plugin_slug' => plugin_basename(__FILE__),

        'vc_icon' => plugins_url('assets/img/vc-icon.png', __FILE__),

        'menu_icon' => plugins_url('assets/img/menu-icon.png', __FILE__),
        'update_url' => esc_url('https://a.elfsight.com/updates/v1/'),

        'preview_url' => plugins_url('preview/index.html', __FILE__),
        'observer_url' => plugins_url('preview/social-share-buttons-observer.js', __FILE__),

        'product_url' => esc_url('https://codecanyon.net/item/elfsight-social-share-buttons-wordpress-plugin/20574814?ref=Elfsight'),
        'support_url' => esc_url('https://elfsight.ticksy.com/submit/#100010647'),
    )
);

?>