<?php 
/**
Plugin Name: Social Locker | BizPanda
Plugin URI: http://codecanyon.net/item/social-locker-for-wordpress/3667715?ref=OnePress&utm_source=plugin&utm_medium=plugin-uri&utm_campaign=plugin-uri
Description: Social Locker is a set of social buttons and a locker in one bottle. <strong>Give people a reason</strong> why they need to click your social buttons. Ask people to “pay” with a Like/Tweet/+1 to get access to your content, to get discount, to download, to watch a video, to view a funny picture or so. And it will help you to get more likes/tweets/+1s, traffic and customers!
Author: پرشین اسکریپت
Version: 5.3.0
Author URI: http://www.persianscript.ir
*/

// ---
// Constatns & Resources
//

if (defined('SOCIALLOCKER_PLUGIN_ACTIVE')) return;
define('SOCIALLOCKER_PLUGIN_ACTIVE', true);



define('SOCIALLOCKER_DIR', dirname(__FILE__));
define('SOCIALLOCKER_URL', plugins_url( null, __FILE__ ));



// ---
// BizPanda Framework
//

// inits bizpanda and its items
require( SOCIALLOCKER_DIR . '/bizpanda/connect.php');
define('SOCIALLOCKER_BIZPANDA_VERSION', 135);

/**
 * Fires when the BizPanda connected.
 */
function onp_sl_init_bizpanda( $activationHook = false ) {
    
    /**
     * Displays a note about that it's requited to update other plugins.
     */
    if ( !$activationHook && !bizpanda_validate( SOCIALLOCKER_BIZPANDA_VERSION, 'Social Locker' ) ) return;

    // enabling features the plugin requires
    
    BizPanda::enableFeature('lockers');
    BizPanda::enableFeature('terms');
    BizPanda::enableFeature('social');
        BizPanda::enableFeature('linkedin');
        BizPanda::enableFeature('sociallocker-premium');
    

    
    // creating the plugin object

    global $sociallocker;
    $sociallocker = new Factory325_Plugin(__FILE__, array(
        'name'          => 'sociallocker-next',
        'title'         => 'Social Locker',
        'version'       => '5.3.0',
        'assembly'      => 'premium',
        'lang'          => 'en_US',
        'api'           => 'http://api.byonepress.com/1.1/',
        'premium'       => 'http://api.byonepress.com/public/1.0/get/?product=sociallocker-next',
        'styleroller'   => 'http://sociallocker.org/styleroller',
        'account'       => 'http://accounts.byonepress.com/',
        'updates'       => SOCIALLOCKER_DIR . '/plugin/updates/',
        'tracker'       => /*@var:tracker*/'0900124461779baebd4e030b813535ac'/*@*/,
        'childPlugins'  => array( 'bizpanda' )
    )); 
    

        BizPanda::registerPlugin($sociallocker, 'sociallocker', 'premium'); 
    


    // requires factory modules
    $sociallocker->load(array(
        array( 'bizpanda/libs/factory/bootstrap', 'factory_bootstrap_330', 'admin' ),
        array( 'bizpanda/libs/factory/notices', 'factory_notices_323', 'admin' ),
        array( 'bizpanda/libs/onepress/api', 'onp_api_320' ),
        array( 'bizpanda/libs/onepress/licensing', 'onp_licensing_325' ),
        array( 'bizpanda/libs/onepress/updates', 'onp_updates_325' )
    ));

    require(SOCIALLOCKER_DIR . '/panda-items/signin-locker/boot.php');
    require(SOCIALLOCKER_DIR . '/panda-items/social-locker/boot.php');
    require(SOCIALLOCKER_DIR . '/plugin/boot.php');
}

add_action('bizpanda_init', 'onp_sl_init_bizpanda');

/**
 * Activates the plugin.
 * 
 * TThe activation hook has to be registered before loading the plugin.
 * The deactivateion hook can be registered in any place (currently in the file plugin.class.php).
 */
function onp_sl_activation() {
    
    // if the old version of the bizpanda which doesn't contain the function bizpanda_connect has been loaded,
    // ignores activation, the message suggesting to upgrade the plugin will be appear instead
    if ( !function_exists( 'bizpanda_connect') ) return;

    // if the bizpanda has been already connected, inits the plugin manually
    if ( defined('OPANDA_ACTIVE') ) onp_sl_init_bizpanda( true );
    else bizpanda_connect();
    
    global $sociallocker;
    $sociallocker->activate();
}

register_activation_hook( __FILE__, 'onp_sl_activation' );

/**
 * Displays a note about that it's requited to update other plugins.
 */
if ( is_admin() && defined('OPANDA_ACTIVE') ) {
    bizpanda_validate( SOCIALLOCKER_BIZPANDA_VERSION, 'Social Locker' );
}