<?php
/*
* Plugin Name: 		Smart Footer System
* Plugin URI: 		https://smartfootersystem2.metaplugin.com
* Description: 		Footer plugin All-In-One for Wordpress
* Version: 			2.5.4
* Author: 			پرشین اسکریپت
* Author URI: 		http://www.persianscript.ir
* License: 			Regular Licence
* License URI: 		http://www.gnu.org/licenses/gpl-2.0.txt
* Text Domain: 		smart-footer-system
* Domain Path: 		/languages
*/

/**
* Current Version Constant
*/
define("SFS_VERSION", "2.5.4");

/**
* Default constants
*/
define("SFS_PREFIX", "Sfs");
define("SFS_PATH", plugin_dir_path(__FILE__));
define("SFS_URL", plugin_dir_url(__FILE__));
define("SFS_OPTIONS_KEY", "sfs-settings");

/**
* Debug function
*/
if(!function_exists("sfs_debug")){
	function sfs_debug($var) {
		echo '<pre style="display:none" id="sfs-footer-debug">';
		foreach(func_get_args() as $funct) {
			var_dump($funct);
			echo "---------------------------------------------------------\n";
		}
		echo "</pre>";
		echo '<script>console.log(jQuery("#sfs-footer-debug").text())</script>';
	}
}

/**
* Load plugin textdomain
*/

add_action('plugins_loaded', function() {
	load_plugin_textdomain( 'smart-footer-system', false, dirname( plugin_basename(__FILE__) ) . '/languages/' );
});

/**
* Require classes
*/
require_once(SFS_PATH . 'inc/core/class-sfs.php');
require_once(SFS_PATH . 'inc/core/class-sfs-backend.php');
require_once(SFS_PATH . 'inc/core/class-sfs-frontend.php');
require_once(SFS_PATH . 'inc/core/class-sfs-post-type.php');
require_once(SFS_PATH . 'inc/core/class-sfs-settings.php');
require_once(SFS_PATH . 'inc/core/class-sfs-shortcodes.php');

/**
* Initializate plugin
*/
SmartFooterSystem::init();
