<?php
/**
* Core class of plugin
*/
class SmartFooterSystem {
	public static function init() {
		SfsPostType::init();
		SfsBackend::init();
		SfsFrontend::init();
		SfsShortcodes::init();
		if (  defined( 'WPB_VC_VERSION' )  ) {
			add_action("vc_after_init", function(){
				add_action("current_screen", function(){
					global $vc_manager;
					$current_screen = get_current_screen();
					if(!$vc_manager || wp_doing_ajax() || (isset($_POST['originalaction']) && $_POST['originalaction'] == 'editpost')) {
						return;
					}
					$existing_vc_post_types = $vc_manager->editorPostTypes();
					$existing_vc_post_types[] = 'sfs-footer';
					$vc_manager->setEditorPostTypes( $existing_vc_post_types );
				});
			});
		}

		add_action("after_setup_theme", function(){

			if( defined('VCV_VERSION') ) {
				if(function_exists('vchelper')){
					$vcvOptionsHelper = vchelper('Options');
					$currentPostTypes = (array)$vcvOptionsHelper->get('post-types', ['post', 'page']);
					$currentPostTypes[] = 'sfs-footer';
					$vcvOptionsHelper->set('post-types', $currentPostTypes);
				}
			}

			if(function_exists("add_ux_builder_post_type")){
				add_ux_builder_post_type("sfs-footer");
			}

			add_filter( 'et_builder_post_types', function( $post_types ) {
				$post_types[] = 'sfs-footer';
				return $post_types;
			});
			add_filter( 'dslc_enabled_cpt', function ( $cpt ) {
				$cpt['sfs-footer'] = 'sfs-footer';
				return $cpt;
			});

		});

		add_action("wp_enqueue_scripts", function(){
			wp_deregister_script( 'ba-resize' );
		}, 99);

	}
}
