<?php
/**
* Smart Footer System - Settings Class
*/
class SfsSettings {
	/**
	 * Get settings
	 * @return array of data settings
	 */
	public static function get() {
		return get_option(SFS_OPTIONS_KEY, [
			"hide_footer" => false,
			"classes"	  => ""
		]);
	}
	/**
	 * Set settings
	 * @param array $data $_POST data with settings
	 * @return boolean
	 */
	public static function set($data = []) {
		return update_option(SFS_OPTIONS_KEY, $data);
	}

	/**
	 * Get the_content filters
	 * @return array of the_content filters
	 */
	public static function getContentFilters(){
		return get_option("sfs-content-filters", []);
	}

	/**
	 * Set the_content filters
	 * @return boolean
	 */
	public static function setContentFilters() {
		$filters = [];
		foreach($GLOBALS["wp_filter"]["the_content"]->callbacks as $key => $sfsDisableFilter){
			$filtersKeys = array_keys($sfsDisableFilter);
			foreach($filtersKeys as $filtersKey){
				$function = $sfsDisableFilter[$filtersKey]["function"];
				if(is_object($function) ) {
					continue;
				}
				if(!is_array($function)){
					$filters[] = $function;
					continue;
				}
				$filters[] = @get_class($function[0])."@".$function[1];
			}
		}
		return update_option("sfs-content-filters", $filters);
	}

	/**
	 * Disable content filters
	 * @return null
	 */
	public static function disableContentFilters() {
		$sfsSettings = self::get();
		if(isset($sfsSettings["disable_filters"]) && !empty($sfsSettings["disable_filters"])){
			foreach($sfsSettings["disable_filters"] as $disableFilter => $value){
				$expFilter = explode("@", $disableFilter);
				foreach($GLOBALS["wp_filter"]["the_content"]->callbacks as $key => $sfsDisableFilter){
					foreach($sfsDisableFilter as $filter => $sfsDisableFilterObj){
						$function = $sfsDisableFilterObj["function"];
						if(!is_array($function) && $function == $expFilter[0]){
							remove_filter("the_content", $filter, $key);
							remove_action("the_content", $filter, $key);
						}
						else if(!is_string($function[0]) && get_class($function[0]) == $expFilter[0] && $function[1] == $expFilter[1]) {
							remove_filter("the_content", $filter, $key);
							remove_action("the_content", $filter, $key);
						}
					}
				}
			}
		}
	}
}
