<?php
$rawDemos = @unserialize(@base64_decode(@file_get_contents(SFS_PATH.'demos/all-demos.sfsbackup')));
?>
<script>
	var sfsRawDemos = [];
	<?php foreach($rawDemos as $rawDemo): ?>
	sfsRawDemos.push('<?php echo @base64_encode(@serialize([$rawDemo])) ?>');
	<?php endforeach; ?>
</script>
<table class="form-table sfs-table sfs-table-full" id="sfs-import-export">
	<tbody>
		<tr>
			<th>
				<label data-hint="<?php echo __("If you need you can import a previously .sfsbackup generated by export option.", "smart-footer-system"); ?>"><?php echo __("Import", "smart-footer-system") ?></label>
			</th>
			<td>
				<section id="sfs-import">
					<form action="javascript:;">
						<input id="sfs-import-file" type="file" name="import-file">
						<a id="a-import" href="javascript:;" type="button" class="button button-default button-large"><?php echo __('Import','smart-footer-system') ?></a>
					</form>
					<div class="sfs-imported">
						<div class="imported">
							<span></span> <?php echo __("footers imported!", 'smart-footer-system') ?>
						</div>
						<div class="errors">
							<span></span> <?php echo __("errors", 'smart-footer-system') ?>
						</div>
					</div>
				</section>
			</td>
		</tr>
		<tr>
			<th>
				<label data-hint="<?php echo __("Use this option to generate a .sfsbackup file that save all data of your footers.", "smart-footer-system"); ?>"><?php echo __("Export", "smart-footer-system") ?></label>
			</th>
			<td>
				<section id="sfs-export">
					<a id="a-export" href="javascript:;" class="button button-default button-large"><?php echo __('Export all footers','smart-footer-system') ?></a>
					<a id="sfs-export-a" download="" href=""></a>
				</section>
			</td>
		</tr>
		<tr>
			<th>
				<label data-hint="<?php echo __("Import demos that you have seen on the official <a href='https://smartfootersystem2.metaplugin.com/demos/' target='_blank'>Smart Footer System Website</a>", "smart-footer-system"); ?>"><?php echo __("Import Demos", "smart-footer-system") ?></label>
			</th>
			<td>
				<section id="sfs-import-demo">
					<form action="javascript:;">
						<a id="sfs-import-demo-a" href="javascript:;" type="button" class="button button-default button-large"><?php echo __('Import Demos','smart-footer-system') ?></a>
						<textarea id="sfs-import-demo-textarea" style="display: none" name="" id="" cols="30" rows="10"></textarea>
					</form>
				</section>
			</td>
		</tr>
	</tbody>
</table>
<div id="sfs-import-loading">
	<div class="sfs-import-loading-content">
		<h2><?php echo __("Import Smart Footer System demos...", "smart-footer-system")  ?></h2>
		<span class="loading-bar">
			<i></i>
			<b>10/<?php echo count($rawDemos) ?></b>
		</span>
		<span class="loading-message loading-message-ok"><?php echo __("DONE!"); ?></span>
	</div>
</div>
