<table class="form-table sfs-table sfs-table-full">
	<tbody>
		<tr>
			<th>
				<label data-hint="<?php echo __("Set the master footer for your website", "smart-footer-system"); ?>" for="">
					<?php echo __("Master Footer", 'smart-footer-system') ?>
				</label>
			</th>
			<td>
				<select id="sfs-settings-master-footer" name="sfs[footers][master]">
					<option <?php echo (!isset($sfsSettings["footers"]["master"]) || !$sfsSettings["footers"]["master"]) ? 'selected' : '' ?> value="false"><?php echo __("Theme footer", 'smart-footer-system') ?></option>
					<?php foreach($sfsFooters as $sfsFooter): ?>
						<option <?php echo (isset($sfsSettings["footers"]["master"]) && $sfsSettings["footers"]["master"] == $sfsFooter->ID) ? 'selected' : '' ?> value="<?php echo $sfsFooter->ID ?>"><?php echo $sfsFooter->post_title ?></option>
					<?php endforeach; ?>
				</select>
			</td>
		</tr>
		<tr>
			<th>
				<label data-hint="<?php echo __("Use this selector to hide your Theme footer. Alternatively you can leave it off so that new footer blocks will go under your Theme footer.", "smart-footer-system"); ?>" for="sfs-hide-footer-check">
					<?php echo __("Hide Theme Footer", "smart-footer-system") ?>
				</label>
			</th>
			<td>
				<input <?php echo (isset($sfsSettings['hide_footer']) && $sfsSettings['hide_footer']) ? 'checked': '' ?> id="sfs-hide-footer-check" name="sfs[hide_footer]" type="checkbox" class="regular-text">
			</td>
		</tr>
		<tr>
			<th>
				<label data-hint="<?php echo __("If the action “Hide Theme footer” doesn’t work properly you can manually insert css classes to hide Theme or custom elements.", "smart-footer-system"); ?>" for="sfs-classes">
					<?php echo __("Css selectors to hide (optional)", 'smart-footer-system') ?>
				</label>
			</th>
			<td>
				<input value="<?php echo (isset($sfsSettings['classes'])) ? $sfsSettings['classes']: '' ?>" id="sfs-classes" name="sfs[classes]" type="text" class="regular-text">
				<p class="description" id="tagline-description"><?php echo __('Es: .my-theme-footer, .footer, #footer', 'smart-footer-system') ?></p>
			</td>
		</tr>
		<tr>
			<th>
				<label data-hint="<?php echo __("Use this option if you want to execute SFS in another hook. Example: do_action('my_custom_hook'). See <a target='_blank' href='https://developer.wordpress.org/reference/functions/do_action/'>do_action Wordpress Referece for details.</a>", "smart-footer-system"); ?>">
					<?php echo __("Custom WP Hook", "smart-footer-system") ?>
				</label>
			</th>
			<td>
				<input value="<?php echo (isset($sfsSettings['custom_hook']) && $sfsSettings['custom_hook']) ? $sfsSettings['custom_hook'] : '' ?>" id="sfs-custom-hook-name" name="sfs[custom_hook]" type="text" class="regular-text">
			</td>
		</tr>
		<tr>
			<th>
				<label data-hint="<?php echo __("Use this option if you don't want to load the Font Awesome icons", "smart-footer-system"); ?>">
					<?php echo __("Disable Font Awesome Icons", "smart-footer-system") ?>
				</label>
			</th>
			<td>
				<input <?php echo (isset($sfsSettings['disable_font_awesome']) && $sfsSettings['disable_font_awesome']) ? 'checked' : '' ?> id="sfs-disable-font-awesome-icons" name="sfs[disable_font_awesome]" type="checkbox" class="regular-text">
			</td>
		</tr>
		<tr>
			<th>
				<label data-hint="<?php echo __("Use this option if you don't want to load the Genericons icons", "smart-footer-system"); ?>">
					<?php echo __("Disable Genericons Icons", "smart-footer-system") ?>
				</label>
			</th>
			<td>
				<input <?php echo (isset($sfsSettings['disable_genericons']) && $sfsSettings['disable_genericons'])  ? 'checked' : '' ?> id="sfs-disable-genricons-icons" name="sfs[disable_genericons]" type="checkbox" class="regular-text">
			</td>
		</tr>
		<tr>
			<th>
				<label data-hint="<?php echo __("Use this option if you don't want to load the Elegant icons", "smart-footer-system"); ?>">
					<?php echo __("Disable Elegant Icons", "smart-footer-system") ?>
				</label>
			</th>
			<td>
				<input <?php echo (isset($sfsSettings['disable_elegant_icons']) && $sfsSettings['disable_elegant_icons'])  ? 'checked' : ''  ?> id="sfs-disable-elegant-icons" name="sfs[disable_elegant_icons]" type="checkbox" class="regular-text">
			</td>
		</tr>
		<tr>
			<th colspan="2" style="width: 100%">
				<label data-hint="<?php echo __("A footer made with SFS is a WordPress post and many plugins interfere with it by adding their own functionality to the <b>the_content</b> hook, such as the like, rating or share buttons. In order to show the filters below, you need to visit at least once a footer on frontend.", "smart-footer-system"); ?>">
					<?php echo __("Disable filters for the footer content", "smart-footer-system") ?>
				</label>
				<?php
				$sfsSettingsFilters = SfsSettings::getContentFilters();
				natsort($sfsSettingsFilters);
				foreach($sfsSettingsFilters as $filter): ?>
				<div style="margin: 5px; display: inline-block; min-width: 405px; border: 1px solid #E9E9E9; padding:10px; ">
					<span style="display: block; margin-left: 4px; margin-bottom: 15px; font-weight: normal!important">
						<?php
						$filter_label 	= preg_replace('/([A-Z]+)/', " $1", $filter);
						$filter_label 	= str_replace("\\" ,'', $filter_label);
						$filter_label  	= str_replace("@", " <br> ", $filter_label);
						$filter_label 	= str_replace("_",' ', $filter_label);
						$filter_label 	= ucwords($filter_label);
						echo $filter_label;
						?>
					</span>
					<input <?php echo (@isset($sfsSettings['disable_filters'][$filter])) ? 'checked': '' ?> id="sfs-filter-<?php echo $filter ?>-footer-check" name="sfs[disable_filters][<?php echo $filter ?>]" type="checkbox" value="" class="regular-text">
				</div>
				<?php endforeach; ?>
			</th>
		</tr>
	</tbody>
</table>
