<?php
namespace SlimSEOPro\ContentAnalysis\Integrations;

class BeaverBuilder extends Base {
	protected function is_active(): bool {
		return defined( 'FL_BUILDER_VERSION' );
	}

	protected function get_content( int $post_id ): string {
		if ( ! \FLBuilderModel::is_builder_enabled( $post_id ) ) {
			return '';
		}

		$post_content = get_post_field( 'post_content', $post_id );
		$post_content = do_shortcode( $post_content );
		$post_content = do_blocks( $post_content );

		return $post_content;
	}
}
