<?php
namespace SlimSEOPro\ContentAnalysis\Integrations;

abstract class Base {
	protected $location;

	public function __construct() {
		add_action( 'init', [ $this, 'setup' ] );
	}

	abstract protected function is_active(): bool;
	abstract protected function get_content( int $post_id ): string;

	public function setup(): void {
		if ( ! $this->is_active() ) {
			return;
		}

		add_filter( 'slim_seo_pro_builder_content', [ $this, 'builder_content' ], 10, 2 );
	}

	public function builder_content( string $content, int $post_id ): string {
		return $this->get_content( $post_id ) ?: $content;
	}
}
