jQuery(function($) {
    function copyToClipboard(element) {
        var $temp = $("<input>");
        $("body").append($temp);
        $temp.val($(element).text()).select();
        document.execCommand("copy");
        $temp.remove();
    }

    // Copy to clipboard for manage popups
    $('.sppro_ctc').click(function() {
        $(this).focus().select();
        document.execCommand('copy');
        $(this).find('.sppro_ctc_alert').text("Copied!");
    });

    // Delete Popup
    $(".delete-popup").on('click', function(e) {
        e.preventDefault();
        const $btnClicked = $(this);
        const popupDelete = confirm('Are you sure you want to delete popup?');
        const $noticeArea = $('.sppro-notice-area');

        $btnClicked.addClass('disabled');
        $btnClicked.find('.dashicons').addClass('spin');

        if (popupDelete) {
            $.post(
                ajaxurl,
                {
                    post_id: $btnClicked.attr('data-popup_id'),
                    action: 'action_delete_sppro_popup',
                },
                function(response) {
                    if (response.success === true) {
                        if (response.data.reload !== undefined) {
                            location.reload();
                        }
                    }

                    if (response.data.reason !== undefined) {
                        $noticeArea.html(response.data.reason);
                    }
                    $btnClicked.removeClass('disabled');
                    $btnClicked.find('.dashicons').removeClass('spin');
                }
            );
        }
    });

    // Notice dismissable
    $('.sppro-dismissable').click(function(e) {
        e.preventDefault();
        var $btnClicked = $(this);
        var $parentBox = $btnClicked.closest('.notice');
        $parentBox.hide();
        $.post(
            ajaxurl,
            {
                action: 'sppro_notice_dismissable',
                dataBtn: $btnClicked.attr('data-btn'),
            },
            function(response) {
                // Handle response if needed
            }
        );
    });

    // Import page import button
    $('.sppro-btn-importer').click(function(e) {
        e.preventDefault();
        var $btnClicked = $(this);
        var $parentForm = $btnClicked.closest('form');
        var $loader = $parentForm.find('.sp-loader');
        var $importResult = $parentForm.find('.import-box-result');

        $loader.css('visibility', 'visible');
        $importResult.empty().removeClass('error success').slideUp();
        $btnClicked.addClass('disable');
        $('.sppro-btn-importer').hide();

        $.post(
            ajaxurl,
            {
                action: 'sppro_action_importDemo',
                title: $btnClicked.attr('data-title'),
            },
            function(response) {
                if (response.success === true) {
                    $importResult.addClass('success').html(response.data.reason);
                    if (response.data.reload) {
                        setTimeout(function() {
                            location.reload();
                        }, 1000);
                    }
                } else {
                    $importResult.addClass('error').html(response.data.reason);
                    if (response.data.reason.indexOf("exists") !== -1) {
                        // Handle exists case
                    }
                }
                $importResult.slideDown();
                $loader.css('visibility', 'hidden');
                $('.sppro-btn-importer').show();
            }
        );
    });

    jQuery('.sp-update-license').click(function (e) {

        if(! $(this).closest('form')[0].checkValidity()){
            return;
        }

        e.preventDefault();

        let $btnClicked = jQuery(this);

        if($btnClicked.hasClass('disabled')) return;

        let $parentForm = jQuery(this).closest('form');
        let $purchaseInput = jQuery('#purchase_code');
        let $loader = $parentForm.find('.sp-loader');
        let $importResult = $parentForm.find('.result-area');

        $purchaseInput.prop('disabled', false);

        //$btnClicked.addClass('animate');
        $loader.css({'visibility': 'visible'}); //slideDown();
        $importResult.html('').removeClass('error').removeClass('success');
        $btnClicked.addClass('disabled');

        let formFields = $parentForm.serialize();

        jQuery.post(
            ajaxurl,
            {
                action: 'action_sppro_update_license',
                fields: formFields,
            },
            function (response) {
                if (response.success === true) {
                    $importResult.addClass('notice notice-success').html(response.data.reason);
                    if (response.data.reload)
                        setTimeout(function () {
                            location.reload();
                        }, 1000);
                } else {
                    $importResult.addClass('error').html(response.data.reason);
                    if (response.data.reason.indexOf("exists") === 0) {
                    }
                }
                $btnClicked.removeClass('disabled');
                $loader.css({'visibility': 'hidden'}) //.slideUp();
            }
        );
    });

    // Help and Support form submit button
    $('.sp-submit-btn').click(function(e) {

        if(!$(this).closest('form')[0].checkValidity()){
            return;
        }

        e.preventDefault();

        var $btnClicked = $(this);

        if ($btnClicked.hasClass('disabled')) {
            return;
        }

        var $parentForm = $btnClicked.closest('form');
        var $loader = $parentForm.find('.sp-loader');
        var $importResult = $parentForm.find('.result-area');

        $loader.css('visibility', 'visible');
        $importResult.empty().removeClass('error success').slideUp();
        $btnClicked.addClass('disabled');

        var formFields = $parentForm.serialize();

        $.post(
            ajaxurl,
            {
                action: 'action_sppro_contact_support',
                fields: formFields,
            },
            function(response) {
                if (response.success === true) {
                    $importResult.addClass('notice notice-success').html(response.data.reason);
                    if (response.data.reload) {
                        setTimeout(function() {
                            location.reload();
                        }, 1000);
                    }
                    $parentForm[0].reset();
                } else {
                    $importResult.addClass('error').html(response.data.reason);
                    if (response.data.reason.indexOf("exists") === 0) {
                        // Handle exists case
                    }
                }
                $importResult.slideDown();
                $loader.css('visibility', 'hidden');
                $btnClicked.removeClass('disabled');
            }
        );
    });
});