<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class XforWC_PDF_Print_Share_Settings {

	public static $plugin;

	public static function init() {

		self::$plugin = array(
			'name'    => 'Share, Print and PDF for WooCommerce',
			'xforwc'  => 'Print, PDF and Share',
			'slug'    => 'share-print-pdf',
			'label'   => 'share_print_pdf',
			'image'   => Wcmnspp()->plugin_url() . '/includes/images/share-print-pdf-for-woocommerce-elements.png',
			'path'    => 'share-print-pdf-woocommerce/share-woo',
			'version' => XforWC_PDF_Print_Share::$version,
		);

		if ( SevenVXGet()->plugin_page_check( self::$plugin['label'] ) ) {
			add_filter( 'svx_plugins_settings', array( 'XforWC_PDF_Print_Share_Settings', 'get_settings' ), 50 );
		}

		if ( function_exists( 'XforWC' ) ) {
			add_filter( 'xforwc_settings', array( 'XforWC_PDF_Print_Share_Settings', 'xforwc' ), 9999999141 );
			add_filter( 'xforwc_svx_get_share_print_pdf', array( 'XforWC_PDF_Print_Share_Settings', '_get_settings_xforwc' ) );
		}

		add_filter( 'svx_plugins', array( 'XforWC_PDF_Print_Share_Settings', 'add_plugin' ), 0 );
	}

	public static function xforwc( $settings ) {
		$settings['plugins'][] = self::$plugin;

		return $settings;
	}

	public static function add_plugin( $plugins ) {
		$plugins[ self::$plugin['label'] ] = array(
			'slug' => self::$plugin['label'],
			'name' => self::$plugin['xforwc'],
		);

		return $plugins;
	}

	public static function _get_settings_xforwc() {
		$settings = self::get_settings( array() );
		return $settings[ self::$plugin['label'] ];
	}

	public static function get_settings( $plugins ) {

		$plugins[ self::$plugin['label'] ] = array(
			'slug'     => self::$plugin['label'],
			'name'     => esc_html( function_exists( 'XforWC' ) ? self::$plugin['xforwc'] : self::$plugin['name'] ),
			'desc'     => esc_html( function_exists( 'XforWC' ) ? self::$plugin['name'] . ' v' . self::$plugin['version'] : esc_html__( 'Settings page for', 'share-print-pdf-woocommerce' ) . ' ' . self::$plugin['name'] ),
			'link'     => esc_url( 'https://xforwoocommerce.com/store/pdf-print-and-share/' ),
			'ref'      => array(
				'name' => esc_html__( 'Visit XforWooCommerce.com', 'share-print-pdf-woocommerce' ),
				'url'  => 'https://xforwoocommerce.com',
			),
			'doc'      => array(
				'name' => esc_html__( 'Get help', 'share-print-pdf-woocommerce' ),
				'url'  => 'https://help.xforwoocommerce.com',
			),
			'sections' => array(
				'dashboard'       => array(
					'name' => esc_html__( 'Dashboard', 'share-print-pdf-woocommerce' ),
					'desc' => esc_html__( 'Dashboard Overview', 'share-print-pdf-woocommerce' ),
				),
				'general'         => array(
					'name' => esc_html__( 'General', 'share-print-pdf-woocommerce' ),
					'desc' => esc_html__( 'General Options', 'share-print-pdf-woocommerce' ),
				),
				'print_pdf_setup' => array(
					'name' => esc_html__( 'Print/PDF Setup', 'share-print-pdf-woocommerce' ),
					'desc' => esc_html__( 'Print/PDF Setup Options', 'share-print-pdf-woocommerce' ),
				),
				'installation'    => array(
					'name' => esc_html__( 'Installation', 'share-print-pdf-woocommerce' ),
					'desc' => esc_html__( 'Installation Options', 'share-print-pdf-woocommerce' ),
				),
			),
			'settings' => array(

				'wcmn_dashboard'                 => array(
					'type'    => 'html',
					'id'      => 'wcmn_dashboard',
					'desc'    => '
						<h3><span class="dashicons dashicons-store"></span> XforWooCommerce</h3>
						<p>' . esc_html__( 'Visit XforWooCommerce.com store, demos and knowledge base.', 'share-print-pdf-woocommerce' ) . '</p>
						<p><a href="https://xforwoocommerce.com" class="xforwc-button-primary x-color" target="_blank">XforWooCommerce.com</a></p>

						<br /><hr />

						<h3><span class="dashicons dashicons-admin-tools"></span> ' . esc_html__( 'Help Center', 'share-print-pdf-woocommerce' ) . '</h3>
						<p>' . esc_html__( 'Need support? Visit the Help Center.', 'share-print-pdf-woocommerce' ) . '</p>
						<p><a href="https://help.xforwoocommerce.com" class="xforwc-button-primary red" target="_blank">XforWooCommerce.com HELP</a></p>
						
						<br /><hr />

						<h3><span class="dashicons dashicons-update"></span> ' . esc_html__( 'Automatic Updates', 'share-print-pdf-woocommerce' ) . '</h3>
						<p>' . esc_html__( 'Get automatic updates, by downloading and installing the Envato Market plugin.', 'share-print-pdf-woocommerce' ) . '</p>
						<p><a href="https://envato.com/market-plugin/" class="svx-button" target="_blank">Envato Market Plugin</a></p>
						
						<br />',
					'section' => 'dashboard',
				),

				'wcmn_utility'                   => array(
					'name'    => esc_html__( 'Plugin Options', 'share-print-pdf-woocommerce' ),
					'type'    => 'utility',
					'id'      => 'wcmn_utility',
					'desc'    => esc_html__( 'Quick export/import, backup and restore, or just reset your optons here', 'share-print-pdf-woocommerce' ),
					'section' => 'dashboard',
				),

				'wc_settings_spp_enable'         => array(
					'name'     => esc_html__( 'Installation Method', 'share-print-pdf-woocommerce' ),
					'type'     => 'select',
					'desc'     => esc_html__( 'Select method for installing the Share, Print and PDF template in your single product page.', 'share-print-pdf-woocommerce' ),
					'id'       => 'wc_settings_spp_enable',
					'autoload' => true,
					'options'  => array(
						'override' => esc_html__( 'Override WooCommerce Template', 'share-print-pdf-woocommerce' ),
						'action'   => esc_html__( 'Init Action', 'share-print-pdf-woocommerce' ),
					),
					'default'  => 'yes',
					'section'  => 'installation',
				),

				'wc_settings_spp_action'         => array(
					'name'     => esc_html__( 'Init Action', 'share-print-pdf-woocommerce' ),
					'type'     => 'text',
					'desc'     => esc_html__( 'Change default plugin initialization action on single product pages. Use actions done in your content-single-product.php file. Please enter action in the following format action_name:priority.', 'share-print-pdf-woocommerce' ) . ' ( default: woocommerce_single_product_summary:60 )' . ' (default: :60)',
					'id'       => 'wc_settings_spp_action',
					'autoload' => true,
					'default'  => 'woocommerce_single_product_summary:60',
					'section'  => 'installation',
				),

				'wc_settings_spp_force_scripts'  => array(
					'name'     => esc_html__( 'Plugin Scripts', 'share-print-pdf-woocommerce' ),
					'type'     => 'checkbox',
					'desc'     => esc_html__( 'Check this option to enable plugin scripts in all pages. This option fixes issues in Quick Views.', 'share-print-pdf-woocommerce' ),
					'id'       => 'wc_settings_spp_force_scripts',
					'autoload' => true,
					'default'  => 'no',
					'section'  => 'installation',
				),

				'wc_settings_spp_style'          => array(
					'name'     => esc_html__( 'Icons Style', 'share-print-pdf-woocommerce' ),
					'type'     => 'select',
					'desc'     => esc_html__( 'Choose share icons style.', 'share-print-pdf-woocommerce' ),
					'id'       => 'wc_settings_spp_style',
					'autoload' => false,
					'options'  => array(
						'line-icons'        => esc_html__( 'Gray', 'share-print-pdf-woocommerce' ),
						'background-colors' => esc_html__( 'Backgrounds', 'share-print-pdf-woocommerce' ),
						'border-colors'     => esc_html__( 'Borders', 'share-print-pdf-woocommerce' ),
						'flat'              => esc_html__( 'Flat Colors', 'share-print-pdf-woocommerce' ),

					),
					'default'  => 'line-icons',
					'section'  => 'general',
				),

				'wc_settings_spp_shares'         => array(
					'name'     => esc_html__( 'Hide Icons', 'share-print-pdf-woocommerce' ),
					'type'     => 'multiselect',
					'desc'     => esc_html__( 'Select icons to hide on your webiste.', 'share-print-pdf-woocommerce' ),
					'id'       => 'wc_settings_spp_shares',
					'autoload' => false,
					'options'  => array(
						'facebook' => esc_html__( 'Facebook', 'share-print-pdf-woocommerce' ),
						'twitter'  => esc_html__( 'X (formerly Twitter)', 'share-print-pdf-woocommerce' ),
						'pin'      => esc_html__( 'Pinterest', 'share-print-pdf-woocommerce' ),
						'linked'   => esc_html__( 'LinkedIn', 'share-print-pdf-woocommerce' ),
						'whatsapp' => esc_html__( 'WhatsApp', 'share-print-pdf-woocommerce' ),
						'viber'    => esc_html__( 'Viber', 'share-print-pdf-woocommerce' ),
						'print'    => esc_html__( 'Print', 'share-print-pdf-woocommerce' ),
						'pdf'      => esc_html__( 'PDF', 'share-print-pdf-woocommerce' ),
						'email'    => esc_html__( 'Email', 'share-print-pdf-woocommerce' ),
					),
					'default'  => array(),
					'section'  => 'general',
					'class'    => 'svx-selectize',
				),

				'wc_settings_spp_pagesize'       => array(
					'name'     => esc_html__( 'Page Size', 'share-print-pdf-woocommerce' ),
					'type'     => 'select',
					'desc'     => esc_html__( 'Select print and PDF page format.', 'share-print-pdf-woocommerce' ),
					'id'       => 'wc_settings_spp_pagesize',
					'autoload' => false,
					'options'  => array(
						'letter' => esc_html__( 'Letter', 'share-print-pdf-woocommerce' ),
						'legal'  => esc_html__( 'Legal', 'share-print-pdf-woocommerce' ),
						'a4'     => 'A4',
						'a3'     => 'A3',
					),
					'default'  => 'letter',
					'section'  => 'print_pdf_setup',
				),
				
				'wc_settings_spp_logo'           => array(
					'name'     => esc_html__( 'Page Logo', 'share-print-pdf-woocommerce' ),
					'type'     => 'file',
					'desc'     => esc_html__( 'Set page logo in print and PDF mode.', 'share-print-pdf-woocommerce' ),
					'id'       => 'wc_settings_spp_logo',
					'autoload' => false,
					'default'  => '',
					'section'  => 'print_pdf_setup',
				),

				'wc_settings_spp_title'          => array(
					'name'      => esc_html__( 'Page Title', 'share-print-pdf-woocommerce' ),
					'type'      => 'textarea',
					'desc'      => esc_html__( 'Replace page title in print and PDF mode.', 'share-print-pdf-woocommerce' ),
					'id'        => 'wc_settings_spp_title',
					'autoload'  => false,
					'translate' => true,
					'default'   => '',
					'section'   => 'print_pdf_setup',
				),

				'wc_settings_spp_header_after'   => array(
					'name'      => esc_html__( 'Header After', 'share-print-pdf-woocommerce' ),
					'type'      => 'textarea',
					'desc'      => esc_html__( 'Set custom content after header in print and PDF mode.', 'share-print-pdf-woocommerce' ),
					'id'        => 'wc_settings_spp_header_after',
					'autoload'  => false,
					'translate' => true,
					'default'   => '',
					'section'   => 'print_pdf_setup',
				),

				'wc_settings_spp_product_before' => array(
					'name'      => esc_html__( 'Product Before', 'share-print-pdf-woocommerce' ),
					'type'      => 'textarea',
					'desc'      => esc_html__( 'Set custom content before product content in print and PDF mode.', 'share-print-pdf-woocommerce' ),
					'id'        => 'wc_settings_spp_product_before',
					'autoload'  => false,
					'translate' => true,
					'default'   => '',
					'section'   => 'print_pdf_setup',
				),

				'wc_settings_spp_product_after'  => array(
					'name'      => esc_html__( 'Product After', 'share-print-pdf-woocommerce' ),
					'type'      => 'textarea',
					'desc'      => esc_html__( 'Set custom content after product content in print and PDF mode.', 'share-print-pdf-woocommerce' ),
					'id'        => 'wc_settings_spp_product_after',
					'autoload'  => false,
					'translate' => true,
					'default'   => '',
					'section'   => 'print_pdf_setup',
				),

			),
		);

		return SevenVX()->_do_options( $plugins, self::$plugin['label'] );
	}

}

	XforWC_PDF_Print_Share_Settings::init();
