<?php
/**
 * View: PayPal logo small.
 *
 * @since 4.25.0
 * @version 4.25.0
 *
 * @var string[] $classes        Additional classes to add to the svg icon.
 * @var string   $label          The label for the icon.
 * @var bool     $is_aria_hidden Whether the icon is hidden from screen readers. Default false to show the icon.
 * @var Template $this           The template instance.
 *
 * @package LearnDash\Core
 */

use LearnDash\Core\Template\Template;

$svg_classes = [ 'ld-svgicon__paypal-small' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}

if ( empty( $label ) ) {
	$label = __( 'PayPal logo', 'learndash' );
}

$this->template(
	'components/icons/icon/start',
	[
		'classes' => $svg_classes,
		'height'  => 14,
		'label'   => $label,
		'width'   => 53,
	],
);

?>

<mask id="mask0_16807_55248" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0" width="53" height="14">
	<path d="M0 0H52.1849V14H0V0Z" fill="white"/>
</mask>
<g mask="url(#mask0_16807_55248)">
	<path d="M19.042 8.48514C19.8001 8.48451 20.533 8.20975 21.1084 7.71044C21.6839 7.21112 22.0641 6.52013 22.1804 5.76213C22.4256 4.18208 21.2055 2.80275 19.4768 2.80275H16.6906C16.6383 2.80207 16.5876 2.82053 16.5477 2.85473C16.5078 2.88893 16.4815 2.93657 16.4737 2.98885L15.2319 10.9645C15.2274 10.9936 15.2292 11.0234 15.2372 11.0518C15.2451 11.0801 15.259 11.1064 15.278 11.1289C15.2969 11.1513 15.3204 11.1693 15.3468 11.1817C15.3733 11.194 15.4021 11.2005 15.4312 11.2005H16.9056C16.9577 11.2011 17.0083 11.1825 17.0481 11.1483C17.0878 11.1141 17.114 11.0666 17.1219 11.0144L17.4872 8.67156C17.495 8.61927 17.5212 8.57161 17.561 8.53735C17.6008 8.50309 17.6515 8.48455 17.7038 8.48514H19.042ZM20.2759 5.69023C20.1848 6.27428 19.7387 6.70468 18.8848 6.70468H17.7927L18.1238 4.57971H19.1961C20.0794 4.58162 20.3665 5.10873 20.2759 5.69182V5.69023ZM28.5683 5.31486H27.1684C27.1162 5.31425 27.0655 5.33273 27.0256 5.36692C26.9858 5.40111 26.9595 5.44871 26.9515 5.50096L26.9062 5.79489C26.9062 5.79489 25.8195 4.59403 23.8962 5.40521C22.7927 5.86997 22.2634 6.83034 22.0383 7.53336C22.0383 7.53336 21.3225 9.67042 22.9405 10.8471C22.9405 10.8471 24.4403 11.9783 26.1298 10.7771L26.1005 10.9645C26.096 10.9936 26.0977 11.0234 26.1057 11.0518C26.1136 11.0802 26.1275 11.1065 26.1464 11.129C26.1654 11.1514 26.1889 11.1694 26.2154 11.1818C26.2419 11.1941 26.2707 11.2005 26.2998 11.2005H27.6991C27.7513 11.2012 27.8021 11.1827 27.8419 11.1485C27.8818 11.1143 27.9081 11.0667 27.916 11.0144L28.7673 5.5509C28.7718 5.52176 28.77 5.49199 28.762 5.46362C28.7541 5.43525 28.7402 5.40895 28.7212 5.38653C28.7023 5.36411 28.6788 5.3461 28.6524 5.33373C28.6259 5.32136 28.5974 5.31492 28.5683 5.31486ZM26.5101 8.33436C26.4554 8.71503 26.266 9.06269 25.9772 9.31283C25.6884 9.56296 25.3197 9.69861 24.9396 9.6946C24.7907 9.69631 24.6425 9.6743 24.5004 9.62938C23.8968 9.43343 23.5526 8.8462 23.6516 8.20998C23.7064 7.82826 23.8966 7.47974 24.1866 7.22941C24.4766 6.97908 24.8467 6.84403 25.2278 6.84942C25.3768 6.84783 25.5252 6.8701 25.6673 6.91496C26.2687 7.11027 26.6107 7.6975 26.5117 8.33436H26.5101Z" fill="#003087"/>
	<path d="M39.193 8.48514C39.9514 8.48493 40.6849 8.21038 41.2609 7.71105C41.8369 7.21172 42.2175 6.5205 42.3341 5.76212C42.579 4.18207 41.3593 2.80275 39.6299 2.80275H36.8446C36.7925 2.80221 36.7418 2.82073 36.702 2.85491C36.6623 2.88909 36.636 2.93664 36.628 2.98884L35.3825 10.9667C35.3754 11.0106 35.3828 11.0557 35.4035 11.095C35.4243 11.1343 35.4572 11.1656 35.4973 11.184C35.5238 11.1965 35.5526 11.203 35.5818 11.2031H37.0565C37.1088 11.2036 37.1594 11.185 37.1992 11.1508C37.239 11.1165 37.2653 11.0689 37.2731 11.0167L37.6387 8.67377C37.6465 8.62146 37.6727 8.57376 37.7125 8.53949C37.7523 8.50522 37.8031 8.4867 37.8553 8.48736L39.193 8.48514ZM40.4269 5.69023C40.3357 6.27427 39.8896 6.70468 39.0355 6.70468H37.9437L38.275 4.57971H39.3473C40.2301 4.58161 40.5177 5.10872 40.4269 5.69182V5.69023ZM48.7189 5.31486H47.3206C47.2684 5.31432 47.2178 5.33284 47.178 5.36702C47.1382 5.4012 47.112 5.44875 47.104 5.50095L47.0581 5.79488C47.0581 5.79488 45.9717 4.59402 44.0484 5.4052C42.9453 5.86996 42.4155 6.83033 42.1901 7.53335C42.1901 7.53335 41.4746 9.67041 43.0924 10.8471C43.0924 10.8471 44.5925 11.9783 46.2819 10.7771L46.2527 10.9645C46.2456 11.0084 46.253 11.0535 46.2737 11.0928C46.2944 11.1321 46.3274 11.1633 46.3675 11.1818C46.3939 11.1945 46.4228 11.2008 46.452 11.2008H47.8513C47.9036 11.2016 47.9544 11.1832 47.9942 11.1489C48.0341 11.1146 48.0602 11.0668 48.0679 11.0144L48.9195 5.55089C48.9237 5.52166 48.9217 5.49186 48.9137 5.46346C48.9057 5.43505 48.8918 5.40869 48.873 5.38611C48.8541 5.36348 48.8304 5.34536 48.8038 5.33304C48.7772 5.32072 48.7482 5.31451 48.7189 5.31486ZM46.6611 8.33435C46.6069 8.71531 46.4178 9.06335 46.1288 9.31361C45.8398 9.56387 45.4708 9.69928 45.0905 9.69459C44.9414 9.69637 44.793 9.67436 44.6507 9.62938C44.0468 9.43342 43.7022 8.84619 43.8013 8.20997C43.856 7.82924 44.0453 7.48151 44.3341 7.23131C44.6229 6.9811 44.9917 6.84542 45.3719 6.84942C45.5212 6.84783 45.6696 6.86978 45.8117 6.91495C46.4193 7.11027 46.7623 7.6975 46.6626 8.33435H46.6611Z" fill="#0070E0"/>
	<path d="M33.7002 5.44968L32.013 8.33143L31.157 5.47099C31.1435 5.4256 31.1159 5.38583 31.0783 5.35762C31.0407 5.32941 30.9951 5.31428 30.9482 5.31448H29.4261C29.3998 5.31397 29.3739 5.31991 29.3504 5.3318C29.3269 5.34368 29.3066 5.36114 29.2913 5.3827C29.276 5.40425 29.266 5.42925 29.2624 5.45554C29.2587 5.48184 29.2613 5.50864 29.2701 5.53366L30.8043 10.3517L29.417 12.6224C29.4013 12.6474 29.3926 12.6762 29.3917 12.7058C29.3909 12.7354 29.3979 12.7647 29.4122 12.7905C29.4264 12.8164 29.4473 12.8379 29.4726 12.8528C29.4979 12.8676 29.5266 12.8753 29.5559 12.875H31.196C31.2429 12.8752 31.289 12.8631 31.3299 12.8398C31.3707 12.8165 31.4048 12.7828 31.4289 12.742L35.7144 5.56802C35.7298 5.54298 35.7383 5.5142 35.7389 5.48469C35.7395 5.45519 35.7323 5.42607 35.7179 5.40038C35.7036 5.37469 35.6826 5.35339 35.6573 5.33872C35.632 5.32406 35.6033 5.31656 35.5741 5.31703H33.9347C33.8876 5.31647 33.8411 5.32843 33.8 5.3517C33.7588 5.37498 33.7244 5.40876 33.7002 5.44968Z" fill="#003087"/>
	<path d="M50.297 2.98689L49.0515 10.9648C49.0443 11.0087 49.0517 11.0538 49.0725 11.0931C49.0932 11.1323 49.1262 11.1636 49.1662 11.182C49.1926 11.1947 49.2215 11.2011 49.2508 11.2011H50.7248C50.7771 11.2018 50.8279 11.1833 50.8677 11.149C50.9075 11.1147 50.9337 11.067 50.9414 11.0147L52.1873 3.03683C52.1919 3.00769 52.1902 2.97787 52.1823 2.94946C52.1744 2.92106 52.1604 2.89474 52.1414 2.87237C52.1224 2.84998 52.0989 2.832 52.0724 2.81964C52.0459 2.80729 52.0171 2.80086 51.988 2.80079H50.5136C50.4614 2.80025 50.4108 2.81878 50.371 2.85296C50.3312 2.88714 50.3049 2.93469 50.297 2.98689Z" fill="#0070E0"/>
	<path d="M11.0443 6.44639C10.728 8.27075 9.25712 9.64976 7.32691 9.64976H6.10151C5.85158 9.64976 5.59978 9.88388 5.55985 10.1428L5.02323 13.5895C4.99211 13.7858 4.90125 13.851 4.70477 13.851H2.73369C2.53438 13.851 2.48723 13.7836 2.51709 13.5848L2.74344 11.2012L0.377511 11.0774C0.178517 11.0774 0.106527 10.9677 0.13482 10.7666L1.74909 0.408991C1.78022 0.212717 1.90093 0.128418 2.09678 0.128418H6.19079C8.16155 0.128418 9.40833 1.47084 9.5608 3.21154C10.7334 4.01317 11.2816 5.07979 11.0446 6.44607L11.0443 6.44639Z" fill="#001C64"/>
	<path d="M3.34856 7.34146L2.74906 11.2011L2.36993 13.6225C2.36289 13.6692 2.36587 13.7169 2.37866 13.7623C2.39145 13.8077 2.41375 13.8498 2.44406 13.8857C2.47436 13.9217 2.51195 13.9506 2.55427 13.9705C2.5966 13.9904 2.64266 14.0008 2.68933 14.0011H4.77107C4.86609 14.001 4.95795 13.9666 5.03015 13.9041C5.10235 13.8416 5.15016 13.755 5.16497 13.6601L5.71291 10.1418C5.72779 10.0469 5.77563 9.96043 5.84782 9.89798C5.92001 9.83554 6.01184 9.80119 6.10681 9.80109H7.33222C8.26597 9.79985 9.16857 9.46112 9.87731 8.84595C10.5861 8.23079 11.0543 7.37965 11.1977 6.44599C11.4099 5.07589 10.7286 3.82858 9.56265 3.2124C9.56001 3.35838 9.54741 3.504 9.52493 3.64821C9.38104 4.58139 8.91261 5.43192 8.20399 6.04662C7.49537 6.66132 6.59314 6.9998 5.65978 7.00109H3.74214C3.64724 7.00112 3.55546 7.03542 3.48331 7.09781C3.41116 7.16021 3.36338 7.2466 3.34856 7.34146Z" fill="#0070E0"/>
	<path d="M2.74788 11.2H0.323791C0.277024 11.1998 0.230854 11.1893 0.18843 11.1694C0.146005 11.1495 0.108323 11.1206 0.0779501 11.0846C0.0475776 11.0486 0.0252288 11.0064 0.0124269 10.9609C-0.000374982 10.9154 -0.00332909 10.8676 0.0037658 10.8208L1.63722 0.341013C1.6519 0.246038 1.69962 0.159492 1.77179 0.0969688C1.84395 0.0344459 1.9358 5.76323e-05 2.0308 0H6.19302C8.16379 0 9.59668 1.45122 9.56304 3.20941C9.0385 2.93557 8.45598 2.79506 7.86577 2.8H4.39579C4.30076 2.80002 4.20886 2.83434 4.1366 2.89679C4.06434 2.95924 4.01646 3.04573 4.00157 3.1407L3.34769 7.34038L2.74788 11.2Z" fill="#003087"/>
</g>

<?php
$this->template( 'components/icons/icon/end' );
