<?php
/**
 * View: Discover logo small.
 *
 * @since 4.25.0
 * @version 4.25.0
 *
 * @var string[] $classes        Additional classes to add to the svg icon.
 * @var string   $label          The label for the icon.
 * @var bool     $is_aria_hidden Whether the icon is hidden from screen readers. Default false to show the icon.
 * @var Template $this           The template instance.
 *
 * @package LearnDash\Core
 */

use LearnDash\Core\Template\Template;

$svg_classes = [ 'ld-svgicon__discover-small' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}

if ( empty( $label ) ) {
	$label = __( 'Discover logo', 'learndash' );
}

$this->template(
	'components/icons/icon/start',
	[
		'classes' => $svg_classes,
		'height'  => 17,
		'label'   => $label,
		'width'   => 26,
	],
);

?>

<g clip-path="url(#clip0_16085_26069)">
	<path d="M24.9164 16.8203H1.08355C0.4875 16.8203 0 16.3403 0 15.7536V1.88698C0 1.30031 0.4875 0.820312 1.08355 0.820312H24.9164C25.5125 0.820312 26 1.30031 26 1.88698V15.7536C26 16.3403 25.5125 16.8203 24.9164 16.8203Z" fill="white"/>
	<path d="M25.3464 8.65381C25.3464 8.65381 17.8889 14.2205 4.22461 16.4871H24.6964C25.0552 16.4871 25.3464 16.1885 25.3464 15.8205V8.65381Z" fill="#F48024"/>
	<path d="M3.4658 8.65881C3.2461 8.86214 2.9614 8.95081 2.5103 8.95081H2.3218V6.52014H2.5103C2.9614 6.52014 3.23505 6.60281 3.4658 6.81748C3.7063 7.03748 3.85255 7.38014 3.85255 7.73214C3.85255 8.08548 3.70695 8.43881 3.4658 8.65881ZM2.65005 5.89681H1.625V9.57348H2.6455C3.18695 9.57348 3.57825 9.44214 3.92145 9.14881C4.33095 8.80214 4.57145 8.27881 4.57145 7.73814C4.57145 6.65281 3.78235 5.89681 2.65005 5.89681ZM4.8945 9.57348H5.5926V5.89748H4.8945M7.29755 7.30814C6.8783 7.14814 6.75545 7.04348 6.75545 6.84481C6.75545 6.61348 6.97515 6.43814 7.27545 6.43814C7.48475 6.43814 7.657 6.52614 7.839 6.73548L8.2043 6.24414C7.904 5.97414 7.54455 5.83614 7.1526 5.83614C6.51885 5.83614 6.0359 6.28814 6.0359 6.88948C6.0359 7.39614 6.2608 7.65614 6.91665 7.89814C7.18965 7.99681 7.3294 8.06281 7.3996 8.10748C7.53935 8.20081 7.6089 8.33414 7.6089 8.48748C7.6089 8.78614 7.3788 9.00748 7.0668 9.00748C6.7353 9.00748 6.4662 8.83548 6.3063 8.51681L5.85455 8.96348C6.1763 9.44748 6.56305 9.66348 7.0941 9.66348C7.8195 9.66348 8.3291 9.16681 8.3291 8.45548C8.3291 7.87148 8.09315 7.60681 7.29885 7.30881L7.29755 7.30814ZM8.5475 7.73814C8.5475 8.81814 9.373 9.65614 10.437 9.65614C10.7373 9.65614 10.9947 9.59614 11.3126 9.44281V8.59814C11.0331 8.88481 10.7861 9.00081 10.4696 9.00081C9.76625 9.00081 9.26705 8.47748 9.26705 7.73414C9.26705 7.02748 9.78185 6.47081 10.437 6.47081C10.7698 6.47081 11.022 6.59281 11.3126 6.88414V6.04014C11.0058 5.88014 10.7536 5.81348 10.4533 5.81348C9.39575 5.81348 8.5475 6.66881 8.5475 7.73814ZM16.8493 8.36681L15.8951 5.89681H15.132L16.651 9.66748H17.0267L18.5737 5.89748H17.8165M18.889 9.57348H20.8689V8.95081H19.5864V7.95881H20.8214V7.33614H19.5864V6.52014H20.8689V5.89681H18.889M22.2346 7.58948H22.0305V6.47614H22.2449C22.6804 6.47614 22.917 6.66281 22.917 7.02148C22.917 7.39081 22.6805 7.58948 22.2346 7.58948ZM23.6353 6.98281C23.6353 6.29414 23.1738 5.89748 22.3678 5.89748H21.333V9.57348H22.0305V8.09681H22.1215L23.088 9.57348H23.946L22.8195 8.02481C23.346 7.91481 23.6353 7.54481 23.6353 6.98281Z" fill="#221F20"/>
	<path d="M15.338 7.73836C15.338 8.81836 14.4865 9.69169 13.4354 9.69169C12.3844 9.69302 11.5322 8.81836 11.5322 7.73836C11.5322 6.65836 12.3837 5.78369 13.4354 5.78369C14.4871 5.78369 15.338 6.65836 15.338 7.73836Z" fill="#F48024"/>
</g>
<defs>
	<clipPath id="clip0_16085_26069">
		<rect width="26" height="16" fill="white" transform="translate(0 0.820312)"/>
	</clipPath>
</defs>

<?php
$this->template( 'components/icons/icon/end' );
