<?php
/**
 * Cloud Firewall Visitor Logging
 * 
 * This file contains the visitor logging form content for the Cloud Firewall module.
 */

namespace WPSecurityNinja\Plugin;

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Ensure we have access to the main class
if (!class_exists('Wf_sn_cf')) {
    return;
}

/**
 * Render the visitor logging form content
 * 
 * @param array $options Current options
 */
function wf_sn_cf_render_visitor_logging_content($options) {
    ?>

<table class="form-table">
					<tbody>
						<tr valign="top">
							<th colspan="2">
								<h3><?php esc_html_e('Visitor Logging', 'security-ninja'); ?></h3>
							</th>
						</tr>
						<?php

						echo '<tr valign="top"><th scope="row"><label for="wf_sn_cf_trackvisits"><h3>' . __('Track visitors', 'security-ninja') . '</h3>';
						echo '<p class="description">' . esc_html__('Track all visitors and page requests to the website.', 'security-ninja');

						echo '</label></th><td class="sn-cf-options">';

						\WPSecurityNinja\Plugin\Utils::create_toggle_switch(
							WF_SN_CF_OPTIONS_KEY . '_trackvisits',
							array(
								'saved_value' => $options['trackvisits'],
								'option_key'  => WF_SN_CF_OPTIONS_KEY . '[trackvisits]',
							)
						);


						echo '</td></tr>';

						$trackvisits_howlong = array();
						$trackvisits_howlong[] = array('val'   => 1, 'label' => esc_html__('1 day', 'security-ninja'));
						$trackvisits_howlong[] = array('val'   => 3, 'label' => esc_html__('3 days', 'security-ninja'));
						$trackvisits_howlong[] = array('val'   => 7, 'label' => esc_html__('7 days', 'security-ninja'));
						$trackvisits_howlong[] = array('val'   => 14, 'label' => esc_html__('14 days', 'security-ninja'));

						echo '<tr valign="top">';
						echo '<th scope="row"><label for="' . esc_attr(WF_SN_CF_OPTIONS_KEY) . '_trackvisits_howlong"><h3>' . esc_html__('Keep visitor logs for', 'security-ninja') . '</h3>';
						echo '<p class="description">' . esc_html__('How long to keep a log of visitors to your website.', 'security-ninja') . '</p>';

						echo '</label></th><td class="sn-cf-options">';
			
						echo '<select name="' . esc_attr(WF_SN_CF_OPTIONS_KEY) . '[trackvisits_howlong]" id="' . esc_attr(WF_SN_CF_OPTIONS_KEY) . '_trackvisits_howlong" class="regular-text">';
						Utils::create_select_options($trackvisits_howlong, $options['trackvisits_howlong']);
						echo '</select>';

						echo '</td></tr>';

						?>
					</tbody>
				</table>

<?php
}