<?php

/**
 * Class SearchWP_Redirects
 */
class SearchWP_Redirects {

	public $settings;

	private $engine;

	/**
	 * SearchWP_Redirects constructor.
	 */
	function __construct() {
		$this->meta_key = 'searchwp_redirects';

		require_once SEARCHWP_REDIRECTS_PLUGIN_DIR . '/vendor/autoload.php';

		// Not using PSR-4 because of the way SearchWP Extensions are implemented (can't use namespaces)
		require_once SEARCHWP_REDIRECTS_PLUGIN_DIR . '/admin/settings.php';

		$this->settings = new SearchWP_Redirects_Settings();
		$this->settings->init();

		add_action( 'searchwp_before_query_index', array( $this, 'init' ) );
	}

	/**
	 * Redirect if necessary
	 *
	 * @param array $args
	 */
	function init( $args = array() ) {

		// This should only fire as a callback to searchwp_before_query_index
		if ( empty( $args ) ) {
			return;
		}

		if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
			return;
		}

		if ( is_admin() || did_action('wp') ) {
			return;
		}

		$settings = $this->settings->get();

		$redirects = isset( $settings['redirects'] ) ? $settings['redirects'] : array();

		if ( empty( $redirects ) ) {
			return;
		}

		foreach ( $redirects as $redirect ) {
			// Does this engine apply to the redirect?
			if ( is_null( $redirect['engines'] ) || ( is_array( $redirect['engines'] ) && in_array( $args['engine'], $redirect['engines'], true ) ) ) {

				$destination = false;

				// We're going to work with the original query so as to exclude potential issues of
				// common words triggering failed matches etc
				$search_query = SWP()->original_query;
				if ( empty( $search_query ) && ! empty( $args['terms'] ) ) {
					$search_query = implode( ' ', $args['terms'] );
				}

				// Does this search query apply to the redirect
				if ( ! empty( $redirect['partial'] ) ) {

					// We're going to normalize the Redirect trigger word and then strpos each search term for partial matches
					$source = explode( ' ', SWP()->clean_term_string( $redirect['query'] ) );
					foreach ( $source as $term ) {
						if ( false !== strpos( $search_query, $term ) ) {
							$destination = $redirect['redirect'];
							break;
						}
					}

				} elseif ( strtolower( $redirect['query'] ) === strtolower( $search_query ) ) {
					$destination = $redirect['redirect'];
				}

				if ( $destination ) {
					wp_safe_redirect( home_url( $destination ) );
					die();
				}
			}
		}
	}

	/**
	 * Setter for engine name
	 *
	 * @param string $engine Valid engine name
	 */
	public function set_engine( $engine = 'default' ) {
		$this->engine = SWP()->is_valid_engine( $engine ) ? $engine : 'default';
	}
}
