/* Chartist.js 0.1.15
 * Copyright © 2014 Gion Kunz
 * Free to use under the WTFPL license.
 * http://www.wtfpl.net/
 */

!function(a,b){"object"==typeof exports?module.exports=b():"function"==typeof define&&define.amd?define([],b):a.Chartist=b()}(this,function(){var a={};return a.version="0.1.14",function(a,b,c){"use strict";c.noop=function(a){return a},c.alphaNumerate=function(a){return String.fromCharCode(97+a%26)},c.extend=function(a,b){a=a||{};for(var d in b)a[d]="object"==typeof b[d]?c.extend(a[d],b[d]):b[d];return a},c.getHeight=function(a){return a.clientHeight||Math.round(a.getBBox().height)||a.parentNode.clientHeight},c.getWidth=function(a){return a.clientWidth||Math.round(a.getBBox().width)||a.parentNode.clientWidth},c.querySelector=function(a){return a instanceof Node?a:b.querySelector(a)},c.createSvg=function(a,b,d,e){var f;return void 0!==a.chartistSvg?(f=a.chartistSvg.attr({width:b||"100%",height:d||"100%"}).removeAllClasses().addClass(e),f.empty()):(f=c.svg("svg").attr({width:b||"100%",height:d||"100%"}).addClass(e),a.appendChild(f._node),a.chartistSvg=f),f},c.getDataArray=function(a){for(var b=[],c=0;c<a.series.length;c++)b[c]="object"==typeof a.series[c]&&void 0!==a.series[c].data?a.series[c].data:a.series[c];return b},c.normalizeDataArray=function(a,b){for(var c=0;c<a.length;c++)if(a[c].length!==b)for(var d=a[c].length;b>d;d++)a[c][d]=0;return a},c.orderOfMagnitude=function(a){return Math.floor(Math.log(Math.abs(a))/Math.LN10)},c.projectLength=function(a,b,d,e){var f=c.getAvailableHeight(a,e);return b/d.range*f},c.getAvailableHeight=function(a,b){return c.getHeight(a._node)-2*b.chartPadding-b.axisX.offset},c.getHighLow=function(a){var b,c,d={high:-Number.MAX_VALUE,low:Number.MAX_VALUE};for(b=0;b<a.length;b++)for(c=0;c<a[b].length;c++)a[b][c]>d.high&&(d.high=a[b][c]),a[b][c]<d.low&&(d.low=a[b][c]);return d},c.getBounds=function(a,b,d,e){var f,g,h,i=c.getHighLow(b);for(i.high=d.high||(0===d.high?0:i.high),i.low=d.low||(0===d.low?0:i.low),i.high===i.low&&(0===i.low?i.high=1:i.low<0?i.high=0:i.low=0),(e||0===e)&&(i.high=Math.max(e,i.high),i.low=Math.min(e,i.low)),i.valueRange=i.high-i.low,i.oom=c.orderOfMagnitude(i.valueRange),i.min=Math.floor(i.low/Math.pow(10,i.oom))*Math.pow(10,i.oom),i.max=Math.ceil(i.high/Math.pow(10,i.oom))*Math.pow(10,i.oom),i.range=i.max-i.min,i.step=Math.pow(10,i.oom),i.numberOfSteps=Math.round(i.range/i.step);;){var j=c.projectLength(a,i.step/2,i,d);if(!(j>=d.axisY.scaleMinSpace))break;i.step/=2}for(g=i.min,h=i.max,f=i.min;f<=i.max;f+=i.step)f+i.step<i.low&&(g+=i.step),f-i.step>i.high&&(h-=i.step);for(i.min=g,i.max=h,i.range=i.max-i.min,i.values=[],f=i.min;f<=i.max;f+=i.step)i.values.push(f);return i},c.calculateLabelOffset=function(a,b,c,d,e){for(var f=0,g=0;g<b.length;g++){var h=d(b[g],g);if(h||0===h){var i=a.elem("text",{dx:0,dy:0},c).text(""+h);f=Math.max(f,e(i._node)),i.remove()}}return f},c.polarToCartesian=function(a,b,c,d){var e=(d-90)*Math.PI/180;return{x:a+c*Math.cos(e),y:b+c*Math.sin(e)}},c.createChartRect=function(a,b,d,e){return{x1:b.chartPadding+e,y1:(b.height||c.getHeight(a._node))-b.chartPadding-d,x2:(b.width||c.getWidth(a._node))-b.chartPadding,y2:b.chartPadding,width:function(){return this.x2-this.x1},height:function(){return this.y1-this.y2}}},c.createXAxis=function(a,b,d,e,f){b.labels.forEach(function(g,h){var i=f.axisX.labelInterpolationFnc(g,h),j=a.x1+a.width()/b.labels.length*h;if((i||0===i)&&(f.axisX.showGrid&&d.elem("line",{x1:j,y1:a.y1,x2:j,y2:a.y2},[f.classNames.grid,f.classNames.horizontal].join(" ")),f.axisX.showLabel)){var k=e.elem("text",{dx:j+2},[f.classNames.label,f.classNames.horizontal].join(" ")).text(""+i);k.attr({dy:a.y1+c.getHeight(k._node)+f.axisX.offset})}})},c.createYAxis=function(a,b,c,d,e,f){b.values.forEach(function(g,h){var i=f.axisY.labelInterpolationFnc(g,h),j=a.y1-a.height()/b.values.length*h;(i||0===i)&&(f.axisY.showGrid&&c.elem("line",{x1:a.x1,y1:j,x2:a.x2,y2:j},[f.classNames.grid,f.classNames.vertical].join(" ")),f.axisY.showLabel&&d.elem("text",{dx:"right"===f.axisY.labelAlign?e-f.axisY.offset+f.chartPadding:f.chartPadding,dy:j-2,"text-anchor":"right"===f.axisY.labelAlign?"end":"start"},[f.classNames.label,f.classNames.vertical].join(" ")).text(""+i))})},c.projectPoint=function(a,b,c,d){return{x:a.x1+a.width()/c.length*d,y:a.y1-a.height()*(c[d]-b.min)/(b.range+b.step)}},c.optionsProvider=function(b,d,e){function f(){if(h=c.extend({},j),e)for(i=0;i<e.length;i++){var b=a.matchMedia(e[i][0]);b.matches&&(h=c.extend(h,e[i][1]))}}function g(){k.forEach(function(a){a.removeListener(f)})}var h,i,j=c.extend(c.extend({},b),d),k=[],l=[];if(!a.matchMedia)throw"window.matchMedia not found! Make sure you're using a polyfill.";if(e)for(i=0;i<e.length;i++){var m=a.matchMedia(e[i][0]);m.addListener(f),k.push(m)}return f(),{get currentOptions(){return c.extend({},h)},addOptionsListener:function(a){l.push(a)},removeOptionsListener:function(a){l.splice(l.indexOf(a),1)},clear:function(){l=[],g()}}},c.catmullRom2bezier=function(a,b){for(var c=[],d=0,e=a.length;e-2*!b>d;d+=2){var f=[{x:+a[d-2],y:+a[d-1]},{x:+a[d],y:+a[d+1]},{x:+a[d+2],y:+a[d+3]},{x:+a[d+4],y:+a[d+5]}];b?d?e-4===d?f[3]={x:+a[0],y:+a[1]}:e-2===d&&(f[2]={x:+a[0],y:+a[1]},f[3]={x:+a[2],y:+a[3]}):f[0]={x:+a[e-2],y:+a[e-1]}:e-4===d?f[3]=f[2]:d||(f[0]={x:+a[d],y:+a[d+1]}),c.push([(-f[0].x+6*f[1].x+f[2].x)/6,(-f[0].y+6*f[1].y+f[2].y)/6,(f[1].x+6*f[2].x-f[3].x)/6,(f[1].y+6*f[2].y-f[3].y)/6,f[2].x,f[2].y])}return c}}(window,document,a),function(a,b,c){"use strict";c.xmlNs={qualifiedName:"xmlns:ct",prefix:"ct",uri:"http://gionkunz.github.com/chartist-js/ct"},c.svg=function(a,d,e,f,g){function h(a,b,d){return Object.keys(b).forEach(function(e){d?a.setAttributeNS(d,[c.xmlNs.prefix,":",e].join(""),b[e]):a.setAttribute(e,b[e])}),a}function i(a,d,e,f,g,i){var j=b.createElementNS(q,d);return"svg"===d&&j.setAttributeNS(r,c.xmlNs.qualifiedName,c.xmlNs.uri),i&&(g&&i.firstChild?i.insertBefore(j,i.firstChild):i.appendChild(j)),e&&h(j,e),f&&n(j,f),j}function j(a,c){a.appendChild(b.createTextNode(c))}function k(a){for(;a.firstChild;)a.removeChild(a.firstChild)}function l(a){a.parentNode.removeChild(a)}function m(a){return a.getAttribute("class")?a.getAttribute("class").trim().split(/\s+/):[]}function n(a,b){a.setAttribute("class",m(a).concat(b.trim().split(/\s+/)).filter(function(a,b,c){return c.indexOf(a)===b}).join(" "))}function o(a,b){var c=b.trim().split(/\s+/);a.setAttribute("class",m(a).filter(function(a){return-1===c.indexOf(a)}).join(" "))}function p(a){a.setAttribute("class","")}var q="http://www.w3.org/2000/svg",r="http://www.w3.org/2000/xmlns/";return{_node:i(this,a,d,e,f,g?g._node:void 0),_parent:g,parent:function(){return this._parent},attr:function(a,b){return h(this._node,a,b),this},empty:function(){return k(this._node),this},remove:function(){return l(this._node),this},elem:function(a,b,d,e){return c.svg(a,b,d,e,this)},text:function(a){return j(this._node,a),this},addClass:function(a){return n(this._node,a),this},removeClass:function(a){return o(this._node,a),this},removeAllClasses:function(){return p(this._node),this},classes:function(){return m(this._node)}}}}(window,document,a),function(a,b,c){"use strict";c.Line=function(b,d,e,f){function g(a){var b,e,f,g=[],h=c.normalizeDataArray(c.getDataArray(d),d.labels.length);n=c.createSvg(p,a.width,a.height,a.classNames.chart),f=c.getBounds(n,h,a),b=a.axisX.offset,a.axisX.showLabel&&(b+=c.calculateLabelOffset(n,d.labels,[a.classNames.label,a.classNames.horizontal].join(" "),a.axisX.labelInterpolationFnc,c.getHeight)),e=a.axisY.offset,a.axisY.showLabel&&(e+=c.calculateLabelOffset(n,f.values,[a.classNames.label,a.classNames.horizontal].join(" "),a.axisY.labelInterpolationFnc,c.getWidth));var i=c.createChartRect(n,a,b,e),j=n.elem("g"),k=n.elem("g");c.createXAxis(i,d,k,j,a),c.createYAxis(i,f,k,j,e,a);for(var l=0;l<d.series.length;l++){g[l]=n.elem("g"),d.series[l].name&&g[l].attr({"series-name":d.series[l].name},c.xmlNs.uri),g[l].addClass([a.classNames.series,d.series[l].className||a.classNames.series+"-"+c.alphaNumerate(l)].join(" "));for(var m,o,q=[],r=0;r<h[l].length;r++)m=c.projectPoint(i,f,h[l],r),q.push(m.x,m.y),a.showPoint&&(o=g[l].elem("line",{x1:m.x,y1:m.y,x2:m.x+.01,y2:m.y},a.classNames.point).attr({value:h[l][r]},c.xmlNs.uri));if(a.showLine||a.showArea){var s=["M"+q[0]+","+q[1]];if(a.lineSmooth&&q.length>4)for(var t=c.catmullRom2bezier(q),u=0;u<t.length;u++)s.push("C"+t[u].join());else for(var v=3;v<q.length;v+=2)s.push("L"+q[v-1]+","+q[v]);if(a.showArea){var w=s.slice(),x=c.projectPoint(i,f,[a.areaBase],0);w.splice(0,0,"M"+x.x+","+x.y),w[1]="L"+q[0]+","+q[1],w.push("L"+q[q.length-2]+","+x.y),g[l].elem("path",{d:w.join("")},a.classNames.area,!0).attr({values:h[l]},c.xmlNs.uri)}a.showLine&&g[l].elem("path",{d:s.join("")},a.classNames.line,!0).attr({values:h[l]},c.xmlNs.uri)}}}function h(){g(m.currentOptions)}function i(){a.removeEventListener("resize",h),m.clear()}function j(a){m.addOptionsListener(a)}function k(a){m.removeOptionsListener(a)}function l(){g(m.currentOptions)}var m,n,o={axisX:{offset:10,showLabel:!0,showGrid:!0,labelInterpolationFnc:c.noop},axisY:{offset:15,showLabel:!0,showGrid:!0,labelAlign:"right",labelInterpolationFnc:c.noop,scaleMinSpace:30},width:void 0,height:void 0,showLine:!0,showPoint:!0,showArea:!1,areaBase:0,lineSmooth:!0,low:void 0,high:void 0,chartPadding:5,classNames:{chart:"ct-chart-line",label:"ct-label",series:"ct-series",line:"ct-line",point:"ct-point",area:"ct-area",grid:"ct-grid",vertical:"ct-vertical",horizontal:"ct-horizontal"}},p=c.querySelector(b);p.chartist&&p.chartist.detach(),m=c.optionsProvider(o,e,f),g(m.currentOptions),a.addEventListener("resize",l);var q={version:c.version,update:h,detach:i,addOptionsListener:j,removeOptionsListener:k};return p.chartist=q,q}}(window,document,a),function(a,b,c){"use strict";c.Bar=function(b,d,e,f){function g(a){var b,e,f,g=[],h=c.normalizeDataArray(c.getDataArray(d),d.labels.length);m=c.createSvg(o,a.width,a.height,a.classNames.chart),f=c.getBounds(m,h,a,0),b=a.axisX.offset,a.axisX.showLabel&&(b+=c.calculateLabelOffset(m,d.labels,[a.classNames.label,a.classNames.horizontal].join(" "),a.axisX.labelInterpolationFnc,c.getHeight)),e=a.axisY.offset,a.axisY.showLabel&&(e+=c.calculateLabelOffset(m,f.values,[a.classNames.label,a.classNames.horizontal].join(" "),a.axisY.labelInterpolationFnc,c.getWidth));var i=c.createChartRect(m,a,b,e),j=m.elem("g"),k=m.elem("g"),l=c.projectPoint(i,f,[0],0);c.createXAxis(i,d,k,j,a),c.createYAxis(i,f,k,j,e,a);for(var n=0;n<d.series.length;n++){var p=n-(d.series.length-1)/2,q=i.width()/h[n].length/2;g[n]=m.elem("g"),d.series[n].name&&g[n].attr({"series-name":d.series[n].name},c.xmlNs.uri),g[n].addClass([a.classNames.series,d.series[n].className||a.classNames.series+"-"+c.alphaNumerate(n)].join(" "));for(var r=0;r<h[n].length;r++){var s,t=c.projectPoint(i,f,h[n],r);t.x+=q+p*a.seriesBarDistance,s=g[n].elem("line",{x1:t.x,y1:l.y,x2:t.x,y2:t.y},a.classNames.bar).attr({value:h[n][r]},c.xmlNs.uri)}}}function h(){g(l.currentOptions)}function i(){a.removeEventListener("resize",h),l.clear()}function j(a){l.addOptionsListener(a)}function k(a){l.removeOptionsListener(a)}var l,m,n={axisX:{offset:10,showLabel:!0,showGrid:!0,labelInterpolationFnc:c.noop},axisY:{offset:15,showLabel:!0,showGrid:!0,labelAlign:"right",labelInterpolationFnc:c.noop,scaleMinSpace:40},width:void 0,height:void 0,high:void 0,low:void 0,chartPadding:5,seriesBarDistance:15,classNames:{chart:"ct-chart-bar",label:"ct-label",series:"ct-series",bar:"ct-bar",thin:"ct-thin",thick:"ct-thick",grid:"ct-grid",vertical:"ct-vertical",horizontal:"ct-horizontal"}},o=c.querySelector(b);o.chartist&&o.chartist.detach(),l=c.optionsProvider(n,e,f),g(l.currentOptions),a.addEventListener("resize",h);var p={version:c.version,update:h,detach:i,addOptionsListener:j,removeOptionsListener:k};return o.chartist=p,p}}(window,document,a),function(a,b,c){"use strict";c.Pie=function(b,d,e,f){function g(a,b,c){var d=b.x>a.x;return d&&"explode"===c||!d&&"implode"===c?"start":d&&"implode"===c||!d&&"explode"===c?"end":"middle"}function h(a){var b,e,f,h,i=[],j=a.startAngle,k=c.getDataArray(d);o=c.createSvg(q,a.width,a.height,a.classNames.chart),b=c.createChartRect(o,a,0,0),e=Math.min(b.width()/2,b.height()/2),h=a.total||k.reduce(function(a,b){return a+b},0),e-=a.donut?a.donutWidth/2:0,f=a.donut?e:e/2,f+=a.labelOffset;for(var l={x:b.x1+b.width()/2,y:b.y2+b.height()/2},m=0;m<d.series.length;m++){i[m]=o.elem("g",null,null,!0),d.series[m].name&&i[m].attr({"series-name":d.series[m].name},c.xmlNs.uri),i[m].addClass([a.classNames.series,d.series[m].className||a.classNames.series+"-"+c.alphaNumerate(m)].join(" "));var n=j+k[m]/h*360;n-j===360&&(n-=.01);var p=c.polarToCartesian(l.x,l.y,e,j-(0===m?0:.2)),r=c.polarToCartesian(l.x,l.y,e,n),s=180>=n-j?"0":"1",t=["M",r.x,r.y,"A",e,e,0,s,0,p.x,p.y];a.donut===!1&&t.push("L",l.x,l.y);var u=i[m].elem("path",{d:t.join(" ")},a.classNames.slice+(a.donut?" "+a.classNames.donut:""));if(u.attr({value:k[m]},c.xmlNs.uri),a.donut===!0&&u.attr({style:"stroke-width: "+ +a.donutWidth+"px"}),a.showLabel){var v=c.polarToCartesian(l.x,l.y,f,j+(n-j)/2),w=a.labelInterpolationFnc(d.labels?d.labels[m]:k[m],m);i[m].elem("text",{dx:v.x,dy:v.y,"text-anchor":g(l,v,a.labelDirection)},a.classNames.label).text(""+w)}j=n}}function i(){h(n.currentOptions)}function j(){a.removeEventListener("resize",i),n.clear()}function k(a){n.addOptionsListener(a)}function l(a){n.removeOptionsListener(a)}function m(){h(n.currentOptions)}var n,o,p={width:void 0,height:void 0,chartPadding:5,classNames:{chart:"ct-chart-pie",series:"ct-series",slice:"ct-slice",donut:"ct-donut",label:"ct-label"},startAngle:0,total:void 0,donut:!1,donutWidth:60,showLabel:!0,labelOffset:0,labelInterpolationFnc:c.noop,labelOverflow:!1,labelDirection:"neutral"},q=c.querySelector(b);q.chartist&&q.chartist.detach(),n=c.optionsProvider(p,e,f),h(n.currentOptions),a.addEventListener("resize",m);var r={version:c.version,update:i,detach:j,addOptionsListener:k,removeOptionsListener:l};return q.chartist=r,r}}(window,document,a),a});
//# sourceMappingURL=chartist.min.map